import unittest

from learnsprout.errors import LearnSproutClientException
from learnsprout.client import LearnSproutClient
from learnsprout.resources import Organization
from learnsprout.tests import sample_org_id

class TestOrganizations(unittest.TestCase):
  def setUp(self):
    """ Set up for organization tests. Create a client to use """
    self.lsc = LearnSproutClient()

  def ensure_members(self, student):
    self.assertTrue(hasattr(student, "ls_id"))
    self.assertTrue(hasattr(student, "name"))

  def test_list_organizations(self):
    """ List some organizations """
    orgs = self.lsc.orgs.iter_all()
    for count, org in enumerate(orgs, 1):
      self.ensure_members(org)
    self.assertGreater(count, 0)
'''
  def test_get_org_by_id(self):
    """ Get an individual organization by its id """
    org = self.lsc.orgs.get(sample_org_id)
    self.assertIsInstance(org, Organization)
    self.ensure_members(org)

  def test_get_org_bad_id(self):
    """ Get an individual organization with an id that does not exist """
    self.assertRaises(LearnSproutClientException, self.lsc.orgs.get, sample_org_id)
'''
if __name__ == '__main__':
  unittest.main()
