import unittest

from learnsprout.resources import resource

class FakeIterableResult(object):

  def __init__(self, owning_client, instance_from_json, uri, params):
    self.params = params

resource.IterableResult = FakeIterableResult

class TestIterAll(resource.ResourceCollection):
  owning_client = instance_from_json = uri = 1

  def __init__(self):
    pass

class TestResource(unittest.TestCase):

  def test_iter_all(self):
    """ Ensure iter_all functionality """
    client = TestIterAll()

    result = client.iter_all(params={'foo': 1})
    self.assertIn('foo', result.params)
    self.assertEqual(result.params['foo'], 1)

    result2 = client.iter_all(params={'foo': 1, 'bar': 2})
    self.assertIn('foo', result2.params)
    self.assertIn('bar', result2.params)
    self.assertEquals(result2.params['foo'], 1)
    self.assertEquals(result2.params['bar'], 2)

    result3 = client.iter_all(since=3)
    self.assertIn('since', result3.params)
    self.assertEquals(result3.params['since'], 3)

if __name__ == '__main__':
  unittest.main()
