from lemon.bundles import Bundle, Url
from lemon.views import ArchiveView, DayView, MonthView, YearView, ArchiveDetailView


class DateBasedBundle(Bundle):

    archive_view = ArchiveView
    year_view = YearView
    month_view = MonthView
    day_view = DayView
    detail_view = ArchiveDetailView

    archive = Url(r'^$', 'archive_view')
    year = Url(r'^(\d{4})$', 'year_view')
    month = Url(r'^(\d{4})-(\d{2})$', 'month_view')
    day = Url(r'^(\d{4})-(\d{2})-(\d{2})$', 'day_view')
    detail = Url(r'^(\d{4})-(\d{2})-(\d{2})/(\d+)$', 'detail_view')

    def __init__(self, *args, **kwargs):
        model = self._meta.get('model')
        date_field = self._meta.get('date_field')
        if model and date_field:
            mixins = self._meta.get('mixins')
            for name in 'archive year month day detail'.split():
                view = getattr(self, '%s_view' % name)
                if not getattr(view, 'model', None):
                    setattr(self, '%s_view' % name, view.factory(
                        model=model, mixins=mixins, date_field=date_field))
        super(DateBasedBundle, self).__init__(*args, **kwargs)