from django.conf.urls.defaults import patterns, url

from lemon.bundles.base import Bundle
from lemon.bundles.urls import Url
from lemon.views import DetailView, ListView


class ListDetailBundle(Bundle):

    list_view = ListView
    detail_view = DetailView

    list_ = Url(r'^$', 'list_view')
    detail = Url(r'^(\d+)$', 'detail_view')

    def __init__(self, *args, **kwargs):
        model = self._meta.get('model')
        if model:
            mixins = self._meta.get('mixins')
            if not getattr(self.list_view, 'model', None):
                self.list_view = self.list_view.factory(
                    model=model, mixins=mixins)
            if not getattr(self.detail_view, 'model', None):
                self.detail_view = self.detail_view.factory(
                    model=model, mixins=mixins)
        super(ListDetailBundle, self).__init__(*args, **kwargs)