from django.conf.urls.defaults import patterns, url, include
from django.contrib.admin import sites

from lemon.contrib.extradmin import widgets, ModelAdmin
from lemon.contrib.filebrowser.sites import FileBrowserSite
from lemon.db.models import MarkupField


class AdminSite(sites.AdminSite):

    def __init__(self, name=None, app_name='admin'):
        super(AdminSite, self).__init__(name, app_name)
        self.file_browser_site = FileBrowserSite(self)

    def get_urls(self):
        urls = super(AdminSite, self).get_urls()
        return patterns(
            '',
            url(r'^filebrowser/', include(self.file_browser_site.urls)),
        ) + urls

    def register(self, model_or_iterable, admin_class=None, **options):
        if not admin_class:
            admin_class = ModelAdmin
        super(AdminSite, self).register(
            model_or_iterable, admin_class, **options)

    def _formfield_overrides(self):
        return {MarkupField: {
            'widget': widgets.AdminTinyMCE(self.file_browser_site)}}
    formfield_overrides = property(_formfield_overrides)


site = AdminSite()
