# -*- coding: utf-8 -*-

from django.conf import settings
from django.contrib.contenttypes.models import ContentType
from django.core.management.base import NoArgsCommand

from lemon.contrib import metatags
from lemon.contrib.metatags.models import MetaTags


class Command(NoArgsCommand):

    help = 'Sync metatags with all registered models'

    def handle_noargs(self, **options):
        print 'Starting metatags synchronisation with all registered models.'
        metatags.autodiscover()
        for model, model_meta_tags in metatags.site._registry.items():
            print 'Syncing %s.%s model.' % (model._meta.app_label, model.__name__)
            self.sync_meta_tags(model, model_meta_tags)
        print 'All objects with `get_absolute_url` method was synced.',
        print 'Removing orphaned metatags.'
        self.remove_orphaned()
        print 'Done.'

    def sync_meta_tags(self, model, model_meta_tags):
        for obj in model.objects.all():
            try:
                meta_tags = MetaTags.objects.get_for_content_object(obj)
            except MetaTags.DoesNotExist:
                pass
            else:
                meta_tags.update_url()
                meta_tags.update_sites()
                sites = ', '.join([s.domain for s in meta_tags.sites.all()])
                print '  Metatags for %s (%s) was updated.' % (meta_tags.url, sites)

    def remove_orphaned(self):
        for meta_tags in MetaTags.objects.all():
            if meta_tags.content_type and meta_tags.object_id:
                if not meta_tags.content_object:
                    sites = ', '.join([s.domain for s in meta_tags.sites.all()])
                    print '  Metatags for %s (%s) was deleted.' % (meta_tags.url, sites)
                    meta_tags.delete()