# encoding: utf-8

import datetime

from south.db import db
from south.v2 import SchemaMigration

from django.db import models


class Migration(SchemaMigration):
    
    def forwards(self, orm):
        
        # Adding model 'MetaTags'
        db.create_table('metatags_metatags', (
            ('description', self.gf(
                'django.db.models.fields.TextField')(blank=True)),
            ('title', self.gf(
                'django.db.models.fields.CharField')(
                    max_length=255, blank=True)),
            ('url', self.gf(
                'django.db.models.fields.CharField')(
                    unique=True, max_length=255)),
            ('enabled', self.gf(
                'django.db.models.fields.BooleanField')(
                    default=False, blank=True)),
            ('object_id', self.gf(
                'django.db.models.fields.PositiveIntegerField')(
                    null=True)),
            ('id', self.gf(
                'django.db.models.fields.AutoField')(primary_key=True)),
            ('content_type', self.gf(
                'django.db.models.fields.related.ForeignKey')(
                    to=orm['contenttypes.ContentType'], null=True)),
            ('keywords', self.gf(
                'django.db.models.fields.TextField')(blank=True)),
            ('title_extend', self.gf(
                'django.db.models.fields.BooleanField')(
                    default=True, blank=True)),
        ))
        db.send_create_signal('metatags', ['MetaTags'])
    
    def backwards(self, orm):
        
        # Deleting model 'MetaTags'
        db.delete_table('metatags_metatags')
    
    models = {
        'contenttypes.contenttype': {
            'Meta': {
                'unique_together': "(('app_label', 'model'),)",
                'object_name': 'ContentType',
                'db_table': "'django_content_type'"},
            'app_label': (
                'django.db.models.fields.CharField', [],
                {'max_length': '100'}),
            'id': (
                'django.db.models.fields.AutoField', [],
                {'primary_key': 'True'}),
            'model': (
                'django.db.models.fields.CharField', [],
                {'max_length': '100'}),
            'name': (
                'django.db.models.fields.CharField', [],
                {'max_length': '100'})
        },
        'metatags.metatags': {
            'Meta': {'object_name': 'MetaTags'},
            'content_type': (
                'django.db.models.fields.related.ForeignKey', [],
                {'to': "orm['contenttypes.ContentType']", 'null': 'True'}),
            'description': (
                'django.db.models.fields.TextField', [],
                {'blank': 'True'}),
            'enabled': (
                'django.db.models.fields.BooleanField', [],
                {'default': 'False', 'blank': 'True'}),
            'id': (
                'django.db.models.fields.AutoField', [],
                {'primary_key': 'True'}),
            'keywords': (
                'django.db.models.fields.TextField', [],
                {'blank': 'True'}),
            'object_id': (
                'django.db.models.fields.PositiveIntegerField', [],
                {'null': 'True'}),
            'title': (
                'django.db.models.fields.CharField', [],
                {'max_length': '255', 'blank': 'True'}),
            'title_extend': (
                'django.db.models.fields.BooleanField', [],
                {'default': 'True', 'blank': 'True'}),
            'url': (
                'django.db.models.fields.CharField', [],
                {'unique': 'True', 'max_length': '255'})
        }
    }
    
    complete_apps = ['metatags']
