from django import forms
from django.utils.translation import ugettext_lazy as _

from lemon.contrib.pages.models import Page
from lemon.contrib.pages.widgets import SelectPageTemplate


class PageAdminForm(forms.ModelForm):

    template = forms.CharField(label=_('Template'), max_length=255,
                               error_messages={'required': _('Please create template for pages')},
                               widget=SelectPageTemplate())

    class Meta:
        model = Page