# encoding: utf-8

import datetime

from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):
    
    def forwards(self, orm):
        
        # Adding model 'Page'
        db.create_table('pages_page', (
            ('author', self.gf(
                'django.db.models.fields.related.ForeignKey')(
                    to=orm['auth.User'], null=True)),
            ('publication_start_date', self.gf(
                'django.db.models.fields.DateTimeField')(
                    default=datetime.datetime.now, db_index=True)),
            ('title', self.gf(
                'django.db.models.fields.CharField')(max_length=255)),
            ('enabled', self.gf(
                'django.db.models.fields.BooleanField')(
                    default=True, db_index=True, blank=True)),
            ('site', self.gf(
                'django.db.models.fields.related.ForeignKey')(
                    to=orm['sites.Site'])),
            ('id', self.gf(
                'django.db.models.fields.AutoField')(primary_key=True)),
            ('publication_end_date', self.gf(
                'django.db.models.fields.DateTimeField')(
                    db_index=True, null=True, blank=True)),
            ('template', self.gf(
                'django.db.models.fields.CharField')(max_length=255)),
            ('slug', self.gf(
                'lemon.contrib.pages.models.URLPathField')(blank=True)),
            ('contents', self.gf(
                'lemon.db.models.fields.MarkupField')()),
        ))
        db.send_create_signal('pages', ['Page'])

        # Adding unique constraint on 'Page', fields ['slug', 'site']
        db.create_unique('pages_page', ['slug', 'site_id'])
    
    def backwards(self, orm):
        
        # Deleting model 'Page'
        db.delete_table('pages_page')

        # Removing unique constraint on 'Page', fields ['slug', 'site']
        db.delete_unique('pages_page', ['slug', 'site_id'])
    
    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': (
                'django.db.models.fields.AutoField', [],
                {'primary_key': 'True'}),
            'name': (
                'django.db.models.fields.CharField', [],
                {'unique': 'True', 'max_length': '80'}),
            'permissions': (
                'django.db.models.fields.related.ManyToManyField', [],
                {'to': "orm['auth.Permission']", 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {
                'unique_together': "(('content_type', 'codename'),)",
                'object_name': 'Permission'},
            'codename': (
                'django.db.models.fields.CharField', [],
                {'max_length': '100'}),
            'content_type': (
                'django.db.models.fields.related.ForeignKey', [],
                {'to': "orm['contenttypes.ContentType']"}),
            'id': (
                'django.db.models.fields.AutoField', [],
                {'primary_key': 'True'}),
            'name': (
                'django.db.models.fields.CharField', [],
                {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': (
                'django.db.models.fields.DateTimeField', [],
                {'default': 'datetime.datetime.now'}),
            'email': (
                'django.db.models.fields.EmailField', [],
                {'max_length': '75', 'blank': 'True'}),
            'first_name': (
                'django.db.models.fields.CharField', [],
                {'max_length': '30', 'blank': 'True'}),
            'groups': (
                'django.db.models.fields.related.ManyToManyField', [],
                {'to': "orm['auth.Group']", 'blank': 'True'}),
            'id': (
                'django.db.models.fields.AutoField', [],
                {'primary_key': 'True'}),
            'is_active': (
                'django.db.models.fields.BooleanField', [],
                {'default': 'True', 'blank': 'True'}),
            'is_staff': (
                'django.db.models.fields.BooleanField', [],
                {'default': 'False', 'blank': 'True'}),
            'is_superuser': (
                'django.db.models.fields.BooleanField', [],
                {'default': 'False', 'blank': 'True'}),
            'last_login': (
                'django.db.models.fields.DateTimeField', [],
                {'default': 'datetime.datetime.now'}),
            'last_name': (
                'django.db.models.fields.CharField', [],
                {'max_length': '30', 'blank': 'True'}),
            'password': (
                'django.db.models.fields.CharField', [],
                {'max_length': '128'}),
            'user_permissions': (
                'django.db.models.fields.related.ManyToManyField', [],
                {'to': "orm['auth.Permission']", 'blank': 'True'}),
            'username': (
                'django.db.models.fields.CharField', [],
                {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {
                'unique_together': "(('app_label', 'model'),)",
                'object_name': 'ContentType',
                'db_table': "'django_content_type'"},
            'app_label': (
                'django.db.models.fields.CharField', [],
                {'max_length': '100'}),
            'id': (
                'django.db.models.fields.AutoField', [],
                {'primary_key': 'True'}),
            'model': (
                'django.db.models.fields.CharField', [],
                {'max_length': '100'}),
            'name': (
                'django.db.models.fields.CharField', [],
                {'max_length': '100'})
        },
        'pages.page': {
            'Meta': {
                'unique_together': "(('slug', 'site'),)",
                'object_name': 'Page'},
            'author': (
                'django.db.models.fields.related.ForeignKey', [],
                {'to': "orm['auth.User']", 'null': 'True'}),
            'contents': ('lemon.db.models.fields.MarkupField', [], {}),
            'enabled': (
                'django.db.models.fields.BooleanField', [],
                {'default': 'True', 'db_index': 'True', 'blank': 'True'}),
            'id': (
                'django.db.models.fields.AutoField', [],
                {'primary_key': 'True'}),
            'publication_end_date': (
                'django.db.models.fields.DateTimeField', [],
                {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'publication_start_date': (
                'django.db.models.fields.DateTimeField', [],
                {'default': 'datetime.datetime.now', 'db_index': 'True'}),
            'site': (
                'django.db.models.fields.related.ForeignKey', [],
                {'to': "orm['sites.Site']"}),
            'slug': (
                'lemon.contrib.pages.models.URLPathField', [],
                {'blank': 'True'}),
            'template': (
                'django.db.models.fields.CharField', [],
                {'max_length': '255'}),
            'title': (
                'django.db.models.fields.CharField', [],
                {'max_length': '255'})
        },
        'sites.site': {
            'Meta': {'object_name': 'Site', 'db_table': "'django_site'"},
            'domain': (
                'django.db.models.fields.CharField', [],
                {'max_length': '100'}),
            'id': (
                'django.db.models.fields.AutoField', [],
                {'primary_key': 'True'}),
            'name': (
                'django.db.models.fields.CharField', [],
                {'max_length': '50'})
        }
    }
    
    complete_apps = ['pages']
