from django.template import RequestContext
from django.shortcuts import get_object_or_404, render_to_response
from django.views.decorators.csrf import csrf_protect

from lemon.contrib.pages.models import Page


@csrf_protect
def page(request, slug):
    site = request.site
    qs = Page.objects.published().filter(site=site)
    page = get_object_or_404(qs, slug=slug)
    return render_to_response('pages/%s' % page.template, {'page': page},
                              context_instance=RequestContext(request))
