import os
from datetime import datetime, timedelta

from django.conf import settings
from django.test import TestCase

from lemon.contrib.publications.tests.models import Episode


class PublshedMixinTestCase(TestCase):

    fixtures = ['test_publications.json']
    urls = 'lemon.contrib.publications.tests.urls'

    def setUp(self):
        self.old_TEMPLATE_DIRS = settings.TEMPLATE_DIRS
        settings.TEMPLATE_DIRS = (
            os.path.join(os.path.dirname(__file__), 'templates'),)
        self.episode = Episode.objects.create(
            title='Unknown',
            publication_start_date=datetime.now() + timedelta(1)
        )

    def tearDown(self):
        settings.TEMPLATE_DIRS = self.old_TEMPLATE_DIRS

    def test_archive_view_response(self):
        response = self.client.get('/')
        self.assertEqual(response.status_code, 200)
        self.assertEqual(len(response.context['object_list']), 3)
        self.assertTrue(self.episode not in response.context['object_list'])

    def test_archive_detail_view_response(self):
        response = self.client.get('/3')
        self.assertEqual(response.status_code, 200)
        self.assertEqual(response.context['object'].pk, 3)

    def test_archive_detail_view_not_found(self):
        response = self.client.get('/%s' % self.episode.pk)
        self.assertEqual(response.status_code, 404)
