from django.db import models
from django.contrib.sites.models import Site
from django.contrib.sites.managers import CurrentSiteManager
from django.utils.translation import ugettext_lazy as _


class RobotsTxtFile(models.Model):

    site = models.OneToOneField(Site, verbose_name=_('site'))
    contents = models.TextField(_('file contents'))

    objects = models.Manager()

    class Meta:
        ordering = ['site__domain']
        verbose_name = _('robots.txt file')
        verbose_name_plural = _('robots.txt files')

    def __unicode__(self):
        return u'/'.join([self.site.domain, u'robots.txt'])
