from django.test import TestCase
from lemon.contrib.robots.models import RobotsTxtFile


class RobotsTxtViewTestCase(TestCase):

    fixtures = ['test_robots.json']
    urls = 'lemon.contrib.robots.tests.urls'

    def test_response(self):
        response = self.client.get('/robots.txt')
        self.assertEqual(response.status_code, 200)
        self.assertEqual(response.context.current_app, 'robots')

        robots_txt_file = response.context.get('object')
        self.assertTrue(isinstance(robots_txt_file, RobotsTxtFile))

    def test_filter_by_site(self):
        response = self.client.get('/robots.txt', HTTP_HOST='second.example.com')
        self.assertEqual(response.status_code, 200)

        robots_txt_file = response.context.get('object')
        self.assertEqual(robots_txt_file.contents, 'second.example.com')

    def test_default_template(self):
        response = self.client.get('/robots.txt', HTTP_HOST='third.example.com')
        self.assertEqual(response.status_code, 200)

        robots_txt_file = response.context.get('object')
        self.assertTrue(robots_txt_file is None)