from django import forms
from django.utils.translation import ugettext_lazy as _
from django.utils.translation import ungettext

from lemon.contrib import extradmin
from lemon.contrib.extradmin import generic
from lemon.contrib.sitemapsdb.models import SiteMapItem


class SiteMapItemForm(forms.ModelForm):

    def has_changed(self):
        return True


class SiteMapItemInline(generic.GenericStackedInline):

    form = SiteMapItemForm
    model = SiteMapItem
    exclude = ('url', 'sites')
    extra = 1
    max_num = 1


class SiteMapItemAdmin(extradmin.ModelAdmin):

    list_display = ('url', 'changefreq', 'enabled')
    string_overrides = {
        'add_title': _(u'Add sitemap.xml item'),
        'change_title': _(u'Change sitemap.xml item'),
        'changelist_title': _(u'Choose sitemap.xml item to change'),
        'changelist_popup_title': _(u'Choose sitemap.xml item'),
        'changelist_addlink_title': _(u'Add sitemap.xml item'),
        'changelist_paginator_description': lambda n: \
            ungettext('%(count)d sitemap.xml item', '%(count)d sitemap.xml items', n)
    }


extradmin.site.register(SiteMapItem, SiteMapItemAdmin)