# -*- coding: utf-8 -*-

from django.conf import settings
from django.contrib.contenttypes.models import ContentType
from django.core.management.base import NoArgsCommand

from lemon.contrib import sitemapsdb
from lemon.contrib.sitemapsdb.models import SiteMapItem


class Command(NoArgsCommand):

    help = 'Sync sitemapsdb with all registered models'

    def handle_noargs(self, **options):
        print 'Starting sitemap.xml synchronization with all registered models.'
        sitemapsdb.autodiscover()
        for model, model_site_map in sitemapsdb.site._registry.items():
            print 'Syncing %s.%s model.' % (model._meta.app_label, model.__name__)
            self.sync_site_map_items(model, model_site_map)
        print 'All objects with `get_absolute_url` method was synced.',
        print 'Removing orphaned sitemap.xml items.'
        self.remove_orphaned()
        print 'Done.'

    def sync_site_map_items(self, model, model_site_map):
        for obj in model.objects.all():
            try:
                site_map_item = SiteMapItem.objects.get_for_content_object(obj)
            except SiteMapItem.DoesNotExist:
                if model_site_map.url(obj):
                    site_map_item = SiteMapItem(content_object=obj)
                    site_map_item.save()
                    sites = ', '.join([s.domain for s in site_map_item.sites.all()])
                    print '  sitemap.xml item for %s (%s) was created.' % (site_map_item.url, sites)
            else:
                site_map_item.update_url()
                site_map_item.update_sites()
                sites = ', '.join([s.domain for s in site_map_item.sites.all()])
                print '  sitemap.xml item for %s (%s) was updated.' % (site_map_item.url, sites)

    def remove_orphaned(self):
        for site_map_item in SiteMapItem.objects.all():
            if site_map_item.content_type and site_map_item.object_id:
                if not site_map_item.content_object:
                    sites = ', '.join([s.domain for s in site_map_item.sites.all()])
                    print '  sitemap.xml item for %s (%s) deleted.' % (site_map_item.url, sites)
                    site_map_item.delete()
