# encoding: utf-8

import datetime

from south.db import db
from south.v2 import SchemaMigration

from django.db import models


class Migration(SchemaMigration):
    
    def forwards(self, orm):
        
        # Adding model 'SiteMapItem'
        db.create_table('sitemapsdb_sitemapitem', (
            ('url', self.gf(
                'django.db.models.fields.CharField')(
                    unique=True, max_length=255)),
            ('enabled', self.gf(
                'django.db.models.fields.BooleanField')(
                    default=True, blank=True)),
            ('object_id', self.gf(
                'django.db.models.fields.PositiveIntegerField')(null=True)),
            ('priority', self.gf(
                'django.db.models.fields.FloatField')(
                    default=0.5, null=True, blank=True)),
            ('content_type', self.gf(
                'django.db.models.fields.related.ForeignKey')(
                    to=orm['contenttypes.ContentType'], null=True)),
            ('lastmod', self.gf(
                'django.db.models.fields.DateTimeField')(
                    default=datetime.datetime.now, null=True, blank=True)),
            ('changefreq', self.gf(
                'django.db.models.fields.CharField')(
                    default='M', max_length=1)),
            ('id', self.gf(
                'django.db.models.fields.AutoField')(primary_key=True)),
        ))
        db.send_create_signal('sitemapsdb', ['SiteMapItem'])
    
    def backwards(self, orm):
        
        # Deleting model 'SiteMapItem'
        db.delete_table('sitemapsdb_sitemapitem')
    
    models = {
        'contenttypes.contenttype': {
            'Meta': {
                'unique_together': "(('app_label', 'model'),)",
                'object_name': 'ContentType',
                'db_table': "'django_content_type'"},
            'app_label': (
                'django.db.models.fields.CharField', [],
                {'max_length': '100'}),
            'id': (
                'django.db.models.fields.AutoField', [],
                {'primary_key': 'True'}),
            'model': (
                'django.db.models.fields.CharField', [],
                {'max_length': '100'}),
            'name': (
                'django.db.models.fields.CharField', [],
                {'max_length': '100'})
        },
        'sitemapsdb.sitemapitem': {
            'Meta': {'object_name': 'SiteMapItem'},
            'changefreq': (
                'django.db.models.fields.CharField', [],
                {'default': "'M'", 'max_length': '1'}),
            'content_type': (
                'django.db.models.fields.related.ForeignKey', [],
                {'to': "orm['contenttypes.ContentType']", 'null': 'True'}),
            'enabled': (
                'django.db.models.fields.BooleanField', [],
                {'default': 'True', 'blank': 'True'}),
            'id': (
                'django.db.models.fields.AutoField', [],
                {'primary_key': 'True'}),
            'lastmod': (
                'django.db.models.fields.DateTimeField', [],
                {'default': 'datetime.datetime.now',
                 'null': 'True',
                 'blank': 'True'}),
            'object_id': (
                'django.db.models.fields.PositiveIntegerField', [],
                {'null': 'True'}),
            'priority': (
                'django.db.models.fields.FloatField', [],
                {'default': '0.5', 'null': 'True', 'blank': 'True'}),
            'url': (
                'django.db.models.fields.CharField', [],
                {'unique': 'True', 'max_length': '255'})
        }
    }
    
    complete_apps = ['sitemapsdb']
