# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models

class Migration(SchemaMigration):

    def forwards(self, orm):
        
        # Removing unique constraint on 'SiteMapItem', fields ['url']
        db.delete_unique('sitemapsdb_sitemapitem', ['url'])

        # Adding M2M table for field sites on 'SiteMapItem'
        db.create_table('sitemapsdb_sitemapitem_sites', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('sitemapitem', models.ForeignKey(orm['sitemapsdb.sitemapitem'], null=False)),
            ('site', models.ForeignKey(orm['sites.site'], null=False))
        ))
        db.create_unique('sitemapsdb_sitemapitem_sites', ['sitemapitem_id', 'site_id'])

        # Adding index on 'SiteMapItem', fields ['url']
        db.create_index('sitemapsdb_sitemapitem', ['url'])


    def backwards(self, orm):
        
        # Removing index on 'SiteMapItem', fields ['url']
        db.delete_index('sitemapsdb_sitemapitem', ['url'])

        # Removing M2M table for field sites on 'SiteMapItem'
        db.delete_table('sitemapsdb_sitemapitem_sites')

        # Adding unique constraint on 'SiteMapItem', fields ['url']
        db.create_unique('sitemapsdb_sitemapitem', ['url'])


    models = {
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'sitemapsdb.sitemapitem': {
            'Meta': {'object_name': 'SiteMapItem'},
            'changefreq': ('django.db.models.fields.CharField', [], {'default': "'M'", 'max_length': '1'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']", 'null': 'True'}),
            'enabled': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'lastmod': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'object_id': ('django.db.models.fields.PositiveIntegerField', [], {'null': 'True'}),
            'priority': ('django.db.models.fields.FloatField', [], {'default': '0.5', 'null': 'True', 'blank': 'True'}),
            'sites': ('django.db.models.fields.related.ManyToManyField', [], {'symmetrical': 'False', 'to': "orm['sites.Site']", 'null': 'True', 'blank': 'True'}),
            'url': ('django.db.models.fields.CharField', [], {'max_length': '255', 'db_index': 'True'})
        },
        'sites.site': {
            'Meta': {'ordering': "('domain',)", 'object_name': 'Site', 'db_table': "'django_site'"},
            'domain': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        }
    }

    complete_apps = ['sitemapsdb']
