from lemon.bundles import *
from lemon.tests.test_bundles.models import *
from lemon.views import *


class SimpleBundle(Bundle):

    index = Url(r'^$', View.factory(
        name='IndexView', template_name='test_bundles/index.html'))
    about = Url(r'^about$', View.factory(
        name='AboutView', template_name='test_bundles/about.html'))
    list_ = Url(r'^list$', View.factory(
        name='ListView', template_name='test_bundles/list.html'))

    class Meta:
        app_name = 'simple'
        some_option = 'some option'


class CustomBundle(SimpleBundle):

    contacts = Url(r'^contacts$', View.factory(
        name='ContactsView', template_name='test_bundles/contacts.html'))

    class Meta:
        app_name = 'custom'
        exclude = ['about']
        regexes = {
            'index': r'^index$',
            'list': r'^new-list$'
        }


class CharactersBundle(ListDetailBundle):

    class Meta:
        app_name = 'characters'
        model = Character


class EpisodesBundle(DateBasedBundle):

    class Meta:
        app_name = 'episodes'
        model = Episode
        date_field = 'publish_date'
