from datetime import datetime
from django.db import models


class Character(models.Model):

    name = models.CharField(max_length=100)
    planet = models.CharField(max_length=25, db_index=True)

    def __unicode__(self):
        return self.name


class Season(models.Model):

    slug = models.SlugField(unique=True)
    title = models.CharField(max_length=100)

    def __unicode__(self):
        return u'%s (%s)' % (self.title, self.slug)


class Episode(models.Model):

    title = models.CharField(max_length=100)
    publish_date = models.DateField(default=datetime.now)

    def __unicode__(self):
        return self.title