from django.conf.urls.defaults import *

from lemon.tests.test_views.models import *
from lemon.views import *


class EarthMixin(object):

    def get_queryset(self):
        return self.model.objects.filter(planet='Earth')


urlpatterns = patterns('',
    url(
        r'^view$',
        View.factory(
            name='TestView',
            template_name='test_views/view.html'
        ),
        {'current_app': 'test_views'}
    ),
    url(
        r'^view-without-current-app$',
        View.factory(
            name='TestView',
            template_name='test_views/view.html'
        )
    ),
    url(
        r'^detail-view/(\d+)$',
        DetailView.factory(model=Character),
        {'current_app': 'test_views'}
    ),
    url(
        r'^detail-view-with-template-object-name/(\d+)$',
        DetailView.factory(
            model=Character,
            template_object_name='character'
        ),
    ),
    url(
        r'^detail-view-with-template-name/(\d+)$',
        DetailView.factory(
            model=Character,
            template_name='test_views/detail_view.html'
        )
    ),
    url(
        r'^detail-view-allow-empty/(\d+)$',
        DetailView.factory(model=Character, allow_empty=True)
    ),
    url(
        r'^detail-view-with-slug/([-\w]+)$',
        DetailView.factory(model=Season, field='slug')
    ),
    url(
        r'^detail-view-with-mixin/(\d+)$',
        DetailView.factory(model=Character, mixins=[EarthMixin])
    ),
    url(
        r'^list-view$',
        ListView.factory(model=Character),
        {'current_app': 'test_views'}
    ),
    url(
        r'^list-view-with-template-list-name$',
        ListView.factory(
            model=Character,
            template_list_name='character_list'
        ),
    ),
    url(
        r'^list-view-with-template-name$',
        ListView.factory(
            model=Character,
            template_name='test_views/list_view.html'
        )
    ),
    url(
        r'^list-view-paginated$',
        ListView.factory(
            model=Character,
            paginate_by=2
        )
    ),
    url(
        r'^list-view-paginated-with-orphan$',
        ListView.factory(
            model=Character,
            paginate_by=2,
            orphans=1
        )
    ),
    url(
        r'^list-view-with-mixin$',
        ListView.factory(model=Character, mixins=[EarthMixin])
    ),
    url(
        r'^archive-view$',
        ArchiveView.factory(
            model=Episode,
            date_field='publish_date'
        ),
        {'current_app': 'test_views'}
    ),
    url(
        r'^year-view/(\d{4})$',
        YearView.factory(
            model=Episode,
            date_field='publish_date'
        ),
        {'current_app': 'test_views'}
    ),
    url(
        r'^month-view/(\d{4})-(\d{2})$',
        MonthView.factory(
            model=Episode,
            date_field='publish_date'
        ),
        {'current_app': 'test_views'}
    ),
    url(
        r'^day-view/(\d{4})-(\d{2})-(\d{2})$',
        DayView.factory(
            model=Episode,
            date_field='publish_date'
        ),
        {'current_app': 'test_views'}
    ),
    url(
        r'^archive-detail-view/(\d{4})-(\d{2})-(\d{2})/(\d+)',
        ArchiveDetailView.factory(
            model=Episode,
            date_field='publish_date'
        ),
        {'current_app': 'test_views'}
    )
)