from django.conf.urls.defaults import *


def date_based_urlpatterns(queryset, date_field, month_format='%m',
                           day_format='%d', name_prefix='',
                           date_separator='-', page_separator='/',
                           object_separator='/', paginate_by=None,
                           index_max_items=None, slug_field=None,
                           reverse_pages=True, allow_empty=True,
                           template_loader=None, extra_context=None,
                           context_processors=None, exclude=None,
                           template_object_name='object', mimetype=None,
                           current_app=None, current_app_field=None):
    if exclude is None:
        exclude = ['week', 'day', 'today']
    urls = []
    kwargs = {'queryset': queryset, 'date_field': date_field,
              'extra_context': extra_context,
              'context_processors': context_processors,
              'template_object_name': template_object_name,
              'mimetype': mimetype, 'current_app': current_app,
              'current_app_field': current_app_field}
    if template_loader:
        kwargs['template_loader'] = template_loader

    if 'index' not in exclude:
        kwargs_index = {'num_latest': index_max_items,
                        'allow_empty': allow_empty}
        kwargs_index.update(kwargs)
        urls.append(url(r'^$', 'archive_index', kwargs_index,
                        name='%sindex' % name_prefix))

    if 'year' not in exclude:
        kwargs_year = {'paginate_by': paginate_by,
                       'allow_empty': allow_empty,
                       'reverse_pages': reverse_pages}
        kwargs_year.update(kwargs)
        urls.append(url(r'^(?P<year>\d+)$', 'archive_year', kwargs_year,
                        name='%syear' % name_prefix))
        pattern = r'^(?P<year>\d+)%spage-(?P<page>\d+)$' % page_separator
        urls.append(url(pattern, 'archive_year', kwargs_year,
                        name='%syear' % name_prefix))

    if 'month' not in exclude:
        kwargs_month = {'month_format': month_format,
                        'paginate_by': paginate_by,
                        'allow_empty': allow_empty,
                        'reverse_pages': reverse_pages}
        kwargs_month.update(kwargs)
        pattern = r'^(?P<year>\d+)%s(?P<month>\d+)$' % date_separator
        urls.append(url(pattern, 'archive_month', kwargs_month,
                        name='%smonth' % name_prefix))
        pattern = pattern[:-1] + r'%spage-(?P<page>\d+)$' % page_separator
        urls.append(url(pattern, 'archive_month', kwargs_month,
                        name='%smonth' % name_prefix))

    if 'week' not in exclude:
        kwargs_week = {'paginate_by': paginate_by,
                       'allow_empty': allow_empty,
                       'reverse_pages': reverse_pages}
        kwargs_week.update(kwargs)
        pattern = r'^(?P<year>\d+)%s(?P<week>\d+)$' % date_separator
        urls.append(url(pattern, 'archive_week', kwargs_week,
                        name='%sweek' % name_prefix))
        pattern = pattern[:-1] + r'%spage-(?P<page>\d+)$' % page_separator
        urls.append(url(pattern, 'archive_week', kwargs_week,
                        name='%sweek' % name_prefix))

    if 'day' not in exclude:
        kwargs_day = {'month_format': month_format, 'day_format': day_format,
                      'paginate_by': paginate_by, 'allow_empty': allow_empty,
                      'reverse_pages': reverse_pages}
        kwargs_day.update(kwargs)
        pattern = r'^(?P<year>\d+)%s(?P<month>\d+)%s(?P<day>\d+)$'
        pattern %= (date_separator, date_separator)
        urls.append(url(pattern, 'archive_day', kwargs_day,
                        name='%sday' % name_prefix))
        pattern = pattern[:-1] + r'%spage-(?P<page>\d+)$' % page_separator
        urls.append(url(pattern, 'archive_day', kwargs_day,
                        name='%sday' % name_prefix))

    if 'today' not in exclude:
        kwargs_today = {'paginate_by': paginate_by,
                        'allow_empty': allow_empty,
                        'reverse_pages': reverse_pages}
        kwargs_today.update(kwargs)
        pattern = r'^today$'
        urls.append(url(pattern, 'archive_today', kwargs_today,
                        name='%stoday' % name_prefix))
        pattern = pattern[:-1] + r'%spage-(?P<page>\d+)$' % page_separator
        urls.append(url(pattern, 'archive_today', kwargs_today,
                        name='%stoday' % name_prefix))

    if 'detail' not in exclude:
        kwargs_detail = {'slug_field': slug_field} if slug_field else {}
        kwargs_detail.update(kwargs)
        pattern = r'^(?P<year>\d+)%s(?P<month>\d+)%s(?P<day>\d+)'
        pattern %= (date_separator, date_separator)
        if slug_field:
            pattern += r'%s(?P<slug>[-\w]+)$' % object_separator
        else:
            pattern += r'%s(?P<object_id>\d+)$' % object_separator
        urls.append(url(pattern, 'archive_detail', kwargs_detail,
                        name='%sdetail' % name_prefix))

    return patterns('lemon.views.generic.date_based', *urls)
