from django.conf.urls.defaults import *


def list_detail_urlpatterns(queryset, archive_prefix='archive/',
                            name_prefix='', paginate_by=None,
                            index_max_items=None, slug_field=None,
                            reverse_pages=True, allow_empty=True,
                            template_loader=None, extra_context=None,
                            context_processors=None, exclude=None,
                            template_object_name='object', mimetype=None,
                            current_app=None, current_app_field=None):
    if exclude is None:
        exclude = []
    urls = []
    kwargs = {
        'queryset': queryset, 'extra_context': extra_context,
        'context_processors': context_processors,
        'template_object_name': template_object_name, 'mimetype': mimetype,
        'current_app': current_app, 'current_app_field': current_app_field
    }
    if template_loader:
        kwargs['template_loader'] = template_loader

    if 'index' not in exclude:
        kwargs_index = {'max_items': index_max_items,
                        'allow_empty': allow_empty}
        kwargs_index.update(kwargs)
        urls.append(url(r'^$', 'object_index', kwargs_index,
                        name='%sindex' % name_prefix))

    if 'list' not in exclude:
        kwargs_list = {'paginate_by': paginate_by,
                       'allow_empty': allow_empty,
                       'reverse_pages': reverse_pages}
        kwargs_list.update(kwargs)
        urls.append(url(r'^%s$' % archive_prefix, 'object_list', kwargs_list,
                        name='%slist' % name_prefix))
        urls.append(url(r'^%spage-(?P<page>\d+)$' % archive_prefix,
                        'object_list', kwargs_list,
                        name='%slist' % name_prefix))

    if 'detail' not in exclude:
        kwargs_detail = {'slug_field': slug_field} if slug_field else {}
        kwargs_detail.update(kwargs)
        urls.append(
            url(r'^(?P<slug>[-\w]+)$' if slug_field else \
                r'^(?P<object_id>\d+)$',
                'object_detail', kwargs_detail, name='%sdetail' % name_prefix)
        )
    return patterns('lemon.views.generic.list_detail', *urls)
