from datetime import datetime
from lemon.views.list import ListView


class ArchiveView(ListView):
    """
    .. py:attribute:: date_field
       The name of field with date for filter.

    .. py:attribute:: allow_future
       If True and object is in future, it will not be shown.
    """

    def get_prepared_queryset(self):
        queryset = super(ArchiveView, self).get_prepared_queryset()
        if not getattr(self, 'allow_future', False):
            lookup_kwargs = {'%s__lte' % self.date_field: datetime.now()}
            return queryset.filter(**lookup_kwargs)
        return queryset

    def get_template_name(self, suffix='archive'):
        return super(ArchiveView, self).get_template_name(suffix)