from django.shortcuts import render_to_response
from django.template import RequestContext

from baseviews.views import BasicView


class View(BasicView):
    """
    Required attributes:
    template_name -- the name of template
    """

    @classmethod
    def factory(cls, name, mixins=None, **kwargs):
        if not isinstance(name, basestring):
            name = name.__name__ + cls.__name__
        if isinstance(mixins, (list, tuple)):
            bases = tuple([cls] + mixins)
        else:
            bases = (cls,)
        return type(name, bases, kwargs)

    def __init__(self, request, current_app=None):
        self.request = request
        self.current_app = current_app

    def get_template_name(self):
        return getattr(self, 'template_name', None)

    def render(self):
        request_context = RequestContext(
            self.request, current_app=self.current_app)
        return render_to_response(
            self.get_template_name(), self.get_context(),
            context_instance=request_context,
            mimetype=self.content_type)