from datetime import datetime
from lemon.views.month import MonthView


class DayView(MonthView):

    def __init__(self, request, year=None, month=None, day=None, current_app=None):
        super(DayView, self).__init__(request, year, month, current_app)
        self.day = day

    def get_prepared_queryset(self):
        queryset = super(DayView, self).get_prepared_queryset()
        lookup_kwargs = {'%s__day' % self.date_field: self.get_day()}
        return queryset.filter(**lookup_kwargs)

    def get_day(self):
        return int(self.day) if self.day else datetime.now()

    def get_template_name(self, suffix='archive_day'):
        return super(MonthView, self).get_template_name(suffix)