from datetime import datetime
from lemon.views.year import YearView


class MonthView(YearView):

    def __init__(self, request, year=None, month=None, current_app=None):
        super(MonthView, self).__init__(request, year, current_app)
        self.month = month

    def get_prepared_queryset(self):
        queryset = super(MonthView, self).get_prepared_queryset()
        lookup_kwargs = {'%s__month' % self.date_field: self.get_month()}
        return queryset.filter(**lookup_kwargs)

    def get_month(self):
        return int(self.month) if self.month else datetime.now().month

    def get_template_name(self, suffix='archive_month'):
        return super(MonthView, self).get_template_name(suffix)