from datetime import datetime
from lemon.views.archive import ArchiveView


class YearView(ArchiveView):

    def __init__(self, request, year=None, current_app=None):
        super(YearView, self).__init__(request, current_app)
        self.year = year

    def get_prepared_queryset(self):
        queryset = super(YearView, self).get_prepared_queryset()
        lookup_kwargs = {'%s__year' % self.date_field: self.get_year()}
        return queryset.filter(**lookup_kwargs)

    def get_year(self):
        return int(self.year) if self.year else datetime.now().year

    def get_template_name(self, suffix='archive_year'):
        return super(YearView, self).get_template_name(suffix)