import os
import subprocess

from setuptools import setup, find_packages


def get_version():
    if os.path.exists('version.txt'):
        return open('version.txt').readline().strip()
    else:
        p = subprocess.Popen(
            'git describe --tags', shell=True,
            stderr=subprocess.STDOUT, stdout=subprocess.PIPE)
        version = p.communicate()[0].strip()
        if p.returncode:
            version = 'unknown'
        f = open('version.txt', 'w')
        f.write(version)
        f.close()
        return version


setup(
    name = 'Lemon',
    version = get_version(),
    url = 'http://www.trilan.ru/',
    download_url = 'http://lab.dev.3lan.ru/',
    author = 'TriLan Co.',
    author_email = 'lemonteam@trilan.ru',
    description = 'A high-level Python Web framework for Django.',
    packages = find_packages(exclude=['demoproject', 'demoproject.*']),
    include_package_data = True,
    zip_safe = False,
    install_requires = [
        'Django>=1.2,<1.3',
        'South>=0.7,<0.8',
        'django-tinymce>=1.6.0,<1.7.0',
        'django-baseviews',
        'django-intellipages',
        'django-classy-tags',
        'django-staticfiles',
    ],
    test_suite = 'tests.main',
    entry_points = {
        'lemonrecipe': [
            'init = lemon:init'
        ]
    }
)