# Copyright 2014 MINES ParisTech
#
# This file is part of LinPy.
#
# LinPy is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# LinPy is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LinPy.  If not, see <http://www.gnu.org/licenses/>.

"""
A polyhedral library based on isl
"""

from .geometry import GeometricObject, Point, Vector
from .linexprs import LinExpr, Symbol, symbols, Dummy, Rational
from .polyhedra import Polyhedron, Lt, Le, Eq, Ne, Ge, Gt, Ne, Empty, Universe
from .domains import Domain, And, Or, Not
from ._version import __version__


__all__ = [
    'LinExpr', 'Symbol', 'symbols', 'Dummy', 'Rational',
    'GeometricObject', 'Point', 'Vector',
    'Polyhedron', 'Lt', 'Le', 'Eq', 'Ne', 'Ge', 'Gt', 'Empty', 'Universe',
    'Domain', 'And', 'Or', 'Not',
    '__version__',
]
