#!/usr/bin/env python3

# This example is inspired from a math question in the French baccalauréat 2014
# consisting in computing the intersection of a plane with a line.

from linpy import Eq, symbols

x, y, z = symbols('x y z')
plane = Eq(x, y) & Eq(z, 6 - 2*x)
line = Eq(x + y - 2*z, 0)

if __name__ == '__main__':
    print('plane:       ', plane)
    print('line:        ', line)
    print('intersection:', plane & line)
