# Copyright 2014 MINES ParisTech
#
# This file is part of LinPy.
#
# LinPy is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# LinPy is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LinPy.  If not, see <http://www.gnu.org/licenses/>.

"""
A polyhedral library based on isl
"""

from ._version import __version__
from .domains import And, Domain, Not, Or
from .geometry import GeometricObject, Point, Vector
from .linexprs import Dummy, LinExpr, Rational, Symbol, symbols
from .polyhedra import Empty, Eq, Ge, Gt, Le, Lt, Ne, Polyhedron, Universe


__all__ = [
    '__version__',
    'And',
    'Domain',
    'Dummy',
    'Empty',
    'Eq',
    'Ge',
    'GeometricObject',
    'Gt',
    'Le',
    'LinExpr',
    'Lt',
    'Ne',
    'Not',
    'Or',
    'Point',
    'Polyhedron',
    'Rational',
    'Symbol',
    'symbols',
    'Universe',
    'Vector',
]
