#!/usr/bin/env python3

# This program plots several 2D and 3D polyhedra on the same figure,
# illustrating some of the possible plot options.

import matplotlib.pyplot as plt

from matplotlib import pylab

from linpy import Ge, Le, symbols


x, y, z = symbols('x y z')

diam = Ge(y, x - 1) & Le(y, x + 1) & Ge(y, -x - 1) & Le(y, -x + 1)

cham = (
    Le(0, x, 3) & Le(0, y, 3) & Le(0, z, 3) &
    Le(z - 2, x, z + 2) & Le(1 - z, x, 5 - z) &
    Le(z - 2, y, z + 2) & Le(1 - z, y, 5 - z) &
    Le(y - 2, x, y + 2) & Le(1 - y, x, 5 - y))

rhom = cham & (
    Le(x + y + z, 7) & Ge(-2, -x - y - z) &
    Le(-1, x + y - z, 4) & Le(-1, x - y + z, 4) & Le(-1, -x + y + z, 4))

cubo = (
    Le(0, x, 5) & Le(0, y, 5) & Le(0, z, 5) &
    Le(x - 4, y, x + 4) & Le(-x + 1, y, -x + 9) &
    Le(y - 4, z, y + 4) & Le(-y + 1, z, -y + 9) &
    Le(z - 4, x, z + 4) & Le(-z + 1, x, -z + 9) &
    Le(3, x + y + z, 12) & Le(-2, x - y + z, 7) &
    Le(-2, -x + y + z, 7) & Le(-2, x + y - z, 7))


if __name__ == '__main__':

    fig = plt.figure(facecolor='white')

    diam_plot = fig.add_subplot(2, 2, 1, aspect='equal')
    diam_plot.set_title('Diamond')
    diam.plot(diam_plot, fill=True, edgecolor='red', facecolor='yellow')

    cham_plot = fig.add_subplot(2, 2, 2, projection='3d', aspect='equal')
    cham_plot.set_title('Chamfered cube')
    cham.plot(cham_plot, facecolors=(1, 0, 0, 0.75))

    rhom_plot = fig.add_subplot(2, 2, 3, projection='3d', aspect='equal')
    rhom_plot.set_title('Rhombicuboctahedron')
    rhom.plot(rhom_plot, facecolors=(0, 1, 0, 0.75))

    cubo_plot = fig.add_subplot(2, 2, 4, projection='3d', aspect='equal')
    cubo_plot.set_title('Truncated cuboctahedron')
    cubo.plot(cubo_plot, facecolors=(0, 0, 1, 0.75))

    pylab.show()
