# Copyright 2014 MINES ParisTech
#
# This file is part of LinPy.
#
# LinPy is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# LinPy is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LinPy.  If not, see <http://www.gnu.org/licenses/>.

import ctypes
import ctypes.util
import re

from . import _islhelper
from ._islhelper import (isl_basic_set_constraints, isl_set_basic_sets,
                         isl_set_points, isl_vertices_vertices)


__all__ = [
    'isl_basic_set_constraints',
    'isl_basic_set_to_str',
    'isl_multi_aff_to_str',
    'isl_set_basic_sets',
    'isl_set_points',
    'isl_set_to_str',
    'isl_val_to_int',
    'isl_version',
    'isl_vertices_vertices',
    'libisl',
    'mainctx',
]


libisl = ctypes.CDLL(ctypes.util.find_library('isl'))
libisl.isl_dim_set = _islhelper.dim_set

libisl.isl_version.restype = ctypes.c_char_p
isl_version = libisl.isl_version().decode().strip()
isl_version = re.sub(r'^isl-', '', isl_version)


mainctx = libisl.isl_ctx_alloc()


libisl.isl_printer_get_str.restype = ctypes.c_char_p


def isl_val_to_int(islval):
    islpr = libisl.isl_printer_to_str(mainctx)
    islpr = libisl.isl_printer_print_val(islpr, islval)
    string = libisl.isl_printer_get_str(islpr).decode()
    return int(string)


def isl_basic_set_to_str(islbset):
    islpr = libisl.isl_printer_to_str(mainctx)
    islpr = libisl.isl_printer_print_basic_set(islpr, islbset)
    string = libisl.isl_printer_get_str(islpr).decode()
    return string


def isl_set_to_str(islset):
    islpr = libisl.isl_printer_to_str(mainctx)
    islpr = libisl.isl_printer_print_set(islpr, islset)
    string = libisl.isl_printer_get_str(islpr).decode()
    return string


def isl_multi_aff_to_str(islmaff):
    islpr = libisl.isl_printer_to_str(mainctx)
    islpr = libisl.isl_printer_print_multi_aff(islpr, islmaff)
    string = libisl.isl_printer_get_str(islpr).decode()
    return string
