#!/usr/bin/env python3

# Copyright 2014 MINES ParisTech
#
# This file is part of LinPy.
#
# LinPy is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# LinPy is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LinPy.  If not, see <http://www.gnu.org/licenses/>.

from setuptools import setup, Extension


with open('linpy/_version.py') as file:
    exec(file.read())

with open('README.rst') as file:
    long_description=file.read()

setup(
    name='LinPy',
    version=__version__,
    license='GPLv3',
    description='A polyhedral library based on isl',
    long_description=long_description,
    author='MINES ParisTech',
    url='https://scm.cri.mines-paristech.fr/git/linpy.git',
    packages=['linpy'],
    ext_modules=[
        Extension('linpy._islhelper',
            sources=['linpy/_islhelper.c'],
            libraries=['isl'])
    ],
    test_suite='linpy.tests'
)
