import pkg_resources
import sys
import os
import time
from optparse import OptionParser
import tempfile
import webbrowser

group_name = 'lyricsearch.search'

        
def command():
    usage = "usage: %prog [options] title artist"
    parser = OptionParser(usage)
    parser.add_option('-p','--plugin', action="store", dest="plugin",help='Select a plugin to search')
    parser.add_option('-l','--list', action="store_true", dest="lista", help='List plugins available')
    parser.add_option('-b','--browser', action="store_true", dest="browser", help='Open file in window/tab browser')
    (options, args) = parser.parse_args()
    if options.lista:
        print 'Plugins availables:'
        for ep in pkg_resources.iter_entry_points(group_name):
            print '--',ep.name
        sys.exit()    
    if len(args) != 2:
        parser.error('incorrect number of arguments')
    title = args[0]
    artist = args[1]
    text = ''
    if options.plugin:
        for ep in pkg_resources.iter_entry_points(group_name):
            if ep.name == options.plugin:
                plugin_class = ep.load()
                b = plugin_class()
                text = b.find(title, artist)
                if text:
                    break
    else:
        entry_points = []
        for ep in pkg_resources.iter_entry_points(group_name):
            entry_points.append(ep)
        for ep in entry_points:
            plugin_class = ep.load()
            print 'Find with:',ep.name
            b = plugin_class()
            text = b.find(title, artist)
            if text:
                break
    if options.browser:
        if text:
            html_body = """
            <html>
            <head>
                <title>%s</title>
            </head>
            <body>
                %s
                <hr/>
                <code>Find in <a href="%s">%s</a></code>
                <br/>
                <code>Generated by LyricSearch Powered by Python</code>
            </body>
            </html>
            """ % (artist.capitalize() + ' - ' + title.capitalize(), 
                text, b.url, b.description) 
        else:
            html_body = """
            <html>
            <head>
                <title>%s</title>
            </head>
            <body>
               <h1>Lyric not found!</h1>
               <code>Find in <a href="%s">%s</a></code>
               <br/>
               <code>Generated by LyricSearch Powered by Python</code>            
            </body>
            </html>
            """ % (artist.capitalize() + ' - ' + title.capitalize(), 
                b.url, b.description)             
        if 'windows' in os.environ['OS'].lower():
            arq = open('lyric.html','w')
            arq.write(html_body)
            arq.close()
            webbrowser.open(arq.name)
            time.sleep(2)
            os.remove(arq.name)
        else:
            file_temp = tempfile.NamedTemporaryFile(suffix='.html')
            file_temp.write(html_body)
            file_temp.flush()
            webbrowser.open(file_temp.name)
            file_temp.close()
    else:
        print text
        
if __name__ == '__main__':
    command()