#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Copyright (c) 2009, 2010 Jack Kaliko <efrim@azylum.org> {{{
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of the
#  License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with this program.
#  If not, see <http://www.gnu.org/licenses/>.
#
#  }}}

"""
This is a really simple script to add similar artists to the MPD playlist.

Original code from user Kane at http://bbs.archlinux.org
    http://bbs.archlinux.org/viewtopic.php?pid=377423#p377423

Looking for already existing projects while I was writing MPD_sima I found this
script, slightly modified it to have it python 2.6 ready and more pep8-ized.

"""

import audioscrobbler
import mpd
import random
import time
import sys


LASTSONG = {}

def get_similar():
    """Retrieve similar artists."""
    audioscrobbler
    client = mpd.MPDClient()
    client.connect("localhost", 6600)
    mpdstatus = client.status()
    prevsonginfo = client.currentsong()
    global LASTSONG
    if mpdstatus['state'] == "stop":
        return
    if prevsonginfo == LASTSONG:
        return

    LASTSONG = prevsonginfo
    similarartists = ""
    song = prevsonginfo
    #if not song: break #No song, do nothing
    prevartist = song['artist']

    # Is the info already cached?
    similar_cache = {}
    if prevartist in similar_cache:
        similarartists = similar_cache[prevartist]
    else:
        #Not cached so fetch from Audioscrobbler
        try:
            as_request = audioscrobbler.AudioScrobblerQuery(artist=prevartist)
            similarartists = [artist.name for artist in as_request.similar()]
            # Cache search results and save some time next search
            similar_cache[prevartist] = similarartists
        except audioscrobbler.AudioScrobblerError:
            similar_cache[prevartist] = None # Empty cache
            return # Do nothing!

    if not similarartists:
        return # Empty list

    # Split list in half and sort upper half
    # this means good matches will have priority
    # but makes sure artist A does not always result in artist B
    half_idx = len(similarartists)/2
    upperhalf = similarartists[:half_idx]
    lowerhalf = similarartists[half_idx:]
    random.shuffle(upperhalf)
    artistlist = upperhalf
    artistlist.extend(lowerhalf)
    # Try each artist in order
    for artist in artistlist:
        try:
            print "Trying: %s" % artist
            songs = client.search("artist", artist)
            if not songs:
                continue
            selected_song = random.sample(songs, 1)[0]
            #client.add(selected_song['file'])
            print 'Added %s by %s' % (selected_song['title'], selected_song['artist'])
            # Delete old song from playlist?
            break
        except mpd.MPDError, err:
            print "MPDError: %s" % err.message
            continue
        except ValueError, err:
            print "ValueError: %s" % err.message
            continue


while(42):
    """
    Main loop.
    """
    try:
        get_similar()
        time.sleep(10)
    except KeyboardInterrupt:
        print 'Stopped'
        sys.exit(0)

# VIM MODLINE
# vim: ai ts=4 sw=4 sts=4 expandtab
