# -*- coding: utf-8 -*-
"""
    # MailShake
    
    Although Python makes sending email relatively easy via the smtplib module,
    this bundle provides a couple of light wrappers over it.
    
    These wrappers are provided to make sending email extra quick, to make it
    easy to test email sending during development, and to provide support for
    platforms that can’t use SMTP.

    Usage:
    
        from mailshake import EmailMessage, Mailer
        
        email_msg = EmailMessage(
            "Weekend getaway",
            'Here's a photo of us from our Europe trip.',
            'from@example.com',
            ['mary@example.com', 'bob@example.com'],
            
            )
        email_msg.attach("picture.jpg")
        
        mailer = Mailer()
        mailer.send(email_msg)
    

    Severals other mailers are available for testing: `ToConsoleMailer`,
    `DummyMailer` (does nothing), `ToFileMailer` and `ToMemoryMailer`.


    - LEGAL -------------------------------------------------------------------

    Much of the code was originally based on the mail code from Django
    (http://djangoproject.com). The original code was BSD licensed:

        Copyright (c) Django Software Foundation and individual contributors.
        All rights reserved.

        Redistribution and use in source and binary forms, with or without
        modification, are permitted provided that the following conditions are
        met:

            1. Redistributions of source code must retain the above copyright
               notice, this list of conditions and the following disclaimer.
            
            2. Redistributions in binary form must reproduce the above
               copyright notice, this list of conditions and the following
               disclaimer in the documentation and/or other materials provided
               with the distribution.

            3. Neither the name of Django nor the names of its contributors
               may be used to endorse or promote products derived from this
               software without specific prior written permission.

        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
        "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
        LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
        PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
        OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
        SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
        LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
        DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
        THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
        OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


    Copyright © 2010-2011 by Lúcuma labs (http://lucumalabs.com).
    MIT License. (http://www.opensource.org/licenses/mit-license.php)

"""
from .mailers.console import ToConsoleMailer
from .mailers.dummy import DummyMailer
from .mailers.filebased import ToFileMailer
from .mailers.memory import ToMemoryMailer
from .mailers.smtp import SMTPMailer

from .message import EmailMessage


Mailer = ToConsoleMailer

