'''
Default Palette
===============

'''

from matplotlib.colors import LinearSegmentedColormap


class Palette(object):

    '''
    This class is a collection of all colors provided by the default 
    palette of MatPlotTheme.
    '''

    color_cycle = [
        '#66c2a5', '#fc8d62', '#8da0cb', '#e78ac3',
        '#a6d854', '#ffd92f', '#e5c494', '#b3b3b3',
    ]
    '''
    Defines the color cycle used in all
    :meth:`matplottheme.style.default.Style.plot`,
    :meth:`matplottheme.style.default.Style.bar`, 
    :meth:`matplottheme.style.default.Style.barh` and other methods.
    '''

    dark_frame = '#444444'
    '''
    Defines the color of plot frame and labels/texts.
    '''

    legend_bgcolor = '#dddddd'
    '''
    Defines the background color of legend
    '''

    frame_bgcolor = '#ffffff'
    '''
    Defines the background color of plots.
    '''

    cold_warm_map = LinearSegmentedColormap('cold_warm_map', {
        'red':  ((0.0, 0.0, 0.0), (0.1, 0.101960784314, 0.101960784314), (0.2, 0.4, 0.4), (0.3, 0.650980392157, 0.650980392157), (0.4, 0.850980392157, 0.850980392157), (0.5, 1.0, 1.0), (0.6, 0.996078431373, 0.996078431373), (0.7, 0.992156862745, 0.992156862745), (0.8, 0.956862745098, 0.956862745098), (0.9, 0.843137254902, 0.843137254902), (1.0, 0.647058823529, 0.647058823529),),
        'green':  ((0.0, 0.407843137255, 0.407843137255), (0.1, 0.596078431373, 0.596078431373), (0.2, 0.741176470588, 0.741176470588), (0.3, 0.850980392157, 0.850980392157), (0.4, 0.937254901961, 0.937254901961), (0.5, 1.0, 1.0), (0.6, 0.878431372549, 0.878431372549), (0.7, 0.682352941176, 0.682352941176), (0.8, 0.427450980392, 0.427450980392), (0.9, 0.188235294118, 0.188235294118), (1.0, 0.0, 0.0),),
        'blue':  ((0.0, 0.21568627451, 0.21568627451), (0.1, 0.313725490196, 0.313725490196), (0.2, 0.388235294118, 0.388235294118), (0.3, 0.41568627451, 0.41568627451), (0.4, 0.545098039216, 0.545098039216), (0.5, 0.749019607843, 0.749019607843), (0.6, 0.545098039216, 0.545098039216), (0.7, 0.380392156863, 0.380392156863), (0.8, 0.262745098039, 0.262745098039), (0.9, 0.152941176471, 0.152941176471), (1.0, 0.149019607843, 0.149019607843),)
    })
    '''
    Defines the cold-warm color map.
    '''

    cold_map = LinearSegmentedColormap('cold_map', {
        'red':  ((0.0, 0.0, 0.0), (0.125, 0.0, 0.0), (0.25, 0.137254901961, 0.137254901961), (0.375, 0.254901960784, 0.254901960784), (0.5, 0.454901960784, 0.454901960784), (0.625, 0.63137254902, 0.63137254902), (0.75, 0.780392156863, 0.780392156863), (0.875, 0.898039215686, 0.898039215686), (1.0, 0.96862745098, 0.96862745098),),
        'green':  ((0.0, 0.266666666667, 0.266666666667), (0.125, 0.427450980392, 0.427450980392), (0.25, 0.545098039216, 0.545098039216), (0.375, 0.670588235294, 0.670588235294), (0.5, 0.76862745098, 0.76862745098), (0.625, 0.850980392157, 0.850980392157), (0.75, 0.913725490196, 0.913725490196), (0.875, 0.960784313725, 0.960784313725), (1.0, 0.988235294118, 0.988235294118),),
        'blue':  ((0.0, 0.105882352941, 0.105882352941), (0.125, 0.172549019608, 0.172549019608), (0.25, 0.270588235294, 0.270588235294), (0.375, 0.364705882353, 0.364705882353), (0.5, 0.462745098039, 0.462745098039), (0.625, 0.607843137255, 0.607843137255), (0.75, 0.752941176471, 0.752941176471), (0.875, 0.878431372549, 0.878431372549), (1.0, 0.960784313725, 0.960784313725),)
    })
    '''
    Defines the cold color map.
    '''

    warm_map = LinearSegmentedColormap('warm_map', {
        'red':  ((0.0, 1.0, 1.0), (0.125, 0.996078431373, 0.996078431373), (0.25, 0.992156862745, 0.992156862745), (0.375, 0.992156862745, 0.992156862745), (0.5, 0.992156862745, 0.992156862745), (0.625, 0.945098039216, 0.945098039216), (0.75, 0.850980392157, 0.850980392157), (0.875, 0.650980392157, 0.650980392157), (1.0, 0.498039215686, 0.498039215686),),
        'green':  ((0.0, 0.960784313725, 0.960784313725), (0.125, 0.901960784314, 0.901960784314), (0.25, 0.81568627451, 0.81568627451), (0.375, 0.682352941176, 0.682352941176), (0.5, 0.552941176471, 0.552941176471), (0.625, 0.411764705882, 0.411764705882), (0.75, 0.282352941176, 0.282352941176), (0.875, 0.211764705882, 0.211764705882), (1.0, 0.152941176471, 0.152941176471),),
        'blue':  ((0.0, 0.921568627451, 0.921568627451), (0.125, 0.807843137255, 0.807843137255), (0.25, 0.635294117647, 0.635294117647), (0.375, 0.419607843137, 0.419607843137), (0.5, 0.235294117647, 0.235294117647), (0.625, 0.0745098039216, 0.0745098039216), (0.75, 0.00392156862745, 0.00392156862745), (0.875, 0.0117647058824, 0.0117647058824), (1.0, 0.0156862745098, 0.0156862745098),)
    })
    '''
    Defines the warm color map.
    '''


def _generate_color_map_str(color_str, reverse=False):
    colors = color_str.split()
    r = []
    g = []
    b = []
    for i in range(len(colors)):
        if reverse:
            index = len(colors) - i - 1
        else:
            index = i
        rgb = colors[index].split(',')
        r.append(
            (1.0 / (len(colors) - 1) * i, float(rgb[0]) / 255, float(rgb[0]) / 255))
        g.append(
            (1.0 / (len(colors) - 1) * i, float(rgb[1]) / 255, float(rgb[1]) / 255))
        b.append(
            (1.0 / (len(colors) - 1) * i, float(rgb[2]) / 255, float(rgb[2]) / 255))

    red = "'red':  ("
    for i in range(len(r)):
        red += "(" + str(r[i][0]) + ", " + \
            str(r[i][1]) + ", " + str(r[i][2]) + "), "
    red += "),"
    print(red)
    green = "'green':  ("
    for i in range(len(r)):
        green += "(" + str(g[i][0]) + ", " + \
            str(g[i][1]) + ", " + str(g[i][2]) + "), "
    green += "),"
    print(green)
    blue = "'blue':  ("
    for i in range(len(r)):
        blue += "(" + str(b[i][0]) + ", " + \
            str(b[i][1]) + ", " + str(b[i][2]) + "), "
    blue += ")"
    print(blue)
