#!/usr/bin/python
# -*- coding: utf-8 -*-

"""
Inspired by PyAlaMode (a programmer's editor from wxPython code)

'Math bench: not a whole laboratory, just a small bench'
"""

import os
import sys
import logging
import wx


# use latest local dev version
#sys.path.insert(0,os.path.expanduser("~/src/mathbenchdev/mathbench/mathbenchdir/trunk"))
# sys.path.insert(0,os.path.expanduser("~/src/yapsy/yapsydir/trunk"))

#----------------------------------------------------------------------
# This was generated by /usr/lib/python2.5/site-packages/wx-2.8-gtk2-unicode/wx/tools/img2py.py
#
from wx import ImageFromStream, BitmapFromImage, EmptyIcon
import cStringIO, zlib


def getData():
    return zlib.decompress(
'x\xda\x01\xf7\t\x08\xf6\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\t\xaeIDATh\x81\xd5\x9a[\xac\\U\x19\xc7\x7fk\xad}\x9b\
\x99smO/\xb4\xf4B[-m\xa1Dn\xa9\xa0($&\x90x\xc1\x17}Q\x91\x98\x00\t/\x86\x07\
\x8d\x10\x9f\x9a\xb41\xf1\xd5D@\xa3\x89\x0f\x12Em\x08X\x10\x84D\xc5\x10i0)\
\x97\xa2\x9c\x8a\xd0\xd2szn3\xb3\xe7\xb2gf_\x96\x0f{f\xef\xd9g.g\xc6\x18\x03\
\xdf\xcb\xac\xb5\xf6Zk\xff\xbf\xff\xfa.k\xad=BH\xc5GY\x8ca\x0f\x9f\xfc\xcd\
\x13z\xd3\xa6\xcd\x00\xdcq\xfb\xe7\xc48\x13?\xfa\xe8\x8f4\xc0\xfd\xf7?8\xd6\
\xb8\x17_z^_\xbcx\x91o|\xfd\xde\x91\xc6\xc9a\x0f\x1d\'\x87i\x9a\x94\xcb\xe5q\
0\x00P\x98\x98\xc0\xb2\xad\xb1\xc6<\xfe\x93\x1fk\xd34\x99\x9c\x9c\x1cy\xcc@\
\x05~w\xeaI\xbdc\xc7\x0e\x0c\xc3\xa0T*\xf2\xf0#\xdf\xd5\xe3\x80\xd9\xb5k\x17\
33\xb3\xe3\x0c\xa1X,\x02\xb0g\xcf\x9e\x91\xc7\x0cT \x0c\x03J\xa5\x12\x9f<\
\xf6)Q\xa9T\xc7^\x85\xb5\xb5\xb5\xb1\xfa\x03T\xab\xf1{\x96\x97\x97\xf9\xd9\
\xcf\x1f\x1f\x89\xb0\x81\n8N\x8e\\.\x07\xc4\xccT\xab\xd5\xb1\xc0\xe4\xf3y\
\xf2\xf9\xfcXcJ\xa5\x12\xa5R\t\xd341\xcd\xd1\xcco\xa0\x13\x9b\xa6\x89\xe7y\
\x00\xb8\xae;\x16\x10\x00\xc7q\xc6\xea\x7f\xcf7\xbf\xa6\xcb\xe52\xb5j\x95\\.\
\x87\xe3\xd8#\x8d\x1b\xb2\x02Nb6\x15\xb72\x16\x18\x00\xcb\xb2\xb0\xac\xf1\
\x9c\x18\xe2\xa8\xe5y\x1e\x8e\x93\x1b\xa9\xbf\xe8\xce\x03\'N\x1e\xd7\x00\x9b\
7m\xe2\xe8u\xd7\xf1\xdak\xaf\xb1\xec\x96\xb1\xc6r_\x98\x98\x98`\xdf\xbe}\x00\
,,,\xb0\xbc\xbc<\xd6\xf8\xdd\xbbwS(\x148w\xee\\\xcf\xb3\x87\xbf\xf7\xfdLx\
\xcd\x98P\x14E\xbc\xb2\xb6\x8b\xfd\x91d\xaf\xeb\xb2X\x16\xfc\xbb\xbc\x153h;\
\xb01\x1a+\x93\xa1`S\xa9\x04\xc0\xa5\x12,V\xa7\x00\xf0\x95 \xc7\xe0\xc4i\x08\
\x1f\x80+\xfc\x16-\xb6\xb2\x10\\\x89\x941\xde\x19s\t;l\xf6\x8e\xe9\x14N\x9c<\
\xae\xa3(\xe2\xbd\x92\x85\xaf\r>]q\xa9\xd6\xaa\xbc\xfe\xc1,\x8d\x96\x8dc\xd9\
\x84\xd6\xc4H\n\xecl\xd4\xd9?\x1dG\xa1\xf7V\x0c\xde\\\xcd!s\xd3\x00\xe4\xf11\
\x8c\xf8\xb5\x86a \x85\xc4\xc6GJ\x89R\x8azu\x81\xab*U\xd4\xa4\xa2\xa8\xa7\
\xc9\x85\x82\xc0Tl5}\x08\x17\x07+\xd0-^=\xa0X\xac\xd2\xaa\x97i\xb4\xf2\x18~\
\x9d\xba\xd6\xd8#* \xbcF\x12\xd3+U\x07\xdf\x97L[\x11\r%\x13\xf0RJ\xa4\x90I\
\x19@k\x8d\xf0\xeb\xb8n\x1d\xed\xac\x92\xc3!0\xe3\x15kP\xa0\xdf\xfag\x14\x08\
T<Q\xd1\x87\x95b\x8dF\xad\x84\xe1OC\xb3\xc2\xa8\xeeX\xc0\xa7\xd1l\xb0\xba\
\xba\n@\xad:\x8d\x1f\x14h\x85u\xa6\xecB\n\xbe\r\xda\xc6\x07b\xf6\xc30D\xb5\
\x8a\x94J\x1e-\xbb\x8e\x87\x8d\xd9\x9e\xb7\x19\xa9\xbe\nd\xa2\x90\x96i\xe8z\
\xe7rH\xd0\xacb\xaf\xbd\xc2\xb2\xbbD\x10\x86\xd8\xa17\x92\x12\xbe\xefS.\x97)\
\x97\xcb4\xaak\x98Q\xef\xb8\xf5\xec\x03T\xd6\x16\x88J\xf3\xb8e\x97\xf3\x97\
\x8ai_)\xa9\xeb\xfe9e`\x18}\xa7\xe8\xe0G\x8a\x83\xbbg\x90\x8bo\x00`\xa8\xa1{\
?\n\xc4N\xe8\xb9+I[\xad\xbc\x92\xe9\xd3\xcb>(\x15\x9b\xc9\xfc\x99SL\x15,\x96\
\x8b\x15V\xea\x02\xd3\xcc\xbe/\x8a\xa2$Rv$kB:\xadza\x8eW\xdf\xbc\xc0\xe6\x82\
DZ\x13\xe4\x0b\x06\xb5dA\x07\x8bR\x8a\x921\xc5\xd9sg\xb0m\x9b\xa8p\x00\x00\
\xc7JW\xb7\x9b\xfd\x8e2RJ\xec\xc24\xf3\xef/S\xaa\xc3\xf5\xfb\'\x92\xf6n\xe5\
\xd7KF\x01\x19\xa5\x00\xf3N\x8e\x9d\xb7|\x95K\xf3\x7f\xe7\x8b\xb7_\xcfJ0\xc1\
\xdb\x8b\xd1@\xe0\x1d\xf6\x95\x94\\\xbd\xff\xe3\xf8[l\x1aM\x8f[n\xba\x81\xb3\
\xff\xb8L\x95\xfe\xb6/D\x1a\xd6\xef\xfc\xf2=\xbc\xfb\xd6\xdf\xb8\xe3\xf05\
\xccn\xd9\xc9\xeb\x17\xe2\xf0\x9dS1\xe9-AON\xca(\xd0 \xfb\xf4\x9a\xa3\x87x\
\xe4\x81\xbb8\xfb\xcf\x8b\xfc\xf2\xa5\x7f\r\x04\xdf\x91\x8e)\x18\xca\xe0\xf3\
w}\x96\x9b\x0e\xef\xe0\xe9?\x9d\xa3\xa1\x15F\xdb\x1c\x06\xb1/\x8c\x88\xb9\
\xb9m|\xe5\xdb\x0f\xd0j\xb58}\xe6R\x86q\xa5\x14J\x16\xa0Y\x1b\xac\x80\x08\
\xd3$S\xf4\xe1\xa9W\xde\xe7\xc5\xd7\x17\xf0]\x97\xa6\x1a\x9c\xc4\xba\xd9\x07\
X*\xfb<q\xfa\x1c\xbf\xfe\xe3[T\x03\x81c9XC\xd8\x17B \xb5\xc9\xf9w\x978\xbf\
\xe8\x12\x04~\xa2X\x87}\x00K:\x84\x0cQ\xa0\x15\xf5:i\xb5\xe6\xc3\x10\xf0\x1d\
\xe9\xb0\xdf)k\xcb&\x00&\xf2\xe9\x9c\x83\xd8o*\xd1VJd\xc0w\xcf\'\xa5$\x88L\
\xd6\x1f\xd32^\xd1\x0c\xc7:\xfde\x15h\xbf\xd0\xb7R?\xca$\xadu\x91\xa7\x9b\
\xfd\x9c\x16\xe4\x10I\xd2\xeaH7\xfb\x10\'\xb3\xf5\x92\xa1\xfc\x9e/\xdc\xc0w\
\xb6m\xcftx\xf9\x8d\xcb\xfc\xe0\xc9\xb7\xfa\x82\x9eR\x11\xf7\xdeu\x80\x9b\
\x0e\xef\x00\xc01\xc6\xdc\xf5\xb5\xa5{\xf5\x86I\xa5R\xe1\xf4\xd3\xe73m\x19\
\x05f&m&\xf3\xd9\xc9\xee\xbcy\x07\xaf\xbe\xbd\xc8\x8bo\xf4\x9e\xb0n<4\xc7\
\xdd\xb7\xed\x1b\x17\xef\x7f-y{\xaa\xa7-cB\x83NA\xc7\x8e\\\xd9\xb7\xfd3\xd7^\
\xf1?\x805\xbaXm\xf3\xecNf\x99\x15PkG\x08k\x8d\xb8l\xde\n[N\x01p\xec\xd0\xe6\
\x9e\xc9fM\xf8\xc4\xc1\xadi\xc3\xf2\xddD\xe1\xfbi]\xcc\xc4?B\x10\xe9<\xaa\
\xeb\xdc\xa1;\xbb\x1a\x91\x06\x07\x9d\x94\x9dv\xbd\xfbD\x17\'Ae\xe4\x11\xe6$\
\xdaOy\xcf(\x90W\r\x123n\xbd\x8c\x1f\\F\x19\xdb\x98\xcc+n<0\xc5\x99\xf9\xf4h\
y\xf4\xc0tbn\xc2\x9f\'\xf0_\x8e\xcb\x01\xc4\t\xfdB\xdcQ\xeeBP$\n;\xe0\xa7\
\x80R[\x81\xf8\xfaDI\x05\xba+\xd2\x89\x1cB\xf7*\x15\x06M\x1cs\x12\xcfO\xbbJ\
\x88\x97$\x14-\x8cu\xbe$Z\x7fH\xca\xb7^=\x97yv\xec\xc8\xce\xa4\xac\xbdSiy\
\xf8v\t\xd1\x0e\xa5\x9d\xdf\xde\x0e1\xe8A+2\xe9\x84\x99\xeeC/\xb6D\xed\xf7I\
\xb9\x13i 6\x9f[\xaf\xd9\x96\x82n\x9c\x8e\xfb\x07\xeb\xc6\xcb]\x99\xbaf\n\
\xad#\x84\x90\xe8vHTR\xa5&5D\x94\x94()q\n\x03\x14\xb0\xfb\x84\xc0\xc8\x7f\
\x01\xc2\xd8\'v\xce9\x1c\x9c\x8b\x9d\xe8cW\xcd$\xe6\xa3\x83\x0bD\xc1\xd9.\
\xd3\xe9\x0f\x1e\xfa\xb3\x9e\x01?\x80}\xa9\xe2\xadt\x18\x99\xccNfsU\xaa\x80\
\xd9\xab\x80\xa9A6\x9fK\xea\xb7\\\xbb\x9d\x02>\xb7\x1fMWC6\x9f\xea\x19\xd7O\
\x06\xb1?\x18|\xaf(C1\xbb\xee\xd61Q@\xad_\xff\xb6\x04^\xea\x077\x1f\xd9\x89e\
\x9aY\xf3\xa9?\xbf!\xfb\x9a\xa9\x8d\xd9\xef\x91,\xfb\xc8\xb8>5\xedgz%\xb3J\
\xbb\x7f\x16\xd5\xcd_%\xe5\xabwOp\xc3\xa1\xb9\x8c\xf9\x84\xed\xe8\xb3\x91\
\x8c\xc7\xfe\xbaK1\x99*33\x99\xc5\x99(\x90\xb7Z}_lj\xd0\xcd\xbf&\xf5\x07\xbf\
t8\x05\xd5xv,\xf6u\xd7^f\x14\xc7M\xd8\xef\x92\xbc#\x08E+If\x89\x029\xa3\xf7\
\xce%\x01\xe5\x9dN\xca3\x93i\xb6\x96\xde3\x1b\x86MH\xd9\xef\xc8F\xecK)zL\xa7\
S\xd7X\xc9&1\xa3\x80\xb2\x07+\x105\x9e\xe9iS\xfe\x12\x91\x975\x9f~\xec\xa7\
\xe5\x02J\xaa\x91\xc3f\xe6]\x9dk\x97\xae\xbb\x91V;\x18\xa5+`6\x06N`\x84\x17\
\x10\xfe|\xb6\xb1\xf1\xecXIK\xf5\xfb\x945\x80\xfdf\x90\'\x8cL\xc2\xc8DI\x99$\
\xb1VM\xf3\xecK\x12\xedK\x14\xb1\xc9\'\x10\xf2\xd6\x067\xd0\xad\xe7\xc0<\x90\
T\x83\xc6\xe9\xcc\xe3\xbe\xb6\x9f\x947\xb6}C)"-\x90R\xf2\xc2_\xb6\xf0\xc1r\
\xea\xc8Z\xc5\x11R\x84)c\x9dr\xd2\x92\xb3\x06\xaf\x00@T\xfb-\xa2\xf0 \x002(\
\xe3\xfb/\x0c\xed\xdf\xcd\xbel\xb3\xdf\r^\xaaX\xa9P\xc7\x1b\xb5H[H)\x89\xda\
\xf5\xbd{\xf7\xb2}{|6\xf1}\x9fz\xbdN\xa5R\xa1T*Q\xae\xad\xa1dlN\x89\t9f\xf6\
\xfef\xbd\xe8\xc6Y\xa2\xfa/\x90A\x99\xa8\xfa\xc3,\xd8\x01\xb6/\x84\xc8\xb0\
\xbf\x1e|G\x8c\xf6\x91\x11\xe2\xc3Md*r\xb9\x1c333\xc9a\xc7\xf3<\xbcz\x9d\x8a\
Wb6\x9fF\xccd\x05l\xb3\xc80\xd1\x06Pz\x88 xh\xac-\x83\xea\xc3~GBm\xb7M\xc7B\
\n\x102\x8e4\xa6\x8a\xf7;\x95J\x85J\xa5\x82\xeb\xbaT\\\x97\xb2\xebbi\xc1\x96\
Y\x17\xb7\xd6\xbe7\xeaL\x96\xb3/\r\x04\x1f\x84\x03\x1f\xf5*\xda\xc5\xbe\x10\
\xbd_\x1b\xbbM\xc7h\xb3\xdbm:\x10o\xbf<\xcf\xeb\x01\xdf\x0c\xeb\x1c\xdc\xb7\
\xc4\xdct\x90D\xa1\xd4\x89\xd5`\x1f\xd0F\x9c\xd0\x82p\x83\r\x9b\x98\xe9\xb95\
\x88\x95\xeae\xbf\x03\x9ev\x84I\xce\xc5\xc2\xa6\xee[8\xcd\x06\xaeK\x02>\x08\
\x02\xf6]\xe913\x01`b\xfa\x1e\'N\x1e\x8f\xe1\xf4;\x0bt$\x08c5}A_p\xeb%\xbdm\
\x18\xcc~\xc7T:\xe0\xd3\xbaM\x18E\xd4\xab\x02\xc3\x0c\xa9\xd7\x8b\x94\xaa\
\xabXZp`O\x99\xed\xb3i\xae\xf2%X\x80q\xe2\xe4q\x1d\xd2\xe2\xa2{\xe7P`\x1a{]\
\xdd\xe9\xffL\xa6\xed*\xb2\x88\x8c\xd4\x1f",l-\x89\xba/\xeb\xbb\xfa#\x1d..\
\x054\x83(\xf9,5\x91\x0f\xb8b[\x84\xa9LV\xab\xbdw\xb3\x06\x80\xd2\x16O\xff\
\xf9\xb6\xa1\n\xfc\x7f$\x8e.Q\x14%\xdf*\xa8;\xcc\xbf\xdb\xdb\xd3\x92q6\x16B*\
\xee\xbb\xef[\xda\xb4L6o\xee=\xbc\x7f\x18%\x08\x02V\x96Wx\xec\xb1\x9f\x8a\
\xc4%\xfd\x96\xcf\xe2B\xef7\xa8\x0f\xbb\x88\x8f\xfa\xdfm\xfe\x03\xf9\xf6\xa5\
\\\x94z\x0cQ\x00\x00\x00\x00IEND\xaeB`\x82&1\xf6\xc7' )

def getBitmap():
    return BitmapFromImage(getImage())

def getImage():
    stream = cStringIO.StringIO(getData())
    return ImageFromStream(stream)

def getIcon():
    icon = EmptyIcon()
    icon.CopyFromBitmap(getBitmap())
    return icon

# end of icon stuff
#----------------------------------------------------------------------

from mathbench.lab.notebook import LabBook
from mathbench.basement.configuration import MathBenchConfig as mbconfig
import mathbench.basement.plugin_manager as pm

from mathbench.basement.librarian import LibrarianSingleton
from mathbench.lab.library import LibraryDeskHTML
 
# Sets some basic paths.
CONFIG_DIR= os.path.expanduser("~/.mathbench")

PLUGINS_DIR= os.path.join(CONFIG_DIR,"plugins")

if not os.path.isdir(CONFIG_DIR):	
	os.mkdir(CONFIG_DIR)

if not os.path.isdir(PLUGINS_DIR):	
	os.mkdir(PLUGINS_DIR)



# Create the app

class MathBenchApp(wx.App):
	"""
	MathBench as a standalone application.
	"""	

	
	def __init__(self, filename=None):
		self.filename = filename
		wx.App.__init__(self, redirect=False)
		
	def OnInit(self):
		"""
		Create the main frame and load the config
		"""

		# create the configuration manager
		mbconfig.setFilePath(os.path.join(CONFIG_DIR,"config.txt"))
		self.config = mbconfig.getConfig()

		# create the plugin manager 
		self.pm = pm.LabPluginManager.get()
		self.pm.setConfigParser(self.config, lambda : self.config.save())
		self.pm.setCategoriesFilter({"Default":pm.IPlugin})
		self.pm.setPluginPlaces([PLUGINS_DIR])
		self.pm.setInstallDir(PLUGINS_DIR)
		self.pm.setPluginInfoExtension("mathplug")
		# load the plugins
		self.pm.collectPlugins()

		def createSimpleLibraryDesk():
			"""
			Just create a simple frame
			"""
			return LibraryDeskHTML("Mathbench's Library Desk")

		# set the correct class for the help display (library desk)
		LibrarianSingleton.setDeskFactory(createSimpleLibraryDesk)

		# show the main frame
		self.frame = LabBook(filename=self.filename,config=self.config, history_dir=CONFIG_DIR)		
		self.frame.SetIcon(getIcon())
		self.frame.Show()
		self.SetTopWindow(self.frame)
		return True



def main(filename=None):
	if not filename and len(sys.argv) > 1:
		filename = sys.argv[1]
	if filename:
		filename = os.path.realpath(filename)
	app = MathBenchApp(filename)
	app.MainLoop()

if __name__ == '__main__':
	main()

