/*++

Module Name:

    GenomeIndex.h

Abstract:

    Headers for the index builder for the SNAP sequencer

Authors:

    Bill Bolosky, August, 2011

Environment:
`
    User mode service.

Revision History:

    Adapted from Matei Zaharia's Scala implementation.

--*/

#include "stdafx.h"
#include "GenomeIndex.h"

double GenomeIndex::biasTable17[] = {   // hg19
    (double)678275330 / 3137161264. * 4.,
    (double)375395031 / 3137161264. * 4.,
    (double)225133115 / 3137161264. * 4.,
    (double)111496909 / 3137161264. * 4.
};

double GenomeIndex::biasTable18[] = {   // hg19
    1.650792057,
    1.162720398,
    0.789596025,
    1.059051011,
    0.782483812,
    0.62438787,
    0.463758566,
    0.513510994,
    0.628377954,
    0.079382543,
    0.360011264,
    0.418725905,
    0.336826487,
    0.249211298,
    0.128937754,
    0.079394059
};

double GenomeIndex::biasTable19[] = { // hg19
    2.964824327,
    1.702601831,
    1.191508069,
    1.948422477,
    1.700599654,
    1.30101866,
    1.012917446,
    1.17882497,
    1.426927077,
    0.18423492,
    0.779376213,
    1.105942264,
    1.361476436,
    1.20537269,
    0.83137104,
    1.467453804,
    1.226401801,
    0.94746705,
    0.563245797,
    0.740676604,
    0.858999075,
    0.721156894,
    0.578796487,
    0.576240618,
    0.734901579,
    0.109312399,
    0.532503058,
    0.648702193,
    0.554063381,
    0.654509757,
    0.423599569,
    0.632166602,
    0.792527465,
    0.788453402,
    0.536223966,
    0.685528597,
    0.075600576,
    0.090135623,
    0.06985142,
    0.088332984,
    0.596066256,
    0.078056177,
    0.392329557,
    0.51120876,
    0.419395555,
    0.535695162,
    0.395736091,
    0.522797122,
    0.564480054,
    0.317532499,
    0.262308908,
    0.430329465,
    0.371016755,
    0.286074474,
    0.206545904,
    0.273072595,
    0.246781045,
    0.020949467,
    0.14353289,
    0.190429341,
    0.169674353,
    0.101777924,
    0.073093444,
    0.051824626
};

double GenomeIndex::biasTable20[] = { // hg19
    4.922970244,
    2.660600899,
    1.9864751,
    3.586580375,
    2.420989791,
    1.693873492,
    1.331391556,
    1.749676175,
    2.108511951,
    0.227632769,
    1.049277819,
    1.630525847,
    2.55406231,
    2.058152803,
    1.317711152,
    2.46183336,
    2.626472068,
    1.859238461,
    1.146895385,
    1.587268723,
    1.769776976,
    1.333202885,
    1.155074968,
    1.186720475,
    1.575011955,
    0.193049085,
    1.126120466,
    1.342655466,
    1.210268,
    1.344885824,
    0.934194883,
    1.44103675,
    1.690183593,
    1.574098824,
    1.148671789,
    1.617385652,
    0.173309864,
    0.185498085,
    0.148721337,
    0.239210033,
    1.177288539,
    0.15242625,
    0.81634334,
    1.090498963,
    0.970685942,
    1.291386288,
    0.937397126,
    1.422505816,
    1.977316859,
    1.066737965,
    0.949758834,
    1.866469906,
    1.500027885,
    1.168969497,
    0.939662409,
    1.449476808,
    1.240342741,
    0.123157497,
    0.828955894,
    1.279735827,
    1.543363185,
    1.106004813,
    1.219248756,
    2.459059775,
    1.976334121,
    1.281366978,
    0.740405582,
    1.191117703,
    1.318880842,
    1.098638398,
    0.744130407,
    0.808243156,
    0.93955551,
    0.129210194,
    0.522507495,
    0.741712527,
    0.799483379,
    0.887220686,
    0.500234599,
    0.910043745,
    1.271146436,
    1.058078152,
    0.553852622,
    0.716600928,
    0.972352508,
    0.772545028,
    0.642022014,
    0.629862353,
    0.867270849,
    0.156697485,
    0.626862892,
    0.784263546,
    0.558531298,
    0.748293763,
    0.456662,
    0.64988653,
    0.813490519,
    0.930091097,
    0.550346329,
    0.724637788,
    0.092373059,
    0.139063688,
    0.102066939,
    0.103068936,
    0.775656365,
    0.129981582,
    0.556694509,
    0.725657411,
    0.519126461,
    0.853135267,
    0.560002753,
    0.749812058,
    0.745690972,
    0.513185232,
    0.370428871,
    0.661810196,
    0.767954564,
    0.719780322,
    0.489792833,
    0.713353967,
    0.625313181,
    0.065301696,
    0.420977826,
    0.637027537,
    0.59903687,
    0.563433319,
    0.515835598,
    0.9871343,
    1.300675501,
    0.779434069,
    0.538590927,
    0.768772547,
    1.027977869,
    0.845387442,
    0.704970785,
    0.739752518,
    0.926644291,
    0.137077975,
    0.525918395,
    0.690414951,
    0.706382426,
    0.711710086,
    0.558745341,
    0.93077313,
    0.088558635,
    0.099620906,
    0.052488319,
    0.068845527,
    0.087253404,
    0.117752315,
    0.091848437,
    0.07083883,
    0.084215509,
    0.031844534,
    0.087568798,
    0.08473548,
    0.074290286,
    0.123329433,
    0.069948465,
    0.094724352,
    0.658821589,
    0.710694625,
    0.516040012,
    0.591989684,
    0.072061234,
    0.086796757,
    0.077433286,
    0.079979363,
    0.632332949,
    0.093797348,
    0.398317645,
    0.51624614,
    0.410768871,
    0.605927951,
    0.50534536,
    0.600456589,
    0.552455262,
    0.376246471,
    0.334092204,
    0.498488797,
    0.630615625,
    0.562405047,
    0.470893954,
    0.590240617,
    0.580976782,
    0.06330668,
    0.447380212,
    0.601771123,
    0.484002896,
    0.452204059,
    0.513530003,
    0.780068283,
    0.998281193,
    0.45168115,
    0.34634179,
    0.650617851,
    0.452993399,
    0.291711244,
    0.249793868,
    0.326005484,
    0.469267781,
    0.045846696,
    0.231359633,
    0.36483739,
    0.557724331,
    0.38660484,
    0.29603242,
    0.637194414,
    0.556249286,
    0.393968725,
    0.251595732,
    0.35206261,
    0.371359791,
    0.314344904,
    0.23689946,
    0.262328084,
    0.315361997,
    0.031217583,
    0.220550167,
    0.301364568,
    0.295256381,
    0.30840441,
    0.207649475,
    0.341425815,
    0.304852827,
    0.266274052,
    0.190556049,
    0.274063657,
    0.022253882,
    0.021211982,
    0.015655264,
    0.02447559,
    0.225141854,
    0.020083665,
    0.15033021,
    0.211987868,
    0.193750295,
    0.209041041,
    0.173276325,
    0.242271838,
    0.284439325,
    0.138096536,
    0.119946849,
    0.212531422,
    0.143600947,
    0.103066732,
    0.080137264,
    0.115026548,
    0.130745789,
    0.008641208,
    0.07773905,
    0.109165535,
    0.108390638,
    0.059779251,
    0.044487853,
    0.031818095
};

double GenomeIndex::biasTable21[] = {       // hg19
    (double)24935131 / 3137161264 * 1024.,
    (double)12043061 / 3137161264 * 1024.,
    (double)9659231 / 3137161264 * 1024.,
    (double)18258032 / 3137161264 * 1024.,
    (double)11943759 / 3137161264 * 1024.,
    (double)7420857 / 3137161264 * 1024.,
    (double)6201456 / 3137161264 * 1024.,
    (double)8214051 / 3137161264 * 1024.,
    (double)11005557 / 3137161264 * 1024.,
    (double)1115450 / 3137161264 * 1024.,
    (double)5081205 / 3137161264 * 1024.,
    (double)7989872 / 3137161264 * 1024.,
    (double)15140511 / 3137161264 * 1024.,
    (double)11401800 / 3137161264 * 1024.,
    (double)6936136 / 3137161264 * 1024.,
    (double)12602401 / 3137161264 * 1024.,
    (double)11863490 / 3137161264 * 1024.,
    (double)7215823 / 3137161264 * 1024.,
    (double)4917985 / 3137161264 * 1024.,
    (double)6735024 / 3137161264 * 1024.,
    (double)7490093 / 3137161264 * 1024.,
    (double)4878176 / 3137161264 * 1024.,
    (double)4296645 / 3137161264 * 1024.,
    (double)4582253 / 3137161264 * 1024.,
    (double)6746986 / 3137161264 * 1024.,
    (double)662163 / 3137161264 * 1024.,
    (double)4211006 / 3137161264 * 1024.,
    (double)5052194 / 3137161264 * 1024.,
    (double)5821832 / 3137161264 * 1024.,
    (double)5659153 / 3137161264 * 1024.,
    (double)4196826 / 3137161264 * 1024.,
    (double)6306675 / 3137161264 * 1024.,
    (double)8512713 / 3137161264 * 1024.,
    (double)6200149 / 3137161264 * 1024.,
    (double)4782574 / 3137161264 * 1024.,
    (double)7221794 / 3137161264 * 1024.,
    (double)740629 / 3137161264 * 1024.,
    (double)610876 / 3137161264 * 1024.,
    (double)513568 / 3137161264 * 1024.,
    (double)949450 / 3137161264 * 1024.,
    (double)5103932 / 3137161264 * 1024.,
    (double)514909 / 3137161264 * 1024.,
    (double)3205805 / 3137161264 * 1024.,
    (double)4305711 / 3137161264 * 1024.,
    (double)4679753 / 3137161264 * 1024.,
    (double)5408673 / 3137161264 * 1024.,
    (double)4203260 / 3137161264 * 1024.,
    (double)6187057 / 3137161264 * 1024.,
    (double)11923597 / 3137161264 * 1024.,
    (double)5530868 / 3137161264 * 1024.,
    (double)5072855 / 3137161264 * 1024.,
    (double)10232400 / 3137161264 * 1024.,
    (double)8145766 / 3137161264 * 1024.,
    (double)5527147 / 3137161264 * 1024.,
    (double)4692618 / 3137161264 * 1024.,
    (double)7558756 / 3137161264 * 1024.,
    (double)6274907 / 3137161264 * 1024.,
    (double)556486 / 3137161264 * 1024.,
    (double)3853809 / 3137161264 * 1024.,
    (double)5873043 / 3137161264 * 1024.,
    (double)8591298 / 3137161264 * 1024.,
    (double)5412825 / 3137161264 * 1024.,
    (double)5946452 / 3137161264 * 1024.,
    (double)11464418 / 3137161264 * 1024.,
    (double)13579581 / 3137161264 * 1024.,
    (double)7594654 / 3137161264 * 1024.,
    (double)4656903 / 3137161264 * 1024.,
    (double)7584972 / 3137161264 * 1024.,
    (double)8453363 / 3137161264 * 1024.,
    (double)5932749 / 3137161264 * 1024.,
    (double)4246409 / 3137161264 * 1024.,
    (double)4771848 / 3137161264 * 1024.,
    (double)6156873 / 3137161264 * 1024.,
    (double)778521 / 3137161264 * 1024.,
    (double)3074450 / 3137161264 * 1024.,
    (double)4411346 / 3137161264 * 1024.,
    (double)5486074 / 3137161264 * 1024.,
    (double)5669329 / 3137161264 * 1024.,
    (double)3137104 / 3137161264 * 1024.,
    (double)5659803 / 3137161264 * 1024.,
    (double)8332275 / 3137161264 * 1024.,
    (double)6133495 / 3137161264 * 1024.,
    (double)3402488 / 3137161264 * 1024.,
    (double)4440451 / 3137161264 * 1024.,
    (double)5683530 / 3137161264 * 1024.,
    (double)3977006 / 3137161264 * 1024.,
    (double)3525183 / 3137161264 * 1024.,
    (double)3498630 / 3137161264 * 1024.,
    (double)5589277 / 3137161264 * 1024.,
    (double)820904 / 3137161264 * 1024.,
    (double)3591038 / 3137161264 * 1024.,
    (double)4617758 / 3137161264 * 1024.,
    (double)3686974 / 3137161264 * 1024.,
    (double)4479472 / 3137161264 * 1024.,
    (double)2826504 / 3137161264 * 1024.,
    (double)3933389 / 3137161264 * 1024.,
    (double)5724901 / 3137161264 * 1024.,
    (double)5701560 / 3137161264 * 1024.,
    (double)3612457 / 3137161264 * 1024.,
    (double)4686872 / 3137161264 * 1024.,
    (double)613718 / 3137161264 * 1024.,
    (double)648480 / 3137161264 * 1024.,
    (double)520172 / 3137161264 * 1024.,
    (double)609276 / 3137161264 * 1024.,
    (double)5336666 / 3137161264 * 1024.,
    (double)739837 / 3137161264 * 1024.,
    (double)3533632 / 3137161264 * 1024.,
    (double)4564377 / 3137161264 * 1024.,
    (double)3470691 / 3137161264 * 1024.,
    (double)5210236 / 3137161264 * 1024.,
    (double)3655455 / 3137161264 * 1024.,
    (double)4470169 / 3137161264 * 1024.,
    (double)5128609 / 3137161264 * 1024.,
    (double)3437475 / 3137161264 * 1024.,
    (double)2385467 / 3137161264 * 1024.,
    (double)4195239 / 3137161264 * 1024.,
    (double)5245137 / 3137161264 * 1024.,
    (double)4304452 / 3137161264 * 1024.,
    (double)3052493 / 3137161264 * 1024.,
    (double)4249474 / 3137161264 * 1024.,
    (double)4394030 / 3137161264 * 1024.,
    (double)410963 / 3137161264 * 1024.,
    (double)2777801 / 3137161264 * 1024.,
    (double)4102630 / 3137161264 * 1024.,
    (double)4208108 / 3137161264 * 1024.,
    (double)3684897 / 3137161264 * 1024.,
    (double)3616115 / 3137161264 * 1024.,
    (double)6613668 / 3137161264 * 1024.,
    (double)8756112 / 3137161264 * 1024.,
    (double)4218547 / 3137161264 * 1024.,
    (double)3328460 / 3137161264 * 1024.,
    (double)5162053 / 3137161264 * 1024.,
    (double)6638765 / 3137161264 * 1024.,
    (double)4493639 / 3137161264 * 1024.,
    (double)3978534 / 3137161264 * 1024.,
    (double)4637836 / 3137161264 * 1024.,
    (double)6661477 / 3137161264 * 1024.,
    (double)834998 / 3137161264 * 1024.,
    (double)2842502 / 3137161264 * 1024.,
    (double)4148236 / 3137161264 * 1024.,
    (double)5481531 / 3137161264 * 1024.,
    (double)4815460 / 3137161264 * 1024.,
    (double)3467359 / 3137161264 * 1024.,
    (double)6665696 / 3137161264 * 1024.,
    (double)674189 / 3137161264 * 1024.,
    (double)577817 / 3137161264 * 1024.,
    (double)358003 / 3137161264 * 1024.,
    (double)532467 / 3137161264 * 1024.,
    (double)637679 / 3137161264 * 1024.,
    (double)623564 / 3137161264 * 1024.,
    (double)501027 / 3137161264 * 1024.,
    (double)531387 / 3137161264 * 1024.,
    (double)617860 / 3137161264 * 1024.,
    (double)147090 / 3137161264 * 1024.,
    (double)512124 / 3137161264 * 1024.,
    (double)569465 / 3137161264 * 1024.,
    (double)669458 / 3137161264 * 1024.,
    (double)983639 / 3137161264 * 1024.,
    (double)512017 / 3137161264 * 1024.,
    (double)809167 / 3137161264 * 1024.,
    (double)4031988 / 3137161264 * 1024.,
    (double)3662596 / 3137161264 * 1024.,
    (double)3315446 / 3137161264 * 1024.,
    (double)3809441 / 3137161264 * 1024.,
    (double)447258 / 3137161264 * 1024.,
    (double)404462 / 3137161264 * 1024.,
    (double)498100 / 3137161264 * 1024.,
    (double)562653 / 3137161264 * 1024.,
    (double)3833825 / 3137161264 * 1024.,
    (double)537346 / 3137161264 * 1024.,
    (double)2623082 / 3137161264 * 1024.,
    (double)3189550 / 3137161264 * 1024.,
    (double)2764369 / 3137161264 * 1024.,
    (double)3820859 / 3137161264 * 1024.,
    (double)3256243 / 3137161264 * 1024.,
    (double)3750110 / 3137161264 * 1024.,
    (double)3813384 / 3137161264 * 1024.,
    (double)2418665 / 3137161264 * 1024.,
    (double)2291197 / 3137161264 * 1024.,
    (double)3664590 / 3137161264 * 1024.,
    (double)4692468 / 3137161264 * 1024.,
    (double)3695615 / 3137161264 * 1024.,
    (double)3371131 / 3137161264 * 1024.,
    (double)4411814 / 3137161264 * 1024.,
    (double)4146699 / 3137161264 * 1024.,
    (double)462646 / 3137161264 * 1024.,
    (double)2977993 / 3137161264 * 1024.,
    (double)4147729 / 3137161264 * 1024.,
    (double)3950894 / 3137161264 * 1024.,
    (double)3699212 / 3137161264 * 1024.,
    (double)3935229 / 3137161264 * 1024.,
    (double)6316250 / 3137161264 * 1024.,
    (double)10494830 / 3137161264 * 1024.,
    (double)4190992 / 3137161264 * 1024.,
    (double)3430944 / 3137161264 * 1024.,
    (double)7212905 / 3137161264 * 1024.,
    (double)4556733 / 3137161264 * 1024.,
    (double)2738212 / 3137161264 * 1024.,
    (double)2600782 / 3137161264 * 1024.,
    (double)3514724 / 3137161264 * 1024.,
    (double)5313191 / 3137161264 * 1024.,
    (double)535904 / 3137161264 * 1024.,
    (double)2346643 / 3137161264 * 1024.,
    (double)3790638 / 3137161264 * 1024.,
    (double)7370200 / 3137161264 * 1024.,
    (double)4838779 / 3137161264 * 1024.,
    (double)3548102 / 3137161264 * 1024.,
    (double)8258262 / 3137161264 * 1024.,
    (double)6771970 / 3137161264 * 1024.,
    (double)4465262 / 3137161264 * 1024.,
    (double)3137008 / 3137161264 * 1024.,
    (double)4529885 / 3137161264 * 1024.,
    (double)4621771 / 3137161264 * 1024.,
    (double)3526556 / 3137161264 * 1024.,
    (double)3017888 / 3137161264 * 1024.,
    (double)3463126 / 3137161264 * 1024.,
    (double)4379136 / 3137161264 * 1024.,
    (double)430025 / 3137161264 * 1024.,
    (double)2917800 / 3137161264 * 1024.,
    (double)4058498 / 3137161264 * 1024.,
    (double)4739637 / 3137161264 * 1024.,
    (double)4823998 / 3137161264 * 1024.,
    (double)3277038 / 3137161264 * 1024.,
    (double)5542792 / 3137161264 * 1024.,
    (double)4309508 / 3137161264 * 1024.,
    (double)3723148 / 3137161264 * 1024.,
    (double)3204731 / 3137161264 * 1024.,
    (double)4362066 / 3137161264 * 1024.,
    (double)390881 / 3137161264 * 1024.,
    (double)323313 / 3137161264 * 1024.,
    (double)351678 / 3137161264 * 1024.,
    (double)473073 / 3137161264 * 1024.,
    (double)3664246 / 3137161264 * 1024.,
    (double)364112 / 3137161264 * 1024.,
    (double)2631045 / 3137161264 * 1024.,
    (double)3639109 / 3137161264 * 1024.,
    (double)3407914 / 3137161264 * 1024.,
    (double)4154533 / 3137161264 * 1024.,
    (double)3672190 / 3137161264 * 1024.,
    (double)4875087 / 3137161264 * 1024.,
    (double)6444367 / 3137161264 * 1024.,
    (double)3502434 / 3137161264 * 1024.,
    (double)3224376 / 3137161264 * 1024.,
    (double)6427812 / 3137161264 * 1024.,
    (double)3948444 / 3137161264 * 1024.,
    (double)2868160 / 3137161264 * 1024.,
    (double)2816237 / 3137161264 * 1024.,
    (double)4236734 / 3137161264 * 1024.,
    (double)5404138 / 3137161264 * 1024.,
    (double)434316 / 3137161264 * 1024.,
    (double)3657909 / 3137161264 * 1024.,
    (double)5850941 / 3137161264 * 1024.,
    (double)7564957 / 3137161264 * 1024.,
    (double)5897540 / 3137161264 * 1024.,
    (double)6274744 / 3137161264 * 1024.,
    (double)11968420 / 3137161264 * 1024.,
    (double)9219286 / 3137161264 * 1024.,
    (double)5610693 / 3137161264 * 1024.,
    (double)3883131 / 3137161264 * 1024.,
    (double)6428256 / 3137161264 * 1024.,
    (double)5317917 / 3137161264 * 1024.,
    (double)4164655 / 3137161264 * 1024.,
    (double)3091733 / 3137161264 * 1024.,
    (double)3534457 / 3137161264 * 1024.,
    (double)3770321 / 3137161264 * 1024.,
    (double)456567 / 3137161264 * 1024.,
    (double)1971182 / 3137161264 * 1024.,
    (double)3038280 / 3137161264 * 1024.,
    (double)4112735 / 3137161264 * 1024.,
    (double)3981576 / 3137161264 * 1024.,
    (double)2487254 / 3137161264 * 1024.,
    (double)4412078 / 3137161264 * 1024.,
    (double)5840133 / 3137161264 * 1024.,
    (double)4546812 / 3137161264 * 1024.,
    (double)2828778 / 3137161264 * 1024.,
    (double)3519809 / 3137161264 * 1024.,
    (double)4330145 / 3137161264 * 1024.,
    (double)3545397 / 3137161264 * 1024.,
    (double)3154980 / 3137161264 * 1024.,
    (double)2845836 / 3137161264 * 1024.,
    (double)3247485 / 3137161264 * 1024.,
    (double)500330 / 3137161264 * 1024.,
    (double)2637948 / 3137161264 * 1024.,
    (double)3014833 / 3137161264 * 1024.,
    (double)2250118 / 3137161264 * 1024.,
    (double)2911401 / 3137161264 * 1024.,
    (double)2079947 / 3137161264 * 1024.,
    (double)2991218 / 3137161264 * 1024.,
    (double)3139629 / 3137161264 * 1024.,
    (double)3351497 / 3137161264 * 1024.,
    (double)2309545 / 3137161264 * 1024.,
    (double)2963388 / 3137161264 * 1024.,
    (double)360215 / 3137161264 * 1024.,
    (double)466500 / 3137161264 * 1024.,
    (double)340868 / 3137161264 * 1024.,
    (double)431143 / 3137161264 * 1024.,
    (double)2223917 / 3137161264 * 1024.,
    (double)311721 / 3137161264 * 1024.,
    (double)1775477 / 3137161264 * 1024.,
    (double)2181035 / 3137161264 * 1024.,
    (double)1813881 / 3137161264 * 1024.,
    (double)2580906 / 3137161264 * 1024.,
    (double)2004391 / 3137161264 * 1024.,
    (double)2875145 / 3137161264 * 1024.,
    (double)3331467 / 3137161264 * 1024.,
    (double)1933074 / 3137161264 * 1024.,
    (double)1719760 / 3137161264 * 1024.,
    (double)2982854 / 3137161264 * 1024.,
    (double)3296190 / 3137161264 * 1024.,
    (double)2934186 / 3137161264 * 1024.,
    (double)2048154 / 3137161264 * 1024.,
    (double)2750976 / 3137161264 * 1024.,
    (double)2230697 / 3137161264 * 1024.,
    (double)255269 / 3137161264 * 1024.,
    (double)1540850 / 3137161264 * 1024.,
    (double)2239520 / 3137161264 * 1024.,
    (double)2711038 / 3137161264 * 1024.,
    (double)2097945 / 3137161264 * 1024.,
    (double)2303663 / 3137161264 * 1024.,
    (double)4396680 / 3137161264 * 1024.,
    (double)5900982 / 3137161264 * 1024.,
    (double)4518840 / 3137161264 * 1024.,
    (double)2205905 / 3137161264 * 1024.,
    (double)3359087 / 3137161264 * 1024.,
    (double)4245434 / 3137161264 * 1024.,
    (double)4139672 / 3137161264 * 1024.,
    (double)2452137 / 3137161264 * 1024.,
    (double)2483714 / 3137161264 * 1024.,
    (double)2782814 / 3137161264 * 1024.,
    (double)434666 / 3137161264 * 1024.,
    (double)1527146 / 3137161264 * 1024.,
    (double)2158838 / 3137161264 * 1024.,
    (double)2179833 / 3137161264 * 1024.,
    (double)2728447 / 3137161264 * 1024.,
    (double)1474236 / 3137161264 * 1024.,
    (double)2627397 / 3137161264 * 1024.,
    (double)4076870 / 3137161264 * 1024.,
    (double)3851077 / 3137161264 * 1024.,
    (double)1963873 / 3137161264 * 1024.,
    (double)2309595 / 3137161264 * 1024.,
    (double)3165842 / 3137161264 * 1024.,
    (double)2192359 / 3137161264 * 1024.,
    (double)2263515 / 3137161264 * 1024.,
    (double)2094706 / 3137161264 * 1024.,
    (double)2835751 / 3137161264 * 1024.,
    (double)637071 / 3137161264 * 1024.,
    (double)2059274 / 3137161264 * 1024.,
    (double)2601992 / 3137161264 * 1024.,
    (double)1650014 / 3137161264 * 1024.,
    (double)2640051 / 3137161264 * 1024.,
    (double)1619816 / 3137161264 * 1024.,
    (double)2079760 / 3137161264 * 1024.,
    (double)2672778 / 3137161264 * 1024.,
    (double)3651255 / 3137161264 * 1024.,
    (double)1997698 / 3137161264 * 1024.,
    (double)2423082 / 3137161264 * 1024.,
    (double)374096 / 3137161264 * 1024.,
    (double)702349 / 3137161264 * 1024.,
    (double)445681 / 3137161264 * 1024.,
    (double)401337 / 3137161264 * 1024.,
    (double)2717251 / 3137161264 * 1024.,
    (double)581850 / 3137161264 * 1024.,
    (double)1974065 / 3137161264 * 1024.,
    (double)2520609 / 3137161264 * 1024.,
    (double)1630419 / 3137161264 * 1024.,
    (double)3404052 / 3137161264 * 1024.,
    (double)2116183 / 3137161264 * 1024.,
    (double)2619048 / 3137161264 * 1024.,
    (double)2156894 / 3137161264 * 1024.,
    (double)1734204 / 3137161264 * 1024.,
    (double)1154001 / 3137161264 * 1024.,
    (double)1838342 / 3137161264 * 1024.,
    (double)2584856 / 3137161264 * 1024.,
    (double)2922004 / 3137161264 * 1024.,
    (double)1680218 / 3137161264 * 1024.,
    (double)2064101 / 3137161264 * 1024.,
    (double)2059561 / 3137161264 * 1024.,
    (double)250388 / 3137161264 * 1024.,
    (double)1373836 / 3137161264 * 1024.,
    (double)2011391 / 3137161264 * 1024.,
    (double)1749190 / 3137161264 * 1024.,
    (double)1884384 / 3137161264 * 1024.,
    (double)1586521 / 3137161264 * 1024.,
    (double)2949211 / 3137161264 * 1024.,
    (double)3771306 / 3137161264 * 1024.,
    (double)2471949 / 3137161264 * 1024.,
    (double)1592392 / 3137161264 * 1024.,
    (double)2355300 / 3137161264 * 1024.,
    (double)3444814 / 3137161264 * 1024.,
    (double)3136281 / 3137161264 * 1024.,
    (double)2561797 / 3137161264 * 1024.,
    (double)2410262 / 3137161264 * 1024.,
    (double)2763881 / 3137161264 * 1024.,
    (double)463710 / 3137161264 * 1024.,
    (double)1613716 / 3137161264 * 1024.,
    (double)2101544 / 3137161264 * 1024.,
    (double)2069920 / 3137161264 * 1024.,
    (double)2417695 / 3137161264 * 1024.,
    (double)1769070 / 3137161264 * 1024.,
    (double)2915512 / 3137161264 * 1024.,
    (double)276880 / 3137161264 * 1024.,
    (double)407316 / 3137161264 * 1024.,
    (double)202752 / 3137161264 * 1024.,
    (double)258693 / 3137161264 * 1024.,
    (double)356247 / 3137161264 * 1024.,
    (double)612598 / 3137161264 * 1024.,
    (double)452193 / 3137161264 * 1024.,
    (double)293712 / 3137161264 * 1024.,
    (double)321384 / 3137161264 * 1024.,
    (double)202636 / 3137161264 * 1024.,
    (double)418457 / 3137161264 * 1024.,
    (double)341717 / 3137161264 * 1024.,
    (double)215360 / 3137161264 * 1024.,
    (double)528227 / 3137161264 * 1024.,
    (double)270886 / 3137161264 * 1024.,
    (double)306283 / 3137161264 * 1024.,
    (double)2382464 / 3137161264 * 1024.,
    (double)2808744 / 3137161264 * 1024.,
    (double)2193383 / 3137161264 * 1024.,
    (double)2255155 / 3137161264 * 1024.,
    (double)345127 / 3137161264 * 1024.,
    (double)478348 / 3137161264 * 1024.,
    (double)417253 / 3137161264 * 1024.,
    (double)336736 / 3137161264 * 1024.,
    (double)2419339 / 3137161264 * 1024.,
    (double)485655 / 3137161264 * 1024.,
    (double)1838932 / 3137161264 * 1024.,
    (double)2158802 / 3137161264 * 1024.,
    (double)1482404 / 3137161264 * 1024.,
    (double)2839209 / 3137161264 * 1024.,
    (double)2307556 / 3137161264 * 1024.,
    (double)2416200 / 3137161264 * 1024.,
    (double)1951008 / 3137161264 * 1024.,
    (double)1367462 / 3137161264 * 1024.,
    (double)1291103 / 3137161264 * 1024.,
    (double)1871759 / 3137161264 * 1024.,
    (double)2686876 / 3137161264 * 1024.,
    (double)2918549 / 3137161264 * 1024.,
    (double)2344807 / 3137161264 * 1024.,
    (double)2569037 / 3137161264 * 1024.,
    (double)2286707 / 3137161264 * 1024.,
    (double)288042 / 3137161264 * 1024.,
    (double)1897381 / 3137161264 * 1024.,
    (double)2478455 / 3137161264 * 1024.,
    (double)1813581 / 3137161264 * 1024.,
    (double)1946252 / 3137161264 * 1024.,
    (double)2265926 / 3137161264 * 1024.,
    (double)3329298 / 3137161264 * 1024.,
    (double)3451532 / 3137161264 * 1024.,
    (double)1950493 / 3137161264 * 1024.,
    (double)1464925 / 3137161264 * 1024.,
    (double)2488360 / 3137161264 * 1024.,
    (double)2092306 / 3137161264 * 1024.,
    (double)1535671 / 3137161264 * 1024.,
    (double)1256044 / 3137161264 * 1024.,
    (double)1536348 / 3137161264 * 1024.,
    (double)1920259 / 3137161264 * 1024.,
    (double)197984 / 3137161264 * 1024.,
    (double)1011301 / 3137161264 * 1024.,
    (double)1523007 / 3137161264 * 1024.,
    (double)2296734 / 3137161264 * 1024.,
    (double)1841105 / 3137161264 * 1024.,
    (double)1398150 / 3137161264 * 1024.,
    (double)2897231 / 3137161264 * 1024.,
    (double)3001426 / 3137161264 * 1024.,
    (double)2629399 / 3137161264 * 1024.,
    (double)1723373 / 3137161264 * 1024.,
    (double)2285739 / 3137161264 * 1024.,
    (double)2412398 / 3137161264 * 1024.,
    (double)2588943 / 3137161264 * 1024.,
    (double)1916168 / 3137161264 * 1024.,
    (double)2094518 / 3137161264 * 1024.,
    (double)2018281 / 3137161264 * 1024.,
    (double)305728 / 3137161264 * 1024.,
    (double)1650130 / 3137161264 * 1024.,
    (double)2186701 / 3137161264 * 1024.,
    (double)1872307 / 3137161264 * 1024.,
    (double)2924447 / 3137161264 * 1024.,
    (double)1717178 / 3137161264 * 1024.,
    (double)2602856 / 3137161264 * 1024.,
    (double)1907514 / 3137161264 * 1024.,
    (double)2045911 / 3137161264 * 1024.,
    (double)1663968 / 3137161264 * 1024.,
    (double)2102331 / 3137161264 * 1024.,
    (double)174316 / 3137161264 * 1024.,
    (double)227310 / 3137161264 * 1024.,
    (double)171690 / 3137161264 * 1024.,
    (double)215754 / 3137161264 * 1024.,
    (double)1656505 / 3137161264 * 1024.,
    (double)206209 / 3137161264 * 1024.,
    (double)1425654 / 3137161264 * 1024.,
    (double)1875433 / 3137161264 * 1024.,
    (double)1442607 / 3137161264 * 1024.,
    (double)2070952 / 3137161264 * 1024.,
    (double)1930955 / 3137161264 * 1024.,
    (double)2456673 / 3137161264 * 1024.,
    (double)2385636 / 3137161264 * 1024.,
    (double)1455893 / 3137161264 * 1024.,
    (double)1343337 / 3137161264 * 1024.,
    (double)2204407 / 3137161264 * 1024.,
    (double)1929652 / 3137161264 * 1024.,
    (double)1742612 / 3137161264 * 1024.,
    (double)1350272 / 3137161264 * 1024.,
    (double)1945992 / 3137161264 * 1024.,
    (double)2140351 / 3137161264 * 1024.,
    (double)198850 / 3137161264 * 1024.,
    (double)1602081 / 3137161264 * 1024.,
    (double)2534473 / 3137161264 * 1024.,
    (double)2685121 / 3137161264 * 1024.,
    (double)2562420 / 3137161264 * 1024.,
    (double)2660527 / 3137161264 * 1024.,
    (double)4617694 / 3137161264 * 1024.,
    (double)5861485 / 3137161264 * 1024.,
    (double)3726599 / 3137161264 * 1024.,
    (double)2602009 / 3137161264 * 1024.,
    (double)4344827 / 3137161264 * 1024.,
    (double)3099510 / 3137161264 * 1024.,
    (double)2515504 / 3137161264 * 1024.,
    (double)1743224 / 3137161264 * 1024.,
    (double)2365666 / 3137161264 * 1024.,
    (double)2824036 / 3137161264 * 1024.,
    (double)309428 / 3137161264 * 1024.,
    (double)1510936 / 3137161264 * 1024.,
    (double)2140606 / 3137161264 * 1024.,
    (double)2786358 / 3137161264 * 1024.,
    (double)2457931 / 3137161264 * 1024.,
    (double)1545041 / 3137161264 * 1024.,
    (double)2872192 / 3137161264 * 1024.,
    (double)4450044 / 3137161264 * 1024.,
    (double)3764581 / 3137161264 * 1024.,
    (double)1997498 / 3137161264 * 1024.,
    (double)2739539 / 3137161264 * 1024.,
    (double)3333850 / 3137161264 * 1024.,
    (double)2811928 / 3137161264 * 1024.,
    (double)2313936 / 3137161264 * 1024.,
    (double)2228558 / 3137161264 * 1024.,
    (double)3188961 / 3137161264 * 1024.,
    (double)451220 / 3137161264 * 1024.,
    (double)2547703 / 3137161264 * 1024.,
    (double)2705777 / 3137161264 * 1024.,
    (double)2108928 / 3137161264 * 1024.,
    (double)2912421 / 3137161264 * 1024.,
    (double)1696602 / 3137161264 * 1024.,
    (double)2556776 / 3137161264 * 1024.,
    (double)2805735 / 3137161264 * 1024.,
    (double)3310351 / 3137161264 * 1024.,
    (double)2448721 / 3137161264 * 1024.,
    (double)2938376 / 3137161264 * 1024.,
    (double)351987 / 3137161264 * 1024.,
    (double)447291 / 3137161264 * 1024.,
    (double)358136 / 3137161264 * 1024.,
    (double)519469 / 3137161264 * 1024.,
    (double)2341222 / 3137161264 * 1024.,
    (double)385281 / 3137161264 * 1024.,
    (double)1689745 / 3137161264 * 1024.,
    (double)2099905 / 3137161264 * 1024.,
    (double)1599529 / 3137161264 * 1024.,
    (double)2771453 / 3137161264 * 1024.,
    (double)1752866 / 3137161264 * 1024.,
    (double)2579107 / 3137161264 * 1024.,
    (double)2739689 / 3137161264 * 1024.,
    (double)1807315 / 3137161264 * 1024.,
    (double)1477477 / 3137161264 * 1024.,
    (double)2814471 / 3137161264 * 1024.,
    (double)2453993 / 3137161264 * 1024.,
    (double)2268535 / 3137161264 * 1024.,
    (double)1701659 / 3137161264 * 1024.,
    (double)2506746 / 3137161264 * 1024.,
    (double)2412249 / 3137161264 * 1024.,
    (double)270032 / 3137161264 * 1024.,
    (double)1710422 / 3137161264 * 1024.,
    (double)2596159 / 3137161264 * 1024.,
    (double)2534749 / 3137161264 * 1024.,
    (double)2102912 / 3137161264 * 1024.,
    (double)2348226 / 3137161264 * 1024.,
    (double)4814959 / 3137161264 * 1024.,
    (double)352410 / 3137161264 * 1024.,
    (double)313349 / 3137161264 * 1024.,
    (double)177302 / 3137161264 * 1024.,
    (double)263085 / 3137161264 * 1024.,
    (double)356785 / 3137161264 * 1024.,
    (double)419515 / 3137161264 * 1024.,
    (double)231901 / 3137161264 * 1024.,
    (double)244516 / 3137161264 * 1024.,
    (double)233417 / 3137161264 * 1024.,
    (double)57875 / 3137161264 * 1024.,
    (double)170422 / 3137161264 * 1024.,
    (double)199019 / 3137161264 * 1024.,
    (double)191735 / 3137161264 * 1024.,
    (double)271125 / 3137161264 * 1024.,
    (double)150443 / 3137161264 * 1024.,
    (double)248085 / 3137161264 * 1024.,
    (double)318328 / 3137161264 * 1024.,
    (double)389815 / 3137161264 * 1024.,
    (double)175876 / 3137161264 * 1024.,
    (double)203381 / 3137161264 * 1024.,
    (double)396955 / 3137161264 * 1024.,
    (double)500444 / 3137161264 * 1024.,
    (double)335048 / 3137161264 * 1024.,
    (double)259720 / 3137161264 * 1024.,
    (double)310870 / 3137161264 * 1024.,
    (double)144573 / 3137161264 * 1024.,
    (double)395455 / 3137161264 * 1024.,
    (double)313243 / 3137161264 * 1024.,
    (double)174513 / 3137161264 * 1024.,
    (double)328047 / 3137161264 * 1024.,
    (double)174791 / 3137161264 * 1024.,
    (double)215172 / 3137161264 * 1024.,
    (double)209430 / 3137161264 * 1024.,
    (double)360653 / 3137161264 * 1024.,
    (double)228546 / 3137161264 * 1024.,
    (double)222685 / 3137161264 * 1024.,
    (double)57007 / 3137161264 * 1024.,
    (double)137518 / 3137161264 * 1024.,
    (double)131102 / 3137161264 * 1024.,
    (double)63649 / 3137161264 * 1024.,
    (double)289081 / 3137161264 * 1024.,
    (double)120418 / 3137161264 * 1024.,
    (double)338151 / 3137161264 * 1024.,
    (double)314420 / 3137161264 * 1024.,
    (double)159893 / 3137161264 * 1024.,
    (double)373425 / 3137161264 * 1024.,
    (double)248228 / 3137161264 * 1024.,
    (double)279630 / 3137161264 * 1024.,
    (double)272828 / 3137161264 * 1024.,
    (double)212013 / 3137161264 * 1024.,
    (double)145995 / 3137161264 * 1024.,
    (double)280475 / 3137161264 * 1024.,
    (double)368864 / 3137161264 * 1024.,
    (double)470158 / 3137161264 * 1024.,
    (double)303339 / 3137161264 * 1024.,
    (double)382369 / 3137161264 * 1024.,
    (double)259366 / 3137161264 * 1024.,
    (double)51549 / 3137161264 * 1024.,
    (double)234925 / 3137161264 * 1024.,
    (double)327695 / 3137161264 * 1024.,
    (double)239881 / 3137161264 * 1024.,
    (double)254715 / 3137161264 * 1024.,
    (double)244275 / 3137161264 * 1024.,
    (double)446534 / 3137161264 * 1024.,
    (double)3098816 / 3137161264 * 1024.,
    (double)2157250 / 3137161264 * 1024.,
    (double)1396788 / 3137161264 * 1024.,
    (double)1675264 / 3137161264 * 1024.,
    (double)2482715 / 3137161264 * 1024.,
    (double)2534553 / 3137161264 * 1024.,
    (double)2101903 / 3137161264 * 1024.,
    (double)1820694 / 3137161264 * 1024.,
    (double)2385287 / 3137161264 * 1024.,
    (double)434681 / 3137161264 * 1024.,
    (double)1801585 / 3137161264 * 1024.,
    (double)1927052 / 3137161264 * 1024.,
    (double)1600088 / 3137161264 * 1024.,
    (double)1970702 / 3137161264 * 1024.,
    (double)1632938 / 3137161264 * 1024.,
    (double)2269597 / 3137161264 * 1024.,
    (double)240626 / 3137161264 * 1024.,
    (double)337147 / 3137161264 * 1024.,
    (double)160465 / 3137161264 * 1024.,
    (double)164172 / 3137161264 * 1024.,
    (double)234291 / 3137161264 * 1024.,
    (double)363658 / 3137161264 * 1024.,
    (double)316548 / 3137161264 * 1024.,
    (double)171353 / 3137161264 * 1024.,
    (double)272012 / 3137161264 * 1024.,
    (double)122774 / 3137161264 * 1024.,
    (double)331915 / 3137161264 * 1024.,
    (double)245010 / 3137161264 * 1024.,
    (double)187204 / 3137161264 * 1024.,
    (double)363177 / 3137161264 * 1024.,
    (double)225324 / 3137161264 * 1024.,
    (double)230176 / 3137161264 * 1024.,
    (double)1993854 / 3137161264 * 1024.,
    (double)2564954 / 3137161264 * 1024.,
    (double)1680945 / 3137161264 * 1024.,
    (double)1694960 / 3137161264 * 1024.,
    (double)251631 / 3137161264 * 1024.,
    (double)372152 / 3137161264 * 1024.,
    (double)297221 / 3137161264 * 1024.,
    (double)249608 / 3137161264 * 1024.,
    (double)2080352 / 3137161264 * 1024.,
    (double)354009 / 3137161264 * 1024.,
    (double)1086069 / 3137161264 * 1024.,
    (double)1489863 / 3137161264 * 1024.,
    (double)1129825 / 3137161264 * 1024.,
    (double)1974929 / 3137161264 * 1024.,
    (double)1585020 / 3137161264 * 1024.,
    (double)1749384 / 3137161264 * 1024.,
    (double)1606154 / 3137161264 * 1024.,
    (double)1233408 / 3137161264 * 1024.,
    (double)1020352 / 3137161264 * 1024.,
    (double)1326607 / 3137161264 * 1024.,
    (double)1968715 / 3137161264 * 1024.,
    (double)2198120 / 3137161264 * 1024.,
    (double)1689955 / 3137161264 * 1024.,
    (double)1833953 / 3137161264 * 1024.,
    (double)2106145 / 3137161264 * 1024.,
    (double)288037 / 3137161264 * 1024.,
    (double)1935620 / 3137161264 * 1024.,
    (double)2157443 / 3137161264 * 1024.,
    (double)1458555 / 3137161264 * 1024.,
    (double)1678518 / 3137161264 * 1024.,
    (double)1872732 / 3137161264 * 1024.,
    (double)2543537 / 3137161264 * 1024.,
    (double)2584179 / 3137161264 * 1024.,
    (double)1493840 / 3137161264 * 1024.,
    (double)1055552 / 3137161264 * 1024.,
    (double)1850586 / 3137161264 * 1024.,
    (double)1595078 / 3137161264 * 1024.,
    (double)1141891 / 3137161264 * 1024.,
    (double)871213 / 3137161264 * 1024.,
    (double)1088093 / 3137161264 * 1024.,
    (double)1605741 / 3137161264 * 1024.,
    (double)176350 / 3137161264 * 1024.,
    (double)994145 / 3137161264 * 1024.,
    (double)1448188 / 3137161264 * 1024.,
    (double)1702204 / 3137161264 * 1024.,
    (double)1418887 / 3137161264 * 1024.,
    (double)1039901 / 3137161264 * 1024.,
    (double)2141789 / 3137161264 * 1024.,
    (double)2654636 / 3137161264 * 1024.,
    (double)2212879 / 3137161264 * 1024.,
    (double)1298527 / 3137161264 * 1024.,
    (double)1726710 / 3137161264 * 1024.,
    (double)2101953 / 3137161264 * 1024.,
    (double)2061896 / 3137161264 * 1024.,
    (double)1500714 / 3137161264 * 1024.,
    (double)1392705 / 3137161264 * 1024.,
    (double)1975357 / 3137161264 * 1024.,
    (double)252271 / 3137161264 * 1024.,
    (double)1657089 / 3137161264 * 1024.,
    (double)1975380 / 3137161264 * 1024.,
    (double)1699461 / 3137161264 * 1024.,
    (double)2167276 / 3137161264 * 1024.,
    (double)1460598 / 3137161264 * 1024.,
    (double)2060384 / 3137161264 * 1024.,
    (double)1913305 / 3137161264 * 1024.,
    (double)2030587 / 3137161264 * 1024.,
    (double)1407226 / 3137161264 * 1024.,
    (double)1858921 / 3137161264 * 1024.,
    (double)181105 / 3137161264 * 1024.,
    (double)231149 / 3137161264 * 1024.,
    (double)158310 / 3137161264 * 1024.,
    (double)195934 / 3137161264 * 1024.,
    (double)1872599 / 3137161264 * 1024.,
    (double)223902 / 3137161264 * 1024.,
    (double)1516511 / 3137161264 * 1024.,
    (double)1883820 / 3137161264 * 1024.,
    (double)1460894 / 3137161264 * 1024.,
    (double)2128645 / 3137161264 * 1024.,
    (double)1707539 / 3137161264 * 1024.,
    (double)2191233 / 3137161264 * 1024.,
    (double)1973912 / 3137161264 * 1024.,
    (double)1248324 / 3137161264 * 1024.,
    (double)1096962 / 3137161264 * 1024.,
    (double)1727444 / 3137161264 * 1024.,
    (double)1596971 / 3137161264 * 1024.,
    (double)1447561 / 3137161264 * 1024.,
    (double)1130242 / 3137161264 * 1024.,
    (double)1479210 / 3137161264 * 1024.,
    (double)2077177 / 3137161264 * 1024.,
    (double)193410 / 3137161264 * 1024.,
    (double)1843155 / 3137161264 * 1024.,
    (double)2362133 / 3137161264 * 1024.,
    (double)2225004 / 3137161264 * 1024.,
    (double)2108649 / 3137161264 * 1024.,
    (double)2186826 / 3137161264 * 1024.,
    (double)3418973 / 3137161264 * 1024.,
    (double)5281150 / 3137161264 * 1024.,
    (double)2278626 / 3137161264 * 1024.,
    (double)1716347 / 3137161264 * 1024.,
    (double)3642827 / 3137161264 * 1024.,
    (double)1937640 / 3137161264 * 1024.,
    (double)1186296 / 3137161264 * 1024.,
    (double)990353 / 3137161264 * 1024.,
    (double)1535541 / 3137161264 * 1024.,
    (double)1842762 / 3137161264 * 1024.,
    (double)167715 / 3137161264 * 1024.,
    (double)844903 / 3137161264 * 1024.,
    (double)1506366 / 3137161264 * 1024.,
    (double)2594167 / 3137161264 * 1024.,
    (double)1731344 / 3137161264 * 1024.,
    (double)1196899 / 3137161264 * 1024.,
    (double)2769871 / 3137161264 * 1024.,
    (double)2268668 / 3137161264 * 1024.,
    (double)1277178 / 3137161264 * 1024.,
    (double)820995 / 3137161264 * 1024.,
    (double)1357749 / 3137161264 * 1024.,
    (double)1276082 / 3137161264 * 1024.,
    (double)803255 / 3137161264 * 1024.,
    (double)687304 / 3137161264 * 1024.,
    (double)923069 / 3137161264 * 1024.,
    (double)1246209 / 3137161264 * 1024.,
    (double)101059 / 3137161264 * 1024.,
    (double)706136 / 3137161264 * 1024.,
    (double)1066127 / 3137161264 * 1024.,
    (double)1134932 / 3137161264 * 1024.,
    (double)957245 / 3137161264 * 1024.,
    (double)698971 / 3137161264 * 1024.,
    (double)1310048 / 3137161264 * 1024.,
    (double)1736445 / 3137161264 * 1024.,
    (double)1355749 / 3137161264 * 1024.,
    (double)957296 / 3137161264 * 1024.,
    (double)1790462 / 3137161264 * 1024.,
    (double)140662 / 3137161264 * 1024.,
    (double)119101 / 3137161264 * 1024.,
    (double)89107 / 3137161264 * 1024.,
    (double)210497 / 3137161264 * 1024.,
    (double)1103721 / 3137161264 * 1024.,
    (double)99376 / 3137161264 * 1024.,
    (double)629885 / 3137161264 * 1024.,
    (double)1056345 / 3137161264 * 1024.,
    (double)1073268 / 3137161264 * 1024.,
    (double)1123462 / 3137161264 * 1024.,
    (double)823404 / 3137161264 * 1024.,
    (double)1545805 / 3137161264 * 1024.,
    (double)2343464 / 3137161264 * 1024.,
    (double)1163325 / 3137161264 * 1024.,
    (double)1098305 / 3137161264 * 1024.,
    (double)2491293 / 3137161264 * 1024.,
    (double)1432746 / 3137161264 * 1024.,
    (double)964044 / 3137161264 * 1024.,
    (double)860949 / 3137161264 * 1024.,
    (double)1603901 / 3137161264 * 1024.,
    (double)1356657 / 3137161264 * 1024.,
    (double)103553 / 3137161264 * 1024.,
    (double)816520 / 3137161264 * 1024.,
    (double)1451957 / 3137161264 * 1024.,
    (double)1998466 / 3137161264 * 1024.,
    (double)1296587 / 3137161264 * 1024.,
    (double)1393998 / 3137161264 * 1024.,
    (double)3472183 / 3137161264 * 1024.,
    (double)2720363 / 3137161264 * 1024.,
    (double)1589015 / 3137161264 * 1024.,
    (double)991466 / 3137161264 * 1024.,
    (double)1752416 / 3137161264 * 1024.,
    (double)1703383 / 3137161264 * 1024.,
    (double)1317968 / 3137161264 * 1024.,
    (double)910236 / 3137161264 * 1024.,
    (double)1107025 / 3137161264 * 1024.,
    (double)1286004 / 3137161264 * 1024.,
    (double)135644 / 3137161264 * 1024.,
    (double)710916 / 3137161264 * 1024.,
    (double)1089553 / 3137161264 * 1024.,
    (double)1208576 / 3137161264 * 1024.,
    (double)1178968 / 3137161264 * 1024.,
    (double)700604 / 3137161264 * 1024.,
    (double)1418534 / 3137161264 * 1024.,
    (double)1762413 / 3137161264 * 1024.,
    (double)1288581 / 3137161264 * 1024.,
    (double)655472 / 3137161264 * 1024.,
    (double)1001161 / 3137161264 * 1024.,
    (double)1374010 / 3137161264 * 1024.,
    (double)1101148 / 3137161264 * 1024.,
    (double)731453 / 3137161264 * 1024.,
    (double)853309 / 3137161264 * 1024.,
    (double)1112453 / 3137161264 * 1024.,
    (double)122666 / 3137161264 * 1024.,
    (double)759463 / 3137161264 * 1024.,
    (double)1035413 / 3137161264 * 1024.,
    (double)832065 / 3137161264 * 1024.,
    (double)928459 / 3137161264 * 1024.,
    (double)561777 / 3137161264 * 1024.,
    (double)962928 / 3137161264 * 1024.,
    (double)1136437 / 3137161264 * 1024.,
    (double)1098113 / 3137161264 * 1024.,
    (double)672108 / 3137161264 * 1024.,
    (double)1063169 / 3137161264 * 1024.,
    (double)91045 / 3137161264 * 1024.,
    (double)112146 / 3137161264 * 1024.,
    (double)80236 / 3137161264 * 1024.,
    (double)114415 / 3137161264 * 1024.,
    (double)1009046 / 3137161264 * 1024.,
    (double)108996 / 3137161264 * 1024.,
    (double)661653 / 3137161264 * 1024.,
    (double)1005147 / 3137161264 * 1024.,
    (double)818444 / 3137161264 * 1024.,
    (double)1090323 / 3137161264 * 1024.,
    (double)719625 / 3137161264 * 1024.,
    (double)1191965 / 3137161264 * 1024.,
    (double)1253940 / 3137161264 * 1024.,
    (double)753009 / 3137161264 * 1024.,
    (double)598631 / 3137161264 * 1024.,
    (double)1173223 / 3137161264 * 1024.,
    (double)1119142 / 3137161264 * 1024.,
    (double)948659 / 3137161264 * 1024.,
    (double)689704 / 3137161264 * 1024.,
    (double)1197256 / 3137161264 * 1024.,
    (double)948698 / 3137161264 * 1024.,
    (double)78455 / 3137161264 * 1024.,
    (double)613809 / 3137161264 * 1024.,
    (double)1029821 / 3137161264 * 1024.,
    (double)1016608 / 3137161264 * 1024.,
    (double)894794 / 3137161264 * 1024.,
    (double)813694 / 3137161264 * 1024.,
    (double)1685724 / 3137161264 * 1024.,
    (double)1501722 / 3137161264 * 1024.,
    (double)797788 / 3137161264 * 1024.,
    (double)599925 / 3137161264 * 1024.,
    (double)914451 / 3137161264 * 1024.,
    (double)1063806 / 3137161264 * 1024.,
    (double)749289 / 3137161264 * 1024.,
    (double)646375 / 3137161264 * 1024.,
    (double)850593 / 3137161264 * 1024.,
    (double)967184 / 3137161264 * 1024.,
    (double)110795 / 3137161264 * 1024.,
    (double)536343 / 3137161264 * 1024.,
    (double)803447 / 3137161264 * 1024.,
    (double)840854 / 3137161264 * 1024.,
    (double)745310 / 3137161264 * 1024.,
    (double)650152 / 3137161264 * 1024.,
    (double)1178873 / 3137161264 * 1024.,
    (double)86783 / 3137161264 * 1024.,
    (double)71210 / 3137161264 * 1024.,
    (double)41407 / 3137161264 * 1024.,
    (double)66915 / 3137161264 * 1024.,
    (double)68441 / 3137161264 * 1024.,
    (double)79101 / 3137161264 * 1024.,
    (double)55769 / 3137161264 * 1024.,
    (double)63052 / 3137161264 * 1024.,
    (double)60651 / 3137161264 * 1024.,
    (double)11004 / 3137161264 * 1024.,
    (double)55291 / 3137161264 * 1024.,
    (double)72361 / 3137161264 * 1024.,
    (double)68804 / 3137161264 * 1024.,
    (double)83900 / 3137161264 * 1024.,
    (double)56397 / 3137161264 * 1024.,
    (double)92792 / 3137161264 * 1024.,
    (double)793804 / 3137161264 * 1024.,
    (double)748961 / 3137161264 * 1024.,
    (double)494604 / 3137161264 * 1024.,
    (double)734656 / 3137161264 * 1024.,
    (double)59440 / 3137161264 * 1024.,
    (double)58048 / 3137161264 * 1024.,
    (double)48211 / 3137161264 * 1024.,
    (double)81385 / 3137161264 * 1024.,
    (double)731949 / 3137161264 * 1024.,
    (double)74151 / 3137161264 * 1024.,
    (double)462895 / 3137161264 * 1024.,
    (double)647107 / 3137161264 * 1024.,
    (double)548580 / 3137161264 * 1024.,
    (double)669248 / 3137161264 * 1024.,
    (double)585497 / 3137161264 * 1024.,
    (double)826965 / 3137161264 * 1024.,
    (double)784656 / 3137161264 * 1024.,
    (double)507538 / 3137161264 * 1024.,
    (double)446419 / 3137161264 * 1024.,
    (double)696666 / 3137161264 * 1024.,
    (double)766036 / 3137161264 * 1024.,
    (double)584074 / 3137161264 * 1024.,
    (double)506914 / 3137161264 * 1024.,
    (double)774134 / 3137161264 * 1024.,
    (double)781297 / 3137161264 * 1024.,
    (double)61909 / 3137161264 * 1024.,
    (double)542412 / 3137161264 * 1024.,
    (double)849504 / 3137161264 * 1024.,
    (double)693314 / 3137161264 * 1024.,
    (double)563761 / 3137161264 * 1024.,
    (double)675394 / 3137161264 * 1024.,
    (double)1112082 / 3137161264 * 1024.,
    (double)1606853 / 3137161264 * 1024.,
    (double)620032 / 3137161264 * 1024.,
    (double)479387 / 3137161264 * 1024.,
    (double)939135 / 3137161264 * 1024.,
    (double)600181 / 3137161264 * 1024.,
    (double)367492 / 3137161264 * 1024.,
    (double)312028 / 3137161264 * 1024.,
    (double)445327 / 3137161264 * 1024.,
    (double)631092 / 3137161264 * 1024.,
    (double)53815 / 3137161264 * 1024.,
    (double)304327 / 3137161264 * 1024.,
    (double)525705 / 3137161264 * 1024.,
    (double)794022 / 3137161264 * 1024.,
    (double)505718 / 3137161264 * 1024.,
    (double)421938 / 3137161264 * 1024.,
    (double)1004448 / 3137161264 * 1024.,
    (double)691831 / 3137161264 * 1024.,
    (double)399584 / 3137161264 * 1024.,
    (double)256028 / 3137161264 * 1024.,
    (double)420059 / 3137161264 * 1024.,
    (double)416258 / 3137161264 * 1024.,
    (double)308824 / 3137161264 * 1024.,
    (double)237524 / 3137161264 * 1024.,
    (double)312524 / 3137161264 * 1024.,
    (double)362026 / 3137161264 * 1024.,
    (double)25244 / 3137161264 * 1024.,
    (double)238679 / 3137161264 * 1024.,
    (double)374227 / 3137161264 * 1024.,
    (double)383360 / 3137161264 * 1024.,
    (double)330038 / 3137161264 * 1024.,
    (double)250253 / 3137161264 * 1024.,
    (double)491824 / 3137161264 * 1024.,
    (double)530360 / 3137161264 * 1024.,
    (double)402546 / 3137161264 * 1024.,
    (double)272302 / 3137161264 * 1024.,
    (double)470055 / 3137161264 * 1024.,
    (double)30235 / 3137161264 * 1024.,
    (double)24792 / 3137161264 * 1024.,
    (double)16003 / 3137161264 * 1024.,
    (double)35373 / 3137161264 * 1024.,
    (double)383827 / 3137161264 * 1024.,
    (double)26436 / 3137161264 * 1024.,
    (double)233016 / 3137161264 * 1024.,
    (double)368732 / 3137161264 * 1024.,
    (double)359228 / 3137161264 * 1024.,
    (double)337554 / 3137161264 * 1024.,
    (double)278523 / 3137161264 * 1024.,
    (double)445715 / 3137161264 * 1024.,
    (double)595489 / 3137161264 * 1024.,
    (double)238070 / 3137161264 * 1024.,
    (double)212777 / 3137161264 * 1024.,
    (double)416345 / 3137161264 * 1024.,
    (double)256314 / 3137161264 * 1024.,
    (double)173633 / 3137161264 * 1024.,
    (double)134358 / 3137161264 * 1024.,
    (double)215905 / 3137161264 * 1024.,
    (double)239844 / 3137161264 * 1024.,
    (double)12151 / 3137161264 * 1024.,
    (double)136682 / 3137161264 * 1024.,
    (double)209358 / 3137161264 * 1024.,
    (double)210974 / 3137161264 * 1024.,
    (double)96287 / 3137161264 * 1024.,
    (double)78520 / 3137161264 * 1024.,
    (double)58068 / 3137161264 * 1024.
};

double GenomeIndex::biasTable22[] = { // hg19
    (double)11801384./3137161264. * 4096.,
    (double)4561397./3137161264. * 4096.,
    (double)3366965./3137161264. * 4096.,
    (double)6907427./3137161264. * 4096.,
    (double)4602473./3137161264. * 4096.,
    (double)2565494./3137161264. * 4096.,
    (double)2178641./3137161264. * 4096.,
    (double)3018627./3137161264. * 4096.,
    (double)4539319./3137161264. * 4096.,
    (double)423184./3137161264. * 4096.,
    (double)1935286./3137161264. * 4096.,
    (double)3016887./3137161264. * 4096.,
    (double)6530765./3137161264. * 4096.,
    (double)4492830./3137161264. * 4096.,
    (double)2776188./3137161264. * 4096.,
    (double)5063961./3137161264. * 4096.,
    (double)5104920./3137161264. * 4096.,
    (double)2691421./3137161264. * 4096.,
    (double)1877482./3137161264. * 4096.,
    (double)2608862./3137161264. * 4096.,
    (double)2799267./3137161264. * 4096.,
    (double)1693193./3137161264. * 4096.,
    (double)1486086./3137161264. * 4096.,
    (double)1561484./3137161264. * 4096.,
    (double)2709154./3137161264. * 4096.,
    (double)221872./3137161264. * 4096.,
    (double)1488741./3137161264. * 4096.,
    (double)1870098./3137161264. * 4096.,
    (double)2351620./3137161264. * 4096.,
    (double)2044627./3137161264. * 4096.,
    (double)1547147./3137161264. * 4096.,
    (double)2406922./3137161264. * 4096.,
    (double)3896018./3137161264. * 4096.,
    (double)2485308./3137161264. * 4096.,
    (double)1973697./3137161264. * 4096.,
    (double)2940214./3137161264. * 4096.,
    (double)306733./3137161264. * 4096.,
    (double)243096./3137161264. * 4096.,
    (double)195902./3137161264. * 4096.,
    (double)377619./3137161264. * 4096.,
    (double)2111840./3137161264. * 4096.,
    (double)197079./3137161264. * 4096.,
    (double)1219742./3137161264. * 4096.,
    (double)1638636./3137161264. * 4096.,
    (double)2009680./3137161264. * 4096.,
    (double)2185374./3137161264. * 4096.,
    (double)1600074./3137161264. * 4096.,
    (double)2342228./3137161264. * 4096.,
    (double)5860279./3137161264. * 4096.,
    (double)2439204./3137161264. * 4096.,
    (double)2425278./3137161264. * 4096.,
    (double)4935168./3137161264. * 4096.,
    (double)3599476./3137161264. * 4096.,
    (double)2376989./3137161264. * 4096.,
    (double)2110823./3137161264. * 4096.,
    (double)3542104./3137161264. * 4096.,
    (double)2777164./3137161264. * 4096.,
    (double)225893./3137161264. * 4096.,
    (double)1573128./3137161264. * 4096.,
    (double)2472142./3137161264. * 4096.,
    (double)3939266./3137161264. * 4096.,
    (double)2292886./3137161264. * 4096.,
    (double)2381686./3137161264. * 4096.,
    (double)4323464./3137161264. * 4096.,
    (double)5411153./3137161264. * 4096.,
    (double)2530021./3137161264. * 4096.,
    (double)1605751./3137161264. * 4096.,
    (double)2641088./3137161264. * 4096.,
    (double)2742648./3137161264. * 4096.,
    (double)1792619./3137161264. * 4096.,
    (double)1270293./3137161264. * 4096.,
    (double)1526311./3137161264. * 4096.,
    (double)2247482./3137161264. * 4096.,
    (double)238129./3137161264. * 4096.,
    (double)1013361./3137161264. * 4096.,
    (double)1503803./3137161264. * 4096.,
    (double)1989685./3137161264. * 4096.,
    (double)1883022./3137161264. * 4096.,
    (double)1071855./3137161264. * 4096.,
    (double)1895822./3137161264. * 4096.,
    (double)3104454./3137161264. * 4096.,
    (double)1926486./3137161264. * 4096.,
    (double)1107908./3137161264. * 4096.,
    (double)1484918./3137161264. * 4096.,
    (double)1789613./3137161264. * 4096.,
    (double)1187535./3137161264. * 4096.,
    (double)976016./3137161264. * 4096.,
    (double)986629./3137161264. * 4096.,
    (double)1805597./3137161264. * 4096.,
    (double)193923./3137161264. * 4096.,
    (double)1022519./3137161264. * 4096.,
    (double)1337650./3137161264. * 4096.,
    (double)1226134./3137161264. * 4096.,
    (double)1289923./3137161264. * 4096.,
    (double)903574./3137161264. * 4096.,
    (double)1221486./3137161264. * 4096.,
    (double)2179053./3137161264. * 4096.,
    (double)1885193./3137161264. * 4096.,
    (double)1171489./3137161264. * 4096.,
    (double)1610497./3137161264. * 4096.,
    (double)193576./3137161264. * 4096.,
    (double)172065./3137161264. * 4096.,
    (double)130067./3137161264. * 4096.,
    (double)174748./3137161264. * 4096.,
    (double)1751211./3137161264. * 4096.,
    (double)185078./3137161264. * 4096.,
    (double)1010997./3137161264. * 4096.,
    (double)1315943./3137161264. * 4096.,
    (double)1137228./3137161264. * 4096.,
    (double)1545535./3137161264. * 4096.,
    (double)1041668./3137161264. * 4096.,
    (double)1393756./3137161264. * 4096.,
    (double)2040720./3137161264. * 4096.,
    (double)1281475./3137161264. * 4096.,
    (double)939168./3137161264. * 4096.,
    (double)1649552./3137161264. * 4096.,
    (double)1863645./3137161264. * 4096.,
    (double)1384318./3137161264. * 4096.,
    (double)1041986./3137161264. * 4096.,
    (double)1462491./3137161264. * 4096.,
    (double)1705193./3137161264. * 4096.,
    (double)137781./3137161264. * 4096.,
    (double)971452./3137161264. * 4096.,
    (double)1436970./3137161264. * 4096.,
    (double)1629308./3137161264. * 4096.,
    (double)1308710./3137161264. * 4096.,
    (double)1234961./3137161264. * 4096.,
    (double)2235689./3137161264. * 4096.,
    (double)3813768./3137161264. * 4096.,
    (double)1565893./3137161264. * 4096.,
    (double)1384933./3137161264. * 4096.,
    (double)1992428./3137161264. * 4096.,
    (double)2250098./3137161264. * 4096.,
    (double)1322772./3137161264. * 4096.,
    (double)1247013./3137161264. * 4096.,
    (double)1466316./3137161264. * 4096.,
    (double)2133034./3137161264. * 4096.,
    (double)252917./3137161264. * 4096.,
    (double)941840./3137161264. * 4096.,
    (double)1521957./3137161264. * 4096.,
    (double)1960816./3137161264. * 4096.,
    (double)1652824./3137161264. * 4096.,
    (double)1267415./3137161264. * 4096.,
    (double)2462455./3137161264. * 4096.,
    (double)261584./3137161264. * 4096.,
    (double)185552./3137161264. * 4096.,
    (double)118773./3137161264. * 4096.,
    (double)179429./3137161264. * 4096.,
    (double)188230./3137161264. * 4096.,
    (double)161232./3137161264. * 4096.,
    (double)124730./3137161264. * 4096.,
    (double)139152./3137161264. * 4096.,
    (double)182373./3137161264. * 4096.,
    (double)33377./3137161264. * 4096.,
    (double)126252./3137161264. * 4096.,
    (double)174348./3137161264. * 4096.,
    (double)227192./3137161264. * 4096.,
    (double)288931./3137161264. * 4096.,
    (double)164544./3137161264. * 4096.,
    (double)274229./3137161264. * 4096.,
    (double)1557720./3137161264. * 4096.,
    (double)1234380./3137161264. * 4096.,
    (double)1111067./3137161264. * 4096.,
    (double)1287505./3137161264. * 4096.,
    (double)144337./3137161264. * 4096.,
    (double)114220./3137161264. * 4096.,
    (double)110049./3137161264. * 4096.,
    (double)150252./3137161264. * 4096.,
    (double)1288761./3137161264. * 4096.,
    (double)148395./3137161264. * 4096.,
    (double)801832./3137161264. * 4096.,
    (double)1019720./3137161264. * 4096.,
    (double)968770./3137161264. * 4096.,
    (double)1171779./3137161264. * 4096.,
    (double)1043838./3137161264. * 4096.,
    (double)1192453./3137161264. * 4096.,
    (double)1522376./3137161264. * 4096.,
    (double)926023./3137161264. * 4096.,
    (double)891601./3137161264. * 4096.,
    (double)1414828./3137161264. * 4096.,
    (double)1710652./3137161264. * 4096.,
    (double)1240218./3137161264. * 4096.,
    (double)1063906./3137161264. * 4096.,
    (double)1467138./3137161264. * 4096.,
    (double)1544971./3137161264. * 4096.,
    (double)150333./3137161264. * 4096.,
    (double)1060503./3137161264. * 4096.,
    (double)1521421./3137161264. * 4096.,
    (double)1391313./3137161264. * 4096.,
    (double)1301317./3137161264. * 4096.,
    (double)1364101./3137161264. * 4096.,
    (double)2231813./3137161264. * 4096.,
    (double)5332950./3137161264. * 4096.,
    (double)1913872./3137161264. * 4096.,
    (double)1604175./3137161264. * 4096.,
    (double)3462489./3137161264. * 4096.,
    (double)1964465./3137161264. * 4096.,
    (double)1094286./3137161264. * 4096.,
    (double)1106848./3137161264. * 4096.,
    (double)1451301./3137161264. * 4096.,
    (double)2320384./3137161264. * 4096.,
    (double)219343./3137161264. * 4096.,
    (double)976911./3137161264. * 4096.,
    (double)1649867./3137161264. * 4096.,
    (double)3102057./3137161264. * 4096.,
    (double)2012885./3137161264. * 4096.,
    (double)1592066./3137161264. * 4096.,
    (double)3792062./3137161264. * 4096.,
    (double)3138364./3137161264. * 4096.,
    (double)1897428./3137161264. * 4096.,
    (double)1340310./3137161264. * 4096.,
    (double)1912271./3137161264. * 4096.,
    (double)1884272./3137161264. * 4096.,
    (double)1302359./3137161264. * 4096.,
    (double)1139526./3137161264. * 4096.,
    (double)1286258./3137161264. * 4096.,
    (double)1840322./3137161264. * 4096.,
    (double)145865./3137161264. * 4096.,
    (double)1127472./3137161264. * 4096.,
    (double)1646303./3137161264. * 4096.,
    (double)2039336./3137161264. * 4096.,
    (double)1864010./3137161264. * 4096.,
    (double)1400307./3137161264. * 4096.,
    (double)2390564./3137161264. * 4096.,
    (double)1901959./3137161264. * 4096.,
    (double)1495345./3137161264. * 4096.,
    (double)1250726./3137161264. * 4096.,
    (double)1736289./3137161264. * 4096.,
    (double)154628./3137161264. * 4096.,
    (double)117730./3137161264. * 4096.,
    (double)125410./3137161264. * 4096.,
    (double)166843./3137161264. * 4096.,
    (double)1452824./3137161264. * 4096.,
    (double)118914./3137161264. * 4096.,
    (double)981208./3137161264. * 4096.,
    (double)1366761./3137161264. * 4096.,
    (double)1371147./3137161264. * 4096.,
    (double)1503951./3137161264. * 4096.,
    (double)1310138./3137161264. * 4096.,
    (double)1767048./3137161264. * 4096.,
    (double)2973395./3137161264. * 4096.,
    (double)1551604./3137161264. * 4096.,
    (double)1421372./3137161264. * 4096.,
    (double)2866086./3137161264. * 4096.,
    (double)1603489./3137161264. * 4096.,
    (double)1114672./3137161264. * 4096.,
    (double)1087649./3137161264. * 4096.,
    (double)1692776./3137161264. * 4096.,
    (double)2204353./3137161264. * 4096.,
    (double)154295./3137161264. * 4096.,
    (double)1399986./3137161264. * 4096.,
    (double)2293154./3137161264. * 4096.,
    (double)2973439./3137161264. * 4096.,
    (double)2169141./3137161264. * 4096.,
    (double)2241164./3137161264. * 4096.,
    (double)4414678./3137161264. * 4096.,
    (double)5363846./3137161264. * 4096.,
    (double)3045092./3137161264. * 4096.,
    (double)2070279./3137161264. * 4096.,
    (double)3459090./3137161264. * 4096.,
    (double)2608056./3137161264. * 4096.,
    (double)1904660./3137161264. * 4096.,
    (double)1481823./3137161264. * 4096.,
    (double)1716908./3137161264. * 4096.,
    (double)1978885./3137161264. * 4096.,
    (double)219478./3137161264. * 4096.,
    (double)968829./3137161264. * 4096.,
    (double)1564089./3137161264. * 4096.,
    (double)2166033./3137161264. * 4096.,
    (double)1994828./3137161264. * 4096.,
    (double)1288165./3137161264. * 4096.,
    (double)2274600./3137161264. * 4096.,
    (double)3062760./3137161264. * 4096.,
    (double)2430838./3137161264. * 4096.,
    (double)1371112./3137161264. * 4096.,
    (double)1767219./3137161264. * 4096.,
    (double)1967057./3137161264. * 4096.,
    (double)1486134./3137161264. * 4096.,
    (double)1309054./3137161264. * 4096.,
    (double)1260476./3137161264. * 4096.,
    (double)1575043./3137161264. * 4096.,
    (double)202361./3137161264. * 4096.,
    (double)1112120./3137161264. * 4096.,
    (double)1420595./3137161264. * 4096.,
    (double)1124267./3137161264. * 4096.,
    (double)1311111./3137161264. * 4096.,
    (double)956410./3137161264. * 4096.,
    (double)1448258./3137161264. * 4096.,
    (double)1712369./3137161264. * 4096.,
    (double)1796324./3137161264. * 4096.,
    (double)1233321./3137161264. * 4096.,
    (double)1543006./3137161264. * 4096.,
    (double)186022./3137161264. * 4096.,
    (double)240254./3137161264. * 4096.,
    (double)157259./3137161264. * 4096.,
    (double)211381./3137161264. * 4096.,
    (double)1144434./3137161264. * 4096.,
    (double)138539./3137161264. * 4096.,
    (double)849452./3137161264. * 4096.,
    (double)1005851./3137161264. * 4096.,
    (double)907838./3137161264. * 4096.,
    (double)1282068./3137161264. * 4096.,
    (double)945478./3137161264. * 4096.,
    (double)1345748./3137161264. * 4096.,
    (double)1909355./3137161264. * 4096.,
    (double)1046328./3137161264. * 4096.,
    (double)979448./3137161264. * 4096.,
    (double)1642218./3137161264. * 4096.,
    (double)1782329./3137161264. * 4096.,
    (double)1494025./3137161264. * 4096.,
    (double)1057127./3137161264. * 4096.,
    (double)1428402./3137161264. * 4096.,
    (double)1191404./3137161264. * 4096.,
    (double)132846./3137161264. * 4096.,
    (double)738367./3137161264. * 4096.,
    (double)1125313./3137161264. * 4096.,
    (double)1373088./3137161264. * 4096.,
    (double)1043904./3137161264. * 4096.,
    (double)1139117./3137161264. * 4096.,
    (double)2212564./3137161264. * 4096.,
    (double)3240206./3137161264. * 4096.,
    (double)2391797./3137161264. * 4096.,
    (double)1127421./3137161264. * 4096.,
    (double)1737579./3137161264. * 4096.,
    (double)2064249./3137161264. * 4096.,
    (double)1887304./3137161264. * 4096.,
    (double)1129855./3137161264. * 4096.,
    (double)1170571./3137161264. * 4096.,
    (double)1440459./3137161264. * 4096.,
    (double)196808./3137161264. * 4096.,
    (double)734878./3137161264. * 4096.,
    (double)1072252./3137161264. * 4096.,
    (double)1110790./3137161264. * 4096.,
    (double)1344959./3137161264. * 4096.,
    (double)753014./3137161264. * 4096.,
    (double)1309081./3137161264. * 4096.,
    (double)1992874./3137161264. * 4096.,
    (double)1806129./3137161264. * 4096.,
    (double)909312./3137161264. * 4096.,
    (double)1066322./3137161264. * 4096.,
    (double)1379015./3137161264. * 4096.,
    (double)843793./3137161264. * 4096.,
    (double)951376./3137161264. * 4096.,
    (double)853847./3137161264. * 4096.,
    (double)1296411./3137161264. * 4096.,
    (double)205792./3137161264. * 4096.,
    (double)904819./3137161264. * 4096.,
    (double)1165908./3137161264. * 4096.,
    (double)758829./3137161264. * 4096.,
    (double)1099318./3137161264. * 4096.,
    (double)752594./3137161264. * 4096.,
    (double)942668./3137161264. * 4096.,
    (double)1451066./3137161264. * 4096.,
    (double)1941852./3137161264. * 4096.,
    (double)1041024./3137161264. * 4096.,
    (double)1273119./3137161264. * 4096.,
    (double)171469./3137161264. * 4096.,
    (double)290072./3137161264. * 4096.,
    (double)183705./3137161264. * 4096.,
    (double)200984./3137161264. * 4096.,
    (double)1323919./3137161264. * 4096.,
    (double)250126./3137161264. * 4096.,
    (double)924166./3137161264. * 4096.,
    (double)1148604./3137161264. * 4096.,
    (double)798021./3137161264. * 4096.,
    (double)1755603./3137161264. * 4096.,
    (double)955620./3137161264. * 4096.,
    (double)1200568./3137161264. * 4096.,
    (double)1199358./3137161264. * 4096.,
    (double)930001./3137161264. * 4096.,
    (double)619476./3137161264. * 4096.,
    (double)988833./3137161264. * 4096.,
    (double)1343504./3137161264. * 4096.,
    (double)1364249./3137161264. * 4096.,
    (double)826618./3137161264. * 4096.,
    (double)1023771./3137161264. * 4096.,
    (double)1137625./3137161264. * 4096.,
    (double)124588./3137161264. * 4096.,
    (double)648804./3137161264. * 4096.,
    (double)967129./3137161264. * 4096.,
    (double)896168./3137161264. * 4096.,
    (double)948049./3137161264. * 4096.,
    (double)757909./3137161264. * 4096.,
    (double)1418487./3137161264. * 4096.,
    (double)2121795./3137161264. * 4096.,
    (double)1394482./3137161264. * 4096.,
    (double)921703./3137161264. * 4096.,
    (double)1357435./3137161264. * 4096.,
    (double)1738536./3137161264. * 4096.,
    (double)1478413./3137161264. * 4096.,
    (double)1328533./3137161264. * 4096.,
    (double)1211254./3137161264. * 4096.,
    (double)1420624./3137161264. * 4096.,
    (double)205666./3137161264. * 4096.,
    (double)853300./3137161264. * 4096.,
    (double)1179863./3137161264. * 4096.,
    (double)1059365./3137161264. * 4096.,
    (double)1183002./3137161264. * 4096.,
    (double)982771./3137161264. * 4096.,
    (double)1526796./3137161264. * 4096.,
    (double)150099./3137161264. * 4096.,
    (double)217534./3137161264. * 4096.,
    (double)102394./3137161264. * 4096.,
    (double)138782./3137161264. * 4096.,
    (double)142949./3137161264. * 4096.,
    (double)217562./3137161264. * 4096.,
    (double)168691./3137161264. * 4096.,
    (double)120408./3137161264. * 4096.,
    (double)142511./3137161264. * 4096.,
    (double)58873./3137161264. * 4096.,
    (double)159358./3137161264. * 4096.,
    (double)162425./3137161264. * 4096.,
    (double)106284./3137161264. * 4096.,
    (double)215437./3137161264. * 4096.,
    (double)132179./3137161264. * 4096.,
    (double)158230./3137161264. * 4096.,
    (double)1335294./3137161264. * 4096.,
    (double)1565059./3137161264. * 4096.,
    (double)1346918./3137161264. * 4096.,
    (double)1224659./3137161264. * 4096.,
    (double)176568./3137161264. * 4096.,
    (double)235164./3137161264. * 4096.,
    (double)180700./3137161264. * 4096.,
    (double)157000./3137161264. * 4096.,
    (double)1248818./3137161264. * 4096.,
    (double)206145./3137161264. * 4096.,
    (double)982858./3137161264. * 4096.,
    (double)1130942./3137161264. * 4096.,
    (double)763431./3137161264. * 4096.,
    (double)1455626./3137161264. * 4096.,
    (double)1231846./3137161264. * 4096.,
    (double)1186255./3137161264. * 4096.,
    (double)1054963./3137161264. * 4096.,
    (double)744184./3137161264. * 4096.,
    (double)733869./3137161264. * 4096.,
    (double)991947./3137161264. * 4096.,
    (double)1374040./3137161264. * 4096.,
    (double)1498160./3137161264. * 4096.,
    (double)1140543./3137161264. * 4096.,
    (double)1270658./3137161264. * 4096.,
    (double)1212798./3137161264. * 4096.,
    (double)139514./3137161264. * 4096.,
    (double)1023750./3137161264. * 4096.,
    (double)1329253./3137161264. * 4096.,
    (double)864889./3137161264. * 4096.,
    (double)949734./3137161264. * 4096.,
    (double)1139703./3137161264. * 4096.,
    (double)1575779./3137161264. * 4096.,
    (double)1959023./3137161264. * 4096.,
    (double)1054714./3137161264. * 4096.,
    (double)816834./3137161264. * 4096.,
    (double)1355745./3137161264. * 4096.,
    (double)1161608./3137161264. * 4096.,
    (double)798665./3137161264. * 4096.,
    (double)716065./3137161264. * 4096.,
    (double)819861./3137161264. * 4096.,
    (double)994661./3137161264. * 4096.,
    (double)95624./3137161264. * 4096.,
    (double)516924./3137161264. * 4096.,
    (double)811894./3137161264. * 4096.,
    (double)1163805./3137161264. * 4096.,
    (double)889858./3137161264. * 4096.,
    (double)722841./3137161264. * 4096.,
    (double)1492433./3137161264. * 4096.,
    (double)1670747./3137161264. * 4096.,
    (double)1454881./3137161264. * 4096.,
    (double)938265./3137161264. * 4096.,
    (double)1224217./3137161264. * 4096.,
    (double)1196070./3137161264. * 4096.,
    (double)1184503./3137161264. * 4096.,
    (double)943668./3137161264. * 4096.,
    (double)1007291./3137161264. * 4096.,
    (double)1017336./3137161264. * 4096.,
    (double)120490./3137161264. * 4096.,
    (double)814221./3137161264. * 4096.,
    (double)1156079./3137161264. * 4096.,
    (double)901980./3137161264. * 4096.,
    (double)1212070./3137161264. * 4096.,
    (double)856448./3137161264. * 4096.,
    (double)1342373./3137161264. * 4096.,
    (double)1123538./3137161264. * 4096.,
    (double)1151159./3137161264. * 4096.,
    (double)967499./3137161264. * 4096.,
    (double)1187746./3137161264. * 4096.,
    (double)97412./3137161264. * 4096.,
    (double)118277./3137161264. * 4096.,
    (double)84447./3137161264. * 4096.,
    (double)112433./3137161264. * 4096.,
    (double)929824./3137161264. * 4096.,
    (double)101973./3137161264. * 4096.,
    (double)754836./3137161264. * 4096.,
    (double)1000649./3137161264. * 4096.,
    (double)798915./3137161264. * 4096.,
    (double)1084250./3137161264. * 4096.,
    (double)996662./3137161264. * 4096.,
    (double)1264524./3137161264. * 4096.,
    (double)1388928./3137161264. * 4096.,
    (double)802891./3137161264. * 4096.,
    (double)799134./3137161264. * 4096.,
    (double)1258502./3137161264. * 4096.,
    (double)1056500./3137161264. * 4096.,
    (double)912327./3137161264. * 4096.,
    (double)708165./3137161264. * 4096.,
    (double)1047949./3137161264. * 4096.,
    (double)1242166./3137161264. * 4096.,
    (double)112059./3137161264. * 4096.,
    (double)897619./3137161264. * 4096.,
    (double)1429554./3137161264. * 4096.,
    (double)1486246./3137161264. * 4096.,
    (double)1394108./3137161264. * 4096.,
    (double)1474595./3137161264. * 4096.,
    (double)2428291./3137161264. * 4096.,
    (double)3446040./3137161264. * 4096.,
    (double)1859622./3137161264. * 4096.,
    (double)1413918./3137161264. * 4096.,
    (double)2275376./3137161264. * 4096.,
    (double)1386594./3137161264. * 4096.,
    (double)1057855./3137161264. * 4096.,
    (double)790483./3137161264. * 4096.,
    (double)1034697./3137161264. * 4096.,
    (double)1466420./3137161264. * 4096.,
    (double)152722./3137161264. * 4096.,
    (double)700963./3137161264. * 4096.,
    (double)1056658./3137161264. * 4096.,
    (double)1533107./3137161264. * 4096.,
    (double)1346930./3137161264. * 4096.,
    (double)799444./3137161264. * 4096.,
    (double)1558297./3137161264. * 4096.,
    (double)2373893./3137161264. * 4096.,
    (double)1853633./3137161264. * 4096.,
    (double)1091086./3137161264. * 4096.,
    (double)1473035./3137161264. * 4096.,
    (double)1401178./3137161264. * 4096.,
    (double)1135525./3137161264. * 4096.,
    (double)1030383./3137161264. * 4096.,
    (double)1000487./3137161264. * 4096.,
    (double)1566470./3137161264. * 4096.,
    (double)192745./3137161264. * 4096.,
    (double)1032871./3137161264. * 4096.,
    (double)1230163./3137161264. * 4096.,
    (double)1143386./3137161264. * 4096.,
    (double)1425159./3137161264. * 4096.,
    (double)828223./3137161264. * 4096.,
    (double)1281567./3137161264. * 4096.,
    (double)1610524./3137161264. * 4096.,
    (double)1745876./3137161264. * 4096.,
    (double)1810135./3137161264. * 4096.,
    (double)1692390./3137161264. * 4096.,
    (double)177054./3137161264. * 4096.,
    (double)216773./3137161264. * 4096.,
    (double)184919./3137161264. * 4096.,
    (double)264998./3137161264. * 4096.,
    (double)1070091./3137161264. * 4096.,
    (double)143493./3137161264. * 4096.,
    (double)736298./3137161264. * 4096.,
    (double)930560./3137161264. * 4096.,
    (double)817940./3137161264. * 4096.,
    (double)1321482./3137161264. * 4096.,
    (double)815608./3137161264. * 4096.,
    (double)1237618./3137161264. * 4096.,
    (double)1693339./3137161264. * 4096.,
    (double)1052326./3137161264. * 4096.,
    (double)1044603./3137161264. * 4096.,
    (double)1821812./3137161264. * 4096.,
    (double)1346994./3137161264. * 4096.,
    (double)1217142./3137161264. * 4096.,
    (double)967770./3137161264. * 4096.,
    (double)1369959./3137161264. * 4096.,
    (double)1265917./3137161264. * 4096.,
    (double)133416./3137161264. * 4096.,
    (double)825974./3137161264. * 4096.,
    (double)1292525./3137161264. * 4096.,
    (double)1462465./3137161264. * 4096.,
    (double)1161310./3137161264. * 4096.,
    (double)1266129./3137161264. * 4096.,
    (double)2888293./3137161264. * 4096.,
    (double)224613./3137161264. * 4096.,
    (double)185353./3137161264. * 4096.,
    (double)104577./3137161264. * 4096.,
    (double)164587./3137161264. * 4096.,
    (double)175129./3137161264. * 4096.,
    (double)187378./3137161264. * 4096.,
    (double)105000./3137161264. * 4096.,
    (double)117320./3137161264. * 4096.,
    (double)136901./3137161264. * 4096.,
    (double)29410./3137161264. * 4096.,
    (double)82615./3137161264. * 4096.,
    (double)108678./3137161264. * 4096.,
    (double)121943./3137161264. * 4096.,
    (double)170372./3137161264. * 4096.,
    (double)97117./3137161264. * 4096.,
    (double)147643./3137161264. * 4096.,
    (double)196721./3137161264. * 4096.,
    (double)219548./3137161264. * 4096.,
    (double)105699./3137161264. * 4096.,
    (double)124505./3137161264. * 4096.,
    (double)174874./3137161264. * 4096.,
    (double)206363./3137161264. * 4096.,
    (double)133406./3137161264. * 4096.,
    (double)113408./3137161264. * 4096.,
    (double)170818./3137161264. * 4096.,
    (double)48688./3137161264. * 4096.,
    (double)140433./3137161264. * 4096.,
    (double)145706./3137161264. * 4096.,
    (double)111436./3137161264. * 4096.,
    (double)197519./3137161264. * 4096.,
    (double)97653./3137161264. * 4096.,
    (double)128033./3137161264. * 4096.,
    (double)131474./3137161264. * 4096.,
    (double)201814./3137161264. * 4096.,
    (double)144668./3137161264. * 4096.,
    (double)142106./3137161264. * 4096.,
    (double)23836./3137161264. * 4096.,
    (double)50314./3137161264. * 4096.,
    (double)42542./3137161264. * 4096.,
    (double)30076./3137161264. * 4096.,
    (double)153769./3137161264. * 4096.,
    (double)43783./3137161264. * 4096.,
    (double)154708./3137161264. * 4096.,
    (double)155248./3137161264. * 4096.,
    (double)96338./3137161264. * 4096.,
    (double)210880./3137161264. * 4096.,
    (double)118880./3137161264. * 4096.,
    (double)142504./3137161264. * 4096.,
    (double)198770./3137161264. * 4096.,
    (double)145907./3137161264. * 4096.,
    (double)114997./3137161264. * 4096.,
    (double)212067./3137161264. * 4096.,
    (double)245095./3137161264. * 4096.,
    (double)291386./3137161264. * 4096.,
    (double)198006./3137161264. * 4096.,
    (double)255862./3137161264. * 4096.,
    (double)167530./3137161264. * 4096.,
    (double)27736./3137161264. * 4096.,
    (double)134649./3137161264. * 4096.,
    (double)184371./3137161264. * 4096.,
    (double)172725./3137161264. * 4096.,
    (double)177524./3137161264. * 4096.,
    (double)160043./3137161264. * 4096.,
    (double)302616./3137161264. * 4096.,
    (double)1520279./3137161264. * 4096.,
    (double)997143./3137161264. * 4096.,
    (double)708588./3137161264. * 4096.,
    (double)868546./3137161264. * 4096.,
    (double)1064496./3137161264. * 4096.,
    (double)980506./3137161264. * 4096.,
    (double)859131./3137161264. * 4096.,
    (double)775744./3137161264. * 4096.,
    (double)1305133./3137161264. * 4096.,
    (double)247021./3137161264. * 4096.,
    (double)845291./3137161264. * 4096.,
    (double)973812./3137161264. * 4096.,
    (double)882252./3137161264. * 4096.,
    (double)1052000./3137161264. * 4096.,
    (double)808724./3137161264. * 4096.,
    (double)1116492./3137161264. * 4096.,
    (double)129602./3137161264. * 4096.,
    (double)157546./3137161264. * 4096.,
    (double)75765./3137161264. * 4096.,
    (double)85552./3137161264. * 4096.,
    (double)96730./3137161264. * 4096.,
    (double)135263./3137161264. * 4096.,
    (double)102440./3137161264. * 4096.,
    (double)70648./3137161264. * 4096.,
    (double)171731./3137161264. * 4096.,
    (double)94134./3137161264. * 4096.,
    (double)128291./3137161264. * 4096.,
    (double)115031./3137161264. * 4096.,
    (double)112319./3137161264. * 4096.,
    (double)227759./3137161264. * 4096.,
    (double)107044./3137161264. * 4096.,
    (double)117343./3137161264. * 4096.,
    (double)966646./3137161264. * 4096.,
    (double)1267751./3137161264. * 4096.,
    (double)850439./3137161264. * 4096.,
    (double)815554./3137161264. * 4096.,
    (double)114901./3137161264. * 4096.,
    (double)182521./3137161264. * 4096.,
    (double)135415./3137161264. * 4096.,
    (double)111517./3137161264. * 4096.,
    (double)1065508./3137161264. * 4096.,
    (double)183945./3137161264. * 4096.,
    (double)643174./3137161264. * 4096.,
    (double)775007./3137161264. * 4096.,
    (double)591136./3137161264. * 4096.,
    (double)1034924./3137161264. * 4096.,
    (double)787336./3137161264. * 4096.,
    (double)811993./3137161264. * 4096.,
    (double)860897./3137161264. * 4096.,
    (double)645490./3137161264. * 4096.,
    (double)587373./3137161264. * 4096.,
    (double)721718./3137161264. * 4096.,
    (double)974938./3137161264. * 4096.,
    (double)1113869./3137161264. * 4096.,
    (double)865925./3137161264. * 4096.,
    (double)941669./3137161264. * 4096.,
    (double)1106121./3137161264. * 4096.,
    (double)163476./3137161264. * 4096.,
    (double)968843./3137161264. * 4096.,
    (double)1104555./3137161264. * 4096.,
    (double)750728./3137161264. * 4096.,
    (double)920178./3137161264. * 4096.,
    (double)906444./3137161264. * 4096.,
    (double)1219943./3137161264. * 4096.,
    (double)1480672./3137161264. * 4096.,
    (double)784940./3137161264. * 4096.,
    (double)575930./3137161264. * 4096.,
    (double)1032781./3137161264. * 4096.,
    (double)869019./3137161264. * 4096.,
    (double)573018./3137161264. * 4096.,
    (double)449003./3137161264. * 4096.,
    (double)550502./3137161264. * 4096.,
    (double)972292./3137161264. * 4096.,
    (double)101277./3137161264. * 4096.,
    (double)489053./3137161264. * 4096.,
    (double)770860./3137161264. * 4096.,
    (double)1053557./3137161264. * 4096.,
    (double)840748./3137161264. * 4096.,
    (double)582446./3137161264. * 4096.,
    (double)1231479./3137161264. * 4096.,
    (double)1648937./3137161264. * 4096.,
    (double)1296649./3137161264. * 4096.,
    (double)768408./3137161264. * 4096.,
    (double)1041681./3137161264. * 4096.,
    (double)1139308./3137161264. * 4096.,
    (double)1082666./3137161264. * 4096.,
    (double)765243./3137161264. * 4096.,
    (double)753602./3137161264. * 4096.,
    (double)1298473./3137161264. * 4096.,
    (double)174343./3137161264. * 4096.,
    (double)851121./3137161264. * 4096.,
    (double)1108000./3137161264. * 4096.,
    (double)1094828./3137161264. * 4096.,
    (double)1339293./3137161264. * 4096.,
    (double)828235./3137161264. * 4096.,
    (double)1197139./3137161264. * 4096.,
    (double)1120095./3137161264. * 4096.,
    (double)1186133./3137161264. * 4096.,
    (double)854263./3137161264. * 4096.,
    (double)1051425./3137161264. * 4096.,
    (double)112929./3137161264. * 4096.,
    (double)148736./3137161264. * 4096.,
    (double)94494./3137161264. * 4096.,
    (double)111961./3137161264. * 4096.,
    (double)1112631./3137161264. * 4096.,
    (double)135632./3137161264. * 4096.,
    (double)774214./3137161264. * 4096.,
    (double)1026017./3137161264. * 4096.,
    (double)837063./3137161264. * 4096.,
    (double)1240495./3137161264. * 4096.,
    (double)901476./3137161264. * 4096.,
    (double)1214412./3137161264. * 4096.,
    (double)1339509./3137161264. * 4096.,
    (double)814669./3137161264. * 4096.,
    (double)788061./3137161264. * 4096.,
    (double)1071661./3137161264. * 4096.,
    (double)1082940./3137161264. * 4096.,
    (double)970554./3137161264. * 4096.,
    (double)739344./3137161264. * 4096.,
    (double)949151./3137161264. * 4096.,
    (double)1329467./3137161264. * 4096.,
    (double)133104./3137161264. * 4096.,
    (double)1068320./3137161264. * 4096.,
    (double)1460397./3137161264. * 4096.,
    (double)1471152./3137161264. * 4096.,
    (double)1396214./3137161264. * 4096.,
    (double)1324539./3137161264. * 4096.,
    (double)2220611./3137161264. * 4096.,
    (double)4209265./3137161264. * 4096.,
    (double)1903543./3137161264. * 4096.,
    (double)1489131./3137161264. * 4096.,
    (double)3218814./3137161264. * 4096.,
    (double)1459476./3137161264. * 4096.,
    (double)913891./3137161264. * 4096.,
    (double)801280./3137161264. * 4096.,
    (double)1073816./3137161264. * 4096.,
    (double)1483545./3137161264. * 4096.,
    (double)138466./3137161264. * 4096.,
    (double)677171./3137161264. * 4096.,
    (double)1181776./3137161264. * 4096.,
    (double)2365739./3137161264. * 4096.,
    (double)1516684./3137161264. * 4096.,
    (double)1065918./3137161264. * 4096.,
    (double)2435036./3137161264. * 4096.,
    (double)1773718./3137161264. * 4096.,
    (double)998791./3137161264. * 4096.,
    (double)694603./3137161264. * 4096.,
    (double)1189460./3137161264. * 4096.,
    (double)952986./3137161264. * 4096.,
    (double)578921./3137161264. * 4096.,
    (double)549475./3137161264. * 4096.,
    (double)694426./3137161264. * 4096.,
    (double)1087870./3137161264. * 4096.,
    (double)89067./3137161264. * 4096.,
    (double)578108./3137161264. * 4096.,
    (double)895009./3137161264. * 4096.,
    (double)1016395./3137161264. * 4096.,
    (double)820388./3137161264. * 4096.,
    (double)602853./3137161264. * 4096.,
    (double)1129598./3137161264. * 4096.,
    (double)1573451./3137161264. * 4096.,
    (double)1181167./3137161264. * 4096.,
    (double)969981./3137161264. * 4096.,
    (double)1695177./3137161264. * 4096.,
    (double)134155./3137161264. * 4096.,
    (double)113955./3137161264. * 4096.,
    (double)88937./3137161264. * 4096.,
    (double)199547./3137161264. * 4096.,
    (double)942501./3137161264. * 4096.,
    (double)84343./3137161264. * 4096.,
    (double)515906./3137161264. * 4096.,
    (double)851609./3137161264. * 4096.,
    (double)923068./3137161264. * 4096.,
    (double)958322./3137161264. * 4096.,
    (double)664584./3137161264. * 4096.,
    (double)1292177./3137161264. * 4096.,
    (double)2302261./3137161264. * 4096.,
    (double)1104367./3137161264. * 4096.,
    (double)1219512./3137161264. * 4096.,
    (double)3020941./3137161264. * 4096.,
    (double)1401186./3137161264. * 4096.,
    (double)958742./3137161264. * 4096.,
    (double)916547./3137161264. * 4096.,
    (double)1642452./3137161264. * 4096.,
    (double)1308021./3137161264. * 4096.,
    (double)102465./3137161264. * 4096.,
    (double)820885./3137161264. * 4096.,
    (double)1378614./3137161264. * 4096.,
    (double)2017120./3137161264. * 4096.,
    (double)1300291./3137161264. * 4096.,
    (double)1434811./3137161264. * 4096.,
    (double)3704302./3137161264. * 4096.,
    (double)2580578./3137161264. * 4096.,
    (double)1520268./3137161264. * 4096.,
    (double)969711./3137161264. * 4096.,
    (double)1802635./3137161264. * 4096.,
    (double)1561479./3137161264. * 4096.,
    (double)1159148./3137161264. * 4096.,
    (double)821797./3137161264. * 4096.,
    (double)1016259./3137161264. * 4096.,
    (double)1295829./3137161264. * 4096.,
    (double)136036./3137161264. * 4096.,
    (double)665975./3137161264. * 4096.,
    (double)1076105./3137161264. * 4096.,
    (double)1229580./3137161264. * 4096.,
    (double)1221242./3137161264. * 4096.,
    (double)755816./3137161264. * 4096.,
    (double)1413884./3137161264. * 4096.,
    (double)1730239./3137161264. * 4096.,
    (double)1248948./3137161264. * 4096.,
    (double)674250./3137161264. * 4096.,
    (double)1069091./3137161264. * 4096.,
    (double)1182807./3137161264. * 4096.,
    (double)973719./3137161264. * 4096.,
    (double)668206./3137161264. * 4096.,
    (double)763322./3137161264. * 4096.,
    (double)1164822./3137161264. * 4096.,
    (double)150246./3137161264. * 4096.,
    (double)720157./3137161264. * 4096.,
    (double)1059117./3137161264. * 4096.,
    (double)908688./3137161264. * 4096.,
    (double)1081286./3137161264. * 4096.,
    (double)587131./3137161264. * 4096.,
    (double)995005./3137161264. * 4096.,
    (double)1267028./3137161264. * 4096.,
    (double)1159775./3137161264. * 4096.,
    (double)761030./3137161264. * 4096.,
    (double)1214004./3137161264. * 4096.,
    (double)97940./3137161264. * 4096.,
    (double)115291./3137161264. * 4096.,
    (double)84960./3137161264. * 4096.,
    (double)127777./3137161264. * 4096.,
    (double)1091142./3137161264. * 4096.,
    (double)114656./3137161264. * 4096.,
    (double)702743./3137161264. * 4096.,
    (double)1030675./3137161264. * 4096.,
    (double)893522./3137161264. * 4096.,
    (double)1204174./3137161264. * 4096.,
    (double)762454./3137161264. * 4096.,
    (double)1224947./3137161264. * 4096.,
    (double)1559034./3137161264. * 4096.,
    (double)885736./3137161264. * 4096.,
    (double)772335./3137161264. * 4096.,
    (double)1574273./3137161264. * 4096.,
    (double)1370067./3137161264. * 4096.,
    (double)1153000./3137161264. * 4096.,
    (double)893197./3137161264. * 4096.,
    (double)1445549./3137161264. * 4096.,
    (double)1201154./3137161264. * 4096.,
    (double)98869./3137161264. * 4096.,
    (double)777463./3137161264. * 4096.,
    (double)1245394./3137161264. * 4096.,
    (double)1327139./3137161264. * 4096.,
    (double)1145793./3137161264. * 4096.,
    (double)1055071./3137161264. * 4096.,
    (double)2117888./3137161264. * 4096.,
    (double)1609549./3137161264. * 4096.,
    (double)939556./3137161264. * 4096.,
    (double)712880./3137161264. * 4096.,
    (double)1136800./3137161264. * 4096.,
    (double)1216191./3137161264. * 4096.,
    (double)823084./3137161264. * 4096.,
    (double)753353./3137161264. * 4096.,
    (double)971483./3137161264. * 4096.,
    (double)1277585./3137161264. * 4096.,
    (double)165832./3137161264. * 4096.,
    (double)758573./3137161264. * 4096.,
    (double)1090500./3137161264. * 4096.,
    (double)1070375./3137161264. * 4096.,
    (double)992243./3137161264. * 4096.,
    (double)907056./3137161264. * 4096.,
    (double)1494324./3137161264. * 4096.,
    (double)117253./3137161264. * 4096.,
    (double)106669./3137161264. * 4096.,
    (double)63413./3137161264. * 4096.,
    (double)106328./3137161264. * 4096.,
    (double)83918./3137161264. * 4096.,
    (double)91095./3137161264. * 4096.,
    (double)71738./3137161264. * 4096.,
    (double)78066./3137161264. * 4096.,
    (double)109639./3137161264. * 4096.,
    (double)25455./3137161264. * 4096.,
    (double)93606./3137161264. * 4096.,
    (double)137067./3137161264. * 4096.,
    (double)108258./3137161264. * 4096.,
    (double)144979./3137161264. * 4096.,
    (double)90503./3137161264. * 4096.,
    (double)137595./3137161264. * 4096.,
    (double)991973./3137161264. * 4096.,
    (double)989573./3137161264. * 4096.,
    (double)717189./3137161264. * 4096.,
    (double)1013432./3137161264. * 4096.,
    (double)85222./3137161264. * 4096.,
    (double)87086./3137161264. * 4096.,
    (double)83374./3137161264. * 4096.,
    (double)110438./3137161264. * 4096.,
    (double)1041493./3137161264. * 4096.,
    (double)116052./3137161264. * 4096.,
    (double)657544./3137161264. * 4096.,
    (double)891836./3137161264. * 4096.,
    (double)754584./3137161264. * 4096.,
    (double)997207./3137161264. * 4096.,
    (double)862510./3137161264. * 4096.,
    (double)1104070./3137161264. * 4096.,
    (double)1028274./3137161264. * 4096.,
    (double)694047./3137161264. * 4096.,
    (double)659137./3137161264. * 4096.,
    (double)1075677./3137161264. * 4096.,
    (double)1152584./3137161264. * 4096.,
    (double)938519./3137161264. * 4096.,
    (double)863409./3137161264. * 4096.,
    (double)1257053./3137161264. * 4096.,
    (double)1315252./3137161264. * 4096.,
    (double)127804./3137161264. * 4096.,
    (double)921443./3137161264. * 4096.,
    (double)1405609./3137161264. * 4096.,
    (double)1069014./3137161264. * 4096.,
    (double)1010662./3137161264. * 4096.,
    (double)1108684./3137161264. * 4096.,
    (double)1805460./3137161264. * 4096.,
    (double)2669639./3137161264. * 4096.,
    (double)1156735./3137161264. * 4096.,
    (double)955258./3137161264. * 4096.,
    (double)1844937./3137161264. * 4096.,
    (double)1179820./3137161264. * 4096.,
    (double)758142./3137161264. * 4096.,
    (double)737601./3137161264. * 4096.,
    (double)895825./3137161264. * 4096.,
    (double)1401081./3137161264. * 4096.,
    (double)122020./3137161264. * 4096.,
    (double)666661./3137161264. * 4096.,
    (double)1135266./3137161264. * 4096.,
    (double)1822964./3137161264. * 4096.,
    (double)1207432./3137161264. * 4096.,
    (double)1047097./3137161264. * 4096.,
    (double)2531702./3137161264. * 4096.,
    (double)1407159./3137161264. * 4096.,
    (double)932495./3137161264. * 4096.,
    (double)635926./3137161264. * 4096.,
    (double)1069155./3137161264. * 4096.,
    (double)898002./3137161264. * 4096.,
    (double)658617./3137161264. * 4096.,
    (double)606847./3137161264. * 4096.,
    (double)747210./3137161264. * 4096.,
    (double)1014677./3137161264. * 4096.,
    (double)82782./3137161264. * 4096.,
    (double)675825./3137161264. * 4096.,
    (double)1121405./3137161264. * 4096.,
    (double)1111062./3137161264. * 4096.,
    (double)1041575./3137161264. * 4096.,
    (double)767428./3137161264. * 4096.,
    (double)1438771./3137161264. * 4096.,
    (double)1542825./3137161264. * 4096.,
    (double)1316145./3137161264. * 4096.,
    (double)979955./3137161264. * 4096.,
    (double)1620639./3137161264. * 4096.,
    (double)118313./3137161264. * 4096.,
    (double)100804./3137161264. * 4096.,
    (double)75877./3137161264. * 4096.,
    (double)137701./3137161264. * 4096.,
    (double)1369755./3137161264. * 4096.,
    (double)109393./3137161264. * 4096.,
    (double)869213./3137161264. * 4096.,
    (double)1357139./3137161264. * 4096.,
    (double)1349222./3137161264. * 4096.,
    (double)1493434./3137161264. * 4096.,
    (double)1248718./3137161264. * 4096.,
    (double)1839750./3137161264. * 4096.,
    (double)2548895./3137161264. * 4096.,
    (double)1263454./3137161264. * 4096.,
    (double)1247935./3137161264. * 4096.,
    (double)2642340./3137161264. * 4096.,
    (double)1666363./3137161264. * 4096.,
    (double)1339428./3137161264. * 4096.,
    (double)1142610./3137161264. * 4096.,
    (double)1795138./3137161264. * 4096.,
    (double)2150276./3137161264. * 4096.,
    (double)132225./3137161264. * 4096.,
    (double)1529851./3137161264. * 4096.,
    (double)2554365./3137161264. * 4096.,
    (double)3340127./3137161264. * 4096.,
    (double)2223771./3137161264. * 4096.,
    (double)2423396./3137161264. * 4096.,
    (double)4362931./3137161264. * 4096.,
    (double)3353534./3137161264. * 4096.,
    (double)2034524./3137161264. * 4096.,
    (double)1575900./3137161264. * 4096.,
    (double)2579473./3137161264. * 4096.,
    (double)2088030./3137161264. * 4096.,
    (double)1384888./3137161264. * 4096.,
    (double)1025631./3137161264. * 4096.,
    (double)1235561./3137161264. * 4096.,
    (double)1652691./3137161264. * 4096.,
    (double)194495./3137161264. * 4096.,
    (double)838732./3137161264. * 4096.,
    (double)1276646./3137161264. * 4096.,
    (double)2042060./3137161264. * 4096.,
    (double)1752346./3137161264. * 4096.,
    (double)1033384./3137161264. * 4096.,
    (double)1734849./3137161264. * 4096.,
    (double)2007729./3137161264. * 4096.,
    (double)1458934./3137161264. * 4096.,
    (double)899501./3137161264. * 4096.,
    (double)1100621./3137161264. * 4096.,
    (double)1488861./3137161264. * 4096.,
    (double)1086215./3137161264. * 4096.,
    (double)848358./3137161264. * 4096.,
    (double)821092./3137161264. * 4096.,
    (double)1183046./3137161264. * 4096.,
    (double)141736./3137161264. * 4096.,
    (double)852576./3137161264. * 4096.,
    (double)969684./3137161264. * 4096.,
    (double)858305./3137161264. * 4096.,
    (double)987538./3137161264. * 4096.,
    (double)746436./3137161264. * 4096.,
    (double)1011944./3137161264. * 4096.,
    (double)1113871./3137161264. * 4096.,
    (double)995537./3137161264. * 4096.,
    (double)734880./3137161264. * 4096.,
    (double)982738./3137161264. * 4096.,
    (double)117521./3137161264. * 4096.,
    (double)110546./3137161264. * 4096.,
    (double)93439./3137161264. * 4096.,
    (double)139261./3137161264. * 4096.,
    (double)769351./3137161264. * 4096.,
    (double)96466./3137161264. * 4096.,
    (double)528165./3137161264. * 4096.,
    (double)614233./3137161264. * 4096.,
    (double)656664./3137161264. * 4096.,
    (double)861055./3137161264. * 4096.,
    (double)692262./3137161264. * 4096.,
    (double)900465./3137161264. * 4096.,
    (double)1451782./3137161264. * 4096.,
    (double)793908./3137161264. * 4096.,
    (double)652474./3137161264. * 4096.,
    (double)1284982./3137161264. * 4096.,
    (double)1303311./3137161264. * 4096.,
    (double)951061./3137161264. * 4096.,
    (double)715057./3137161264. * 4096.,
    (double)1059949./3137161264. * 4096.,
    (double)936356./3137161264. * 4096.,
    (double)103768./3137161264. * 4096.,
    (double)603580./3137161264. * 4096.,
    (double)887299./3137161264. * 4096.,
    (double)1128846./3137161264. * 4096.,
    (double)844374./3137161264. * 4096.,
    (double)913107./3137161264. * 4096.,
    (double)1615975./3137161264. * 4096.,
    (double)2334722./3137161264. * 4096.,
    (double)1536426./3137161264. * 4096.,
    (double)842167./3137161264. * 4096.,
    (double)1250387./3137161264. * 4096.,
    (double)1781073./3137161264. * 4096.,
    (double)1299800./3137161264. * 4096.,
    (double)764748./3137161264. * 4096.,
    (double)813946./3137161264. * 4096.,
    (double)1194056./3137161264. * 4096.,
    (double)195545./3137161264. * 4096.,
    (double)679622./3137161264. * 4096.,
    (double)864934./3137161264. * 4096.,
    (double)900998./3137161264. * 4096.,
    (double)1134068./3137161264. * 4096.,
    (double)588696./3137161264. * 4096.,
    (double)992491./3137161264. * 4096.,
    (double)1573361./3137161264. * 4096.,
    (double)1347367./3137161264. * 4096.,
    (double)670239./3137161264. * 4096.,
    (double)828009./3137161264. * 4096.,
    (double)1213838./3137161264. * 4096.,
    (double)963952./3137161264. * 4096.,
    (double)716593./3137161264. * 4096.,
    (double)699107./3137161264. * 4096.,
    (double)1114167./3137161264. * 4096.,
    (double)216577./3137161264. * 4096.,
    (double)858301./3137161264. * 4096.,
    (double)1040297./3137161264. * 4096.,
    (double)627470./3137161264. * 4096.,
    (double)958116./3137161264. * 4096.,
    (double)579057./3137161264. * 4096.,
    (double)759203./3137161264. * 4096.,
    (double)895125./3137161264. * 4096.,
    (double)1071342./3137161264. * 4096.,
    (double)598740./3137161264. * 4096.,
    (double)684600./3137161264. * 4096.,
    (double)131607./3137161264. * 4096.,
    (double)149524./3137161264. * 4096.,
    (double)117357./3137161264. * 4096.,
    (double)102178./3137161264. * 4096.,
    (double)1044800./3137161264. * 4096.,
    (double)185707./3137161264. * 4096.,
    (double)705232./3137161264. * 4096.,
    (double)758840./3137161264. * 4096.,
    (double)567564./3137161264. * 4096.,
    (double)1051812./3137161264. * 4096.,
    (double)691874./3137161264. * 4096.,
    (double)741194./3137161264. * 4096.,
    (double)735920./3137161264. * 4096.,
    (double)585250./3137161264. * 4096.,
    (double)362042./3137161264. * 4096.,
    (double)573029./3137161264. * 4096.,
    (double)917954./3137161264. * 4096.,
    (double)807362./3137161264. * 4096.,
    (double)542550./3137161264. * 4096.,
    (double)665437./3137161264. * 4096.,
    (double)764828./3137161264. * 4096.,
    (double)88409./3137161264. * 4096.,
    (double)526865./3137161264. * 4096.,
    (double)716425./3137161264. * 4096.,
    (double)647587./3137161264. * 4096.,
    (double)680499./3137161264. * 4096.,
    (double)654942./3137161264. * 4096.,
    (double)1063770./3137161264. * 4096.,
    (double)1228146./3137161264. * 4096.,
    (double)751876./3137161264. * 4096.,
    (double)500016./3137161264. * 4096.,
    (double)737692./3137161264. * 4096.,
    (double)1186449./3137161264. * 4096.,
    (double)855831./3137161264. * 4096.,
    (double)662971./3137161264. * 4096.,
    (double)722031./3137161264. * 4096.,
    (double)1009139./3137161264. * 4096.,
    (double)148441./3137161264. * 4096.,
    (double)503912./3137161264. * 4096.,
    (double)687777./3137161264. * 4096.,
    (double)712355./3137161264. * 4096.,
    (double)747484./3137161264. * 4096.,
    (double)551967./3137161264. * 4096.,
    (double)995092./3137161264. * 4096.,
    (double)100619./3137161264. * 4096.,
    (double)114821./3137161264. * 4096.,
    (double)66277./3137161264. * 4096.,
    (double)83765./3137161264. * 4096.,
    (double)130081./3137161264. * 4096.,
    (double)152671./3137161264. * 4096.,
    (double)100445./3137161264. * 4096.,
    (double)92318./3137161264. * 4096.,
    (double)102396./3137161264. * 4096.,
    (double)38225./3137161264. * 4096.,
    (double)97344./3137161264. * 4096.,
    (double)106953./3137161264. * 4096.,
    (double)78311./3137161264. * 4096.,
    (double)157148./3137161264. * 4096.,
    (double)87346./3137161264. * 4096.,
    (double)115097./3137161264. * 4096.,
    (double)587725./3137161264. * 4096.,
    (double)660783./3137161264. * 4096.,
    (double)504466./3137161264. * 4096.,
    (double)519999./3137161264. * 4096.,
    (double)77417./3137161264. * 4096.,
    (double)81680./3137161264. * 4096.,
    (double)73020./3137161264. * 4096.,
    (double)81764./3137161264. * 4096.,
    (double)625531./3137161264. * 4096.,
    (double)103173./3137161264. * 4096.,
    (double)488173./3137161264. * 4096.,
    (double)582007./3137161264. * 4096.,
    (double)399781./3137161264. * 4096.,
    (double)628338./3137161264. * 4096.,
    (double)562720./3137161264. * 4096.,
    (double)611201./3137161264. * 4096.,
    (double)554780./3137161264. * 4096.,
    (double)397326./3137161264. * 4096.,
    (double)355745./3137161264. * 4096.,
    (double)512136./3137161264. * 4096.,
    (double)741758./3137161264. * 4096.,
    (double)671359./3137161264. * 4096.,
    (double)513860./3137161264. * 4096.,
    (double)662454./3137161264. * 4096.,
    (double)695442./3137161264. * 4096.,
    (double)93998./3137161264. * 4096.,
    (double)546401./3137161264. * 4096.,
    (double)701122./3137161264. * 4096.,
    (double)570015./3137161264. * 4096.,
    (double)650337./3137161264. * 4096.,
    (double)694665./3137161264. * 4096.,
    (double)993046./3137161264. * 4096.,
    (double)1353709./3137161264. * 4096.,
    (double)637304./3137161264. * 4096.,
    (double)479318./3137161264. * 4096.,
    (double)955886./3137161264. * 4096.,
    (double)704741./3137161264. * 4096.,
    (double)445994./3137161264. * 4096.,
    (double)349195./3137161264. * 4096.,
    (double)474240./3137161264. * 4096.,
    (double)755616./3137161264. * 4096.,
    (double)88960./3137161264. * 4096.,
    (double)357575./3137161264. * 4096.,
    (double)557944./3137161264. * 4096.,
    (double)850079./3137161264. * 4096.,
    (double)650744./3137161264. * 4096.,
    (double)468515./3137161264. * 4096.,
    (double)1098805./3137161264. * 4096.,
    (double)1123222./3137161264. * 4096.,
    (double)886062./3137161264. * 4096.,
    (double)570853./3137161264. * 4096.,
    (double)805282./3137161264. * 4096.,
    (double)927170./3137161264. * 4096.,
    (double)828173./3137161264. * 4096.,
    (double)586089./3137161264. * 4096.,
    (double)660155./3137161264. * 4096.,
    (double)697982./3137161264. * 4096.,
    (double)90548./3137161264. * 4096.,
    (double)537842./3137161264. * 4096.,
    (double)760695./3137161264. * 4096.,
    (double)605486./3137161264. * 4096.,
    (double)808450./3137161264. * 4096.,
    (double)538511./3137161264. * 4096.,
    (double)853899./3137161264. * 4096.,
    (double)597809./3137161264. * 4096.,
    (double)564084./3137161264. * 4096.,
    (double)487743./3137161264. * 4096.,
    (double)629329./3137161264. * 4096.,
    (double)63630./3137161264. * 4096.,
    (double)56494./3137161264. * 4096.,
    (double)65810./3137161264. * 4096.,
    (double)74709./3137161264. * 4096.,
    (double)539006./3137161264. * 4096.,
    (double)72050./3137161264. * 4096.,
    (double)405533./3137161264. * 4096.,
    (double)550880./3137161264. * 4096.,
    (double)442073./3137161264. * 4096.,
    (double)630460./3137161264. * 4096.,
    (double)530701./3137161264. * 4096.,
    (double)681804./3137161264. * 4096.,
    (double)857734./3137161264. * 4096.,
    (double)519082./3137161264. * 4096.,
    (double)487940./3137161264. * 4096.,
    (double)859584./3137161264. * 4096.,
    (double)577835./3137161264. * 4096.,
    (double)499403./3137161264. * 4096.,
    (double)426566./3137161264. * 4096.,
    (double)599708./3137161264. * 4096.,
    (double)788802./3137161264. * 4096.,
    (double)75300./3137161264. * 4096.,
    (double)577633./3137161264. * 4096.,
    (double)897540./3137161264. * 4096.,
    (double)975639./3137161264. * 4096.,
    (double)913308./3137161264. * 4096.,
    (double)931147./3137161264. * 4096.,
    (double)1687144./3137161264. * 4096.,
    (double)2123547./3137161264. * 4096.,
    (double)1457258./3137161264. * 4096.,
    (double)970370./3137161264. * 4096.,
    (double)1463498./3137161264. * 4096.,
    (double)1503265./3137161264. * 4096.,
    (double)1329684./3137161264. * 4096.,
    (double)883109./3137161264. * 4096.,
    (double)903126./3137161264. * 4096.,
    (double)889274./3137161264. * 4096.,
    (double)121306./3137161264. * 4096.,
    (double)490850./3137161264. * 4096.,
    (double)717420./3137161264. * 4096.,
    (double)901230./3137161264. * 4096.,
    (double)951655./3137161264. * 4096.,
    (double)580696./3137161264. * 4096.,
    (double)987311./3137161264. * 4096.,
    (double)1494501./3137161264. * 4096.,
    (double)1289778./3137161264. * 4096.,
    (double)743975./3137161264. * 4096.,
    (double)840442./3137161264. * 4096.,
    (double)1308036./3137161264. * 4096.,
    (double)1203466./3137161264. * 4096.,
    (double)988478./3137161264. * 4096.,
    (double)812484./3137161264. * 4096.,
    (double)828745./3137161264. * 4096.,
    (double)157409./3137161264. * 4096.,
    (double)702994./3137161264. * 4096.,
    (double)815402./3137161264. * 4096.,
    (double)506054./3137161264. * 4096.,
    (double)807154./3137161264. * 4096.,
    (double)544180./3137161264. * 4096.,
    (double)742740./3137161264. * 4096.,
    (double)694765./3137161264. * 4096.,
    (double)850506./3137161264. * 4096.,
    (double)595258./3137161264. * 4096.,
    (double)668529./3137161264. * 4096.,
    (double)90980./3137161264. * 4096.,
    (double)132510./3137161264. * 4096.,
    (double)103587./3137161264. * 4096.,
    (double)108131./3137161264. * 4096.,
    (double)519312./3137161264. * 4096.,
    (double)86499./3137161264. * 4096.,
    (double)453968./3137161264. * 4096.,
    (double)480660./3137161264. * 4096.,
    (double)431678./3137161264. * 4096.,
    (double)627433./3137161264. * 4096.,
    (double)493449./3137161264. * 4096.,
    (double)653277./3137161264. * 4096.,
    (double)701525./3137161264. * 4096.,
    (double)440328./3137161264. * 4096.,
    (double)371505./3137161264. * 4096.,
    (double)668327./3137161264. * 4096.,
    (double)774215./3137161264. * 4096.,
    (double)807172./3137161264. * 4096.,
    (double)515004./3137161264. * 4096.,
    (double)638366./3137161264. * 4096.,
    (double)520006./3137161264. * 4096.,
    (double)64156./3137161264. * 4096.,
    (double)388212./3137161264. * 4096.,
    (double)512996./3137161264. * 4096.,
    (double)677111./3137161264. * 4096.,
    (double)509434./3137161264. * 4096.,
    (double)544342./3137161264. * 4096.,
    (double)992284./3137161264. * 4096.,
    (double)1480911./3137161264. * 4096.,
    (double)1291757./3137161264. * 4096.,
    (double)581051./3137161264. * 4096.,
    (double)786421./3137161264. * 4096.,
    (double)1208585./3137161264. * 4096.,
    (double)1405693./3137161264. * 4096.,
    (double)694992./3137161264. * 4096.,
    (double)645655./3137161264. * 4096.,
    (double)763515./3137161264. * 4096.,
    (double)135451./3137161264. * 4096.,
    (double)478491./3137161264. * 4096.,
    (double)615631./3137161264. * 4096.,
    (double)515719./3137161264. * 4096.,
    (double)752550./3137161264. * 4096.,
    (double)387151./3137161264. * 4096.,
    (double)691643./3137161264. * 4096.,
    (double)1060945./3137161264. * 4096.,
    (double)1052691./3137161264. * 4096.,
    (double)540901./3137161264. * 4096.,
    (double)567398./3137161264. * 4096.,
    (double)714245./3137161264. * 4096.,
    (double)433584./3137161264. * 4096.,
    (double)566185./3137161264. * 4096.,
    (double)520487./3137161264. * 4096.,
    (double)729574./3137161264. * 4096.,
    (double)218850./3137161264. * 4096.,
    (double)606433./3137161264. * 4096.,
    (double)748807./3137161264. * 4096.,
    (double)376705./3137161264. * 4096.,
    (double)777513./3137161264. * 4096.,
    (double)448831./3137161264. * 4096.,
    (double)544164./3137161264. * 4096.,
    (double)654578./3137161264. * 4096.,
    (double)1050980./3137161264. * 4096.,
    (double)529282./3137161264. * 4096.,
    (double)578659./3137161264. * 4096.,
    (double)112895./3137161264. * 4096.,
    (double)252261./3137161264. * 4096.,
    (double)143081./3137161264. * 4096.,
    (double)112122./3137161264. * 4096.,
    (double)679433./3137161264. * 4096.,
    (double)179525./3137161264. * 4096.,
    (double)543771./3137161264. * 4096.,
    (double)668046./3137161264. * 4096.,
    (double)371554./3137161264. * 4096.,
    (double)972637./3137161264. * 4096.,
    (double)617510./3137161264. * 4096.,
    (double)663211./3137161264. * 4096.,
    (double)493899./3137161264. * 4096.,
    (double)453713./3137161264. * 4096.,
    (double)287329./3137161264. * 4096.,
    (double)412964./3137161264. * 4096.,
    (double)680969./3137161264. * 4096.,
    (double)941221./3137161264. * 4096.,
    (double)460210./3137161264. * 4096.,
    (double)539233./3137161264. * 4096.,
    (double)537749./3137161264. * 4096.,
    (double)82175./3137161264. * 4096.,
    (double)429068./3137161264. * 4096.,
    (double)584506./3137161264. * 4096.,
    (double)411102./3137161264. * 4096.,
    (double)525088./3137161264. * 4096.,
    (double)439091./3137161264. * 4096.,
    (double)747507./3137161264. * 4096.,
    (double)968370./3137161264. * 4096.,
    (double)736151./3137161264. * 4096.,
    (double)437952./3137161264. * 4096.,
    (double)584287./3137161264. * 4096.,
    (double)1099122./3137161264. * 4096.,
    (double)1136987./3137161264. * 4096.,
    (double)787021./3137161264. * 4096.,
    (double)679230./3137161264. * 4096.,
    (double)801810./3137161264. * 4096.,
    (double)155201./3137161264. * 4096.,
    (double)489873./3137161264. * 4096.,
    (double)605583./3137161264. * 4096.,
    (double)516990./3137161264. * 4096.,
    (double)731836./3137161264. * 4096.,
    (double)502207./3137161264. * 4096.,
    (double)750339./3137161264. * 4096.,
    (double)85065./3137161264. * 4096.,
    (double)146117./3137161264. * 4096.,
    (double)71454./3137161264. * 4096.,
    (double)76485./3137161264. * 4096.,
    (double)141052./3137161264. * 4096.,
    (double)282387./3137161264. * 4096.,
    (double)187581./3137161264. * 4096.,
    (double)99989./3137161264. * 4096.,
    (double)111641./3137161264. * 4096.,
    (double)87129./3137161264. * 4096.,
    (double)143943./3137161264. * 4096.,
    (double)116908./3137161264. * 4096.,
    (double)55825./3137161264. * 4096.,
    (double)202487./3137161264. * 4096.,
    (double)87900./3137161264. * 4096.,
    (double)84073./3137161264. * 4096.,
    (double)655281./3137161264. * 4096.,
    (double)896534./3137161264. * 4096.,
    (double)604463./3137161264. * 4096.,
    (double)584444./3137161264. * 4096.,
    (double)127601./3137161264. * 4096.,
    (double)198224./3137161264. * 4096.,
    (double)148292./3137161264. * 4096.,
    (double)107473./3137161264. * 4096.,
    (double)661414./3137161264. * 4096.,
    (double)149448./3137161264. * 4096.,
    (double)558265./3137161264. * 4096.,
    (double)621111./3137161264. * 4096.,
    (double)368478./3137161264. * 4096.,
    (double)831017./3137161264. * 4096.,
    (double)705875./3137161264. * 4096.,
    (double)643176./3137161264. * 4096.,
    (double)482762./3137161264. * 4096.,
    (double)376914./3137161264. * 4096.,
    (double)335183./3137161264. * 4096.,
    (double)443729./3137161264. * 4096.,
    (double)821052./3137161264. * 4096.,
    (double)1054078./3137161264. * 4096.,
    (double)773573./3137161264. * 4096.,
    (double)742887./3137161264. * 4096.,
    (double)687933./3137161264. * 4096.,
    (double)101524./3137161264. * 4096.,
    (double)608882./3137161264. * 4096.,
    (double)714592./3137161264. * 4096.,
    (double)480333./3137161264. * 4096.,
    (double)581466./3137161264. * 4096.,
    (double)685099./3137161264. * 4096.,
    (double)877785./3137161264. * 4096.,
    (double)782269./3137161264. * 4096.,
    (double)500951./3137161264. * 4096.,
    (double)348072./3137161264. * 4096.,
    (double)552399./3137161264. * 4096.,
    (double)586189./3137161264. * 4096.,
    (double)472798./3137161264. * 4096.,
    (double)315125./3137161264. * 4096.,
    (double)370182./3137161264. * 4096.,
    (double)486738./3137161264. * 4096.,
    (double)55300./3137161264. * 4096.,
    (double)269838./3137161264. * 4096.,
    (double)375047./3137161264. * 4096.,
    (double)500433./3137161264. * 4096.,
    (double)438195./3137161264. * 4096.,
    (double)318953./3137161264. * 4096.,
    (double)629376./3137161264. * 4096.,
    (double)748558./3137161264. * 4096.,
    (double)785637./3137161264. * 4096.,
    (double)488096./3137161264. * 4096.,
    (double)602605./3137161264. * 4096.,
    (double)743192./3137161264. * 4096.,
    (double)983924./3137161264. * 4096.,
    (double)609699./3137161264. * 4096.,
    (double)632475./3137161264. * 4096.,
    (double)542538./3137161264. * 4096.,
    (double)109160./3137161264. * 4096.,
    (double)471660./3137161264. * 4096.,
    (double)602165./3137161264. * 4096.,
    (double)376831./3137161264. * 4096.,
    (double)727439./3137161264. * 4096.,
    (double)438066./3137161264. * 4096.,
    (double)588948./3137161264. * 4096.,
    (double)469095./3137161264. * 4096.,
    (double)610194./3137161264. * 4096.,
    (double)464288./3137161264. * 4096.,
    (double)517808./3137161264. * 4096.,
    (double)51090./3137161264. * 4096.,
    (double)80490./3137161264. * 4096.,
    (double)55037./3137161264. * 4096.,
    (double)60083./3137161264. * 4096.,
    (double)410671./3137161264. * 4096.,
    (double)63620./3137161264. * 4096.,
    (double)419701./3137161264. * 4096.,
    (double)482611./3137161264. * 4096.,
    (double)327584./3137161264. * 4096.,
    (double)560346./3137161264. * 4096.,
    (double)542728./3137161264. * 4096.,
    (double)603775./3137161264. * 4096.,
    (double)546601./3137161264. * 4096.,
    (double)367437./3137161264. * 4096.,
    (double)315497./3137161264. * 4096.,
    (double)502960./3137161264. * 4096.,
    (double)478440./3137161264. * 4096.,
    (double)528258./3137161264. * 4096.,
    (double)382675./3137161264. * 4096.,
    (double)494278./3137161264. * 4096.,
    (double)514858./3137161264. * 4096.,
    (double)53439./3137161264. * 4096.,
    (double)425542./3137161264. * 4096.,
    (double)613915./3137161264. * 4096.,
    (double)588889./3137161264. * 4096.,
    (double)661043./3137161264. * 4096.,
    (double)682293./3137161264. * 4096.,
    (double)1074460./3137161264. * 4096.,
    (double)1279491./3137161264. * 4096.,
    (double)958862./3137161264. * 4096.,
    (double)613371./3137161264. * 4096.,
    (double)1000742./3137161264. * 4096.,
    (double)820716./3137161264. * 4096.,
    (double)658992./3137161264. * 4096.,
    (double)438251./3137161264. * 4096.,
    (double)581324./3137161264. * 4096.,
    (double)671082./3137161264. * 4096.,
    (double)84949./3137161264. * 4096.,
    (double)368735./3137161264. * 4096.,
    (double)506942./3137161264. * 4096.,
    (double)648341./3137161264. * 4096.,
    (double)676322./3137161264. * 4096.,
    (double)387235./3137161264. * 4096.,
    (double)704023./3137161264. * 4096.,
    (double)1149821./3137161264. * 4096.,
    (double)1154036./3137161264. * 4096.,
    (double)516921./3137161264. * 4096.,
    (double)705265./3137161264. * 4096.,
    (double)975754./3137161264. * 4096.,
    (double)931453./3137161264. * 4096.,
    (double)659742./3137161264. * 4096.,
    (double)653548./3137161264. * 4096.,
    (double)912374./3137161264. * 4096.,
    (double)167021./3137161264. * 4096.,
    (double)752964./3137161264. * 4096.,
    (double)793284./3137161264. * 4096.,
    (double)517928./3137161264. * 4096.,
    (double)915650./3137161264. * 4096.,
    (double)442350./3137161264. * 4096.,
    (double)655886./3137161264. * 4096.,
    (double)620138./3137161264. * 4096.,
    (double)879623./3137161264. * 4096.,
    (double)575403./3137161264. * 4096.,
    (double)708999./3137161264. * 4096.,
    (double)91049./3137161264. * 4096.,
    (double)126722./3137161264. * 4096.,
    (double)99850./3137161264. * 4096.,
    (double)139462./3137161264. * 4096.,
    (double)561544./3137161264. * 4096.,
    (double)103033./3137161264. * 4096.,
    (double)423585./3137161264. * 4096.,
    (double)531835./3137161264. * 4096.,
    (double)366550./3137161264. * 4096.,
    (double)704457./3137161264. * 4096.,
    (double)439636./3137161264. * 4096.,
    (double)644939./3137161264. * 4096.,
    (double)605834./3137161264. * 4096.,
    (double)439384./3137161264. * 4096.,
    (double)336398./3137161264. * 4096.,
    (double)685484./3137161264. * 4096.,
    (double)628096./3137161264. * 4096.,
    (double)640676./3137161264. * 4096.,
    (double)462954./3137161264. * 4096.,
    (double)673155./3137161264. * 4096.,
    (double)590532./3137161264. * 4096.,
    (double)77155./3137161264. * 4096.,
    (double)453098./3137161264. * 4096.,
    (double)662398./3137161264. * 4096.,
    (double)603677./3137161264. * 4096.,
    (double)546987./3137161264. * 4096.,
    (double)587727./3137161264. * 4096.,
    (double)1228480./3137161264. * 4096.,
    (double)88061./3137161264. * 4096.,
    (double)87575./3137161264. * 4096.,
    (double)42483./3137161264. * 4096.,
    (double)61786./3137161264. * 4096.,
    (double)121334./3137161264. * 4096.,
    (double)140591./3137161264. * 4096.,
    (double)82398./3137161264. * 4096.,
    (double)71544./3137161264. * 4096.,
    (double)72478./3137161264. * 4096.,
    (double)23408./3137161264. * 4096.,
    (double)53023./3137161264. * 4096.,
    (double)58641./3137161264. * 4096.,
    (double)50645./3137161264. * 4096.,
    (double)88029./3137161264. * 4096.,
    (double)49412./3137161264. * 4096.,
    (double)70941./3137161264. * 4096.,
    (double)91956./3137161264. * 4096.,
    (double)148915./3137161264. * 4096.,
    (double)56582./3137161264. * 4096.,
    (double)65076./3137161264. * 4096.,
    (double)148912./3137161264. * 4096.,
    (double)239493./3137161264. * 4096.,
    (double)140844./3137161264. * 4096.,
    (double)100363./3137161264. * 4096.,
    (double)113332./3137161264. * 4096.,
    (double)93851./3137161264. * 4096.,
    (double)136583./3137161264. * 4096.,
    (double)118635./3137161264. * 4096.,
    (double)50345./3137161264. * 4096.,
    (double)132278./3137161264. * 4096.,
    (double)58635./3137161264. * 4096.,
    (double)66701./3137161264. * 4096.,
    (double)54642./3137161264. * 4096.,
    (double)123813./3137161264. * 4096.,
    (double)72251./3137161264. * 4096.,
    (double)61412./3137161264. * 4096.,
    (double)28092./3137161264. * 4096.,
    (double)76302./3137161264. * 4096.,
    (double)64814./3137161264. * 4096.,
    (double)28253./3137161264. * 4096.,
    (double)96339./3137161264. * 4096.,
    (double)60914./3137161264. * 4096.,
    (double)137118./3137161264. * 4096.,
    (double)109538./3137161264. * 4096.,
    (double)44460./3137161264. * 4096.,
    (double)132562./3137161264. * 4096.,
    (double)87876./3137161264. * 4096.,
    (double)77273./3137161264. * 4096.,
    (double)57092./3137161264. * 4096.,
    (double)55091./3137161264. * 4096.,
    (double)34291./3137161264. * 4096.,
    (double)63199./3137161264. * 4096.,
    (double)119852./3137161264. * 4096.,
    (double)170464./3137161264. * 4096.,
    (double)96529./3137161264. * 4096.,
    (double)119059./3137161264. * 4096.,
    (double)72278./3137161264. * 4096.,
    (double)21572./3137161264. * 4096.,
    (double)83343./3137161264. * 4096.,
    (double)94409./3137161264. * 4096.,
    (double)55562./3137161264. * 4096.,
    (double)70798./3137161264. * 4096.,
    (double)70442./3137161264. * 4096.,
    (double)111498./3137161264. * 4096.,
    (double)808528./3137161264. * 4096.,
    (double)731760./3137161264. * 4096.,
    (double)402446./3137161264. * 4096.,
    (double)492967./3137161264. * 4096.,
    (double)740106./3137161264. * 4096.,
    (double)898766./3137161264. * 4096.,
    (double)609329./3137161264. * 4096.,
    (double)553259./3137161264. * 4096.,
    (double)774948./3137161264. * 4096.,
    (double)161340./3137161264. * 4096.,
    (double)642722./3137161264. * 4096.,
    (double)672445./3137161264. * 4096.,
    (double)460479./3137161264. * 4096.,
    (double)655009./3137161264. * 4096.,
    (double)484083./3137161264. * 4096.,
    (double)685792./3137161264. * 4096.,
    (double)76524./3137161264. * 4096.,
    (double)164463./3137161264. * 4096.,
    (double)59682./3137161264. * 4096.,
    (double)55907./3137161264. * 4096.,
    (double)88222./3137161264. * 4096.,
    (double)187844./3137161264. * 4096.,
    (double)124623./3137161264. * 4096.,
    (double)70342./3137161264. * 4096.,
    (double)101328./3137161264. * 4096.,
    (double)65791./3137161264. * 4096.,
    (double)152003./3137161264. * 4096.,
    (double)106875./3137161264. * 4096.,
    (double)54738./3137161264. * 4096.,
    (double)136954./3137161264. * 4096.,
    (double)75697./3137161264. * 4096.,
    (double)72780./3137161264. * 4096.,
    (double)515889./3137161264. * 4096.,
    (double)940507./3137161264. * 4096.,
    (double)500877./3137161264. * 4096.,
    (double)483854./3137161264. * 4096.,
    (double)85370./3137161264. * 4096.,
    (double)192763./3137161264. * 4096.,
    (double)120833./3137161264. * 4096.,
    (double)88053./3137161264. * 4096.,
    (double)684719./3137161264. * 4096.,
    (double)173570./3137161264. * 4096.,
    (double)444659./3137161264. * 4096.,
    (double)568860./3137161264. * 4096.,
    (double)333951./3137161264. * 4096.,
    (double)779794./3137161264. * 4096.,
    (double)520481./3137161264. * 4096.,
    (double)551862./3137161264. * 4096.,
    (double)421195./3137161264. * 4096.,
    (double)391259./3137161264. * 4096.,
    (double)295289./3137161264. * 4096.,
    (double)397074./3137161264. * 4096.,
    (double)641018./3137161264. * 4096.,
    (double)958760./3137161264. * 4096.,
    (double)589617./3137161264. * 4096.,
    (double)670279./3137161264. * 4096.,
    (double)764273./3137161264. * 4096.,
    (double)143637./3137161264. * 4096.,
    (double)747069./3137161264. * 4096.,
    (double)773586./3137161264. * 4096.,
    (double)431551./3137161264. * 4096.,
    (double)603108./3137161264. * 4096.,
    (double)616053./3137161264. * 4096.,
    (double)798998./3137161264. * 4096.,
    (double)687200./3137161264. * 4096.,
    (double)477654./3137161264. * 4096.,
    (double)300074./3137161264. * 4096.,
    (double)538847./3137161264. * 4096.,
    (double)453356./3137161264. * 4096.,
    (double)358883./3137161264. * 4096.,
    (double)240158./3137161264. * 4096.,
    (double)310315./3137161264. * 4096.,
    (double)490608./3137161264. * 4096.,
    (double)61947./3137161264. * 4096.,
    (double)291669./3137161264. * 4096.,
    (double)479865./3137161264. * 4096.,
    (double)486243./3137161264. * 4096.,
    (double)463034./3137161264. * 4096.,
    (double)291304./3137161264. * 4096.,
    (double)658858./3137161264. * 4096.,
    (double)837215./3137161264. * 4096.,
    (double)930396./3137161264. * 4096.,
    (double)443389./3137161264. * 4096.,
    (double)557205./3137161264. * 4096.,
    (double)811911./3137161264. * 4096.,
    (double)980911./3137161264. * 4096.,
    (double)577611./3137161264. * 4096.,
    (double)561030./3137161264. * 4096.,
    (double)764795./3137161264. * 4096.,
    (double)135596./3137161264. * 4096.,
    (double)656655./3137161264. * 4096.,
    (double)830802./3137161264. * 4096.,
    (double)524543./3137161264. * 4096.,
    (double)874885./3137161264. * 4096.,
    (double)505279./3137161264. * 4096.,
    (double)703416./3137161264. * 4096.,
    (double)550113./3137161264. * 4096.,
    (double)750224./3137161264. * 4096.,
    (double)482727./3137161264. * 4096.,
    (double)546574./3137161264. * 4096.,
    (double)59052./3137161264. * 4096.,
    (double)98289./3137161264. * 4096.,
    (double)66012./3137161264. * 4096.,
    (double)65399./3137161264. * 4096.,
    (double)626403./3137161264. * 4096.,
    (double)110607./3137161264. * 4096.,
    (double)531785./3137161264. * 4096.,
    (double)651974./3137161264. * 4096.,
    (double)427368./3137161264. * 4096.,
    (double)843603./3137161264. * 4096.,
    (double)547759./3137161264. * 4096.,
    (double)695054./3137161264. * 4096.,
    (double)547763./3137161264. * 4096.,
    (double)415513./3137161264. * 4096.,
    (double)325045./3137161264. * 4096.,
    (double)552045./3137161264. * 4096.,
    (double)528308./3137161264. * 4096.,
    (double)544115./3137161264. * 4096.,
    (double)385222./3137161264. * 4096.,
    (double)502364./3137161264. * 4096.,
    (double)697969./3137161264. * 4096.,
    (double)81391./3137161264. * 4096.,
    (double)686181./3137161264. * 4096.,
    (double)858834./3137161264. * 4096.,
    (double)697070./3137161264. * 4096.,
    (double)789605./3137161264. * 4096.,
    (double)751500./3137161264. * 4096.,
    (double)1135919./3137161264. * 4096.,
    (double)1288772./3137161264. * 4096.,
    (double)683840./3137161264. * 4096.,
    (double)519365./3137161264. * 4096.,
    (double)1030555./3137161264. * 4096.,
    (double)655646./3137161264. * 4096.,
    (double)420329./3137161264. * 4096.,
    (double)340827./3137161264. * 4096.,
    (double)556993./3137161264. * 4096.,
    (double)604820./3137161264. * 4096.,
    (double)58861./3137161264. * 4096.,
    (double)290085./3137161264. * 4096.,
    (double)530928./3137161264. * 4096.,
    (double)734752./3137161264. * 4096.,
    (double)546651./3137161264. * 4096.,
    (double)406586./3137161264. * 4096.,
    (double)854712./3137161264. * 4096.,
    (double)793187./3137161264. * 4096.,
    (double)560884./3137161264. * 4096.,
    (double)313995./3137161264. * 4096.,
    (double)504739./3137161264. * 4096.,
    (double)501126./3137161264. * 4096.,
    (double)377535./3137161264. * 4096.,
    (double)290525./3137161264. * 4096.,
    (double)402567./3137161264. * 4096.,
    (double)464863./3137161264. * 4096.,
    (double)49466./3137161264. * 4096.,
    (double)296845./3137161264. * 4096.,
    (double)459453./3137161264. * 4096.,
    (double)405536./3137161264. * 4096.,
    (double)389211./3137161264. * 4096.,
    (double)283589./3137161264. * 4096.,
    (double)500484./3137161264. * 4096.,
    (double)531708./3137161264. * 4096.,
    (double)477904./3137161264. * 4096.,
    (double)332838./3137161264. * 4096.,
    (double)570798./3137161264. * 4096.,
    (double)45058./3137161264. * 4096.,
    (double)42674./3137161264. * 4096.,
    (double)31800./3137161264. * 4096.,
    (double)74402./3137161264. * 4096.,
    (double)372932./3137161264. * 4096.,
    (double)39955./3137161264. * 4096.,
    (double)238797./3137161264. * 4096.,
    (double)368939./3137161264. * 4096.,
    (double)335772./3137161264. * 4096.,
    (double)392443./3137161264. * 4096.,
    (double)284240./3137161264. * 4096.,
    (double)523461./3137161264. * 4096.,
    (double)689194./3137161264. * 4096.,
    (double)381980./3137161264. * 4096.,
    (double)369889./3137161264. * 4096.,
    (double)848358./3137161264. * 4096.,
    (double)480585./3137161264. * 4096.,
    (double)359198./3137161264. * 4096.,
    (double)309624./3137161264. * 4096.,
    (double)663593./3137161264. * 4096.,
    (double)483580./3137161264. * 4096.,
    (double)41132./3137161264. * 4096.,
    (double)309664./3137161264. * 4096.,
    (double)567694./3137161264. * 4096.,
    (double)681326./3137161264. * 4096.,
    (double)459781./3137161264. * 4096.,
    (double)503200./3137161264. * 4096.,
    (double)1288104./3137161264. * 4096.,
    (double)1103694./3137161264. * 4096.,
    (double)739469./3137161264. * 4096.,
    (double)447546./3137161264. * 4096.,
    (double)751257./3137161264. * 4096.,
    (double)850237./3137161264. * 4096.,
    (double)733764./3137161264. * 4096.,
    (double)576817./3137161264. * 4096.,
    (double)584900./3137161264. * 4096.,
    (double)675316./3137161264. * 4096.,
    (double)89754./3137161264. * 4096.,
    (double)412423./3137161264. * 4096.,
    (double)612521./3137161264. * 4096.,
    (double)574926./3137161264. * 4096.,
    (double)675271./3137161264. * 4096.,
    (double)380962./3137161264. * 4096.,
    (double)726954./3137161264. * 4096.,
    (double)834919./3137161264. * 4096.,
    (double)747794./3137161264. * 4096.,
    (double)354287./3137161264. * 4096.,
    (double)520341./3137161264. * 4096.,
    (double)809623./3137161264. * 4096.,
    (double)805454./3137161264. * 4096.,
    (double)492513./3137161264. * 4096.,
    (double)561320./3137161264. * 4096.,
    (double)698248./3137161264. * 4096.,
    (double)126204./3137161264. * 4096.,
    (double)501621./3137161264. * 4096.,
    (double)703560./3137161264. * 4096.,
    (double)489820./3137161264. * 4096.,
    (double)706286./3137161264. * 4096.,
    (double)385936./3137161264. * 4096.,
    (double)614609./3137161264. * 4096.,
    (double)490808./3137161264. * 4096.,
    (double)621938./3137161264. * 4096.,
    (double)367024./3137161264. * 4096.,
    (double)517116./3137161264. * 4096.,
    (double)57758./3137161264. * 4096.,
    (double)89244./3137161264. * 4096.,
    (double)62819./3137161264. * 4096.,
    (double)82695./3137161264. * 4096.,
    (double)562268./3137161264. * 4096.,
    (double)84097./3137161264. * 4096.,
    (double)428587./3137161264. * 4096.,
    (double)571500./3137161264. * 4096.,
    (double)422451./3137161264. * 4096.,
    (double)706120./3137161264. * 4096.,
    (double)436308./3137161264. * 4096.,
    (double)632650./3137161264. * 4096.,
    (double)526854./3137161264. * 4096.,
    (double)387045./3137161264. * 4096.,
    (double)314416./3137161264. * 4096.,
    (double)620961./3137161264. * 4096.,
    (double)654109./3137161264. * 4096.,
    (double)679495./3137161264. * 4096.,
    (double)491833./3137161264. * 4096.,
    (double)1042220./3137161264. * 4096.,
    (double)549902./3137161264. * 4096.,
    (double)61021./3137161264. * 4096.,
    (double)453764./3137161264. * 4096.,
    (double)671356./3137161264. * 4096.,
    (double)539281./3137161264. * 4096.,
    (double)558014./3137161264. * 4096.,
    (double)529651./3137161264. * 4096.,
    (double)1019983./3137161264. * 4096.,
    (double)703440./3137161264. * 4096.,
    (double)472728./3137161264. * 4096.,
    (double)317429./3137161264. * 4096.,
    (double)473018./3137161264. * 4096.,
    (double)620148./3137161264. * 4096.,
    (double)542196./3137161264. * 4096.,
    (double)415621./3137161264. * 4096.,
    (double)498723./3137161264. * 4096.,
    (double)638912./3137161264. * 4096.,
    (double)90291./3137161264. * 4096.,
    (double)409344./3137161264. * 4096.,
    (double)559812./3137161264. * 4096.,
    (double)471650./3137161264. * 4096.,
    (double)499490./3137161264. * 4096.,
    (double)432162./3137161264. * 4096.,
    (double)737019./3137161264. * 4096.,
    (double)50706./3137161264. * 4096.,
    (double)59762./3137161264. * 4096.,
    (double)28919./3137161264. * 4096.,
    (double)44193./3137161264. * 4096.,
    (double)48425./3137161264. * 4096.,
    (double)82215./3137161264. * 4096.,
    (double)51961./3137161264. * 4096.,
    (double)47005./3137161264. * 4096.,
    (double)47512./3137161264. * 4096.,
    (double)15736./3137161264. * 4096.,
    (double)53000./3137161264. * 4096.,
    (double)58931./3137161264. * 4096.,
    (double)41832./3137161264. * 4096.,
    (double)70274./3137161264. * 4096.,
    (double)45710./3137161264. * 4096.,
    (double)62463./3137161264. * 4096.,
    (double)416083./3137161264. * 4096.,
    (double)503999./3137161264. * 4096.,
    (double)326115./3137161264. * 4096.,
    (double)431566./3137161264. * 4096.,
    (double)43884./3137161264. * 4096.,
    (double)57452./3137161264. * 4096.,
    (double)45453./3137161264. * 4096.,
    (double)61015./3137161264. * 4096.,
    (double)514784./3137161264. * 4096.,
    (double)80792./3137161264. * 4096.,
    (double)387215./3137161264. * 4096.,
    (double)501997./3137161264. * 4096.,
    (double)340622./3137161264. * 4096.,
    (double)557490./3137161264. * 4096.,
    (double)452600./3137161264. * 4096.,
    (double)570564./3137161264. * 4096.,
    (double)414030./3137161264. * 4096.,
    (double)328636./3137161264. * 4096.,
    (double)283234./3137161264. * 4096.,
    (double)440948./3137161264. * 4096.,
    (double)524260./3137161264. * 4096.,
    (double)516579./3137161264. * 4096.,
    (double)423965./3137161264. * 4096.,
    (double)633319./3137161264. * 4096.,
    (double)656919./3137161264. * 4096.,
    (double)90167./3137161264. * 4096.,
    (double)527840./3137161264. * 4096.,
    (double)736972./3137161264. * 4096.,
    (double)487464./3137161264. * 4096.,
    (double)517350./3137161264. * 4096.,
    (double)606332./3137161264. * 4096.,
    (double)903105./3137161264. * 4096.,
    (double)913584./3137161264. * 4096.,
    (double)494414./3137161264. * 4096.,
    (double)369893./3137161264. * 4096.,
    (double)683025./3137161264. * 4096.,
    (double)469675./3137161264. * 4096.,
    (double)357163./3137161264. * 4096.,
    (double)276537./3137161264. * 4096.,
    (double)362182./3137161264. * 4096.,
    (double)539432./3137161264. * 4096.,
    (double)57463./3137161264. * 4096.,
    (double)294982./3137161264. * 4096.,
    (double)486301./3137161264. * 4096.,
    (double)589009./3137161264. * 4096.,
    (double)443107./3137161264. * 4096.,
    (double)372636./3137161264. * 4096.,
    (double)863650./3137161264. * 4096.,
    (double)690091./3137161264. * 4096.,
    (double)505050./3137161264. * 4096.,
    (double)303311./3137161264. * 4096.,
    (double)475682./3137161264. * 4096.,
    (double)499811./3137161264. * 4096.,
    (double)484749./3137161264. * 4096.,
    (double)349467./3137161264. * 4096.,
    (double)424266./3137161264. * 4096.,
    (double)463382./3137161264. * 4096.,
    (double)47454./3137161264. * 4096.,
    (double)354167./3137161264. * 4096.,
    (double)520840./3137161264. * 4096.,
    (double)451681./3137161264. * 4096.,
    (double)485068./3137161264. * 4096.,
    (double)360280./3137161264. * 4096.,
    (double)696424./3137161264. * 4096.,
    (double)582869./3137161264. * 4096.,
    (double)544539./3137161264. * 4096.,
    (double)396868./3137161264. * 4096.,
    (double)617402./3137161264. * 4096.,
    (double)49547./3137161264. * 4096.,
    (double)46506./3137161264. * 4096.,
    (double)33886./3137161264. * 4096.,
    (double)59673./3137161264. * 4096.,
    (double)544014./3137161264. * 4096.,
    (double)56398./3137161264. * 4096.,
    (double)413672./3137161264. * 4096.,
    (double)600632./3137161264. * 4096.,
    (double)518354./3137161264. * 4096.,
    (double)673507./3137161264. * 4096.,
    (double)560655./3137161264. * 4096.,
    (double)796032./3137161264. * 4096.,
    (double)840654./3137161264. * 4096.,
    (double)481586./3137161264. * 4096.,
    (double)460078./3137161264. * 4096.,
    (double)913379./3137161264. * 4096.,
    (double)653777./3137161264. * 4096.,
    (double)611655./3137161264. * 4096.,
    (double)495259./3137161264. * 4096.,
    (double)779256./3137161264. * 4096.,
    (double)819345./3137161264. * 4096.,
    (double)66776./3137161264. * 4096.,
    (double)717737./3137161264. * 4096.,
    (double)1086253./3137161264. * 4096.,
    (double)1159920./3137161264. * 4096.,
    (double)971454./3137161264. * 4096.,
    (double)1066585./3137161264. * 4096.,
    (double)1538167./3137161264. * 4096.,
    (double)2110128./3137161264. * 4096.,
    (double)1188711./3137161264. * 4096.,
    (double)1057538./3137161264. * 4096.,
    (double)1728478./3137161264. * 4096.,
    (double)1260684./3137161264. * 4096.,
    (double)873476./3137161264. * 4096.,
    (double)756298./3137161264. * 4096.,
    (double)929290./3137161264. * 4096.,
    (double)1122168./3137161264. * 4096.,
    (double)116594./3137161264. * 4096.,
    (double)564998./3137161264. * 4096.,
    (double)839477./3137161264. * 4096.,
    (double)1354576./3137161264. * 4096.,
    (double)1124881./3137161264. * 4096.,
    (double)702780./3137161264. * 4096.,
    (double)1207692./3137161264. * 4096.,
    (double)1134100./3137161264. * 4096.,
    (double)785411./3137161264. * 4096.,
    (double)553162./3137161264. * 4096.,
    (double)718004./3137161264. * 4096.,
    (double)838054./3137161264. * 4096.,
    (double)568014./3137161264. * 4096.,
    (double)555669./3137161264. * 4096.,
    (double)588826./3137161264. * 4096.,
    (double)687168./3137161264. * 4096.,
    (double)82158./3137161264. * 4096.,
    (double)460070./3137161264. * 4096.,
    (double)538417./3137161264. * 4096.,
    (double)591011./3137161264. * 4096.,
    (double)636435./3137161264. * 4096.,
    (double)486377./3137161264. * 4096.,
    (double)685780./3137161264. * 4096.,
    (double)903316./3137161264. * 4096.,
    (double)702696./3137161264. * 4096.,
    (double)512628./3137161264. * 4096.,
    (double)767129./3137161264. * 4096.,
    (double)78550./3137161264. * 4096.,
    (double)66230./3137161264. * 4096.,
    (double)58066./3137161264. * 4096.,
    (double)106589./3137161264. * 4096.,
    (double)542587./3137161264. * 4096.,
    (double)57496./3137161264. * 4096.,
    (double)396243./3137161264. * 4096.,
    (double)533534./3137161264. * 4096.,
    (double)458541./3137161264. * 4096.,
    (double)568636./3137161264. * 4096.,
    (double)475819./3137161264. * 4096.,
    (double)671539./3137161264. * 4096.,
    (double)1035311./3137161264. * 4096.,
    (double)522158./3137161264. * 4096.,
    (double)426854./3137161264. * 4096.,
    (double)861870./3137161264. * 4096.,
    (double)759662./3137161264. * 4096.,
    (double)542107./3137161264. * 4096.,
    (double)454751./3137161264. * 4096.,
    (double)695698./3137161264. * 4096.,
    (double)582823./3137161264. * 4096.,
    (double)50868./3137161264. * 4096.,
    (double)377592./3137161264. * 4096.,
    (double)551036./3137161264. * 4096.,
    (double)750234./3137161264. * 4096.,
    (double)459822./3137161264. * 4096.,
    (double)584590./3137161264. * 4096.,
    (double)1129785./3137161264. * 4096.,
    (double)1719305./3137161264. * 4096.,
    (double)1098117./3137161264. * 4096.,
    (double)668938./3137161264. * 4096.,
    (double)1067540./3137161264. * 4096.,
    (double)1258884./3137161264. * 4096.,
    (double)999996./3137161264. * 4096.,
    (double)801849./3137161264. * 4096.,
    (double)806053./3137161264. * 4096.,
    (double)862808./3137161264. * 4096.,
    (double)118344./3137161264. * 4096.,
    (double)448600./3137161264. * 4096.,
    (double)621447./3137161264. * 4096.,
    (double)732298./3137161264. * 4096.,
    (double)843467./3137161264. * 4096.,
    (double)450547./3137161264. * 4096.,
    (double)788319./3137161264. * 4096.,
    (double)1186997./3137161264. * 4096.,
    (double)1036838./3137161264. * 4096.,
    (double)540920./3137161264. * 4096.,
    (double)665609./3137161264. * 4096.,
    (double)938801./3137161264. * 4096.,
    (double)635496./3137161264. * 4096.,
    (double)680738./3137161264. * 4096.,
    (double)629831./3137161264. * 4096.,
    (double)951711./3137161264. * 4096.,
    (double)175612./3137161264. * 4096.,
    (double)598857./3137161264. * 4096.,
    (double)778677./3137161264. * 4096.,
    (double)544345./3137161264. * 4096.,
    (double)771103./3137161264. * 4096.,
    (double)426830./3137161264. * 4096.,
    (double)579286./3137161264. * 4096.,
    (double)863505./3137161264. * 4096.,
    (double)973743./3137161264. * 4096.,
    (double)616829./3137161264. * 4096.,
    (double)758015./3137161264. * 4096.,
    (double)104193./3137161264. * 4096.,
    (double)122216./3137161264. * 4096.,
    (double)102704./3137161264. * 4096.,
    (double)119555./3137161264. * 4096.,
    (double)858413./3137161264. * 4096.,
    (double)133964./3137161264. * 4096.,
    (double)665560./3137161264. * 4096.,
    (double)935655./3137161264. * 4096.,
    (double)520912./3137161264. * 4096.,
    (double)872208./3137161264. * 4096.,
    (double)643052./3137161264. * 4096.,
    (double)740417./3137161264. * 4096.,
    (double)723174./3137161264. * 4096.,
    (double)495579./3137161264. * 4096.,
    (double)332521./3137161264. * 4096.,
    (double)585118./3137161264. * 4096.,
    (double)850347./3137161264. * 4096.,
    (double)758584./3137161264. * 4096.,
    (double)534054./3137161264. * 4096.,
    (double)735452./3137161264. * 4096.,
    (double)616179./3137161264. * 4096.,
    (double)63282./3137161264. * 4096.,
    (double)414216./3137161264. * 4096.,
    (double)648601./3137161264. * 4096.,
    (double)576826./3137161264. * 4096.,
    (double)533576./3137161264. * 4096.,
    (double)544498./3137161264. * 4096.,
    (double)1027053./3137161264. * 4096.,
    (double)1123930./3137161264. * 4096.,
    (double)591968./3137161264. * 4096.,
    (double)442279./3137161264. * 4096.,
    (double)702092./3137161264. * 4096.,
    (double)1065904./3137161264. * 4096.,
    (double)780143./3137161264. * 4096.,
    (double)727735./3137161264. * 4096.,
    (double)763195./3137161264. * 4096.,
    (double)1346620./3137161264. * 4096.,
    (double)166205./3137161264. * 4096.,
    (double)497285./3137161264. * 4096.,
    (double)630720./3137161264. * 4096.,
    (double)823051./3137161264. * 4096.,
    (double)790325./3137161264. * 4096.,
    (double)528276./3137161264. * 4096.,
    (double)912610./3137161264. * 4096.,
    (double)103239./3137161264. * 4096.,
    (double)105789./3137161264. * 4096.,
    (double)60083./3137161264. * 4096.,
    (double)84380./3137161264. * 4096.,
    (double)116581./3137161264. * 4096.,
    (double)117194./3137161264. * 4096.,
    (double)107020./3137161264. * 4096.,
    (double)102346./3137161264. * 4096.,
    (double)130555./3137161264. * 4096.,
    (double)32524./3137161264. * 4096.,
    (double)112376./3137161264. * 4096.,
    (double)103203./3137161264. * 4096.,
    (double)112500./3137161264. * 4096.,
    (double)204809./3137161264. * 4096.,
    (double)92837./3137161264. * 4096.,
    (double)136238./3137161264. * 4096.,
    (double)597828./3137161264. * 4096.,
    (double)588422./3137161264. * 4096.,
    (double)570394./3137161264. * 4096.,
    (double)609969./3137161264. * 4096.,
    (double)78535./3137161264. * 4096.,
    (double)75897./3137161264. * 4096.,
    (double)128318./3137161264. * 4096.,
    (double)117131./3137161264. * 4096.,
    (double)644363./3137161264. * 4096.,
    (double)106475./3137161264. * 4096.,
    (double)471927./3137161264. * 4096.,
    (double)510945./3137161264. * 4096.,
    (double)395986./3137161264. * 4096.,
    (double)664611./3137161264. * 4096.,
    (double)524019./3137161264. * 4096.,
    (double)560285./3137161264. * 4096.,
    (double)508484./3137161264. * 4096.,
    (double)337926./3137161264. * 4096.,
    (double)312852./3137161264. * 4096.,
    (double)470893./3137161264. * 4096.,
    (double)754619./3137161264. * 4096.,
    (double)643175./3137161264. * 4096.,
    (double)687988./3137161264. * 4096.,
    (double)753782./3137161264. * 4096.,
    (double)627562./3137161264. * 4096.,
    (double)76245./3137161264. * 4096.,
    (double)490942./3137161264. * 4096.,
    (double)613166./3137161264. * 4096.,
    (double)592982./3137161264. * 4096.,
    (double)565134./3137161264. * 4096.,
    (double)586102./3137161264. * 4096.,
    (double)906512./3137161264. * 4096.,
    (double)1108892./3137161264. * 4096.,
    (double)492650./3137161264. * 4096.,
    (double)391109./3137161264. * 4096.,
    (double)778258./3137161264. * 4096.,
    (double)582258./3137161264. * 4096.,
    (double)384629./3137161264. * 4096.,
    (double)375776./3137161264. * 4096.,
    (double)472035./3137161264. * 4096.,
    (double)687915./3137161264. * 4096.,
    (double)73047./3137161264. * 4096.,
    (double)299995./3137161264. * 4096.,
    (double)452924./3137161264. * 4096.,
    (double)871162./3137161264. * 4096.,
    (double)633525./3137161264. * 4096.,
    (double)439619./3137161264. * 4096.,
    (double)953059./3137161264. * 4096.,
    (double)849735./3137161264. * 4096.,
    (double)630335./3137161264. * 4096.,
    (double)422679./3137161264. * 4096.,
    (double)589233./3137161264. * 4096.,
    (double)667421./3137161264. * 4096.,
    (double)525381./3137161264. * 4096.,
    (double)497187./3137161264. * 4096.,
    (double)541585./3137161264. * 4096.,
    (double)653361./3137161264. * 4096.,
    (double)75275./3137161264. * 4096.,
    (double)454010./3137161264. * 4096.,
    (double)581250./3137161264. * 4096.,
    (double)636895./3137161264. * 4096.,
    (double)726026./3137161264. * 4096.,
    (double)465930./3137161264. * 4096.,
    (double)763719./3137161264. * 4096.,
    (double)620707./3137161264. * 4096.,
    (double)599472./3137161264. * 4096.,
    (double)524869./3137161264. * 4096.,
    (double)674014./3137161264. * 4096.,
    (double)62903./3137161264. * 4096.,
    (double)56305./3137161264. * 4096.,
    (double)61193./3137161264. * 4096.,
    (double)84768./3137161264. * 4096.,
    (double)587166./3137161264. * 4096.,
    (double)64468./3137161264. * 4096.,
    (double)458625./3137161264. * 4096.,
    (double)613939./3137161264. * 4096.,
    (double)511585./3137161264. * 4096.,
    (double)701854./3137161264. * 4096.,
    (double)648780./3137161264. * 4096.,
    (double)794507./3137161264. * 4096.,
    (double)830059./3137161264. * 4096.,
    (double)477825./3137161264. * 4096.,
    (double)426107./3137161264. * 4096.,
    (double)827278./3137161264. * 4096.,
    (double)561540./3137161264. * 4096.,
    (double)422250./3137161264. * 4096.,
    (double)462158./3137161264. * 4096.,
    (double)659539./3137161264. * 4096.,
    (double)835193./3137161264. * 4096.,
    (double)74450./3137161264. * 4096.,
    (double)596073./3137161264. * 4096.,
    (double)916954./3137161264. * 4096.,
    (double)1144163./3137161264. * 4096.,
    (double)918751./3137161264. * 4096.,
    (double)1018699./3137161264. * 4096.,
    (double)1872439./3137161264. * 4096.,
    (double)115573./3137161264. * 4096.,
    (double)85943./3137161264. * 4096.,
    (double)68460./3137161264. * 4096.,
    (double)85910./3137161264. * 4096.,
    (double)91410./3137161264. * 4096.,
    (double)85042./3137161264. * 4096.,
    (double)65012./3137161264. * 4096.,
    (double)74451./3137161264. * 4096.,
    (double)64166./3137161264. * 4096.,
    (double)11744./3137161264. * 4096.,
    (double)37960./3137161264. * 4096.,
    (double)52664./3137161264. * 4096.,
    (double)67040./3137161264. * 4096.,
    (double)79477./3137161264. * 4096.,
    (double)47820./3137161264. * 4096.,
    (double)71269./3137161264. * 4096.,
    (double)106177./3137161264. * 4096.,
    (double)99910./3137161264. * 4096.,
    (double)89861./3137161264. * 4096.,
    (double)76810./3137161264. * 4096.,
    (double)107968./3137161264. * 4096.,
    (double)105953./3137161264. * 4096.,
    (double)117662./3137161264. * 4096.,
    (double)90827./3137161264. * 4096.,
    (double)72045./3137161264. * 4096.,
    (double)23534./3137161264. * 4096.,
    (double)71627./3137161264. * 4096.,
    (double)66187./3137161264. * 4096.,
    (double)53211./3137161264. * 4096.,
    (double)76076./3137161264. * 4096.,
    (double)57043./3137161264. * 4096.,
    (double)65282./3137161264. * 4096.,
    (double)56835./3137161264. * 4096.,
    (double)73991./3137161264. * 4096.,
    (double)48408./3137161264. * 4096.,
    (double)56540./3137161264. * 4096.,
    (double)11406./3137161264. * 4096.,
    (double)16904./3137161264. * 4096.,
    (double)14906./3137161264. * 4096.,
    (double)13789./3137161264. * 4096.,
    (double)48362./3137161264. * 4096.,
    (double)12140./3137161264. * 4096.,
    (double)50047./3137161264. * 4096.,
    (double)54179./3137161264. * 4096.,
    (double)33293./3137161264. * 4096.,
    (double)58650./3137161264. * 4096.,
    (double)48740./3137161264. * 4096.,
    (double)59133./3137161264. * 4096.,
    (double)61574./3137161264. * 4096.,
    (double)40918./3137161264. * 4096.,
    (double)33694./3137161264. * 4096.,
    (double)57769./3137161264. * 4096.,
    (double)73464./3137161264. * 4096.,
    (double)72180./3137161264. * 4096.,
    (double)54222./3137161264. * 4096.,
    (double)67430./3137161264. * 4096.,
    (double)50748./3137161264. * 4096.,
    (double)8163./3137161264. * 4096.,
    (double)38862./3137161264. * 4096.,
    (double)53608./3137161264. * 4096.,
    (double)54874./3137161264. * 4096.,
    (double)46202./3137161264. * 4096.,
    (double)54992./3137161264. * 4096.,
    (double)95184./3137161264. * 4096.,
    (double)102001./3137161264. * 4096.,
    (double)102447./3137161264. * 4096.,
    (double)51000./3137161264. * 4096.,
    (double)66736./3137161264. * 4096.,
    (double)103192./3137161264. * 4096.,
    (double)132677./3137161264. * 4096.,
    (double)92952./3137161264. * 4096.,
    (double)77642./3137161264. * 4096.,
    (double)64807./3137161264. * 4096.,
    (double)20438./3137161264. * 4096.,
    (double)42957./3137161264. * 4096.,
    (double)49567./3137161264. * 4096.,
    (double)42795./3137161264. * 4096.,
    (double)68887./3137161264. * 4096.,
    (double)39761./3137161264. * 4096.,
    (double)52256./3137161264. * 4096.,
    (double)113577./3137161264. * 4096.,
    (double)158736./3137161264. * 4096.,
    (double)69327./3137161264. * 4096.,
    (double)65027./3137161264. * 4096.,
    (double)139272./3137161264. * 4096.,
    (double)138226./3137161264. * 4096.,
    (double)139456./3137161264. * 4096.,
    (double)102099./3137161264. * 4096.,
    (double)109103./3137161264. * 4096.,
    (double)57979./3137161264. * 4096.,
    (double)92485./3137161264. * 4096.,
    (double)91801./3137161264. * 4096.,
    (double)48445./3137161264. * 4096.,
    (double)102478./3137161264. * 4096.,
    (double)56855./3137161264. * 4096.,
    (double)60088./3137161264. * 4096.,
    (double)65736./3137161264. * 4096.,
    (double)115519./3137161264. * 4096.,
    (double)64763./3137161264. * 4096.,
    (double)62670./3137161264. * 4096.,
    (double)21249./3137161264. * 4096.,
    (double)59653./3137161264. * 4096.,
    (double)41257./3137161264. * 4096.,
    (double)21162./3137161264. * 4096.,
    (double)116038./3137161264. * 4096.,
    (double)53636./3137161264. * 4096.,
    (double)108981./3137161264. * 4096.,
    (double)123259./3137161264. * 4096.,
    (double)44385./3137161264. * 4096.,
    (double)115377./3137161264. * 4096.,
    (double)84158./3137161264. * 4096.,
    (double)74510./3137161264. * 4096.,
    (double)53976./3137161264. * 4096.,
    (double)45190./3137161264. * 4096.,
    (double)29974./3137161264. * 4096.,
    (double)45091./3137161264. * 4096.,
    (double)81632./3137161264. * 4096.,
    (double)103405./3137161264. * 4096.,
    (double)68032./3137161264. * 4096.,
    (double)68691./3137161264. * 4096.,
    (double)57617./3137161264. * 4096.,
    (double)11951./3137161264. * 4096.,
    (double)48276./3137161264. * 4096.,
    (double)60537./3137161264. * 4096.,
    (double)41396./3137161264. * 4096.,
    (double)50040./3137161264. * 4096.,
    (double)49322./3137161264. * 4096.,
    (double)81959./3137161264. * 4096.,
    (double)73651./3137161264. * 4096.,
    (double)55216./3137161264. * 4096.,
    (double)36040./3137161264. * 4096.,
    (double)46050./3137161264. * 4096.,
    (double)89917./3137161264. * 4096.,
    (double)105802./3137161264. * 4096.,
    (double)97729./3137161264. * 4096.,
    (double)67763./3137161264. * 4096.,
    (double)93219./3137161264. * 4096.,
    (double)25739./3137161264. * 4096.,
    (double)69602./3137161264. * 4096.,
    (double)55819./3137161264. * 4096.,
    (double)47320./3137161264. * 4096.,
    (double)73120./3137161264. * 4096.,
    (double)49997./3137161264. * 4096.,
    (double)63566./3137161264. * 4096.,
    (double)10846./3137161264. * 4096.,
    (double)22217./3137161264. * 4096.,
    (double)11715./3137161264. * 4096.,
    (double)11335./3137161264. * 4096.,
    (double)23162./3137161264. * 4096.,
    (double)47922./3137161264. * 4096.,
    (double)43184./3137161264. * 4096.,
    (double)19772./3137161264. * 4096.,
    (double)24496./3137161264. * 4096.,
    (double)30117./3137161264. * 4096.,
    (double)57227./3137161264. * 4096.,
    (double)23369./3137161264. * 4096.,
    (double)8183./3137161264. * 4096.,
    (double)29171./3137161264. * 4096.,
    (double)17609./3137161264. * 4096.,
    (double)12878./3137161264. * 4096.,
    (double)57945./3137161264. * 4096.,
    (double)85461./3137161264. * 4096.,
    (double)77925./3137161264. * 4096.,
    (double)68437./3137161264. * 4096.,
    (double)17830./3137161264. * 4096.,
    (double)36215./3137161264. * 4096.,
    (double)47133./3137161264. * 4096.,
    (double)19413./3137161264. * 4096.,
    (double)107024./3137161264. * 4096.,
    (double)56835./3137161264. * 4096.,
    (double)102906./3137161264. * 4096.,
    (double)80542./3137161264. * 4096.,
    (double)40478./3137161264. * 4096.,
    (double)120547./3137161264. * 4096.,
    (double)90875./3137161264. * 4096.,
    (double)70944./3137161264. * 4096.,
    (double)46495./3137161264. * 4096.,
    (double)35783./3137161264. * 4096.,
    (double)34620./3137161264. * 4096.,
    (double)44871./3137161264. * 4096.,
    (double)81912./3137161264. * 4096.,
    (double)105890./3137161264. * 4096.,
    (double)100945./3137161264. * 4096.,
    (double)86157./3137161264. * 4096.,
    (double)71598./3137161264. * 4096.,
    (double)19615./3137161264. * 4096.,
    (double)79970./3137161264. * 4096.,
    (double)83654./3137161264. * 4096.,
    (double)47654./3137161264. * 4096.,
    (double)80785./3137161264. * 4096.,
    (double)70454./3137161264. * 4096.,
    (double)90350./3137161264. * 4096.,
    (double)87250./3137161264. * 4096.,
    (double)68767./3137161264. * 4096.,
    (double)46094./3137161264. * 4096.,
    (double)70702./3137161264. * 4096.,
    (double)60482./3137161264. * 4096.,
    (double)52779./3137161264. * 4096.,
    (double)44608./3137161264. * 4096.,
    (double)50402./3137161264. * 4096.,
    (double)61070./3137161264. * 4096.,
    (double)8723./3137161264. * 4096.,
    (double)34315./3137161264. * 4096.,
    (double)45001./3137161264. * 4096.,
    (double)73087./3137161264. * 4096.,
    (double)66924./3137161264. * 4096.,
    (double)53843./3137161264. * 4096.,
    (double)96286./3137161264. * 4096.,
    (double)106358./3137161264. * 4096.,
    (double)115031./3137161264. * 4096.,
    (double)68918./3137161264. * 4096.,
    (double)83422./3137161264. * 4096.,
    (double)114301./3137161264. * 4096.,
    (double)127549./3137161264. * 4096.,
    (double)105876./3137161264. * 4096.,
    (double)101294./3137161264. * 4096.,
    (double)99090./3137161264. * 4096.,
    (double)23684./3137161264. * 4096.,
    (double)97502./3137161264. * 4096.,
    (double)90957./3137161264. * 4096.,
    (double)77019./3137161264. * 4096.,
    (double)134677./3137161264. * 4096.,
    (double)80866./3137161264. * 4096.,
    (double)104901./3137161264. * 4096.,
    (double)55404./3137161264. * 4096.,
    (double)72204./3137161264. * 4096.,
    (double)62302./3137161264. * 4096.,
    (double)67946./3137161264. * 4096.,
    (double)8438./3137161264. * 4096.,
    (double)15578./3137161264. * 4096.,
    (double)13516./3137161264. * 4096.,
    (double)12631./3137161264. * 4096.,
    (double)68055./3137161264. * 4096.,
    (double)16423./3137161264. * 4096.,
    (double)69819./3137161264. * 4096.,
    (double)80154./3137161264. * 4096.,
    (double)50460./3137161264. * 4096.,
    (double)87824./3137161264. * 4096.,
    (double)103054./3137161264. * 4096.,
    (double)92898./3137161264. * 4096.,
    (double)72520./3137161264. * 4096.,
    (double)52116./3137161264. * 4096.,
    (double)43231./3137161264. * 4096.,
    (double)71249./3137161264. * 4096.,
    (double)62255./3137161264. * 4096.,
    (double)64985./3137161264. * 4096.,
    (double)55644./3137161264. * 4096.,
    (double)70817./3137161264. * 4096.,
    (double)77111./3137161264. * 4096.,
    (double)10367./3137161264. * 4096.,
    (double)68257./3137161264. * 4096.,
    (double)94952./3137161264. * 4096.,
    (double)88379./3137161264. * 4096.,
    (double)94768./3137161264. * 4096.,
    (double)104854./3137161264. * 4096.,
    (double)166066./3137161264. * 4096.,
    (double)1046986./3137161264. * 4096.,
    (double)742254./3137161264. * 4096.,
    (double)519873./3137161264. * 4096.,
    (double)832001./3137161264. * 4096.,
    (double)677882./3137161264. * 4096.,
    (double)598554./3137161264. * 4096.,
    (double)398585./3137161264. * 4096.,
    (double)513181./3137161264. * 4096.,
    (double)548388./3137161264. * 4096.,
    (double)63825./3137161264. * 4096.,
    (double)353854./3137161264. * 4096.,
    (double)437064./3137161264. * 4096.,
    (double)462441./3137161264. * 4096.,
    (double)412507./3137161264. * 4096.,
    (double)304944./3137161264. * 4096.,
    (double)502261./3137161264. * 4096.,
    (double)844130./3137161264. * 4096.,
    (double)732175./3137161264. * 4096.,
    (double)412735./3137161264. * 4096.,
    (double)515385./3137161264. * 4096.,
    (double)776712./3137161264. * 4096.,
    (double)656961./3137161264. * 4096.,
    (double)626451./3137161264. * 4096.,
    (double)516320./3137161264. * 4096.,
    (double)701740./3137161264. * 4096.,
    (double)103860./3137161264. * 4096.,
    (double)725447./3137161264. * 4096.,
    (double)649261./3137161264. * 4096.,
    (double)382416./3137161264. * 4096.,
    (double)570247./3137161264. * 4096.,
    (double)377579./3137161264. * 4096.,
    (double)504633./3137161264. * 4096.,
    (double)573782./3137161264. * 4096.,
    (double)720971./3137161264. * 4096.,
    (double)495716./3137161264. * 4096.,
    (double)599875./3137161264. * 4096.,
    (double)84120./3137161264. * 4096.,
    (double)113584./3137161264. * 4096.,
    (double)107167./3137161264. * 4096.,
    (double)129787./3137161264. * 4096.,
    (double)629842./3137161264. * 4096.,
    (double)130734./3137161264. * 4096.,
    (double)510735./3137161264. * 4096.,
    (double)548596./3137161264. * 4096.,
    (double)338544./3137161264. * 4096.,
    (double)670421./3137161264. * 4096.,
    (double)417627./3137161264. * 4096.,
    (double)544917./3137161264. * 4096.,
    (double)504364./3137161264. * 4096.,
    (double)345024./3137161264. * 4096.,
    (double)264590./3137161264. * 4096.,
    (double)501093./3137161264. * 4096.,
    (double)523314./3137161264. * 4096.,
    (double)492214./3137161264. * 4096.,
    (double)409522./3137161264. * 4096.,
    (double)555198./3137161264. * 4096.,
    (double)544286./3137161264. * 4096.,
    (double)65428./3137161264. * 4096.,
    (double)441789./3137161264. * 4096.,
    (double)620515./3137161264. * 4096.,
    (double)477337./3137161264. * 4096.,
    (double)422561./3137161264. * 4096.,
    (double)486609./3137161264. * 4096.,
    (double)922223./3137161264. * 4096.,
    (double)75307./3137161264. * 4096.,
    (double)74634./3137161264. * 4096.,
    (double)37045./3137161264. * 4096.,
    (double)56090./3137161264. * 4096.,
    (double)89510./3137161264. * 4096.,
    (double)130357./3137161264. * 4096.,
    (double)66558./3137161264. * 4096.,
    (double)67168./3137161264. * 4096.,
    (double)51220./3137161264. * 4096.,
    (double)14925./3137161264. * 4096.,
    (double)47817./3137161264. * 4096.,
    (double)49414./3137161264. * 4096.,
    (double)35328./3137161264. * 4096.,
    (double)51787./3137161264. * 4096.,
    (double)30059./3137161264. * 4096.,
    (double)48672./3137161264. * 4096.,
    (double)69141./3137161264. * 4096.,
    (double)85096./3137161264. * 4096.,
    (double)41414./3137161264. * 4096.,
    (double)41616./3137161264. * 4096.,
    (double)101952./3137161264. * 4096.,
    (double)111393./3137161264. * 4096.,
    (double)97825./3137161264. * 4096.,
    (double)66891./3137161264. * 4096.,
    (double)73449./3137161264. * 4096.,
    (double)32044./3137161264. * 4096.,
    (double)147073./3137161264. * 4096.,
    (double)86277./3137161264. * 4096.,
    (double)32765./3137161264. * 4096.,
    (double)61326./3137161264. * 4096.,
    (double)39290./3137161264. * 4096.,
    (double)41612./3137161264. * 4096.,
    (double)50829./3137161264. * 4096.,
    (double)94369./3137161264. * 4096.,
    (double)68574./3137161264. * 4096.,
    (double)54162./3137161264. * 4096.,
    (double)14793./3137161264. * 4096.,
    (double)37408./3137161264. * 4096.,
    (double)51601./3137161264. * 4096.,
    (double)18456./3137161264. * 4096.,
    (double)76995./3137161264. * 4096.,
    (double)38459./3137161264. * 4096.,
    (double)108395./3137161264. * 4096.,
    (double)94402./3137161264. * 4096.,
    (double)34481./3137161264. * 4096.,
    (double)87474./3137161264. * 4096.,
    (double)62443./3137161264. * 4096.,
    (double)60105./3137161264. * 4096.,
    (double)58518./3137161264. * 4096.,
    (double)43761./3137161264. * 4096.,
    (double)29821./3137161264. * 4096.,
    (double)55438./3137161264. * 4096.,
    (double)81380./3137161264. * 4096.,
    (double)106109./3137161264. * 4096.,
    (double)85308./3137161264. * 4096.,
    (double)88594./3137161264. * 4096.,
    (double)60918./3137161264. * 4096.,
    (double)13081./3137161264. * 4096.,
    (double)61396./3137161264. * 4096.,
    (double)95374./3137161264. * 4096.,
    (double)44380./3137161264. * 4096.,
    (double)49043./3137161264. * 4096.,
    (double)50706./3137161264. * 4096.,
    (double)89722./3137161264. * 4096.,
    (double)775242./3137161264. * 4096.,
    (double)527221./3137161264. * 4096.,
    (double)361564./3137161264. * 4096.,
    (double)361580./3137161264. * 4096.,
    (double)678098./3137161264. * 4096.,
    (double)735940./3137161264. * 4096.,
    (double)689959./3137161264. * 4096.,
    (double)495765./3137161264. * 4096.,
    (double)576829./3137161264. * 4096.,
    (double)106390./3137161264. * 4096.,
    (double)534474./3137161264. * 4096.,
    (double)485657./3137161264. * 4096.,
    (double)331658./3137161264. * 4096.,
    (double)436127./3137161264. * 4096.,
    (double)430062./3137161264. * 4096.,
    (double)507601./3137161264. * 4096.,
    (double)63179./3137161264. * 4096.,
    (double)95546./3137161264. * 4096.,
    (double)52861./3137161264. * 4096.,
    (double)42705./3137161264. * 4096.,
    (double)71149./3137161264. * 4096.,
    (double)117188./3137161264. * 4096.,
    (double)141319./3137161264. * 4096.,
    (double)52566./3137161264. * 4096.,
    (double)73059./3137161264. * 4096.,
    (double)30491./3137161264. * 4096.,
    (double)116832./3137161264. * 4096.,
    (double)74924./3137161264. * 4096.,
    (double)40661./3137161264. * 4096.,
    (double)86160./3137161264. * 4096.,
    (double)68986./3137161264. * 4096.,
    (double)57805./3137161264. * 4096.,
    (double)545538./3137161264. * 4096.,
    (double)622468./3137161264. * 4096.,
    (double)485251./3137161264. * 4096.,
    (double)452403./3137161264. * 4096.,
    (double)77392./3137161264. * 4096.,
    (double)93001./3137161264. * 4096.,
    (double)107935./3137161264. * 4096.,
    (double)81526./3137161264. * 4096.,
    (double)500530./3137161264. * 4096.,
    (double)91415./3137161264. * 4096.,
    (double)209958./3137161264. * 4096.,
    (double)305578./3137161264. * 4096.,
    (double)249148./3137161264. * 4096.,
    (double)419967./3137161264. * 4096.,
    (double)410600./3137161264. * 4096.,
    (double)416284./3137161264. * 4096.,
    (double)360957./3137161264. * 4096.,
    (double)274134./3137161264. * 4096.,
    (double)240717./3137161264. * 4096.,
    (double)276687./3137161264. * 4096.,
    (double)508087./3137161264. * 4096.,
    (double)546821./3137161264. * 4096.,
    (double)495348./3137161264. * 4096.,
    (double)478690./3137161264. * 4096.,
    (double)494834./3137161264. * 4096.,
    (double)74003./3137161264. * 4096.,
    (double)535123./3137161264. * 4096.,
    (double)533338./3137161264. * 4096.,
    (double)315618./3137161264. * 4096.,
    (double)387800./3137161264. * 4096.,
    (double)482470./3137161264. * 4096.,
    (double)587709./3137161264. * 4096.,
    (double)580167./3137161264. * 4096.,
    (double)358559./3137161264. * 4096.,
    (double)270955./3137161264. * 4096.,
    (double)411549./3137161264. * 4096.,
    (double)406458./3137161264. * 4096.,
    (double)316534./3137161264. * 4096.,
    (double)244945./3137161264. * 4096.,
    (double)266055./3137161264. * 4096.,
    (double)366921./3137161264. * 4096.,
    (double)45143./3137161264. * 4096.,
    (double)276501./3137161264. * 4096.,
    (double)345047./3137161264. * 4096.,
    (double)338913./3137161264. * 4096.,
    (double)309222./3137161264. * 4096.,
    (double)246524./3137161264. * 4096.,
    (double)441888./3137161264. * 4096.,
    (double)624231./3137161264. * 4096.,
    (double)579689./3137161264. * 4096.,
    (double)363386./3137161264. * 4096.,
    (double)406112./3137161264. * 4096.,
    (double)617643./3137161264. * 4096.,
    (double)657653./3137161264. * 4096.,
    (double)560143./3137161264. * 4096.,
    (double)402060./3137161264. * 4096.,
    (double)510214./3137161264. * 4096.,
    (double)75340./3137161264. * 4096.,
    (double)560233./3137161264. * 4096.,
    (double)550719./3137161264. * 4096.,
    (double)384763./3137161264. * 4096.,
    (double)555894./3137161264. * 4096.,
    (double)420816./3137161264. * 4096.,
    (double)485781./3137161264. * 4096.,
    (double)517440./3137161264. * 4096.,
    (double)615237./3137161264. * 4096.,
    (double)436618./3137161264. * 4096.,
    (double)536457./3137161264. * 4096.,
    (double)59775./3137161264. * 4096.,
    (double)88008./3137161264. * 4096.,
    (double)63527./3137161264. * 4096.,
    (double)72951./3137161264. * 4096.,
    (double)577690./3137161264. * 4096.,
    (double)81871./3137161264. * 4096.,
    (double)607649./3137161264. * 4096.,
    (double)642781./3137161264. * 4096.,
    (double)369964./3137161264. * 4096.,
    (double)626173./3137161264. * 4096.,
    (double)540616./3137161264. * 4096.,
    (double)609294./3137161264. * 4096.,
    (double)460723./3137161264. * 4096.,
    (double)319655./3137161264. * 4096.,
    (double)264081./3137161264. * 4096.,
    (double)425028./3137161264. * 4096.,
    (double)457483./3137161264. * 4096.,
    (double)448450./3137161264. * 4096.,
    (double)350267./3137161264. * 4096.,
    (double)436122./3137161264. * 4096.,
    (double)562552./3137161264. * 4096.,
    (double)59563./3137161264. * 4096.,
    (double)604325./3137161264. * 4096.,
    (double)682981./3137161264. * 4096.,
    (double)532907./3137161264. * 4096.,
    (double)567544./3137161264. * 4096.,
    (double)619788./3137161264. * 4096.,
    (double)864728./3137161264. * 4096.,
    (double)1021591./3137161264. * 4096.,
    (double)510942./3137161264. * 4096.,
    (double)374869./3137161264. * 4096.,
    (double)728339./3137161264. * 4096.,
    (double)501198./3137161264. * 4096.,
    (double)336081./3137161264. * 4096.,
    (double)271402./3137161264. * 4096.,
    (double)395432./3137161264. * 4096.,
    (double)439027./3137161264. * 4096.,
    (double)45418./3137161264. * 4096.,
    (double)218552./3137161264. * 4096.,
    (double)352714./3137161264. * 4096.,
    (double)544884./3137161264. * 4096.,
    (double)405251./3137161264. * 4096.,
    (double)283272./3137161264. * 4096.,
    (double)617835./3137161264. * 4096.,
    (double)638816./3137161264. * 4096.,
    (double)381170./3137161264. * 4096.,
    (double)240006./3137161264. * 4096.,
    (double)356305./3137161264. * 4096.,
    (double)395466./3137161264. * 4096.,
    (double)259020./3137161264. * 4096.,
    (double)238089./3137161264. * 4096.,
    (double)283654./3137161264. * 4096.,
    (double)330639./3137161264. * 4096.,
    (double)28969./3137161264. * 4096.,
    (double)228085./3137161264. * 4096.,
    (double)303229./3137161264. * 4096.,
    (double)277729./3137161264. * 4096.,
    (double)263379./3137161264. * 4096.,
    (double)206937./3137161264. * 4096.,
    (double)350162./3137161264. * 4096.,
    (double)482739./3137161264. * 4096.,
    (double)407387./3137161264. * 4096.,
    (double)260855./3137161264. * 4096.,
    (double)440842./3137161264. * 4096.,
    (double)43123./3137161264. * 4096.,
    (double)38035./3137161264. * 4096.,
    (double)30473./3137161264. * 4096.,
    (double)62296./3137161264. * 4096.,
    (double)364174./3137161264. * 4096.,
    (double)36146./3137161264. * 4096.,
    (double)233457./3137161264. * 4096.,
    (double)362308./3137161264. * 4096.,
    (double)317439./3137161264. * 4096.,
    (double)362886./3137161264. * 4096.,
    (double)292068./3137161264. * 4096.,
    (double)471948./3137161264. * 4096.,
    (double)586173./3137161264. * 4096.,
    (double)320344./3137161264. * 4096.,
    (double)265489./3137161264. * 4096.,
    (double)541280./3137161264. * 4096.,
    (double)417374./3137161264. * 4096.,
    (double)296465./3137161264. * 4096.,
    (double)258307./3137161264. * 4096.,
    (double)454332./3137161264. * 4096.,
    (double)385247./3137161264. * 4096.,
    (double)32781./3137161264. * 4096.,
    (double)237361./3137161264. * 4096.,
    (double)407662./3137161264. * 4096.,
    (double)517715./3137161264. * 4096.,
    (double)357525./3137161264. * 4096.,
    (double)387383./3137161264. * 4096.,
    (double)872500./3137161264. * 4096.,
    (double)992600./3137161264. * 4096.,
    (double)658420./3137161264. * 4096.,
    (double)386270./3137161264. * 4096.,
    (double)677175./3137161264. * 4096.,
    (double)717007./3137161264. * 4096.,
    (double)633122./3137161264. * 4096.,
    (double)445589./3137161264. * 4096.,
    (double)503914./3137161264. * 4096.,
    (double)497144./3137161264. * 4096.,
    (double)58105./3137161264. * 4096.,
    (double)323881./3137161264. * 4096.,
    (double)444164./3137161264. * 4096.,
    (double)443584./3137161264. * 4096.,
    (double)474060./3137161264. * 4096.,
    (double)276423./3137161264. * 4096.,
    (double)554665./3137161264. * 4096.,
    (double)757640./3137161264. * 4096.,
    (double)634309./3137161264. * 4096.,
    (double)319654./3137161264. * 4096.,
    (double)448651./3137161264. * 4096.,
    (double)696491./3137161264. * 4096.,
    (double)554724./3137161264. * 4096.,
    (double)468119./3137161264. * 4096.,
    (double)473432./3137161264. * 4096.,
    (double)509833./3137161264. * 4096.,
    (double)62439./3137161264. * 4096.,
    (double)462156./3137161264. * 4096.,
    (double)531718./3137161264. * 4096.,
    (double)326750./3137161264. * 4096.,
    (double)414139./3137161264. * 4096.,
    (double)275867./3137161264. * 4096.,
    (double)414248./3137161264. * 4096.,
    (double)511950./3137161264. * 4096.,
    (double)613733./3137161264. * 4096.,
    (double)380702./3137161264. * 4096.,
    (double)502078./3137161264. * 4096.,
    (double)51486./3137161264. * 4096.,
    (double)73180./3137161264. * 4096.,
    (double)63012./3137161264. * 4096.,
    (double)69310./3137161264. * 4096.,
    (double)530169./3137161264. * 4096.,
    (double)71787./3137161264. * 4096.,
    (double)436682./3137161264. * 4096.,
    (double)621920./3137161264. * 4096.,
    (double)368697./3137161264. * 4096.,
    (double)598642./3137161264. * 4096.,
    (double)420356./3137161264. * 4096.,
    (double)603894./3137161264. * 4096.,
    (double)584749./3137161264. * 4096.,
    (double)385279./3137161264. * 4096.,
    (double)291402./3137161264. * 4096.,
    (double)513232./3137161264. * 4096.,
    (double)592479./3137161264. * 4096.,
    (double)548644./3137161264. * 4096.,
    (double)435755./3137161264. * 4096.,
    (double)638981./3137161264. * 4096.,
    (double)486554./3137161264. * 4096.,
    (double)51466./3137161264. * 4096.,
    (double)365410./3137161264. * 4096.,
    (double)612133./3137161264. * 4096.,
    (double)450868./3137161264. * 4096.,
    (double)440640./3137161264. * 4096.,
    (double)412859./3137161264. * 4096.,
    (double)792381./3137161264. * 4096.,
    (double)784608./3137161264. * 4096.,
    (double)453338./3137161264. * 4096.,
    (double)319932./3137161264. * 4096.,
    (double)449136./3137161264. * 4096.,
    (double)594897./3137161264. * 4096.,
    (double)496701./3137161264. * 4096.,
    (double)461361./3137161264. * 4096.,
    (double)506752./3137161264. * 4096.,
    (double)539868./3137161264. * 4096.,
    (double)72944./3137161264. * 4096.,
    (double)352501./3137161264. * 4096.,
    (double)492208./3137161264. * 4096.,
    (double)404221./3137161264. * 4096.,
    (double)421139./3137161264. * 4096.,
    (double)398729./3137161264. * 4096.,
    (double)642624./3137161264. * 4096.,
    (double)58785./3137161264. * 4096.,
    (double)52767./3137161264. * 4096.,
    (double)31105./3137161264. * 4096.,
    (double)41810./3137161264. * 4096.,
    (double)51511./3137161264. * 4096.,
    (double)71278./3137161264. * 4096.,
    (double)59702./3137161264. * 4096.,
    (double)51471./3137161264. * 4096.,
    (double)42685./3137161264. * 4096.,
    (double)10724./3137161264. * 4096.,
    (double)50311./3137161264. * 4096.,
    (double)59037./3137161264. * 4096.,
    (double)37363./3137161264. * 4096.,
    (double)59872./3137161264. * 4096.,
    (double)42938./3137161264. * 4096.,
    (double)55618./3137161264. * 4096.,
    (double)485626./3137161264. * 4096.,
    (double)559767./3137161264. * 4096.,
    (double)376267./3137161264. * 4096.,
    (double)483735./3137161264. * 4096.,
    (double)48333./3137161264. * 4096.,
    (double)55976./3137161264. * 4096.,
    (double)55546./3137161264. * 4096.,
    (double)72395./3137161264. * 4096.,
    (double)570154./3137161264. * 4096.,
    (double)82227./3137161264. * 4096.,
    (double)402336./3137161264. * 4096.,
    (double)528238./3137161264. * 4096.,
    (double)337136./3137161264. * 4096.,
    (double)524424./3137161264. * 4096.,
    (double)475644./3137161264. * 4096.,
    (double)555821./3137161264. * 4096.,
    (double)458535./3137161264. * 4096.,
    (double)327199./3137161264. * 4096.,
    (double)306846./3137161264. * 4096.,
    (double)407824./3137161264. * 4096.,
    (double)562645./3137161264. * 4096.,
    (double)493447./3137161264. * 4096.,
    (double)498060./3137161264. * 4096.,
    (double)617477./3137161264. * 4096.,
    (double)527803./3137161264. * 4096.,
    (double)56224./3137161264. * 4096.,
    (double)493001./3137161264. * 4096.,
    (double)705731./3137161264. * 4096.,
    (double)437345./3137161264. * 4096.,
    (double)430679./3137161264. * 4096.,
    (double)560675./3137161264. * 4096.,
    (double)785060./3137161264. * 4096.,
    (double)786067./3137161264. * 4096.,
    (double)372471./3137161264. * 4096.,
    (double)301105./3137161264. * 4096.,
    (double)534616./3137161264. * 4096.,
    (double)405125./3137161264. * 4096.,
    (double)281815./3137161264. * 4096.,
    (double)252548./3137161264. * 4096.,
    (double)310484./3137161264. * 4096.,
    (double)435761./3137161264. * 4096.,
    (double)49781./3137161264. * 4096.,
    (double)246161./3137161264. * 4096.,
    (double)382216./3137161264. * 4096.,
    (double)460067./3137161264. * 4096.,
    (double)339228./3137161264. * 4096.,
    (double)300736./3137161264. * 4096.,
    (double)651861./3137161264. * 4096.,
    (double)562309./3137161264. * 4096.,
    (double)381342./3137161264. * 4096.,
    (double)257556./3137161264. * 4096.,
    (double)383880./3137161264. * 4096.,
    (double)424200./3137161264. * 4096.,
    (double)368676./3137161264. * 4096.,
    (double)326185./3137161264. * 4096.,
    (double)345666./3137161264. * 4096.,
    (double)357193./3137161264. * 4096.,
    (double)32728./3137161264. * 4096.,
    (double)312249./3137161264. * 4096.,
    (double)442055./3137161264. * 4096.,
    (double)341948./3137161264. * 4096.,
    (double)351093./3137161264. * 4096.,
    (double)312683./3137161264. * 4096.,
    (double)487829./3137161264. * 4096.,
    (double)548563./3137161264. * 4096.,
    (double)532439./3137161264. * 4096.,
    (double)386536./3137161264. * 4096.,
    (double)594577./3137161264. * 4096.,
    (double)44199./3137161264. * 4096.,
    (double)47882./3137161264. * 4096.,
    (double)34756./3137161264. * 4096.,
    (double)60994./3137161264. * 4096.,
    (double)575216./3137161264. * 4096.,
    (double)54959./3137161264. * 4096.,
    (double)490116./3137161264. * 4096.,
    (double)702032./3137161264. * 4096.,
    (double)477377./3137161264. * 4096.,
    (double)596460./3137161264. * 4096.,
    (double)567806./3137161264. * 4096.,
    (double)717751./3137161264. * 4096.,
    (double)736506./3137161264. * 4096.,
    (double)400024./3137161264. * 4096.,
    (double)365588./3137161264. * 4096.,
    (double)735829./3137161264. * 4096.,
    (double)565185./3137161264. * 4096.,
    (double)490545./3137161264. * 4096.,
    (double)426726./3137161264. * 4096.,
    (double)620542./3137161264. * 4096.,
    (double)669915./3137161264. * 4096.,
    (double)51596./3137161264. * 4096.,
    (double)586092./3137161264. * 4096.,
    (double)904012./3137161264. * 4096.,
    (double)836052./3137161264. * 4096.,
    (double)658014./3137161264. * 4096.,
    (double)794180./3137161264. * 4096.,
    (double)1201945./3137161264. * 4096.,
    (double)2036330./3137161264. * 4096.,
    (double)915368./3137161264. * 4096.,
    (double)791704./3137161264. * 4096.,
    (double)1730225./3137161264. * 4096.,
    (double)825776./3137161264. * 4096.,
    (double)478319./3137161264. * 4096.,
    (double)408578./3137161264. * 4096.,
    (double)616716./3137161264. * 4096.,
    (double)798423./3137161264. * 4096.,
    (double)68649./3137161264. * 4096.,
    (double)317942./3137161264. * 4096.,
    (double)577849./3137161264. * 4096.,
    (double)1309699./3137161264. * 4096.,
    (double)900407./3137161264. * 4096.,
    (double)491696./3137161264. * 4096.,
    (double)1067826./3137161264. * 4096.,
    (double)786620./3137161264. * 4096.,
    (double)415263./3137161264. * 4096.,
    (double)305971./3137161264. * 4096.,
    (double)468793./3137161264. * 4096.,
    (double)443444./3137161264. * 4096.,
    (double)247211./3137161264. * 4096.,
    (double)228389./3137161264. * 4096.,
    (double)280851./3137161264. * 4096.,
    (double)429113./3137161264. * 4096.,
    (double)31780./3137161264. * 4096.,
    (double)242929./3137161264. * 4096.,
    (double)297317./3137161264. * 4096.,
    (double)458997./3137161264. * 4096.,
    (double)404136./3137161264. * 4096.,
    (double)257904./3137161264. * 4096.,
    (double)452499./3137161264. * 4096.,
    (double)595292./3137161264. * 4096.,
    (double)401655./3137161264. * 4096.,
    (double)309118./3137161264. * 4096.,
    (double)566672./3137161264. * 4096.,
    (double)48164./3137161264. * 4096.,
    (double)33104./3137161264. * 4096.,
    (double)27008./3137161264. * 4096.,
    (double)62300./3137161264. * 4096.,
    (double)342451./3137161264. * 4096.,
    (double)26772./3137161264. * 4096.,
    (double)185519./3137161264. * 4096.,
    (double)295328./3137161264. * 4096.,
    (double)366585./3137161264. * 4096.,
    (double)363783./3137161264. * 4096.,
    (double)277683./3137161264. * 4096.,
    (double)501717./3137161264. * 4096.,
    (double)989612./3137161264. * 4096.,
    (double)437159./3137161264. * 4096.,
    (double)402533./3137161264. * 4096.,
    (double)846011./3137161264. * 4096.,
    (double)580799./3137161264. * 4096.,
    (double)355331./3137161264. * 4096.,
    (double)304726./3137161264. * 4096.,
    (double)533620./3137161264. * 4096.,
    (double)471571./3137161264. * 4096.,
    (double)34522./3137161264. * 4096.,
    (double)270069./3137161264. * 4096.,
    (double)444718./3137161264. * 4096.,
    (double)750888./3137161264. * 4096.,
    (double)447600./3137161264. * 4096.,
    (double)475582./3137161264. * 4096.,
    (double)1158058./3137161264. * 4096.,
    (double)944835./3137161264. * 4096.,
    (double)457488./3137161264. * 4096.,
    (double)299195./3137161264. * 4096.,
    (double)568108./3137161264. * 4096.,
    (double)491847./3137161264. * 4096.,
    (double)292953./3137161264. * 4096.,
    (double)217252./3137161264. * 4096.,
    (double)301875./3137161264. * 4096.,
    (double)366007./3137161264. * 4096.,
    (double)34503./3137161264. * 4096.,
    (double)161778./3137161264. * 4096.,
    (double)272958./3137161264. * 4096.,
    (double)434750./3137161264. * 4096.,
    (double)350473./3137161264. * 4096.,
    (double)193445./3137161264. * 4096.,
    (double)431740./3137161264. * 4096.,
    (double)502538./3137161264. * 4096.,
    (double)302698./3137161264. * 4096.,
    (double)178433./3137161264. * 4096.,
    (double)286273./3137161264. * 4096.,
    (double)296702./3137161264. * 4096.,
    (double)177272./3137161264. * 4096.,
    (double)151331./3137161264. * 4096.,
    (double)197104./3137161264. * 4096.,
    (double)295888./3137161264. * 4096.,
    (double)25842./3137161264. * 4096.,
    (double)147521./3137161264. * 4096.,
    (double)226971./3137161264. * 4096.,
    (double)274560./3137161264. * 4096.,
    (double)234940./3137161264. * 4096.,
    (double)153718./3137161264. * 4096.,
    (double)268655./3137161264. * 4096.,
    (double)393258./3137161264. * 4096.,
    (double)300007./3137161264. * 4096.,
    (double)209675./3137161264. * 4096.,
    (double)338226./3137161264. * 4096.,
    (double)30181./3137161264. * 4096.,
    (double)23657./3137161264. * 4096.,
    (double)17333./3137161264. * 4096.,
    (double)30225./3137161264. * 4096.,
    (double)314272./3137161264. * 4096.,
    (double)31359./3137161264. * 4096.,
    (double)145229./3137161264. * 4096.,
    (double)244311./3137161264. * 4096.,
    (double)274574./3137161264. * 4096.,
    (double)304396./3137161264. * 4096.,
    (double)206089./3137161264. * 4096.,
    (double)321292./3137161264. * 4096.,
    (double)398259./3137161264. * 4096.,
    (double)240032./3137161264. * 4096.,
    (double)165952./3137161264. * 4096.,
    (double)338148./3137161264. * 4096.,
    (double)315035./3137161264. * 4096.,
    (double)222598./3137161264. * 4096.,
    (double)155621./3137161264. * 4096.,
    (double)262248./3137161264. * 4096.,
    (double)282024./3137161264. * 4096.,
    (double)19967./3137161264. * 4096.,
    (double)150940./3137161264. * 4096.,
    (double)269198./3137161264. * 4096.,
    (double)325537./3137161264. * 4096.,
    (double)247743./3137161264. * 4096.,
    (double)239706./3137161264. * 4096.,
    (double)536468./3137161264. * 4096.,
    (double)734291./3137161264. * 4096.,
    (double)314465./3137161264. * 4096.,
    (double)257023./3137161264. * 4096.,
    (double)464602./3137161264. * 4096.,
    (double)488592./3137161264. * 4096.,
    (double)282497./3137161264. * 4096.,
    (double)252031./3137161264. * 4096.,
    (double)375847./3137161264. * 4096.,
    (double)496772./3137161264. * 4096.,
    (double)50640./3137161264. * 4096.,
    (double)162881./3137161264. * 4096.,
    (double)288615./3137161264. * 4096.,
    (double)570177./3137161264. * 4096.,
    (double)402340./3137161264. * 4096.,
    (double)247763./3137161264. * 4096.,
    (double)606350./3137161264. * 4096.,
    (double)49780./3137161264. * 4096.,
    (double)31232./3137161264. * 4096.,
    (double)21625./3137161264. * 4096.,
    (double)39228./3137161264. * 4096.,
    (double)37613./3137161264. * 4096.,
    (double)26396./3137161264. * 4096.,
    (double)23920./3137161264. * 4096.,
    (double)34412./3137161264. * 4096.,
    (double)37818./3137161264. * 4096.,
    (double)4513./3137161264. * 4096.,
    (double)19506./3137161264. * 4096.,
    (double)30746./3137161264. * 4096.,
    (double)63568./3137161264. * 4096.,
    (double)62128./3137161264. * 4096.,
    (double)28989./3137161264. * 4096.,
    (double)62185./3137161264. * 4096.,
    (double)322319./3137161264. * 4096.,
    (double)241255./3137161264. * 4096.,
    (double)226199./3137161264. * 4096.,
    (double)314347./3137161264. * 4096.,
    (double)26978./3137161264. * 4096.,
    (double)19451./3137161264. * 4096.,
    (double)20184./3137161264. * 4096.,
    (double)33561./3137161264. * 4096.,
    (double)264347./3137161264. * 4096.,
    (double)25573./3137161264. * 4096.,
    (double)140134./3137161264. * 4096.,
    (double)209003./3137161264. * 4096.,
    (double)253718./3137161264. * 4096.,
    (double)266310./3137161264. * 4096.,
    (double)219495./3137161264. * 4096.,
    (double)317240./3137161264. * 4096.,
    (double)346736./3137161264. * 4096.,
    (double)204203./3137161264. * 4096.,
    (double)197352./3137161264. * 4096.,
    (double)356616./3137161264. * 4096.,
    (double)356681./3137161264. * 4096.,
    (double)241682./3137161264. * 4096.,
    (double)217326./3137161264. * 4096.,
    (double)341810./3137161264. * 4096.,
    (double)323454./3137161264. * 4096.,
    (double)33001./3137161264. * 4096.,
    (double)185332./3137161264. * 4096.,
    (double)313075./3137161264. * 4096.,
    (double)385141./3137161264. * 4096.,
    (double)299722./3137161264. * 4096.,
    (double)305821./3137161264. * 4096.,
    (double)591712./3137161264. * 4096.,
    (double)990646./3137161264. * 4096.,
    (double)367012./3137161264. * 4096.,
    (double)309188./3137161264. * 4096.,
    (double)704244./3137161264. * 4096.,
    (double)409391./3137161264. * 4096.,
    (double)221665./3137161264. * 4096.,
    (double)221026./3137161264. * 4096.,
    (double)333072./3137161264. * 4096.,
    (double)521965./3137161264. * 4096.,
    (double)43738./3137161264. * 4096.,
    (double)208931./3137161264. * 4096.,
    (double)350872./3137161264. * 4096.,
    (double)941504./3137161264. * 4096.,
    (double)498140./3137161264. * 4096.,
    (double)331334./3137161264. * 4096.,
    (double)847341./3137161264. * 4096.,
    (double)552468./3137161264. * 4096.,
    (double)302765./3137161264. * 4096.,
    (double)233508./3137161264. * 4096.,
    (double)368971./3137161264. * 4096.,
    (double)317006./3137161264. * 4096.,
    (double)204049./3137161264. * 4096.,
    (double)195575./3137161264. * 4096.,
    (double)257985./3137161264. * 4096.,
    (double)361987./3137161264. * 4096.,
    (double)25696./3137161264. * 4096.,
    (double)192714./3137161264. * 4096.,
    (double)303824./3137161264. * 4096.,
    (double)488761./3137161264. * 4096.,
    (double)409235./3137161264. * 4096.,
    (double)253097./3137161264. * 4096.,
    (double)499616./3137161264. * 4096.,
    (double)392942./3137161264. * 4096.,
    (double)303007./3137161264. * 4096.,
    (double)260467./3137161264. * 4096.,
    (double)398110./3137161264. * 4096.,
    (double)28887./3137161264. * 4096.,
    (double)20734./3137161264. * 4096.,
    (double)20313./3137161264. * 4096.,
    (double)33474./3137161264. * 4096.,
    (double)319562./3137161264. * 4096.,
    (double)22635./3137161264. * 4096.,
    (double)188835./3137161264. * 4096.,
    (double)292099./3137161264. * 4096.,
    (double)341449./3137161264. * 4096.,
    (double)349364./3137161264. * 4096.,
    (double)306141./3137161264. * 4096.,
    (double)469859./3137161264. * 4096.,
    (double)682600./3137161264. * 4096.,
    (double)339962./3137161264. * 4096.,
    (double)321041./3137161264. * 4096.,
    (double)699394./3137161264. * 4096.,
    (double)401987./3137161264. * 4096.,
    (double)259763./3137161264. * 4096.,
    (double)250252./3137161264. * 4096.,
    (double)405775./3137161264. * 4096.,
    (double)529862./3137161264. * 4096.,
    (double)36419./3137161264. * 4096.,
    (double)320085./3137161264. * 4096.,
    (double)554524./3137161264. * 4096.,
    (double)886076./3137161264. * 4096.,
    (double)625293./3137161264. * 4096.,
    (double)652401./3137161264. * 4096.,
    (double)1446684./3137161264. * 4096.,
    (double)1013524./3137161264. * 4096.,
    (double)556029./3137161264. * 4096.,
    (double)417680./3137161264. * 4096.,
    (double)773647./3137161264. * 4096.,
    (double)557184./3137161264. * 4096.,
    (double)380500./3137161264. * 4096.,
    (double)286637./3137161264. * 4096.,
    (double)387626./3137161264. * 4096.,
    (double)418380./3137161264. * 4096.,
    (double)42772./3137161264. * 4096.,
    (double)198601./3137161264. * 4096.,
    (double)334941./3137161264. * 4096.,
    (double)526258./3137161264. * 4096.,
    (double)467048./3137161264. * 4096.,
    (double)270505./3137161264. * 4096.,
    (double)549513./3137161264. * 4096.,
    (double)630623./3137161264. * 4096.,
    (double)388612./3137161264. * 4096.,
    (double)304177./3137161264. * 4096.,
    (double)407118./3137161264. * 4096.,
    (double)430385./3137161264. * 4096.,
    (double)296495./3137161264. * 4096.,
    (double)299434./3137161264. * 4096.,
    (double)301109./3137161264. * 4096.,
    (double)333421./3137161264. * 4096.,
    (double)35672./3137161264. * 4096.,
    (double)273460./3137161264. * 4096.,
    (double)298591./3137161264. * 4096.,
    (double)276765./3137161264. * 4096.,
    (double)299908./3137161264. * 4096.,
    (double)219611./3137161264. * 4096.,
    (double)346178./3137161264. * 4096.,
    (double)371362./3137161264. * 4096.,
    (double)327377./3137161264. * 4096.,
    (double)226449./3137161264. * 4096.,
    (double)368067./3137161264. * 4096.,
    (double)33582./3137161264. * 4096.,
    (double)33438./3137161264. * 4096.,
    (double)24265./3137161264. * 4096.,
    (double)42826./3137161264. * 4096.,
    (double)249111./3137161264. * 4096.,
    (double)26613./3137161264. * 4096.,
    (double)169268./3137161264. * 4096.,
    (double)260931./3137161264. * 4096.,
    (double)224109./3137161264. * 4096.,
    (double)276731./3137161264. * 4096.,
    (double)221641./3137161264. * 4096.,
    (double)371164./3137161264. * 4096.,
    (double)418724./3137161264. * 4096.,
    (double)231998./3137161264. * 4096.,
    (double)202347./3137161264. * 4096.,
    (double)372418./3137161264. * 4096.,
    (double)373987./3137161264. * 4096.,
    (double)291205./3137161264. * 4096.,
    (double)212038./3137161264. * 4096.,
    (double)323764./3137161264. * 4096.,
    (double)261658./3137161264. * 4096.,
    (double)23513./3137161264. * 4096.,
    (double)160008./3137161264. * 4096.,
    (double)262340./3137161264. * 4096.,
    (double)338981./3137161264. * 4096.,
    (double)250811./3137161264. * 4096.,
    (double)270051./3137161264. * 4096.,
    (double)578114./3137161264. * 4096.,
    (double)674868./3137161264. * 4096.,
    (double)424166./3137161264. * 4096.,
    (double)231849./3137161264. * 4096.,
    (double)415348./3137161264. * 4096.,
    (double)448995./3137161264. * 4096.,
    (double)367071./3137161264. * 4096.,
    (double)226586./3137161264. * 4096.,
    (double)275772./3137161264. * 4096.,
    (double)281134./3137161264. * 4096.,
    (double)32612./3137161264. * 4096.,
    (double)132312./3137161264. * 4096.,
    (double)215786./3137161264. * 4096.,
    (double)284957./3137161264. * 4096.,
    (double)282778./3137161264. * 4096.,
    (double)156434./3137161264. * 4096.,
    (double)315402./3137161264. * 4096.,
    (double)462332./3137161264. * 4096.,
    (double)387020./3137161264. * 4096.,
    (double)192355./3137161264. * 4096.,
    (double)277169./3137161264. * 4096.,
    (double)390104./3137161264. * 4096.,
    (double)274544./3137161264. * 4096.,
    (double)214368./3137161264. * 4096.,
    (double)245086./3137161264. * 4096.,
    (double)285524./3137161264. * 4096.,
    (double)39475./3137161264. * 4096.,
    (double)176950./3137161264. * 4096.,
    (double)241979./3137161264. * 4096.,
    (double)215090./3137161264. * 4096.,
    (double)259117./3137161264. * 4096.,
    (double)158594./3137161264. * 4096.,
    (double)239390./3137161264. * 4096.,
    (double)307771./3137161264. * 4096.,
    (double)325303./3137161264. * 4096.,
    (double)189473./3137161264. * 4096.,
    (double)282813./3137161264. * 4096.,
    (double)32217./3137161264. * 4096.,
    (double)37683./3137161264. * 4096.,
    (double)24259./3137161264. * 4096.,
    (double)32858./3137161264. * 4096.,
    (double)298546./3137161264. * 4096.,
    (double)38830./3137161264. * 4096.,
    (double)176366./3137161264. * 4096.,
    (double)268601./3137161264. * 4096.,
    (double)215052./3137161264. * 4096.,
    (double)311970./3137161264. * 4096.,
    (double)215163./3137161264. * 4096.,
    (double)330676./3137161264. * 4096.,
    (double)267169./3137161264. * 4096.,
    (double)191283./3137161264. * 4096.,
    (double)127303./3137161264. * 4096.,
    (double)236440./3137161264. * 4096.,
    (double)282251./3137161264. * 4096.,
    (double)272380./3137161264. * 4096.,
    (double)158567./3137161264. * 4096.,
    (double)229435./3137161264. * 4096.,
    (double)215233./3137161264. * 4096.,
    (double)18676./3137161264. * 4096.,
    (double)129685./3137161264. * 4096.,
    (double)217164./3137161264. * 4096.,
    (double)226065./3137161264. * 4096.,
    (double)205875./3137161264. * 4096.,
    (double)188970./3137161264. * 4096.,
    (double)381703./3137161264. * 4096.,
    (double)445739./3137161264. * 4096.,
    (double)234441./3137161264. * 4096.,
    (double)163611./3137161264. * 4096.,
    (double)276576./3137161264. * 4096.,
    (double)341953./3137161264. * 4096.,
    (double)262297./3137161264. * 4096.,
    (double)229580./3137161264. * 4096.,
    (double)261887./3137161264. * 4096.,
    (double)293791./3137161264. * 4096.,
    (double)39228./3137161264. * 4096.,
    (double)140421./3137161264. * 4096.,
    (double)205828./3137161264. * 4096.,
    (double)272669./3137161264. * 4096.,
    (double)259243./3137161264. * 4096.,
    (double)175601./3137161264. * 4096.,
    (double)363180./3137161264. * 4096.,
    (double)24569./3137161264. * 4096.,
    (double)24632./3137161264. * 4096.,
    (double)14065./3137161264. * 4096.,
    (double)23282./3137161264. * 4096.,
    (double)26494./3137161264. * 4096.,
    (double)32850./3137161264. * 4096.,
    (double)25053./3137161264. * 4096.,
    (double)25107./3137161264. * 4096.,
    (double)22503./3137161264. * 4096.,
    (double)7269./3137161264. * 4096.,
    (double)25264./3137161264. * 4096.,
    (double)23538./3137161264. * 4096.,
    (double)24726./3137161264. * 4096.,
    (double)39917./3137161264. * 4096.,
    (double)20571./3137161264. * 4096.,
    (double)30903./3137161264. * 4096.,
    (double)266671./3137161264. * 4096.,
    (double)252625./3137161264. * 4096.,
    (double)197186./3137161264. * 4096.,
    (double)260397./3137161264. * 4096.,
    (double)24428./3137161264. * 4096.,
    (double)26286./3137161264. * 4096.,
    (double)23748./3137161264. * 4096.,
    (double)30247./3137161264. * 4096.,
    (double)253778./3137161264. * 4096.,
    (double)35618./3137161264. * 4096.,
    (double)153679./3137161264. * 4096.,
    (double)216879./3137161264. * 4096.,
    (double)185232./3137161264. * 4096.,
    (double)275153./3137161264. * 4096.,
    (double)223466./3137161264. * 4096.,
    (double)299744./3137161264. * 4096.,
    (double)256396./3137161264. * 4096.,
    (double)161137./3137161264. * 4096.,
    (double)145371./3137161264. * 4096.,
    (double)255600./3137161264. * 4096.,
    (double)296305./3137161264. * 4096.,
    (double)263674./3137161264. * 4096.,
    (double)228189./3137161264. * 4096.,
    (double)300421./3137161264. * 4096.,
    (double)262843./3137161264. * 4096.,
    (double)24227./3137161264. * 4096.,
    (double)176503./3137161264. * 4096.,
    (double)273024./3137161264. * 4096.,
    (double)251577./3137161264. * 4096.,
    (double)222678./3137161264. * 4096.,
    (double)258035./3137161264. * 4096.,
    (double)462974./3137161264. * 4096.,
    (double)467371./3137161264. * 4096.,
    (double)239818./3137161264. * 4096.,
    (double)182641./3137161264. * 4096.,
    (double)346066./3137161264. * 4096.,
    (double)237450./3137161264. * 4096.,
    (double)163443./3137161264. * 4096.,
    (double)142669./3137161264. * 4096.,
    (double)192186./3137161264. * 4096.,
    (double)260428./3137161264. * 4096.,
    (double)23413./3137161264. * 4096.,
    (double)127601./3137161264. * 4096.,
    (double)195864./3137161264. * 4096.,
    (double)345438./3137161264. * 4096.,
    (double)254376./3137161264. * 4096.,
    (double)193197./3137161264. * 4096.,
    (double)416127./3137161264. * 4096.,
    (double)371194./3137161264. * 4096.,
    (double)260766./3137161264. * 4096.,
    (double)186271./3137161264. * 4096.,
    (double)279608./3137161264. * 4096.,
    (double)263473./3137161264. * 4096.,
    (double)232660./3137161264. * 4096.,
    (double)195361./3137161264. * 4096.,
    (double)241656./3137161264. * 4096.,
    (double)244175./3137161264. * 4096.,
    (double)26515./3137161264. * 4096.,
    (double)174567./3137161264. * 4096.,
    (double)244862./3137161264. * 4096.,
    (double)277113./3137161264. * 4096.,
    (double)378662./3137161264. * 4096.,
    (double)206950./3137161264. * 4096.,
    (double)346686./3137161264. * 4096.,
    (double)244240./3137161264. * 4096.,
    (double)229304./3137161264. * 4096.,
    (double)184026./3137161264. * 4096.,
    (double)271658./3137161264. * 4096.,
    (double)18995./3137161264. * 4096.,
    (double)19064./3137161264. * 4096.,
    (double)16030./3137161264. * 4096.,
    (double)23153./3137161264. * 4096.,
    (double)208325./3137161264. * 4096.,
    (double)19305./3137161264. * 4096.,
    (double)155218./3137161264. * 4096.,
    (double)230979./3137161264. * 4096.,
    (double)199302./3137161264. * 4096.,
    (double)244912./3137161264. * 4096.,
    (double)256987./3137161264. * 4096.,
    (double)343123./3137161264. * 4096.,
    (double)334651./3137161264. * 4096.,
    (double)191425./3137161264. * 4096.,
    (double)175083./3137161264. * 4096.,
    (double)306782./3137161264. * 4096.,
    (double)263675./3137161264. * 4096.,
    (double)211916./3137161264. * 4096.,
    (double)172379./3137161264. * 4096.,
    (double)251871./3137161264. * 4096.,
    (double)282069./3137161264. * 4096.,
    (double)21813./3137161264. * 4096.,
    (double)191820./3137161264. * 4096.,
    (double)326506./3137161264. * 4096.,
    (double)389902./3137161264. * 4096.,
    (double)328001./3137161264. * 4096.,
    (double)350875./3137161264. * 4096.,
    (double)676323./3137161264. * 4096.,
    (double)591211./3137161264. * 4096.,
    (double)330930./3137161264. * 4096.,
    (double)241846./3137161264. * 4096.,
    (double)428023./3137161264. * 4096.,
    (double)276074./3137161264. * 4096.,
    (double)214886./3137161264. * 4096.,
    (double)133728./3137161264. * 4096.,
    (double)214747./3137161264. * 4096.,
    (double)278877./3137161264. * 4096.,
    (double)24035./3137161264. * 4096.,
    (double)131903./3137161264. * 4096.,
    (double)202668./3137161264. * 4096.,
    (double)307927./3137161264. * 4096.,
    (double)221170./3137161264. * 4096.,
    (double)141635./3137161264. * 4096.,
    (double)286209./3137161264. * 4096.,
    (double)398953./3137161264. * 4096.,
    (double)281550./3137161264. * 4096.,
    (double)152437./3137161264. * 4096.,
    (double)241900./3137161264. * 4096.,
    (double)263743./3137161264. * 4096.,
    (double)194640./3137161264. * 4096.,
    (double)143625./3137161264. * 4096.,
    (double)164264./3137161264. * 4096.,
    (double)247334./3137161264. * 4096.,
    (double)25517./3137161264. * 4096.,
    (double)195986./3137161264. * 4096.,
    (double)213520./3137161264. * 4096.,
    (double)211554./3137161264. * 4096.,
    (double)234946./3137161264. * 4096.,
    (double)151572./3137161264. * 4096.,
    (double)255033./3137161264. * 4096.,
    (double)282371./3137161264. * 4096.,
    (double)274677./3137161264. * 4096.,
    (double)167842./3137161264. * 4096.,
    (double)271223./3137161264. * 4096.,
    (double)31669./3137161264. * 4096.,
    (double)29174./3137161264. * 4096.,
    (double)19350./3137161264. * 4096.,
    (double)38155./3137161264. * 4096.,
    (double)203377./3137161264. * 4096.,
    (double)22984./3137161264. * 4096.,
    (double)122903./3137161264. * 4096.,
    (double)196264./3137161264. * 4096.,
    (double)164345./3137161264. * 4096.,
    (double)236580./3137161264. * 4096.,
    (double)166723./3137161264. * 4096.,
    (double)283523./3137161264. * 4096.,
    (double)288176./3137161264. * 4096.,
    (double)176904./3137161264. * 4096.,
    (double)127272./3137161264. * 4096.,
    (double)268130./3137161264. * 4096.,
    (double)234291./3137161264. * 4096.,
    (double)188983./3137161264. * 4096.,
    (double)130673./3137161264. * 4096.,
    (double)222381./3137161264. * 4096.,
    (double)241619./3137161264. * 4096.,
    (double)22325./3137161264. * 4096.,
    (double)146879./3137161264. * 4096.,
    (double)257256./3137161264. * 4096.,
    (double)272398./3137161264. * 4096.,
    (double)205932./3137161264. * 4096.,
    (double)230332./3137161264. * 4096.,
    (double)491953./3137161264. * 4096.,
    (double)30320./3137161264. * 4096.,
    (double)21999./3137161264. * 4096.,
    (double)17257./3137161264. * 4096.,
    (double)23285./3137161264. * 4096.,
    (double)24850./3137161264. * 4096.,
    (double)22571./3137161264. * 4096.,
    (double)12223./3137161264. * 4096.,
    (double)16860./3137161264. * 4096.,
    (double)16996./3137161264. * 4096.,
    (double)2611./3137161264. * 4096.,
    (double)12580./3137161264. * 4096.,
    (double)14635./3137161264. * 4096.,
    (double)17616./3137161264. * 4096.,
    (double)19225./3137161264. * 4096.,
    (double)11649./3137161264. * 4096.,
    (double)22420./3137161264. * 4096.,
    (double)23118./3137161264. * 4096.,
    (double)20068./3137161264. * 4096.,
    (double)9959./3137161264. * 4096.,
    (double)14084./3137161264. * 4096.,
    (double)30156./3137161264. * 4096.,
    (double)25950./3137161264. * 4096.,
    (double)13694./3137161264. * 4096.,
    (double)15365./3137161264. * 4096.,
    (double)18216./3137161264. * 4096.,
    (double)4071./3137161264. * 4096.,
    (double)24228./3137161264. * 4096.,
    (double)18420./3137161264. * 4096.,
    (double)14333./3137161264. * 4096.,
    (double)18894./3137161264. * 4096.,
    (double)12949./3137161264. * 4096.,
    (double)17680./3137161264. * 4096.,
    (double)16695./3137161264. * 4096.,
    (double)19285./3137161264. * 4096.,
    (double)11419./3137161264. * 4096.,
    (double)16048./3137161264. * 4096.,
    (double)2743./3137161264. * 4096.,
    (double)4001./3137161264. * 4096.,
    (double)3133./3137161264. * 4096.,
    (double)2775./3137161264. * 4096.,
    (double)18552./3137161264. * 4096.,
    (double)3894./3137161264. * 4096.,
    (double)15105./3137161264. * 4096.,
    (double)21075./3137161264. * 4096.,
    (double)13947./3137161264. * 4096.,
    (double)23703./3137161264. * 4096.,
    (double)20691./3137161264. * 4096.,
    (double)34662./3137161264. * 4096.,
    (double)22915./3137161264. * 4096.,
    (double)15623./3137161264. * 4096.,
    (double)9987./3137161264. * 4096.,
    (double)22830./3137161264. * 4096.,
    (double)25349./3137161264. * 4096.,
    (double)26028./3137161264. * 4096.,
    (double)14852./3137161264. * 4096.,
    (double)24095./3137161264. * 4096.,
    (double)19268./3137161264. * 4096.,
    (double)2664./3137161264. * 4096.,
    (double)13668./3137161264. * 4096.,
    (double)24970./3137161264. * 4096.,
    (double)20978./3137161264. * 4096.,
    (double)18955./3137161264. * 4096.,
    (double)18831./3137161264. * 4096.,
    (double)39734./3137161264. * 4096.,
    (double)330278./3137161264. * 4096.,
    (double)191008./3137161264. * 4096.,
    (double)128159./3137161264. * 4096.,
    (double)170473./3137161264. * 4096.,
    (double)229288./3137161264. * 4096.,
    (double)198825./3137161264. * 4096.,
    (double)170216./3137161264. * 4096.,
    (double)171728./3137161264. * 4096.,
    (double)195082./3137161264. * 4096.,
    (double)28520./3137161264. * 4096.,
    (double)134849./3137161264. * 4096.,
    (double)162447./3137161264. * 4096.,
    (double)165295./3137161264. * 4096.,
    (double)178479./3137161264. * 4096.,
    (double)155391./3137161264. * 4096.,
    (double)245623./3137161264. * 4096.,
    (double)19837./3137161264. * 4096.,
    (double)18551./3137161264. * 4096.,
    (double)9921./3137161264. * 4096.,
    (double)12809./3137161264. * 4096.,
    (double)17316./3137161264. * 4096.,
    (double)17798./3137161264. * 4096.,
    (double)13683./3137161264. * 4096.,
    (double)11593./3137161264. * 4096.,
    (double)16120./3137161264. * 4096.,
    (double)3754./3137161264. * 4096.,
    (double)24954./3137161264. * 4096.,
    (double)15887./3137161264. * 4096.,
    (double)17206./3137161264. * 4096.,
    (double)24361./3137161264. * 4096.,
    (double)22113./3137161264. * 4096.,
    (double)21905./3137161264. * 4096.,
    (double)208305./3137161264. * 4096.,
    (double)220825./3137161264. * 4096.,
    (double)147623./3137161264. * 4096.,
    (double)180476./3137161264. * 4096.,
    (double)18919./3137161264. * 4096.,
    (double)20666./3137161264. * 4096.,
    (double)17463./3137161264. * 4096.,
    (double)19614./3137161264. * 4096.,
    (double)205609./3137161264. * 4096.,
    (double)24034./3137161264. * 4096.,
    (double)101692./3137161264. * 4096.,
    (double)149046./3137161264. * 4096.,
    (double)125158./3137161264. * 4096.,
    (double)183091./3137161264. * 4096.,
    (double)152986./3137161264. * 4096.,
    (double)194999./3137161264. * 4096.,
    (double)190129./3137161264. * 4096.,
    (double)128884./3137161264. * 4096.,
    (double)102880./3137161264. * 4096.,
    (double)150404./3137161264. * 4096.,
    (double)193672./3137161264. * 4096.,
    (double)177949./3137161264. * 4096.,
    (double)139961./3137161264. * 4096.,
    (double)172979./3137161264. * 4096.,
    (double)216696./3137161264. * 4096.,
    (double)20922./3137161264. * 4096.,
    (double)178596./3137161264. * 4096.,
    (double)215094./3137161264. * 4096.,
    (double)176218./3137161264. * 4096.,
    (double)167090./3137161264. * 4096.,
    (double)198959./3137161264. * 4096.,
    (double)297066./3137161264. * 4096.,
    (double)313876./3137161264. * 4096.,
    (double)162699./3137161264. * 4096.,
    (double)111923./3137161264. * 4096.,
    (double)207893./3137161264. * 4096.,
    (double)171426./3137161264. * 4096.,
    (double)117702./3137161264. * 4096.,
    (double)92828./3137161264. * 4096.,
    (double)125928./3137161264. * 4096.,
    (double)177783./3137161264. * 4096.,
    (double)16608./3137161264. * 4096.,
    (double)110246./3137161264. * 4096.,
    (double)157077./3137161264. * 4096.,
    (double)198667./3137161264. * 4096.,
    (double)152025./3137161264. * 4096.,
    (double)115942./3137161264. * 4096.,
    (double)244782./3137161264. * 4096.,
    (double)278373./3137161264. * 4096.,
    (double)191695./3137161264. * 4096.,
    (double)117106./3137161264. * 4096.,
    (double)180032./3137161264. * 4096.,
    (double)188906./3137161264. * 4096.,
    (double)156423./3137161264. * 4096.,
    (double)113736./3137161264. * 4096.,
    (double)124431./3137161264. * 4096.,
    (double)181212./3137161264. * 4096.,
    (double)16059./3137161264. * 4096.,
    (double)153963./3137161264. * 4096.,
    (double)182224./3137161264. * 4096.,
    (double)191632./3137161264. * 4096.,
    (double)204807./3137161264. * 4096.,
    (double)155070./3137161264. * 4096.,
    (double)228883./3137161264. * 4096.,
    (double)246821./3137161264. * 4096.,
    (double)208312./3137161264. * 4096.,
    (double)139530./3137161264. * 4096.,
    (double)219623./3137161264. * 4096.,
    (double)18064./3137161264. * 4096.,
    (double)16595./3137161264. * 4096.,
    (double)11695./3137161264. * 4096.,
    (double)17775./3137161264. * 4096.,
    (double)200416./3137161264. * 4096.,
    (double)16853./3137161264. * 4096.,
    (double)140634./3137161264. * 4096.,
    (double)193815./3137161264. * 4096.,
    (double)199377./3137161264. * 4096.,
    (double)218035./3137161264. * 4096.,
    (double)193950./3137161264. * 4096.,
    (double)261169./3137161264. * 4096.,
    (double)249713./3137161264. * 4096.,
    (double)139770./3137161264. * 4096.,
    (double)122667./3137161264. * 4096.,
    (double)203186./3137161264. * 4096.,
    (double)170087./3137161264. * 4096.,
    (double)139863./3137161264. * 4096.,
    (double)109431./3137161264. * 4096.,
    (double)154511./3137161264. * 4096.,
    (double)237768./3137161264. * 4096.,
    (double)17745./3137161264. * 4096.,
    (double)189645./3137161264. * 4096.,
    (double)252637./3137161264. * 4096.,
    (double)268986./3137161264. * 4096.,
    (double)226733./3137161264. * 4096.,
    (double)246284./3137161264. * 4096.,
    (double)402233./3137161264. * 4096.,
    (double)771786./3137161264. * 4096.,
    (double)268156./3137161264. * 4096.,
    (double)194182./3137161264. * 4096.,
    (double)443233./3137161264. * 4096.,
    (double)222407./3137161264. * 4096.,
    (double)125370./3137161264. * 4096.,
    (double)99010./3137161264. * 4096.,
    (double)178746./3137161264. * 4096.,
    (double)213610./3137161264. * 4096.,
    (double)17049./3137161264. * 4096.,
    (double)89449./3137161264. * 4096.,
    (double)171942./3137161264. * 4096.,
    (double)303713./3137161264. * 4096.,
    (double)194253./3137161264. * 4096.,
    (double)128414./3137161264. * 4096.,
    (double)330650./3137161264. * 4096.,
    (double)257377./3137161264. * 4096.,
    (double)127067./3137161264. * 4096.,
    (double)77604./3137161264. * 4096.,
    (double)138618./3137161264. * 4096.,
    (double)133544./3137161264. * 4096.,
    (double)80692./3137161264. * 4096.,
    (double)61816./3137161264. * 4096.,
    (double)93697./3137161264. * 4096.,
    (double)129583./3137161264. * 4096.,
    (double)8848./3137161264. * 4096.,
    (double)67936./3137161264. * 4096.,
    (double)112938./3137161264. * 4096.,
    (double)124453./3137161264. * 4096.,
    (double)98655./3137161264. * 4096.,
    (double)71047./3137161264. * 4096.,
    (double)149458./3137161264. * 4096.,
    (double)204125./3137161264. * 4096.,
    (double)143534./3137161264. * 4096.,
    (double)91820./3137161264. * 4096.,
    (double)200779./3137161264. * 4096.,
    (double)14150./3137161264. * 4096.,
    (double)11321./3137161264. * 4096.,
    (double)7539./3137161264. * 4096.,
    (double)20897./3137161264. * 4096.,
    (double)119894./3137161264. * 4096.,
    (double)9364./3137161264. * 4096.,
    (double)60665./3137161264. * 4096.,
    (double)119405./3137161264. * 4096.,
    (double)127389./3137161264. * 4096.,
    (double)123317./3137161264. * 4096.,
    (double)89727./3137161264. * 4096.,
    (double)187770./3137161264. * 4096.,
    (double)290573./3137161264. * 4096.,
    (double)135035./3137161264. * 4096.,
    (double)116303./3137161264. * 4096.,
    (double)267593./3137161264. * 4096.,
    (double)162824./3137161264. * 4096.,
    (double)98692./3137161264. * 4096.,
    (double)85789./3137161264. * 4096.,
    (double)168344./3137161264. * 4096.,
    (double)159014./3137161264. * 4096.,
    (double)10698./3137161264. * 4096.,
    (double)87368./3137161264. * 4096.,
    (double)179628./3137161264. * 4096.,
    (double)251478./3137161264. * 4096.,
    (double)157772./3137161264. * 4096.,
    (double)168647./3137161264. * 4096.,
    (double)454379./3137161264. * 4096.,
    (double)282084./3137161264. * 4096.,
    (double)137146./3137161264. * 4096.,
    (double)91523./3137161264. * 4096.,
    (double)173293./3137161264. * 4096.,
    (double)141594./3137161264. * 4096.,
    (double)93323./3137161264. * 4096.,
    (double)63896./3137161264. * 4096.,
    (double)96109./3137161264. * 4096.,
    (double)107324./3137161264. * 4096.,
    (double)8437./3137161264. * 4096.,
    (double)53212./3137161264. * 4096.,
    (double)92020./3137161264. * 4096.,
    (double)119314./3137161264. * 4096.,
    (double)96117./3137161264. * 4096.,
    (double)60766./3137161264. * 4096.,
    (double)142621./3137161264. * 4096.,
    (double)164711./3137161264. * 4096.,
    (double)100967./3137161264. * 4096.,
    (double)54298./3137161264. * 4096.,
    (double)94330./3137161264. * 4096.,
    (double)112156./3137161264. * 4096.,
    (double)83281./3137161264. * 4096.,
    (double)47202./3137161264. * 4096.,
    (double)72260./3137161264. * 4096.,
    (double)91875./3137161264. * 4096.,
    (double)6643./3137161264. * 4096.,
    (double)54303./3137161264. * 4096.,
    (double)86003./3137161264. * 4096.,
    (double)81639./3137161264. * 4096.,
    (double)75571./3137161264. * 4096.,
    (double)48715./3137161264. * 4096.,
    (double)101493./3137161264. * 4096.,
    (double)119591./3137161264. * 4096.,
    (double)88414./3137161264. * 4096.,
    (double)53124./3137161264. * 4096.,
    (double)106217./3137161264. * 4096.,
    (double)7260./3137161264. * 4096.,
    (double)6385./3137161264. * 4096.,
    (double)3685./3137161264. * 4096.,
    (double)8030./3137161264. * 4096.,
    (double)97793./3137161264. * 4096.,
    (double)7279./3137161264. * 4096.,
    (double)51161./3137161264. * 4096.,
    (double)95082./3137161264. * 4096.,
    (double)89850./3137161264. * 4096.,
    (double)97558./3137161264. * 4096.,
    (double)65442./3137161264. * 4096.,
    (double)131767./3137161264. * 4096.,
    (double)135130./3137161264. * 4096.,
    (double)72808./3137161264. * 4096.,
    (double)58862./3137161264. * 4096.,
    (double)122695./3137161264. * 4096.,
    (double)108358./3137161264. * 4096.,
    (double)74452./3137161264. * 4096.,
    (double)52880./3137161264. * 4096.,
    (double)101206./3137161264. * 4096.,
    (double)96737./3137161264. * 4096.,
    (double)6198./3137161264. * 4096.,
    (double)51771./3137161264. * 4096.,
    (double)104807./3137161264. * 4096.,
    (double)117539./3137161264. * 4096.,
    (double)92082./3137161264. * 4096.,
    (double)86229./3137161264. * 4096.,
    (double)207580./3137161264. * 4096.,
    (double)219846./3137161264. * 4096.,
    (double)101240./3137161264. * 4096.,
    (double)84454./3137161264. * 4096.,
    (double)128493./3137161264. * 4096.,
    (double)135287./3137161264. * 4096.,
    (double)84144./3137161264. * 4096.,
    (double)73492./3137161264. * 4096.,
    (double)115135./3137161264. * 4096.,
    (double)121405./3137161264. * 4096.,
    (double)11055./3137161264. * 4096.,
    (double)53787./3137161264. * 4096.,
    (double)94471./3137161264. * 4096.,
    (double)120779./3137161264. * 4096.,
    (double)94804./3137161264. * 4096.,
    (double)77323./3137161264. * 4096.,
    (double)169421./3137161264. * 4096.,
    (double)10323./3137161264. * 4096.,
    (double)7477./3137161264. * 4096.,
    (double)4228./3137161264. * 4096.,
    (double)7526./3137161264. * 4096.,
    (double)7166./3137161264. * 4096.,
    (double)6344./3137161264. * 4096.,
    (double)4428./3137161264. * 4096.,
    (double)6972./3137161264. * 4096.,
    (double)5995./3137161264. * 4096.,
    (double)656./3137161264. * 4096.,
    (double)3858./3137161264. * 4096.,
    (double)6211./3137161264. * 4096.,
    (double)8808./3137161264. * 4096.,
    (double)8665./3137161264. * 4096.,
    (double)5987./3137161264. * 4096.,
    (double)12078./3137161264. * 4096.,
    (double)115133./3137161264. * 4096.,
    (double)95247./3137161264. * 4096.,
    (double)63834./3137161264. * 4096.,
    (double)109819./3137161264. * 4096.,
    (double)6598./3137161264. * 4096.,
    (double)5754./3137161264. * 4096.,
    (double)4301./3137161264. * 4096.,
    (double)9369./3137161264. * 4096.,
    (double)98051./3137161264. * 4096.,
    (double)7750./3137161264. * 4096.,
    (double)56320./3137161264. * 4096.,
    (double)82589./3137161264. * 4096.,
    (double)83884./3137161264. * 4096.,
    (double)87860./3137161264. * 4096.,
    (double)77526./3137161264. * 4096.,
    (double)126041./3137161264. * 4096.,
    (double)124227./3137161264. * 4096.,
    (double)77004./3137161264. * 4096.,
    (double)64021./3137161264. * 4096.,
    (double)104393./3137161264. * 4096.,
    (double)104306./3137161264. * 4096.,
    (double)74928./3137161264. * 4096.,
    (double)61567./3137161264. * 4096.,
    (double)104568./3137161264. * 4096.,
    (double)106779./3137161264. * 4096.,
    (double)6777./3137161264. * 4096.,
    (double)67063./3137161264. * 4096.,
    (double)111203./3137161264. * 4096.,
    (double)107603./3137161264. * 4096.,
    (double)78915./3137161264. * 4096.,
    (double)95504./3137161264. * 4096.,
    (double)173881./3137161264. * 4096.,
    (double)300528./3137161264. * 4096.,
    (double)93764./3137161264. * 4096.,
    (double)70033./3137161264. * 4096.,
    (double)147795./3137161264. * 4096.,
    (double)86260./3137161264. * 4096.,
    (double)50054./3137161264. * 4096.,
    (double)41026./3137161264. * 4096.,
    (double)65025./3137161264. * 4096.,
    (double)91703./3137161264. * 4096.,
    (double)6337./3137161264. * 4096.,
    (double)41209./3137161264. * 4096.,
    (double)76156./3137161264. * 4096.,
    (double)127251./3137161264. * 4096.,
    (double)75449./3137161264. * 4096.,
    (double)59434./3137161264. * 4096.,
    (double)159941./3137161264. * 4096.,
    (double)108470./3137161264. * 4096.,
    (double)57045./3137161264. * 4096.,
    (double)34907./3137161264. * 4096.,
    (double)59959./3137161264. * 4096.,
    (double)59763./3137161264. * 4096.,
    (double)43477./3137161264. * 4096.,
    (double)30316./3137161264. * 4096.,
    (double)44107./3137161264. * 4096.,
    (double)53035./3137161264. * 4096.,
    (double)3059./3137161264. * 4096.,
    (double)30606./3137161264. * 4096.,
    (double)51123./3137161264. * 4096.,
    (double)60208./3137161264. * 4096.,
    (double)47512./3137161264. * 4096.,
    (double)35074./3137161264. * 4096.,
    (double)78653./3137161264. * 4096.,
    (double)81839./3137161264. * 4096.,
    (double)56406./3137161264. * 4096.,
    (double)37339./3137161264. * 4096.,
    (double)71495./3137161264. * 4096.,
    (double)3493./3137161264. * 4096.,
    (double)2854./3137161264. * 4096.,
    (double)1692./3137161264. * 4096.,
    (double)4261./3137161264. * 4096.,
    (double)56288./3137161264. * 4096.,
    (double)3103./3137161264. * 4096.,
    (double)32238./3137161264. * 4096.,
    (double)54412./3137161264. * 4096.,
    (double)57757./3137161264. * 4096.,
    (double)47416./3137161264. * 4096.,
    (double)41876./3137161264. * 4096.,
    (double)74959./3137161264. * 4096.,
    (double)105162./3137161264. * 4096.,
    (double)32466./3137161264. * 4096.,
    (double)29673./3137161264. * 4096.,
    (double)60782./3137161264. * 4096.,
    (double)33291./3137161264. * 4096.,
    (double)20174./3137161264. * 4096.,
    (double)16646./3137161264. * 4096.,
    (double)30240./3137161264. * 4096.,
    (double)32331./3137161264. * 4096.,
    (double)1423./3137161264. * 4096.,
    (double)18901./3137161264. * 4096.,
    (double)30260./3137161264. * 4096.,
    (double)30262./3137161264. * 4096.,
    (double)11686./3137161264. * 4096.,
    (double)12224./3137161264. * 4096.,
    (double)10415./3137161264. * 4096.
};

double GenomeIndex::biasTable23[] = {   // hg19
    (double)7101184./3137161264. * 16384.,
    (double)1881723./3137161264. * 16384.,
    (double)1169960./3137161264. * 16384.,
    (double)2567237./3137161264. * 16384.,
    (double)1921326./3137161264. * 16384.,
    (double)893671./3137161264. * 16384.,
    (double)734875./3137161264. * 16384.,
    (double)1121460./3137161264. * 16384.,
    (double)1664566./3137161264. * 16384.,
    (double)141958./3137161264. * 16384.,
    (double)641599./3137161264. * 16384.,
    (double)995519./3137161264. * 16384.,
    (double)2554449./3137161264. * 16384.,
    (double)1549810./3137161264. * 16384.,
    (double)1068202./3137161264. * 16384.,
    (double)1924397./3137161264. * 16384.,
    (double)2140197./3137161264. * 16384.,
    (double)955021./3137161264. * 16384.,
    (double)671774./3137161264. * 16384.,
    (double)953559./3137161264. * 16384.,
    (double)1019575./3137161264. * 16384.,
    (double)543023./3137161264. * 16384.,
    (double)496790./3137161264. * 16384.,
    (double)537790./3137161264. * 16384.,
    (double)1003199./3137161264. * 16384.,
    (double)69900./3137161264. * 16384.,
    (double)490044./3137161264. * 16384.,
    (double)640182./3137161264. * 16384.,
    (double)924198./3137161264. * 16384.,
    (double)686614./3137161264. * 16384.,
    (double)539843./3137161264. * 16384.,
    (double)905884./3137161264. * 16384.,
    (double)1770319./3137161264. * 16384.,
    (double)994500./3137161264. * 16384.,
    (double)744076./3137161264. * 16384.,
    (double)1136848./3137161264. * 16384.,
    (double)125500./3137161264. * 16384.,
    (double)89554./3137161264. * 16384.,
    (double)66928./3137161264. * 16384.,
    (double)143839./3137161264. * 16384.,
    (double)814841./3137161264. * 16384.,
    (double)71022./3137161264. * 16384.,
    (double)459910./3137161264. * 16384.,
    (double)620300./3137161264. * 16384.,
    (double)819525./3137161264. * 16384.,
    (double)811666./3137161264. * 16384.,
    (double)556892./3137161264. * 16384.,
    (double)872605./3137161264. * 16384.,
    (double)2621526./3137161264. * 16384.,
    (double)1022584./3137161264. * 16384.,
    (double)1006991./3137161264. * 16384.,
    (double)2054469./3137161264. * 16384.,
    (double)1421996./3137161264. * 16384.,
    (double)918332./3137161264. * 16384.,
    (double)783387./3137161264. * 16384.,
    (double)1431975./3137161264. * 16384.,
    (double)1160543./3137161264. * 16384.,
    (double)88463./3137161264. * 16384.,
    (double)598262./3137161264. * 16384.,
    (double)966168./3137161264. * 16384.,
    (double)1734842./3137161264. * 16384.,
    (double)898078./3137161264. * 16384.,
    (double)900705./3137161264. * 16384.,
    (double)1643316./3137161264. * 16384.,
    (double)2526450./3137161264. * 16384.,
    (double)1022373./3137161264. * 16384.,
    (double)635237./3137161264. * 16384.,
    (double)1056230./3137161264. * 16384.,
    (double)1099197./3137161264. * 16384.,
    (double)637266./3137161264. * 16384.,
    (double)450143./3137161264. * 16384.,
    (double)540325./3137161264. * 16384.,
    (double)905545./3137161264. * 16384.,
    (double)84986./3137161264. * 16384.,
    (double)350435./3137161264. * 16384.,
    (double)561271./3137161264. * 16384.,
    (double)818175./3137161264. * 16384.,
    (double)708237./3137161264. * 16384.,
    (double)385573./3137161264. * 16384.,
    (double)726440./3137161264. * 16384.,
    (double)1242622./3137161264. * 16384.,
    (double)669926./3137161264. * 16384.,
    (double)385774./3137161264. * 16384.,
    (double)539889./3137161264. * 16384.,
    (double)658238./3137161264. * 16384.,
    (double)400598./3137161264. * 16384.,
    (double)318129./3137161264. * 16384.,
    (double)333008./3137161264. * 16384.,
    (double)671592./3137161264. * 16384.,
    (double)57055./3137161264. * 16384.,
    (double)331696./3137161264. * 16384.,
    (double)440778./3137161264. * 16384.,
    (double)460605./3137161264. * 16384.,
    (double)412666./3137161264. * 16384.,
    (double)277545./3137161264. * 16384.,
    (double)422749./3137161264. * 16384.,
    (double)941348./3137161264. * 16384.,
    (double)723670./3137161264. * 16384.,
    (double)439489./3137161264. * 16384.,
    (double)633140./3137161264. * 16384.,
    (double)66948./3137161264. * 16384.,
    (double)54911./3137161264. * 16384.,
    (double)40951./3137161264. * 16384.,
    (double)60805./3137161264. * 16384.,
    (double)633672./3137161264. * 16384.,
    (double)57633./3137161264. * 16384.,
    (double)336394./3137161264. * 16384.,
    (double)473415./3137161264. * 16384.,
    (double)455874./3137161264. * 16384.,
    (double)548802./3137161264. * 16384.,
    (double)350311./3137161264. * 16384.,
    (double)531509./3137161264. * 16384.,
    (double)852239./3137161264. * 16384.,
    (double)495177./3137161264. * 16384.,
    (double)366733./3137161264. * 16384.,
    (double)664356./3137161264. * 16384.,
    (double)681803./3137161264. * 16384.,
    (double)477030./3137161264. * 16384.,
    (double)381040./3137161264. * 16384.,
    (double)531253./3137161264. * 16384.,
    (double)658778./3137161264. * 16384.,
    (double)46497./3137161264. * 16384.,
    (double)333028./3137161264. * 16384.,
    (double)523053./3137161264. * 16384.,
    (double)663917./3137161264. * 16384.,
    (double)489941./3137161264. * 16384.,
    (double)430074./3137161264. * 16384.,
    (double)851899./3137161264. * 16384.,
    (double)1918754./3137161264. * 16384.,
    (double)661721./3137161264. * 16384.,
    (double)575361./3137161264. * 16384.,
    (double)855927./3137161264. * 16384.,
    (double)946760./3137161264. * 16384.,
    (double)515650./3137161264. * 16384.,
    (double)472847./3137161264. * 16384.,
    (double)575516./3137161264. * 16384.,
    (double)916895./3137161264. * 16384.,
    (double)94816./3137161264. * 16384.,
    (double)364998./3137161264. * 16384.,
    (double)620648./3137161264. * 16384.,
    (double)823977./3137161264. * 16384.,
    (double)638842./3137161264. * 16384.,
    (double)488407./3137161264. * 16384.,
    (double)1026270./3137161264. * 16384.,
    (double)116522./3137161264. * 16384.,
    (double)70061./3137161264. * 16384.,
    (double)46566./3137161264. * 16384.,
    (double)75340./3137161264. * 16384.,
    (double)81072./3137161264. * 16384.,
    (double)62731./3137161264. * 16384.,
    (double)45381./3137161264. * 16384.,
    (double)55138./3137161264. * 16384.,
    (double)73208./3137161264. * 16384.,
    (double)10095./3137161264. * 16384.,
    (double)45735./3137161264. * 16384.,
    (double)67940./3137161264. * 16384.,
    (double)95795./3137161264. * 16384.,
    (double)105720./3137161264. * 16384.,
    (double)62734./3137161264. * 16384.,
    (double)115002./3137161264. * 16384.,
    (double)678977./3137161264. * 16384.,
    (double)485802./3137161264. * 16384.,
    (double)433350./3137161264. * 16384.,
    (double)543819./3137161264. * 16384.,
    (double)59900./3137161264. * 16384.,
    (double)39950./3137161264. * 16384.,
    (double)38376./3137161264. * 16384.,
    (double)60291./3137161264. * 16384.,
    (double)514810./3137161264. * 16384.,
    (double)48257./3137161264. * 16384.,
    (double)284693./3137161264. * 16384.,
    (double)391465./3137161264. * 16384.,
    (double)397819./3137161264. * 16384.,
    (double)438649./3137161264. * 16384.,
    (double)359010./3137161264. * 16384.,
    (double)462314./3137161264. * 16384.,
    (double)668875./3137161264. * 16384.,
    (double)384909./3137161264. * 16384.,
    (double)370465./3137161264. * 16384.,
    (double)617265./3137161264. * 16384.,
    (double)731996./3137161264. * 16384.,
    (double)477914./3137161264. * 16384.,
    (double)414358./3137161264. * 16384.,
    (double)590008./3137161264. * 16384.,
    (double)599734./3137161264. * 16384.,
    (double)51666./3137161264. * 16384.,
    (double)399110./3137161264. * 16384.,
    (double)575997./3137161264. * 16384.,
    (double)556422./3137161264. * 16384.,
    (double)471592./3137161264. * 16384.,
    (double)496340./3137161264. * 16384.,
    (double)845075./3137161264. * 16384.,
    (double)2757028./3137161264. * 16384.,
    (double)917053./3137161264. * 16384.,
    (double)741628./3137161264. * 16384.,
    (double)1608971./3137161264. * 16384.,
    (double)905598./3137161264. * 16384.,
    (double)473178./3137161264. * 16384.,
    (double)462601./3137161264. * 16384.,
    (double)624887./3137161264. * 16384.,
    (double)1131812./3137161264. * 16384.,
    (double)107266./3137161264. * 16384.,
    (double)446678./3137161264. * 16384.,
    (double)782459./3137161264. * 16384.,
    (double)1520617./3137161264. * 16384.,
    (double)934873./3137161264. * 16384.,
    (double)729418./3137161264. * 16384.,
    (double)1844259./3137161264. * 16384.,
    (double)1418970./3137161264. * 16384.,
    (double)811130./3137161264. * 16384.,
    (double)567732./3137161264. * 16384.,
    (double)842872./3137161264. * 16384.,
    (double)843582./3137161264. * 16384.,
    (double)546653./3137161264. * 16384.,
    (double)460798./3137161264. * 16384.,
    (double)554180./3137161264. * 16384.,
    (double)848023./3137161264. * 16384.,
    (double)57996./3137161264. * 16384.,
    (double)480098./3137161264. * 16384.,
    (double)748948./3137161264. * 16384.,
    (double)990356./3137161264. * 16384.,
    (double)817638./3137161264. * 16384.,
    (double)633950./3137161264. * 16384.,
    (double)1142620./3137161264. * 16384.,
    (double)886800./3137161264. * 16384.,
    (double)662391./3137161264. * 16384.,
    (double)516267./3137161264. * 16384.,
    (double)747083./3137161264. * 16384.,
    (double)68574./3137161264. * 16384.,
    (double)48177./3137161264. * 16384.,
    (double)42686./3137161264. * 16384.,
    (double)67897./3137161264. * 16384.,
    (double)623418./3137161264. * 16384.,
    (double)44418./3137161264. * 16384.,
    (double)362707./3137161264. * 16384.,
    (double)559483./3137161264. * 16384.,
    (double)606369./3137161264. * 16384.,
    (double)623892./3137161264. * 16384.,
    (double)524121./3137161264. * 16384.,
    (double)742544./3137161264. * 16384.,
    (double)1401947./3137161264. * 16384.,
    (double)727187./3137161264. * 16384.,
    (double)611883./3137161264. * 16384.,
    (double)1289470./3137161264. * 16384.,
    (double)706936./3137161264. * 16384.,
    (double)467817./3137161264. * 16384.,
    (double)430038./3137161264. * 16384.,
    (double)714663./3137161264. * 16384.,
    (double)913788./3137161264. * 16384.,
    (double)57269./3137161264. * 16384.,
    (double)536938./3137161264. * 16384.,
    (double)900408./3137161264. * 16384.,
    (double)1214541./3137161264. * 16384.,
    (double)803947./3137161264. * 16384.,
    (double)808055./3137161264. * 16384.,
    (double)1575244./3137161264. * 16384.,
    (double)2352269./3137161264. * 16384.,
    (double)1151564./3137161264. * 16384.,
    (double)752316./3137161264. * 16384.,
    (double)1289676./3137161264. * 16384.,
    (double)941238./3137161264. * 16384.,
    (double)603401./3137161264. * 16384.,
    (double)462240./3137161264. * 16384.,
    (double)558140./3137161264. * 16384.,
    (double)720036./3137161264. * 16384.,
    (double)72301./3137161264. * 16384.,
    (double)304531./3137161264. * 16384.,
    (double)528122./3137161264. * 16384.,
    (double)798177./3137161264. * 16384.,
    (double)696444./3137161264. * 16384.,
    (double)412849./3137161264. * 16384.,
    (double)767627./3137161264. * 16384.,
    (double)1080962./3137161264. * 16384.,
    (double)706339./3137161264. * 16384.,
    (double)417657./3137161264. * 16384.,
    (double)578716./3137161264. * 16384.,
    (double)646898./3137161264. * 16384.,
    (double)417751./3137161264. * 16384.,
    (double)361406./3137161264. * 16384.,
    (double)385782./3137161264. * 16384.,
    (double)502096./3137161264. * 16384.,
    (double)52397./3137161264. * 16384.,
    (double)296599./3137161264. * 16384.,
    (double)432240./3137161264. * 16384.,
    (double)388031./3137161264. * 16384.,
    (double)389382./3137161264. * 16384.,
    (double)276940./3137161264. * 16384.,
    (double)484515./3137161264. * 16384.,
    (double)690118./3137161264. * 16384.,
    (double)623276./3137161264. * 16384.,
    (double)395598./3137161264. * 16384.,
    (double)566969./3137161264. * 16384.,
    (double)64003./3137161264. * 16384.,
    (double)65080./3137161264. * 16384.,
    (double)42537./3137161264. * 16384.,
    (double)68193./3137161264. * 16384.,
    (double)392992./3137161264. * 16384.,
    (double)40101./3137161264. * 16384.,
    (double)265035./3137161264. * 16384.,
    (double)335832./3137161264. * 16384.,
    (double)324927./3137161264. * 16384.,
    (double)421351./3137161264. * 16384.,
    (double)299257./3137161264. * 16384.,
    (double)476290./3137161264. * 16384.,
    (double)729811./3137161264. * 16384.,
    (double)357688./3137161264. * 16384.,
    (double)342232./3137161264. * 16384.,
    (double)577407./3137161264. * 16384.,
    (double)615308./3137161264. * 16384.,
    (double)471843./3137161264. * 16384.,
    (double)331864./3137161264. * 16384.,
    (double)482999./3137161264. * 16384.,
    (double)436908./3137161264. * 16384.,
    (double)43771./3137161264. * 16384.,
    (double)229208./3137161264. * 16384.,
    (double)376071./3137161264. * 16384.,
    (double)490725./3137161264. * 16384.,
    (double)339678./3137161264. * 16384.,
    (double)351476./3137161264. * 16384.,
    (double)734763./3137161264. * 16384.,
    (double)1293813./3137161264. * 16384.,
    (double)837772./3137161264. * 16384.,
    (double)393935./3137161264. * 16384.,
    (double)631091./3137161264. * 16384.,
    (double)717695./3137161264. * 16384.,
    (double)546256./3137161264. * 16384.,
    (double)332116./3137161264. * 16384.,
    (double)351664./3137161264. * 16384.,
    (double)508522./3137161264. * 16384.,
    (double)56067./3137161264. * 16384.,
    (double)212115./3137161264. * 16384.,
    (double)342477./3137161264. * 16384.,
    (double)409482./3137161264. * 16384.,
    (double)438242./3137161264. * 16384.,
    (double)230373./3137161264. * 16384.,
    (double)423991./3137161264. * 16384.,
    (double)700655./3137161264. * 16384.,
    (double)507526./3137161264. * 16384.,
    (double)261745./3137161264. * 16384.,
    (double)342373./3137161264. * 16384.,
    (double)441612./3137161264. * 16384.,
    (double)255117./3137161264. * 16384.,
    (double)256704./3137161264. * 16384.,
    (double)247964./3137161264. * 16384.,
    (double)394020./3137161264. * 16384.,
    (double)45305./3137161264. * 16384.,
    (double)222652./3137161264. * 16384.,
    (double)321911./3137161264. * 16384.,
    (double)245170./3137161264. * 16384.,
    (double)287881./3137161264. * 16384.,
    (double)190547./3137161264. * 16384.,
    (double)270189./3137161264. * 16384.,
    (double)536312./3137161264. * 16384.,
    (double)604374./3137161264. * 16384.,
    (double)288445./3137161264. * 16384.,
    (double)395862./3137161264. * 16384.,
    (double)49225./3137161264. * 16384.,
    (double)70685./3137161264. * 16384.,
    (double)35096./3137161264. * 16384.,
    (double)41392./3137161264. * 16384.,
    (double)402683./3137161264. * 16384.,
    (double)57454./3137161264. * 16384.,
    (double)245223./3137161264. * 16384.,
    (double)328424./3137161264. * 16384.,
    (double)258380./3137161264. * 16384.,
    (double)460816./3137161264. * 16384.,
    (double)253930./3137161264. * 16384.,
    (double)381240./3137161264. * 16384.,
    (double)430735./3137161264. * 16384.,
    (double)296594./3137161264. * 16384.,
    (double)189149./3137161264. * 16384.,
    (double)317990./3137161264. * 16384.,
    (double)418725./3137161264. * 16384.,
    (double)385954./3137161264. * 16384.,
    (double)216559./3137161264. * 16384.,
    (double)284465./3137161264. * 16384.,
    (double)401329./3137161264. * 16384.,
    (double)34062./3137161264. * 16384.,
    (double)178340./3137161264. * 16384.,
    (double)299154./3137161264. * 16384.,
    (double)306554./3137161264. * 16384.,
    (double)272340./3137161264. * 16384.,
    (double)210194./3137161264. * 16384.,
    (double)445804./3137161264. * 16384.,
    (double)858146./3137161264. * 16384.,
    (double)492404./3137161264. * 16384.,
    (double)323551./3137161264. * 16384.,
    (double)532520./3137161264. * 16384.,
    (double)635511./3137161264. * 16384.,
    (double)461720./3137161264. * 16384.,
    (double)392422./3137161264. * 16384.,
    (double)409222./3137161264. * 16384.,
    (double)486147./3137161264. * 16384.,
    (double)58931./3137161264. * 16384.,
    (double)237371./3137161264. * 16384.,
    (double)397690./3137161264. * 16384.,
    (double)391844./3137161264. * 16384.,
    (double)382078./3137161264. * 16384.,
    (double)296685./3137161264. * 16384.,
    (double)553182./3137161264. * 16384.,
    (double)51818./3137161264. * 16384.,
    (double)53668./3137161264. * 16384.,
    (double)29023./3137161264. * 16384.,
    (double)62412./3137161264. * 16384.,
    (double)44052./3137161264. * 16384.,
    (double)56066./3137161264. * 16384.,
    (double)38543./3137161264. * 16384.,
    (double)34328./3137161264. * 16384.,
    (double)39400./3137161264. * 16384.,
    (double)10484./3137161264. * 16384.,
    (double)34154./3137161264. * 16384.,
    (double)46732./3137161264. * 16384.,
    (double)35568./3137161264. * 16384.,
    (double)55994./3137161264. * 16384.,
    (double)33114./3137161264. * 16384.,
    (double)51027./3137161264. * 16384.,
    (double)475557./3137161264. * 16384.,
    (double)499935./3137161264. * 16384.,
    (double)380248./3137161264. * 16384.,
    (double)413709./3137161264. * 16384.,
    (double)50588./3137161264. * 16384.,
    (double)50926./3137161264. * 16384.,
    (double)39407./3137161264. * 16384.,
    (double)44570./3137161264. * 16384.,
    (double)380245./3137161264. * 16384.,
    (double)47684./3137161264. * 16384.,
    (double)255427./3137161264. * 16384.,
    (double)335146./3137161264. * 16384.,
    (double)248514./3137161264. * 16384.,
    (double)384271./3137161264. * 16384.,
    (double)315412./3137161264. * 16384.,
    (double)380368./3137161264. * 16384.,
    (double)363686./3137161264. * 16384.,
    (double)231388./3137161264. * 16384.,
    (double)220816./3137161264. * 16384.,
    (double)332002./3137161264. * 16384.,
    (double)451358./3137161264. * 16384.,
    (double)405020./3137161264. * 16384.,
    (double)317524./3137161264. * 16384.,
    (double)385851./3137161264. * 16384.,
    (double)356112./3137161264. * 16384.,
    (double)34045./3137161264. * 16384.,
    (double)270604./3137161264. * 16384.,
    (double)389419./3137161264. * 16384.,
    (double)294082./3137161264. * 16384.,
    (double)269961./3137161264. * 16384.,
    (double)333497./3137161264. * 16384.,
    (double)508832./3137161264. * 16384.,
    (double)833089./3137161264. * 16384.,
    (double)377535./3137161264. * 16384.,
    (double)313447./3137161264. * 16384.,
    (double)536273./3137161264. * 16384.,
    (double)461741./3137161264. * 16384.,
    (double)286016./3137161264. * 16384.,
    (double)257408./3137161264. * 16384.,
    (double)290428./3137161264. * 16384.,
    (double)402560./3137161264. * 16384.,
    (double)35661./3137161264. * 16384.,
    (double)182096./3137161264. * 16384.,
    (double)323534./3137161264. * 16384.,
    (double)484096./3137161264. * 16384.,
    (double)334487./3137161264. * 16384.,
    (double)258523./3137161264. * 16384.,
    (double)586665./3137161264. * 16384.,
    (double)633224./3137161264. * 16384.,
    (double)446852./3137161264. * 16384.,
    (double)325456./3137161264. * 16384.,
    (double)477549./3137161264. * 16384.,
    (double)421844./3137161264. * 16384.,
    (double)371895./3137161264. * 16384.,
    (double)283887./3137161264. * 16384.,
    (double)320286./3137161264. * 16384.,
    (double)335793./3137161264. * 16384.,
    (double)33591./3137161264. * 16384.,
    (double)246368./3137161264. * 16384.,
    (double)440848./3137161264. * 16384.,
    (double)325982./3137161264. * 16384.,
    (double)385510./3137161264. * 16384.,
    (double)276934./3137161264. * 16384.,
    (double)489180./3137161264. * 16384.,
    (double)468221./3137161264. * 16384.,
    (double)439281./3137161264. * 16384.,
    (double)358638./3137161264. * 16384.,
    (double)453082./3137161264. * 16384.,
    (double)37353./3137161264. * 16384.,
    (double)36297./3137161264. * 16384.,
    (double)26182./3137161264. * 16384.,
    (double)38593./3137161264. * 16384.,
    (double)345671./3137161264. * 16384.,
    (double)31338./3137161264. * 16384.,
    (double)243859./3137161264. * 16384.,
    (double)361458./3137161264. * 16384.,
    (double)296018./3137161264. * 16384.,
    (double)370323./3137161264. * 16384.,
    (double)319787./3137161264. * 16384.,
    (double)463244./3137161264. * 16384.,
    (double)559840./3137161264. * 16384.,
    (double)302302./3137161264. * 16384.,
    (double)298299./3137161264. * 16384.,
    (double)483805./3137161264. * 16384.,
    (double)396951./3137161264. * 16384.,
    (double)307998./3137161264. * 16384.,
    (double)248648./3137161264. * 16384.,
    (double)369323./3137161264. * 16384.,
    (double)442343./3137161264. * 16384.,
    (double)33374./3137161264. * 16384.,
    (double)286345./3137161264. * 16384.,
    (double)485187./3137161264. * 16384.,
    (double)546036./3137161264. * 16384.,
    (double)450738./3137161264. * 16384.,
    (double)463407./3137161264. * 16384.,
    (double)806841./3137161264. * 16384.,
    (double)1646808./3137161264. * 16384.,
    (double)693740./3137161264. * 16384.,
    (double)658030./3137161264. * 16384.,
    (double)923831./3137161264. * 16384.,
    (double)551683./3137161264. * 16384.,
    (double)359382./3137161264. * 16384.,
    (double)287685./3137161264. * 16384.,
    (double)383760./3137161264. * 16384.,
    (double)678687./3137161264. * 16384.,
    (double)58005./3137161264. * 16384.,
    (double)274446./3137161264. * 16384.,
    (double)409435./3137161264. * 16384.,
    (double)628885./3137161264. * 16384.,
    (double)495506./3137161264. * 16384.,
    (double)298327./3137161264. * 16384.,
    (double)594433./3137161264. * 16384.,
    (double)887614./3137161264. * 16384.,
    (double)560935./3137161264. * 16384.,
    (double)353877./3137161264. * 16384.,
    (double)483729./3137161264. * 16384.,
    (double)459896./3137161264. * 16384.,
    (double)305998./3137161264. * 16384.,
    (double)275165./3137161264. * 16384.,
    (double)293714./3137161264. * 16384.,
    (double)534099./3137161264. * 16384.,
    (double)50596./3137161264. * 16384.,
    (double)294118./3137161264. * 16384.,
    (double)379670./3137161264. * 16384.,
    (double)394404./3137161264. * 16384.,
    (double)425394./3137161264. * 16384.,
    (double)243794./3137161264. * 16384.,
    (double)414606./3137161264. * 16384.,
    (double)606739./3137161264. * 16384.,
    (double)574611./3137161264. * 16384.,
    (double)418450./3137161264. * 16384.,
    (double)557656./3137161264. * 16384.,
    (double)61547./3137161264. * 16384.,
    (double)67115./3137161264. * 16384.,
    (double)45225./3137161264. * 16384.,
    (double)80909./3137161264. * 16384.,
    (double)377145./3137161264. * 16384.,
    (double)44804./3137161264. * 16384.,
    (double)211020./3137161264. * 16384.,
    (double)318156./3137161264. * 16384.,
    (double)320050./3137161264. * 16384.,
    (double)469817./3137161264. * 16384.,
    (double)261785./3137161264. * 16384.,
    (double)486338./3137161264. * 16384.,
    (double)647697./3137161264. * 16384.,
    (double)377560./3137161264. * 16384.,
    (double)343572./3137161264. * 16384.,
    (double)620140./3137161264. * 16384.,
    (double)491565./3137161264. * 16384.,
    (double)420432./3137161264. * 16384.,
    (double)302534./3137161264. * 16384.,
    (double)462258./3137161264. * 16384.,
    (double)485371./3137161264. * 16384.,
    (double)47158./3137161264. * 16384.,
    (double)274907./3137161264. * 16384.,
    (double)471656./3137161264. * 16384.,
    (double)555218./3137161264. * 16384.,
    (double)400401./3137161264. * 16384.,
    (double)444943./3137161264. * 16384.,
    (double)1096214./3137161264. * 16384.,
    (double)94375./3137161264. * 16384.,
    (double)63481./3137161264. * 16384.,
    (double)40900./3137161264. * 16384.,
    (double)64607./3137161264. * 16384.,
    (double)62398./3137161264. * 16384.,
    (double)53180./3137161264. * 16384.,
    (double)31996./3137161264. * 16384.,
    (double)38985./3137161264. * 16384.,
    (double)48958./3137161264. * 16384.,
    (double)7947./3137161264. * 16384.,
    (double)24956./3137161264. * 16384.,
    (double)37189./3137161264. * 16384.,
    (double)44915./3137161264. * 16384.,
    (double)53123./3137161264. * 16384.,
    (double)30010./3137161264. * 16384.,
    (double)52037./3137161264. * 16384.,
    (double)67708./3137161264. * 16384.,
    (double)54037./3137161264. * 16384.,
    (double)30782./3137161264. * 16384.,
    (double)37534./3137161264. * 16384.,
    (double)51797./3137161264. * 16384.,
    (double)47671./3137161264. * 16384.,
    (double)32078./3137161264. * 16384.,
    (double)30841./3137161264. * 16384.,
    (double)47426./3137161264. * 16384.,
    (double)9265./3137161264. * 16384.,
    (double)31302./3137161264. * 16384.,
    (double)37248./3137161264. * 16384.,
    (double)33783./3137161264. * 16384.,
    (double)46343./3137161264. * 16384.,
    (double)23248./3137161264. * 16384.,
    (double)36295./3137161264. * 16384.,
    (double)47290./3137161264. * 16384.,
    (double)58716./3137161264. * 16384.,
    (double)33805./3137161264. * 16384.,
    (double)42946./3137161264. * 16384.,
    (double)6765./3137161264. * 16384.,
    (double)11138./3137161264. * 16384.,
    (double)8112./3137161264. * 16384.,
    (double)7360./3137161264. * 16384.,
    (double)44347./3137161264. * 16384.,
    (double)10083./3137161264. * 16384.,
    (double)31232./3137161264. * 16384.,
    (double)41080./3137161264. * 16384.,
    (double)33829./3137161264. * 16384.,
    (double)59902./3137161264. * 16384.,
    (double)31323./3137161264. * 16384.,
    (double)49760./3137161264. * 16384.,
    (double)73785./3137161264. * 16384.,
    (double)47418./3137161264. * 16384.,
    (double)35660./3137161264. * 16384.,
    (double)71003./3137161264. * 16384.,
    (double)78050./3137161264. * 16384.,
    (double)84015./3137161264. * 16384.,
    (double)53321./3137161264. * 16384.,
    (double)75420./3137161264. * 16384.,
    (double)58260./3137161264. * 16384.,
    (double)7120./3137161264. * 16384.,
    (double)39258./3137161264. * 16384.,
    (double)60546./3137161264. * 16384.,
    (double)62245./3137161264. * 16384.,
    (double)52999./3137161264. * 16384.,
    (double)51452./3137161264. * 16384.,
    (double)108689./3137161264. * 16384.,
    (double)626775./3137161264. * 16384.,
    (double)358597./3137161264. * 16384.,
    (double)262790./3137161264. * 16384.,
    (double)332894./3137161264. * 16384.,
    (double)399570./3137161264. * 16384.,
    (double)318554./3137161264. * 16384.,
    (double)254251./3137161264. * 16384.,
    (double)271897./3137161264. * 16384.,
    (double)451702./3137161264. * 16384.,
    (double)59887./3137161264. * 16384.,
    (double)261036./3137161264. * 16384.,
    (double)352869./3137161264. * 16384.,
    (double)336586./3137161264. * 16384.,
    (double)313654./3137161264. * 16384.,
    (double)265102./3137161264. * 16384.,
    (double)384823./3137161264. * 16384.,
    (double)48185./3137161264. * 16384.,
    (double)47193./3137161264. * 16384.,
    (double)21342./3137161264. * 16384.,
    (double)28443./3137161264. * 16384.,
    (double)31384./3137161264. * 16384.,
    (double)36164./3137161264. * 16384.,
    (double)25164./3137161264. * 16384.,
    (double)21852./3137161264. * 16384.,
    (double)39235./3137161264. * 16384.,
    (double)8969./3137161264. * 16384.,
    (double)30004./3137161264. * 16384.,
    (double)32699./3137161264. * 16384.,
    (double)38005./3137161264. * 16384.,
    (double)48376./3137161264. * 16384.,
    (double)28116./3137161264. * 16384.,
    (double)36204./3137161264. * 16384.,
    (double)368825./3137161264. * 16384.,
    (double)407279./3137161264. * 16384.,
    (double)252704./3137161264. * 16384.,
    (double)275817./3137161264. * 16384.,
    (double)36658./3137161264. * 16384.,
    (double)51453./3137161264. * 16384.,
    (double)28865./3137161264. * 16384.,
    (double)34148./3137161264. * 16384.,
    (double)352021./3137161264. * 16384.,
    (double)52808./3137161264. * 16384.,
    (double)171861./3137161264. * 16384.,
    (double)240208./3137161264. * 16384.,
    (double)218159./3137161264. * 16384.,
    (double)325806./3137161264. * 16384.,
    (double)221717./3137161264. * 16384.,
    (double)264849./3137161264. * 16384.,
    (double)331452./3137161264. * 16384.,
    (double)221235./3137161264. * 16384.,
    (double)184115./3137161264. * 16384.,
    (double)242531./3137161264. * 16384.,
    (double)328781./3137161264. * 16384.,
    (double)329016./3137161264. * 16384.,
    (double)239157./3137161264. * 16384.,
    (double)290115./3137161264. * 16384.,
    (double)373155./3137161264. * 16384.,
    (double)43983./3137161264. * 16384.,
    (double)280007./3137161264. * 16384.,
    (double)369579./3137161264. * 16384.,
    (double)259559./3137161264. * 16384.,
    (double)283912./3137161264. * 16384.,
    (double)265604./3137161264. * 16384.,
    (double)394324./3137161264. * 16384.,
    (double)615803./3137161264. * 16384.,
    (double)295763./3137161264. * 16384.,
    (double)223979./3137161264. * 16384.,
    (double)404671./3137161264. * 16384.,
    (double)357560./3137161264. * 16384.,
    (double)206474./3137161264. * 16384.,
    (double)159451./3137161264. * 16384.,
    (double)212255./3137161264. * 16384.,
    (double)371814./3137161264. * 16384.,
    (double)35254./3137161264. * 16384.,
    (double)187533./3137161264. * 16384.,
    (double)306303./3137161264. * 16384.,
    (double)431568./3137161264. * 16384.,
    (double)306125./3137161264. * 16384.,
    (double)217694./3137161264. * 16384.,
    (double)474437./3137161264. * 16384.,
    (double)637004./3137161264. * 16384.,
    (double)458530./3137161264. * 16384.,
    (double)260784./3137161264. * 16384.,
    (double)372447./3137161264. * 16384.,
    (double)422354./3137161264. * 16384.,
    (double)336448./3137161264. * 16384.,
    (double)239319./3137161264. * 16384.,
    (double)256239./3137161264. * 16384.,
    (double)400219./3137161264. * 16384.,
    (double)37890./3137161264. * 16384.,
    (double)257941./3137161264. * 16384.,
    (double)375977./3137161264. * 16384.,
    (double)395433./3137161264. * 16384.,
    (double)409094./3137161264. * 16384.,
    (double)263348./3137161264. * 16384.,
    (double)409358./3137161264. * 16384.,
    (double)446218./3137161264. * 16384.,
    (double)420131./3137161264. * 16384.,
    (double)290984./3137161264. * 16384.,
    (double)400860./3137161264. * 16384.,
    (double)40228./3137161264. * 16384.,
    (double)43808./3137161264. * 16384.,
    (double)26558./3137161264. * 16384.,
    (double)40634./3137161264. * 16384.,
    (double)385854./3137161264. * 16384.,
    (double)45586./3137161264. * 16384.,
    (double)250089./3137161264. * 16384.,
    (double)407441./3137161264. * 16384.,
    (double)327746./3137161264. * 16384.,
    (double)434928./3137161264. * 16384.,
    (double)308502./3137161264. * 16384.,
    (double)465325./3137161264. * 16384.,
    (double)491093./3137161264. * 16384.,
    (double)273994./3137161264. * 16384.,
    (double)273923./3137161264. * 16384.,
    (double)368302./3137161264. * 16384.,
    (double)392880./3137161264. * 16384.,
    (double)323833./3137161264. * 16384.,
    (double)256053./3137161264. * 16384.,
    (double)337763./3137161264. * 16384.,
    (double)477263./3137161264. * 16384.,
    (double)42264./3137161264. * 16384.,
    (double)345596./3137161264. * 16384.,
    (double)514522./3137161264. * 16384.,
    (double)546936./3137161264. * 16384.,
    (double)456359./3137161264. * 16384.,
    (double)448138./3137161264. * 16384.,
    (double)805292./3137161264. * 16384.,
    (double)2217986./3137161264. * 16384.,
    (double)872966./3137161264. * 16384.,
    (double)705895./3137161264. * 16384.,
    (double)1690582./3137161264. * 16384.,
    (double)684438./3137161264. * 16384.,
    (double)379391./3137161264. * 16384.,
    (double)354999./3137161264. * 16384.,
    (double)514764./3137161264. * 16384.,
    (double)703078./3137161264. * 16384.,
    (double)62862./3137161264. * 16384.,
    (double)300548./3137161264. * 16384.,
    (double)555493./3137161264. * 16384.,
    (double)1228775./3137161264. * 16384.,
    (double)701452./3137161264. * 16384.,
    (double)469834./3137161264. * 16384.,
    (double)1126027./3137161264. * 16384.,
    (double)814389./3137161264. * 16384.,
    (double)410112./3137161264. * 16384.,
    (double)287312./3137161264. * 16384.,
    (double)485550./3137161264. * 16384.,
    (double)399725./3137161264. * 16384.,
    (double)223000./3137161264. * 16384.,
    (double)208883./3137161264. * 16384.,
    (double)275253./3137161264. * 16384.,
    (double)457020./3137161264. * 16384.,
    (double)33586./3137161264. * 16384.,
    (double)245817./3137161264. * 16384.,
    (double)387045./3137161264. * 16384.,
    (double)433383./3137161264. * 16384.,
    (double)330085./3137161264. * 16384.,
    (double)235257./3137161264. * 16384.,
    (double)467636./3137161264. * 16384.,
    (double)746023./3137161264. * 16384.,
    (double)527907./3137161264. * 16384.,
    (double)358922./3137161264. * 16384.,
    (double)721114./3137161264. * 16384.,
    (double)58507./3137161264. * 16384.,
    (double)46184./3137161264. * 16384.,
    (double)32983./3137161264. * 16384.,
    (double)82640./3137161264. * 16384.,
    (double)406397./3137161264. * 16384.,
    (double)35293./3137161264. * 16384.,
    (double)189946./3137161264. * 16384.,
    (double)361574./3137161264. * 16384.,
    (double)423790./3137161264. * 16384.,
    (double)414041./3137161264. * 16384.,
    (double)260934./3137161264. * 16384.,
    (double)569699./3137161264. * 16384.,
    (double)1007997./3137161264. * 16384.,
    (double)467201./3137161264. * 16384.,
    (double)477778./3137161264. * 16384.,
    (double)1208291./3137161264. * 16384.,
    (double)592461./3137161264. * 16384.,
    (double)390626./3137161264. * 16384.,
    (double)361439./3137161264. * 16384.,
    (double)687322./3137161264. * 16384.,
    (double)583435./3137161264. * 16384.,
    (double)45590./3137161264. * 16384.,
    (double)352503./3137161264. * 16384.,
    (double)629191./3137161264. * 16384.,
    (double)931815./3137161264. * 16384.,
    (double)578942./3137161264. * 16384.,
    (double)621677./3137161264. * 16384.,
    (double)1730482./3137161264. * 16384.,
    (double)1225970./3137161264. * 16384.,
    (double)651403./3137161264. * 16384.,
    (double)432741./3137161264. * 16384.,
    (double)870894./3137161264. * 16384.,
    (double)703330./3137161264. * 16384.,
    (double)450881./3137161264. * 16384.,
    (double)318333./3137161264. * 16384.,
    (double)445786./3137161264. * 16384.,
    (double)571647./3137161264. * 16384.,
    (double)52252./3137161264. * 16384.,
    (double)262771./3137161264. * 16384.,
    (double)463744./3137161264. * 16384.,
    (double)555678./3137161264. * 16384.,
    (double)491597./3137161264. * 16384.,
    (double)299014./3137161264. * 16384.,
    (double)587034./3137161264. * 16384.,
    (double)770174./3137161264. * 16384.,
    (double)446298./3137161264. * 16384.,
    (double)268810./3137161264. * 16384.,
    (double)433841./3137161264. * 16384.,
    (double)473880./3137161264. * 16384.,
    (double)329990./3137161264. * 16384.,
    (double)232866./3137161264. * 16384.,
    (double)286966./3137161264. * 16384.,
    (double)456348./3137161264. * 16384.,
    (double)50087./3137161264. * 16384.,
    (double)252747./3137161264. * 16384.,
    (double)398025./3137161264. * 16384.,
    (double)364009./3137161264. * 16384.,
    (double)365572./3137161264. * 16384.,
    (double)200347./3137161264. * 16384.,
    (double)376137./3137161264. * 16384.,
    (double)589593./3137161264. * 16384.,
    (double)475513./3137161264. * 16384.,
    (double)280962./3137161264. * 16384.,
    (double)506459./3137161264. * 16384.,
    (double)38645./3137161264. * 16384.,
    (double)37695./3137161264. * 16384.,
    (double)24385./3137161264. * 16384.,
    (double)45680./3137161264. * 16384.,
    (double)440594./3137161264. * 16384.,
    (double)40769./3137161264. * 16384.,
    (double)245005./3137161264. * 16384.,
    (double)412421./3137161264. * 16384.,
    (double)390056./3137161264. * 16384.,
    (double)462219./3137161264. * 16384.,
    (double)281397./3137161264. * 16384.,
    (double)526484./3137161264. * 16384.,
    (double)710721./3137161264. * 16384.,
    (double)370242./3137161264. * 16384.,
    (double)313866./3137161264. * 16384.,
    (double)669966./3137161264. * 16384.,
    (double)560530./3137161264. * 16384.,
    (double)441291./3137161264. * 16384.,
    (double)315797./3137161264. * 16384.,
    (double)563247./3137161264. * 16384.,
    (double)529548./3137161264. * 16384.,
    (double)37213./3137161264. * 16384.,
    (double)316859./3137161264. * 16384.,
    (double)531162./3137161264. * 16384.,
    (double)600946./3137161264. * 16384.,
    (double)444725./3137161264. * 16384.,
    (double)436994./3137161264. * 16384.,
    (double)940989./3137161264. * 16384.,
    (double)706786./3137161264. * 16384.,
    (double)398311./3137161264. * 16384.,
    (double)306061./3137161264. * 16384.,
    (double)524078./3137161264. * 16384.,
    (double)515595./3137161264. * 16384.,
    (double)319597./3137161264. * 16384.,
    (double)282395./3137161264. * 16384.,
    (double)395785./3137161264. * 16384.,
    (double)510011./3137161264. * 16384.,
    (double)57228./3137161264. * 16384.,
    (double)271249./3137161264. * 16384.,
    (double)433076./3137161264. * 16384.,
    (double)462063./3137161264. * 16384.,
    (double)399879./3137161264. * 16384.,
    (double)319862./3137161264. * 16384.,
    (double)579965./3137161264. * 16384.,
    (double)50277./3137161264. * 16384.,
    (double)38656./3137161264. * 16384.,
    (double)24360./3137161264. * 16384.,
    (double)42441./3137161264. * 16384.,
    (double)33665./3137161264. * 16384.,
    (double)31037./3137161264. * 16384.,
    (double)24653./3137161264. * 16384.,
    (double)29138./3137161264. * 16384.,
    (double)37513./3137161264. * 16384.,
    (double)5734./3137161264. * 16384.,
    (double)30395./3137161264. * 16384.,
    (double)56202./3137161264. * 16384.,
    (double)42271./3137161264. * 16384.,
    (double)46807./3137161264. * 16384.,
    (double)28610./3137161264. * 16384.,
    (double)50814./3137161264. * 16384.,
    (double)425516./3137161264. * 16384.,
    (double)389017./3137161264. * 16384.,
    (double)260140./3137161264. * 16384.,
    (double)387082./3137161264. * 16384.,
    (double)32396./3137161264. * 16384.,
    (double)27547./3137161264. * 16384.,
    (double)22381./3137161264. * 16384.,
    (double)37312./3137161264. * 16384.,
    (double)444748./3137161264. * 16384.,
    (double)38228./3137161264. * 16384.,
    (double)214470./3137161264. * 16384.,
    (double)309077./3137161264. * 16384.,
    (double)325292./3137161264. * 16384.,
    (double)358630./3137161264. * 16384.,
    (double)300494./3137161264. * 16384.,
    (double)400954./3137161264. * 16384.,
    (double)436823./3137161264. * 16384.,
    (double)279170./3137161264. * 16384.,
    (double)253715./3137161264. * 16384.,
    (double)416816./3137161264. * 16384.,
    (double)450876./3137161264. * 16384.,
    (double)325796./3137161264. * 16384.,
    (double)291031./3137161264. * 16384.,
    (double)452583./3137161264. * 16384.,
    (double)495003./3137161264. * 16384.,
    (double)42950./3137161264. * 16384.,
    (double)299913./3137161264. * 16384.,
    (double)498965./3137161264. * 16384.,
    (double)417931./3137161264. * 16384.,
    (double)356302./3137161264. * 16384.,
    (double)369769./3137161264. * 16384.,
    (double)646410./3137161264. * 16384.,
    (double)1269173./3137161264. * 16384.,
    (double)504423./3137161264. * 16384.,
    (double)423478./3137161264. * 16384.,
    (double)832858./3137161264. * 16384.,
    (double)528912./3137161264. * 16384.,
    (double)314113./3137161264. * 16384.,
    (double)359127./3137161264. * 16384.,
    (double)384880./3137161264. * 16384.,
    (double)597002./3137161264. * 16384.,
    (double)50423./3137161264. * 16384.,
    (double)296424./3137161264. * 16384.,
    (double)496500./3137161264. * 16384.,
    (double)846364./3137161264. * 16384.,
    (double)529529./3137161264. * 16384.,
    (double)446604./3137161264. * 16384.,
    (double)1083316./3137161264. * 16384.,
    (double)595686./3137161264. * 16384.,
    (double)358834./3137161264. * 16384.,
    (double)253255./3137161264. * 16384.,
    (double)418906./3137161264. * 16384.,
    (double)373400./3137161264. * 16384.,
    (double)250941./3137161264. * 16384.,
    (double)224659./3137161264. * 16384.,
    (double)281645./3137161264. * 16384.,
    (double)388398./3137161264. * 16384.,
    (double)27306./3137161264. * 16384.,
    (double)249606./3137161264. * 16384.,
    (double)438735./3137161264. * 16384.,
    (double)466717./3137161264. * 16384.,
    (double)400115./3137161264. * 16384.,
    (double)286626./3137161264. * 16384.,
    (double)562966./3137161264. * 16384.,
    (double)672891./3137161264. * 16384.,
    (double)546867./3137161264. * 16384.,
    (double)379779./3137161264. * 16384.,
    (double)621966./3137161264. * 16384.,
    (double)46125./3137161264. * 16384.,
    (double)35117./3137161264. * 16384.,
    (double)25461./3137161264. * 16384.,
    (double)48542./3137161264. * 16384.,
    (double)546385./3137161264. * 16384.,
    (double)39070./3137161264. * 16384.,
    (double)307122./3137161264. * 16384.,
    (double)523272./3137161264. * 16384.,
    (double)572588./3137161264. * 16384.,
    (double)585577./3137161264. * 16384.,
    (double)457763./3137161264. * 16384.,
    (double)701703./3137161264. * 16384.,
    (double)1059930./3137161264. * 16384.,
    (double)496719./3137161264. * 16384.,
    (double)467454./3137161264. * 16384.,
    (double)993620./3137161264. * 16384.,
    (double)648457./3137161264. * 16384.,
    (double)488894./3137161264. * 16384.,
    (double)400771./3137161264. * 16384.,
    (double)652196./3137161264. * 16384.,
    (double)805536./3137161264. * 16384.,
    (double)43984./3137161264. * 16384.,
    (double)520523./3137161264. * 16384.,
    (double)895356./3137161264. * 16384.,
    (double)1290460./3137161264. * 16384.,
    (double)790854./3137161264. * 16384.,
    (double)806577./3137161264. * 16384.,
    (double)1624300./3137161264. * 16384.,
    (double)2047795./3137161264. * 16384.,
    (double)1143159./3137161264. * 16384.,
    (double)872077./3137161264. * 16384.,
    (double)1436313./3137161264. * 16384.,
    (double)1201947./3137161264. * 16384.,
    (double)714727./3137161264. * 16384.,
    (double)532505./3137161264. * 16384.,
    (double)652870./3137161264. * 16384.,
    (double)914049./3137161264. * 16384.,
    (double)99240./3137161264. * 16384.,
    (double)422085./3137161264. * 16384.,
    (double)661571./3137161264. * 16384.,
    (double)1142077./3137161264. * 16384.,
    (double)924159./3137161264. * 16384.,
    (double)540317./3137161264. * 16384.,
    (double)912579./3137161264. * 16384.,
    (double)1004796./3137161264. * 16384.,
    (double)710906./3137161264. * 16384.,
    (double)427644./3137161264. * 16384.,
    (double)510025./3137161264. * 16384.,
    (double)693344./3137161264. * 16384.,
    (double)476054./3137161264. * 16384.,
    (double)381476./3137161264. * 16384.,
    (double)378354./3137161264. * 16384.,
    (double)595797./3137161264. * 16384.,
    (double)59351./3137161264. * 16384.,
    (double)386000./3137161264. * 16384.,
    (double)456993./3137161264. * 16384.,
    (double)434843./3137161264. * 16384.,
    (double)460288./3137161264. * 16384.,
    (double)343523./3137161264. * 16384.,
    (double)499188./3137161264. * 16384.,
    (double)598141./3137161264. * 16384.,
    (double)529961./3137161264. * 16384.,
    (double)369256./3137161264. * 16384.,
    (double)512722./3137161264. * 16384.,
    (double)59830./3137161264. * 16384.,
    (double)52879./3137161264. * 16384.,
    (double)40498./3137161264. * 16384.,
    (double)68254./3137161264. * 16384.,
    (double)394854./3137161264. * 16384.,
    (double)43972./3137161264. * 16384.,
    (double)235818./3137161264. * 16384.,
    (double)305048./3137161264. * 16384.,
    (double)350918./3137161264. * 16384.,
    (double)446655./3137161264. * 16384.,
    (double)321324./3137161264. * 16384.,
    (double)465993./3137161264. * 16384.,
    (double)774177./3137161264. * 16384.,
    (double)414280./3137161264. * 16384.,
    (double)329725./3137161264. * 16384.,
    (double)673581./3137161264. * 16384.,
    (double)656430./3137161264. * 16384.,
    (double)480448./3137161264. * 16384.,
    (double)339830./3137161264. * 16384.,
    (double)541888./3137161264. * 16384.,
    (double)503141./3137161264. * 16384.,
    (double)58964./3137161264. * 16384.,
    (double)291114./3137161264. * 16384.,
    (double)457192./3137161264. * 16384.,
    (double)588520./3137161264. * 16384.,
    (double)434591./3137161264. * 16384.,
    (double)458777./3137161264. * 16384.,
    (double)822873./3137161264. * 16384.,
    (double)1284745./3137161264. * 16384.,
    (double)802378./3137161264. * 16384.,
    (double)403237./3137161264. * 16384.,
    (double)621984./3137161264. * 16384.,
    (double)1097110./3137161264. * 16384.,
    (double)640266./3137161264. * 16384.,
    (double)360951./3137161264. * 16384.,
    (double)393191./3137161264. * 16384.,
    (double)622013./3137161264. * 16384.,
    (double)92163./3137161264. * 16384.,
    (double)290324./3137161264. * 16384.,
    (double)407130./3137161264. * 16384.,
    (double)465395./3137161264. * 16384.,
    (double)567514./3137161264. * 16384.,
    (double)269911./3137161264. * 16384.,
    (double)493329./3137161264. * 16384.,
    (double)761821./3137161264. * 16384.,
    (double)597037./3137161264. * 16384.,
    (double)281684./3137161264. * 16384.,
    (double)351308./3137161264. * 16384.,
    (double)556717./3137161264. * 16384.,
    (double)368173./3137161264. * 16384.,
    (double)284846./3137161264. * 16384.,
    (double)290740./3137161264. * 16384.,
    (double)493153./3137161264. * 16384.,
    (double)74232./3137161264. * 16384.,
    (double)338009./3137161264. * 16384.,
    (double)422090./3137161264. * 16384.,
    (double)294839./3137161264. * 16384.,
    (double)397294./3137161264. * 16384.,
    (double)231514./3137161264. * 16384.,
    (double)351090./3137161264. * 16384.,
    (double)478153./3137161264. * 16384.,
    (double)520410./3137161264. * 16384.,
    (double)266611./3137161264. * 16384.,
    (double)328618./3137161264. * 16384.,
    (double)70153./3137161264. * 16384.,
    (double)53724./3137161264. * 16384.,
    (double)39225./3137161264. * 16384.,
    (double)42843./3137161264. * 16384.,
    (double)423610./3137161264. * 16384.,
    (double)60898./3137161264. * 16384.,
    (double)289636./3137161264. * 16384.,
    (double)348795./3137161264. * 16384.,
    (double)282084./3137161264. * 16384.,
    (double)481602./3137161264. * 16384.,
    (double)301792./3137161264. * 16384.,
    (double)367234./3137161264. * 16384.,
    (double)390838./3137161264. * 16384.,
    (double)287570./3137161264. * 16384.,
    (double)167123./3137161264. * 16384.,
    (double)287104./3137161264. * 16384.,
    (double)454868./3137161264. * 16384.,
    (double)362365./3137161264. * 16384.,
    (double)213872./3137161264. * 16384.,
    (double)296487./3137161264. * 16384.,
    (double)358665./3137161264. * 16384.,
    (double)36896./3137161264. * 16384.,
    (double)234922./3137161264. * 16384.,
    (double)339717./3137161264. * 16384.,
    (double)320322./3137161264. * 16384.,
    (double)331353./3137161264. * 16384.,
    (double)296027./3137161264. * 16384.,
    (double)516838./3137161264. * 16384.,
    (double)684609./3137161264. * 16384.,
    (double)406810./3137161264. * 16384.,
    (double)255335./3137161264. * 16384.,
    (double)397067./3137161264. * 16384.,
    (double)673937./3137161264. * 16384.,
    (double)462965./3137161264. * 16384.,
    (double)319250./3137161264. * 16384.,
    (double)368273./3137161264. * 16384.,
    (double)560607./3137161264. * 16384.,
    (double)74364./3137161264. * 16384.,
    (double)247955./3137161264. * 16384.,
    (double)369098./3137161264. * 16384.,
    (double)396141./3137161264. * 16384.,
    (double)384859./3137161264. * 16384.,
    (double)267268./3137161264. * 16384.,
    (double)515691./3137161264. * 16384.,
    (double)55736./3137161264. * 16384.,
    (double)58659./3137161264. * 16384.,
    (double)31204./3137161264. * 16384.,
    (double)42470./3137161264. * 16384.,
    (double)76067./3137161264. * 16384.,
    (double)81372./3137161264. * 16384.,
    (double)44119./3137161264. * 16384.,
    (double)45627./3137161264. * 16384.,
    (double)50306./3137161264. * 16384.,
    (double)13842./3137161264. * 16384.,
    (double)42673./3137161264. * 16384.,
    (double)51526./3137161264. * 16384.,
    (double)42211./3137161264. * 16384.,
    (double)75752./3137161264. * 16384.,
    (double)37741./3137161264. * 16384.,
    (double)57511./3137161264. * 16384.,
    (double)314446./3137161264. * 16384.,
    (double)351522./3137161264. * 16384.,
    (double)236594./3137161264. * 16384.,
    (double)265973./3137161264. * 16384.,
    (double)38378./3137161264. * 16384.,
    (double)35775./3137161264. * 16384.,
    (double)27126./3137161264. * 16384.,
    (double)37827./3137161264. * 16384.,
    (double)302064./3137161264. * 16384.,
    (double)42795./3137161264. * 16384.,
    (double)222054./3137161264. * 16384.,
    (double)297774./3137161264. * 16384.,
    (double)205361./3137161264. * 16384.,
    (double)298370./3137161264. * 16384.,
    (double)228908./3137161264. * 16384.,
    (double)278723./3137161264. * 16384.,
    (double)292846./3137161264. * 16384.,
    (double)204798./3137161264. * 16384.,
    (double)163592./3137161264. * 16384.,
    (double)256965./3137161264. * 16384.,
    (double)390132./3137161264. * 16384.,
    (double)343615./3137161264. * 16384.,
    (double)236930./3137161264. * 16384.,
    (double)324688./3137161264. * 16384.,
    (double)332956./3137161264. * 16384.,
    (double)41453./3137161264. * 16384.,
    (double)256945./3137161264. * 16384.,
    (double)334501./3137161264. * 16384.,
    (double)281226./3137161264. * 16384.,
    (double)307033./3137161264. * 16384.,
    (double)308871./3137161264. * 16384.,
    (double)464406./3137161264. * 16384.,
    (double)752380./3137161264. * 16384.,
    (double)359594./3137161264. * 16384.,
    (double)270140./3137161264. * 16384.,
    (double)554887./3137161264. * 16384.,
    (double)394634./3137161264. * 16384.,
    (double)236459./3137161264. * 16384.,
    (double)178890./3137161264. * 16384.,
    (double)247697./3137161264. * 16384.,
    (double)425663./3137161264. * 16384.,
    (double)50401./3137161264. * 16384.,
    (double)195967./3137161264. * 16384.,
    (double)323513./3137161264. * 16384.,
    (double)473876./3137161264. * 16384.,
    (double)341374./3137161264. * 16384.,
    (double)251745./3137161264. * 16384.,
    (double)601971./3137161264. * 16384.,
    (double)608162./3137161264. * 16384.,
    (double)480195./3137161264. * 16384.,
    (double)298386./3137161264. * 16384.,
    (double)423970./3137161264. * 16384.,
    (double)484292./3137161264. * 16384.,
    (double)411534./3137161264. * 16384.,
    (double)295925./3137161264. * 16384.,
    (double)323709./3137161264. * 16384.,
    (double)365034./3137161264. * 16384.,
    (double)41069./3137161264. * 16384.,
    (double)272996./3137161264. * 16384.,
    (double)391805./3137161264. * 16384.,
    (double)327669./3137161264. * 16384.,
    (double)402512./3137161264. * 16384.,
    (double)269936./3137161264. * 16384.,
    (double)441784./3137161264. * 16384.,
    (double)333214./3137161264. * 16384.,
    (double)302207./3137161264. * 16384.,
    (double)253347./3137161264. * 16384.,
    (double)333989./3137161264. * 16384.,
    (double)36893./3137161264. * 16384.,
    (double)26963./3137161264. * 16384.,
    (double)34329./3137161264. * 16384.,
    (double)39438./3137161264. * 16384.,
    (double)261580./3137161264. * 16384.,
    (double)28537./3137161264. * 16384.,
    (double)190520./3137161264. * 16384.,
    (double)266185./3137161264. * 16384.,
    (double)231511./3137161264. * 16384.,
    (double)315197./3137161264. * 16384.,
    (double)249271./3137161264. * 16384.,
    (double)339161./3137161264. * 16384.,
    (double)459145./3137161264. * 16384.,
    (double)265160./3137161264. * 16384.,
    (double)224214./3137161264. * 16384.,
    (double)442909./3137161264. * 16384.,
    (double)297048./3137161264. * 16384.,
    (double)241029./3137161264. * 16384.,
    (double)212820./3137161264. * 16384.,
    (double)304580./3137161264. * 16384.,
    (double)400796./3137161264. * 16384.,
    (double)34546./3137161264. * 16384.,
    (double)278550./3137161264. * 16384.,
    (double)445027./3137161264. * 16384.,
    (double)507647./3137161264. * 16384.,
    (double)452748./3137161264. * 16384.,
    (double)449285./3137161264. * 16384.,
    (double)832271./3137161264. * 16384.,
    (double)1191426./3137161264. * 16384.,
    (double)774252./3137161264. * 16384.,
    (double)534916./3137161264. * 16384.,
    (double)790755./3137161264. * 16384.,
    (double)830400./3137161264. * 16384.,
    (double)675462./3137161264. * 16384.,
    (double)451218./3137161264. * 16384.,
    (double)474326./3137161264. * 16384.,
    (double)468625./3137161264. * 16384.,
    (double)60064./3137161264. * 16384.,
    (double)238527./3137161264. * 16384.,
    (double)372175./3137161264. * 16384.,
    (double)477495./3137161264. * 16384.,
    (double)483858./3137161264. * 16384.,
    (double)288171./3137161264. * 16384.,
    (double)510545./3137161264. * 16384.,
    (double)739296./3137161264. * 16384.,
    (double)609992./3137161264. * 16384.,
    (double)346801./3137161264. * 16384.,
    (double)402659./3137161264. * 16384.,
    (double)637913./3137161264. * 16384.,
    (double)494828./3137161264. * 16384.,
    (double)426467./3137161264. * 16384.,
    (double)372063./3137161264. * 16384.,
    (double)396349./3137161264. * 16384.,
    (double)61432./3137161264. * 16384.,
    (double)305540./3137161264. * 16384.,
    (double)382211./3137161264. * 16384.,
    (double)241347./3137161264. * 16384.,
    (double)336857./3137161264. * 16384.,
    (double)233355./3137161264. * 16384.,
    (double)384987./3137161264. * 16384.,
    (double)369625./3137161264. * 16384.,
    (double)438124./3137161264. * 16384.,
    (double)299544./3137161264. * 16384.,
    (double)350067./3137161264. * 16384.,
    (double)45076./3137161264. * 16384.,
    (double)57062./3137161264. * 16384.,
    (double)43977./3137161264. * 16384.,
    (double)51948./3137161264. * 16384.,
    (double)252440./3137161264. * 16384.,
    (double)36322./3137161264. * 16384.,
    (double)210926./3137161264. * 16384.,
    (double)241391./3137161264. * 16384.,
    (double)200404./3137161264. * 16384.,
    (double)310845./3137161264. * 16384.,
    (double)235528./3137161264. * 16384.,
    (double)337160./3137161264. * 16384.,
    (double)372879./3137161264. * 16384.,
    (double)222170./3137161264. * 16384.,
    (double)188082./3137161264. * 16384.,
    (double)337168./3137161264. * 16384.,
    (double)394838./3137161264. * 16384.,
    (double)383501./3137161264. * 16384.,
    (double)253312./3137161264. * 16384.,
    (double)325835./3137161264. * 16384.,
    (double)272493./3137161264. * 16384.,
    (double)34509./3137161264. * 16384.,
    (double)184626./3137161264. * 16384.,
    (double)262400./3137161264. * 16384.,
    (double)314789./3137161264. * 16384.,
    (double)250424./3137161264. * 16384.,
    (double)262135./3137161264. * 16384.,
    (double)499305./3137161264. * 16384.,
    (double)734807./3137161264. * 16384.,
    (double)627928./3137161264. * 16384.,
    (double)279444./3137161264. * 16384.,
    (double)379419./3137161264. * 16384.,
    (double)616963./3137161264. * 16384.,
    (double)617523./3137161264. * 16384.,
    (double)305149./3137161264. * 16384.,
    (double)295070./3137161264. * 16384.,
    (double)370688./3137161264. * 16384.,
    (double)56247./3137161264. * 16384.,
    (double)214055./3137161264. * 16384.,
    (double)282047./3137161264. * 16384.,
    (double)254920./3137161264. * 16384.,
    (double)352827./3137161264. * 16384.,
    (double)179325./3137161264. * 16384.,
    (double)294335./3137161264. * 16384.,
    (double)488628./3137161264. * 16384.,
    (double)450470./3137161264. * 16384.,
    (double)221941./3137161264. * 16384.,
    (double)237124./3137161264. * 16384.,
    (double)307048./3137161264. * 16384.,
    (double)131577./3137161264. * 16384.,
    (double)217524./3137161264. * 16384.,
    (double)196376./3137161264. * 16384.,
    (double)318423./3137161264. * 16384.,
    (double)68971./3137161264. * 16384.,
    (double)247674./3137161264. * 16384.,
    (double)328418./3137161264. * 16384.,
    (double)161848./3137161264. * 16384.,
    (double)298036./3137161264. * 16384.,
    (double)180781./3137161264. * 16384.,
    (double)225612./3137161264. * 16384.,
    (double)313651./3137161264. * 16384.,
    (double)495109./3137161264. * 16384.,
    (double)232056./3137161264. * 16384.,
    (double)267134./3137161264. * 16384.,
    (double)45633./3137161264. * 16384.,
    (double)75677./3137161264. * 16384.,
    (double)43627./3137161264. * 16384.,
    (double)42046./3137161264. * 16384.,
    (double)305576./3137161264. * 16384.,
    (double)62264./3137161264. * 16384.,
    (double)238645./3137161264. * 16384.,
    (double)308061./3137161264. * 16384.,
    (double)177331./3137161264. * 16384.,
    (double)428636./3137161264. * 16384.,
    (double)262744./3137161264. * 16384.,
    (double)309454./3137161264. * 16384.,
    (double)239662./3137161264. * 16384.,
    (double)212455./3137161264. * 16384.,
    (double)124708./3137161264. * 16384.,
    (double)188070./3137161264. * 16384.,
    (double)310632./3137161264. * 16384.,
    (double)384849./3137161264. * 16384.,
    (double)182803./3137161264. * 16384.,
    (double)233394./3137161264. * 16384.,
    (double)253152./3137161264. * 16384.,
    (double)32671./3137161264. * 16384.,
    (double)187106./3137161264. * 16384.,
    (double)289595./3137161264. * 16384.,
    (double)191564./3137161264. * 16384.,
    (double)229362./3137161264. * 16384.,
    (double)187802./3137161264. * 16384.,
    (double)346294./3137161264. * 16384.,
    (double)535516./3137161264. * 16384.,
    (double)394998./3137161264. * 16384.,
    (double)225953./3137161264. * 16384.,
    (double)318392./3137161264. * 16384.,
    (double)626596./3137161264. * 16384.,
    (double)608611./3137161264. * 16384.,
    (double)383787./3137161264. * 16384.,
    (double)355357./3137161264. * 16384.,
    (double)414088./3137161264. * 16384.,
    (double)78161./3137161264. * 16384.,
    (double)234728./3137161264. * 16384.,
    (double)329904./3137161264. * 16384.,
    (double)272194./3137161264. * 16384.,
    (double)397523./3137161264. * 16384.,
    (double)239953./3137161264. * 16384.,
    (double)393177./3137161264. * 16384.,
    (double)41004./3137161264. * 16384.,
    (double)64474./3137161264. * 16384.,
    (double)30073./3137161264. * 16384.,
    (double)37818./3137161264. * 16384.,
    (double)74691./3137161264. * 16384.,
    (double)112620./3137161264. * 16384.,
    (double)66497./3137161264. * 16384.,
    (double)42874./3137161264. * 16384.,
    (double)48765./3137161264. * 16384.,
    (double)27680./3137161264. * 16384.,
    (double)60554./3137161264. * 16384.,
    (double)50423./3137161264. * 16384.,
    (double)27779./3137161264. * 16384.,
    (double)107179./3137161264. * 16384.,
    (double)35809./3137161264. * 16384.,
    (double)39291./3137161264. * 16384.,
    (double)328460./3137161264. * 16384.,
    (double)444477./3137161264. * 16384.,
    (double)278460./3137161264. * 16384.,
    (double)279384./3137161264. * 16384.,
    (double)71055./3137161264. * 16384.,
    (double)81823./3137161264. * 16384.,
    (double)50095./3137161264. * 16384.,
    (double)45214./3137161264. * 16384.,
    (double)315414./3137161264. * 16384.,
    (double)58493./3137161264. * 16384.,
    (double)253511./3137161264. * 16384.,
    (double)302017./3137161264. * 16384.,
    (double)174959./3137161264. * 16384.,
    (double)381186./3137161264. * 16384.,
    (double)303340./3137161264. * 16384.,
    (double)298434./3137161264. * 16384.,
    (double)238742./3137161264. * 16384.,
    (double)191746./3137161264. * 16384.,
    (double)160778./3137161264. * 16384.,
    (double)212981./3137161264. * 16384.,
    (double)467178./3137161264. * 16384.,
    (double)575402./3137161264. * 16384.,
    (double)372480./3137161264. * 16384.,
    (double)366409./3137161264. * 16384.,
    (double)323049./3137161264. * 16384.,
    (double)43049./3137161264. * 16384.,
    (double)258087./3137161264. * 16384.,
    (double)332611./3137161264. * 16384.,
    (double)230523./3137161264. * 16384.,
    (double)269258./3137161264. * 16384.,
    (double)296854./3137161264. * 16384.,
    (double)410194./3137161264. * 16384.,
    (double)437357./3137161264. * 16384.,
    (double)272645./3137161264. * 16384.,
    (double)189196./3137161264. * 16384.,
    (double)308917./3137161264. * 16384.,
    (double)324086./3137161264. * 16384.,
    (double)254318./3137161264. * 16384.,
    (double)159473./3137161264. * 16384.,
    (double)193413./3137161264. * 16384.,
    (double)250659./3137161264. * 16384.,
    (double)28458./3137161264. * 16384.,
    (double)136511./3137161264. * 16384.,
    (double)211077./3137161264. * 16384.,
    (double)267841./3137161264. * 16384.,
    (double)235360./3137161264. * 16384.,
    (double)161007./3137161264. * 16384.,
    (double)339163./3137161264. * 16384.,
    (double)388113./3137161264. * 16384.,
    (double)386792./3137161264. * 16384.,
    (double)247781./3137161264. * 16384.,
    (double)326585./3137161264. * 16384.,
    (double)376988./3137161264. * 16384.,
    (double)452869./3137161264. * 16384.,
    (double)275459./3137161264. * 16384.,
    (double)277499./3137161264. * 16384.,
    (double)259718./3137161264. * 16384.,
    (double)47488./3137161264. * 16384.,
    (double)227223./3137161264. * 16384.,
    (double)307235./3137161264. * 16384.,
    (double)186746./3137161264. * 16384.,
    (double)361457./3137161264. * 16384.,
    (double)203611./3137161264. * 16384.,
    (double)291233./3137161264. * 16384.,
    (double)265907./3137161264. * 16384.,
    (double)336164./3137161264. * 16384.,
    (double)260720./3137161264. * 16384.,
    (double)286573./3137161264. * 16384.,
    (double)31381./3137161264. * 16384.,
    (double)38401./3137161264. * 16384.,
    (double)25715./3137161264. * 16384.,
    (double)29652./3137161264. * 16384.,
    (double)197069./3137161264. * 16384.,
    (double)26694./3137161264. * 16384.,
    (double)192415./3137161264. * 16384.,
    (double)235250./3137161264. * 16384.,
    (double)164959./3137161264. * 16384.,
    (double)274756./3137161264. * 16384.,
    (double)238103./3137161264. * 16384.,
    (double)295646./3137161264. * 16384.,
    (double)297881./3137161264. * 16384.,
    (double)186672./3137161264. * 16384.,
    (double)156943./3137161264. * 16384.,
    (double)259032./3137161264. * 16384.,
    (double)259559./3137161264. * 16384.,
    (double)259244./3137161264. * 16384.,
    (double)205536./3137161264. * 16384.,
    (double)243858./3137161264. * 16384.,
    (double)255865./3137161264. * 16384.,
    (double)24055./3137161264. * 16384.,
    (double)189761./3137161264. * 16384.,
    (double)288359./3137161264. * 16384.,
    (double)300034./3137161264. * 16384.,
    (double)315863./3137161264. * 16384.,
    (double)305533./3137161264. * 16384.,
    (double)514541./3137161264. * 16384.,
    (double)736774./3137161264. * 16384.,
    (double)521113./3137161264. * 16384.,
    (double)353208./3137161264. * 16384.,
    (double)541384./3137161264. * 16384.,
    (double)495634./3137161264. * 16384.,
    (double)351202./3137161264. * 16384.,
    (double)246522./3137161264. * 16384.,
    (double)324203./3137161264. * 16384.,
    (double)392959./3137161264. * 16384.,
    (double)46379./3137161264. * 16384.,
    (double)197523./3137161264. * 16384.,
    (double)290680./3137161264. * 16384.,
    (double)375781./3137161264. * 16384.,
    (double)366205./3137161264. * 16384.,
    (double)235743./3137161264. * 16384.,
    (double)410725./3137161264. * 16384.,
    (double)593186./3137161264. * 16384.,
    (double)563036./3137161264. * 16384.,
    (double)250708./3137161264. * 16384.,
    (double)351538./3137161264. * 16384.,
    (double)470273./3137161264. * 16384.,
    (double)416564./3137161264. * 16384.,
    (double)296217./3137161264. * 16384.,
    (double)312890./3137161264. * 16384.,
    (double)504618./3137161264. * 16384.,
    (double)73949./3137161264. * 16384.,
    (double)357045./3137161264. * 16384.,
    (double)407361./3137161264. * 16384.,
    (double)266706./3137161264. * 16384.,
    (double)400443./3137161264. * 16384.,
    (double)217778./3137161264. * 16384.,
    (double)341456./3137161264. * 16384.,
    (double)339589./3137161264. * 16384.,
    (double)471007./3137161264. * 16384.,
    (double)260922./3137161264. * 16384.,
    (double)360993./3137161264. * 16384.,
    (double)43350./3137161264. * 16384.,
    (double)57914./3137161264. * 16384.,
    (double)40178./3137161264. * 16384.,
    (double)66066./3137161264. * 16384.,
    (double)299433./3137161264. * 16384.,
    (double)49768./3137161264. * 16384.,
    (double)208436./3137161264. * 16384.,
    (double)303235./3137161264. * 16384.,
    (double)207293./3137161264. * 16384.,
    (double)370183./3137161264. * 16384.,
    (double)214237./3137161264. * 16384.,
    (double)406113./3137161264. * 16384.,
    (double)331699./3137161264. * 16384.,
    (double)228554./3137161264. * 16384.,
    (double)164480./3137161264. * 16384.,
    (double)342594./3137161264. * 16384.,
    (double)328768./3137161264. * 16384.,
    (double)328592./3137161264. * 16384.,
    (double)215372./3137161264. * 16384.,
    (double)327853./3137161264. * 16384.,
    (double)337005./3137161264. * 16384.,
    (double)39879./3137161264. * 16384.,
    (double)240868./3137161264. * 16384.,
    (double)372282./3137161264. * 16384.,
    (double)325241./3137161264. * 16384.,
    (double)267106./3137161264. * 16384.,
    (double)302146./3137161264. * 16384.,
    (double)652104./3137161264. * 16384.,
    (double)51040./3137161264. * 16384.,
    (double)44352./3137161264. * 16384.,
    (double)22978./3137161264. * 16384.,
    (double)33688./3137161264. * 16384.,
    (double)78848./3137161264. * 16384.,
    (double)65013./3137161264. * 16384.,
    (double)42055./3137161264. * 16384.,
    (double)37350./3137161264. * 16384.,
    (double)36240./3137161264. * 16384.,
    (double)9680./3137161264. * 16384.,
    (double)25279./3137161264. * 16384.,
    (double)32006./3137161264. * 16384.,
    (double)28076./3137161264. * 16384.,
    (double)43638./3137161264. * 16384.,
    (double)34233./3137161264. * 16384.,
    (double)46116./3137161264. * 16384.,
    (double)41205./3137161264. * 16384.,
    (double)54244./3137161264. * 16384.,
    (double)22238./3137161264. * 16384.,
    (double)26382./3137161264. * 16384.,
    (double)59529./3137161264. * 16384.,
    (double)75864./3137161264. * 16384.,
    (double)44103./3137161264. * 16384.,
    (double)39316./3137161264. * 16384.,
    (double)49209./3137161264. * 16384.,
    (double)24020./3137161264. * 16384.,
    (double)47976./3137161264. * 16384.,
    (double)49462./3137161264. * 16384.,
    (double)22511./3137161264. * 16384.,
    (double)46455./3137161264. * 16384.,
    (double)24120./3137161264. * 16384.,
    (double)29387./3137161264. * 16384.,
    (double)28019./3137161264. * 16384.,
    (double)57510./3137161264. * 16384.,
    (double)28378./3137161264. * 16384.,
    (double)29387./3137161264. * 16384.,
    (double)9861./3137161264. * 16384.,
    (double)22381./3137161264. * 16384.,
    (double)17154./3137161264. * 16384.,
    (double)9890./3137161264. * 16384.,
    (double)43062./3137161264. * 16384.,
    (double)20675./3137161264. * 16384.,
    (double)46691./3137161264. * 16384.,
    (double)49326./3137161264. * 16384.,
    (double)23066./3137161264. * 16384.,
    (double)59241./3137161264. * 16384.,
    (double)38082./3137161264. * 16384.,
    (double)43038./3137161264. * 16384.,
    (double)30970./3137161264. * 16384.,
    (double)27177./3137161264. * 16384.,
    (double)16488./3137161264. * 16384.,
    (double)31663./3137161264. * 16384.,
    (double)54521./3137161264. * 16384.,
    (double)73828./3137161264. * 16384.,
    (double)38881./3137161264. * 16384.,
    (double)50370./3137161264. * 16384.,
    (double)37243./3137161264. * 16384.,
    (double)8124./3137161264. * 16384.,
    (double)38545./3137161264. * 16384.,
    (double)49076./3137161264. * 16384.,
    (double)29633./3137161264. * 16384.,
    (double)33962./3137161264. * 16384.,
    (double)37021./3137161264. * 16384.,
    (double)58824./3137161264. * 16384.,
    (double)463932./3137161264. * 16384.,
    (double)405070./3137161264. * 16384.,
    (double)216543./3137161264. * 16384.,
    (double)273072./3137161264. * 16384.,
    (double)437764./3137161264. * 16384.,
    (double)512501./3137161264. * 16384.,
    (double)316837./3137161264. * 16384.,
    (double)305776./3137161264. * 16384.,
    (double)444408./3137161264. * 16384.,
    (double)89738./3137161264. * 16384.,
    (double)451170./3137161264. * 16384.,
    (double)435840./3137161264. * 16384.,
    (double)258624./3137161264. * 16384.,
    (double)348349./3137161264. * 16384.,
    (double)267861./3137161264. * 16384.,
    (double)370008./3137161264. * 16384.,
    (double)39231./3137161264. * 16384.,
    (double)84616./3137161264. * 16384.,
    (double)27638./3137161264. * 16384.,
    (double)27427./3137161264. * 16384.,
    (double)45654./3137161264. * 16384.,
    (double)104889./3137161264. * 16384.,
    (double)51942./3137161264. * 16384.,
    (double)33520./3137161264. * 16384.,
    (double)47094./3137161264. * 16384.,
    (double)23300./3137161264. * 16384.,
    (double)61102./3137161264. * 16384.,
    (double)50389./3137161264. * 16384.,
    (double)27041./3137161264. * 16384.,
    (double)62591./3137161264. * 16384.,
    (double)33722./3137161264. * 16384.,
    (double)33760./3137161264. * 16384.,
    (double)268922./3137161264. * 16384.,
    (double)499529./3137161264. * 16384.,
    (double)244393./3137161264. * 16384.,
    (double)250572./3137161264. * 16384.,
    (double)42166./3137161264. * 16384.,
    (double)78326./3137161264. * 16384.,
    (double)44894./3137161264. * 16384.,
    (double)41877./3137161264. * 16384.,
    (double)370908./3137161264. * 16384.,
    (double)84285./3137161264. * 16384.,
    (double)226972./3137161264. * 16384.,
    (double)312843./3137161264. * 16384.,
    (double)184428./3137161264. * 16384.,
    (double)407633./3137161264. * 16384.,
    (double)259537./3137161264. * 16384.,
    (double)287132./3137161264. * 16384.,
    (double)219168./3137161264. * 16384.,
    (double)218119./3137161264. * 16384.,
    (double)143656./3137161264. * 16384.,
    (double)190292./3137161264. * 16384.,
    (double)343206./3137161264. * 16384.,
    (double)556959./3137161264. * 16384.,
    (double)278813./3137161264. * 16384.,
    (double)312391./3137161264. * 16384.,
    (double)401721./3137161264. * 16384.,
    (double)73408./3137161264. * 16384.,
    (double)408746./3137161264. * 16384.,
    (double)393968./3137161264. * 16384.,
    (double)216918./3137161264. * 16384.,
    (double)307490./3137161264. * 16384.,
    (double)302847./3137161264. * 16384.,
    (double)373784./3137161264. * 16384.,
    (double)374340./3137161264. * 16384.,
    (double)244691./3137161264. * 16384.,
    (double)163426./3137161264. * 16384.,
    (double)293531./3137161264. * 16384.,
    (double)258277./3137161264. * 16384.,
    (double)194440./3137161264. * 16384.,
    (double)127852./3137161264. * 16384.,
    (double)172560./3137161264. * 16384.,
    (double)264095./3137161264. * 16384.,
    (double)33119./3137161264. * 16384.,
    (double)165124./3137161264. * 16384.,
    (double)289910./3137161264. * 16384.,
    (double)254104./3137161264. * 16384.,
    (double)239865./3137161264. * 16384.,
    (double)160528./3137161264. * 16384.,
    (double)349029./3137161264. * 16384.,
    (double)429188./3137161264. * 16384.,
    (double)466050./3137161264. * 16384.,
    (double)220246./3137161264. * 16384.,
    (double)278709./3137161264. * 16384.,
    (double)426640./3137161264. * 16384.,
    (double)547981./3137161264. * 16384.,
    (double)266795./3137161264. * 16384.,
    (double)277950./3137161264. * 16384.,
    (double)375596./3137161264. * 16384.,
    (double)60791./3137161264. * 16384.,
    (double)316403./3137161264. * 16384.,
    (double)397344./3137161264. * 16384.,
    (double)265598./3137161264. * 16384.,
    (double)426924./3137161264. * 16384.,
    (double)245488./3137161264. * 16384.,
    (double)338370./3137161264. * 16384.,
    (double)288358./3137161264. * 16384.,
    (double)401370./3137161264. * 16384.,
    (double)255532./3137161264. * 16384.,
    (double)287990./3137161264. * 16384.,
    (double)30745./3137161264. * 16384.,
    (double)46521./3137161264. * 16384.,
    (double)30044./3137161264. * 16384.,
    (double)33042./3137161264. * 16384.,
    (double)340822./3137161264. * 16384.,
    (double)57261./3137161264. * 16384.,
    (double)280060./3137161264. * 16384.,
    (double)355021./3137161264. * 16384.,
    (double)231125./3137161264. * 16384.,
    (double)440787./3137161264. * 16384.,
    (double)289158./3137161264. * 16384.,
    (double)378025./3137161264. * 16384.,
    (double)266685./3137161264. * 16384.,
    (double)196899./3137161264. * 16384.,
    (double)154752./3137161264. * 16384.,
    (double)252175./3137161264. * 16384.,
    (double)253190./3137161264. * 16384.,
    (double)272674./3137161264. * 16384.,
    (double)191968./3137161264. * 16384.,
    (double)239677./3137161264. * 16384.,
    (double)352566./3137161264. * 16384.,
    (double)39203./3137161264. * 16384.,
    (double)341636./3137161264. * 16384.,
    (double)419422./3137161264. * 16384.,
    (double)344086./3137161264. * 16384.,
    (double)368864./3137161264. * 16384.,
    (double)353112./3137161264. * 16384.,
    (double)524717./3137161264. * 16384.,
    (double)743523./3137161264. * 16384.,
    (double)373183./3137161264. * 16384.,
    (double)288419./3137161264. * 16384.,
    (double)578312./3137161264. * 16384.,
    (double)361257./3137161264. * 16384.,
    (double)215691./3137161264. * 16384.,
    (double)184606./3137161264. * 16384.,
    (double)310705./3137161264. * 16384.,
    (double)337869./3137161264. * 16384.,
    (double)32463./3137161264. * 16384.,
    (double)149062./3137161264. * 16384.,
    (double)303726./3137161264. * 16384.,
    (double)413885./3137161264. * 16384.,
    (double)297141./3137161264. * 16384.,
    (double)200007./3137161264. * 16384.,
    (double)462006./3137161264. * 16384.,
    (double)442268./3137161264. * 16384.,
    (double)305890./3137161264. * 16384.,
    (double)164175./3137161264. * 16384.,
    (double)271986./3137161264. * 16384.,
    (double)262533./3137161264. * 16384.,
    (double)186443./3137161264. * 16384.,
    (double)147778./3137161264. * 16384.,
    (double)217115./3137161264. * 16384.,
    (double)256680./3137161264. * 16384.,
    (double)25005./3137161264. * 16384.,
    (double)158405./3137161264. * 16384.,
    (double)302415./3137161264. * 16384.,
    (double)225211./3137161264. * 16384.,
    (double)192871./3137161264. * 16384.,
    (double)136649./3137161264. * 16384.,
    (double)275451./3137161264. * 16384.,
    (double)285758./3137161264. * 16384.,
    (double)266172./3137161264. * 16384.,
    (double)156082./3137161264. * 16384.,
    (double)282714./3137161264. * 16384.,
    (double)23134./3137161264. * 16384.,
    (double)21724./3137161264. * 16384.,
    (double)14557./3137161264. * 16384.,
    (double)35460./3137161264. * 16384.,
    (double)185920./3137161264. * 16384.,
    (double)19597./3137161264. * 16384.,
    (double)109255./3137161264. * 16384.,
    (double)205276./3137161264. * 16384.,
    (double)182245./3137161264. * 16384.,
    (double)210248./3137161264. * 16384.,
    (double)140595./3137161264. * 16384.,
    (double)287259./3137161264. * 16384.,
    (double)379103./3137161264. * 16384.,
    (double)204198./3137161264. * 16384.,
    (double)176882./3137161264. * 16384.,
    (double)410819./3137161264. * 16384.,
    (double)252654./3137161264. * 16384.,
    (double)189300./3137161264. * 16384.,
    (double)146214./3137161264. * 16384.,
    (double)304596./3137161264. * 16384.,
    (double)251165./3137161264. * 16384.,
    (double)20857./3137161264. * 16384.,
    (double)147870./3137161264. * 16384.,
    (double)305934./3137161264. * 16384.,
    (double)351006./3137161264. * 16384.,
    (double)235226./3137161264. * 16384.,
    (double)264325./3137161264. * 16384.,
    (double)666046./3137161264. * 16384.,
    (double)633934./3137161264. * 16384.,
    (double)395937./3137161264. * 16384.,
    (double)248172./3137161264. * 16384.,
    (double)408805./3137161264. * 16384.,
    (double)497135./3137161264. * 16384.,
    (double)368166./3137161264. * 16384.,
    (double)318428./3137161264. * 16384.,
    (double)325210./3137161264. * 16384.,
    (double)369694./3137161264. * 16384.,
    (double)45557./3137161264. * 16384.,
    (double)203447./3137161264. * 16384.,
    (double)331236./3137161264. * 16384.,
    (double)309748./3137161264. * 16384.,
    (double)349359./3137161264. * 16384.,
    (double)220103./3137161264. * 16384.,
    (double)391739./3137161264. * 16384.,
    (double)432657./3137161264. * 16384.,
    (double)351956./3137161264. * 16384.,
    (double)169085./3137161264. * 16384.,
    (double)256092./3137161264. * 16384.,
    (double)385922./3137161264. * 16384.,
    (double)338895./3137161264. * 16384.,
    (double)216507./3137161264. * 16384.,
    (double)262094./3137161264. * 16384.,
    (double)352807./3137161264. * 16384.,
    (double)57543./3137161264. * 16384.,
    (double)223200./3137161264. * 16384.,
    (double)351246./3137161264. * 16384.,
    (double)241769./3137161264. * 16384.,
    (double)322457./3137161264. * 16384.,
    (double)172454./3137161264. * 16384.,
    (double)312702./3137161264. * 16384.,
    (double)257861./3137161264. * 16384.,
    (double)330050./3137161264. * 16384.,
    (double)162667./3137161264. * 16384.,
    (double)236873./3137161264. * 16384.,
    (double)26354./3137161264. * 16384.,
    (double)36965./3137161264. * 16384.,
    (double)22442./3137161264. * 16384.,
    (double)32312./3137161264. * 16384.,
    (double)266021./3137161264. * 16384.,
    (double)39444./3137161264. * 16384.,
    (double)201245./3137161264. * 16384.,
    (double)312734./3137161264. * 16384.,
    (double)226919./3137161264. * 16384.,
    (double)377027./3137161264. * 16384.,
    (double)218152./3137161264. * 16384.,
    (double)350055./3137161264. * 16384.,
    (double)274438./3137161264. * 16384.,
    (double)197511./3137161264. * 16384.,
    (double)150906./3137161264. * 16384.,
    (double)276344./3137161264. * 16384.,
    (double)328650./3137161264. * 16384.,
    (double)330640./3137161264. * 16384.,
    (double)205059./3137161264. * 16384.,
    (double)353265./3137161264. * 16384.,
    (double)277135./3137161264. * 16384.,
    (double)27838./3137161264. * 16384.,
    (double)217645./3137161264. * 16384.,
    (double)342200./3137161264. * 16384.,
    (double)285289./3137161264. * 16384.,
    (double)280186./3137161264. * 16384.,
    (double)275733./3137161264. * 16384.,
    (double)523325./3137161264. * 16384.,
    (double)406342./3137161264. * 16384.,
    (double)272184./3137161264. * 16384.,
    (double)184254./3137161264. * 16384.,
    (double)275345./3137161264. * 16384.,
    (double)355791./3137161264. * 16384.,
    (double)301504./3137161264. * 16384.,
    (double)222856./3137161264. * 16384.,
    (double)279096./3137161264. * 16384.,
    (double)371520./3137161264. * 16384.,
    (double)50194./3137161264. * 16384.,
    (double)223001./3137161264. * 16384.,
    (double)326857./3137161264. * 16384.,
    (double)272716./3137161264. * 16384.,
    (double)277079./3137161264. * 16384.,
    (double)237704./3137161264. * 16384.,
    (double)413351./3137161264. * 16384.,
    (double)27545./3137161264. * 16384.,
    (double)29798./3137161264. * 16384.,
    (double)15337./3137161264. * 16384.,
    (double)23851./3137161264. * 16384.,
    (double)26840./3137161264. * 16384.,
    (double)41229./3137161264. * 16384.,
    (double)26519./3137161264. * 16384.,
    (double)24092./3137161264. * 16384.,
    (double)24550./3137161264. * 16384.,
    (double)6294./3137161264. * 16384.,
    (double)23550./3137161264. * 16384.,
    (double)31267./3137161264. * 16384.,
    (double)23048./3137161264. * 16384.,
    (double)35159./3137161264. * 16384.,
    (double)22141./3137161264. * 16384.,
    (double)32547./3137161264. * 16384.,
    (double)244140./3137161264. * 16384.,
    (double)285692./3137161264. * 16384.,
    (double)166935./3137161264. * 16384.,
    (double)235624./3137161264. * 16384.,
    (double)24600./3137161264. * 16384.,
    (double)27627./3137161264. * 16384.,
    (double)19350./3137161264. * 16384.,
    (double)30347./3137161264. * 16384.,
    (double)288762./3137161264. * 16384.,
    (double)38897./3137161264. * 16384.,
    (double)187876./3137161264. * 16384.,
    (double)263784./3137161264. * 16384.,
    (double)198393./3137161264. * 16384.,
    (double)295709./3137161264. * 16384.,
    (double)226793./3137161264. * 16384.,
    (double)293593./3137161264. * 16384.,
    (double)231500./3137161264. * 16384.,
    (double)187244./3137161264. * 16384.,
    (double)149240./3137161264. * 16384.,
    (double)234894./3137161264. * 16384.,
    (double)296685./3137161264. * 16384.,
    (double)280849./3137161264. * 16384.,
    (double)199505./3137161264. * 16384.,
    (double)312873./3137161264. * 16384.,
    (double)337481./3137161264. * 16384.,
    (double)43558./3137161264. * 16384.,
    (double)262641./3137161264. * 16384.,
    (double)364326./3137161264. * 16384.,
    (double)259758./3137161264. * 16384.,
    (double)266795./3137161264. * 16384.,
    (double)297132./3137161264. * 16384.,
    (double)451617./3137161264. * 16384.,
    (double)526659./3137161264. * 16384.,
    (double)271667./3137161264. * 16384.,
    (double)211116./3137161264. * 16384.,
    (double)393535./3137161264. * 16384.,
    (double)268017./3137161264. * 16384.,
    (double)196554./3137161264. * 16384.,
    (double)150196./3137161264. * 16384.,
    (double)197321./3137161264. * 16384.,
    (double)308379./3137161264. * 16384.,
    (double)32822./3137161264. * 16384.,
    (double)168901./3137161264. * 16384.,
    (double)290553./3137161264. * 16384.,
    (double)331514./3137161264. * 16384.,
    (double)241045./3137161264. * 16384.,
    (double)211743./3137161264. * 16384.,
    (double)487997./3137161264. * 16384.,
    (double)372264./3137161264. * 16384.,
    (double)266789./3137161264. * 16384.,
    (double)163943./3137161264. * 16384.,
    (double)260496./3137161264. * 16384.,
    (double)281553./3137161264. * 16384.,
    (double)250961./3137161264. * 16384.,
    (double)173055./3137161264. * 16384.,
    (double)214620./3137161264. * 16384.,
    (double)244261./3137161264. * 16384.,
    (double)21458./3137161264. * 16384.,
    (double)173095./3137161264. * 16384.,
    (double)279317./3137161264. * 16384.,
    (double)259772./3137161264. * 16384.,
    (double)252169./3137161264. * 16384.,
    (double)195485./3137161264. * 16384.,
    (double)352380./3137161264. * 16384.,
    (double)365217./3137161264. * 16384.,
    (double)329034./3137161264. * 16384.,
    (double)222112./3137161264. * 16384.,
    (double)337198./3137161264. * 16384.,
    (double)41715./3137161264. * 16384.,
    (double)25445./3137161264. * 16384.,
    (double)17823./3137161264. * 16384.,
    (double)30544./3137161264. * 16384.,
    (double)309794./3137161264. * 16384.,
    (double)30516./3137161264. * 16384.,
    (double)225712./3137161264. * 16384.,
    (double)342248./3137161264. * 16384.,
    (double)305054./3137161264. * 16384.,
    (double)392211./3137161264. * 16384.,
    (double)305673./3137161264. * 16384.,
    (double)445742./3137161264. * 16384.,
    (double)474806./3137161264. * 16384.,
    (double)274333./3137161264. * 16384.,
    (double)249256./3137161264. * 16384.,
    (double)498734./3137161264. * 16384.,
    (double)414079./3137161264. * 16384.,
    (double)346725./3137161264. * 16384.,
    (double)267462./3137161264. * 16384.,
    (double)382069./3137161264. * 16384.,
    (double)466695./3137161264. * 16384.,
    (double)36695./3137161264. * 16384.,
    (double)395141./3137161264. * 16384.,
    (double)591710./3137161264. * 16384.,
    (double)644693./3137161264. * 16384.,
    (double)497369./3137161264. * 16384.,
    (double)547275./3137161264. * 16384.,
    (double)777871./3137161264. * 16384.,
    (double)1378342./3137161264. * 16384.,
    (double)618350./3137161264. * 16384.,
    (double)616188./3137161264. * 16384.,
    (double)926404./3137161264. * 16384.,
    (double)659311./3137161264. * 16384.,
    (double)412949./3137161264. * 16384.,
    (double)366687./3137161264. * 16384.,
    (double)444768./3137161264. * 16384.,
    (double)716432./3137161264. * 16384.,
    (double)64149./3137161264. * 16384.,
    (double)273981./3137161264. * 16384.,
    (double)394714./3137161264. * 16384.,
    (double)769628./3137161264. * 16384.,
    (double)596070./3137161264. * 16384.,
    (double)334484./3137161264. * 16384.,
    (double)613933./3137161264. * 16384.,
    (double)533150./3137161264. * 16384.,
    (double)332920./3137161264. * 16384.,
    (double)224921./3137161264. * 16384.,
    (double)317842./3137161264. * 16384.,
    (double)371089./3137161264. * 16384.,
    (double)227546./3137161264. * 16384.,
    (double)222404./3137161264. * 16384.,
    (double)250399./3137161264. * 16384.,
    (double)334749./3137161264. * 16384.,
    (double)35982./3137161264. * 16384.,
    (double)199081./3137161264. * 16384.,
    (double)238860./3137161264. * 16384.,
    (double)277420./3137161264. * 16384.,
    (double)273454./3137161264. * 16384.,
    (double)195693./3137161264. * 16384.,
    (double)304579./3137161264. * 16384.,
    (double)537230./3137161264. * 16384.,
    (double)354619./3137161264. * 16384.,
    (double)252485./3137161264. * 16384.,
    (double)367648./3137161264. * 16384.,
    (double)42470./3137161264. * 16384.,
    (double)32953./3137161264. * 16384.,
    (double)27234./3137161264. * 16384.,
    (double)52080./3137161264. * 16384.,
    (double)277652./3137161264. * 16384.,
    (double)27268./3137161264. * 16384.,
    (double)176072./3137161264. * 16384.,
    (double)237170./3137161264. * 16384.,
    (double)244754./3137161264. * 16384.,
    (double)284540./3137161264. * 16384.,
    (double)218214./3137161264. * 16384.,
    (double)326082./3137161264. * 16384.,
    (double)569287./3137161264. * 16384.,
    (double)287611./3137161264. * 16384.,
    (double)231459./3137161264. * 16384.,
    (double)470579./3137161264. * 16384.,
    (double)434032./3137161264. * 16384.,
    (double)301909./3137161264. * 16384.,
    (double)245364./3137161264. * 16384.,
    (double)383173./3137161264. * 16384.,
    (double)309750./3137161264. * 16384.,
    (double)27736./3137161264. * 16384.,
    (double)185035./3137161264. * 16384.,
    (double)284525./3137161264. * 16384.,
    (double)414284./3137161264. * 16384.,
    (double)252943./3137161264. * 16384.,
    (double)307057./3137161264. * 16384.,
    (double)604945./3137161264. * 16384.,
    (double)966683./3137161264. * 16384.,
    (double)528569./3137161264. * 16384.,
    (double)347942./3137161264. * 16384.,
    (double)563685./3137161264. * 16384.,
    (double)637833./3137161264. * 16384.,
    (double)443578./3137161264. * 16384.,
    (double)391347./3137161264. * 16384.,
    (double)420114./3137161264. * 16384.,
    (double)506002./3137161264. * 16384.,
    (double)64671./3137161264. * 16384.,
    (double)220576./3137161264. * 16384.,
    (double)323907./3137161264. * 16384.,
    (double)411831./3137161264. * 16384.,
    (double)458359./3137161264. * 16384.,
    (double)217458./3137161264. * 16384.,
    (double)413584./3137161264. * 16384.,
    (double)523796./3137161264. * 16384.,
    (double)379241./3137161264. * 16384.,
    (double)221156./3137161264. * 16384.,
    (double)294825./3137161264. * 16384.,
    (double)385101./3137161264. * 16384.,
    (double)227893./3137161264. * 16384.,
    (double)257644./3137161264. * 16384.,
    (double)282416./3137161264. * 16384.,
    (double)462492./3137161264. * 16384.,
    (double)95784./3137161264. * 16384.,
    (double)237400./3137161264. * 16384.,
    (double)306264./3137161264. * 16384.,
    (double)260174./3137161264. * 16384.,
    (double)356874./3137161264. * 16384.,
    (double)169348./3137161264. * 16384.,
    (double)257857./3137161264. * 16384.,
    (double)457999./3137161264. * 16384.,
    (double)460397./3137161264. * 16384.,
    (double)290984./3137161264. * 16384.,
    (double)378110./3137161264. * 16384.,
    (double)50460./3137161264. * 16384.,
    (double)48717./3137161264. * 16384.,
    (double)42058./3137161264. * 16384.,
    (double)53210./3137161264. * 16384.,
    (double)392097./3137161264. * 16384.,
    (double)49845./3137161264. * 16384.,
    (double)260281./3137161264. * 16384.,
    (double)344328./3137161264. * 16384.,
    (double)259471./3137161264. * 16384.,
    (double)386628./3137161264. * 16384.,
    (double)265140./3137161264. * 16384.,
    (double)330599./3137161264. * 16384.,
    (double)393339./3137161264. * 16384.,
    (double)251538./3137161264. * 16384.,
    (double)175869./3137161264. * 16384.,
    (double)329494./3137161264. * 16384.,
    (double)441631./3137161264. * 16384.,
    (double)370049./3137161264. * 16384.,
    (double)268509./3137161264. * 16384.,
    (double)364898./3137161264. * 16384.,
    (double)318028./3137161264. * 16384.,
    (double)30864./3137161264. * 16384.,
    (double)192937./3137161264. * 16384.,
    (double)296041./3137161264. * 16384.,
    (double)288241./3137161264. * 16384.,
    (double)261625./3137161264. * 16384.,
    (double)263057./3137161264. * 16384.,
    (double)486334./3137161264. * 16384.,
    (double)697669./3137161264. * 16384.,
    (double)302283./3137161264. * 16384.,
    (double)243101./3137161264. * 16384.,
    (double)391533./3137161264. * 16384.,
    (double)591757./3137161264. * 16384.,
    (double)390609./3137161264. * 16384.,
    (double)389750./3137161264. * 16384.,
    (double)398374./3137161264. * 16384.,
    (double)1153299./3137161264. * 16384.,
    (double)111157./3137161264. * 16384.,
    (double)277820./3137161264. * 16384.,
    (double)354956./3137161264. * 16384.,
    (double)533583./3137161264. * 16384.,
    (double)412998./3137161264. * 16384.,
    (double)272776./3137161264. * 16384.,
    (double)506793./3137161264. * 16384.,
    (double)57335./3137161264. * 16384.,
    (double)47033./3137161264. * 16384.,
    (double)28512./3137161264. * 16384.,
    (double)44843./3137161264. * 16384.,
    (double)61722./3137161264. * 16384.,
    (double)55308./3137161264. * 16384.,
    (double)48533./3137161264. * 16384.,
    (double)53412./3137161264. * 16384.,
    (double)80255./3137161264. * 16384.,
    (double)14795./3137161264. * 16384.,
    (double)43395./3137161264. * 16384.,
    (double)48430./3137161264. * 16384.,
    (double)65325./3137161264. * 16384.,
    (double)98203./3137161264. * 16384.,
    (double)40632./3137161264. * 16384.,
    (double)66632./3137161264. * 16384.,
    (double)300858./3137161264. * 16384.,
    (double)274460./3137161264. * 16384.,
    (double)241491./3137161264. * 16384.,
    (double)269168./3137161264. * 16384.,
    (double)36395./3137161264. * 16384.,
    (double)32897./3137161264. * 16384.,
    (double)32591./3137161264. * 16384.,
    (double)43324./3137161264. * 16384.,
    (double)294240./3137161264. * 16384.,
    (double)44598./3137161264. * 16384.,
    (double)184479./3137161264. * 16384.,
    (double)216873./3137161264. * 16384.,
    (double)196806./3137161264. * 16384.,
    (double)313299./3137161264. * 16384.,
    (double)198515./3137161264. * 16384.,
    (double)239292./3137161264. * 16384.,
    (double)268711./3137161264. * 16384.,
    (double)163215./3137161264. * 16384.,
    (double)151184./3137161264. * 16384.,
    (double)241586./3137161264. * 16384.,
    (double)387810./3137161264. * 16384.,
    (double)314291./3137161264. * 16384.,
    (double)274096./3137161264. * 16384.,
    (double)359459./3137161264. * 16384.,
    (double)313681./3137161264. * 16384.,
    (double)34829./3137161264. * 16384.,
    (double)204522./3137161264. * 16384.,
    (double)270124./3137161264. * 16384.,
    (double)296006./3137161264. * 16384.,
    (double)266048./3137161264. * 16384.,
    (double)263131./3137161264. * 16384.,
    (double)434079./3137161264. * 16384.,
    (double)712814./3137161264. * 16384.,
    (double)278929./3137161264. * 16384.,
    (double)234575./3137161264. * 16384.,
    (double)486881./3137161264. * 16384.,
    (double)349004./3137161264. * 16384.,
    (double)215936./3137161264. * 16384.,
    (double)211303./3137161264. * 16384.,
    (double)296377./3137161264. * 16384.,
    (double)529494./3137161264. * 16384.,
    (double)53092./3137161264. * 16384.,
    (double)188929./3137161264. * 16384.,
    (double)292408./3137161264. * 16384.,
    (double)627305./3137161264. * 16384.,
    (double)391987./3137161264. * 16384.,
    (double)244439./3137161264. * 16384.,
    (double)602164./3137161264. * 16384.,
    (double)494977./3137161264. * 16384.,
    (double)305304./3137161264. * 16384.,
    (double)226770./3137161264. * 16384.,
    (double)333194./3137161264. * 16384.,
    (double)387852./3137161264. * 16384.,
    (double)260038./3137161264. * 16384.,
    (double)274281./3137161264. * 16384.,
    (double)310974./3137161264. * 16384.,
    (double)406698./3137161264. * 16384.,
    (double)39222./3137161264. * 16384.,
    (double)223335./3137161264. * 16384.,
    (double)311206./3137161264. * 16384.,
    (double)405849./3137161264. * 16384.,
    (double)371909./3137161264. * 16384.,
    (double)225411./3137161264. * 16384.,
    (double)399338./3137161264. * 16384.,
    (double)343201./3137161264. * 16384.,
    (double)300649./3137161264. * 16384.,
    (double)274334./3137161264. * 16384.,
    (double)360834./3137161264. * 16384.,
    (double)34711./3137161264. * 16384.,
    (double)27083./3137161264. * 16384.,
    (double)28073./3137161264. * 16384.,
    (double)44522./3137161264. * 16384.,
    (double)295102./3137161264. * 16384.,
    (double)30237./3137161264. * 16384.,
    (double)204948./3137161264. * 16384.,
    (double)296575./3137161264. * 16384.,
    (double)275649./3137161264. * 16384.,
    (double)350414./3137161264. * 16384.,
    (double)280687./3137161264. * 16384.,
    (double)397321./3137161264. * 16384.,
    (double)498628./3137161264. * 16384.,
    (double)257954./3137161264. * 16384.,
    (double)235162./3137161264. * 16384.,
    (double)482011./3137161264. * 16384.,
    (double)326129./3137161264. * 16384.,
    (double)235183./3137161264. * 16384.,
    (double)237967./3137161264. * 16384.,
    (double)370164./3137161264. * 16384.,
    (double)452943./3137161264. * 16384.,
    (double)37534./3137161264. * 16384.,
    (double)301093./3137161264. * 16384.,
    (double)490131./3137161264. * 16384.,
    (double)714922./3137161264. * 16384.,
    (double)517279./3137161264. * 16384.,
    (double)563750./3137161264. * 16384.,
    (double)1137696./3137161264. * 16384.,
    (double)82769./3137161264. * 16384.,
    (double)50504./3137161264. * 16384.,
    (double)38225./3137161264. * 16384.,
    (double)54583./3137161264. * 16384.,
    (double)58561./3137161264. * 16384.,
    (double)46699./3137161264. * 16384.,
    (double)36429./3137161264. * 16384.,
    (double)44959./3137161264. * 16384.,
    (double)45218./3137161264. * 16384.,
    (double)6800./3137161264. * 16384.,
    (double)21874./3137161264. * 16384.,
    (double)30758./3137161264. * 16384.,
    (double)45740./3137161264. * 16384.,
    (double)49937./3137161264. * 16384.,
    (double)26802./3137161264. * 16384.,
    (double)43711./3137161264. * 16384.,
    (double)61503./3137161264. * 16384.,
    (double)44544./3137161264. * 16384.,
    (double)31477./3137161264. * 16384.,
    (double)40075./3137161264. * 16384.,
    (double)54803./3137161264. * 16384.,
    (double)44713./3137161264. * 16384.,
    (double)44309./3137161264. * 16384.,
    (double)47471./3137161264. * 16384.,
    (double)36501./3137161264. * 16384.,
    (double)7392./3137161264. * 16384.,
    (double)30958./3137161264. * 16384.,
    (double)32182./3137161264. * 16384.,
    (double)25139./3137161264. * 16384.,
    (double)34077./3137161264. * 16384.,
    (double)24541./3137161264. * 16384.,
    (double)35891./3137161264. * 16384.,
    (double)37439./3137161264. * 16384.,
    (double)41168./3137161264. * 16384.,
    (double)27263./3137161264. * 16384.,
    (double)34156./3137161264. * 16384.,
    (double)7574./3137161264. * 16384.,
    (double)7733./3137161264. * 16384.,
    (double)6676./3137161264. * 16384.,
    (double)8001./3137161264. * 16384.,
    (double)28028./3137161264. * 16384.,
    (double)5002./3137161264. * 16384.,
    (double)22949./3137161264. * 16384.,
    (double)27499./3137161264. * 16384.,
    (double)19986./3137161264. * 16384.,
    (double)32923./3137161264. * 16384.,
    (double)23627./3137161264. * 16384.,
    (double)33155./3137161264. * 16384.,
    (double)39881./3137161264. * 16384.,
    (double)25178./3137161264. * 16384.,
    (double)20572./3137161264. * 16384.,
    (double)36948./3137161264. * 16384.,
    (double)49298./3137161264. * 16384.,
    (double)45047./3137161264. * 16384.,
    (double)34114./3137161264. * 16384.,
    (double)43913./3137161264. * 16384.,
    (double)33498./3137161264. * 16384.,
    (double)4352./3137161264. * 16384.,
    (double)22129./3137161264. * 16384.,
    (double)33530./3137161264. * 16384.,
    (double)33962./3137161264. * 16384.,
    (double)26801./3137161264. * 16384.,
    (double)31724./3137161264. * 16384.,
    (double)55501./3137161264. * 16384.,
    (double)67961./3137161264. * 16384.,
    (double)54469./3137161264. * 16384.,
    (double)29653./3137161264. * 16384.,
    (double)46069./3137161264. * 16384.,
    (double)60390./3137161264. * 16384.,
    (double)62998./3137161264. * 16384.,
    (double)45905./3137161264. * 16384.,
    (double)54757./3137161264. * 16384.,
    (double)42483./3137161264. * 16384.,
    (double)10060./3137161264. * 16384.,
    (double)22260./3137161264. * 16384.,
    (double)32126./3137161264. * 16384.,
    (double)29325./3137161264. * 16384.,
    (double)43049./3137161264. * 16384.,
    (double)21062./3137161264. * 16384.,
    (double)33811./3137161264. * 16384.,
    (double)56681./3137161264. * 16384.,
    (double)56446./3137161264. * 16384.,
    (double)29372./3137161264. * 16384.,
    (double)34307./3137161264. * 16384.,
    (double)58047./3137161264. * 16384.,
    (double)46628./3137161264. * 16384.,
    (double)51179./3137161264. * 16384.,
    (double)55138./3137161264. * 16384.,
    (double)49195./3137161264. * 16384.,
    (double)14474./3137161264. * 16384.,
    (double)33652./3137161264. * 16384.,
    (double)40341./3137161264. * 16384.,
    (double)23154./3137161264. * 16384.,
    (double)40235./3137161264. * 16384.,
    (double)22886./3137161264. * 16384.,
    (double)30551./3137161264. * 16384.,
    (double)40815./3137161264. * 16384.,
    (double)58102./3137161264. * 16384.,
    (double)36009./3137161264. * 16384.,
    (double)36703./3137161264. * 16384.,
    (double)9502./3137161264. * 16384.,
    (double)16209./3137161264. * 16384.,
    (double)13981./3137161264. * 16384.,
    (double)9692./3137161264. * 16384.,
    (double)46694./3137161264. * 16384.,
    (double)14393./3137161264. * 16384.,
    (double)38051./3137161264. * 16384.,
    (double)41615./3137161264. * 16384.,
    (double)21981./3137161264. * 16384.,
    (double)50743./3137161264. * 16384.,
    (double)34843./3137161264. * 16384.,
    (double)37635./3137161264. * 16384.,
    (double)35253./3137161264. * 16384.,
    (double)27306./3137161264. * 16384.,
    (double)18555./3137161264. * 16384.,
    (double)30807./3137161264. * 16384.,
    (double)54041./3137161264. * 16384.,
    (double)63340./3137161264. * 16384.,
    (double)41337./3137161264. * 16384.,
    (double)42769./3137161264. * 16384.,
    (double)34471./3137161264. * 16384.,
    (double)4983./3137161264. * 16384.,
    (double)24645./3137161264. * 16384.,
    (double)33522./3137161264. * 16384.,
    (double)25413./3137161264. * 16384.,
    (double)27721./3137161264. * 16384.,
    (double)27489./3137161264. * 16384.,
    (double)48751./3137161264. * 16384.,
    (double)50080./3137161264. * 16384.,
    (double)31509./3137161264. * 16384.,
    (double)21159./3137161264. * 16384.,
    (double)29622./3137161264. * 16384.,
    (double)56237./3137161264. * 16384.,
    (double)56851./3137161264. * 16384.,
    (double)50333./3137161264. * 16384.,
    (double)40433./3137161264. * 16384.,
    (double)68650./3137161264. * 16384.,
    (double)14347./3137161264. * 16384.,
    (double)32320./3137161264. * 16384.,
    (double)31157./3137161264. * 16384.,
    (double)33046./3137161264. * 16384.,
    (double)44207./3137161264. * 16384.,
    (double)27515./3137161264. * 16384.,
    (double)39949./3137161264. * 16384.,
    (double)5415./3137161264. * 16384.,
    (double)8111./3137161264. * 16384.,
    (double)4687./3137161264. * 16384.,
    (double)5532./3137161264. * 16384.,
    (double)10305./3137161264. * 16384.,
    (double)16488./3137161264. * 16384.,
    (double)14695./3137161264. * 16384.,
    (double)9510./3137161264. * 16384.,
    (double)11349./3137161264. * 16384.,
    (double)8819./3137161264. * 16384.,
    (double)13334./3137161264. * 16384.,
    (double)9231./3137161264. * 16384.,
    (double)4526./3137161264. * 16384.,
    (double)13535./3137161264. * 16384.,
    (double)6731./3137161264. * 16384.,
    (double)6345./3137161264. * 16384.,
    (double)33212./3137161264. * 16384.,
    (double)45882./3137161264. * 16384.,
    (double)39955./3137161264. * 16384.,
    (double)36964./3137161264. * 16384.,
    (double)8416./3137161264. * 16384.,
    (double)13523./3137161264. * 16384.,
    (double)13304./3137161264. * 16384.,
    (double)9096./3137161264. * 16384.,
    (double)54272./3137161264. * 16384.,
    (double)22174./3137161264. * 16384.,
    (double)39264./3137161264. * 16384.,
    (double)37701./3137161264. * 16384.,
    (double)24109./3137161264. * 16384.,
    (double)69731./3137161264. * 16384.,
    (double)36591./3137161264. * 16384.,
    (double)33950./3137161264. * 16384.,
    (double)29465./3137161264. * 16384.,
    (double)19987./3137161264. * 16384.,
    (double)19992./3137161264. * 16384.,
    (double)27310./3137161264. * 16384.,
    (double)50346./3137161264. * 16384.,
    (double)59431./3137161264. * 16384.,
    (double)51375./3137161264. * 16384.,
    (double)51325./3137161264. * 16384.,
    (double)39095./3137161264. * 16384.,
    (double)7375./3137161264. * 16384.,
    (double)34653./3137161264. * 16384.,
    (double)37752./3137161264. * 16384.,
    (double)27707./3137161264. * 16384.,
    (double)33709./3137161264. * 16384.,
    (double)34584./3137161264. * 16384.,
    (double)48692./3137161264. * 16384.,
    (double)68153./3137161264. * 16384.,
    (double)46630./3137161264. * 16384.,
    (double)33410./3137161264. * 16384.,
    (double)51244./3137161264. * 16384.,
    (double)44790./3137161264. * 16384.,
    (double)35235./3137161264. * 16384.,
    (double)30708./3137161264. * 16384.,
    (double)36782./3137161264. * 16384.,
    (double)50843./3137161264. * 16384.,
    (double)6536./3137161264. * 16384.,
    (double)24651./3137161264. * 16384.,
    (double)33568./3137161264. * 16384.,
    (double)60529./3137161264. * 16384.,
    (double)49371./3137161264. * 16384.,
    (double)35707./3137161264. * 16384.,
    (double)70646./3137161264. * 16384.,
    (double)75706./3137161264. * 16384.,
    (double)64596./3137161264. * 16384.,
    (double)47820./3137161264. * 16384.,
    (double)57528./3137161264. * 16384.,
    (double)79462./3137161264. * 16384.,
    (double)75095./3137161264. * 16384.,
    (double)70812./3137161264. * 16384.,
    (double)69241./3137161264. * 16384.,
    (double)72241./3137161264. * 16384.,
    (double)12276./3137161264. * 16384.,
    (double)53333./3137161264. * 16384.,
    (double)61732./3137161264. * 16384.,
    (double)58734./3137161264. * 16384.,
    (double)86965./3137161264. * 16384.,
    (double)49270./3137161264. * 16384.,
    (double)69023./3137161264. * 16384.,
    (double)38729./3137161264. * 16384.,
    (double)45790./3137161264. * 16384.,
    (double)39803./3137161264. * 16384.,
    (double)44427./3137161264. * 16384.,
    (double)5493./3137161264. * 16384.,
    (double)8143./3137161264. * 16384.,
    (double)6540./3137161264. * 16384.,
    (double)7956./3137161264. * 16384.,
    (double)42851./3137161264. * 16384.,
    (double)7712./3137161264. * 16384.,
    (double)37467./3137161264. * 16384.,
    (double)46572./3137161264. * 16384.,
    (double)32736./3137161264. * 16384.,
    (double)52904./3137161264. * 16384.,
    (double)44942./3137161264. * 16384.,
    (double)55527./3137161264. * 16384.,
    (double)55623./3137161264. * 16384.,
    (double)35528./3137161264. * 16384.,
    (double)29985./3137161264. * 16384.,
    (double)51265./3137161264. * 16384.,
    (double)46723./3137161264. * 16384.,
    (double)45016./3137161264. * 16384.,
    (double)37617./3137161264. * 16384.,
    (double)49460./3137161264. * 16384.,
    (double)53170./3137161264. * 16384.,
    (double)5821./3137161264. * 16384.,
    (double)41463./3137161264. * 16384.,
    (double)60464./3137161264. * 16384.,
    (double)66734./3137161264. * 16384.,
    (double)60654./3137161264. * 16384.,
    (double)64569./3137161264. * 16384.,
    (double)112297./3137161264. * 16384.,
    (double)584555./3137161264. * 16384.,
    (double)326457./3137161264. * 16384.,
    (double)249685./3137161264. * 16384.,
    (double)383544./3137161264. * 16384.,
    (double)329957./3137161264. * 16384.,
    (double)257171./3137161264. * 16384.,
    (double)185669./3137161264. * 16384.,
    (double)236778./3137161264. * 16384.,
    (double)291514./3137161264. * 16384.,
    (double)33216./3137161264. * 16384.,
    (double)177276./3137161264. * 16384.,
    (double)208379./3137161264. * 16384.,
    (double)252149./3137161264. * 16384.,
    (double)221985./3137161264. * 16384.,
    (double)155208./3137161264. * 16384.,
    (double)249733./3137161264. * 16384.,
    (double)376971./3137161264. * 16384.,
    (double)290974./3137161264. * 16384.,
    (double)176413./3137161264. * 16384.,
    (double)225760./3137161264. * 16384.,
    (double)310984./3137161264. * 16384.,
    (double)245956./3137161264. * 16384.,
    (double)234334./3137161264. * 16384.,
    (double)206319./3137161264. * 16384.,
    (double)306429./3137161264. * 16384.,
    (double)41248./3137161264. * 16384.,
    (double)271367./3137161264. * 16384.,
    (double)263923./3137161264. * 16384.,
    (double)176604./3137161264. * 16384.,
    (double)232198./3137161264. * 16384.,
    (double)158394./3137161264. * 16384.,
    (double)218029./3137161264. * 16384.,
    (double)327363./3137161264. * 16384.,
    (double)379137./3137161264. * 16384.,
    (double)300268./3137161264. * 16384.,
    (double)320808./3137161264. * 16384.,
    (double)47507./3137161264. * 16384.,
    (double)52704./3137161264. * 16384.,
    (double)85059./3137161264. * 16384.,
    (double)67602./3137161264. * 16384.,
    (double)345348./3137161264. * 16384.,
    (double)47451./3137161264. * 16384.,
    (double)212110./3137161264. * 16384.,
    (double)253507./3137161264. * 16384.,
    (double)192165./3137161264. * 16384.,
    (double)339196./3137161264. * 16384.,
    (double)191468./3137161264. * 16384.,
    (double)270578./3137161264. * 16384.,
    (double)270729./3137161264. * 16384.,
    (double)177412./3137161264. * 16384.,
    (double)149231./3137161264. * 16384.,
    (double)300831./3137161264. * 16384.,
    (double)277029./3137161264. * 16384.,
    (double)240261./3137161264. * 16384.,
    (double)262535./3137161264. * 16384.,
    (double)301324./3137161264. * 16384.,
    (double)297394./3137161264. * 16384.,
    (double)31544./3137161264. * 16384.,
    (double)204089./3137161264. * 16384.,
    (double)289634./3137161264. * 16384.,
    (double)247472./3137161264. * 16384.,
    (double)205658./3137161264. * 16384.,
    (double)232335./3137161264. * 16384.,
    (double)450537./3137161264. * 16384.,
    (double)42788./3137161264. * 16384.,
    (double)35764./3137161264. * 16384.,
    (double)19717./3137161264. * 16384.,
    (double)31839./3137161264. * 16384.,
    (double)43795./3137161264. * 16384.,
    (double)52599./3137161264. * 16384.,
    (double)30584./3137161264. * 16384.,
    (double)33020./3137161264. * 16384.,
    (double)26843./3137161264. * 16384.,
    (double)6361./3137161264. * 16384.,
    (double)19369./3137161264. * 16384.,
    (double)23162./3137161264. * 16384.,
    (double)19651./3137161264. * 16384.,
    (double)26654./3137161264. * 16384.,
    (double)14854./3137161264. * 16384.,
    (double)25340./3137161264. * 16384.,
    (double)31649./3137161264. * 16384.,
    (double)31044./3137161264. * 16384.,
    (double)15819./3137161264. * 16384.,
    (double)18183./3137161264. * 16384.,
    (double)37345./3137161264. * 16384.,
    (double)38646./3137161264. * 16384.,
    (double)32268./3137161264. * 16384.,
    (double)26538./3137161264. * 16384.,
    (double)30274./3137161264. * 16384.,
    (double)10370./3137161264. * 16384.,
    (double)33589./3137161264. * 16384.,
    (double)30596./3137161264. * 16384.,
    (double)15644./3137161264. * 16384.,
    (double)23387./3137161264. * 16384.,
    (double)14618./3137161264. * 16384.,
    (double)18206./3137161264. * 16384.,
    (double)31624./3137161264. * 16384.,
    (double)48129./3137161264. * 16384.,
    (double)59476./3137161264. * 16384.,
    (double)32262./3137161264. * 16384.,
    (double)8183./3137161264. * 16384.,
    (double)14610./3137161264. * 16384.,
    (double)59360./3137161264. * 16384.,
    (double)10539./3137161264. * 16384.,
    (double)36771./3137161264. * 16384.,
    (double)12998./3137161264. * 16384.,
    (double)40206./3137161264. * 16384.,
    (double)37757./3137161264. * 16384.,
    (double)18948./3137161264. * 16384.,
    (double)40462./3137161264. * 16384.,
    (double)27288./3137161264. * 16384.,
    (double)29156./3137161264. * 16384.,
    (double)34272./3137161264. * 16384.,
    (double)23471./3137161264. * 16384.,
    (double)19216./3137161264. * 16384.,
    (double)35752./3137161264. * 16384.,
    (double)45836./3137161264. * 16384.,
    (double)54227./3137161264. * 16384.,
    (double)76518./3137161264. * 16384.,
    (double)52499./3137161264. * 16384.,
    (double)33637./3137161264. * 16384.,
    (double)5524./3137161264. * 16384.,
    (double)28760./3137161264. * 16384.,
    (double)39667./3137161264. * 16384.,
    (double)23931./3137161264. * 16384.,
    (double)24694./3137161264. * 16384.,
    (double)25806./3137161264. * 16384.,
    (double)44046./3137161264. * 16384.,
    (double)366441./3137161264. * 16384.,
    (double)250805./3137161264. * 16384.,
    (double)170186./3137161264. * 16384.,
    (double)193102./3137161264. * 16384.,
    (double)354012./3137161264. * 16384.,
    (double)373746./3137161264. * 16384.,
    (double)312245./3137161264. * 16384.,
    (double)259020./3137161264. * 16384.,
    (double)316701./3137161264. * 16384.,
    (double)55297./3137161264. * 16384.,
    (double)243133./3137161264. * 16384.,
    (double)244485./3137161264. * 16384.,
    (double)172467./3137161264. * 16384.,
    (double)212052./3137161264. * 16384.,
    (double)192248./3137161264. * 16384.,
    (double)246534./3137161264. * 16384.,
    (double)30737./3137161264. * 16384.,
    (double)42356./3137161264. * 16384.,
    (double)22128./3137161264. * 16384.,
    (double)20582./3137161264. * 16384.,
    (double)36873./3137161264. * 16384.,
    (double)60714./3137161264. * 16384.,
    (double)63547./3137161264. * 16384.,
    (double)26903./3137161264. * 16384.,
    (double)35454./3137161264. * 16384.,
    (double)13653./3137161264. * 16384.,
    (double)51873./3137161264. * 16384.,
    (double)36010./3137161264. * 16384.,
    (double)20374./3137161264. * 16384.,
    (double)38073./3137161264. * 16384.,
    (double)27381./3137161264. * 16384.,
    (double)25904./3137161264. * 16384.,
    (double)277933./3137161264. * 16384.,
    (double)321224./3137161264. * 16384.,
    (double)241496./3137161264. * 16384.,
    (double)241236./3137161264. * 16384.,
    (double)40001./3137161264. * 16384.,
    (double)48353./3137161264. * 16384.,
    (double)48425./3137161264. * 16384.,
    (double)50371./3137161264. * 16384.,
    (double)298916./3137161264. * 16384.,
    (double)55218./3137161264. * 16384.,
    (double)120441./3137161264. * 16384.,
    (double)174757./3137161264. * 16384.,
    (double)136524./3137161264. * 16384.,
    (double)243827./3137161264. * 16384.,
    (double)196407./3137161264. * 16384.,
    (double)206181./3137161264. * 16384.,
    (double)189555./3137161264. * 16384.,
    (double)135683./3137161264. * 16384.,
    (double)118265./3137161264. * 16384.,
    (double)154436./3137161264. * 16384.,
    (double)267422./3137161264. * 16384.,
    (double)278449./3137161264. * 16384.,
    (double)231113./3137161264. * 16384.,
    (double)273895./3137161264. * 16384.,
    (double)263264./3137161264. * 16384.,
    (double)37884./3137161264. * 16384.,
    (double)244893./3137161264. * 16384.,
    (double)253301./3137161264. * 16384.,
    (double)155541./3137161264. * 16384.,
    (double)189335./3137161264. * 16384.,
    (double)210944./3137161264. * 16384.,
    (double)264921./3137161264. * 16384.,
    (double)312466./3137161264. * 16384.,
    (double)185302./3137161264. * 16384.,
    (double)143342./3137161264. * 16384.,
    (double)229102./3137161264. * 16384.,
    (double)222411./3137161264. * 16384.,
    (double)167419./3137161264. * 16384.,
    (double)118059./3137161264. * 16384.,
    (double)143956./3137161264. * 16384.,
    (double)214905./3137161264. * 16384.,
    (double)26869./3137161264. * 16384.,
    (double)148243./3137161264. * 16384.,
    (double)200577./3137161264. * 16384.,
    (double)196988./3137161264. * 16384.,
    (double)171813./3137161264. * 16384.,
    (double)123302./3137161264. * 16384.,
    (double)231721./3137161264. * 16384.,
    (double)327039./3137161264. * 16384.,
    (double)288210./3137161264. * 16384.,
    (double)172800./3137161264. * 16384.,
    (double)197847./3137161264. * 16384.,
    (double)319959./3137161264. * 16384.,
    (double)332455./3137161264. * 16384.,
    (double)274909./3137161264. * 16384.,
    (double)204155./3137161264. * 16384.,
    (double)283865./3137161264. * 16384.,
    (double)41521./3137161264. * 16384.,
    (double)267200./3137161264. * 16384.,
    (double)283102./3137161264. * 16384.,
    (double)234327./3137161264. * 16384.,
    (double)286753./3137161264. * 16384.,
    (double)190456./3137161264. * 16384.,
    (double)241285./3137161264. * 16384.,
    (double)284052./3137161264. * 16384.,
    (double)345223./3137161264. * 16384.,
    (double)224572./3137161264. * 16384.,
    (double)283217./3137161264. * 16384.,
    (double)34573./3137161264. * 16384.,
    (double)51173./3137161264. * 16384.,
    (double)34176./3137161264. * 16384.,
    (double)48133./3137161264. * 16384.,
    (double)317282./3137161264. * 16384.,
    (double)52009./3137161264. * 16384.,
    (double)286593./3137161264. * 16384.,
    (double)316771./3137161264. * 16384.,
    (double)202400./3137161264. * 16384.,
    (double)339821./3137161264. * 16384.,
    (double)264904./3137161264. * 16384.,
    (double)308435./3137161264. * 16384.,
    (double)243024./3137161264. * 16384.,
    (double)162818./3137161264. * 16384.,
    (double)132828./3137161264. * 16384.,
    (double)213678./3137161264. * 16384.,
    (double)263967./3137161264. * 16384.,
    (double)249742./3137161264. * 16384.,
    (double)176987./3137161264. * 16384.,
    (double)236705./3137161264. * 16384.,
    (double)289956./3137161264. * 16384.,
    (double)31322./3137161264. * 16384.,
    (double)267253./3137161264. * 16384.,
    (double)320360./3137161264. * 16384.,
    (double)269110./3137161264. * 16384.,
    (double)274490./3137161264. * 16384.,
    (double)278043./3137161264. * 16384.,
    (double)404710./3137161264. * 16384.,
    (double)608238./3137161264. * 16384.,
    (double)279968./3137161264. * 16384.,
    (double)212017./3137161264. * 16384.,
    (double)410655./3137161264. * 16384.,
    (double)273129./3137161264. * 16384.,
    (double)170990./3137161264. * 16384.,
    (double)142818./3137161264. * 16384.,
    (double)206573./3137161264. * 16384.,
    (double)249449./3137161264. * 16384.,
    (double)26205./3137161264. * 16384.,
    (double)114650./3137161264. * 16384.,
    (double)188360./3137161264. * 16384.,
    (double)338409./3137161264. * 16384.,
    (double)222937./3137161264. * 16384.,
    (double)153860./3137161264. * 16384.,
    (double)328672./3137161264. * 16384.,
    (double)347714./3137161264. * 16384.,
    (double)199206./3137161264. * 16384.,
    (double)130717./3137161264. * 16384.,
    (double)196048./3137161264. * 16384.,
    (double)191522./3137161264. * 16384.,
    (double)130549./3137161264. * 16384.,
    (double)114159./3137161264. * 16384.,
    (double)143524./3137161264. * 16384.,
    (double)169829./3137161264. * 16384.,
    (double)15154./3137161264. * 16384.,
    (double)108241./3137161264. * 16384.,
    (double)161437./3137161264. * 16384.,
    (double)147801./3137161264. * 16384.,
    (double)128886./3137161264. * 16384.,
    (double)100050./3137161264. * 16384.,
    (double)178411./3137161264. * 16384.,
    (double)278709./3137161264. * 16384.,
    (double)297134./3137161264. * 16384.,
    (double)158028./3137161264. * 16384.,
    (double)255437./3137161264. * 16384.,
    (double)24514./3137161264. * 16384.,
    (double)23515./3137161264. * 16384.,
    (double)19302./3137161264. * 16384.,
    (double)35905./3137161264. * 16384.,
    (double)192415./3137161264. * 16384.,
    (double)19982./3137161264. * 16384.,
    (double)107409./3137161264. * 16384.,
    (double)175072./3137161264. * 16384.,
    (double)186998./3137161264. * 16384.,
    (double)209049./3137161264. * 16384.,
    (double)143930./3137161264. * 16384.,
    (double)239435./3137161264. * 16384.,
    (double)349895./3137161264. * 16384.,
    (double)202549./3137161264. * 16384.,
    (double)167379./3137161264. * 16384.,
    (double)347789./3137161264. * 16384.,
    (double)241635./3137161264. * 16384.,
    (double)172299./3137161264. * 16384.,
    (double)166049./3137161264. * 16384.,
    (double)282741./3137161264. * 16384.,
    (double)222770./3137161264. * 16384.,
    (double)18885./3137161264. * 16384.,
    (double)127364./3137161264. * 16384.,
    (double)219031./3137161264. * 16384.,
    (double)319818./3137161264. * 16384.,
    (double)201364./3137161264. * 16384.,
    (double)227628./3137161264. * 16384.,
    (double)494460./3137161264. * 16384.,
    (double)609490./3137161264. * 16384.,
    (double)386912./3137161264. * 16384.,
    (double)238177./3137161264. * 16384.,
    (double)432657./3137161264. * 16384.,
    (double)402291./3137161264. * 16384.,
    (double)360418./3137161264. * 16384.,
    (double)247693./3137161264. * 16384.,
    (double)296264./3137161264. * 16384.,
    (double)302797./3137161264. * 16384.,
    (double)33757./3137161264. * 16384.,
    (double)172889./3137161264. * 16384.,
    (double)261645./3137161264. * 16384.,
    (double)278884./3137161264. * 16384.,
    (double)280739./3137161264. * 16384.,
    (double)162814./3137161264. * 16384.,
    (double)334212./3137161264. * 16384.,
    (double)407013./3137161264. * 16384.,
    (double)311808./3137161264. * 16384.,
    (double)171048./3137161264. * 16384.,
    (double)255806./3137161264. * 16384.,
    (double)330022./3137161264. * 16384.,
    (double)289366./3137161264. * 16384.,
    (double)220781./3137161264. * 16384.,
    (double)250463./3137161264. * 16384.,
    (double)267367./3137161264. * 16384.,
    (double)31162./3137161264. * 16384.,
    (double)200741./3137161264. * 16384.,
    (double)277232./3137161264. * 16384.,
    (double)187769./3137161264. * 16384.,
    (double)212060./3137161264. * 16384.,
    (double)144198./3137161264. * 16384.,
    (double)225605./3137161264. * 16384.,
    (double)324453./3137161264. * 16384.,
    (double)384237./3137161264. * 16384.,
    (double)282624./3137161264. * 16384.,
    (double)306775./3137161264. * 16384.,
    (double)29466./3137161264. * 16384.,
    (double)39743./3137161264. * 16384.,
    (double)62894./3137161264. * 16384.,
    (double)39886./3137161264. * 16384.,
    (double)281047./3137161264. * 16384.,
    (double)36271./3137161264. * 16384.,
    (double)222215./3137161264. * 16384.,
    (double)310547./3137161264. * 16384.,
    (double)221398./3137161264. * 16384.,
    (double)337043./3137161264. * 16384.,
    (double)228696./3137161264. * 16384.,
    (double)337098./3137161264. * 16384.,
    (double)342808./3137161264. * 16384.,
    (double)231084./3137161264. * 16384.,
    (double)195648./3137161264. * 16384.,
    (double)334057./3137161264. * 16384.,
    (double)351326./3137161264. * 16384.,
    (double)330379./3137161264. * 16384.,
    (double)297824./3137161264. * 16384.,
    (double)371854./3137161264. * 16384.,
    (double)289798./3137161264. * 16384.,
    (double)26688./3137161264. * 16384.,
    (double)204683./3137161264. * 16384.,
    (double)314681./3137161264. * 16384.,
    (double)274602./3137161264. * 16384.,
    (double)254325./3137161264. * 16384.,
    (double)240263./3137161264. * 16384.,
    (double)447973./3137161264. * 16384.,
    (double)418188./3137161264. * 16384.,
    (double)262791./3137161264. * 16384.,
    (double)194748./3137161264. * 16384.,
    (double)266041./3137161264. * 16384.,
    (double)350016./3137161264. * 16384.,
    (double)298406./3137161264. * 16384.,
    (double)260274./3137161264. * 16384.,
    (double)292694./3137161264. * 16384.,
    (double)320082./3137161264. * 16384.,
    (double)43842./3137161264. * 16384.,
    (double)199034./3137161264. * 16384.,
    (double)296596./3137161264. * 16384.,
    (double)238187./3137161264. * 16384.,
    (double)240489./3137161264. * 16384.,
    (double)212377./3137161264. * 16384.,
    (double)370665./3137161264. * 16384.,
    (double)34449./3137161264. * 16384.,
    (double)34625./3137161264. * 16384.,
    (double)17942./3137161264. * 16384.,
    (double)26374./3137161264. * 16384.,
    (double)33812./3137161264. * 16384.,
    (double)52096./3137161264. * 16384.,
    (double)33465./3137161264. * 16384.,
    (double)31685./3137161264. * 16384.,
    (double)25632./3137161264. * 16384.,
    (double)6927./3137161264. * 16384.,
    (double)28942./3137161264. * 16384.,
    (double)33638./3137161264. * 16384.,
    (double)23371./3137161264. * 16384.,
    (double)35303./3137161264. * 16384.,
    (double)23035./3137161264. * 16384.,
    (double)31794./3137161264. * 16384.,
    (double)274784./3137161264. * 16384.,
    (double)376471./3137161264. * 16384.,
    (double)207921./3137161264. * 16384.,
    (double)284711./3137161264. * 16384.,
    (double)27857./3137161264. * 16384.,
    (double)35593./3137161264. * 16384.,
    (double)27726./3137161264. * 16384.,
    (double)49144./3137161264. * 16384.,
    (double)290969./3137161264. * 16384.,
    (double)42727./3137161264. * 16384.,
    (double)189446./3137161264. * 16384.,
    (double)257766./3137161264. * 16384.,
    (double)202720./3137161264. * 16384.,
    (double)338670./3137161264. * 16384.,
    (double)232161./3137161264. * 16384.,
    (double)281748./3137161264. * 16384.,
    (double)256097./3137161264. * 16384.,
    (double)192202./3137161264. * 16384.,
    (double)163387./3137161264. * 16384.,
    (double)235792./3137161264. * 16384.,
    (double)324841./3137161264. * 16384.,
    (double)293075./3137161264. * 16384.,
    (double)270976./3137161264. * 16384.,
    (double)377412./3137161264. * 16384.,
    (double)297352./3137161264. * 16384.,
    (double)29686./3137161264. * 16384.,
    (double)248092./3137161264. * 16384.,
    (double)331267./3137161264. * 16384.,
    (double)260661./3137161264. * 16384.,
    (double)253951./3137161264. * 16384.,
    (double)301695./3137161264. * 16384.,
    (double)410419./3137161264. * 16384.,
    (double)529059./3137161264. * 16384.,
    (double)239581./3137161264. * 16384.,
    (double)211646./3137161264. * 16384.,
    (double)364895./3137161264. * 16384.,
    (double)266085./3137161264. * 16384.,
    (double)185598./3137161264. * 16384.,
    (double)167102./3137161264. * 16384.,
    (double)200813./3137161264. * 16384.,
    (double)308428./3137161264. * 16384.,
    (double)40209./3137161264. * 16384.,
    (double)164899./3137161264. * 16384.,
    (double)280482./3137161264. * 16384.,
    (double)282802./3137161264. * 16384.,
    (double)202890./3137161264. * 16384.,
    (double)173967./3137161264. * 16384.,
    (double)417563./3137161264. * 16384.,
    (double)386600./3137161264. * 16384.,
    (double)281768./3137161264. * 16384.,
    (double)167281./3137161264. * 16384.,
    (double)252677./3137161264. * 16384.,
    (double)292423./3137161264. * 16384.,
    (double)257629./3137161264. * 16384.,
    (double)206053./3137161264. * 16384.,
    (double)224334./3137161264. * 16384.,
    (double)242137./3137161264. * 16384.,
    (double)23009./3137161264. * 16384.,
    (double)202591./3137161264. * 16384.,
    (double)286566./3137161264. * 16384.,
    (double)239995./3137161264. * 16384.,
    (double)224218./3137161264. * 16384.,
    (double)187900./3137161264. * 16384.,
    (double)307563./3137161264. * 16384.,
    (double)353473./3137161264. * 16384.,
    (double)362892./3137161264. * 16384.,
    (double)244898./3137161264. * 16384.,
    (double)374585./3137161264. * 16384.,
    (double)31904./3137161264. * 16384.,
    (double)37470./3137161264. * 16384.,
    (double)23365./3137161264. * 16384.,
    (double)42320./3137161264. * 16384.,
    (double)347949./3137161264. * 16384.,
    (double)38015./3137161264. * 16384.,
    (double)278463./3137161264. * 16384.,
    (double)406645./3137161264. * 16384.,
    (double)313020./3137161264. * 16384.,
    (double)393479./3137161264. * 16384.,
    (double)335313./3137161264. * 16384.,
    (double)433021./3137161264. * 16384.,
    (double)496831./3137161264. * 16384.,
    (double)264183./3137161264. * 16384.,
    (double)240118./3137161264. * 16384.,
    (double)482272./3137161264. * 16384.,
    (double)384468./3137161264. * 16384.,
    (double)374622./3137161264. * 16384.,
    (double)266022./3137161264. * 16384.,
    (double)398338./3137161264. * 16384.,
    (double)427322./3137161264. * 16384.,
    (double)33539./3137161264. * 16384.,
    (double)333711./3137161264. * 16384.,
    (double)537239./3137161264. * 16384.,
    (double)574815./3137161264. * 16384.,
    (double)414027./3137161264. * 16384.,
    (double)473559./3137161264. * 16384.,
    (double)785014./3137161264. * 16384.,
    (double)1540293./3137161264. * 16384.,
    (double)727220./3137161264. * 16384.,
    (double)642395./3137161264. * 16384.,
    (double)1395842./3137161264. * 16384.,
    (double)694773./3137161264. * 16384.,
    (double)383653./3137161264. * 16384.,
    (double)342087./3137161264. * 16384.,
    (double)498522./3137161264. * 16384.,
    (double)697941./3137161264. * 16384.,
    (double)60638./3137161264. * 16384.,
    (double)268288./3137161264. * 16384.,
    (double)479600./3137161264. * 16384.,
    (double)1229211./3137161264. * 16384.,
    (double)777447./3137161264. * 16384.,
    (double)408234./3137161264. * 16384.,
    (double)884567./3137161264. * 16384.,
    (double)601634./3137161264. * 16384.,
    (double)296827./3137161264. * 16384.,
    (double)225166./3137161264. * 16384.,
    (double)349205./3137161264. * 16384.,
    (double)346307./3137161264. * 16384.,
    (double)188735./3137161264. * 16384.,
    (double)171012./3137161264. * 16384.,
    (double)212888./3137161264. * 16384.,
    (double)358440./3137161264. * 16384.,
    (double)25442./3137161264. * 16384.,
    (double)194260./3137161264. * 16384.,
    (double)233028./3137161264. * 16384.,
    (double)338437./3137161264. * 16384.,
    (double)275429./3137161264. * 16384.,
    (double)167095./3137161264. * 16384.,
    (double)306487./3137161264. * 16384.,
    (double)498397./3137161264. * 16384.,
    (double)319779./3137161264. * 16384.,
    (double)240420./3137161264. * 16384.,
    (double)438093./3137161264. * 16384.,
    (double)41188./3137161264. * 16384.,
    (double)26594./3137161264. * 16384.,
    (double)21752./3137161264. * 16384.,
    (double)49726./3137161264. * 16384.,
    (double)279028./3137161264. * 16384.,
    (double)21797./3137161264. * 16384.,
    (double)146789./3137161264. * 16384.,
    (double)233481./3137161264. * 16384.,
    (double)302468./3137161264. * 16384.,
    (double)290397./3137161264. * 16384.,
    (double)203995./3137161264. * 16384.,
    (double)392861./3137161264. * 16384.,
    (double)967104./3137161264. * 16384.,
    (double)386998./3137161264. * 16384.,
    (double)344558./3137161264. * 16384.,
    (double)723657./3137161264. * 16384.,
    (double)506416./3137161264. * 16384.,
    (double)304592./3137161264. * 16384.,
    (double)265300./3137161264. * 16384.,
    (double)460009./3137161264. * 16384.,
    (double)420943./3137161264. * 16384.,
    (double)31503./3137161264. * 16384.,
    (double)240189./3137161264. * 16384.,
    (double)388288./3137161264. * 16384.,
    (double)674510./3137161264. * 16384.,
    (double)389257./3137161264. * 16384.,
    (double)404570./3137161264. * 16384.,
    (double)1006255./3137161264. * 16384.,
    (double)753083./3137161264. * 16384.,
    (double)344077./3137161264. * 16384.,
    (double)234747./3137161264. * 16384.,
    (double)450911./3137161264. * 16384.,
    (double)385547./3137161264. * 16384.,
    (double)212193./3137161264. * 16384.,
    (double)165739./3137161264. * 16384.,
    (double)234644./3137161264. * 16384.,
    (double)321355./3137161264. * 16384.,
    (double)30678./3137161264. * 16384.,
    (double)129167./3137161264. * 16384.,
    (double)220083./3137161264. * 16384.,
    (double)397499./3137161264. * 16384.,
    (double)311504./3137161264. * 16384.,
    (double)152715./3137161264. * 16384.,
    (double)353568./3137161264. * 16384.,
    (double)386248./3137161264. * 16384.,
    (double)217986./3137161264. * 16384.,
    (double)134082./3137161264. * 16384.,
    (double)220689./3137161264. * 16384.,
    (double)212502./3137161264. * 16384.,
    (double)113184./3137161264. * 16384.,
    (double)108188./3137161264. * 16384.,
    (double)149182./3137161264. * 16384.,
    (double)250636./3137161264. * 16384.,
    (double)27204./3137161264. * 16384.,
    (double)118209./3137161264. * 16384.,
    (double)170270./3137161264. * 16384.,
    (double)220020./3137161264. * 16384.,
    (double)184596./3137161264. * 16384.,
    (double)108603./3137161264. * 16384.,
    (double)195774./3137161264. * 16384.,
    (double)351211./3137161264. * 16384.,
    (double)264085./3137161264. * 16384.,
    (double)187822./3137161264. * 16384.,
    (double)290944./3137161264. * 16384.,
    (double)28223./3137161264. * 16384.,
    (double)19070./3137161264. * 16384.,
    (double)15631./3137161264. * 16384.,
    (double)26046./3137161264. * 16384.,
    (double)255127./3137161264. * 16384.,
    (double)20449./3137161264. * 16384.,
    (double)118228./3137161264. * 16384.,
    (double)185048./3137161264. * 16384.,
    (double)236683./3137161264. * 16384.,
    (double)236229./3137161264. * 16384.,
    (double)163366./3137161264. * 16384.,
    (double)262685./3137161264. * 16384.,
    (double)359374./3137161264. * 16384.,
    (double)196635./3137161264. * 16384.,
    (double)156734./3137161264. * 16384.,
    (double)306233./3137161264. * 16384.,
    (double)276388./3137161264. * 16384.,
    (double)184294./3137161264. * 16384.,
    (double)142053./3137161264. * 16384.,
    (double)222982./3137161264. * 16384.,
    (double)245390./3137161264. * 16384.,
    (double)16253./3137161264. * 16384.,
    (double)126460./3137161264. * 16384.,
    (double)218713./3137161264. * 16384.,
    (double)279173./3137161264. * 16384.,
    (double)209349./3137161264. * 16384.,
    (double)193653./3137161264. * 16384.,
    (double)461945./3137161264. * 16384.,
    (double)690803./3137161264. * 16384.,
    (double)265884./3137161264. * 16384.,
    (double)222872./3137161264. * 16384.,
    (double)427634./3137161264. * 16384.,
    (double)420640./3137161264. * 16384.,
    (double)229002./3137161264. * 16384.,
    (double)210310./3137161264. * 16384.,
    (double)331925./3137161264. * 16384.,
    (double)530028./3137161264. * 16384.,
    (double)49289./3137161264. * 16384.,
    (double)155294./3137161264. * 16384.,
    (double)257846./3137161264. * 16384.,
    (double)587968./3137161264. * 16384.,
    (double)372507./3137161264. * 16384.,
    (double)217315./3137161264. * 16384.,
    (double)557338./3137161264. * 16384.,
    (double)49538./3137161264. * 16384.,
    (double)27006./3137161264. * 16384.,
    (double)19865./3137161264. * 16384.,
    (double)38819./3137161264. * 16384.,
    (double)35515./3137161264. * 16384.,
    (double)23906./3137161264. * 16384.,
    (double)20974./3137161264. * 16384.,
    (double)33532./3137161264. * 16384.,
    (double)38853./3137161264. * 16384.,
    (double)3982./3137161264. * 16384.,
    (double)18155./3137161264. * 16384.,
    (double)28450./3137161264. * 16384.,
    (double)64792./3137161264. * 16384.,
    (double)57201./3137161264. * 16384.,
    (double)24987./3137161264. * 16384.,
    (double)57039./3137161264. * 16384.,
    (double)276629./3137161264. * 16384.,
    (double)204540./3137161264. * 16384.,
    (double)196052./3137161264. * 16384.,
    (double)273652./3137161264. * 16384.,
    (double)23707./3137161264. * 16384.,
    (double)15582./3137161264. * 16384.,
    (double)15724./3137161264. * 16384.,
    (double)29413./3137161264. * 16384.,
    (double)225617./3137161264. * 16384.,
    (double)20707./3137161264. * 16384.,
    (double)106558./3137161264. * 16384.,
    (double)164100./3137161264. * 16384.,
    (double)224263./3137161264. * 16384.,
    (double)224014./3137161264. * 16384.,
    (double)161711./3137161264. * 16384.,
    (double)247436./3137161264. * 16384.,
    (double)293285./3137161264. * 16384.,
    (double)160957./3137161264. * 16384.,
    (double)171778./3137161264. * 16384.,
    (double)310286./3137161264. * 16384.,
    (double)296539./3137161264. * 16384.,
    (double)190815./3137161264. * 16384.,
    (double)178641./3137161264. * 16384.,
    (double)299583./3137161264. * 16384.,
    (double)257161./3137161264. * 16384.,
    (double)20939./3137161264. * 16384.,
    (double)146140./3137161264. * 16384.,
    (double)243427./3137161264. * 16384.,
    (double)326288./3137161264. * 16384.,
    (double)246149./3137161264. * 16384.,
    (double)245063./3137161264. * 16384.,
    (double)490900./3137161264. * 16384.,
    (double)986884./3137161264. * 16384.,
    (double)339921./3137161264. * 16384.,
    (double)301401./3137161264. * 16384.,
    (double)712093./3137161264. * 16384.,
    (double)390547./3137161264. * 16384.,
    (double)202756./3137161264. * 16384.,
    (double)194584./3137161264. * 16384.,
    (double)328178./3137161264. * 16384.,
    (double)611658./3137161264. * 16384.,
    (double)50290./3137161264. * 16384.,
    (double)222753./3137161264. * 16384.,
    (double)366867./3137161264. * 16384.,
    (double)1275399./3137161264. * 16384.,
    (double)584420./3137161264. * 16384.,
    (double)353859./3137161264. * 16384.,
    (double)968540./3137161264. * 16384.,
    (double)544944./3137161264. * 16384.,
    (double)274513./3137161264. * 16384.,
    (double)229033./3137161264. * 16384.,
    (double)370922./3137161264. * 16384.,
    (double)318845./3137161264. * 16384.,
    (double)193723./3137161264. * 16384.,
    (double)189700./3137161264. * 16384.,
    (double)264235./3137161264. * 16384.,
    (double)398744./3137161264. * 16384.,
    (double)27116./3137161264. * 16384.,
    (double)196994./3137161264. * 16384.,
    (double)300405./3137161264. * 16384.,
    (double)557779./3137161264. * 16384.,
    (double)413348./3137161264. * 16384.,
    (double)242098./3137161264. * 16384.,
    (double)488672./3137161264. * 16384.,
    (double)388602./3137161264. * 16384.,
    (double)281611./3137161264. * 16384.,
    (double)258670./3137161264. * 16384.,
    (double)383913./3137161264. * 16384.,
    (double)29613./3137161264. * 16384.,
    (double)19448./3137161264. * 16384.,
    (double)20319./3137161264. * 16384.,
    (double)33806./3137161264. * 16384.,
    (double)326003./3137161264. * 16384.,
    (double)22101./3137161264. * 16384.,
    (double)180926./3137161264. * 16384.,
    (double)284456./3137161264. * 16384.,
    (double)351699./3137161264. * 16384.,
    (double)342949./3137161264. * 16384.,
    (double)262395./3137161264. * 16384.,
    (double)430407./3137161264. * 16384.,
    (double)709705./3137161264. * 16384.,
    (double)334526./3137161264. * 16384.,
    (double)314448./3137161264. * 16384.,
    (double)683873./3137161264. * 16384.,
    (double)399830./3137161264. * 16384.,
    (double)260094./3137161264. * 16384.,
    (double)243485./3137161264. * 16384.,
    (double)411100./3137161264. * 16384.,
    (double)539262./3137161264. * 16384.,
    (double)35108./3137161264. * 16384.,
    (double)315308./3137161264. * 16384.,
    (double)557316./3137161264. * 16384.,
    (double)993997./3137161264. * 16384.,
    (double)675827./3137161264. * 16384.,
    (double)624569./3137161264. * 16384.,
    (double)1485063./3137161264. * 16384.,
    (double)986392./3137161264. * 16384.,
    (double)510652./3137161264. * 16384.,
    (double)377126./3137161264. * 16384.,
    (double)733870./3137161264. * 16384.,
    (double)546902./3137161264. * 16384.,
    (double)343048./3137161264. * 16384.,
    (double)271856./3137161264. * 16384.,
    (double)367421./3137161264. * 16384.,
    (double)438839./3137161264. * 16384.,
    (double)44861./3137161264. * 16384.,
    (double)183816./3137161264. * 16384.,
    (double)313977./3137161264. * 16384.,
    (double)551334./3137161264. * 16384.,
    (double)512345./3137161264. * 16384.,
    (double)249703./3137161264. * 16384.,
    (double)521356./3137161264. * 16384.,
    (double)599249./3137161264. * 16384.,
    (double)338640./3137161264. * 16384.,
    (double)241662./3137161264. * 16384.,
    (double)394253./3137161264. * 16384.,
    (double)406641./3137161264. * 16384.,
    (double)259282./3137161264. * 16384.,
    (double)233259./3137161264. * 16384.,
    (double)269923./3137161264. * 16384.,
    (double)300204./3137161264. * 16384.,
    (double)31218./3137161264. * 16384.,
    (double)250631./3137161264. * 16384.,
    (double)265343./3137161264. * 16384.,
    (double)255196./3137161264. * 16384.,
    (double)267053./3137161264. * 16384.,
    (double)185701./3137161264. * 16384.,
    (double)323320./3137161264. * 16384.,
    (double)381454./3137161264. * 16384.,
    (double)340618./3137161264. * 16384.,
    (double)224627./3137161264. * 16384.,
    (double)365076./3137161264. * 16384.,
    (double)37614./3137161264. * 16384.,
    (double)33703./3137161264. * 16384.,
    (double)23400./3137161264. * 16384.,
    (double)42190./3137161264. * 16384.,
    (double)241729./3137161264. * 16384.,
    (double)26041./3137161264. * 16384.,
    (double)158440./3137161264. * 16384.,
    (double)249132./3137161264. * 16384.,
    (double)233921./3137161264. * 16384.,
    (double)287352./3137161264. * 16384.,
    (double)201643./3137161264. * 16384.,
    (double)355892./3137161264. * 16384.,
    (double)423193./3137161264. * 16384.,
    (double)234719./3137161264. * 16384.,
    (double)204000./3137161264. * 16384.,
    (double)376774./3137161264. * 16384.,
    (double)391933./3137161264. * 16384.,
    (double)292549./3137161264. * 16384.,
    (double)214878./3137161264. * 16384.,
    (double)329079./3137161264. * 16384.,
    (double)283935./3137161264. * 16384.,
    (double)27050./3137161264. * 16384.,
    (double)171426./3137161264. * 16384.,
    (double)281811./3137161264. * 16384.,
    (double)350213./3137161264. * 16384.,
    (double)246481./3137161264. * 16384.,
    (double)269488./3137161264. * 16384.,
    (double)558636./3137161264. * 16384.,
    (double)678871./3137161264. * 16384.,
    (double)395038./3137161264. * 16384.,
    (double)230831./3137161264. * 16384.,
    (double)439752./3137161264. * 16384.,
    (double)443421./3137161264. * 16384.,
    (double)321379./3137161264. * 16384.,
    (double)217358./3137161264. * 16384.,
    (double)277406./3137161264. * 16384.,
    (double)297169./3137161264. * 16384.,
    (double)33988./3137161264. * 16384.,
    (double)125191./3137161264. * 16384.,
    (double)225167./3137161264. * 16384.,
    (double)309569./3137161264. * 16384.,
    (double)326346./3137161264. * 16384.,
    (double)150009./3137161264. * 16384.,
    (double)322495./3137161264. * 16384.,
    (double)432574./3137161264. * 16384.,
    (double)323149./3137161264. * 16384.,
    (double)171721./3137161264. * 16384.,
    (double)264970./3137161264. * 16384.,
    (double)340676./3137161264. * 16384.,
    (double)224506./3137161264. * 16384.,
    (double)190068./3137161264. * 16384.,
    (double)231495./3137161264. * 16384.,
    (double)269382./3137161264. * 16384.,
    (double)32819./3137161264. * 16384.,
    (double)153319./3137161264. * 16384.,
    (double)221836./3137161264. * 16384.,
    (double)197241./3137161264. * 16384.,
    (double)228113./3137161264. * 16384.,
    (double)136705./3137161264. * 16384.,
    (double)221212./3137161264. * 16384.,
    (double)326876./3137161264. * 16384.,
    (double)351471./3137161264. * 16384.,
    (double)198988./3137161264. * 16384.,
    (double)293328./3137161264. * 16384.,
    (double)40162./3137161264. * 16384.,
    (double)45179./3137161264. * 16384.,
    (double)29767./3137161264. * 16384.,
    (double)38002./3137161264. * 16384.,
    (double)283097./3137161264. * 16384.,
    (double)36356./3137161264. * 16384.,
    (double)162924./3137161264. * 16384.,
    (double)238272./3137161264. * 16384.,
    (double)221936./3137161264. * 16384.,
    (double)316580./3137161264. * 16384.,
    (double)198889./3137161264. * 16384.,
    (double)321759./3137161264. * 16384.,
    (double)291829./3137161264. * 16384.,
    (double)210594./3137161264. * 16384.,
    (double)145817./3137161264. * 16384.,
    (double)258711./3137161264. * 16384.,
    (double)325770./3137161264. * 16384.,
    (double)333591./3137161264. * 16384.,
    (double)187146./3137161264. * 16384.,
    (double)245367./3137161264. * 16384.,
    (double)221697./3137161264. * 16384.,
    (double)19477./3137161264. * 16384.,
    (double)127719./3137161264. * 16384.,
    (double)222458./3137161264. * 16384.,
    (double)232101./3137161264. * 16384.,
    (double)203276./3137161264. * 16384.,
    (double)179603./3137161264. * 16384.,
    (double)390159./3137161264. * 16384.,
    (double)535971./3137161264. * 16384.,
    (double)254419./3137161264. * 16384.,
    (double)180286./3137161264. * 16384.,
    (double)320776./3137161264. * 16384.,
    (double)382806./3137161264. * 16384.,
    (double)263401./3137161264. * 16384.,
    (double)237500./3137161264. * 16384.,
    (double)293096./3137161264. * 16384.,
    (double)362235./3137161264. * 16384.,
    (double)46849./3137161264. * 16384.,
    (double)154276./3137161264. * 16384.,
    (double)210614./3137161264. * 16384.,
    (double)337345./3137161264. * 16384.,
    (double)313346./3137161264. * 16384.,
    (double)193681./3137161264. * 16384.,
    (double)402347./3137161264. * 16384.,
    (double)28539./3137161264. * 16384.,
    (double)25566./3137161264. * 16384.,
    (double)15708./3137161264. * 16384.,
    (double)27995./3137161264. * 16384.,
    (double)29435./3137161264. * 16384.,
    (double)32124./3137161264. * 16384.,
    (double)25762./3137161264. * 16384.,
    (double)29347./3137161264. * 16384.,
    (double)27758./3137161264. * 16384.,
    (double)7215./3137161264. * 16384.,
    (double)24741./3137161264. * 16384.,
    (double)25545./3137161264. * 16384.,
    (double)29994./3137161264. * 16384.,
    (double)46733./3137161264. * 16384.,
    (double)22072./3137161264. * 16384.,
    (double)33445./3137161264. * 16384.,
    (double)292939./3137161264. * 16384.,
    (double)295635./3137161264. * 16384.,
    (double)226552./3137161264. * 16384.,
    (double)284575./3137161264. * 16384.,
    (double)28269./3137161264. * 16384.,
    (double)29705./3137161264. * 16384.,
    (double)24452./3137161264. * 16384.,
    (double)33049./3137161264. * 16384.,
    (double)279728./3137161264. * 16384.,
    (double)41285./3137161264. * 16384.,
    (double)156794./3137161264. * 16384.,
    (double)221749./3137161264. * 16384.,
    (double)207302./3137161264. * 16384.,
    (double)331322./3137161264. * 16384.,
    (double)210745./3137161264. * 16384.,
    (double)298367./3137161264. * 16384.,
    (double)292581./3137161264. * 16384.,
    (double)167339./3137161264. * 16384.,
    (double)167734./3137161264. * 16384.,
    (double)279267./3137161264. * 16384.,
    (double)334193./3137161264. * 16384.,
    (double)298174./3137161264. * 16384.,
    (double)254919./3137161264. * 16384.,
    (double)329781./3137161264. * 16384.,
    (double)287518./3137161264. * 16384.,
    (double)25715./3137161264. * 16384.,
    (double)180006./3137161264. * 16384.,
    (double)271555./3137161264. * 16384.,
    (double)278980./3137161264. * 16384.,
    (double)236199./3137161264. * 16384.,
    (double)259058./3137161264. * 16384.,
    (double)460769./3137161264. * 16384.,
    (double)609117./3137161264. * 16384.,
    (double)291147./3137161264. * 16384.,
    (double)234924./3137161264. * 16384.,
    (double)438408./3137161264. * 16384.,
    (double)296952./3137161264. * 16384.,
    (double)190403./3137161264. * 16384.,
    (double)171043./3137161264. * 16384.,
    (double)234351./3137161264. * 16384.,
    (double)346024./3137161264. * 16384.,
    (double)31441./3137161264. * 16384.,
    (double)164756./3137161264. * 16384.,
    (double)242576./3137161264. * 16384.,
    (double)499867./3137161264. * 16384.,
    (double)343090./3137161264. * 16384.,
    (double)239155./3137161264. * 16384.,
    (double)553542./3137161264. * 16384.,
    (double)464095./3137161264. * 16384.,
    (double)313295./3137161264. * 16384.,
    (double)246850./3137161264. * 16384.,
    (double)359224./3137161264. * 16384.,
    (double)341435./3137161264. * 16384.,
    (double)275374./3137161264. * 16384.,
    (double)254917./3137161264. * 16384.,
    (double)293778./3137161264. * 16384.,
    (double)327963./3137161264. * 16384.,
    (double)34119./3137161264. * 16384.,
    (double)229939./3137161264. * 16384.,
    (double)302925./3137161264. * 16384.,
    (double)372612./3137161264. * 16384.,
    (double)446759./3137161264. * 16384.,
    (double)256918./3137161264. * 16384.,
    (double)423659./3137161264. * 16384.,
    (double)314543./3137161264. * 16384.,
    (double)292941./3137161264. * 16384.,
    (double)243351./3137161264. * 16384.,
    (double)349951./3137161264. * 16384.,
    (double)25675./3137161264. * 16384.,
    (double)24508./3137161264. * 16384.,
    (double)18648./3137161264. * 16384.,
    (double)30121./3137161264. * 16384.,
    (double)268996./3137161264. * 16384.,
    (double)24284./3137161264. * 16384.,
    (double)190010./3137161264. * 16384.,
    (double)284492./3137161264. * 16384.,
    (double)265693./3137161264. * 16384.,
    (double)320907./3137161264. * 16384.,
    (double)252862./3137161264. * 16384.,
    (double)408096./3137161264. * 16384.,
    (double)458785./3137161264. * 16384.,
    (double)246596./3137161264. * 16384.,
    (double)226115./3137161264. * 16384.,
    (double)400728./3137161264. * 16384.,
    (double)350915./3137161264. * 16384.,
    (double)274465./3137161264. * 16384.,
    (double)224015./3137161264. * 16384.,
    (double)305768./3137161264. * 16384.,
    (double)373956./3137161264. * 16384.,
    (double)27731./3137161264. * 16384.,
    (double)242343./3137161264. * 16384.,
    (double)410672./3137161264. * 16384.,
    (double)536377./3137161264. * 16384.,
    (double)411641./3137161264. * 16384.,
    (double)401777./3137161264. * 16384.,
    (double)788824./3137161264. * 16384.,
    (double)594901./3137161264. * 16384.,
    (double)342749./3137161264. * 16384.,
    (double)236847./3137161264. * 16384.,
    (double)457540./3137161264. * 16384.,
    (double)313673./3137161264. * 16384.,
    (double)224931./3137161264. * 16384.,
    (double)153708./3137161264. * 16384.,
    (double)242810./3137161264. * 16384.,
    (double)311535./3137161264. * 16384.,
    (double)28923./3137161264. * 16384.,
    (double)143545./3137161264. * 16384.,
    (double)231009./3137161264. * 16384.,
    (double)357346./3137161264. * 16384.,
    (double)269825./3137161264. * 16384.,
    (double)177952./3137161264. * 16384.,
    (double)334538./3137161264. * 16384.,
    (double)449202./3137161264. * 16384.,
    (double)314952./3137161264. * 16384.,
    (double)177158./3137161264. * 16384.,
    (double)284033./3137161264. * 16384.,
    (double)283729./3137161264. * 16384.,
    (double)205239./3137161264. * 16384.,
    (double)160897./3137161264. * 16384.,
    (double)183688./3137161264. * 16384.,
    (double)295077./3137161264. * 16384.,
    (double)30885./3137161264. * 16384.,
    (double)188554./3137161264. * 16384.,
    (double)242825./3137161264. * 16384.,
    (double)245065./3137161264. * 16384.,
    (double)273945./3137161264. * 16384.,
    (double)165622./3137161264. * 16384.,
    (double)285814./3137161264. * 16384.,
    (double)341784./3137161264. * 16384.,
    (double)353679./3137161264. * 16384.,
    (double)234602./3137161264. * 16384.,
    (double)356825./3137161264. * 16384.,
    (double)42950./3137161264. * 16384.,
    (double)39845./3137161264. * 16384.,
    (double)30312./3137161264. * 16384.,
    (double)52455./3137161264. * 16384.,
    (double)283534./3137161264. * 16384.,
    (double)31290./3137161264. * 16384.,
    (double)169122./3137161264. * 16384.,
    (double)278709./3137161264. * 16384.,
    (double)219848./3137161264. * 16384.,
    (double)315092./3137161264. * 16384.,
    (double)191674./3137161264. * 16384.,
    (double)370753./3137161264. * 16384.,
    (double)339537./3137161264. * 16384.,
    (double)217719./3137161264. * 16384.,
    (double)173552./3137161264. * 16384.,
    (double)353451./3137161264. * 16384.,
    (double)289607./3137161264. * 16384.,
    (double)244779./3137161264. * 16384.,
    (double)181864./3137161264. * 16384.,
    (double)291573./3137161264. * 16384.,
    (double)335455./3137161264. * 16384.,
    (double)31259./3137161264. * 16384.,
    (double)197101./3137161264. * 16384.,
    (double)343065./3137161264. * 16384.,
    (double)353842./3137161264. * 16384.,
    (double)254528./3137161264. * 16384.,
    (double)277774./3137161264. * 16384.,
    (double)611833./3137161264. * 16384.,
    (double)37608./3137161264. * 16384.,
    (double)28375./3137161264. * 16384.,
    (double)16984./3137161264. * 16384.,
    (double)35270./3137161264. * 16384.,
    (double)33289./3137161264. * 16384.,
    (double)29537./3137161264. * 16384.,
    (double)17322./3137161264. * 16384.,
    (double)24708./3137161264. * 16384.,
    (double)24088./3137161264. * 16384.,
    (double)3863./3137161264. * 16384.,
    (double)13906./3137161264. * 16384.,
    (double)20882./3137161264. * 16384.,
    (double)26143./3137161264. * 16384.,
    (double)29414./3137161264. * 16384.,
    (double)18655./3137161264. * 16384.,
    (double)33473./3137161264. * 16384.,
    (double)27635./3137161264. * 16384.,
    (double)24460./3137161264. * 16384.,
    (double)12188./3137161264. * 16384.,
    (double)19237./3137161264. * 16384.,
    (double)26033./3137161264. * 16384.,
    (double)28769./3137161264. * 16384.,
    (double)17373./3137161264. * 16384.,
    (double)18841./3137161264. * 16384.,
    (double)23474./3137161264. * 16384.,
    (double)4630./3137161264. * 16384.,
    (double)20307./3137161264. * 16384.,
    (double)22717./3137161264. * 16384.,
    (double)18327./3137161264. * 16384.,
    (double)23758./3137161264. * 16384.,
    (double)14039./3137161264. * 16384.,
    (double)21819./3137161264. * 16384.,
    (double)24810./3137161264. * 16384.,
    (double)33726./3137161264. * 16384.,
    (double)21489./3137161264. * 16384.,
    (double)27242./3137161264. * 16384.,
    (double)4124./3137161264. * 16384.,
    (double)6743./3137161264. * 16384.,
    (double)7716./3137161264. * 16384.,
    (double)4902./3137161264. * 16384.,
    (double)31988./3137161264. * 16384.,
    (double)6301./3137161264. * 16384.,
    (double)22727./3137161264. * 16384.,
    (double)32327./3137161264. * 16384.,
    (double)21893./3137161264. * 16384.,
    (double)37049./3137161264. * 16384.,
    (double)23482./3137161264. * 16384.,
    (double)57273./3137161264. * 16384.,
    (double)32027./3137161264. * 16384.,
    (double)23027./3137161264. * 16384.,
    (double)16407./3137161264. * 16384.,
    (double)35497./3137161264. * 16384.,
    (double)36439./3137161264. * 16384.,
    (double)40380./3137161264. * 16384.,
    (double)27538./3137161264. * 16384.,
    (double)38035./3137161264. * 16384.,
    (double)30651./3137161264. * 16384.,
    (double)3684./3137161264. * 16384.,
    (double)21457./3137161264. * 16384.,
    (double)33636./3137161264. * 16384.,
    (double)30289./3137161264. * 16384.,
    (double)26504./3137161264. * 16384.,
    (double)25401./3137161264. * 16384.,
    (double)54788./3137161264. * 16384.,
    (double)382679./3137161264. * 16384.,
    (double)234722./3137161264. * 16384.,
    (double)158668./3137161264. * 16384.,
    (double)227342./3137161264. * 16384.,
    (double)293437./3137161264. * 16384.,
    (double)266274./3137161264. * 16384.,
    (double)203578./3137161264. * 16384.,
    (double)233797./3137161264. * 16384.,
    (double)282117./3137161264. * 16384.,
    (double)42685./3137161264. * 16384.,
    (double)186241./3137161264. * 16384.,
    (double)218165./3137161264. * 16384.,
    (double)224143./3137161264. * 16384.,
    (double)250509./3137161264. * 16384.,
    (double)231378./3137161264. * 16384.,
    (double)330809./3137161264. * 16384.,
    (double)26105./3137161264. * 16384.,
    (double)26828./3137161264. * 16384.,
    (double)13168./3137161264. * 16384.,
    (double)19129./3137161264. * 16384.,
    (double)21990./3137161264. * 16384.,
    (double)28116./3137161264. * 16384.,
    (double)19779./3137161264. * 16384.,
    (double)16692./3137161264. * 16384.,
    (double)24359./3137161264. * 16384.,
    (double)5986./3137161264. * 16384.,
    (double)32198./3137161264. * 16384.,
    (double)22565./3137161264. * 16384.,
    (double)23691./3137161264. * 16384.,
    (double)35869./3137161264. * 16384.,
    (double)23400./3137161264. * 16384.,
    (double)28183./3137161264. * 16384.,
    (double)257967./3137161264. * 16384.,
    (double)351314./3137161264. * 16384.,
    (double)199825./3137161264. * 16384.,
    (double)254568./3137161264. * 16384.,
    (double)26912./3137161264. * 16384.,
    (double)35061./3137161264. * 16384.,
    (double)24481./3137161264. * 16384.,
    (double)30001./3137161264. * 16384.,
    (double)288481./3137161264. * 16384.,
    (double)36763./3137161264. * 16384.,
    (double)142145./3137161264. * 16384.,
    (double)195853./3137161264. * 16384.,
    (double)169041./3137161264. * 16384.,
    (double)274157./3137161264. * 16384.,
    (double)199448./3137161264. * 16384.,
    (double)256845./3137161264. * 16384.,
    (double)245340./3137161264. * 16384.,
    (double)176392./3137161264. * 16384.,
    (double)140062./3137161264. * 16384.,
    (double)202947./3137161264. * 16384.,
    (double)271916./3137161264. * 16384.,
    (double)275455./3137161264. * 16384.,
    (double)205205./3137161264. * 16384.,
    (double)254194./3137161264. * 16384.,
    (double)308592./3137161264. * 16384.,
    (double)30873./3137161264. * 16384.,
    (double)258084./3137161264. * 16384.,
    (double)280450./3137161264. * 16384.,
    (double)230546./3137161264. * 16384.,
    (double)240446./3137161264. * 16384.,
    (double)264138./3137161264. * 16384.,
    (double)380081./3137161264. * 16384.,
    (double)390875./3137161264. * 16384.,
    (double)204066./3137161264. * 16384.,
    (double)151940./3137161264. * 16384.,
    (double)290509./3137161264. * 16384.,
    (double)234593./3137161264. * 16384.,
    (double)165088./3137161264. * 16384.,
    (double)121360./3137161264. * 16384.,
    (double)174458./3137161264. * 16384.,
    (double)258218./3137161264. * 16384.,
    (double)24690./3137161264. * 16384.,
    (double)158609./3137161264. * 16384.,
    (double)224828./3137161264. * 16384.,
    (double)313740./3137161264. * 16384.,
    (double)226857./3137161264. * 16384.,
    (double)198021./3137161264. * 16384.,
    (double)358639./3137161264. * 16384.,
    (double)409542./3137161264. * 16384.,
    (double)288915./3137161264. * 16384.,
    (double)188721./3137161264. * 16384.,
    (double)279599./3137161264. * 16384.,
    (double)285097./3137161264. * 16384.,
    (double)264903./3137161264. * 16384.,
    (double)190623./3137161264. * 16384.,
    (double)201752./3137161264. * 16384.,
    (double)317260./3137161264. * 16384.,
    (double)29904./3137161264. * 16384.,
    (double)234735./3137161264. * 16384.,
    (double)287547./3137161264. * 16384.,
    (double)332490./3137161264. * 16384.,
    (double)346229./3137161264. * 16384.,
    (double)236488./3137161264. * 16384.,
    (double)351508./3137161264. * 16384.,
    (double)363851./3137161264. * 16384.,
    (double)361629./3137161264. * 16384.,
    (double)242992./3137161264. * 16384.,
    (double)372151./3137161264. * 16384.,
    (double)31324./3137161264. * 16384.,
    (double)44908./3137161264. * 16384.,
    (double)24227./3137161264. * 16384.,
    (double)34871./3137161264. * 16384.,
    (double)332506./3137161264. * 16384.,
    (double)33001./3137161264. * 16384.,
    (double)238247./3137161264. * 16384.,
    (double)319909./3137161264. * 16384.,
    (double)320021./3137161264. * 16384.,
    (double)383512./3137161264. * 16384.,
    (double)303766./3137161264. * 16384.,
    (double)417181./3137161264. * 16384.,
    (double)352547./3137161264. * 16384.,
    (double)214610./3137161264. * 16384.,
    (double)194221./3137161264. * 16384.,
    (double)311939./3137161264. * 16384.,
    (double)290239./3137161264. * 16384.,
    (double)273381./3137161264. * 16384.,
    (double)193609./3137161264. * 16384.,
    (double)266029./3137161264. * 16384.,
    (double)384746./3137161264. * 16384.,
    (double)30475./3137161264. * 16384.,
    (double)303176./3137161264. * 16384.,
    (double)386286./3137161264. * 16384.,
    (double)424331./3137161264. * 16384.,
    (double)383590./3137161264. * 16384.,
    (double)383724./3137161264. * 16384.,
    (double)623864./3137161264. * 16384.,
    (double)1178598./3137161264. * 16384.,
    (double)432250./3137161264. * 16384.,
    (double)347561./3137161264. * 16384.,
    (double)764792./3137161264. * 16384.,
    (double)402942./3137161264. * 16384.,
    (double)229011./3137161264. * 16384.,
    (double)194931./3137161264. * 16384.,
    (double)336376./3137161264. * 16384.,
    (double)400124./3137161264. * 16384.,
    (double)33407./3137161264. * 16384.,
    (double)181312./3137161264. * 16384.,
    (double)336819./3137161264. * 16384.,
    (double)594983./3137161264. * 16384.,
    (double)368941./3137161264. * 16384.,
    (double)253782./3137161264. * 16384.,
    (double)639946./3137161264. * 16384.,
    (double)483005./3137161264. * 16384.,
    (double)255447./3137161264. * 16384.,
    (double)163442./3137161264. * 16384.,
    (double)284438./3137161264. * 16384.,
    (double)263916./3137161264. * 16384.,
    (double)163985./3137161264. * 16384.,
    (double)137472./3137161264. * 16384.,
    (double)198963./3137161264. * 16384.,
    (double)271807./3137161264. * 16384.,
    (double)22127./3137161264. * 16384.,
    (double)186676./3137161264. * 16384.,
    (double)255156./3137161264. * 16384.,
    (double)247768./3137161264. * 16384.,
    (double)205724./3137161264. * 16384.,
    (double)159767./3137161264. * 16384.,
    (double)299421./3137161264. * 16384.,
    (double)400354./3137161264. * 16384.,
    (double)406114./3137161264. * 16384.,
    (double)201575./3137161264. * 16384.,
    (double)418433./3137161264. * 16384.,
    (double)29842./3137161264. * 16384.,
    (double)29548./3137161264. * 16384.,
    (double)17858./3137161264. * 16384.,
    (double)44472./3137161264. * 16384.,
    (double)252022./3137161264. * 16384.,
    (double)23773./3137161264. * 16384.,
    (double)138467./3137161264. * 16384.,
    (double)253703./3137161264. * 16384.,
    (double)274435./3137161264. * 16384.,
    (double)280301./3137161264. * 16384.,
    (double)189746./3137161264. * 16384.,
    (double)391303./3137161264. * 16384.,
    (double)613260./3137161264. * 16384.,
    (double)316590./3137161264. * 16384.,
    (double)276797./3137161264. * 16384.,
    (double)642852./3137161264. * 16384.,
    (double)358573./3137161264. * 16384.,
    (double)234761./3137161264. * 16384.,
    (double)212742./3137161264. * 16384.,
    (double)410982./3137161264. * 16384.,
    (double)360600./3137161264. * 16384.,
    (double)26546./3137161264. * 16384.,
    (double)225395./3137161264. * 16384.,
    (double)441573./3137161264. * 16384.,
    (double)668412./3137161264. * 16384.,
    (double)375732./3137161264. * 16384.,
    (double)404625./3137161264. * 16384.,
    (double)1113533./3137161264. * 16384.,
    (double)534628./3137161264. * 16384.,
    (double)286120./3137161264. * 16384.,
    (double)198782./3137161264. * 16384.,
    (double)399546./3137161264. * 16384.,
    (double)310652./3137161264. * 16384.,
    (double)216752./3137161264. * 16384.,
    (double)163879./3137161264. * 16384.,
    (double)237727./3137161264. * 16384.,
    (double)252840./3137161264. * 16384.,
    (double)22261./3137161264. * 16384.,
    (double)122955./3137161264. * 16384.,
    (double)231655./3137161264. * 16384.,
    (double)287986./3137161264. * 16384.,
    (double)242327./3137161264. * 16384.,
    (double)159910./3137161264. * 16384.,
    (double)389825./3137161264. * 16384.,
    (double)341634./3137161264. * 16384.,
    (double)216730./3137161264. * 16384.,
    (double)123143./3137161264. * 16384.,
    (double)220145./3137161264. * 16384.,
    (double)222327./3137161264. * 16384.,
    (double)159001./3137161264. * 16384.,
    (double)115494./3137161264. * 16384.,
    (double)168049./3137161264. * 16384.,
    (double)219784./3137161264. * 16384.,
    (double)18712./3137161264. * 16384.,
    (double)144734./3137161264. * 16384.,
    (double)222491./3137161264. * 16384.,
    (double)192370./3137161264. * 16384.,
    (double)188645./3137161264. * 16384.,
    (double)132628./3137161264. * 16384.,
    (double)245681./3137161264. * 16384.,
    (double)287564./3137161264. * 16384.,
    (double)260210./3137161264. * 16384.,
    (double)168040./3137161264. * 16384.,
    (double)291984./3137161264. * 16384.,
    (double)19101./3137161264. * 16384.,
    (double)20803./3137161264. * 16384.,
    (double)15253./3137161264. * 16384.,
    (double)25012./3137161264. * 16384.,
    (double)249210./3137161264. * 16384.,
    (double)22773./3137161264. * 16384.,
    (double)145010./3137161264. * 16384.,
    (double)254457./3137161264. * 16384.,
    (double)246265./3137161264. * 16384.,
    (double)304373./3137161264. * 16384.,
    (double)191045./3137161264. * 16384.,
    (double)391343./3137161264. * 16384.,
    (double)353890./3137161264. * 16384.,
    (double)208204./3137161264. * 16384.,
    (double)182465./3137161264. * 16384.,
    (double)370232./3137161264. * 16384.,
    (double)309799./3137161264. * 16384.,
    (double)234972./3137161264. * 16384.,
    (double)178381./3137161264. * 16384.,
    (double)315864./3137161264. * 16384.,
    (double)273583./3137161264. * 16384.,
    (double)19199./3137161264. * 16384.,
    (double)168781./3137161264. * 16384.,
    (double)302982./3137161264. * 16384.,
    (double)340544./3137161264. * 16384.,
    (double)267962./3137161264. * 16384.,
    (double)255883./3137161264. * 16384.,
    (double)582211./3137161264. * 16384.,
    (double)582166./3137161264. * 16384.,
    (double)317067./3137161264. * 16384.,
    (double)266830./3137161264. * 16384.,
    (double)393076./3137161264. * 16384.,
    (double)407752./3137161264. * 16384.,
    (double)284546./3137161264. * 16384.,
    (double)254953./3137161264. * 16384.,
    (double)379718./3137161264. * 16384.,
    (double)411957./3137161264. * 16384.,
    (double)43716./3137161264. * 16384.,
    (double)204393./3137161264. * 16384.,
    (double)336653./3137161264. * 16384.,
    (double)399981./3137161264. * 16384.,
    (double)333356./3137161264. * 16384.,
    (double)300292./3137161264. * 16384.,
    (double)630360./3137161264. * 16384.,
    (double)35897./3137161264. * 16384.,
    (double)31586./3137161264. * 16384.,
    (double)18451./3137161264. * 16384.,
    (double)31705./3137161264. * 16384.,
    (double)26073./3137161264. * 16384.,
    (double)27425./3137161264. * 16384.,
    (double)21096./3137161264. * 16384.,
    (double)26788./3137161264. * 16384.,
    (double)24799./3137161264. * 16384.,
    (double)3650./3137161264. * 16384.,
    (double)20075./3137161264. * 16384.,
    (double)27532./3137161264. * 16384.,
    (double)33097./3137161264. * 16384.,
    (double)36569./3137161264. * 16384.,
    (double)24048./3137161264. * 16384.,
    (double)46052./3137161264. * 16384.,
    (double)368061./3137161264. * 16384.,
    (double)371675./3137161264. * 16384.,
    (double)250587./3137161264. * 16384.,
    (double)397662./3137161264. * 16384.,
    (double)26224./3137161264. * 16384.,
    (double)26284./3137161264. * 16384.,
    (double)19551./3137161264. * 16384.,
    (double)38246./3137161264. * 16384.,
    (double)349129./3137161264. * 16384.,
    (double)32828./3137161264. * 16384.,
    (double)194982./3137161264. * 16384.,
    (double)299919./3137161264. * 16384.,
    (double)293500./3137161264. * 16384.,
    (double)357206./3137161264. * 16384.,
    (double)284655./3137161264. * 16384.,
    (double)439632./3137161264. * 16384.,
    (double)433219./3137161264. * 16384.,
    (double)289412./3137161264. * 16384.,
    (double)257135./3137161264. * 16384.,
    (double)394580./3137161264. * 16384.,
    (double)434210./3137161264. * 16384.,
    (double)332294./3137161264. * 16384.,
    (double)291749./3137161264. * 16384.,
    (double)457292./3137161264. * 16384.,
    (double)430897./3137161264. * 16384.,
    (double)33780./3137161264. * 16384.,
    (double)323595./3137161264. * 16384.,
    (double)470044./3137161264. * 16384.,
    (double)421304./3137161264. * 16384.,
    (double)336317./3137161264. * 16384.,
    (double)416341./3137161264. * 16384.,
    (double)689389./3137161264. * 16384.,
    (double)1118985./3137161264. * 16384.,
    (double)414509./3137161264. * 16384.,
    (double)347734./3137161264. * 16384.,
    (double)719651./3137161264. * 16384.,
    (double)427690./3137161264. * 16384.,
    (double)277582./3137161264. * 16384.,
    (double)231059./3137161264. * 16384.,
    (double)346399./3137161264. * 16384.,
    (double)515536./3137161264. * 16384.,
    (double)39203./3137161264. * 16384.,
    (double)255822./3137161264. * 16384.,
    (double)461007./3137161264. * 16384.,
    (double)738839./3137161264. * 16384.,
    (double)458447./3137161264. * 16384.,
    (double)401463./3137161264. * 16384.,
    (double)1136663./3137161264. * 16384.,
    (double)635200./3137161264. * 16384.,
    (double)383461./3137161264. * 16384.,
    (double)250078./3137161264. * 16384.,
    (double)418232./3137161264. * 16384.,
    (double)428018./3137161264. * 16384.,
    (double)370479./3137161264. * 16384.,
    (double)241425./3137161264. * 16384.,
    (double)318898./3137161264. * 16384.,
    (double)446103./3137161264. * 16384.,
    (double)29117./3137161264. * 16384.,
    (double)260970./3137161264. * 16384.,
    (double)423096./3137161264. * 16384.,
    (double)482616./3137161264. * 16384.,
    (double)406908./3137161264. * 16384.,
    (double)310416./3137161264. * 16384.,
    (double)632001./3137161264. * 16384.,
    (double)623944./3137161264. * 16384.,
    (double)522530./3137161264. * 16384.,
    (double)382357./3137161264. * 16384.,
    (double)645123./3137161264. * 16384.,
    (double)34026./3137161264. * 16384.,
    (double)32791./3137161264. * 16384.,
    (double)21823./3137161264. * 16384.,
    (double)45050./3137161264. * 16384.,
    (double)531848./3137161264. * 16384.,
    (double)37421./3137161264. * 16384.,
    (double)367029./3137161264. * 16384.,
    (double)595736./3137161264. * 16384.,
    (double)591624./3137161264. * 16384.,
    (double)602237./3137161264. * 16384.,
    (double)539592./3137161264. * 16384.,
    (double)848841./3137161264. * 16384.,
    (double)1230992./3137161264. * 16384.,
    (double)544089./3137161264. * 16384.,
    (double)521065./3137161264. * 16384.,
    (double)1119043./3137161264. * 16384.,
    (double)643756./3137161264. * 16384.,
    (double)482525./3137161264. * 16384.,
    (double)403826./3137161264. * 16384.,
    (double)708262./3137161264. * 16384.,
    (double)795284./3137161264. * 16384.,
    (double)44894./3137161264. * 16384.,
    (double)572140./3137161264. * 16384.,
    (double)1022139./3137161264. * 16384.,
    (double)1323157./3137161264. * 16384.,
    (double)761269./3137161264. * 16384.,
    (double)848363./3137161264. * 16384.,
    (double)1554494./3137161264. * 16384.,
    (double)1312052./3137161264. * 16384.,
    (double)699169./3137161264. * 16384.,
    (double)501591./3137161264. * 16384.,
    (double)911941./3137161264. * 16384.,
    (double)772975./3137161264. * 16384.,
    (double)486915./3137161264. * 16384.,
    (double)359311./3137161264. * 16384.,
    (double)444808./3137161264. * 16384.,
    (double)729149./3137161264. * 16384.,
    (double)77848./3137161264. * 16384.,
    (double)305986./3137161264. * 16384.,
    (double)473649./3137161264. * 16384.,
    (double)875999./3137161264. * 16384.,
    (double)701646./3137161264. * 16384.,
    (double)377839./3137161264. * 16384.,
    (double)631623./3137161264. * 16384.,
    (double)891695./3137161264. * 16384.,
    (double)536199./3137161264. * 16384.,
    (double)300033./3137161264. * 16384.,
    (double)392150./3137161264. * 16384.,
    (double)526623./3137161264. * 16384.,
    (double)354483./3137161264. * 16384.,
    (double)262118./3137161264. * 16384.,
    (double)260323./3137161264. * 16384.,
    (double)445440./3137161264. * 16384.,
    (double)43498./3137161264. * 16384.,
    (double)241674./3137161264. * 16384.,
    (double)300850./3137161264. * 16384.,
    (double)334292./3137161264. * 16384.,
    (double)341339./3137161264. * 16384.,
    (double)226754./3137161264. * 16384.,
    (double)339267./3137161264. * 16384.,
    (double)532063./3137161264. * 16384.,
    (double)451814./3137161264. * 16384.,
    (double)290782./3137161264. * 16384.,
    (double)393636./3137161264. * 16384.,
    (double)50575./3137161264. * 16384.,
    (double)51247./3137161264. * 16384.,
    (double)35711./3137161264. * 16384.,
    (double)58197./3137161264. * 16384.,
    (double)346131./3137161264. * 16384.,
    (double)40917./3137161264. * 16384.,
    (double)202116./3137161264. * 16384.,
    (double)248347./3137161264. * 16384.,
    (double)296413./3137161264. * 16384.,
    (double)409852./3137161264. * 16384.,
    (double)251637./3137161264. * 16384.,
    (double)345155./3137161264. * 16384.,
    (double)788043./3137161264. * 16384.,
    (double)375132./3137161264. * 16384.,
    (double)328552./3137161264. * 16384.,
    (double)578415./3137161264. * 16384.,
    (double)556768./3137161264. * 16384.,
    (double)403007./3137161264. * 16384.,
    (double)325308./3137161264. * 16384.,
    (double)487561./3137161264. * 16384.,
    (double)420105./3137161264. * 16384.,
    (double)40111./3137161264. * 16384.,
    (double)230491./3137161264. * 16384.,
    (double)352250./3137161264. * 16384.,
    (double)504065./3137161264. * 16384.,
    (double)349891./3137161264. * 16384.,
    (double)337729./3137161264. * 16384.,
    (double)566994./3137161264. * 16384.,
    (double)899402./3137161264. * 16384.,
    (double)463092./3137161264. * 16384.,
    (double)252256./3137161264. * 16384.,
    (double)423882./3137161264. * 16384.,
    (double)538102./3137161264. * 16384.,
    (double)412251./3137161264. * 16384.,
    (double)244649./3137161264. * 16384.,
    (double)277329./3137161264. * 16384.,
    (double)425458./3137161264. * 16384.,
    (double)53098./3137161264. * 16384.,
    (double)171045./3137161264. * 16384.,
    (double)256030./3137161264. * 16384.,
    (double)313950./3137161264. * 16384.,
    (double)342949./3137161264. * 16384.,
    (double)161365./3137161264. * 16384.,
    (double)279288./3137161264. * 16384.,
    (double)620613./3137161264. * 16384.,
    (double)438170./3137161264. * 16384.,
    (double)196342./3137161264. * 16384.,
    (double)260442./3137161264. * 16384.,
    (double)397495./3137161264. * 16384.,
    (double)301422./3137161264. * 16384.,
    (double)204314./3137161264. * 16384.,
    (double)194408./3137161264. * 16384.,
    (double)351813./3137161264. * 16384.,
    (double)50008./3137161264. * 16384.,
    (double)192406./3137161264. * 16384.,
    (double)257390./3137161264. * 16384.,
    (double)203736./3137161264. * 16384.,
    (double)277524./3137161264. * 16384.,
    (double)149082./3137161264. * 16384.,
    (double)197104./3137161264. * 16384.,
    (double)348935./3137161264. * 16384.,
    (double)398427./3137161264. * 16384.,
    (double)191533./3137161264. * 16384.,
    (double)246436./3137161264. * 16384.,
    (double)35514./3137161264. * 16384.,
    (double)46574./3137161264. * 16384.,
    (double)28044./3137161264. * 16384.,
    (double)30963./3137161264. * 16384.,
    (double)350106./3137161264. * 16384.,
    (double)51012./3137161264. * 16384.,
    (double)203530./3137161264. * 16384.,
    (double)243452./3137161264. * 16384.,
    (double)187413./3137161264. * 16384.,
    (double)343383./3137161264. * 16384.,
    (double)193346./3137161264. * 16384.,
    (double)243975./3137161264. * 16384.,
    (double)290686./3137161264. * 16384.,
    (double)213004./3137161264. * 16384.,
    (double)134331./3137161264. * 16384.,
    (double)220109./3137161264. * 16384.,
    (double)320256./3137161264. * 16384.,
    (double)284422./3137161264. * 16384.,
    (double)170314./3137161264. * 16384.,
    (double)224671./3137161264. * 16384.,
    (double)307001./3137161264. * 16384.,
    (double)31180./3137161264. * 16384.,
    (double)177997./3137161264. * 16384.,
    (double)242619./3137161264. * 16384.,
    (double)246514./3137161264. * 16384.,
    (double)234656./3137161264. * 16384.,
    (double)203363./3137161264. * 16384.,
    (double)340017./3137161264. * 16384.,
    (double)457717./3137161264. * 16384.,
    (double)249765./3137161264. * 16384.,
    (double)165845./3137161264. * 16384.,
    (double)255641./3137161264. * 16384.,
    (double)361169./3137161264. * 16384.,
    (double)229402./3137161264. * 16384.,
    (double)199677./3137161264. * 16384.,
    (double)216744./3137161264. * 16384.,
    (double)325184./3137161264. * 16384.,
    (double)45899./3137161264. * 16384.,
    (double)141459./3137161264. * 16384.,
    (double)228389./3137161264. * 16384.,
    (double)250949./3137161264. * 16384.,
    (double)246834./3137161264. * 16384.,
    (double)174463./3137161264. * 16384.,
    (double)323327./3137161264. * 16384.,
    (double)40018./3137161264. * 16384.,
    (double)35893./3137161264. * 16384.,
    (double)17761./3137161264. * 16384.,
    (double)24952./3137161264. * 16384.,
    (double)33225./3137161264. * 16384.,
    (double)31552./3137161264. * 16384.,
    (double)23354./3137161264. * 16384.,
    (double)22391./3137161264. * 16384.,
    (double)31730./3137161264. * 16384.,
    (double)8460./3137161264. * 16384.,
    (double)22705./3137161264. * 16384.,
    (double)30649./3137161264. * 16384.,
    (double)29407./3137161264. * 16384.,
    (double)49163./3137161264. * 16384.,
    (double)24237./3137161264. * 16384.,
    (double)37605./3137161264. * 16384.,
    (double)221853./3137161264. * 16384.,
    (double)220710./3137161264. * 16384.,
    (double)174387./3137161264. * 16384.,
    (double)168191./3137161264. * 16384.,
    (double)26320./3137161264. * 16384.,
    (double)25460./3137161264. * 16384.,
    (double)21631./3137161264. * 16384.,
    (double)24094./3137161264. * 16384.,
    (double)224738./3137161264. * 16384.,
    (double)40066./3137161264. * 16384.,
    (double)123456./3137161264. * 16384.,
    (double)153751./3137161264. * 16384.,
    (double)129028./3137161264. * 16384.,
    (double)205796./3137161264. * 16384.,
    (double)142187./3137161264. * 16384.,
    (double)153088./3137161264. * 16384.,
    (double)215113./3137161264. * 16384.,
    (double)147114./3137161264. * 16384.,
    (double)122034./3137161264. * 16384.,
    (double)174577./3137161264. * 16384.,
    (double)270611./3137161264. * 16384.,
    (double)219681./3137161264. * 16384.,
    (double)166248./3137161264. * 16384.,
    (double)217391./3137161264. * 16384.,
    (double)259770./3137161264. * 16384.,
    (double)31608./3137161264. * 16384.,
    (double)182458./3137161264. * 16384.,
    (double)230862./3137161264. * 16384.,
    (double)196216./3137161264. * 16384.,
    (double)216357./3137161264. * 16384.,
    (double)202186./3137161264. * 16384.,
    (double)291180./3137161264. * 16384.,
    (double)633154./3137161264. * 16384.,
    (double)263487./3137161264. * 16384.,
    (double)187153./3137161264. * 16384.,
    (double)389990./3137161264. * 16384.,
    (double)288162./3137161264. * 16384.,
    (double)169500./3137161264. * 16384.,
    (double)151344./3137161264. * 16384.,
    (double)196632./3137161264. * 16384.,
    (double)299357./3137161264. * 16384.,
    (double)29937./3137161264. * 16384.,
    (double)119436./3137161264. * 16384.,
    (double)212039./3137161264. * 16384.,
    (double)383209./3137161264. * 16384.,
    (double)274453./3137161264. * 16384.,
    (double)194719./3137161264. * 16384.,
    (double)447998./3137161264. * 16384.,
    (double)527309./3137161264. * 16384.,
    (double)333591./3137161264. * 16384.,
    (double)199499./3137161264. * 16384.,
    (double)263876./3137161264. * 16384.,
    (double)337394./3137161264. * 16384.,
    (double)242524./3137161264. * 16384.,
    (double)191206./3137161264. * 16384.,
    (double)196438./3137161264. * 16384.,
    (double)282433./3137161264. * 16384.,
    (double)27931./3137161264. * 16384.,
    (double)167289./3137161264. * 16384.,
    (double)238102./3137161264. * 16384.,
    (double)263605./3137161264. * 16384.,
    (double)302609./3137161264. * 16384.,
    (double)190443./3137161264. * 16384.,
    (double)315103./3137161264. * 16384.,
    (double)266981./3137161264. * 16384.,
    (double)247410./3137161264. * 16384.,
    (double)202645./3137161264. * 16384.,
    (double)244619./3137161264. * 16384.,
    (double)26789./3137161264. * 16384.,
    (double)23625./3137161264. * 16384.,
    (double)34383./3137161264. * 16384.,
    (double)27600./3137161264. * 16384.,
    (double)230964./3137161264. * 16384.,
    (double)24589./3137161264. * 16384.,
    (double)146025./3137161264. * 16384.,
    (double)203524./3137161264. * 16384.,
    (double)197147./3137161264. * 16384.,
    (double)262190./3137161264. * 16384.,
    (double)198203./3137161264. * 16384.,
    (double)243984./3137161264. * 16384.,
    (double)378121./3137161264. * 16384.,
    (double)220663./3137161264. * 16384.,
    (double)190292./3137161264. * 16384.,
    (double)347767./3137161264. * 16384.,
    (double)244717./3137161264. * 16384.,
    (double)193888./3137161264. * 16384.,
    (double)180427./3137161264. * 16384.,
    (double)248949./3137161264. * 16384.,
    (double)339697./3137161264. * 16384.,
    (double)30248./3137161264. * 16384.,
    (double)215252./3137161264. * 16384.,
    (double)343899./3137161264. * 16384.,
    (double)386446./3137161264. * 16384.,
    (double)347209./3137161264. * 16384.,
    (double)327194./3137161264. * 16384.,
    (double)578986./3137161264. * 16384.,
    (double)866128./3137161264. * 16384.,
    (double)602314./3137161264. * 16384.,
    (double)353186./3137161264. * 16384.,
    (double)544744./3137161264. * 16384.,
    (double)511382./3137161264. * 16384.,
    (double)441568./3137161264. * 16384.,
    (double)290673./3137161264. * 16384.,
    (double)308226./3137161264. * 16384.,
    (double)360529./3137161264. * 16384.,
    (double)46760./3137161264. * 16384.,
    (double)179168./3137161264. * 16384.,
    (double)263913./3137161264. * 16384.,
    (double)330301./3137161264. * 16384.,
    (double)366488./3137161264. * 16384.,
    (double)219105./3137161264. * 16384.,
    (double)344188./3137161264. * 16384.,
    (double)601873./3137161264. * 16384.,
    (double)667775./3137161264. * 16384.,
    (double)259562./3137161264. * 16384.,
    (double)303927./3137161264. * 16384.,
    (double)429904./3137161264. * 16384.,
    (double)367737./3137161264. * 16384.,
    (double)275504./3137161264. * 16384.,
    (double)248156./3137161264. * 16384.,
    (double)284688./3137161264. * 16384.,
    (double)46305./3137161264. * 16384.,
    (double)193793./3137161264. * 16384.,
    (double)245671./3137161264. * 16384.,
    (double)181757./3137161264. * 16384.,
    (double)256976./3137161264. * 16384.,
    (double)156710./3137161264. * 16384.,
    (double)225999./3137161264. * 16384.,
    (double)305445./3137161264. * 16384.,
    (double)452756./3137161264. * 16384.,
    (double)220965./3137161264. * 16384.,
    (double)244638./3137161264. * 16384.,
    (double)44601./3137161264. * 16384.,
    (double)81852./3137161264. * 16384.,
    (double)36335./3137161264. * 16384.,
    (double)40701./3137161264. * 16384.,
    (double)248503./3137161264. * 16384.,
    (double)38495./3137161264. * 16384.,
    (double)195242./3137161264. * 16384.,
    (double)197451./3137161264. * 16384.,
    (double)164239./3137161264. * 16384.,
    (double)279634./3137161264. * 16384.,
    (double)196422./3137161264. * 16384.,
    (double)235974./3137161264. * 16384.,
    (double)318591./3137161264. * 16384.,
    (double)203382./3137161264. * 16384.,
    (double)160665./3137161264. * 16384.,
    (double)240654./3137161264. * 16384.,
    (double)353749./3137161264. * 16384.,
    (double)361910./3137161264. * 16384.,
    (double)197348./3137161264. * 16384.,
    (double)241152./3137161264. * 16384.,
    (double)228171./3137161264. * 16384.,
    (double)39489./3137161264. * 16384.,
    (double)137720./3137161264. * 16384.,
    (double)194102./3137161264. * 16384.,
    (double)244471./3137161264. * 16384.,
    (double)209616./3137161264. * 16384.,
    (double)193384./3137161264. * 16384.,
    (double)364618./3137161264. * 16384.,
    (double)595961./3137161264. * 16384.,
    (double)515837./3137161264. * 16384.,
    (double)202271./3137161264. * 16384.,
    (double)280947./3137161264. * 16384.,
    (double)427724./3137161264. * 16384.,
    (double)487494./3137161264. * 16384.,
    (double)236399./3137161264. * 16384.,
    (double)212151./3137161264. * 16384.,
    (double)291406./3137161264. * 16384.,
    (double)50683./3137161264. * 16384.,
    (double)137432./3137161264. * 16384.,
    (double)189345./3137161264. * 16384.,
    (double)183077./3137161264. * 16384.,
    (double)280876./3137161264. * 16384.,
    (double)138599./3137161264. * 16384.,
    (double)215466./3137161264. * 16384.,
    (double)401256./3137161264. * 16384.,
    (double)471484./3137161264. * 16384.,
    (double)172588./3137161264. * 16384.,
    (double)188645./3137161264. * 16384.,
    (double)334799./3137161264. * 16384.,
    (double)232082./3137161264. * 16384.,
    (double)227719./3137161264. * 16384.,
    (double)178322./3137161264. * 16384.,
    (double)276339./3137161264. * 16384.,
    (double)60038./3137161264. * 16384.,
    (double)167771./3137161264. * 16384.,
    (double)219309./3137161264. * 16384.,
    (double)139027./3137161264. * 16384.,
    (double)264457./3137161264. * 16384.,
    (double)141976./3137161264. * 16384.,
    (double)160683./3137161264. * 16384.,
    (double)258651./3137161264. * 16384.,
    (double)483455./3137161264. * 16384.,
    (double)183917./3137161264. * 16384.,
    (double)199724./3137161264. * 16384.,
    (double)42436./3137161264. * 16384.,
    (double)102190./3137161264. * 16384.,
    (double)40864./3137161264. * 16384.,
    (double)33414./3137161264. * 16384.,
    (double)322373./3137161264. * 16384.,
    (double)86252./3137161264. * 16384.,
    (double)201546./3137161264. * 16384.,
    (double)247095./3137161264. * 16384.,
    (double)154101./3137161264. * 16384.,
    (double)452467./3137161264. * 16384.,
    (double)199674./3137161264. * 16384.,
    (double)227642./3137161264. * 16384.,
    (double)201750./3137161264. * 16384.,
    (double)190624./3137161264. * 16384.,
    (double)98518./3137161264. * 16384.,
    (double)145768./3137161264. * 16384.,
    (double)286415./3137161264. * 16384.,
    (double)367437./3137161264. * 16384.,
    (double)148045./3137161264. * 16384.,
    (double)171723./3137161264. * 16384.,
    (double)249557./3137161264. * 16384.,
    (double)37515./3137161264. * 16384.,
    (double)127499./3137161264. * 16384.,
    (double)176672./3137161264. * 16384.,
    (double)171267./3137161264. * 16384.,
    (double)227288./3137161264. * 16384.,
    (double)136665./3137161264. * 16384.,
    (double)244773./3137161264. * 16384.,
    (double)322126./3137161264. * 16384.,
    (double)272263./3137161264. * 16384.,
    (double)137598./3137161264. * 16384.,
    (double)186600./3137161264. * 16384.,
    (double)330576./3137161264. * 16384.,
    (double)318367./3137161264. * 16384.,
    (double)234738./3137161264. * 16384.,
    (double)198507./3137161264. * 16384.,
    (double)238198./3137161264. * 16384.,
    (double)42888./3137161264. * 16384.,
    (double)146603./3137161264. * 16384.,
    (double)179899./3137161264. * 16384.,
    (double)141243./3137161264. * 16384.,
    (double)200897./3137161264. * 16384.,
    (double)152087./3137161264. * 16384.,
    (double)202840./3137161264. * 16384.,
    (double)30241./3137161264. * 16384.,
    (double)63152./3137161264. * 16384.,
    (double)19833./3137161264. * 16384.,
    (double)21850./3137161264. * 16384.,
    (double)33329./3137161264. * 16384.,
    (double)55751./3137161264. * 16384.,
    (double)37919./3137161264. * 16384.,
    (double)22216./3137161264. * 16384.,
    (double)32773./3137161264. * 16384.,
    (double)19709./3137161264. * 16384.,
    (double)33175./3137161264. * 16384.,
    (double)32069./3137161264. * 16384.,
    (double)15775./3137161264. * 16384.,
    (double)44193./3137161264. * 16384.,
    (double)22520./3137161264. * 16384.,
    (double)22842./3137161264. * 16384.,
    (double)233954./3137161264. * 16384.,
    (double)310112./3137161264. * 16384.,
    (double)349928./3137161264. * 16384.,
    (double)200867./3137161264. * 16384.,
    (double)51597./3137161264. * 16384.,
    (double)57369./3137161264. * 16384.,
    (double)45218./3137161264. * 16384.,
    (double)32603./3137161264. * 16384.,
    (double)272514./3137161264. * 16384.,
    (double)53418./3137161264. * 16384.,
    (double)184114./3137161264. * 16384.,
    (double)207192./3137161264. * 16384.,
    (double)119937./3137161264. * 16384.,
    (double)274861./3137161264. * 16384.,
    (double)201367./3137161264. * 16384.,
    (double)180688./3137161264. * 16384.,
    (double)174439./3137161264. * 16384.,
    (double)133633./3137161264. * 16384.,
    (double)116523./3137161264. * 16384.,
    (double)151962./3137161264. * 16384.,
    (double)283899./3137161264. * 16384.,
    (double)326364./3137161264. * 16384.,
    (double)222767./3137161264. * 16384.,
    (double)226336./3137161264. * 16384.,
    (double)241576./3137161264. * 16384.,
    (double)33323./3137161264. * 16384.,
    (double)186525./3137161264. * 16384.,
    (double)226675./3137161264. * 16384.,
    (double)140866./3137161264. * 16384.,
    (double)185537./3137161264. * 16384.,
    (double)187076./3137161264. * 16384.,
    (double)236259./3137161264. * 16384.,
    (double)278027./3137161264. * 16384.,
    (double)175604./3137161264. * 16384.,
    (double)114130./3137161264. * 16384.,
    (double)177139./3137161264. * 16384.,
    (double)194278./3137161264. * 16384.,
    (double)152542./3137161264. * 16384.,
    (double)138395./3137161264. * 16384.,
    (double)122480./3137161264. * 16384.,
    (double)162602./3137161264. * 16384.,
    (double)17516./3137161264. * 16384.,
    (double)75766./3137161264. * 16384.,
    (double)111813./3137161264. * 16384.,
    (double)156459./3137161264. * 16384.,
    (double)139044./3137161264. * 16384.,
    (double)101199./3137161264. * 16384.,
    (double)184067./3137161264. * 16384.,
    (double)282603./3137161264. * 16384.,
    (double)309760./3137161264. * 16384.,
    (double)156408./3137161264. * 16384.,
    (double)177874./3137161264. * 16384.,
    (double)230049./3137161264. * 16384.,
    (double)258137./3137161264. * 16384.,
    (double)162170./3137161264. * 16384.,
    (double)158260./3137161264. * 16384.,
    (double)219363./3137161264. * 16384.,
    (double)30879./3137161264. * 16384.,
    (double)129452./3137161264. * 16384.,
    (double)171510./3137161264. * 16384.,
    (double)133968./3137161264. * 16384.,
    (double)237581./3137161264. * 16384.,
    (double)130622./3137161264. * 16384.,
    (double)184054./3137161264. * 16384.,
    (double)182396./3137161264. * 16384.,
    (double)241461./3137161264. * 16384.,
    (double)168936./3137161264. * 16384.,
    (double)177726./3137161264. * 16384.,
    (double)20135./3137161264. * 16384.,
    (double)30504./3137161264. * 16384.,
    (double)18676./3137161264. * 16384.,
    (double)19863./3137161264. * 16384.,
    (double)182260./3137161264. * 16384.,
    (double)26194./3137161264. * 16384.,
    (double)141151./3137161264. * 16384.,
    (double)177665./3137161264. * 16384.,
    (double)126359./3137161264. * 16384.,
    (double)212316./3137161264. * 16384.,
    (double)187578./3137161264. * 16384.,
    (double)201644./3137161264. * 16384.,
    (double)213613./3137161264. * 16384.,
    (double)148704./3137161264. * 16384.,
    (double)115320./3137161264. * 16384.,
    (double)171840./3137161264. * 16384.,
    (double)196755./3137161264. * 16384.,
    (double)198540./3137161264. * 16384.,
    (double)122096./3137161264. * 16384.,
    (double)173324./3137161264. * 16384.,
    (double)240298./3137161264. * 16384.,
    (double)33898./3137161264. * 16384.,
    (double)155923./3137161264. * 16384.,
    (double)231504./3137161264. * 16384.,
    (double)230849./3137161264. * 16384.,
    (double)268609./3137161264. * 16384.,
    (double)234177./3137161264. * 16384.,
    (double)354055./3137161264. * 16384.,
    (double)425457./3137161264. * 16384.,
    (double)308803./3137161264. * 16384.,
    (double)177743./3137161264. * 16384.,
    (double)305658./3137161264. * 16384.,
    (double)243275./3137161264. * 16384.,
    (double)209877./3137161264. * 16384.,
    (double)131034./3137161264. * 16384.,
    (double)164672./3137161264. * 16384.,
    (double)207180./3137161264. * 16384.,
    (double)26978./3137161264. * 16384.,
    (double)105039./3137161264. * 16384.,
    (double)159557./3137161264. * 16384.,
    (double)208765./3137161264. * 16384.,
    (double)211784./3137161264. * 16384.,
    (double)111002./3137161264. * 16384.,
    (double)210394./3137161264. * 16384.,
    (double)386336./3137161264. * 16384.,
    (double)416135./3137161264. * 16384.,
    (double)189652./3137161264. * 16384.,
    (double)224598./3137161264. * 16384.,
    (double)273449./3137161264. * 16384.,
    (double)253591./3137161264. * 16384.,
    (double)173883./3137161264. * 16384.,
    (double)165966./3137161264. * 16384.,
    (double)256947./3137161264. * 16384.,
    (double)42482./3137161264. * 16384.,
    (double)167003./3137161264. * 16384.,
    (double)197355./3137161264. * 16384.,
    (double)159545./3137161264. * 16384.,
    (double)252466./3137161264. * 16384.,
    (double)131166./3137161264. * 16384.,
    (double)185359./3137161264. * 16384.,
    (double)245121./3137161264. * 16384.,
    (double)335489./3137161264. * 16384.,
    (double)197938./3137161264. * 16384.,
    (double)238380./3137161264. * 16384.,
    (double)32871./3137161264. * 16384.,
    (double)45712./3137161264. * 16384.,
    (double)28166./3137161264. * 16384.,
    (double)40708./3137161264. * 16384.,
    (double)198831./3137161264. * 16384.,
    (double)31436./3137161264. * 16384.,
    (double)121809./3137161264. * 16384.,
    (double)155892./3137161264. * 16384.,
    (double)130467./3137161264. * 16384.,
    (double)245375./3137161264. * 16384.,
    (double)128382./3137161264. * 16384.,
    (double)189758./3137161264. * 16384.,
    (double)228718./3137161264. * 16384.,
    (double)153441./3137161264. * 16384.,
    (double)126608./3137161264. * 16384.,
    (double)209353./3137161264. * 16384.,
    (double)227945./3137161264. * 16384.,
    (double)206911./3137161264. * 16384.,
    (double)135105./3137161264. * 16384.,
    (double)182032./3137161264. * 16384.,
    (double)207168./3137161264. * 16384.,
    (double)25420./3137161264. * 16384.,
    (double)124934./3137161264. * 16384.,
    (double)196790./3137161264. * 16384.,
    (double)215202./3137161264. * 16384.,
    (double)193138./3137161264. * 16384.,
    (double)184243./3137161264. * 16384.,
    (double)417812./3137161264. * 16384.,
    (double)31015./3137161264. * 16384.,
    (double)32841./3137161264. * 16384.,
    (double)14094./3137161264. * 16384.,
    (double)22971./3137161264. * 16384.,
    (double)31627./3137161264. * 16384.,
    (double)43477./3137161264. * 16384.,
    (double)19827./3137161264. * 16384.,
    (double)20480./3137161264. * 16384.,
    (double)25696./3137161264. * 16384.,
    (double)7815./3137161264. * 16384.,
    (double)14535./3137161264. * 16384.,
    (double)18022./3137161264. * 16384.,
    (double)17888./3137161264. * 16384.,
    (double)32217./3137161264. * 16384.,
    (double)13784./3137161264. * 16384.,
    (double)20423./3137161264. * 16384.,
    (double)33420./3137161264. * 16384.,
    (double)59359./3137161264. * 16384.,
    (double)19229./3137161264. * 16384.,
    (double)21931./3137161264. * 16384.,
    (double)39949./3137161264. * 16384.,
    (double)62460./3137161264. * 16384.,
    (double)29678./3137161264. * 16384.,
    (double)24284./3137161264. * 16384.,
    (double)32633./3137161264. * 16384.,
    (double)14073./3137161264. * 16384.,
    (double)26663./3137161264. * 16384.,
    (double)26967./3137161264. * 16384.,
    (double)16703./3137161264. * 16384.,
    (double)39920./3137161264. * 16384.,
    (double)17256./3137161264. * 16384.,
    (double)20067./3137161264. * 16384.,
    (double)19981./3137161264. * 16384.,
    (double)42053./3137161264. * 16384.,
    (double)19440./3137161264. * 16384.,
    (double)19969./3137161264. * 16384.,
    (double)6277./3137161264. * 16384.,
    (double)15585./3137161264. * 16384.,
    (double)10174./3137161264. * 16384.,
    (double)5769./3137161264. * 16384.,
    (double)30215./3137161264. * 16384.,
    (double)13048./3137161264. * 16384.,
    (double)26997./3137161264. * 16384.,
    (double)25442./3137161264. * 16384.,
    (double)15456./3137161264. * 16384.,
    (double)45916./3137161264. * 16384.,
    (double)21670./3137161264. * 16384.,
    (double)22905./3137161264. * 16384.,
    (double)23013./3137161264. * 16384.,
    (double)20642./3137161264. * 16384.,
    (double)12935./3137161264. * 16384.,
    (double)21178./3137161264. * 16384.,
    (double)41820./3137161264. * 16384.,
    (double)53204./3137161264. * 16384.,
    (double)28819./3137161264. * 16384.,
    (double)32671./3137161264. * 16384.,
    (double)30645./3137161264. * 16384.,
    (double)6617./3137161264. * 16384.,
    (double)22050./3137161264. * 16384.,
    (double)27804./3137161264. * 16384.,
    (double)23742./3137161264. * 16384.,
    (double)28530./3137161264. * 16384.,
    (double)22685./3137161264. * 16384.,
    (double)41195./3137161264. * 16384.,
    (double)202283./3137161264. * 16384.,
    (double)165402./3137161264. * 16384.,
    (double)100875./3137161264. * 16384.,
    (double)127680./3137161264. * 16384.,
    (double)183305./3137161264. * 16384.,
    (double)181256./3137161264. * 16384.,
    (double)174574./3137161264. * 16384.,
    (double)124900./3137161264. * 16384.,
    (double)218459./3137161264. * 16384.,
    (double)39480./3137161264. * 16384.,
    (double)118529./3137161264. * 16384.,
    (double)136142./3137161264. * 16384.,
    (double)117413./3137161264. * 16384.,
    (double)154775./3137161264. * 16384.,
    (double)113343./3137161264. * 16384.,
    (double)141802./3137161264. * 16384.,
    (double)20011./3137161264. * 16384.,
    (double)33583./3137161264. * 16384.,
    (double)13398./3137161264. * 16384.,
    (double)13071./3137161264. * 16384.,
    (double)18906./3137161264. * 16384.,
    (double)29297./3137161264. * 16384.,
    (double)21509./3137161264. * 16384.,
    (double)12301./3137161264. * 16384.,
    (double)23733./3137161264. * 16384.,
    (double)10260./3137161264. * 16384.,
    (double)20190./3137161264. * 16384.,
    (double)19652./3137161264. * 16384.,
    (double)15118./3137161264. * 16384.,
    (double)33547./3137161264. * 16384.,
    (double)17265./3137161264. * 16384.,
    (double)16328./3137161264. * 16384.,
    (double)147481./3137161264. * 16384.,
    (double)233548./3137161264. * 16384.,
    (double)131379./3137161264. * 16384.,
    (double)121957./3137161264. * 16384.,
    (double)21921./3137161264. * 16384.,
    (double)35566./3137161264. * 16384.,
    (double)26415./3137161264. * 16384.,
    (double)19228./3137161264. * 16384.,
    (double)201199./3137161264. * 16384.,
    (double)43956./3137161264. * 16384.,
    (double)107590./3137161264. * 16384.,
    (double)142303./3137161264. * 16384.,
    (double)96021./3137161264. * 16384.,
    (double)230055./3137161264. * 16384.,
    (double)136884./3137161264. * 16384.,
    (double)131585./3137161264. * 16384.,
    (double)128151./3137161264. * 16384.,
    (double)103607./3137161264. * 16384.,
    (double)80540./3137161264. * 16384.,
    (double)92283./3137161264. * 16384.,
    (double)163092./3137161264. * 16384.,
    (double)193294./3137161264. * 16384.,
    (double)140109./3137161264. * 16384.,
    (double)134905./3137161264. * 16384.,
    (double)214367./3137161264. * 16384.,
    (double)40321./3137161264. * 16384.,
    (double)145434./3137161264. * 16384.,
    (double)169122./3137161264. * 16384.,
    (double)117460./3137161264. * 16384.,
    (double)188908./3137161264. * 16384.,
    (double)137237./3137161264. * 16384.,
    (double)177901./3137161264. * 16384.,
    (double)200750./3137161264. * 16384.,
    (double)126644./3137161264. * 16384.,
    (double)79669./3137161264. * 16384.,
    (double)157837./3137161264. * 16384.,
    (double)142709./3137161264. * 16384.,
    (double)98698./3137161264. * 16384.,
    (double)73242./3137161264. * 16384.,
    (double)82679./3137161264. * 16384.,
    (double)191238./3137161264. * 16384.,
    (double)18678./3137161264. * 16384.,
    (double)65349./3137161264. * 16384.,
    (double)108208./3137161264. * 16384.,
    (double)154767./3137161264. * 16384.,
    (double)124551./3137161264. * 16384.,
    (double)78525./3137161264. * 16384.,
    (double)163004./3137161264. * 16384.,
    (double)248336./3137161264. * 16384.,
    (double)233107./3137161264. * 16384.,
    (double)123767./3137161264. * 16384.,
    (double)147522./3137161264. * 16384.,
    (double)205653./3137161264. * 16384.,
    (double)207743./3137161264. * 16384.,
    (double)138191./3137161264. * 16384.,
    (double)127333./3137161264. * 16384.,
    (double)199972./3137161264. * 16384.,
    (double)28378./3137161264. * 16384.,
    (double)129226./3137161264. * 16384.,
    (double)167473./3137161264. * 16384.,
    (double)155643./3137161264. * 16384.,
    (double)220905./3137161264. * 16384.,
    (double)128372./3137161264. * 16384.,
    (double)166722./3137161264. * 16384.,
    (double)177725./3137161264. * 16384.,
    (double)229247./3137161264. * 16384.,
    (double)143887./3137161264. * 16384.,
    (double)156711./3137161264. * 16384.,
    (double)22612./3137161264. * 16384.,
    (double)32482./3137161264. * 16384.,
    (double)19659./3137161264. * 16384.,
    (double)19658./3137161264. * 16384.,
    (double)216862./3137161264. * 16384.,
    (double)36410./3137161264. * 16384.,
    (double)131839./3137161264. * 16384.,
    (double)172021./3137161264. * 16384.,
    (double)136031./3137161264. * 16384.,
    (double)243888./3137161264. * 16384.,
    (double)147025./3137161264. * 16384.,
    (double)184104./3137161264. * 16384.,
    (double)194056./3137161264. * 16384.,
    (double)129398./3137161264. * 16384.,
    (double)114146./3137161264. * 16384.,
    (double)138134./3137161264. * 16384.,
    (double)183417./3137161264. * 16384.,
    (double)186224./3137161264. * 16384.,
    (double)135202./3137161264. * 16384.,
    (double)152602./3137161264. * 16384.,
    (double)246862./3137161264. * 16384.,
    (double)28901./3137161264. * 16384.,
    (double)182079./3137161264. * 16384.,
    (double)243086./3137161264. * 16384.,
    (double)218563./3137161264. * 16384.,
    (double)250879./3137161264. * 16384.,
    (double)203685./3137161264. * 16384.,
    (double)328910./3137161264. * 16384.,
    (double)491431./3137161264. * 16384.,
    (double)282229./3137161264. * 16384.,
    (double)190688./3137161264. * 16384.,
    (double)381106./3137161264. * 16384.,
    (double)216995./3137161264. * 16384.,
    (double)157925./3137161264. * 16384.,
    (double)111378./3137161264. * 16384.,
    (double)145446./3137161264. * 16384.,
    (double)205234./3137161264. * 16384.,
    (double)23392./3137161264. * 16384.,
    (double)91926./3137161264. * 16384.,
    (double)164767./3137161264. * 16384.,
    (double)290554./3137161264. * 16384.,
    (double)229426./3137161264. * 16384.,
    (double)137299./3137161264. * 16384.,
    (double)309487./3137161264. * 16384.,
    (double)250084./3137161264. * 16384.,
    (double)179814./3137161264. * 16384.,
    (double)100332./3137161264. * 16384.,
    (double)185496./3137161264. * 16384.,
    (double)158047./3137161264. * 16384.,
    (double)108771./3137161264. * 16384.,
    (double)79647./3137161264. * 16384.,
    (double)103050./3137161264. * 16384.,
    (double)144954./3137161264. * 16384.,
    (double)15342./3137161264. * 16384.,
    (double)73548./3137161264. * 16384.,
    (double)120553./3137161264. * 16384.,
    (double)125980./3137161264. * 16384.,
    (double)130400./3137161264. * 16384.,
    (double)77515./3137161264. * 16384.,
    (double)144343./3137161264. * 16384.,
    (double)215463./3137161264. * 16384.,
    (double)204230./3137161264. * 16384.,
    (double)119499./3137161264. * 16384.,
    (double)210681./3137161264. * 16384.,
    (double)22263./3137161264. * 16384.,
    (double)23227./3137161264. * 16384.,
    (double)13824./3137161264. * 16384.,
    (double)28314./3137161264. * 16384.,
    (double)152953./3137161264. * 16384.,
    (double)15549./3137161264. * 16384.,
    (double)76998./3137161264. * 16384.,
    (double)118343./3137161264. * 16384.,
    (double)128871./3137161264. * 16384.,
    (double)159520./3137161264. * 16384.,
    (double)100121./3137161264. * 16384.,
    (double)171965./3137161264. * 16384.,
    (double)276484./3137161264. * 16384.,
    (double)150034./3137161264. * 16384.,
    (double)131870./3137161264. * 16384.,
    (double)290231./3137161264. * 16384.,
    (double)198783./3137161264. * 16384.,
    (double)150298./3137161264. * 16384.,
    (double)114013./3137161264. * 16384.,
    (double)188428./3137161264. * 16384.,
    (double)176013./3137161264. * 16384.,
    (double)16276./3137161264. * 16384.,
    (double)107476./3137161264. * 16384.,
    (double)173105./3137161264. * 16384.,
    (double)263844./3137161264. * 16384.,
    (double)192950./3137161264. * 16384.,
    (double)186953./3137161264. * 16384.,
    (double)467225./3137161264. * 16384.,
    (double)407420./3137161264. * 16384.,
    (double)287864./3137161264. * 16384.,
    (double)154648./3137161264. * 16384.,
    (double)278578./3137161264. * 16384.,
    (double)300994./3137161264. * 16384.,
    (double)270153./3137161264. * 16384.,
    (double)142332./3137161264. * 16384.,
    (double)179521./3137161264. * 16384.,
    (double)246942./3137161264. * 16384.,
    (double)33425./3137161264. * 16384.,
    (double)113371./3137161264. * 16384.,
    (double)185794./3137161264. * 16384.,
    (double)211468./3137161264. * 16384.,
    (double)265525./3137161264. * 16384.,
    (double)121765./3137161264. * 16384.,
    (double)221944./3137161264. * 16384.,
    (double)302374./3137161264. * 16384.,
    (double)304829./3137161264. * 16384.,
    (double)124643./3137161264. * 16384.,
    (double)209261./3137161264. * 16384.,
    (double)266882./3137161264. * 16384.,
    (double)268380./3137161264. * 16384.,
    (double)145591./3137161264. * 16384.,
    (double)159072./3137161264. * 16384.,
    (double)227645./3137161264. * 16384.,
    (double)38821./3137161264. * 16384.,
    (double)131551./3137161264. * 16384.,
    (double)200342./3137161264. * 16384.,
    (double)153487./3137161264. * 16384.,
    (double)237007./3137161264. * 16384.,
    (double)107229./3137161264. * 16384.,
    (double)176773./3137161264. * 16384.,
    (double)187975./3137161264. * 16384.,
    (double)229359./3137161264. * 16384.,
    (double)108212./3137161264. * 16384.,
    (double)166261./3137161264. * 16384.,
    (double)19601./3137161264. * 16384.,
    (double)30345./3137161264. * 16384.,
    (double)16353./3137161264. * 16384.,
    (double)21887./3137161264. * 16384.,
    (double)207171./3137161264. * 16384.,
    (double)29038./3137161264. * 16384.,
    (double)131270./3137161264. * 16384.,
    (double)172442./3137161264. * 16384.,
    (double)147232./3137161264. * 16384.,
    (double)265044./3137161264. * 16384.,
    (double)146522./3137161264. * 16384.,
    (double)197143./3137161264. * 16384.,
    (double)191343./3137161264. * 16384.,
    (double)138662./3137161264. * 16384.,
    (double)97012./3137161264. * 16384.,
    (double)175757./3137161264. * 16384.,
    (double)229511./3137161264. * 16384.,
    (double)230077./3137161264. * 16384.,
    (double)137447./3137161264. * 16384.,
    (double)210261./3137161264. * 16384.,
    (double)203411./3137161264. * 16384.,
    (double)20598./3137161264. * 16384.,
    (double)127689./3137161264. * 16384.,
    (double)188238./3137161264. * 16384.,
    (double)197617./3137161264. * 16384.,
    (double)198566./3137161264. * 16384.,
    (double)161435./3137161264. * 16384.,
    (double)307386./3137161264. * 16384.,
    (double)213974./3137161264. * 16384.,
    (double)159313./3137161264. * 16384.,
    (double)90842./3137161264. * 16384.,
    (double)149634./3137161264. * 16384.,
    (double)185922./3137161264. * 16384.,
    (double)140005./3137161264. * 16384.,
    (double)111979./3137161264. * 16384.,
    (double)134595./3137161264. * 16384.,
    (double)205481./3137161264. * 16384.,
    (double)39135./3137161264. * 16384.,
    (double)111954./3137161264. * 16384.,
    (double)174576./3137161264. * 16384.,
    (double)152308./3137161264. * 16384.,
    (double)175471./3137161264. * 16384.,
    (double)124840./3137161264. * 16384.,
    (double)206953./3137161264. * 16384.,
    (double)16599./3137161264. * 16384.,
    (double)22782./3137161264. * 16384.,
    (double)9482./3137161264. * 16384.,
    (double)16366./3137161264. * 16384.,
    (double)14113./3137161264. * 16384.,
    (double)18815./3137161264. * 16384.,
    (double)12457./3137161264. * 16384.,
    (double)12162./3137161264. * 16384.,
    (double)21182./3137161264. * 16384.,
    (double)8718./3137161264. * 16384.,
    (double)16755./3137161264. * 16384.,
    (double)29694./3137161264. * 16384.,
    (double)15349./3137161264. * 16384.,
    (double)29431./3137161264. * 16384.,
    (double)13453./3137161264. * 16384.,
    (double)20636./3137161264. * 16384.,
    (double)137662./3137161264. * 16384.,
    (double)165450./3137161264. * 16384.,
    (double)115910./3137161264. * 16384.,
    (double)127102./3137161264. * 16384.,
    (double)15656./3137161264. * 16384.,
    (double)17916./3137161264. * 16384.,
    (double)23918./3137161264. * 16384.,
    (double)17300./3137161264. * 16384.,
    (double)163267./3137161264. * 16384.,
    (double)23959./3137161264. * 16384.,
    (double)94292./3137161264. * 16384.,
    (double)136378./3137161264. * 16384.,
    (double)102107./3137161264. * 16384.,
    (double)174144./3137161264. * 16384.,
    (double)141869./3137161264. * 16384.,
    (double)153359./3137161264. * 16384.,
    (double)135118./3137161264. * 16384.,
    (double)103433./3137161264. * 16384.,
    (double)81276./3137161264. * 16384.,
    (double)124194./3137161264. * 16384.,
    (double)180093./3137161264. * 16384.,
    (double)157834./3137161264. * 16384.,
    (double)134161./3137161264. * 16384.,
    (double)165537./3137161264. * 16384.,
    (double)201275./3137161264. * 16384.,
    (double)31594./3137161264. * 16384.,
    (double)124787./3137161264. * 16384.,
    (double)189159./3137161264. * 16384.,
    (double)144773./3137161264. * 16384.,
    (double)170240./3137161264. * 16384.,
    (double)147589./3137161264. * 16384.,
    (double)237515./3137161264. * 16384.,
    (double)362747./3137161264. * 16384.,
    (double)169678./3137161264. * 16384.,
    (double)116398./3137161264. * 16384.,
    (double)227631./3137161264. * 16384.,
    (double)183665./3137161264. * 16384.,
    (double)126058./3137161264. * 16384.,
    (double)89802./3137161264. * 16384.,
    (double)122196./3137161264. * 16384.,
    (double)285322./3137161264. * 16384.,
    (double)22886./3137161264. * 16384.,
    (double)84573./3137161264. * 16384.,
    (double)152534./3137161264. * 16384.,
    (double)259452./3137161264. * 16384.,
    (double)180293./3137161264. * 16384.,
    (double)135022./3137161264. * 16384.,
    (double)310229./3137161264. * 16384.,
    (double)199191./3137161264. * 16384.,
    (double)148132./3137161264. * 16384.,
    (double)87527./3137161264. * 16384.,
    (double)149770./3137161264. * 16384.,
    (double)160727./3137161264. * 16384.,
    (double)124404./3137161264. * 16384.,
    (double)99030./3137161264. * 16384.,
    (double)122035./3137161264. * 16384.,
    (double)166089./3137161264. * 16384.,
    (double)17682./3137161264. * 16384.,
    (double)95173./3137161264. * 16384.,
    (double)178064./3137161264. * 16384.,
    (double)146297./3137161264. * 16384.,
    (double)169627./3137161264. * 16384.,
    (double)105676./3137161264. * 16384.,
    (double)195733./3137161264. * 16384.,
    (double)226304./3137161264. * 16384.,
    (double)216117./3137161264. * 16384.,
    (double)134381./3137161264. * 16384.,
    (double)206658./3137161264. * 16384.,
    (double)20482./3137161264. * 16384.,
    (double)19650./3137161264. * 16384.,
    (double)13840./3137161264. * 16384.,
    (double)20677./3137161264. * 16384.,
    (double)229666./3137161264. * 16384.,
    (double)22094./3137161264. * 16384.,
    (double)131067./3137161264. * 16384.,
    (double)207394./3137161264. * 16384.,
    (double)195180./3137161264. * 16384.,
    (double)257600./3137161264. * 16384.,
    (double)204316./3137161264. * 16384.,
    (double)264148./3137161264. * 16384.,
    (double)323219./3137161264. * 16384.,
    (double)186120./3137161264. * 16384.,
    (double)150822./3137161264. * 16384.,
    (double)313659./3137161264. * 16384.,
    (double)259329./3137161264. * 16384.,
    (double)239218./3137161264. * 16384.,
    (double)169612./3137161264. * 16384.,
    (double)244362./3137161264. * 16384.,
    (double)328921./3137161264. * 16384.,
    (double)24477./3137161264. * 16384.,
    (double)211647./3137161264. * 16384.,
    (double)363807./3137161264. * 16384.,
    (double)421562./3137161264. * 16384.,
    (double)337459./3137161264. * 16384.,
    (double)328443./3137161264. * 16384.,
    (double)626604./3137161264. * 16384.,
    (double)757933./3137161264. * 16384.,
    (double)499004./3137161264. * 16384.,
    (double)346383./3137161264. * 16384.,
    (double)559555./3137161264. * 16384.,
    (double)521869./3137161264. * 16384.,
    (double)411279./3137161264. * 16384.,
    (double)252519./3137161264. * 16384.,
    (double)291335./3137161264. * 16384.,
    (double)412243./3137161264. * 16384.,
    (double)55524./3137161264. * 16384.,
    (double)203974./3137161264. * 16384.,
    (double)315106./3137161264. * 16384.,
    (double)442425./3137161264. * 16384.,
    (double)436499./3137161264. * 16384.,
    (double)222717./3137161264. * 16384.,
    (double)381456./3137161264. * 16384.,
    (double)555864./3137161264. * 16384.,
    (double)449262./3137161264. * 16384.,
    (double)233568./3137161264. * 16384.,
    (double)285016./3137161264. * 16384.,
    (double)484579./3137161264. * 16384.,
    (double)388579./3137161264. * 16384.,
    (double)256413./3137161264. * 16384.,
    (double)233040./3137161264. * 16384.,
    (double)333433./3137161264. * 16384.,
    (double)48182./3137161264. * 16384.,
    (double)244436./3137161264. * 16384.,
    (double)274087./3137161264. * 16384.,
    (double)208681./3137161264. * 16384.,
    (double)286283./3137161264. * 16384.,
    (double)187081./3137161264. * 16384.,
    (double)241273./3137161264. * 16384.,
    (double)250661./3137161264. * 16384.,
    (double)264390./3137161264. * 16384.,
    (double)172537./3137161264. * 16384.,
    (double)216276./3137161264. * 16384.,
    (double)29034./3137161264. * 16384.,
    (double)33814./3137161264. * 16384.,
    (double)26159./3137161264. * 16384.,
    (double)34146./3137161264. * 16384.,
    (double)193311./3137161264. * 16384.,
    (double)29013./3137161264. * 16384.,
    (double)134137./3137161264. * 16384.,
    (double)143382./3137161264. * 16384.,
    (double)146721./3137161264. * 16384.,
    (double)229375./3137161264. * 16384.,
    (double)154643./3137161264. * 16384.,
    (double)199033./3137161264. * 16384.,
    (double)308399./3137161264. * 16384.,
    (double)184121./3137161264. * 16384.,
    (double)149832./3137161264. * 16384.,
    (double)267350./3137161264. * 16384.,
    (double)287815./3137161264. * 16384.,
    (double)253635./3137161264. * 16384.,
    (double)182084./3137161264. * 16384.,
    (double)239409./3137161264. * 16384.,
    (double)220564./3137161264. * 16384.,
    (double)27802./3137161264. * 16384.,
    (double)142802./3137161264. * 16384.,
    (double)202791./3137161264. * 16384.,
    (double)247982./3137161264. * 16384.,
    (double)205763./3137161264. * 16384.,
    (double)204604./3137161264. * 16384.,
    (double)348804./3137161264. * 16384.,
    (double)595624./3137161264. * 16384.,
    (double)416166./3137161264. * 16384.,
    (double)194527./3137161264. * 16384.,
    (double)317814./3137161264. * 16384.,
    (double)463532./3137161264. * 16384.,
    (double)417099./3137161264. * 16384.,
    (double)206242./3137161264. * 16384.,
    (double)214753./3137161264. * 16384.,
    (double)313896./3137161264. * 16384.,
    (double)55654./3137161264. * 16384.,
    (double)173023./3137161264. * 16384.,
    (double)214419./3137161264. * 16384.,
    (double)211809./3137161264. * 16384.,
    (double)296649./3137161264. * 16384.,
    (double)127886./3137161264. * 16384.,
    (double)215148./3137161264. * 16384.,
    (double)449598./3137161264. * 16384.,
    (double)464456./3137161264. * 16384.,
    (double)176597./3137161264. * 16384.,
    (double)241395./3137161264. * 16384.,
    (double)412927./3137161264. * 16384.,
    (double)375237./3137161264. * 16384.,
    (double)219493./3137161264. * 16384.,
    (double)209577./3137161264. * 16384.,
    (double)325283./3137161264. * 16384.,
    (double)83796./3137161264. * 16384.,
    (double)267027./3137161264. * 16384.,
    (double)326567./3137161264. * 16384.,
    (double)167324./3137161264. * 16384.,
    (double)323166./3137161264. * 16384.,
    (double)144170./3137161264. * 16384.,
    (double)186196./3137161264. * 16384.,
    (double)206287./3137161264. * 16384.,
    (double)316259./3137161264. * 16384.,
    (double)148728./3137161264. * 16384.,
    (double)158624./3137161264. * 16384.,
    (double)32922./3137161264. * 16384.,
    (double)56413./3137161264. * 16384.,
    (double)39676./3137161264. * 16384.,
    (double)29100./3137161264. * 16384.,
    (double)247011./3137161264. * 16384.,
    (double)59427./3137161264. * 16384.,
    (double)202968./3137161264. * 16384.,
    (double)196995./3137161264. * 16384.,
    (double)133411./3137161264. * 16384.,
    (double)319158./3137161264. * 16384.,
    (double)182412./3137161264. * 16384.,
    (double)187471./3137161264. * 16384.,
    (double)154278./3137161264. * 16384.,
    (double)140385./3137161264. * 16384.,
    (double)89470./3137161264. * 16384.,
    (double)122249./3137161264. * 16384.,
    (double)224257./3137161264. * 16384.,
    (double)253224./3137161264. * 16384.,
    (double)179001./3137161264. * 16384.,
    (double)165321./3137161264. * 16384.,
    (double)194297./3137161264. * 16384.,
    (double)28356./3137161264. * 16384.,
    (double)135474./3137161264. * 16384.,
    (double)192764./3137161264. * 16384.,
    (double)149003./3137161264. * 16384.,
    (double)182625./3137161264. * 16384.,
    (double)170212./3137161264. * 16384.,
    (double)259135./3137161264. * 16384.,
    (double)262543./3137161264. * 16384.,
    (double)185191./3137161264. * 16384.,
    (double)107671./3137161264. * 16384.,
    (double)155451./3137161264. * 16384.,
    (double)282632./3137161264. * 16384.,
    (double)238733./3137161264. * 16384.,
    (double)164692./3137161264. * 16384.,
    (double)170356./3137161264. * 16384.,
    (double)266174./3137161264. * 16384.,
    (double)44127./3137161264. * 16384.,
    (double)127848./3137161264. * 16384.,
    (double)166059./3137161264. * 16384.,
    (double)151363./3137161264. * 16384.,
    (double)189338./3137161264. * 16384.,
    (double)122527./3137161264. * 16384.,
    (double)212909./3137161264. * 16384.,
    (double)22715./3137161264. * 16384.,
    (double)33038./3137161264. * 16384.,
    (double)17011./3137161264. * 16384.,
    (double)19521./3137161264. * 16384.,
    (double)33745./3137161264. * 16384.,
    (double)45888./3137161264. * 16384.,
    (double)29067./3137161264. * 16384.,
    (double)23635./3137161264. * 16384.,
    (double)29772./3137161264. * 16384.,
    (double)15147./3137161264. * 16384.,
    (double)29705./3137161264. * 16384.,
    (double)30275./3137161264. * 16384.,
    (double)17447./3137161264. * 16384.,
    (double)46117./3137161264. * 16384.,
    (double)21336./3137161264. * 16384.,
    (double)26138./3137161264. * 16384.,
    (double)122273./3137161264. * 16384.,
    (double)169420./3137161264. * 16384.,
    (double)122363./3137161264. * 16384.,
    (double)110049./3137161264. * 16384.,
    (double)19678./3137161264. * 16384.,
    (double)26369./3137161264. * 16384.,
    (double)20763./3137161264. * 16384.,
    (double)19970./3137161264. * 16384.,
    (double)160355./3137161264. * 16384.,
    (double)33154./3137161264. * 16384.,
    (double)127731./3137161264. * 16384.,
    (double)139736./3137161264. * 16384.,
    (double)83521./3137161264. * 16384.,
    (double)167732./3137161264. * 16384.,
    (double)117507./3137161264. * 16384.,
    (double)117960./3137161264. * 16384.,
    (double)123095./3137161264. * 16384.,
    (double)97627./3137161264. * 16384.,
    (double)99913./3137161264. * 16384.,
    (double)107130./3137161264. * 16384.,
    (double)171433./3137161264. * 16384.,
    (double)183042./3137161264. * 16384.,
    (double)121308./3137161264. * 16384.,
    (double)151406./3137161264. * 16384.,
    (double)170915./3137161264. * 16384.,
    (double)29838./3137161264. * 16384.,
    (double)131107./3137161264. * 16384.,
    (double)166654./3137161264. * 16384.,
    (double)121003./3137161264. * 16384.,
    (double)168587./3137161264. * 16384.,
    (double)157477./3137161264. * 16384.,
    (double)210345./3137161264. * 16384.,
    (double)290819./3137161264. * 16384.,
    (double)140130./3137161264. * 16384.,
    (double)94592./3137161264. * 16384.,
    (double)193168./3137161264. * 16384.,
    (double)160239./3137161264. * 16384.,
    (double)109198./3137161264. * 16384.,
    (double)73149./3137161264. * 16384.,
    (double)100541./3137161264. * 16384.,
    (double)174992./3137161264. * 16384.,
    (double)18841./3137161264. * 16384.,
    (double)74139./3137161264. * 16384.,
    (double)111588./3137161264. * 16384.,
    (double)189743./3137161264. * 16384.,
    (double)155999./3137161264. * 16384.,
    (double)101767./3137161264. * 16384.,
    (double)238714./3137161264. * 16384.,
    (double)262547./3137161264. * 16384.,
    (double)226995./3137161264. * 16384.,
    (double)129699./3137161264. * 16384.,
    (double)169107./3137161264. * 16384.,
    (double)260335./3137161264. * 16384.,
    (double)246176./3137161264. * 16384.,
    (double)147919./3137161264. * 16384.,
    (double)158043./3137161264. * 16384.,
    (double)182660./3137161264. * 16384.,
    (double)27754./3137161264. * 16384.,
    (double)130005./3137161264. * 16384.,
    (double)181602./3137161264. * 16384.,
    (double)131519./3137161264. * 16384.,
    (double)217577./3137161264. * 16384.,
    (double)117068./3137161264. * 16384.,
    (double)180909./3137161264. * 16384.,
    (double)128370./3137161264. * 16384.,
    (double)140937./3137161264. * 16384.,
    (double)127117./3137161264. * 16384.,
    (double)137340./3137161264. * 16384.,
    (double)14057./3137161264. * 16384.,
    (double)16552./3137161264. * 16384.,
    (double)18979./3137161264. * 16384.,
    (double)16848./3137161264. * 16384.,
    (double)131836./3137161264. * 16384.,
    (double)19497./3137161264. * 16384.,
    (double)110444./3137161264. * 16384.,
    (double)133809./3137161264. * 16384.,
    (double)96078./3137161264. * 16384.,
    (double)160453./3137161264. * 16384.,
    (double)120551./3137161264. * 16384.,
    (double)144414./3137161264. * 16384.,
    (double)195996./3137161264. * 16384.,
    (double)133249./3137161264. * 16384.,
    (double)154942./3137161264. * 16384.,
    (double)194291./3137161264. * 16384.,
    (double)130801./3137161264. * 16384.,
    (double)135057./3137161264. * 16384.,
    (double)107867./3137161264. * 16384.,
    (double)136370./3137161264. * 16384.,
    (double)192608./3137161264. * 16384.,
    (double)22254./3137161264. * 16384.,
    (double)136406./3137161264. * 16384.,
    (double)201462./3137161264. * 16384.,
    (double)208193./3137161264. * 16384.,
    (double)234028./3137161264. * 16384.,
    (double)206045./3137161264. * 16384.,
    (double)359855./3137161264. * 16384.,
    (double)531375./3137161264. * 16384.,
    (double)395211./3137161264. * 16384.,
    (double)230683./3137161264. * 16384.,
    (double)346230./3137161264. * 16384.,
    (double)414187./3137161264. * 16384.,
    (double)424773./3137161264. * 16384.,
    (double)246157./3137161264. * 16384.,
    (double)237307./3137161264. * 16384.,
    (double)231317./3137161264. * 16384.,
    (double)36051./3137161264. * 16384.,
    (double)131241./3137161264. * 16384.,
    (double)178958./3137161264. * 16384.,
    (double)203559./3137161264. * 16384.,
    (double)247581./3137161264. * 16384.,
    (double)128401./3137161264. * 16384.,
    (double)214017./3137161264. * 16384.,
    (double)404603./3137161264. * 16384.,
    (double)403587./3137161264. * 16384.,
    (double)208276./3137161264. * 16384.,
    (double)219621./3137161264. * 16384.,
    (double)419447./3137161264. * 16384.,
    (double)467852./3137161264. * 16384.,
    (double)355719./3137161264. * 16384.,
    (double)252705./3137161264. * 16384.,
    (double)230630./3137161264. * 16384.,
    (double)52732./3137161264. * 16384.,
    (double)198190./3137161264. * 16384.,
    (double)222899./3137161264. * 16384.,
    (double)123654./3137161264. * 16384.,
    (double)232739./3137161264. * 16384.,
    (double)130859./3137161264. * 16384.,
    (double)170927./3137161264. * 16384.,
    (double)180283./3137161264. * 16384.,
    (double)262962./3137161264. * 16384.,
    (double)160547./3137161264. * 16384.,
    (double)167490./3137161264. * 16384.,
    (double)26618./3137161264. * 16384.,
    (double)46287./3137161264. * 16384.,
    (double)33239./3137161264. * 16384.,
    (double)30782./3137161264. * 16384.,
    (double)159608./3137161264. * 16384.,
    (double)31882./3137161264. * 16384.,
    (double)148222./3137161264. * 16384.,
    (double)142428./3137161264. * 16384.,
    (double)140454./3137161264. * 16384.,
    (double)195856./3137161264. * 16384.,
    (double)135279./3137161264. * 16384.,
    (double)164374./3137161264. * 16384.,
    (double)163864./3137161264. * 16384.,
    (double)116884./3137161264. * 16384.,
    (double)91957./3137161264. * 16384.,
    (double)150295./3137161264. * 16384.,
    (double)204289./3137161264. * 16384.,
    (double)249267./3137161264. * 16384.,
    (double)143594./3137161264. * 16384.,
    (double)161519./3137161264. * 16384.,
    (double)129478./3137161264. * 16384.,
    (double)18941./3137161264. * 16384.,
    (double)107705./3137161264. * 16384.,
    (double)130845./3137161264. * 16384.,
    (double)221420./3137161264. * 16384.,
    (double)145274./3137161264. * 16384.,
    (double)132559./3137161264. * 16384.,
    (double)231242./3137161264. * 16384.,
    (double)408712./3137161264. * 16384.,
    (double)349369./3137161264. * 16384.,
    (double)135878./3137161264. * 16384.,
    (double)177094./3137161264. * 16384.,
    (double)315652./3137161264. * 16384.,
    (double)413268./3137161264. * 16384.,
    (double)178549./3137161264. * 16384.,
    (double)158748./3137161264. * 16384.,
    (double)221113./3137161264. * 16384.,
    (double)45033./3137161264. * 16384.,
    (double)126297./3137161264. * 16384.,
    (double)149815./3137161264. * 16384.,
    (double)126710./3137161264. * 16384.,
    (double)211515./3137161264. * 16384.,
    (double)87373./3137161264. * 16384.,
    (double)145256./3137161264. * 16384.,
    (double)247082./3137161264. * 16384.,
    (double)241371./3137161264. * 16384.,
    (double)111076./3137161264. * 16384.,
    (double)123530./3137161264. * 16384.,
    (double)130067./3137161264. * 16384.,
    (double)102845./3137161264. * 16384.,
    (double)111186./3137161264. * 16384.,
    (double)97560./3137161264. * 16384.,
    (double)186192./3137161264. * 16384.,
    (double)79577./3137161264. * 16384.,
    (double)133282./3137161264. * 16384.,
    (double)172003./3137161264. * 16384.,
    (double)85268./3137161264. * 16384.,
    (double)229138./3137161264. * 16384.,
    (double)99110./3137161264. * 16384.,
    (double)115622./3137161264. * 16384.,
    (double)147266./3137161264. * 16384.,
    (double)312960./3137161264. * 16384.,
    (double)130337./3137161264. * 16384.,
    (double)134094./3137161264. * 16384.,
    (double)31734./3137161264. * 16384.,
    (double)106525./3137161264. * 16384.,
    (double)47090./3137161264. * 16384.,
    (double)31777./3137161264. * 16384.,
    (double)197807./3137161264. * 16384.,
    (double)67832./3137161264. * 16384.,
    (double)151952./3137161264. * 16384.,
    (double)192112./3137161264. * 16384.,
    (double)97422./3137161264. * 16384.,
    (double)319424./3137161264. * 16384.,
    (double)164925./3137161264. * 16384.,
    (double)172698./3137161264. * 16384.,
    (double)104727./3137161264. * 16384.,
    (double)119237./3137161264. * 16384.,
    (double)69173./3137161264. * 16384.,
    (double)86026./3137161264. * 16384.,
    (double)181779./3137161264. * 16384.,
    (double)327373./3137161264. * 16384.,
    (double)127210./3137161264. * 16384.,
    (double)138580./3137161264. * 16384.,
    (double)146274./3137161264. * 16384.,
    (double)30496./3137161264. * 16384.,
    (double)121854./3137161264. * 16384.,
    (double)155004./3137161264. * 16384.,
    (double)104868./3137161264. * 16384.,
    (double)161087./3137161264. * 16384.,
    (double)106911./3137161264. * 16384.,
    (double)185550./3137161264. * 16384.,
    (double)220192./3137161264. * 16384.,
    (double)205485./3137161264. * 16384.,
    (double)116403./3137161264. * 16384.,
    (double)130476./3137161264. * 16384.,
    (double)291411./3137161264. * 16384.,
    (double)369128./3137161264. * 16384.,
    (double)220141./3137161264. * 16384.,
    (double)180866./3137161264. * 16384.,
    (double)206125./3137161264. * 16384.,
    (double)46605./3137161264. * 16384.,
    (double)135398./3137161264. * 16384.,
    (double)152304./3137161264. * 16384.,
    (double)111634./3137161264. * 16384.,
    (double)200302./3137161264. * 16384.,
    (double)125490./3137161264. * 16384.,
    (double)163590./3137161264. * 16384.,
    (double)21175./3137161264. * 16384.,
    (double)49534./3137161264. * 16384.,
    (double)24853./3137161264. * 16384.,
    (double)19956./3137161264. * 16384.,
    (double)46041./3137161264. * 16384.,
    (double)118097./3137161264. * 16384.,
    (double)58415./3137161264. * 16384.,
    (double)31676./3137161264. * 16384.,
    (double)34645./3137161264. * 16384.,
    (double)33992./3137161264. * 16384.,
    (double)44727./3137161264. * 16384.,
    (double)34919./3137161264. * 16384.,
    (double)14394./3137161264. * 16384.,
    (double)65841./3137161264. * 16384.,
    (double)25398./3137161264. * 16384.,
    (double)21322./3137161264. * 16384.,
    (double)139147./3137161264. * 16384.,
    (double)254735./3137161264. * 16384.,
    (double)157246./3137161264. * 16384.,
    (double)137150./3137161264. * 16384.,
    (double)31773./3137161264. * 16384.,
    (double)71374./3137161264. * 16384.,
    (double)46446./3137161264. * 16384.,
    (double)30367./3137161264. * 16384.,
    (double)180164./3137161264. * 16384.,
    (double)49115./3137161264. * 16384.,
    (double)149182./3137161264. * 16384.,
    (double)170080./3137161264. * 16384.,
    (double)84863./3137161264. * 16384.,
    (double)258106./3137161264. * 16384.,
    (double)178278./3137161264. * 16384.,
    (double)157303./3137161264. * 16384.,
    (double)102719./3137161264. * 16384.,
    (double)97888./3137161264. * 16384.,
    (double)77667./3137161264. * 16384.,
    (double)94644./3137161264. * 16384.,
    (double)211244./3137161264. * 16384.,
    (double)338931./3137161264. * 16384.,
    (double)220369./3137161264. * 16384.,
    (double)199096./3137161264. * 16384.,
    (double)190938./3137161264. * 16384.,
    (double)34003./3137161264. * 16384.,
    (double)181604./3137161264. * 16384.,
    (double)194224./3137161264. * 16384.,
    (double)112483./3137161264. * 16384.,
    (double)165096./3137161264. * 16384.,
    (double)175167./3137161264. * 16384.,
    (double)207125./3137161264. * 16384.,
    (double)174101./3137161264. * 16384.,
    (double)124911./3137161264. * 16384.,
    (double)76713./3137161264. * 16384.,
    (double)120387./3137161264. * 16384.,
    (double)148549./3137161264. * 16384.,
    (double)143057./3137161264. * 16384.,
    (double)75777./3137161264. * 16384.,
    (double)86174./3137161264. * 16384.,
    (double)131545./3137161264. * 16384.,
    (double)15870./3137161264. * 16384.,
    (double)63180./3137161264. * 16384.,
    (double)82305./3137161264. * 16384.,
    (double)114452./3137161264. * 16384.,
    (double)111699./3137161264. * 16384.,
    (double)70211./3137161264. * 16384.,
    (double)126203./3137161264. * 16384.,
    (double)177732./3137161264. * 16384.,
    (double)235461./3137161264. * 16384.,
    (double)133318./3137161264. * 16384.,
    (double)140767./3137161264. * 16384.,
    (double)232416./3137161264. * 16384.,
    (double)379521./3137161264. * 16384.,
    (double)168728./3137161264. * 16384.,
    (double)164247./3137161264. * 16384.,
    (double)159707./3137161264. * 16384.,
    (double)36919./3137161264. * 16384.,
    (double)121661./3137161264. * 16384.,
    (double)151687./3137161264. * 16384.,
    (double)91710./3137161264. * 16384.,
    (double)228080./3137161264. * 16384.,
    (double)110699./3137161264. * 16384.,
    (double)136790./3137161264. * 16384.,
    (double)112109./3137161264. * 16384.,
    (double)182757./3137161264. * 16384.,
    (double)120588./3137161264. * 16384.,
    (double)125743./3137161264. * 16384.,
    (double)14268./3137161264. * 16384.,
    (double)31991./3137161264. * 16384.,
    (double)18445./3137161264. * 16384.,
    (double)17434./3137161264. * 16384.,
    (double)120307./3137161264. * 16384.,
    (double)24301./3137161264. * 16384.,
    (double)140972./3137161264. * 16384.,
    (double)145977./3137161264. * 16384.,
    (double)80893./3137161264. * 16384.,
    (double)178050./3137161264. * 16384.,
    (double)164750./3137161264. * 16384.,
    (double)164747./3137161264. * 16384.,
    (double)121231./3137161264. * 16384.,
    (double)103676./3137161264. * 16384.,
    (double)72513./3137161264. * 16384.,
    (double)112327./3137161264. * 16384.,
    (double)124477./3137161264. * 16384.,
    (double)177958./3137161264. * 16384.,
    (double)96128./3137161264. * 16384.,
    (double)129206./3137161264. * 16384.,
    (double)143741./3137161264. * 16384.,
    (double)19073./3137161264. * 16384.,
    (double)119699./3137161264. * 16384.,
    (double)155049./3137161264. * 16384.,
    (double)133585./3137161264. * 16384.,
    (double)183091./3137161264. * 16384.,
    (double)182742./3137161264. * 16384.,
    (double)262869./3137161264. * 16384.,
    (double)327817./3137161264. * 16384.,
    (double)266072./3137161264. * 16384.,
    (double)143903./3137161264. * 16384.,
    (double)233188./3137161264. * 16384.,
    (double)242964./3137161264. * 16384.,
    (double)214862./3137161264. * 16384.,
    (double)115818./3137161264. * 16384.,
    (double)165210./3137161264. * 16384.,
    (double)192440./3137161264. * 16384.,
    (double)26271./3137161264. * 16384.,
    (double)96667./3137161264. * 16384.,
    (double)128998./3137161264. * 16384.,
    (double)156119./3137161264. * 16384.,
    (double)177489./3137161264. * 16384.,
    (double)88098./3137161264. * 16384.,
    (double)169379./3137161264. * 16384.,
    (double)354295./3137161264. * 16384.,
    (double)419872./3137161264. * 16384.,
    (double)147952./3137161264. * 16384.,
    (double)203431./3137161264. * 16384.,
    (double)371802./3137161264. * 16384.,
    (double)361236./3137161264. * 16384.,
    (double)228329./3137161264. * 16384.,
    (double)213887./3137161264. * 16384.,
    (double)276668./3137161264. * 16384.,
    (double)59271./3137161264. * 16384.,
    (double)226910./3137161264. * 16384.,
    (double)236289./3137161264. * 16384.,
    (double)135721./3137161264. * 16384.,
    (double)262512./3137161264. * 16384.,
    (double)118463./3137161264. * 16384.,
    (double)170100./3137161264. * 16384.,
    (double)175620./3137161264. * 16384.,
    (double)280310./3137161264. * 16384.,
    (double)148486./3137161264. * 16384.,
    (double)193121./3137161264. * 16384.,
    (double)36117./3137161264. * 16384.,
    (double)47704./3137161264. * 16384.,
    (double)27145./3137161264. * 16384.,
    (double)39830./3137161264. * 16384.,
    (double)177845./3137161264. * 16384.,
    (double)38160./3137161264. * 16384.,
    (double)119016./3137161264. * 16384.,
    (double)151456./3137161264. * 16384.,
    (double)105478./3137161264. * 16384.,
    (double)234433./3137161264. * 16384.,
    (double)114157./3137161264. * 16384.,
    (double)156719./3137161264. * 16384.,
    (double)154310./3137161264. * 16384.,
    (double)121683./3137161264. * 16384.,
    (double)79234./3137161264. * 16384.,
    (double)158688./3137161264. * 16384.,
    (double)214320./3137161264. * 16384.,
    (double)224475./3137161264. * 16384.,
    (double)120086./3137161264. * 16384.,
    (double)169928./3137161264. * 16384.,
    (double)167991./3137161264. * 16384.,
    (double)26143./3137161264. * 16384.,
    (double)124880./3137161264. * 16384.,
    (double)181767./3137161264. * 16384.,
    (double)153832./3137161264. * 16384.,
    (double)161873./3137161264. * 16384.,
    (double)147491./3137161264. * 16384.,
    (double)294790./3137161264. * 16384.,
    (double)27760./3137161264. * 16384.,
    (double)28855./3137161264. * 16384.,
    (double)11674./3137161264. * 16384.,
    (double)17339./3137161264. * 16384.,
    (double)38231./3137161264. * 16384.,
    (double)58308./3137161264. * 16384.,
    (double)26994./3137161264. * 16384.,
    (double)23895./3137161264. * 16384.,
    (double)28831./3137161264. * 16384.,
    (double)9669./3137161264. * 16384.,
    (double)17195./3137161264. * 16384.,
    (double)17740./3137161264. * 16384.,
    (double)13987./3137161264. * 16384.,
    (double)29478./3137161264. * 16384.,
    (double)13481./3137161264. * 16384.,
    (double)20169./3137161264. * 16384.,
    (double)31840./3137161264. * 16384.,
    (double)67613./3137161264. * 16384.,
    (double)19118./3137161264. * 16384.,
    (double)26316./3137161264. * 16384.,
    (double)64677./3137161264. * 16384.,
    (double)122421./3137161264. * 16384.,
    (double)63541./3137161264. * 16384.,
    (double)41730./3137161264. * 16384.,
    (double)44885./3137161264. * 16384.,
    (double)50779./3137161264. * 16384.,
    (double)52759./3137161264. * 16384.,
    (double)44065./3137161264. * 16384.,
    (double)15171./3137161264. * 16384.,
    (double)49707./3137161264. * 16384.,
    (double)18015./3137161264. * 16384.,
    (double)19809./3137161264. * 16384.,
    (double)19068./3137161264. * 16384.,
    (double)47707./3137161264. * 16384.,
    (double)21658./3137161264. * 16384.,
    (double)18016./3137161264. * 16384.,
    (double)14782./3137161264. * 16384.,
    (double)38148./3137161264. * 16384.,
    (double)22346./3137161264. * 16384.,
    (double)9630./3137161264. * 16384.,
    (double)33579./3137161264. * 16384.,
    (double)26492./3137161264. * 16384.,
    (double)42826./3137161264. * 16384.,
    (double)34953./3137161264. * 16384.,
    (double)13864./3137161264. * 16384.,
    (double)52462./3137161264. * 16384.,
    (double)28541./3137161264. * 16384.,
    (double)21177./3137161264. * 16384.,
    (double)15675./3137161264. * 16384.,
    (double)17098./3137161264. * 16384.,
    (double)8173./3137161264. * 16384.,
    (double)13750./3137161264. * 16384.,
    (double)62908./3137161264. * 16384.,
    (double)77378./3137161264. * 16384.,
    (double)28985./3137161264. * 16384.,
    (double)32201./3137161264. * 16384.,
    (double)22911./3137161264. * 16384.,
    (double)9142./3137161264. * 16384.,
    (double)26532./3137161264. * 16384.,
    (double)28020./3137161264. * 16384.,
    (double)14671./3137161264. * 16384.,
    (double)22278./3137161264. * 16384.,
    (double)18715./3137161264. * 16384.,
    (double)28385./3137161264. * 16384.,
    (double)208887./3137161264. * 16384.,
    (double)237043./3137161264. * 16384.,
    (double)110180./3137161264. * 16384.,
    (double)131642./3137161264. * 16384.,
    (double)229040./3137161264. * 16384.,
    (double)312299./3137161264. * 16384.,
    (double)183681./3137161264. * 16384.,
    (double)157949./3137161264. * 16384.,
    (double)233929./3137161264. * 16384.,
    (double)55670./3137161264. * 16384.,
    (double)155996./3137161264. * 16384.,
    (double)161877./3137161264. * 16384.,
    (double)114773./3137161264. * 16384.,
    (double)190719./3137161264. * 16384.,
    (double)121145./3137161264. * 16384.,
    (double)165567./3137161264. * 16384.,
    (double)25888./3137161264. * 16384.,
    (double)79981./3137161264. * 16384.,
    (double)22010./3137161264. * 16384.,
    (double)18242./3137161264. * 16384.,
    (double)34536./3137161264. * 16384.,
    (double)86016./3137161264. * 16384.,
    (double)48085./3137161264. * 16384.,
    (double)24931./3137161264. * 16384.,
    (double)36959./3137161264. * 16384.,
    (double)28748./3137161264. * 16384.,
    (double)50129./3137161264. * 16384.,
    (double)34450./3137161264. * 16384.,
    (double)15446./3137161264. * 16384.,
    (double)49777./3137161264. * 16384.,
    (double)22930./3137161264. * 16384.,
    (double)20446./3137161264. * 16384.,
    (double)132601./3137161264. * 16384.,
    (double)277933./3137161264. * 16384.,
    (double)131523./3137161264. * 16384.,
    (double)125084./3137161264. * 16384.,
    (double)27684./3137161264. * 16384.,
    (double)59881./3137161264. * 16384.,
    (double)35238./3137161264. * 16384.,
    (double)25307./3137161264. * 16384.,
    (double)212478./3137161264. * 16384.,
    (double)63209./3137161264. * 16384.,
    (double)120524./3137161264. * 16384.,
    (double)168328./3137161264. * 16384.,
    (double)89539./3137161264. * 16384.,
    (double)258513./3137161264. * 16384.,
    (double)136804./3137161264. * 16384.,
    (double)140579./3137161264. * 16384.,
    (double)105404./3137161264. * 16384.,
    (double)108859./3137161264. * 16384.,
    (double)68000./3137161264. * 16384.,
    (double)96959./3137161264. * 16384.,
    (double)191354./3137161264. * 16384.,
    (double)298235./3137161264. * 16384.,
    (double)160563./3137161264. * 16384.,
    (double)180396./3137161264. * 16384.,
    (double)228813./3137161264. * 16384.,
    (double)48663./3137161264. * 16384.,
    (double)219677./3137161264. * 16384.,
    (double)222122./3137161264. * 16384.,
    (double)107857./3137161264. * 16384.,
    (double)184863./3137161264. * 16384.,
    (double)155355./3137161264. * 16384.,
    (double)196459./3137161264. * 16384.,
    (double)165408./3137161264. * 16384.,
    (double)128600./3137161264. * 16384.,
    (double)72128./3137161264. * 16384.,
    (double)138462./3137161264. * 16384.,
    (double)124422./3137161264. * 16384.,
    (double)105363./3137161264. * 16384.,
    (double)63065./3137161264. * 16384.,
    (double)77938./3137161264. * 16384.,
    (double)137581./3137161264. * 16384.,
    (double)18286./3137161264. * 16384.,
    (double)72076./3137161264. * 16384.,
    (double)112987./3137161264. * 16384.,
    (double)113096./3137161264. * 16384.,
    (double)116025./3137161264. * 16384.,
    (double)65788./3137161264. * 16384.,
    (double)155435./3137161264. * 16384.,
    (double)243981./3137161264. * 16384.,
    (double)356374./3137161264. * 16384.,
    (double)131233./3137161264. * 16384.,
    (double)149153./3137161264. * 16384.,
    (double)295590./3137161264. * 16384.,
    (double)369668./3137161264. * 16384.,
    (double)198345./3137161264. * 16384.,
    (double)179433./3137161264. * 16384.,
    (double)278091./3137161264. * 16384.,
    (double)57351./3137161264. * 16384.,
    (double)214011./3137161264. * 16384.,
    (double)248423./3137161264. * 16384.,
    (double)143851./3137161264. * 16384.,
    (double)286699./3137161264. * 16384.,
    (double)141409./3137161264. * 16384.,
    (double)182450./3137161264. * 16384.,
    (double)152571./3137161264. * 16384.,
    (double)247597./3137161264. * 16384.,
    (double)159459./3137161264. * 16384.,
    (double)153534./3137161264. * 16384.,
    (double)18917./3137161264. * 16384.,
    (double)38816./3137161264. * 16384.,
    (double)23493./3137161264. * 16384.,
    (double)20178./3137161264. * 16384.,
    (double)199207./3137161264. * 16384.,
    (double)44379./3137161264. * 16384.,
    (double)170114./3137161264. * 16384.,
    (double)197439./3137161264. * 16384.,
    (double)111635./3137161264. * 16384.,
    (double)279546./3137161264. * 16384.,
    (double)155054./3137161264. * 16384.,
    (double)179676./3137161264. * 16384.,
    (double)141894./3137161264. * 16384.,
    (double)122457./3137161264. * 16384.,
    (double)84738./3137161264. * 16384.,
    (double)142026./3137161264. * 16384.,
    (double)146575./3137161264. * 16384.,
    (double)185313./3137161264. * 16384.,
    (double)111813./3137161264. * 16384.,
    (double)139373./3137161264. * 16384.,
    (double)216447./3137161264. * 16384.,
    (double)28879./3137161264. * 16384.,
    (double)208285./3137161264. * 16384.,
    (double)245478./3137161264. * 16384.,
    (double)171739./3137161264. * 16384.,
    (double)242971./3137161264. * 16384.,
    (double)195848./3137161264. * 16384.,
    (double)279188./3137161264. * 16384.,
    (double)281386./3137161264. * 16384.,
    (double)172602./3137161264. * 16384.,
    (double)111978./3137161264. * 16384.,
    (double)219430./3137161264. * 16384.,
    (double)168963./3137161264. * 16384.,
    (double)126039./3137161264. * 16384.,
    (double)79464./3137161264. * 16384.,
    (double)129063./3137161264. * 16384.,
    (double)145590./3137161264. * 16384.,
    (double)16663./3137161264. * 16384.,
    (double)70451./3137161264. * 16384.,
    (double)123434./3137161264. * 16384.,
    (double)158488./3137161264. * 16384.,
    (double)137050./3137161264. * 16384.,
    (double)75780./3137161264. * 16384.,
    (double)189803./3137161264. * 16384.,
    (double)218208./3137161264. * 16384.,
    (double)177261./3137161264. * 16384.,
    (double)80807./3137161264. * 16384.,
    (double)130500./3137161264. * 16384.,
    (double)158866./3137161264. * 16384.,
    (double)133079./3137161264. * 16384.,
    (double)83232./3137161264. * 16384.,
    (double)112004./3137161264. * 16384.,
    (double)122203./3137161264. * 16384.,
    (double)16360./3137161264. * 16384.,
    (double)72758./3137161264. * 16384.,
    (double)112112./3137161264. * 16384.,
    (double)92334./3137161264. * 16384.,
    (double)110617./3137161264. * 16384.,
    (double)58891./3137161264. * 16384.,
    (double)116603./3137161264. * 16384.,
    (double)133614./3137161264. * 16384.,
    (double)137874./3137161264. * 16384.,
    (double)76340./3137161264. * 16384.,
    (double)133629./3137161264. * 16384.,
    (double)13339./3137161264. * 16384.,
    (double)14010./3137161264. * 16384.,
    (double)8288./3137161264. * 16384.,
    (double)18261./3137161264. * 16384.,
    (double)105339./3137161264. * 16384.,
    (double)13485./3137161264. * 16384.,
    (double)59787./3137161264. * 16384.,
    (double)91927./3137161264. * 16384.,
    (double)81254./3137161264. * 16384.,
    (double)112345./3137161264. * 16384.,
    (double)67048./3137161264. * 16384.,
    (double)114644./3137161264. * 16384.,
    (double)151891./3137161264. * 16384.,
    (double)97220./3137161264. * 16384.,
    (double)72737./3137161264. * 16384.,
    (double)171727./3137161264. * 16384.,
    (double)119824./3137161264. * 16384.,
    (double)104297./3137161264. * 16384.,
    (double)69179./3137161264. * 16384.,
    (double)137816./3137161264. * 16384.,
    (double)113907./3137161264. * 16384.,
    (double)11683./3137161264. * 16384.,
    (double)69645./3137161264. * 16384.,
    (double)124049./3137161264. * 16384.,
    (double)147989./3137161264. * 16384.,
    (double)116083./3137161264. * 16384.,
    (double)105907./3137161264. * 16384.,
    (double)267048./3137161264. * 16384.,
    (double)275017./3137161264. * 16384.,
    (double)207367./3137161264. * 16384.,
    (double)101392./3137161264. * 16384.,
    (double)172026./3137161264. * 16384.,
    (double)241842./3137161264. * 16384.,
    (double)260660./3137161264. * 16384.,
    (double)143429./3137161264. * 16384.,
    (double)157714./3137161264. * 16384.,
    (double)206043./3137161264. * 16384.,
    (double)32767./3137161264. * 16384.,
    (double)111703./3137161264. * 16384.,
    (double)158749./3137161264. * 16384.,
    (double)143967./3137161264. * 16384.,
    (double)211385./3137161264. * 16384.,
    (double)91995./3137161264. * 16384.,
    (double)178033./3137161264. * 16384.,
    (double)237562./3137161264. * 16384.,
    (double)275965./3137161264. * 16384.,
    (double)97705./3137161264. * 16384.,
    (double)149272./3137161264. * 16384.,
    (double)307654./3137161264. * 16384.,
    (double)359638./3137161264. * 16384.,
    (double)175880./3137161264. * 16384.,
    (double)184003./3137161264. * 16384.,
    (double)237132./3137161264. * 16384.,
    (double)58456./3137161264. * 16384.,
    (double)155105./3137161264. * 16384.,
    (double)214615./3137161264. * 16384.,
    (double)137774./3137161264. * 16384.,
    (double)264919./3137161264. * 16384.,
    (double)105980./3137161264. * 16384.,
    (double)162637./3137161264. * 16384.,
    (double)121416./3137161264. * 16384.,
    (double)194556./3137161264. * 16384.,
    (double)90405./3137161264. * 16384.,
    (double)115599./3137161264. * 16384.,
    (double)22382./3137161264. * 16384.,
    (double)38987./3137161264. * 16384.,
    (double)19753./3137161264. * 16384.,
    (double)21762./3137161264. * 16384.,
    (double)165458./3137161264. * 16384.,
    (double)31629./3137161264. * 16384.,
    (double)124942./3137161264. * 16384.,
    (double)148841./3137161264. * 16384.,
    (double)106287./3137161264. * 16384.,
    (double)224567./3137161264. * 16384.,
    (double)125557./3137161264. * 16384.,
    (double)147650./3137161264. * 16384.,
    (double)103726./3137161264. * 16384.,
    (double)91627./3137161264. * 16384.,
    (double)62329./3137161264. * 16384.,
    (double)109454./3137161264. * 16384.,
    (double)180294./3137161264. * 16384.,
    (double)224986./3137161264. * 16384.,
    (double)113184./3137161264. * 16384.,
    (double)185842./3137161264. * 16384.,
    (double)146184./3137161264. * 16384.,
    (double)20676./3137161264. * 16384.,
    (double)114907./3137161264. * 16384.,
    (double)156571./3137161264. * 16384.,
    (double)118017./3137161264. * 16384.,
    (double)142996./3137161264. * 16384.,
    (double)118888./3137161264. * 16384.,
    (double)215054./3137161264. * 16384.,
    (double)169136./3137161264. * 16384.,
    (double)138899./3137161264. * 16384.,
    (double)73817./3137161264. * 16384.,
    (double)104866./3137161264. * 16384.,
    (double)180286./3137161264. * 16384.,
    (double)183908./3137161264. * 16384.,
    (double)119470./3137161264. * 16384.,
    (double)130497./3137161264. * 16384.,
    (double)191654./3137161264. * 16384.,
    (double)30777./3137161264. * 16384.,
    (double)109534./3137161264. * 16384.,
    (double)142140./3137161264. * 16384.,
    (double)114626./3137161264. * 16384.,
    (double)142131./3137161264. * 16384.,
    (double)99858./3137161264. * 16384.,
    (double)166372./3137161264. * 16384.,
    (double)13124./3137161264. * 16384.,
    (double)23550./3137161264. * 16384.,
    (double)8079./3137161264. * 16384.,
    (double)11387./3137161264. * 16384.,
    (double)15738./3137161264. * 16384.,
    (double)33463./3137161264. * 16384.,
    (double)17332./3137161264. * 16384.,
    (double)14098./3137161264. * 16384.,
    (double)16409./3137161264. * 16384.,
    (double)7323./3137161264. * 16384.,
    (double)15876./3137161264. * 16384.,
    (double)17346./3137161264. * 16384.,
    (double)10579./3137161264. * 16384.,
    (double)23030./3137161264. * 16384.,
    (double)12180./3137161264. * 16384.,
    (double)15370./3137161264. * 16384.,
    (double)92972./3137161264. * 16384.,
    (double)142753./3137161264. * 16384.,
    (double)79820./3137161264. * 16384.,
    (double)95630./3137161264. * 16384.,
    (double)12818./3137161264. * 16384.,
    (double)20145./3137161264. * 16384.,
    (double)14425./3137161264. * 16384.,
    (double)15723./3137161264. * 16384.,
    (double)151207./3137161264. * 16384.,
    (double)30302./3137161264. * 16384.,
    (double)110338./3137161264. * 16384.,
    (double)142740./3137161264. * 16384.,
    (double)81568./3137161264. * 16384.,
    (double)168690./3137161264. * 16384.,
    (double)111286./3137161264. * 16384.,
    (double)129463./3137161264. * 16384.,
    (double)92084./3137161264. * 16384.,
    (double)87160./3137161264. * 16384.,
    (double)58956./3137161264. * 16384.,
    (double)92899./3137161264. * 16384.,
    (double)139842./3137161264. * 16384.,
    (double)162810./3137161264. * 16384.,
    (double)108829./3137161264. * 16384.,
    (double)148867./3137161264. * 16384.,
    (double)184263./3137161264. * 16384.,
    (double)39646./3137161264. * 16384.,
    (double)142589./3137161264. * 16384.,
    (double)182559./3137161264. * 16384.,
    (double)110740./3137161264. * 16384.,
    (double)158486./3137161264. * 16384.,
    (double)135770./3137161264. * 16384.,
    (double)195350./3137161264. * 16384.,
    (double)206554./3137161264. * 16384.,
    (double)127770./3137161264. * 16384.,
    (double)75122./3137161264. * 16384.,
    (double)144574./3137161264. * 16384.,
    (double)117297./3137161264. * 16384.,
    (double)100628./3137161264. * 16384.,
    (double)60923./3137161264. * 16384.,
    (double)83730./3137161264. * 16384.,
    (double)138026./3137161264. * 16384.,
    (double)14173./3137161264. * 16384.,
    (double)71037./3137161264. * 16384.,
    (double)105701./3137161264. * 16384.,
    (double)135266./3137161264. * 16384.,
    (double)110526./3137161264. * 16384.,
    (double)82046./3137161264. * 16384.,
    (double)184761./3137161264. * 16384.,
    (double)163666./3137161264. * 16384.,
    (double)147519./3137161264. * 16384.,
    (double)70362./3137161264. * 16384.,
    (double)106911./3137161264. * 16384.,
    (double)146591./3137161264. * 16384.,
    (double)168678./3137161264. * 16384.,
    (double)94259./3137161264. * 16384.,
    (double)119796./3137161264. * 16384.,
    (double)156998./3137161264. * 16384.,
    (double)18653./3137161264. * 16384.,
    (double)96287./3137161264. * 16384.,
    (double)132063./3137161264. * 16384.,
    (double)112228./3137161264. * 16384.,
    (double)139672./3137161264. * 16384.,
    (double)90388./3137161264. * 16384.,
    (double)160282./3137161264. * 16384.,
    (double)142188./3137161264. * 16384.,
    (double)145637./3137161264. * 16384.,
    (double)94472./3137161264. * 16384.,
    (double)132358./3137161264. * 16384.,
    (double)13309./3137161264. * 16384.,
    (double)14951./3137161264. * 16384.,
    (double)9629./3137161264. * 16384.,
    (double)15256./3137161264. * 16384.,
    (double)147280./3137161264. * 16384.,
    (double)18584./3137161264. * 16384.,
    (double)114000./3137161264. * 16384.,
    (double)154173./3137161264. * 16384.,
    (double)115488./3137161264. * 16384.,
    (double)183737./3137161264. * 16384.,
    (double)143226./3137161264. * 16384.,
    (double)180405./3137161264. * 16384.,
    (double)184491./3137161264. * 16384.,
    (double)121024./3137161264. * 16384.,
    (double)96110./3137161264. * 16384.,
    (double)191575./3137161264. * 16384.,
    (double)165493./3137161264. * 16384.,
    (double)189301./3137161264. * 16384.,
    (double)122482./3137161264. * 16384.,
    (double)183947./3137161264. * 16384.,
    (double)215547./3137161264. * 16384.,
    (double)21959./3137161264. * 16384.,
    (double)176176./3137161264. * 16384.,
    (double)261015./3137161264. * 16384.,
    (double)256395./3137161264. * 16384.,
    (double)253776./3137161264. * 16384.,
    (double)244965./3137161264. * 16384.,
    (double)331459./3137161264. * 16384.,
    (double)409537./3137161264. * 16384.,
    (double)286418./3137161264. * 16384.,
    (double)237592./3137161264. * 16384.,
    (double)366261./3137161264. * 16384.,
    (double)317736./3137161264. * 16384.,
    (double)249469./3137161264. * 16384.,
    (double)192808./3137161264. * 16384.,
    (double)212573./3137161264. * 16384.,
    (double)263598./3137161264. * 16384.,
    (double)31373./3137161264. * 16384.,
    (double)125505./3137161264. * 16384.,
    (double)196449./3137161264. * 16384.,
    (double)302603./3137161264. * 16384.,
    (double)272476./3137161264. * 16384.,
    (double)154631./3137161264. * 16384.,
    (double)265342./3137161264. * 16384.,
    (double)276604./3137161264. * 16384.,
    (double)226409./3137161264. * 16384.,
    (double)161453./3137161264. * 16384.,
    (double)170264./3137161264. * 16384.,
    (double)219095./3137161264. * 16384.,
    (double)161963./3137161264. * 16384.,
    (double)147789./3137161264. * 16384.,
    (double)136908./3137161264. * 16384.,
    (double)173614./3137161264. * 16384.,
    (double)24438./3137161264. * 16384.,
    (double)114637./3137161264. * 16384.,
    (double)136868./3137161264. * 16384.,
    (double)132542./3137161264. * 16384.,
    (double)167334./3137161264. * 16384.,
    (double)126565./3137161264. * 16384.,
    (double)168229./3137161264. * 16384.,
    (double)197674./3137161264. * 16384.,
    (double)191742./3137161264. * 16384.,
    (double)121533./3137161264. * 16384.,
    (double)179395./3137161264. * 16384.,
    (double)20732./3137161264. * 16384.,
    (double)21086./3137161264. * 16384.,
    (double)16452./3137161264. * 16384.,
    (double)27799./3137161264. * 16384.,
    (double)135932./3137161264. * 16384.,
    (double)17906./3137161264. * 16384.,
    (double)91204./3137161264. * 16384.,
    (double)146215./3137161264. * 16384.,
    (double)104028./3137161264. * 16384.,
    (double)147551./3137161264. * 16384.,
    (double)105123./3137161264. * 16384.,
    (double)158198./3137161264. * 16384.,
    (double)228472./3137161264. * 16384.,
    (double)129401./3137161264. * 16384.,
    (double)101325./3137161264. * 16384.,
    (double)190639./3137161264. * 16384.,
    (double)204539./3137161264. * 16384.,
    (double)168778./3137161264. * 16384.,
    (double)126009./3137161264. * 16384.,
    (double)174166./3137161264. * 16384.,
    (double)140378./3137161264. * 16384.,
    (double)14844./3137161264. * 16384.,
    (double)103094./3137161264. * 16384.,
    (double)134502./3137161264. * 16384.,
    (double)176836./3137161264. * 16384.,
    (double)124889./3137161264. * 16384.,
    (double)147801./3137161264. * 16384.,
    (double)259260./3137161264. * 16384.,
    (double)411062./3137161264. * 16384.,
    (double)323231./3137161264. * 16384.,
    (double)171276./3137161264. * 16384.,
    (double)253460./3137161264. * 16384.,
    (double)366523./3137161264. * 16384.,
    (double)345566./3137161264. * 16384.,
    (double)243720./3137161264. * 16384.,
    (double)214620./3137161264. * 16384.,
    (double)230060./3137161264. * 16384.,
    (double)37740./3137161264. * 16384.,
    (double)111674./3137161264. * 16384.,
    (double)141250./3137161264. * 16384.,
    (double)174452./3137161264. * 16384.,
    (double)233484./3137161264. * 16384.,
    (double)112292./3137161264. * 16384.,
    (double)185239./3137161264. * 16384.,
    (double)316769./3137161264. * 16384.,
    (double)354651./3137161264. * 16384.,
    (double)152436./3137161264. * 16384.,
    (double)172652./3137161264. * 16384.,
    (double)294439./3137161264. * 16384.,
    (double)245465./3137161264. * 16384.,
    (double)224471./3137161264. * 16384.,
    (double)175899./3137161264. * 16384.,
    (double)268625./3137161264. * 16384.,
    (double)60067./3137161264. * 16384.,
    (double)155931./3137161264. * 16384.,
    (double)194434./3137161264. * 16384.,
    (double)139630./3137161264. * 16384.,
    (double)257935./3137161264. * 16384.,
    (double)120659./3137161264. * 16384.,
    (double)151768./3137161264. * 16384.,
    (double)225159./3137161264. * 16384.,
    (double)326605./3137161264. * 16384.,
    (double)166842./3137161264. * 16384.,
    (double)204241./3137161264. * 16384.,
    (double)35571./3137161264. * 16384.,
    (double)55280./3137161264. * 16384.,
    (double)38609./3137161264. * 16384.,
    (double)38595./3137161264. * 16384.,
    (double)258094./3137161264. * 16384.,
    (double)54565./3137161264. * 16384.,
    (double)202452./3137161264. * 16384.,
    (double)259042./3137161264. * 16384.,
    (double)130226./3137161264. * 16384.,
    (double)292150./3137161264. * 16384.,
    (double)184827./3137161264. * 16384.,
    (double)198661./3137161264. * 16384.,
    (double)168225./3137161264. * 16384.,
    (double)133820./3137161264. * 16384.,
    (double)79469./3137161264. * 16384.,
    (double)135703./3137161264. * 16384.,
    (double)284399./3137161264. * 16384.,
    (double)287352./3137161264. * 16384.,
    (double)153815./3137161264. * 16384.,
    (double)197414./3137161264. * 16384.,
    (double)167962./3137161264. * 16384.,
    (double)21568./3137161264. * 16384.,
    (double)107339./3137161264. * 16384.,
    (double)152621./3137161264. * 16384.,
    (double)143183./3137161264. * 16384.,
    (double)147938./3137161264. * 16384.,
    (double)135756./3137161264. * 16384.,
    (double)244982./3137161264. * 16384.,
    (double)228322./3137161264. * 16384.,
    (double)148189./3137161264. * 16384.,
    (double)96752./3137161264. * 16384.,
    (double)155634./3137161264. * 16384.,
    (double)271997./3137161264. * 16384.,
    (double)221581./3137161264. * 16384.,
    (double)190369./3137161264. * 16384.,
    (double)192635./3137161264. * 16384.,
    (double)295315./3137161264. * 16384.,
    (double)51448./3137161264. * 16384.,
    (double)108510./3137161264. * 16384.,
    (double)139475./3137161264. * 16384.,
    (double)187666./3137161264. * 16384.,
    (double)215845./3137161264. * 16384.,
    (double)119503./3137161264. * 16384.,
    (double)200718./3137161264. * 16384.,
    (double)22577./3137161264. * 16384.,
    (double)30884./3137161264. * 16384.,
    (double)14667./3137161264. * 16384.,
    (double)24950./3137161264. * 16384.,
    (double)29323./3137161264. * 16384.,
    (double)36279./3137161264. * 16384.,
    (double)29444./3137161264. * 16384.,
    (double)27731./3137161264. * 16384.,
    (double)39638./3137161264. * 16384.,
    (double)14612./3137161264. * 16384.,
    (double)24759./3137161264. * 16384.,
    (double)25782./3137161264. * 16384.,
    (double)26676./3137161264. * 16384.,
    (double)64718./3137161264. * 16384.,
    (double)24296./3137161264. * 16384.,
    (double)33898./3137161264. * 16384.,
    (double)136951./3137161264. * 16384.,
    (double)156182./3137161264. * 16384.,
    (double)124601./3137161264. * 16384.,
    (double)138960./3137161264. * 16384.,
    (double)22550./3137161264. * 16384.,
    (double)25867./3137161264. * 16384.,
    (double)25937./3137161264. * 16384.,
    (double)28221./3137161264. * 16384.,
    (double)168765./3137161264. * 16384.,
    (double)39380./3137161264. * 16384.,
    (double)107412./3137161264. * 16384.,
    (double)117650./3137161264. * 16384.,
    (double)98787./3137161264. * 16384.,
    (double)202168./3137161264. * 16384.,
    (double)115360./3137161264. * 16384.,
    (double)129019./3137161264. * 16384.,
    (double)112649./3137161264. * 16384.,
    (double)78925./3137161264. * 16384.,
    (double)65138./3137161264. * 16384.,
    (double)105907./3137161264. * 16384.,
    (double)182287./3137161264. * 16384.,
    (double)184118./3137161264. * 16384.,
    (double)148901./3137161264. * 16384.,
    (double)184189./3137161264. * 16384.,
    (double)152583./3137161264. * 16384.,
    (double)22993./3137161264. * 16384.,
    (double)140873./3137161264. * 16384.,
    (double)135540./3137161264. * 16384.,
    (double)138653./3137161264. * 16384.,
    (double)143417./3137161264. * 16384.,
    (double)134811./3137161264. * 16384.,
    (double)236296./3137161264. * 16384.,
    (double)231047./3137161264. * 16384.,
    (double)117687./3137161264. * 16384.,
    (double)86060./3137161264. * 16384.,
    (double)170763./3137161264. * 16384.,
    (double)136922./3137161264. * 16384.,
    (double)95062./3137161264. * 16384.,
    (double)88575./3137161264. * 16384.,
    (double)113913./3137161264. * 16384.,
    (double)157734./3137161264. * 16384.,
    (double)18760./3137161264. * 16384.,
    (double)64720./3137161264. * 16384.,
    (double)97613./3137161264. * 16384.,
    (double)208499./3137161264. * 16384.,
    (double)168022./3137161264. * 16384.,
    (double)98136./3137161264. * 16384.,
    (double)222807./3137161264. * 16384.,
    (double)200097./3137161264. * 16384.,
    (double)192462./3137161264. * 16384.,
    (double)103245./3137161264. * 16384.,
    (double)148111./3137161264. * 16384.,
    (double)171134./3137161264. * 16384.,
    (double)158179./3137161264. * 16384.,
    (double)136956./3137161264. * 16384.,
    (double)151965./3137161264. * 16384.,
    (double)197445./3137161264. * 16384.,
    (double)32666./3137161264. * 16384.,
    (double)108522./3137161264. * 16384.,
    (double)143121./3137161264. * 16384.,
    (double)162103./3137161264. * 16384.,
    (double)240317./3137161264. * 16384.,
    (double)117789./3137161264. * 16384.,
    (double)187738./3137161264. * 16384.,
    (double)139052./3137161264. * 16384.,
    (double)159668./3137161264. * 16384.,
    (double)128199./3137161264. * 16384.,
    (double)160417./3137161264. * 16384.,
    (double)16427./3137161264. * 16384.,
    (double)17899./3137161264. * 16384.,
    (double)17904./3137161264. * 16384.,
    (double)23226./3137161264. * 16384.,
    (double)152659./3137161264. * 16384.,
    (double)21705./3137161264. * 16384.,
    (double)121911./3137161264. * 16384.,
    (double)158491./3137161264. * 16384.,
    (double)125931./3137161264. * 16384.,
    (double)196671./3137161264. * 16384.,
    (double)154029./3137161264. * 16384.,
    (double)190384./3137161264. * 16384.,
    (double)185790./3137161264. * 16384.,
    (double)120606./3137161264. * 16384.,
    (double)99678./3137161264. * 16384.,
    (double)195554./3137161264. * 16384.,
    (double)138340./3137161264. * 16384.,
    (double)118023./3137161264. * 16384.,
    (double)119178./3137161264. * 16384.,
    (double)165116./3137161264. * 16384.,
    (double)204337./3137161264. * 16384.,
    (double)22255./3137161264. * 16384.,
    (double)156949./3137161264. * 16384.,
    (double)211682./3137161264. * 16384.,
    (double)274887./3137161264. * 16384.,
    (double)253896./3137161264. * 16384.,
    (double)262728./3137161264. * 16384.,
    (double)444316./3137161264. * 16384.,
    (double)23974./3137161264. * 16384.,
    (double)23273./3137161264. * 16384.,
    (double)23119./3137161264. * 16384.,
    (double)19385./3137161264. * 16384.,
    (double)23635./3137161264. * 16384.,
    (double)28723./3137161264. * 16384.,
    (double)17929./3137161264. * 16384.,
    (double)17689./3137161264. * 16384.,
    (double)15976./3137161264. * 16384.,
    (double)4102./3137161264. * 16384.,
    (double)9890./3137161264. * 16384.,
    (double)12036./3137161264. * 16384.,
    (double)14113./3137161264. * 16384.,
    (double)19776./3137161264. * 16384.,
    (double)11378./3137161264. * 16384.,
    (double)15491./3137161264. * 16384.,
    (double)29380./3137161264. * 16384.,
    (double)36478./3137161264. * 16384.,
    (double)38961./3137161264. * 16384.,
    (double)21491./3137161264. * 16384.,
    (double)36489./3137161264. * 16384.,
    (double)41896./3137161264. * 16384.,
    (double)39980./3137161264. * 16384.,
    (double)24534./3137161264. * 16384.,
    (double)23836./3137161264. * 16384.,
    (double)13192./3137161264. * 16384.,
    (double)25007./3137161264. * 16384.,
    (double)20658./3137161264. * 16384.,
    (double)12004./3137161264. * 16384.,
    (double)27526./3137161264. * 16384.,
    (double)16763./3137161264. * 16384.,
    (double)16653./3137161264. * 16384.,
    (double)15042./3137161264. * 16384.,
    (double)32070./3137161264. * 16384.,
    (double)14835./3137161264. * 16384.,
    (double)14691./3137161264. * 16384.,
    (double)4223./3137161264. * 16384.,
    (double)8493./3137161264. * 16384.,
    (double)6382./3137161264. * 16384.,
    (double)4707./3137161264. * 16384.,
    (double)14850./3137161264. * 16384.,
    (double)5900./3137161264. * 16384.,
    (double)16639./3137161264. * 16384.,
    (double)16519./3137161264. * 16384.,
    (double)9100./3137161264. * 16384.,
    (double)20012./3137161264. * 16384.,
    (double)14866./3137161264. * 16384.,
    (double)16071./3137161264. * 16384.,
    (double)14909./3137161264. * 16384.,
    (double)12462./3137161264. * 16384.,
    (double)9491./3137161264. * 16384.,
    (double)14348./3137161264. * 16384.,
    (double)22397./3137161264. * 16384.,
    (double)27376./3137161264. * 16384.,
    (double)18311./3137161264. * 16384.,
    (double)19597./3137161264. * 16384.,
    (double)15050./3137161264. * 16384.,
    (double)3432./3137161264. * 16384.,
    (double)14146./3137161264. * 16384.,
    (double)16115./3137161264. * 16384.,
    (double)15975./3137161264. * 16384.,
    (double)14480./3137161264. * 16384.,
    (double)18154./3137161264. * 16384.,
    (double)24300./3137161264. * 16384.,
    (double)25706./3137161264. * 16384.,
    (double)35513./3137161264. * 16384.,
    (double)14869./3137161264. * 16384.,
    (double)15932./3137161264. * 16384.,
    (double)34366./3137161264. * 16384.,
    (double)61387./3137161264. * 16384.,
    (double)35224./3137161264. * 16384.,
    (double)20968./3137161264. * 16384.,
    (double)19922./3137161264. * 16384.,
    (double)9758./3137161264. * 16384.,
    (double)14181./3137161264. * 16384.,
    (double)13287./3137161264. * 16384.,
    (double)10493./3137161264. * 16384.,
    (double)23060./3137161264. * 16384.,
    (double)14987./3137161264. * 16384.,
    (double)13004./3137161264. * 16384.,
    (double)37788./3137161264. * 16384.,
    (double)67347./3137161264. * 16384.,
    (double)26106./3137161264. * 16384.,
    (double)20261./3137161264. * 16384.,
    (double)63231./3137161264. * 16384.,
    (double)73761./3137161264. * 16384.,
    (double)69190./3137161264. * 16384.,
    (double)36212./3137161264. * 16384.,
    (double)45111./3137161264. * 16384.,
    (double)37301./3137161264. * 16384.,
    (double)33669./3137161264. * 16384.,
    (double)30868./3137161264. * 16384.,
    (double)16203./3137161264. * 16384.,
    (double)49339./3137161264. * 16384.,
    (double)20983./3137161264. * 16384.,
    (double)18018./3137161264. * 16384.,
    (double)19641./3137161264. * 16384.,
    (double)50410./3137161264. * 16384.,
    (double)22821./3137161264. * 16384.,
    (double)19058./3137161264. * 16384.,
    (double)11386./3137161264. * 16384.,
    (double)47133./3137161264. * 16384.,
    (double)25394./3137161264. * 16384.,
    (double)9646./3137161264. * 16384.,
    (double)36280./3137161264. * 16384.,
    (double)28905./3137161264. * 16384.,
    (double)39478./3137161264. * 16384.,
    (double)32541./3137161264. * 16384.,
    (double)11836./3137161264. * 16384.,
    (double)50845./3137161264. * 16384.,
    (double)33143./3137161264. * 16384.,
    (double)24078./3137161264. * 16384.,
    (double)13877./3137161264. * 16384.,
    (double)15269./3137161264. * 16384.,
    (double)8884./3137161264. * 16384.,
    (double)11408./3137161264. * 16384.,
    (double)30793./3137161264. * 16384.,
    (double)50971./3137161264. * 16384.,
    (double)26051./3137161264. * 16384.,
    (double)22085./3137161264. * 16384.,
    (double)19497./3137161264. * 16384.,
    (double)6207./3137161264. * 16384.,
    (double)17239./3137161264. * 16384.,
    (double)16523./3137161264. * 16384.,
    (double)11522./3137161264. * 16384.,
    (double)17964./3137161264. * 16384.,
    (double)15835./3137161264. * 16384.,
    (double)22969./3137161264. * 16384.,
    (double)15542./3137161264. * 16384.,
    (double)16701./3137161264. * 16384.,
    (double)9134./3137161264. * 16384.,
    (double)14174./3137161264. * 16384.,
    (double)26232./3137161264. * 16384.,
    (double)40227./3137161264. * 16384.,
    (double)32082./3137161264. * 16384.,
    (double)21700./3137161264. * 16384.,
    (double)30001./3137161264. * 16384.,
    (double)13948./3137161264. * 16384.,
    (double)18400./3137161264. * 16384.,
    (double)14774./3137161264. * 16384.,
    (double)11262./3137161264. * 16384.,
    (double)27983./3137161264. * 16384.,
    (double)13387./3137161264. * 16384.,
    (double)15144./3137161264. * 16384.,
    (double)4036./3137161264. * 16384.,
    (double)11515./3137161264. * 16384.,
    (double)5117./3137161264. * 16384.,
    (double)8228./3137161264. * 16384.,
    (double)11223./3137161264. * 16384.,
    (double)28776./3137161264. * 16384.,
    (double)23711./3137161264. * 16384.,
    (double)9533./3137161264. * 16384.,
    (double)14868./3137161264. * 16384.,
    (double)24454./3137161264. * 16384.,
    (double)18412./3137161264. * 16384.,
    (double)10999./3137161264. * 16384.,
    (double)3058./3137161264. * 16384.,
    (double)16768./3137161264. * 16384.,
    (double)7567./3137161264. * 16384.,
    (double)4781./3137161264. * 16384.,
    (double)15491./3137161264. * 16384.,
    (double)31498./3137161264. * 16384.,
    (double)29353./3137161264. * 16384.,
    (double)21630./3137161264. * 16384.,
    (double)8591./3137161264. * 16384.,
    (double)21601./3137161264. * 16384.,
    (double)22765./3137161264. * 16384.,
    (double)8646./3137161264. * 16384.,
    (double)41242./3137161264. * 16384.,
    (double)36773./3137161264. * 16384.,
    (double)36680./3137161264. * 16384.,
    (double)27179./3137161264. * 16384.,
    (double)12499./3137161264. * 16384.,
    (double)56495./3137161264. * 16384.,
    (double)28872./3137161264. * 16384.,
    (double)20353./3137161264. * 16384.,
    (double)11997./3137161264. * 16384.,
    (double)10858./3137161264. * 16384.,
    (double)9652./3137161264. * 16384.,
    (double)12383./3137161264. * 16384.,
    (double)25631./3137161264. * 16384.,
    (double)44078./3137161264. * 16384.,
    (double)35826./3137161264. * 16384.,
    (double)26753./3137161264. * 16384.,
    (double)24685./3137161264. * 16384.,
    (double)10824./3137161264. * 16384.,
    (double)30109./3137161264. * 16384.,
    (double)23446./3137161264. * 16384.,
    (double)11914./3137161264. * 16384.,
    (double)20599./3137161264. * 16384.,
    (double)20859./3137161264. * 16384.,
    (double)24975./3137161264. * 16384.,
    (double)16636./3137161264. * 16384.,
    (double)16873./3137161264. * 16384.,
    (double)9745./3137161264. * 16384.,
    (double)14355./3137161264. * 16384.,
    (double)14234./3137161264. * 16384.,
    (double)14911./3137161264. * 16384.,
    (double)11475./3137161264. * 16384.,
    (double)11841./3137161264. * 16384.,
    (double)14694./3137161264. * 16384.,
    (double)2932./3137161264. * 16384.,
    (double)7817./3137161264. * 16384.,
    (double)9666./3137161264. * 16384.,
    (double)15962./3137161264. * 16384.,
    (double)18739./3137161264. * 16384.,
    (double)11359./3137161264. * 16384.,
    (double)19948./3137161264. * 16384.,
    (double)28913./3137161264. * 16384.,
    (double)55394./3137161264. * 16384.,
    (double)19876./3137161264. * 16384.,
    (double)25746./3137161264. * 16384.,
    (double)34572./3137161264. * 16384.,
    (double)48388./3137161264. * 16384.,
    (double)36502./3137161264. * 16384.,
    (double)34498./3137161264. * 16384.,
    (double)38103./3137161264. * 16384.,
    (double)15808./3137161264. * 16384.,
    (double)23676./3137161264. * 16384.,
    (double)25531./3137161264. * 16384.,
    (double)21751./3137161264. * 16384.,
    (double)61465./3137161264. * 16384.,
    (double)22968./3137161264. * 16384.,
    (double)26896./3137161264. * 16384.,
    (double)12807./3137161264. * 16384.,
    (double)24538./3137161264. * 16384.,
    (double)17766./3137161264. * 16384.,
    (double)17123./3137161264. * 16384.,
    (double)3056./3137161264. * 16384.,
    (double)7510./3137161264. * 16384.,
    (double)5947./3137161264. * 16384.,
    (double)4301./3137161264. * 16384.,
    (double)22618./3137161264. * 16384.,
    (double)9234./3137161264. * 16384.,
    (double)25799./3137161264. * 16384.,
    (double)26757./3137161264. * 16384.,
    (double)13059./3137161264. * 16384.,
    (double)32350./3137161264. * 16384.,
    (double)26683./3137161264. * 16384.,
    (double)23912./3137161264. * 16384.,
    (double)15472./3137161264. * 16384.,
    (double)14433./3137161264. * 16384.,
    (double)10095./3137161264. * 16384.,
    (double)15676./3137161264. * 16384.,
    (double)15401./3137161264. * 16384.,
    (double)21059./3137161264. * 16384.,
    (double)15416./3137161264. * 16384.,
    (double)17544./3137161264. * 16384.,
    (double)22045./3137161264. * 16384.,
    (double)4458./3137161264. * 16384.,
    (double)21175./3137161264. * 16384.,
    (double)24455./3137161264. * 16384.,
    (double)20256./3137161264. * 16384.,
    (double)27425./3137161264. * 16384.,
    (double)27617./3137161264. * 16384.,
    (double)36846./3137161264. * 16384.,
    (double)263071./3137161264. * 16384.,
    (double)205321./3137161264. * 16384.,
    (double)141003./3137161264. * 16384.,
    (double)208458./3137161264. * 16384.,
    (double)224235./3137161264. * 16384.,
    (double)229174./3137161264. * 16384.,
    (double)136783./3137161264. * 16384.,
    (double)156257./3137161264. * 16384.,
    (double)170218./3137161264. * 16384.,
    (double)23991./3137161264. * 16384.,
    (double)90862./3137161264. * 16384.,
    (double)120296./3137161264. * 16384.,
    (double)135003./3137161264. * 16384.,
    (double)136477./3137161264. * 16384.,
    (double)86472./3137161264. * 16384.,
    (double)142895./3137161264. * 16384.,
    (double)228393./3137161264. * 16384.,
    (double)238304./3137161264. * 16384.,
    (double)133021./3137161264. * 16384.,
    (double)152160./3137161264. * 16384.,
    (double)266969./3137161264. * 16384.,
    (double)242841./3137161264. * 16384.,
    (double)257028./3137161264. * 16384.,
    (double)175491./3137161264. * 16384.,
    (double)218100./3137161264. * 16384.,
    (double)41963./3137161264. * 16384.,
    (double)186947./3137161264. * 16384.,
    (double)177040./3137161264. * 16384.,
    (double)109402./3137161264. * 16384.,
    (double)192196./3137161264. * 16384.,
    (double)115731./3137161264. * 16384.,
    (double)145384./3137161264. * 16384.,
    (double)163439./3137161264. * 16384.,
    (double)262816./3137161264. * 16384.,
    (double)157138./3137161264. * 16384.,
    (double)192655./3137161264. * 16384.,
    (double)29753./3137161264. * 16384.,
    (double)49355./3137161264. * 16384.,
    (double)35671./3137161264. * 16384.,
    (double)48346./3137161264. * 16384.,
    (double)267222./3137161264. * 16384.,
    (double)102281./3137161264. * 16384.,
    (double)147012./3137161264. * 16384.,
    (double)176065./3137161264. * 16384.,
    (double)108124./3137161264. * 16384.,
    (double)309978./3137161264. * 16384.,
    (double)129344./3137161264. * 16384.,
    (double)164458./3137161264. * 16384.,
    (double)140103./3137161264. * 16384.,
    (double)103601./3137161264. * 16384.,
    (double)74001./3137161264. * 16384.,
    (double)139205./3137161264. * 16384.,
    (double)170665./3137161264. * 16384.,
    (double)181092./3137161264. * 16384.,
    (double)129105./3137161264. * 16384.,
    (double)183371./3137161264. * 16384.,
    (double)160206./3137161264. * 16384.,
    (double)27109./3137161264. * 16384.,
    (double)123073./3137161264. * 16384.,
    (double)184179./3137161264. * 16384.,
    (double)142721./3137161264. * 16384.,
    (double)150832./3137161264. * 16384.,
    (double)144991./3137161264. * 16384.,
    (double)263784./3137161264. * 16384.,
    (double)21390./3137161264. * 16384.,
    (double)27290./3137161264. * 16384.,
    (double)11653./3137161264. * 16384.,
    (double)16866./3137161264. * 16384.,
    (double)41785./3137161264. * 16384.,
    (double)74369./3137161264. * 16384.,
    (double)29807./3137161264. * 16384.,
    (double)24838./3137161264. * 16384.,
    (double)18688./3137161264. * 16384.,
    (double)7372./3137161264. * 16384.,
    (double)15986./3137161264. * 16384.,
    (double)17821./3137161264. * 16384.,
    (double)10966./3137161264. * 16384.,
    (double)19764./3137161264. * 16384.,
    (double)9888./3137161264. * 16384.,
    (double)15631./3137161264. * 16384.,
    (double)23141./3137161264. * 16384.,
    (double)36191./3137161264. * 16384.,
    (double)15979./3137161264. * 16384.,
    (double)14617./3137161264. * 16384.,
    (double)46650./3137161264. * 16384.,
    (double)59561./3137161264. * 16384.,
    (double)58110./3137161264. * 16384.,
    (double)30281./3137161264. * 16384.,
    (double)31551./3137161264. * 16384.,
    (double)21193./3137161264. * 16384.,
    (double)41476./3137161264. * 16384.,
    (double)33023./3137161264. * 16384.,
    (double)11897./3137161264. * 16384.,
    (double)29557./3137161264. * 16384.,
    (double)15623./3137161264. * 16384.,
    (double)14883./3137161264. * 16384.,
    (double)16390./3137161264. * 16384.,
    (double)43863./3137161264. * 16384.,
    (double)21735./3137161264. * 16384.,
    (double)18788./3137161264. * 16384.,
    (double)8206./3137161264. * 16384.,
    (double)26965./3137161264. * 16384.,
    (double)21036./3137161264. * 16384.,
    (double)9565./3137161264. * 16384.,
    (double)35193./3137161264. * 16384.,
    (double)33127./3137161264. * 16384.,
    (double)44420./3137161264. * 16384.,
    (double)38756./3137161264. * 16384.,
    (double)12306./3137161264. * 16384.,
    (double)46196./3137161264. * 16384.,
    (double)26845./3137161264. * 16384.,
    (double)22188./3137161264. * 16384.,
    (double)15847./3137161264. * 16384.,
    (double)14197./3137161264. * 16384.,
    (double)8569./3137161264. * 16384.,
    (double)15095./3137161264. * 16384.,
    (double)31432./3137161264. * 16384.,
    (double)47399./3137161264. * 16384.,
    (double)26984./3137161264. * 16384.,
    (double)31220./3137161264. * 16384.,
    (double)20663./3137161264. * 16384.,
    (double)7174./3137161264. * 16384.,
    (double)22357./3137161264. * 16384.,
    (double)26198./3137161264. * 16384.,
    (double)12960./3137161264. * 16384.,
    (double)18067./3137161264. * 16384.,
    (double)16498./3137161264. * 16384.,
    (double)25820./3137161264. * 16384.,
    (double)167706./3137161264. * 16384.,
    (double)177406./3137161264. * 16384.,
    (double)86812./3137161264. * 16384.,
    (double)91966./3137161264. * 16384.,
    (double)234611./3137161264. * 16384.,
    (double)314290./3137161264. * 16384.,
    (double)263675./3137161264. * 16384.,
    (double)158973./3137161264. * 16384.,
    (double)177346./3137161264. * 16384.,
    (double)45069./3137161264. * 16384.,
    (double)146336./3137161264. * 16384.,
    (double)134537./3137161264. * 16384.,
    (double)90294./3137161264. * 16384.,
    (double)148509./3137161264. * 16384.,
    (double)117622./3137161264. * 16384.,
    (double)136095./3137161264. * 16384.,
    (double)17613./3137161264. * 16384.,
    (double)38606./3137161264. * 16384.,
    (double)17481./3137161264. * 16384.,
    (double)13361./3137161264. * 16384.,
    (double)29886./3137161264. * 16384.,
    (double)59677./3137161264. * 16384.,
    (double)94349./3137161264. * 16384.,
    (double)22162./3137161264. * 16384.,
    (double)27783./3137161264. * 16384.,
    (double)19933./3137161264. * 16384.,
    (double)46790./3137161264. * 16384.,
    (double)26220./3137161264. * 16384.,
    (double)13509./3137161264. * 16384.,
    (double)35821./3137161264. * 16384.,
    (double)21943./3137161264. * 16384.,
    (double)18422./3137161264. * 16384.,
    (double)144642./3137161264. * 16384.,
    (double)244692./3137161264. * 16384.,
    (double)156655./3137161264. * 16384.,
    (double)136158./3137161264. * 16384.,
    (double)31152./3137161264. * 16384.,
    (double)54348./3137161264. * 16384.,
    (double)56609./3137161264. * 16384.,
    (double)32874./3137161264. * 16384.,
    (double)188265./3137161264. * 16384.,
    (double)49026./3137161264. * 16384.,
    (double)83900./3137161264. * 16384.,
    (double)126640./3137161264. * 16384.,
    (double)77574./3137161264. * 16384.,
    (double)192329./3137161264. * 16384.,
    (double)159653./3137161264. * 16384.,
    (double)140632./3137161264. * 16384.,
    (double)98537./3137161264. * 16384.,
    (double)91453./3137161264. * 16384.,
    (double)66773./3137161264. * 16384.,
    (double)77946./3137161264. * 16384.,
    (double)177059./3137161264. * 16384.,
    (double)245652./3137161264. * 16384.,
    (double)199450./3137161264. * 16384.,
    (double)169241./3137161264. * 16384.,
    (double)174538./3137161264. * 16384.,
    (double)34571./3137161264. * 16384.,
    (double)164399./3137161264. * 16384.,
    (double)165182./3137161264. * 16384.,
    (double)95194./3137161264. * 16384.,
    (double)142224./3137161264. * 16384.,
    (double)146612./3137161264. * 16384.,
    (double)172377./3137161264. * 16384.,
    (double)142989./3137161264. * 16384.,
    (double)103494./3137161264. * 16384.,
    (double)69038./3137161264. * 16384.,
    (double)106368./3137161264. * 16384.,
    (double)126195./3137161264. * 16384.,
    (double)115995./3137161264. * 16384.,
    (double)77172./3137161264. * 16384.,
    (double)80149./3137161264. * 16384.,
    (double)110047./3137161264. * 16384.,
    (double)16411./3137161264. * 16384.,
    (double)74821./3137161264. * 16384.,
    (double)98223./3137161264. * 16384.,
    (double)104890./3137161264. * 16384.,
    (double)102706./3137161264. * 16384.,
    (double)67123./3137161264. * 16384.,
    (double)127700./3137161264. * 16384.,
    (double)190277./3137161264. * 16384.,
    (double)219862./3137161264. * 16384.,
    (double)118479./3137161264. * 16384.,
    (double)120752./3137161264. * 16384.,
    (double)241392./3137161264. * 16384.,
    (double)309485./3137161264. * 16384.,
    (double)288421./3137161264. * 16384.,
    (double)157166./3137161264. * 16384.,
    (double)189424./3137161264. * 16384.,
    (double)39440./3137161264. * 16384.,
    (double)185562./3137161264. * 16384.,
    (double)184596./3137161264. * 16384.,
    (double)156833./3137161264. * 16384.,
    (double)228546./3137161264. * 16384.,
    (double)139708./3137161264. * 16384.,
    (double)162900./3137161264. * 16384.,
    (double)170333./3137161264. * 16384.,
    (double)292781./3137161264. * 16384.,
    (double)149137./3137161264. * 16384.,
    (double)167113./3137161264. * 16384.,
    (double)28845./3137161264. * 16384.,
    (double)55309./3137161264. * 16384.,
    (double)32734./3137161264. * 16384.,
    (double)28374./3137161264. * 16384.,
    (double)221744./3137161264. * 16384.,
    (double)45474./3137161264. * 16384.,
    (double)244396./3137161264. * 16384.,
    (double)244259./3137161264. * 16384.,
    (double)124619./3137161264. * 16384.,
    (double)263956./3137161264. * 16384.,
    (double)188412./3137161264. * 16384.,
    (double)196385./3137161264. * 16384.,
    (double)129318./3137161264. * 16384.,
    (double)108446./3137161264. * 16384.,
    (double)76664./3137161264. * 16384.,
    (double)120061./3137161264. * 16384.,
    (double)153366./3137161264. * 16384.,
    (double)188084./3137161264. * 16384.,
    (double)126497./3137161264. * 16384.,
    (double)144393./3137161264. * 16384.,
    (double)187731./3137161264. * 16384.,
    (double)26293./3137161264. * 16384.,
    (double)192368./3137161264. * 16384.,
    (double)218600./3137161264. * 16384.,
    (double)155276./3137161264. * 16384.,
    (double)203587./3137161264. * 16384.,
    (double)187416./3137161264. * 16384.,
    (double)257887./3137161264. * 16384.,
    (double)255558./3137161264. * 16384.,
    (double)150123./3137161264. * 16384.,
    (double)103709./3137161264. * 16384.,
    (double)191418./3137161264. * 16384.,
    (double)153815./3137161264. * 16384.,
    (double)120484./3137161264. * 16384.,
    (double)88268./3137161264. * 16384.,
    (double)123652./3137161264. * 16384.,
    (double)130326./3137161264. * 16384.,
    (double)16244./3137161264. * 16384.,
    (double)57022./3137161264. * 16384.,
    (double)98391./3137161264. * 16384.,
    (double)149093./3137161264. * 16384.,
    (double)131885./3137161264. * 16384.,
    (double)74386./3137161264. * 16384.,
    (double)197158./3137161264. * 16384.,
    (double)170050./3137161264. * 16384.,
    (double)126749./3137161264. * 16384.,
    (double)70869./3137161264. * 16384.,
    (double)96382./3137161264. * 16384.,
    (double)133054./3137161264. * 16384.,
    (double)88679./3137161264. * 16384.,
    (double)76831./3137161264. * 16384.,
    (double)82228./3137161264. * 16384.,
    (double)93159./3137161264. * 16384.,
    (double)11060./3137161264. * 16384.,
    (double)59589./3137161264. * 16384.,
    (double)82271./3137161264. * 16384.,
    (double)77871./3137161264. * 16384.,
    (double)87713./3137161264. * 16384.,
    (double)57494./3137161264. * 16384.,
    (double)93939./3137161264. * 16384.,
    (double)137690./3137161264. * 16384.,
    (double)146096./3137161264. * 16384.,
    (double)80268./3137161264. * 16384.,
    (double)130392./3137161264. * 16384.,
    (double)14775./3137161264. * 16384.,
    (double)15784./3137161264. * 16384.,
    (double)11086./3137161264. * 16384.,
    (double)20841./3137161264. * 16384.,
    (double)113287./3137161264. * 16384.,
    (double)16159./3137161264. * 16384.,
    (double)64894./3137161264. * 16384.,
    (double)100511./3137161264. * 16384.,
    (double)95414./3137161264. * 16384.,
    (double)134979./3137161264. * 16384.,
    (double)111541./3137161264. * 16384.,
    (double)148645./3137161264. * 16384.,
    (double)164268./3137161264. * 16384.,
    (double)96581./3137161264. * 16384.,
    (double)74260./3137161264. * 16384.,
    (double)141633./3137161264. * 16384.,
    (double)136171./3137161264. * 16384.,
    (double)105612./3137161264. * 16384.,
    (double)82992./3137161264. * 16384.,
    (double)138527./3137161264. * 16384.,
    (double)108372./3137161264. * 16384.,
    (double)10902./3137161264. * 16384.,
    (double)67540./3137161264. * 16384.,
    (double)109213./3137161264. * 16384.,
    (double)157270./3137161264. * 16384.,
    (double)122790./3137161264. * 16384.,
    (double)114229./3137161264. * 16384.,
    (double)254503./3137161264. * 16384.,
    (double)286984./3137161264. * 16384.,
    (double)238334./3137161264. * 16384.,
    (double)122640./3137161264. * 16384.,
    (double)206889./3137161264. * 16384.,
    (double)289101./3137161264. * 16384.,
    (double)310608./3137161264. * 16384.,
    (double)178623./3137161264. * 16384.,
    (double)187338./3137161264. * 16384.,
    (double)167562./3137161264. * 16384.,
    (double)28441./3137161264. * 16384.,
    (double)107800./3137161264. * 16384.,
    (double)143138./3137161264. * 16384.,
    (double)131829./3137161264. * 16384.,
    (double)179075./3137161264. * 16384.,
    (double)87524./3137161264. * 16384.,
    (double)167313./3137161264. * 16384.,
    (double)266149./3137161264. * 16384.,
    (double)305491./3137161264. * 16384.,
    (double)118034./3137161264. * 16384.,
    (double)153506./3137161264. * 16384.,
    (double)356630./3137161264. * 16384.,
    (double)286022./3137161264. * 16384.,
    (double)218325./3137161264. * 16384.,
    (double)192579./3137161264. * 16384.,
    (double)201774./3137161264. * 16384.,
    (double)40517./3137161264. * 16384.,
    (double)156135./3137161264. * 16384.,
    (double)196512./3137161264. * 16384.,
    (double)119424./3137161264. * 16384.,
    (double)203055./3137161264. * 16384.,
    (double)118128./3137161264. * 16384.,
    (double)146763./3137161264. * 16384.,
    (double)173129./3137161264. * 16384.,
    (double)289354./3137161264. * 16384.,
    (double)131994./3137161264. * 16384.,
    (double)174878./3137161264. * 16384.,
    (double)26354./3137161264. * 16384.,
    (double)49035./3137161264. * 16384.,
    (double)28703./3137161264. * 16384.,
    (double)32562./3137161264. * 16384.,
    (double)211171./3137161264. * 16384.,
    (double)45090./3137161264. * 16384.,
    (double)174230./3137161264. * 16384.,
    (double)227578./3137161264. * 16384.,
    (double)139520./3137161264. * 16384.,
    (double)303927./3137161264. * 16384.,
    (double)172813./3137161264. * 16384.,
    (double)218416./3137161264. * 16384.,
    (double)156960./3137161264. * 16384.,
    (double)125916./3137161264. * 16384.,
    (double)92106./3137161264. * 16384.,
    (double)149100./3137161264. * 16384.,
    (double)224964./3137161264. * 16384.,
    (double)244021./3137161264. * 16384.,
    (double)169807./3137161264. * 16384.,
    (double)250398./3137161264. * 16384.,
    (double)173946./3137161264. * 16384.,
    (double)22058./3137161264. * 16384.,
    (double)130923./3137161264. * 16384.,
    (double)187415./3137161264. * 16384.,
    (double)144183./3137161264. * 16384.,
    (double)166179./3137161264. * 16384.,
    (double)140246./3137161264. * 16384.,
    (double)252660./3137161264. * 16384.,
    (double)195022./3137161264. * 16384.,
    (double)185917./3137161264. * 16384.,
    (double)92190./3137161264. * 16384.,
    (double)130446./3137161264. * 16384.,
    (double)222676./3137161264. * 16384.,
    (double)214807./3137161264. * 16384.,
    (double)172214./3137161264. * 16384.,
    (double)167015./3137161264. * 16384.,
    (double)184591./3137161264. * 16384.,
    (double)38464./3137161264. * 16384.,
    (double)112541./3137161264. * 16384.,
    (double)163270./3137161264. * 16384.,
    (double)109448./3137161264. * 16384.,
    (double)154014./3137161264. * 16384.,
    (double)111685./3137161264. * 16384.,
    (double)178096./3137161264. * 16384.,
    (double)15069./3137161264. * 16384.,
    (double)22733./3137161264. * 16384.,
    (double)9281./3137161264. * 16384.,
    (double)13251./3137161264. * 16384.,
    (double)21581./3137161264. * 16384.,
    (double)32777./3137161264. * 16384.,
    (double)28136./3137161264. * 16384.,
    (double)18642./3137161264. * 16384.,
    (double)16848./3137161264. * 16384.,
    (double)8035./3137161264. * 16384.,
    (double)20002./3137161264. * 16384.,
    (double)22980./3137161264. * 16384.,
    (double)10996./3137161264. * 16384.,
    (double)23636./3137161264. * 16384.,
    (double)14158./3137161264. * 16384.,
    (double)17470./3137161264. * 16384.,
    (double)139559./3137161264. * 16384.,
    (double)210969./3137161264. * 16384.,
    (double)125039./3137161264. * 16384.,
    (double)150440./3137161264. * 16384.,
    (double)21591./3137161264. * 16384.,
    (double)33537./3137161264. * 16384.,
    (double)27882./3137161264. * 16384.,
    (double)28416./3137161264. * 16384.,
    (double)191330./3137161264. * 16384.,
    (double)39759./3137161264. * 16384.,
    (double)134584./3137161264. * 16384.,
    (double)175449./3137161264. * 16384.,
    (double)101141./3137161264. * 16384.,
    (double)212411./3137161264. * 16384.,
    (double)162859./3137161264. * 16384.,
    (double)175940./3137161264. * 16384.,
    (double)125439./3137161264. * 16384.,
    (double)104726./3137161264. * 16384.,
    (double)81075./3137161264. * 16384.,
    (double)115514./3137161264. * 16384.,
    (double)201287./3137161264. * 16384.,
    (double)213977./3137161264. * 16384.,
    (double)199958./3137161264. * 16384.,
    (double)238425./3137161264. * 16384.,
    (double)174790./3137161264. * 16384.,
    (double)25837./3137161264. * 16384.,
    (double)154111./3137161264. * 16384.,
    (double)201314./3137161264. * 16384.,
    (double)130113./3137161264. * 16384.,
    (double)153363./3137161264. * 16384.,
    (double)172632./3137161264. * 16384.,
    (double)234765./3137161264. * 16384.,
    (double)203712./3137161264. * 16384.,
    (double)117830./3137161264. * 16384.,
    (double)80420./3137161264. * 16384.,
    (double)146970./3137161264. * 16384.,
    (double)131840./3137161264. * 16384.,
    (double)101962./3137161264. * 16384.,
    (double)83280./3137161264. * 16384.,
    (double)97979./3137161264. * 16384.,
    (double)130767./3137161264. * 16384.,
    (double)16011./3137161264. * 16384.,
    (double)68572./3137161264. * 16384.,
    (double)110721./3137161264. * 16384.,
    (double)140722./3137161264. * 16384.,
    (double)119890./3137161264. * 16384.,
    (double)91594./3137161264. * 16384.,
    (double)199239./3137161264. * 16384.,
    (double)165530./3137161264. * 16384.,
    (double)153160./3137161264. * 16384.,
    (double)77216./3137161264. * 16384.,
    (double)112814./3137161264. * 16384.,
    (double)151691./3137161264. * 16384.,
    (double)150657./3137161264. * 16384.,
    (double)126742./3137161264. * 16384.,
    (double)121692./3137161264. * 16384.,
    (double)134459./3137161264. * 16384.,
    (double)16542./3137161264. * 16384.,
    (double)96871./3137161264. * 16384.,
    (double)148767./3137161264. * 16384.,
    (double)108211./3137161264. * 16384.,
    (double)137567./3137161264. * 16384.,
    (double)100879./3137161264. * 16384.,
    (double)160786./3137161264. * 16384.,
    (double)166542./3137161264. * 16384.,
    (double)214249./3137161264. * 16384.,
    (double)127487./3137161264. * 16384.,
    (double)189609./3137161264. * 16384.,
    (double)17504./3137161264. * 16384.,
    (double)24240./3137161264. * 16384.,
    (double)15103./3137161264. * 16384.,
    (double)23070./3137161264. * 16384.,
    (double)217191./3137161264. * 16384.,
    (double)28619./3137161264. * 16384.,
    (double)183836./3137161264. * 16384.,
    (double)262339./3137161264. * 16384.,
    (double)156248./3137161264. * 16384.,
    (double)247548./3137161264. * 16384.,
    (double)204405./3137161264. * 16384.,
    (double)242918./3137161264. * 16384.,
    (double)215915./3137161264. * 16384.,
    (double)139973./3137161264. * 16384.,
    (double)112446./3137161264. * 16384.,
    (double)230928./3137161264. * 16384.,
    (double)198117./3137161264. * 16384.,
    (double)207056./3137161264. * 16384.,
    (double)161641./3137161264. * 16384.,
    (double)225097./3137161264. * 16384.,
    (double)232176./3137161264. * 16384.,
    (double)22181./3137161264. * 16384.,
    (double)195954./3137161264. * 16384.,
    (double)300185./3137161264. * 16384.,
    (double)268413./3137161264. * 16384.,
    (double)254330./3137161264. * 16384.,
    (double)257817./3137161264. * 16384.,
    (double)359597./3137161264. * 16384.,
    (double)413567./3137161264. * 16384.,
    (double)245851./3137161264. * 16384.,
    (double)211530./3137161264. * 16384.,
    (double)440765./3137161264. * 16384.,
    (double)239464./3137161264. * 16384.,
    (double)155507./3137161264. * 16384.,
    (double)119855./3137161264. * 16384.,
    (double)175677./3137161264. * 16384.,
    (double)236201./3137161264. * 16384.,
    (double)23058./3137161264. * 16384.,
    (double)91546./3137161264. * 16384.,
    (double)169582./3137161264. * 16384.,
    (double)344382./3137161264. * 16384.,
    (double)265762./3137161264. * 16384.,
    (double)132542./3137161264. * 16384.,
    (double)292299./3137161264. * 16384.,
    (double)245942./3137161264. * 16384.,
    (double)156883./3137161264. * 16384.,
    (double)107065./3137161264. * 16384.,
    (double)151214./3137161264. * 16384.,
    (double)153161./3137161264. * 16384.,
    (double)97635./3137161264. * 16384.,
    (double)79152./3137161264. * 16384.,
    (double)92628./3137161264. * 16384.,
    (double)139241./3137161264. * 16384.,
    (double)13774./3137161264. * 16384.,
    (double)81992./3137161264. * 16384.,
    (double)97335./3137161264. * 16384.,
    (double)152793./3137161264. * 16384.,
    (double)160418./3137161264. * 16384.,
    (double)95556./3137161264. * 16384.,
    (double)161241./3137161264. * 16384.,
    (double)187504./3137161264. * 16384.,
    (double)149354./3137161264. * 16384.,
    (double)105073./3137161264. * 16384.,
    (double)173657./3137161264. * 16384.,
    (double)15420./3137161264. * 16384.,
    (double)13360./3137161264. * 16384.,
    (double)9813./3137161264. * 16384.,
    (double)20720./3137161264. * 16384.,
    (double)117472./3137161264. * 16384.,
    (double)11514./3137161264. * 16384.,
    (double)62491./3137161264. * 16384.,
    (double)98634./3137161264. * 16384.,
    (double)123893./3137161264. * 16384.,
    (double)146022./3137161264. * 16384.,
    (double)94551./3137161264. * 16384.,
    (double)175340./3137161264. * 16384.,
    (double)260494./3137161264. * 16384.,
    (double)131344./3137161264. * 16384.,
    (double)113290./3137161264. * 16384.,
    (double)230262./3137161264. * 16384.,
    (double)173762./3137161264. * 16384.,
    (double)120924./3137161264. * 16384.,
    (double)95033./3137161264. * 16384.,
    (double)159356./3137161264. * 16384.,
    (double)148890./3137161264. * 16384.,
    (double)13051./3137161264. * 16384.,
    (double)103380./3137161264. * 16384.,
    (double)129756./3137161264. * 16384.,
    (double)225180./3137161264. * 16384.,
    (double)149467./3137161264. * 16384.,
    (double)150542./3137161264. * 16384.,
    (double)336346./3137161264. * 16384.,
    (double)303691./3137161264. * 16384.,
    (double)174003./3137161264. * 16384.,
    (double)100082./3137161264. * 16384.,
    (double)196643./3137161264. * 16384.,
    (double)202408./3137161264. * 16384.,
    (double)133607./3137161264. * 16384.,
    (double)86233./3137161264. * 16384.,
    (double)115443./3137161264. * 16384.,
    (double)140180./3137161264. * 16384.,
    (double)16148./3137161264. * 16384.,
    (double)55902./3137161264. * 16384.,
    (double)97487./3137161264. * 16384.,
    (double)149522./3137161264. * 16384.,
    (double)142966./3137161264. * 16384.,
    (double)68503./3137161264. * 16384.,
    (double)151039./3137161264. * 16384.,
    (double)180434./3137161264. * 16384.,
    (double)145315./3137161264. * 16384.,
    (double)68623./3137161264. * 16384.,
    (double)105037./3137161264. * 16384.,
    (double)124311./3137161264. * 16384.,
    (double)101675./3137161264. * 16384.,
    (double)67134./3137161264. * 16384.,
    (double)80951./3137161264. * 16384.,
    (double)122662./3137161264. * 16384.,
    (double)14922./3137161264. * 16384.,
    (double)57703./3137161264. * 16384.,
    (double)89906./3137161264. * 16384.,
    (double)110804./3137161264. * 16384.,
    (double)123486./3137161264. * 16384.,
    (double)65095./3137161264. * 16384.,
    (double)104340./3137161264. * 16384.,
    (double)128125./3137161264. * 16384.,
    (double)128391./3137161264. * 16384.,
    (double)78909./3137161264. * 16384.,
    (double)124606./3137161264. * 16384.,
    (double)11735./3137161264. * 16384.,
    (double)14159./3137161264. * 16384.,
    (double)9041./3137161264. * 16384.,
    (double)13573./3137161264. * 16384.,
    (double)122924./3137161264. * 16384.,
    (double)16186./3137161264. * 16384.,
    (double)65519./3137161264. * 16384.,
    (double)98128./3137161264. * 16384.,
    (double)110320./3137161264. * 16384.,
    (double)185892./3137161264. * 16384.,
    (double)88328./3137161264. * 16384.,
    (double)126315./3137161264. * 16384.,
    (double)127930./3137161264. * 16384.,
    (double)92285./3137161264. * 16384.,
    (double)58409./3137161264. * 16384.,
    (double)120031./3137161264. * 16384.,
    (double)118162./3137161264. * 16384.,
    (double)102231./3137161264. * 16384.,
    (double)61425./3137161264. * 16384.,
    (double)99407./3137161264. * 16384.,
    (double)107046./3137161264. * 16384.,
    (double)9348./3137161264. * 16384.,
    (double)64553./3137161264. * 16384.,
    (double)94540./3137161264. * 16384.,
    (double)120323./3137161264. * 16384.,
    (double)107670./3137161264. * 16384.,
    (double)94282./3137161264. * 16384.,
    (double)194085./3137161264. * 16384.,
    (double)204295./3137161264. * 16384.,
    (double)108645./3137161264. * 16384.,
    (double)80562./3137161264. * 16384.,
    (double)146546./3137161264. * 16384.,
    (double)155453./3137161264. * 16384.,
    (double)103772./3137161264. * 16384.,
    (double)88085./3137161264. * 16384.,
    (double)131473./3137161264. * 16384.,
    (double)165145./3137161264. * 16384.,
    (double)21560./3137161264. * 16384.,
    (double)57533./3137161264. * 16384.,
    (double)99141./3137161264. * 16384.,
    (double)170855./3137161264. * 16384.,
    (double)144338./3137161264. * 16384.,
    (double)80138./3137161264. * 16384.,
    (double)186583./3137161264. * 16384.,
    (double)13542./3137161264. * 16384.,
    (double)12156./3137161264. * 16384.,
    (double)6784./3137161264. * 16384.,
    (double)12794./3137161264. * 16384.,
    (double)11715./3137161264. * 16384.,
    (double)10825./3137161264. * 16384.,
    (double)8191./3137161264. * 16384.,
    (double)11513./3137161264. * 16384.,
    (double)13006./3137161264. * 16384.,
    (double)2811./3137161264. * 16384.,
    (double)6724./3137161264. * 16384.,
    (double)10303./3137161264. * 16384.,
    (double)20280./3137161264. * 16384.,
    (double)27153./3137161264. * 16384.,
    (double)10174./3137161264. * 16384.,
    (double)20544./3137161264. * 16384.,
    (double)95235./3137161264. * 16384.,
    (double)97106./3137161264. * 16384.,
    (double)75228./3137161264. * 16384.,
    (double)102687./3137161264. * 16384.,
    (double)9697./3137161264. * 16384.,
    (double)9591./3137161264. * 16384.,
    (double)8095./3137161264. * 16384.,
    (double)11881./3137161264. * 16384.,
    (double)99481./3137161264. * 16384.,
    (double)13198./3137161264. * 16384.,
    (double)55984./3137161264. * 16384.,
    (double)73122./3137161264. * 16384.,
    (double)86553./3137161264. * 16384.,
    (double)114341./3137161264. * 16384.,
    (double)74041./3137161264. * 16384.,
    (double)102791./3137161264. * 16384.,
    (double)99812./3137161264. * 16384.,
    (double)68259./3137161264. * 16384.,
    (double)58274./3137161264. * 16384.,
    (double)111293./3137161264. * 16384.,
    (double)112402./3137161264. * 16384.,
    (double)95482./3137161264. * 16384.,
    (double)72226./3137161264. * 16384.,
    (double)112337./3137161264. * 16384.,
    (double)107832./3137161264. * 16384.,
    (double)11650./3137161264. * 16384.,
    (double)67400./3137161264. * 16384.,
    (double)98204./3137161264. * 16384.,
    (double)125223./3137161264. * 16384.,
    (double)106593./3137161264. * 16384.,
    (double)101211./3137161264. * 16384.,
    (double)194275./3137161264. * 16384.,
    (double)272202./3137161264. * 16384.,
    (double)116228./3137161264. * 16384.,
    (double)91263./3137161264. * 16384.,
    (double)217554./3137161264. * 16384.,
    (double)128124./3137161264. * 16384.,
    (double)76181./3137161264. * 16384.,
    (double)69470./3137161264. * 16384.,
    (double)110999./3137161264. * 16384.,
    (double)183905./3137161264. * 16384.,
    (double)18308./3137161264. * 16384.,
    (double)63722./3137161264. * 16384.,
    (double)113110./3137161264. * 16384.,
    (double)323435./3137161264. * 16384.,
    (double)189913./3137161264. * 16384.,
    (double)105296./3137161264. * 16384.,
    (double)276366./3137161264. * 16384.,
    (double)169225./3137161264. * 16384.,
    (double)118448./3137161264. * 16384.,
    (double)76317./3137161264. * 16384.,
    (double)125870./3137161264. * 16384.,
    (double)112438./3137161264. * 16384.,
    (double)84765./3137161264. * 16384.,
    (double)70231./3137161264. * 16384.,
    (double)94182./3137161264. * 16384.,
    (double)134388./3137161264. * 16384.,
    (double)13836./3137161264. * 16384.,
    (double)66901./3137161264. * 16384.,
    (double)102804./3137161264. * 16384.,
    (double)195559./3137161264. * 16384.,
    (double)212744./3137161264. * 16384.,
    (double)100794./3137161264. * 16384.,
    (double)193836./3137161264. * 16384.,
    (double)126475./3137161264. * 16384.,
    (double)121519./3137161264. * 16384.,
    (double)94735./3137161264. * 16384.,
    (double)142079./3137161264. * 16384.,
    (double)10616./3137161264. * 16384.,
    (double)9053./3137161264. * 16384.,
    (double)8537./3137161264. * 16384.,
    (double)12973./3137161264. * 16384.,
    (double)113437./3137161264. * 16384.,
    (double)10410./3137161264. * 16384.,
    (double)72351./3137161264. * 16384.,
    (double)107648./3137161264. * 16384.,
    (double)130622./3137161264. * 16384.,
    (double)150742./3137161264. * 16384.,
    (double)114631./3137161264. * 16384.,
    (double)179551./3137161264. * 16384.,
    (double)213972./3137161264. * 16384.,
    (double)127470./3137161264. * 16384.,
    (double)108860./3137161264. * 16384.,
    (double)233566./3137161264. * 16384.,
    (double)131076./3137161264. * 16384.,
    (double)98975./3137161264. * 16384.,
    (double)88778./3137161264. * 16384.,
    (double)141542./3137161264. * 16384.,
    (double)182557./3137161264. * 16384.,
    (double)15058./3137161264. * 16384.,
    (double)116734./3137161264. * 16384.,
    (double)193748./3137161264. * 16384.,
    (double)305953./3137161264. * 16384.,
    (double)247725./3137161264. * 16384.,
    (double)247767./3137161264. * 16384.,
    (double)516611./3137161264. * 16384.,
    (double)382309./3137161264. * 16384.,
    (double)245853./3137161264. * 16384.,
    (double)184141./3137161264. * 16384.,
    (double)307651./3137161264. * 16384.,
    (double)249171./3137161264. * 16384.,
    (double)196105./3137161264. * 16384.,
    (double)131591./3137161264. * 16384.,
    (double)170619./3137161264. * 16384.,
    (double)186879./3137161264. * 16384.,
    (double)23643./3137161264. * 16384.,
    (double)95696./3137161264. * 16384.,
    (double)142492./3137161264. * 16384.,
    (double)207912./3137161264. * 16384.,
    (double)215363./3137161264. * 16384.,
    (double)109402./3137161264. * 16384.,
    (double)220954./3137161264. * 16384.,
    (double)283365./3137161264. * 16384.,
    (double)218867./3137161264. * 16384.,
    (double)169180./3137161264. * 16384.,
    (double)184661./3137161264. * 16384.,
    (double)235877./3137161264. * 16384.,
    (double)195782./3137161264. * 16384.,
    (double)154377./3137161264. * 16384.,
    (double)149755./3137161264. * 16384.,
    (double)178749./3137161264. * 16384.,
    (double)29009./3137161264. * 16384.,
    (double)196149./3137161264. * 16384.,
    (double)158245./3137161264. * 16384.,
    (double)120464./3137161264. * 16384.,
    (double)198417./3137161264. * 16384.,
    (double)114727./3137161264. * 16384.,
    (double)161272./3137161264. * 16384.,
    (double)170972./3137161264. * 16384.,
    (double)207012./3137161264. * 16384.,
    (double)120597./3137161264. * 16384.,
    (double)182416./3137161264. * 16384.,
    (double)19540./3137161264. * 16384.,
    (double)26016./3137161264. * 16384.,
    (double)16748./3137161264. * 16384.,
    (double)26769./3137161264. * 16384.,
    (double)133995./3137161264. * 16384.,
    (double)20198./3137161264. * 16384.,
    (double)101688./3137161264. * 16384.,
    (double)153671./3137161264. * 16384.,
    (double)114576./3137161264. * 16384.,
    (double)171628./3137161264. * 16384.,
    (double)123173./3137161264. * 16384.,
    (double)199819./3137161264. * 16384.,
    (double)181540./3137161264. * 16384.,
    (double)117332./3137161264. * 16384.,
    (double)95763./3137161264. * 16384.,
    (double)177137./3137161264. * 16384.,
    (double)191997./3137161264. * 16384.,
    (double)185390./3137161264. * 16384.,
    (double)119019./3137161264. * 16384.,
    (double)180166./3137161264. * 16384.,
    (double)134873./3137161264. * 16384.,
    (double)16022./3137161264. * 16384.,
    (double)93638./3137161264. * 16384.,
    (double)135107./3137161264. * 16384.,
    (double)172095./3137161264. * 16384.,
    (double)136830./3137161264. * 16384.,
    (double)140444./3137161264. * 16384.,
    (double)274374./3137161264. * 16384.,
    (double)293488./3137161264. * 16384.,
    (double)236392./3137161264. * 16384.,
    (double)110137./3137161264. * 16384.,
    (double)187871./3137161264. * 16384.,
    (double)241450./3137161264. * 16384.,
    (double)240640./3137161264. * 16384.,
    (double)133241./3137161264. * 16384.,
    (double)142412./3137161264. * 16384.,
    (double)151527./3137161264. * 16384.,
    (double)25287./3137161264. * 16384.,
    (double)71253./3137161264. * 16384.,
    (double)105862./3137161264. * 16384.,
    (double)130307./3137161264. * 16384.,
    (double)167545./3137161264. * 16384.,
    (double)83888./3137161264. * 16384.,
    (double)147825./3137161264. * 16384.,
    (double)256458./3137161264. * 16384.,
    (double)295684./3137161264. * 16384.,
    (double)112863./3137161264. * 16384.,
    (double)145606./3137161264. * 16384.,
    (double)260138./3137161264. * 16384.,
    (double)229503./3137161264. * 16384.,
    (double)158226./3137161264. * 16384.,
    (double)163316./3137161264. * 16384.,
    (double)191854./3137161264. * 16384.,
    (double)43881./3137161264. * 16384.,
    (double)112420./3137161264. * 16384.,
    (double)146310./3137161264. * 16384.,
    (double)118929./3137161264. * 16384.,
    (double)222364./3137161264. * 16384.,
    (double)98630./3137161264. * 16384.,
    (double)138310./3137161264. * 16384.,
    (double)154055./3137161264. * 16384.,
    (double)228721./3137161264. * 16384.,
    (double)123909./3137161264. * 16384.,
    (double)163822./3137161264. * 16384.,
    (double)22424./3137161264. * 16384.,
    (double)41634./3137161264. * 16384.,
    (double)27286./3137161264. * 16384.,
    (double)26647./3137161264. * 16384.,
    (double)182823./3137161264. * 16384.,
    (double)35807./3137161264. * 16384.,
    (double)121858./3137161264. * 16384.,
    (double)161092./3137161264. * 16384.,
    (double)119691./3137161264. * 16384.,
    (double)237861./3137161264. * 16384.,
    (double)159096./3137161264. * 16384.,
    (double)193983./3137161264. * 16384.,
    (double)137469./3137161264. * 16384.,
    (double)122555./3137161264. * 16384.,
    (double)74713./3137161264. * 16384.,
    (double)133909./3137161264. * 16384.,
    (double)180012./3137161264. * 16384.,
    (double)231408./3137161264. * 16384.,
    (double)115774./3137161264. * 16384.,
    (double)154246./3137161264. * 16384.,
    (double)142008./3137161264. * 16384.,
    (double)16480./3137161264. * 16384.,
    (double)90510./3137161264. * 16384.,
    (double)136049./3137161264. * 16384.,
    (double)135089./3137161264. * 16384.,
    (double)145334./3137161264. * 16384.,
    (double)115970./3137161264. * 16384.,
    (double)220525./3137161264. * 16384.,
    (double)176903./3137161264. * 16384.,
    (double)120997./3137161264. * 16384.,
    (double)69560./3137161264. * 16384.,
    (double)122708./3137161264. * 16384.,
    (double)174474./3137161264. * 16384.,
    (double)171310./3137161264. * 16384.,
    (double)123899./3137161264. * 16384.,
    (double)147685./3137161264. * 16384.,
    (double)176369./3137161264. * 16384.,
    (double)36376./3137161264. * 16384.,
    (double)78929./3137161264. * 16384.,
    (double)99673./3137161264. * 16384.,
    (double)127174./3137161264. * 16384.,
    (double)180021./3137161264. * 16384.,
    (double)84165./3137161264. * 16384.,
    (double)162181./3137161264. * 16384.,
    (double)12407./3137161264. * 16384.,
    (double)19555./3137161264. * 16384.,
    (double)9252./3137161264. * 16384.,
    (double)16099./3137161264. * 16384.,
    (double)17469./3137161264. * 16384.,
    (double)30046./3137161264. * 16384.,
    (double)19546./3137161264. * 16384.,
    (double)18720./3137161264. * 16384.,
    (double)21877./3137161264. * 16384.,
    (double)14152./3137161264. * 16384.,
    (double)16516./3137161264. * 16384.,
    (double)15814./3137161264. * 16384.,
    (double)15170./3137161264. * 16384.,
    (double)48992./3137161264. * 16384.,
    (double)13833./3137161264. * 16384.,
    (double)18232./3137161264. * 16384.,
    (double)123911./3137161264. * 16384.,
    (double)168396./3137161264. * 16384.,
    (double)118357./3137161264. * 16384.,
    (double)132334./3137161264. * 16384.,
    (double)16350./3137161264. * 16384.,
    (double)24926./3137161264. * 16384.,
    (double)19300./3137161264. * 16384.,
    (double)20797./3137161264. * 16384.,
    (double)166866./3137161264. * 16384.,
    (double)39162./3137161264. * 16384.,
    (double)96200./3137161264. * 16384.,
    (double)129658./3137161264. * 16384.,
    (double)98298./3137161264. * 16384.,
    (double)213156./3137161264. * 16384.,
    (double)127147./3137161264. * 16384.,
    (double)149076./3137161264. * 16384.,
    (double)121403./3137161264. * 16384.,
    (double)95446./3137161264. * 16384.,
    (double)75929./3137161264. * 16384.,
    (double)126824./3137161264. * 16384.,
    (double)169550./3137161264. * 16384.,
    (double)213500./3137161264. * 16384.,
    (double)147943./3137161264. * 16384.,
    (double)175098./3137161264. * 16384.,
    (double)161196./3137161264. * 16384.,
    (double)19035./3137161264. * 16384.,
    (double)107907./3137161264. * 16384.,
    (double)148844./3137161264. * 16384.,
    (double)127978./3137161264. * 16384.,
    (double)137238./3137161264. * 16384.,
    (double)134873./3137161264. * 16384.,
    (double)227912./3137161264. * 16384.,
    (double)184661./3137161264. * 16384.,
    (double)117446./3137161264. * 16384.,
    (double)82726./3137161264. * 16384.,
    (double)146366./3137161264. * 16384.,
    (double)117653./3137161264. * 16384.,
    (double)95436./3137161264. * 16384.,
    (double)73517./3137161264. * 16384.,
    (double)96997./3137161264. * 16384.,
    (double)151201./3137161264. * 16384.,
    (double)18097./3137161264. * 16384.,
    (double)65812./3137161264. * 16384.,
    (double)95181./3137161264. * 16384.,
    (double)198244./3137161264. * 16384.,
    (double)181541./3137161264. * 16384.,
    (double)92578./3137161264. * 16384.,
    (double)197828./3137161264. * 16384.,
    (double)192194./3137161264. * 16384.,
    (double)208688./3137161264. * 16384.,
    (double)117715./3137161264. * 16384.,
    (double)159657./3137161264. * 16384.,
    (double)171051./3137161264. * 16384.,
    (double)192322./3137161264. * 16384.,
    (double)141767./3137161264. * 16384.,
    (double)164355./3137161264. * 16384.,
    (double)209252./3137161264. * 16384.,
    (double)43800./3137161264. * 16384.,
    (double)119452./3137161264. * 16384.,
    (double)154048./3137161264. * 16384.,
    (double)225283./3137161264. * 16384.,
    (double)574699./3137161264. * 16384.,
    (double)148791./3137161264. * 16384.,
    (double)235210./3137161264. * 16384.,
    (double)124105./3137161264. * 16384.,
    (double)155254./3137161264. * 16384.,
    (double)113583./3137161264. * 16384.,
    (double)151342./3137161264. * 16384.,
    (double)12476./3137161264. * 16384.,
    (double)17822./3137161264. * 16384.,
    (double)12671./3137161264. * 16384.,
    (double)16247./3137161264. * 16384.,
    (double)144192./3137161264. * 16384.,
    (double)20361./3137161264. * 16384.,
    (double)116522./3137161264. * 16384.,
    (double)166674./3137161264. * 16384.,
    (double)119722./3137161264. * 16384.,
    (double)211220./3137161264. * 16384.,
    (double)146885./3137161264. * 16384.,
    (double)197553./3137161264. * 16384.,
    (double)164589./3137161264. * 16384.,
    (double)120037./3137161264. * 16384.,
    (double)96745./3137161264. * 16384.,
    (double)156747./3137161264. * 16384.,
    (double)145330./3137161264. * 16384.,
    (double)154865./3137161264. * 16384.,
    (double)106401./3137161264. * 16384.,
    (double)149375./3137161264. * 16384.,
    (double)180758./3137161264. * 16384.,
    (double)18330./3137161264. * 16384.,
    (double)130227./3137161264. * 16384.,
    (double)207619./3137161264. * 16384.,
    (double)219090./3137161264. * 16384.,
    (double)235371./3137161264. * 16384.,
    (double)208515./3137161264. * 16384.,
    (double)368619./3137161264. * 16384.,
    (double)242922./3137161264. * 16384.,
    (double)168229./3137161264. * 16384.,
    (double)104597./3137161264. * 16384.,
    (double)198392./3137161264. * 16384.,
    (double)147588./3137161264. * 16384.,
    (double)135283./3137161264. * 16384.,
    (double)75442./3137161264. * 16384.,
    (double)115154./3137161264. * 16384.,
    (double)135917./3137161264. * 16384.,
    (double)14751./3137161264. * 16384.,
    (double)63832./3137161264. * 16384.,
    (double)104260./3137161264. * 16384.,
    (double)136512./3137161264. * 16384.,
    (double)120810./3137161264. * 16384.,
    (double)71350./3137161264. * 16384.,
    (double)148083./3137161264. * 16384.,
    (double)208798./3137161264. * 16384.,
    (double)187088./3137161264. * 16384.,
    (double)91506./3137161264. * 16384.,
    (double)138098./3137161264. * 16384.,
    (double)184651./3137161264. * 16384.,
    (double)158847./3137161264. * 16384.,
    (double)110888./3137161264. * 16384.,
    (double)112510./3137161264. * 16384.,
    (double)155219./3137161264. * 16384.,
    (double)22638./3137161264. * 16384.,
    (double)108448./3137161264. * 16384.,
    (double)128558./3137161264. * 16384.,
    (double)107814./3137161264. * 16384.,
    (double)160527./3137161264. * 16384.,
    (double)93016./3137161264. * 16384.,
    (double)139240./3137161264. * 16384.,
    (double)152088./3137161264. * 16384.,
    (double)189872./3137161264. * 16384.,
    (double)126464./3137161264. * 16384.,
    (double)176584./3137161264. * 16384.,
    (double)19474./3137161264. * 16384.,
    (double)25665./3137161264. * 16384.,
    (double)17231./3137161264. * 16384.,
    (double)29926./3137161264. * 16384.,
    (double)148201./3137161264. * 16384.,
    (double)23919./3137161264. * 16384.,
    (double)108318./3137161264. * 16384.,
    (double)138522./3137161264. * 16384.,
    (double)101030./3137161264. * 16384.,
    (double)186642./3137161264. * 16384.,
    (double)111802./3137161264. * 16384.,
    (double)168518./3137161264. * 16384.,
    (double)145196./3137161264. * 16384.,
    (double)103310./3137161264. * 16384.,
    (double)74215./3137161264. * 16384.,
    (double)153108./3137161264. * 16384.,
    (double)141828./3137161264. * 16384.,
    (double)138631./3137161264. * 16384.,
    (double)89391./3137161264. * 16384.,
    (double)140641./3137161264. * 16384.,
    (double)151910./3137161264. * 16384.,
    (double)18280./3137161264. * 16384.,
    (double)100859./3137161264. * 16384.,
    (double)163590./3137161264. * 16384.,
    (double)162269./3137161264. * 16384.,
    (double)145112./3137161264. * 16384.,
    (double)142329./3137161264. * 16384.,
    (double)291975./3137161264. * 16384.,
    (double)14582./3137161264. * 16384.,
    (double)15205./3137161264. * 16384.,
    (double)7603./3137161264. * 16384.,
    (double)13826./3137161264. * 16384.,
    (double)15168./3137161264. * 16384.,
    (double)23948./3137161264. * 16384.,
    (double)8582./3137161264. * 16384.,
    (double)11885./3137161264. * 16384.,
    (double)10419./3137161264. * 16384.,
    (double)2402./3137161264. * 16384.,
    (double)6859./3137161264. * 16384.,
    (double)9171./3137161264. * 16384.,
    (double)9442./3137161264. * 16384.,
    (double)13825./3137161264. * 16384.,
    (double)6906./3137161264. * 16384.,
    (double)13091./3137161264. * 16384.,
    (double)13738./3137161264. * 16384.,
    (double)18670./3137161264. * 16384.,
    (double)7146./3137161264. * 16384.,
    (double)9216./3137161264. * 16384.,
    (double)21276./3137161264. * 16384.,
    (double)35384./3137161264. * 16384.,
    (double)14858./3137161264. * 16384.,
    (double)13625./3137161264. * 16384.,
    (double)14997./3137161264. * 16384.,
    (double)6136./3137161264. * 16384.,
    (double)15196./3137161264. * 16384.,
    (double)14891./3137161264. * 16384.,
    (double)8884./3137161264. * 16384.,
    (double)18313./3137161264. * 16384.,
    (double)9170./3137161264. * 16384.,
    (double)11074./3137161264. * 16384.,
    (double)9665./3137161264. * 16384.,
    (double)17392./3137161264. * 16384.,
    (double)9151./3137161264. * 16384.,
    (double)10492./3137161264. * 16384.,
    (double)2562./3137161264. * 16384.,
    (double)6223./3137161264. * 16384.,
    (double)4044./3137161264. * 16384.,
    (double)2742./3137161264. * 16384.,
    (double)16047./3137161264. * 16384.,
    (double)6428./3137161264. * 16384.,
    (double)19715./3137161264. * 16384.,
    (double)15987./3137161264. * 16384.,
    (double)9096./3137161264. * 16384.,
    (double)22576./3137161264. * 16384.,
    (double)13284./3137161264. * 16384.,
    (double)15359./3137161264. * 16384.,
    (double)11560./3137161264. * 16384.,
    (double)10708./3137161264. * 16384.,
    (double)6318./3137161264. * 16384.,
    (double)12857./3137161264. * 16384.,
    (double)17022./3137161264. * 16384.,
    (double)24288./3137161264. * 16384.,
    (double)11892./3137161264. * 16384.,
    (double)16856./3137161264. * 16384.,
    (double)13862./3137161264. * 16384.,
    (double)3447./3137161264. * 16384.,
    (double)12131./3137161264. * 16384.,
    (double)16446./3137161264. * 16384.,
    (double)12964./3137161264. * 16384.,
    (double)14704./3137161264. * 16384.,
    (double)11853./3137161264. * 16384.,
    (double)22989./3137161264. * 16384.,
    (double)149095./3137161264. * 16384.,
    (double)125305./3137161264. * 16384.,
    (double)65408./3137161264. * 16384.,
    (double)86485./3137161264. * 16384.,
    (double)136455./3137161264. * 16384.,
    (double)156437./3137161264. * 16384.,
    (double)110549./3137161264. * 16384.,
    (double)107934./3137161264. * 16384.,
    (double)131862./3137161264. * 16384.,
    (double)25955./3137161264. * 16384.,
    (double)77400./3137161264. * 16384.,
    (double)95419./3137161264. * 16384.,
    (double)88961./3137161264. * 16384.,
    (double)125143./3137161264. * 16384.,
    (double)93485./3137161264. * 16384.,
    (double)139663./3137161264. * 16384.,
    (double)11662./3137161264. * 16384.,
    (double)18037./3137161264. * 16384.,
    (double)7190./3137161264. * 16384.,
    (double)8386./3137161264. * 16384.,
    (double)12977./3137161264. * 16384.,
    (double)20690./3137161264. * 16384.,
    (double)15163./3137161264. * 16384.,
    (double)9605./3137161264. * 16384.,
    (double)13667./3137161264. * 16384.,
    (double)6283./3137161264. * 16384.,
    (double)13655./3137161264. * 16384.,
    (double)12052./3137161264. * 16384.,
    (double)10484./3137161264. * 16384.,
    (double)23947./3137161264. * 16384.,
    (double)12837./3137161264. * 16384.,
    (double)15189./3137161264. * 16384.,
    (double)111230./3137161264. * 16384.,
    (double)194662./3137161264. * 16384.,
    (double)101231./3137161264. * 16384.,
    (double)108204./3137161264. * 16384.,
    (double)16130./3137161264. * 16384.,
    (double)27777./3137161264. * 16384.,
    (double)19934./3137161264. * 16384.,
    (double)16587./3137161264. * 16384.,
    (double)165773./3137161264. * 16384.,
    (double)30805./3137161264. * 16384.,
    (double)79010./3137161264. * 16384.,
    (double)115801./3137161264. * 16384.,
    (double)80269./3137161264. * 16384.,
    (double)175651./3137161264. * 16384.,
    (double)116135./3137161264. * 16384.,
    (double)129420./3137161264. * 16384.,
    (double)103175./3137161264. * 16384.,
    (double)93941./3137161264. * 16384.,
    (double)62295./3137161264. * 16384.,
    (double)85682./3137161264. * 16384.,
    (double)136840./3137161264. * 16384.,
    (double)172328./3137161264. * 16384.,
    (double)121658./3137161264. * 16384.,
    (double)129075./3137161264. * 16384.,
    (double)170447./3137161264. * 16384.,
    (double)23194./3137161264. * 16384.,
    (double)123497./3137161264. * 16384.,
    (double)149237./3137161264. * 16384.,
    (double)113289./3137161264. * 16384.,
    (double)139672./3137161264. * 16384.,
    (double)133242./3137161264. * 16384.,
    (double)188911./3137161264. * 16384.,
    (double)150448./3137161264. * 16384.,
    (double)91312./3137161264. * 16384.,
    (double)62413./3137161264. * 16384.,
    (double)114278./3137161264. * 16384.,
    (double)103712./3137161264. * 16384.,
    (double)84115./3137161264. * 16384.,
    (double)61125./3137161264. * 16384.,
    (double)80578./3137161264. * 16384.,
    (double)112403./3137161264. * 16384.,
    (double)13375./3137161264. * 16384.,
    (double)65655./3137161264. * 16384.,
    (double)94490./3137161264. * 16384.,
    (double)115860./3137161264. * 16384.,
    (double)107843./3137161264. * 16384.,
    (double)73787./3137161264. * 16384.,
    (double)148638./3137161264. * 16384.,
    (double)169945./3137161264. * 16384.,
    (double)158103./3137161264. * 16384.,
    (double)87343./3137161264. * 16384.,
    (double)117957./3137161264. * 16384.,
    (double)146416./3137161264. * 16384.,
    (double)156614./3137161264. * 16384.,
    (double)113480./3137161264. * 16384.,
    (double)105748./3137161264. * 16384.,
    (double)152310./3137161264. * 16384.,
    (double)22215./3137161264. * 16384.,
    (double)110557./3137161264. * 16384.,
    (double)138413./3137161264. * 16384.,
    (double)131650./3137161264. * 16384.,
    (double)205850./3137161264. * 16384.,
    (double)128218./3137161264. * 16384.,
    (double)171714./3137161264. * 16384.,
    (double)196850./3137161264. * 16384.,
    (double)200107./3137161264. * 16384.,
    (double)139004./3137161264. * 16384.,
    (double)153834./3137161264. * 16384.,
    (double)25367./3137161264. * 16384.,
    (double)25458./3137161264. * 16384.,
    (double)27530./3137161264. * 16384.,
    (double)18162./3137161264. * 16384.,
    (double)180675./3137161264. * 16384.,
    (double)23343./3137161264. * 16384.,
    (double)140039./3137161264. * 16384.,
    (double)180940./3137161264. * 16384.,
    (double)157402./3137161264. * 16384.,
    (double)218295./3137161264. * 16384.,
    (double)163996./3137161264. * 16384.,
    (double)203428./3137161264. * 16384.,
    (double)152973./3137161264. * 16384.,
    (double)112807./3137161264. * 16384.,
    (double)93467./3137161264. * 16384.,
    (double)141175./3137161264. * 16384.,
    (double)139796./3137161264. * 16384.,
    (double)143104./3137161264. * 16384.,
    (double)120107./3137161264. * 16384.,
    (double)133268./3137161264. * 16384.,
    (double)200892./3137161264. * 16384.,
    (double)19606./3137161264. * 16384.,
    (double)165726./3137161264. * 16384.,
    (double)221579./3137161264. * 16384.,
    (double)199741./3137161264. * 16384.,
    (double)209989./3137161264. * 16384.,
    (double)196616./3137161264. * 16384.,
    (double)310359./3137161264. * 16384.,
    (double)374910./3137161264. * 16384.,
    (double)165193./3137161264. * 16384.,
    (double)125444./3137161264. * 16384.,
    (double)266547./3137161264. * 16384.,
    (double)168099./3137161264. * 16384.,
    (double)106997./3137161264. * 16384.,
    (double)78460./3137161264. * 16384.,
    (double)146257./3137161264. * 16384.,
    (double)155171./3137161264. * 16384.,
    (double)15282./3137161264. * 16384.,
    (double)63345./3137161264. * 16384.,
    (double)128989./3137161264. * 16384.,
    (double)202563./3137161264. * 16384.,
    (double)150954./3137161264. * 16384.,
    (double)88862./3137161264. * 16384.,
    (double)234535./3137161264. * 16384.,
    (double)187260./3137161264. * 16384.,
    (double)117738./3137161264. * 16384.,
    (double)63208./3137161264. * 16384.,
    (double)106841./3137161264. * 16384.,
    (double)125357./3137161264. * 16384.,
    (double)86954./3137161264. * 16384.,
    (double)63559./3137161264. * 16384.,
    (double)90358./3137161264. * 16384.,
    (double)106172./3137161264. * 16384.,
    (double)10317./3137161264. * 16384.,
    (double)59013./3137161264. * 16384.,
    (double)95128./3137161264. * 16384.,
    (double)91345./3137161264. * 16384.,
    (double)96582./3137161264. * 16384.,
    (double)57589./3137161264. * 16384.,
    (double)118957./3137161264. * 16384.,
    (double)147390./3137161264. * 16384.,
    (double)141018./3137161264. * 16384.,
    (double)81622./3137161264. * 16384.,
    (double)161833./3137161264. * 16384.,
    (double)13451./3137161264. * 16384.,
    (double)14133./3137161264. * 16384.,
    (double)8805./3137161264. * 16384.,
    (double)20910./3137161264. * 16384.,
    (double)115883./3137161264. * 16384.,
    (double)12022./3137161264. * 16384.,
    (double)61036./3137161264. * 16384.,
    (double)107270./3137161264. * 16384.,
    (double)111179./3137161264. * 16384.,
    (double)129142./3137161264. * 16384.,
    (double)83595./3137161264. * 16384.,
    (double)160752./3137161264. * 16384.,
    (double)191711./3137161264. * 16384.,
    (double)107751./3137161264. * 16384.,
    (double)86392./3137161264. * 16384.,
    (double)198867./3137161264. * 16384.,
    (double)128326./3137161264. * 16384.,
    (double)96648./3137161264. * 16384.,
    (double)77597./3137161264. * 16384.,
    (double)144815./3137161264. * 16384.,
    (double)132819./3137161264. * 16384.,
    (double)11164./3137161264. * 16384.,
    (double)76907./3137161264. * 16384.,
    (double)152784./3137161264. * 16384.,
    (double)207803./3137161264. * 16384.,
    (double)147880./3137161264. * 16384.,
    (double)136374./3137161264. * 16384.,
    (double)373227./3137161264. * 16384.,
    (double)250117./3137161264. * 16384.,
    (double)156048./3137161264. * 16384.,
    (double)97118./3137161264. * 16384.,
    (double)190242./3137161264. * 16384.,
    (double)162920./3137161264. * 16384.,
    (double)137587./3137161264. * 16384.,
    (double)80805./3137161264. * 16384.,
    (double)123636./3137161264. * 16384.,
    (double)118820./3137161264. * 16384.,
    (double)13174./3137161264. * 16384.,
    (double)59986./3137161264. * 16384.,
    (double)106833./3137161264. * 16384.,
    (double)119110./3137161264. * 16384.,
    (double)127123./3137161264. * 16384.,
    (double)67857./3137161264. * 16384.,
    (double)161844./3137161264. * 16384.,
    (double)180837./3137161264. * 16384.,
    (double)154427./3137161264. * 16384.,
    (double)63963./3137161264. * 16384.,
    (double)106652./3137161264. * 16384.,
    (double)155373./3137161264. * 16384.,
    (double)160090./3137161264. * 16384.,
    (double)75190./3137161264. * 16384.,
    (double)104958./3137161264. * 16384.,
    (double)128757./3137161264. * 16384.,
    (double)16758./3137161264. * 16384.,
    (double)81339./3137161264. * 16384.,
    (double)117971./3137161264. * 16384.,
    (double)94232./3137161264. * 16384.,
    (double)132011./3137161264. * 16384.,
    (double)68752./3137161264. * 16384.,
    (double)135603./3137161264. * 16384.,
    (double)119313./3137161264. * 16384.,
    (double)132940./3137161264. * 16384.,
    (double)66011./3137161264. * 16384.,
    (double)116414./3137161264. * 16384.,
    (double)9596./3137161264. * 16384.,
    (double)14714./3137161264. * 16384.,
    (double)7282./3137161264. * 16384.,
    (double)12287./3137161264. * 16384.,
    (double)131066./3137161264. * 16384.,
    (double)15464./3137161264. * 16384.,
    (double)87981./3137161264. * 16384.,
    (double)124583./3137161264. * 16384.,
    (double)108574./3137161264. * 16384.,
    (double)160883./3137161264. * 16384.,
    (double)94626./3137161264. * 16384.,
    (double)160611./3137161264. * 16384.,
    (double)136590./3137161264. * 16384.,
    (double)96399./3137161264. * 16384.,
    (double)71302./3137161264. * 16384.,
    (double)140146./3137161264. * 16384.,
    (double)135853./3137161264. * 16384.,
    (double)123833./3137161264. * 16384.,
    (double)76394./3137161264. * 16384.,
    (double)141270./3137161264. * 16384.,
    (double)129818./3137161264. * 16384.,
    (double)12024./3137161264. * 16384.,
    (double)80692./3137161264. * 16384.,
    (double)137895./3137161264. * 16384.,
    (double)146929./3137161264. * 16384.,
    (double)172355./3137161264. * 16384.,
    (double)114178./3137161264. * 16384.,
    (double)275350./3137161264. * 16384.,
    (double)211781./3137161264. * 16384.,
    (double)177738./3137161264. * 16384.,
    (double)97185./3137161264. * 16384.,
    (double)141415./3137161264. * 16384.,
    (double)165074./3137161264. * 16384.,
    (double)137415./3137161264. * 16384.,
    (double)106760./3137161264. * 16384.,
    (double)146980./3137161264. * 16384.,
    (double)164801./3137161264. * 16384.,
    (double)24388./3137161264. * 16384.,
    (double)81032./3137161264. * 16384.,
    (double)134714./3137161264. * 16384.,
    (double)142857./3137161264. * 16384.,
    (double)146393./3137161264. * 16384.,
    (double)118712./3137161264. * 16384.,
    (double)225515./3137161264. * 16384.,
    (double)14565./3137161264. * 16384.,
    (double)28305./3137161264. * 16384.,
    (double)7183./3137161264. * 16384.,
    (double)11345./3137161264. * 16384.,
    (double)11289./3137161264. * 16384.,
    (double)14724./3137161264. * 16384.,
    (double)9769./3137161264. * 16384.,
    (double)11691./3137161264. * 16384.,
    (double)10847./3137161264. * 16384.,
    (double)3227./3137161264. * 16384.,
    (double)8683./3137161264. * 16384.,
    (double)12387./3137161264. * 16384.,
    (double)12343./3137161264. * 16384.,
    (double)19599./3137161264. * 16384.,
    (double)9917./3137161264. * 16384.,
    (double)20282./3137161264. * 16384.,
    (double)133981./3137161264. * 16384.,
    (double)167396./3137161264. * 16384.,
    (double)94669./3137161264. * 16384.,
    (double)141560./3137161264. * 16384.,
    (double)12167./3137161264. * 16384.,
    (double)16088./3137161264. * 16384.,
    (double)11380./3137161264. * 16384.,
    (double)16571./3137161264. * 16384.,
    (double)161980./3137161264. * 16384.,
    (double)21323./3137161264. * 16384.,
    (double)97834./3137161264. * 16384.,
    (double)147437./3137161264. * 16384.,
    (double)112210./3137161264. * 16384.,
    (double)172900./3137161264. * 16384.,
    (double)135058./3137161264. * 16384.,
    (double)189703./3137161264. * 16384.,
    (double)154040./3137161264. * 16384.,
    (double)126337./3137161264. * 16384.,
    (double)87702./3137161264. * 16384.,
    (double)147434./3137161264. * 16384.,
    (double)175044./3137161264. * 16384.,
    (double)169637./3137161264. * 16384.,
    (double)130525./3137161264. * 16384.,
    (double)196097./3137161264. * 16384.,
    (double)206060./3137161264. * 16384.,
    (double)20239./3137161264. * 16384.,
    (double)135815./3137161264. * 16384.,
    (double)209056./3137161264. * 16384.,
    (double)172691./3137161264. * 16384.,
    (double)166427./3137161264. * 16384.,
    (double)170134./3137161264. * 16384.,
    (double)298008./3137161264. * 16384.,
    (double)334995./3137161264. * 16384.,
    (double)158610./3137161264. * 16384.,
    (double)115579./3137161264. * 16384.,
    (double)236862./3137161264. * 16384.,
    (double)159320./3137161264. * 16384.,
    (double)111545./3137161264. * 16384.,
    (double)87296./3137161264. * 16384.,
    (double)128897./3137161264. * 16384.,
    (double)189730./3137161264. * 16384.,
    (double)17202./3137161264. * 16384.,
    (double)89821./3137161264. * 16384.,
    (double)163604./3137161264. * 16384.,
    (double)253454./3137161264. * 16384.,
    (double)182971./3137161264. * 16384.,
    (double)142981./3137161264. * 16384.,
    (double)361935./3137161264. * 16384.,
    (double)234117./3137161264. * 16384.,
    (double)191857./3137161264. * 16384.,
    (double)93154./3137161264. * 16384.,
    (double)153761./3137161264. * 16384.,
    (double)184669./3137161264. * 16384.,
    (double)177518./3137161264. * 16384.,
    (double)111425./3137161264. * 16384.,
    (double)146455./3137161264. * 16384.,
    (double)178300./3137161264. * 16384.,
    (double)16736./3137161264. * 16384.,
    (double)110026./3137161264. * 16384.,
    (double)193749./3137161264. * 16384.,
    (double)172888./3137161264. * 16384.,
    (double)201347./3137161264. * 16384.,
    (double)125914./3137161264. * 16384.,
    (double)311589./3137161264. * 16384.,
    (double)216553./3137161264. * 16384.,
    (double)217020./3137161264. * 16384.,
    (double)159273./3137161264. * 16384.,
    (double)234644./3137161264. * 16384.,
    (double)15824./3137161264. * 16384.,
    (double)17075./3137161264. * 16384.,
    (double)16502./3137161264. * 16384.,
    (double)21248./3137161264. * 16384.,
    (double)244603./3137161264. * 16384.,
    (double)21130./3137161264. * 16384.,
    (double)168337./3137161264. * 16384.,
    (double)290391./3137161264. * 16384.,
    (double)224265./3137161264. * 16384.,
    (double)276044./3137161264. * 16384.,
    (double)240271./3137161264. * 16384.,
    (double)356341./3137161264. * 16384.,
    (double)398364./3137161264. * 16384.,
    (double)208324./3137161264. * 16384.,
    (double)179302./3137161264. * 16384.,
    (double)387502./3137161264. * 16384.,
    (double)258770./3137161264. * 16384.,
    (double)219695./3137161264. * 16384.,
    (double)182399./3137161264. * 16384.,
    (double)324940./3137161264. * 16384.,
    (double)338528./3137161264. * 16384.,
    (double)23264./3137161264. * 16384.,
    (double)251299./3137161264. * 16384.,
    (double)449222./3137161264. * 16384.,
    (double)426345./3137161264. * 16384.,
    (double)325108./3137161264. * 16384.,
    (double)333940./3137161264. * 16384.,
    (double)494735./3137161264. * 16384.,
    (double)798709./3137161264. * 16384.,
    (double)400108./3137161264. * 16384.,
    (double)374637./3137161264. * 16384.,
    (double)632358./3137161264. * 16384.,
    (double)423996./3137161264. * 16384.,
    (double)255530./3137161264. * 16384.,
    (double)251960./3137161264. * 16384.,
    (double)284923./3137161264. * 16384.,
    (double)488011./3137161264. * 16384.,
    (double)43967./3137161264. * 16384.,
    (double)237222./3137161264. * 16384.,
    (double)324967./3137161264. * 16384.,
    (double)582119./3137161264. * 16384.,
    (double)422639./3137161264. * 16384.,
    (double)277821./3137161264. * 16384.,
    (double)463336./3137161264. * 16384.,
    (double)483375./3137161264. * 16384.,
    (double)290179./3137161264. * 16384.,
    (double)225116./3137161264. * 16384.,
    (double)278876./3137161264. * 16384.,
    (double)304067./3137161264. * 16384.,
    (double)198620./3137161264. * 16384.,
    (double)197235./3137161264. * 16384.,
    (double)176285./3137161264. * 16384.,
    (double)303608./3137161264. * 16384.,
    (double)28859./3137161264. * 16384.,
    (double)202219./3137161264. * 16384.,
    (double)223178./3137161264. * 16384.,
    (double)239010./3137161264. * 16384.,
    (double)244890./3137161264. * 16384.,
    (double)197933./3137161264. * 16384.,
    (double)248607./3137161264. * 16384.,
    (double)402894./3137161264. * 16384.,
    (double)232878./3137161264. * 16384.,
    (double)225152./3137161264. * 16384.,
    (double)285525./3137161264. * 16384.,
    (double)30756./3137161264. * 16384.,
    (double)24330./3137161264. * 16384.,
    (double)23378./3137161264. * 16384.,
    (double)37730./3137161264. * 16384.,
    (double)233864./3137161264. * 16384.,
    (double)21264./3137161264. * 16384.,
    (double)142639./3137161264. * 16384.,
    (double)177243./3137161264. * 16384.,
    (double)209352./3137161264. * 16384.,
    (double)227526./3137161264. * 16384.,
    (double)186508./3137161264. * 16384.,
    (double)230651./3137161264. * 16384.,
    (double)477895./3137161264. * 16384.,
    (double)220059./3137161264. * 16384.,
    (double)235695./3137161264. * 16384.,
    (double)452595./3137161264. * 16384.,
    (double)341823./3137161264. * 16384.,
    (double)243011./3137161264. * 16384.,
    (double)225562./3137161264. * 16384.,
    (double)322923./3137161264. * 16384.,
    (double)263175./3137161264. * 16384.,
    (double)22202./3137161264. * 16384.,
    (double)178125./3137161264. * 16384.,
    (double)243221./3137161264. * 16384.,
    (double)349911./3137161264. * 16384.,
    (double)221060./3137161264. * 16384.,
    (double)252647./3137161264. * 16384.,
    (double)410272./3137161264. * 16384.,
    (double)457369./3137161264. * 16384.,
    (double)266052./3137161264. * 16384.,
    (double)178676./3137161264. * 16384.,
    (double)256015./3137161264. * 16384.,
    (double)277505./3137161264. * 16384.,
    (double)191287./3137161264. * 16384.,
    (double)153922./3137161264. * 16384.,
    (double)168753./3137161264. * 16384.,
    (double)216098./3137161264. * 16384.,
    (double)25495./3137161264. * 16384.,
    (double)151755./3137161264. * 16384.,
    (double)178757./3137161264. * 16384.,
    (double)189018./3137161264. * 16384.,
    (double)201100./3137161264. * 16384.,
    (double)145412./3137161264. * 16384.,
    (double)205578./3137161264. * 16384.,
    (double)315138./3137161264. * 16384.,
    (double)228423./3137161264. * 16384.,
    (double)142768./3137161264. * 16384.,
    (double)165834./3137161264. * 16384.,
    (double)187825./3137161264. * 16384.,
    (double)129883./3137161264. * 16384.,
    (double)129536./3137161264. * 16384.,
    (double)118326./3137161264. * 16384.,
    (double)207936./3137161264. * 16384.,
    (double)27209./3137161264. * 16384.,
    (double)148849./3137161264. * 16384.,
    (double)177896./3137161264. * 16384.,
    (double)135383./3137161264. * 16384.,
    (double)163826./3137161264. * 16384.,
    (double)150209./3137161264. * 16384.,
    (double)157926./3137161264. * 16384.,
    (double)201531./3137161264. * 16384.,
    (double)188107./3137161264. * 16384.,
    (double)131613./3137161264. * 16384.,
    (double)160171./3137161264. * 16384.,
    (double)20622./3137161264. * 16384.,
    (double)19048./3137161264. * 16384.,
    (double)17450./3137161264. * 16384.,
    (double)21914./3137161264. * 16384.,
    (double)168880./3137161264. * 16384.,
    (double)19277./3137161264. * 16384.,
    (double)120174./3137161264. * 16384.,
    (double)143523./3137161264. * 16384.,
    (double)110237./3137161264. * 16384.,
    (double)169124./3137161264. * 16384.,
    (double)124543./3137161264. * 16384.,
    (double)134989./3137161264. * 16384.,
    (double)190438./3137161264. * 16384.,
    (double)130765./3137161264. * 16384.,
    (double)98980./3137161264. * 16384.,
    (double)160991./3137161264. * 16384.,
    (double)191882./3137161264. * 16384.,
    (double)150398./3137161264. * 16384.,
    (double)123960./3137161264. * 16384.,
    (double)165631./3137161264. * 16384.,
    (double)172663./3137161264. * 16384.,
    (double)14881./3137161264. * 16384.,
    (double)126596./3137161264. * 16384.,
    (double)166362./3137161264. * 16384.,
    (double)160933./3137161264. * 16384.,
    (double)138171./3137161264. * 16384.,
    (double)151519./3137161264. * 16384.,
    (double)235581./3137161264. * 16384.,
    (double)386768./3137161264. * 16384.,
    (double)150317./3137161264. * 16384.,
    (double)191844./3137161264. * 16384.,
    (double)198499./3137161264. * 16384.,
    (double)263746./3137161264. * 16384.,
    (double)149657./3137161264. * 16384.,
    (double)154974./3137161264. * 16384.,
    (double)159375./3137161264. * 16384.,
    (double)221871./3137161264. * 16384.,
    (double)28268./3137161264. * 16384.,
    (double)115983./3137161264. * 16384.,
    (double)166916./3137161264. * 16384.,
    (double)200205./3137161264. * 16384.,
    (double)185050./3137161264. * 16384.,
    (double)149807./3137161264. * 16384.,
    (double)240114./3137161264. * 16384.,
    (double)27070./3137161264. * 16384.,
    (double)20503./3137161264. * 16384.,
    (double)14324./3137161264. * 16384.,
    (double)17769./3137161264. * 16384.,
    (double)20504./3137161264. * 16384.,
    (double)17746./3137161264. * 16384.,
    (double)14960./3137161264. * 16384.,
    (double)14653./3137161264. * 16384.,
    (double)19611./3137161264. * 16384.,
    (double)4437./3137161264. * 16384.,
    (double)15661./3137161264. * 16384.,
    (double)18998./3137161264. * 16384.,
    (double)23620./3137161264. * 16384.,
    (double)34868./3137161264. * 16384.,
    (double)20702./3137161264. * 16384.,
    (double)27119./3137161264. * 16384.,
    (double)163416./3137161264. * 16384.,
    (double)132322./3137161264. * 16384.,
    (double)123808./3137161264. * 16384.,
    (double)128242./3137161264. * 16384.,
    (double)15042./3137161264. * 16384.,
    (double)12421./3137161264. * 16384.,
    (double)14259./3137161264. * 16384.,
    (double)15749./3137161264. * 16384.,
    (double)145305./3137161264. * 16384.,
    (double)17085./3137161264. * 16384.,
    (double)111489./3137161264. * 16384.,
    (double)117986./3137161264. * 16384.,
    (double)110880./3137161264. * 16384.,
    (double)134263./3137161264. * 16384.,
    (double)154923./3137161264. * 16384.,
    (double)130650./3137161264. * 16384.,
    (double)142405./3137161264. * 16384.,
    (double)90387./3137161264. * 16384.,
    (double)92432./3137161264. * 16384.,
    (double)136564./3137161264. * 16384.,
    (double)167291./3137161264. * 16384.,
    (double)130026./3137161264. * 16384.,
    (double)119019./3137161264. * 16384.,
    (double)153775./3137161264. * 16384.,
    (double)164080./3137161264. * 16384.,
    (double)16905./3137161264. * 16384.,
    (double)125964./3137161264. * 16384.,
    (double)175510./3137161264. * 16384.,
    (double)141902./3137161264. * 16384.,
    (double)139124./3137161264. * 16384.,
    (double)158241./3137161264. * 16384.,
    (double)234967./3137161264. * 16384.,
    (double)458137./3137161264. * 16384.,
    (double)160513./3137161264. * 16384.,
    (double)152955./3137161264. * 16384.,
    (double)272324./3137161264. * 16384.,
    (double)178167./3137161264. * 16384.,
    (double)105275./3137161264. * 16384.,
    (double)119547./3137161264. * 16384.,
    (double)124599./3137161264. * 16384.,
    (double)182615./3137161264. * 16384.,
    (double)17939./3137161264. * 16384.,
    (double)94623./3137161264. * 16384.,
    (double)137920./3137161264. * 16384.,
    (double)236472./3137161264. * 16384.,
    (double)174117./3137161264. * 16384.,
    (double)145798./3137161264. * 16384.,
    (double)305201./3137161264. * 16384.,
    (double)285020./3137161264. * 16384.,
    (double)180655./3137161264. * 16384.,
    (double)139162./3137161264. * 16384.,
    (double)172484./3137161264. * 16384.,
    (double)180127./3137161264. * 16384.,
    (double)130138./3137161264. * 16384.,
    (double)122742./3137161264. * 16384.,
    (double)121650./3137161264. * 16384.,
    (double)172210./3137161264. * 16384.,
    (double)15590./3137161264. * 16384.,
    (double)123726./3137161264. * 16384.,
    (double)151306./3137161264. * 16384.,
    (double)176216./3137161264. * 16384.,
    (double)184855./3137161264. * 16384.,
    (double)141303./3137161264. * 16384.,
    (double)206077./3137161264. * 16384.,
    (double)173408./3137161264. * 16384.,
    (double)142690./3137161264. * 16384.,
    (double)118009./3137161264. * 16384.,
    (double)156833./3137161264. * 16384.,
    (double)13666./3137161264. * 16384.,
    (double)11126./3137161264. * 16384.,
    (double)11802./3137161264. * 16384.,
    (double)15154./3137161264. * 16384.,
    (double)130781./3137161264. * 16384.,
    (double)11235./3137161264. * 16384.,
    (double)101035./3137161264. * 16384.,
    (double)129410./3137161264. * 16384.,
    (double)121890./3137161264. * 16384.,
    (double)140795./3137161264. * 16384.,
    (double)132775./3137161264. * 16384.,
    (double)157682./3137161264. * 16384.,
    (double)252128./3137161264. * 16384.,
    (double)130463./3137161264. * 16384.,
    (double)130516./3137161264. * 16384.,
    (double)243007./3137161264. * 16384.,
    (double)128778./3137161264. * 16384.,
    (double)88934./3137161264. * 16384.,
    (double)101560./3137161264. * 16384.,
    (double)143268./3137161264. * 16384.,
    (double)206238./3137161264. * 16384.,
    (double)15834./3137161264. * 16384.,
    (double)147058./3137161264. * 16384.,
    (double)228147./3137161264. * 16384.,
    (double)270996./3137161264. * 16384.,
    (double)208483./3137161264. * 16384.,
    (double)235505./3137161264. * 16384.,
    (double)423107./3137161264. * 16384.,
    (double)613819./3137161264. * 16384.,
    (double)389017./3137161264. * 16384.,
    (double)288246./3137161264. * 16384.,
    (double)445519./3137161264. * 16384.,
    (double)348819./3137161264. * 16384.,
    (double)273634./3137161264. * 16384.,
    (double)237158./3137161264. * 16384.,
    (double)248253./3137161264. * 16384.,
    (double)263898./3137161264. * 16384.,
    (double)31994./3137161264. * 16384.,
    (double)150013./3137161264. * 16384.,
    (double)228856./3137161264. * 16384.,
    (double)290639./3137161264. * 16384.,
    (double)275733./3137161264. * 16384.,
    (double)194362./3137161264. * 16384.,
    (double)316333./3137161264. * 16384.,
    (double)436870./3137161264. * 16384.,
    (double)358160./3137161264. * 16384.,
    (double)229586./3137161264. * 16384.,
    (double)260511./3137161264. * 16384.,
    (double)305477./3137161264. * 16384.,
    (double)252749./3137161264. * 16384.,
    (double)248008./3137161264. * 16384.,
    (double)204992./3137161264. * 16384.,
    (double)282868./3137161264. * 16384.,
    (double)44545./3137161264. * 16384.,
    (double)230159./3137161264. * 16384.,
    (double)255619./3137161264. * 16384.,
    (double)176889./3137161264. * 16384.,
    (double)236584./3137161264. * 16384.,
    (double)181718./3137161264. * 16384.,
    (double)224811./3137161264. * 16384.,
    (double)222320./3137161264. * 16384.,
    (double)227440./3137161264. * 16384.,
    (double)209031./3137161264. * 16384.,
    (double)217643./3137161264. * 16384.,
    (double)25097./3137161264. * 16384.,
    (double)32011./3137161264. * 16384.,
    (double)27840./3137161264. * 16384.,
    (double)33108./3137161264. * 16384.,
    (double)154436./3137161264. * 16384.,
    (double)19144./3137161264. * 16384.,
    (double)131995./3137161264. * 16384.,
    (double)144065./3137161264. * 16384.,
    (double)119958./3137161264. * 16384.,
    (double)181293./3137161264. * 16384.,
    (double)142175./3137161264. * 16384.,
    (double)183238./3137161264. * 16384.,
    (double)248269./3137161264. * 16384.,
    (double)131637./3137161264. * 16384.,
    (double)139545./3137161264. * 16384.,
    (double)220501./3137161264. * 16384.,
    (double)261370./3137161264. * 16384.,
    (double)214581./3137161264. * 16384.,
    (double)172287./3137161264. * 16384.,
    (double)211763./3137161264. * 16384.,
    (double)161834./3137161264. * 16384.,
    (double)17527./3137161264. * 16384.,
    (double)117586./3137161264. * 16384.,
    (double)164061./3137161264. * 16384.,
    (double)175998./3137161264. * 16384.,
    (double)146004./3137161264. * 16384.,
    (double)179381./3137161264. * 16384.,
    (double)305067./3137161264. * 16384.,
    (double)424426./3137161264. * 16384.,
    (double)354623./3137161264. * 16384.,
    (double)177334./3137161264. * 16384.,
    (double)247546./3137161264. * 16384.,
    (double)324770./3137161264. * 16384.,
    (double)316994./3137161264. * 16384.,
    (double)205228./3137161264. * 16384.,
    (double)208836./3137161264. * 16384.,
    (double)210955./3137161264. * 16384.,
    (double)31934./3137161264. * 16384.,
    (double)133404./3137161264. * 16384.,
    (double)168839./3137161264. * 16384.,
    (double)155222./3137161264. * 16384.,
    (double)203989./3137161264. * 16384.,
    (double)123902./3137161264. * 16384.,
    (double)184785./3137161264. * 16384.,
    (double)303443./3137161264. * 16384.,
    (double)301067./3137161264. * 16384.,
    (double)173263./3137161264. * 16384.,
    (double)175273./3137161264. * 16384.,
    (double)203909./3137161264. * 16384.,
    (double)121473./3137161264. * 16384.,
    (double)174071./3137161264. * 16384.,
    (double)147324./3137161264. * 16384.,
    (double)228420./3137161264. * 16384.,
    (double)40111./3137161264. * 16384.,
    (double)197392./3137161264. * 16384.,
    (double)224889./3137161264. * 16384.,
    (double)119906./3137161264. * 16384.,
    (double)194248./3137161264. * 16384.,
    (double)161871./3137161264. * 16384.,
    (double)168107./3137161264. * 16384.,
    (double)207598./3137161264. * 16384.,
    (double)306693./3137161264. * 16384.,
    (double)215978./3137161264. * 16384.,
    (double)234291./3137161264. * 16384.,
    (double)27256./3137161264. * 16384.,
    (double)47791./3137161264. * 16384.,
    (double)47911./3137161264. * 16384.,
    (double)54035./3137161264. * 16384.,
    (double)202069./3137161264. * 16384.,
    (double)39763./3137161264. * 16384.,
    (double)175342./3137161264. * 16384.,
    (double)196015./3137161264. * 16384.,
    (double)120510./3137161264. * 16384.,
    (double)319390./3137161264. * 16384.,
    (double)170935./3137161264. * 16384.,
    (double)187007./3137161264. * 16384.,
    (double)163494./3137161264. * 16384.,
    (double)133419./3137161264. * 16384.,
    (double)106430./3137161264. * 16384.,
    (double)145720./3137161264. * 16384.,
    (double)206093./3137161264. * 16384.,
    (double)215926./3137161264. * 16384.,
    (double)170303./3137161264. * 16384.,
    (double)193665./3137161264. * 16384.,
    (double)148804./3137161264. * 16384.,
    (double)18513./3137161264. * 16384.,
    (double)116777./3137161264. * 16384.,
    (double)151224./3137161264. * 16384.,
    (double)117461./3137161264. * 16384.,
    (double)140462./3137161264. * 16384.,
    (double)128883./3137161264. * 16384.,
    (double)207968./3137161264. * 16384.,
    (double)305165./3137161264. * 16384.,
    (double)216318./3137161264. * 16384.,
    (double)154790./3137161264. * 16384.,
    (double)204375./3137161264. * 16384.,
    (double)268440./3137161264. * 16384.,
    (double)261103./3137161264. * 16384.,
    (double)260190./3137161264. * 16384.,
    (double)197966./3137161264. * 16384.,
    (double)228169./3137161264. * 16384.,
    (double)38120./3137161264. * 16384.,
    (double)163574./3137161264. * 16384.,
    (double)215925./3137161264. * 16384.,
    (double)151490./3137161264. * 16384.,
    (double)201436./3137161264. * 16384.,
    (double)178547./3137161264. * 16384.,
    (double)236154./3137161264. * 16384.,
    (double)24792./3137161264. * 16384.,
    (double)39424./3137161264. * 16384.,
    (double)20534./3137161264. * 16384.,
    (double)22058./3137161264. * 16384.,
    (double)24734./3137161264. * 16384.,
    (double)40721./3137161264. * 16384.,
    (double)36858./3137161264. * 16384.,
    (double)22059./3137161264. * 16384.,
    (double)25988./3137161264. * 16384.,
    (double)11916./3137161264. * 16384.,
    (double)35791./3137161264. * 16384.,
    (double)31759./3137161264. * 16384.,
    (double)17553./3137161264. * 16384.,
    (double)44731./3137161264. * 16384.,
    (double)29361./3137161264. * 16384.,
    (double)29371./3137161264. * 16384.,
    (double)208691./3137161264. * 16384.,
    (double)254432./3137161264. * 16384.,
    (double)206926./3137161264. * 16384.,
    (double)199221./3137161264. * 16384.,
    (double)25853./3137161264. * 16384.,
    (double)37784./3137161264. * 16384.,
    (double)37902./3137161264. * 16384.,
    (double)28271./3137161264. * 16384.,
    (double)214473./3137161264. * 16384.,
    (double)38964./3137161264. * 16384.,
    (double)203132./3137161264. * 16384.,
    (double)207311./3137161264. * 16384.,
    (double)130111./3137161264. * 16384.,
    (double)288847./3137161264. * 16384.,
    (double)274077./3137161264. * 16384.,
    (double)215972./3137161264. * 16384.,
    (double)156293./3137161264. * 16384.,
    (double)111900./3137161264. * 16384.,
    (double)142301./3137161264. * 16384.,
    (double)143409./3137161264. * 16384.,
    (double)208347./3137161264. * 16384.,
    (double)231733./3137161264. * 16384.,
    (double)216330./3137161264. * 16384.,
    (double)209562./3137161264. * 16384.,
    (double)191984./3137161264. * 16384.,
    (double)25117./3137161264. * 16384.,
    (double)203429./3137161264. * 16384.,
    (double)231526./3137161264. * 16384.,
    (double)123241./3137161264. * 16384.,
    (double)160205./3137161264. * 16384.,
    (double)211069./3137161264. * 16384.,
    (double)252603./3137161264. * 16384.,
    (double)261683./3137161264. * 16384.,
    (double)155540./3137161264. * 16384.,
    (double)120193./3137161264. * 16384.,
    (double)188844./3137161264. * 16384.,
    (double)153063./3137161264. * 16384.,
    (double)119142./3137161264. * 16384.,
    (double)110418./3137161264. * 16384.,
    (double)121926./3137161264. * 16384.,
    (double)128824./3137161264. * 16384.,
    (double)13678./3137161264. * 16384.,
    (double)82093./3137161264. * 16384.,
    (double)117629./3137161264. * 16384.,
    (double)144903./3137161264. * 16384.,
    (double)131514./3137161264. * 16384.,
    (double)111761./3137161264. * 16384.,
    (double)206101./3137161264. * 16384.,
    (double)264270./3137161264. * 16384.,
    (double)247991./3137161264. * 16384.,
    (double)160450./3137161264. * 16384.,
    (double)194933./3137161264. * 16384.,
    (double)198588./3137161264. * 16384.,
    (double)209213./3137161264. * 16384.,
    (double)180718./3137161264. * 16384.,
    (double)183510./3137161264. * 16384.,
    (double)166051./3137161264. * 16384.,
    (double)21605./3137161264. * 16384.,
    (double)162989./3137161264. * 16384.,
    (double)196432./3137161264. * 16384.,
    (double)144507./3137161264. * 16384.,
    (double)218729./3137161264. * 16384.,
    (double)161681./3137161264. * 16384.,
    (double)226735./3137161264. * 16384.,
    (double)147310./3137161264. * 16384.,
    (double)162909./3137161264. * 16384.,
    (double)144753./3137161264. * 16384.,
    (double)173718./3137161264. * 16384.,
    (double)13381./3137161264. * 16384.,
    (double)17948./3137161264. * 16384.,
    (double)14709./3137161264. * 16384.,
    (double)18096./3137161264. * 16384.,
    (double)126990./3137161264. * 16384.,
    (double)14991./3137161264. * 16384.,
    (double)123878./3137161264. * 16384.,
    (double)148786./3137161264. * 16384.,
    (double)115159./3137161264. * 16384.,
    (double)166802./3137161264. * 16384.,
    (double)171527./3137161264. * 16384.,
    (double)189533./3137161264. * 16384.,
    (double)182314./3137161264. * 16384.,
    (double)111039./3137161264. * 16384.,
    (double)120237./3137161264. * 16384.,
    (double)170651./3137161264. * 16384.,
    (double)146019./3137161264. * 16384.,
    (double)127677./3137161264. * 16384.,
    (double)111597./3137161264. * 16384.,
    (double)153776./3137161264. * 16384.,
    (double)167980./3137161264. * 16384.,
    (double)15100./3137161264. * 16384.,
    (double)149806./3137161264. * 16384.,
    (double)223135./3137161264. * 16384.,
    (double)203278./3137161264. * 16384.,
    (double)210225./3137161264. * 16384.,
    (double)264123./3137161264. * 16384.,
    (double)367481./3137161264. * 16384.,
    (double)401863./3137161264. * 16384.,
    (double)254860./3137161264. * 16384.,
    (double)189747./3137161264. * 16384.,
    (double)286132./3137161264. * 16384.,
    (double)178061./3137161264. * 16384.,
    (double)152773./3137161264. * 16384.,
    (double)118869./3137161264. * 16384.,
    (double)135471./3137161264. * 16384.,
    (double)183254./3137161264. * 16384.,
    (double)21195./3137161264. * 16384.,
    (double)103320./3137161264. * 16384.,
    (double)138894./3137161264. * 16384.,
    (double)192782./3137161264. * 16384.,
    (double)183800./3137161264. * 16384.,
    (double)118118./3137161264. * 16384.,
    (double)205021./3137161264. * 16384.,
    (double)353334./3137161264. * 16384.,
    (double)313667./3137161264. * 16384.,
    (double)189998./3137161264. * 16384.,
    (double)221841./3137161264. * 16384.,
    (double)228302./3137161264. * 16384.,
    (double)212286./3137161264. * 16384.,
    (double)184198./3137161264. * 16384.,
    (double)161681./3137161264. * 16384.,
    (double)277058./3137161264. * 16384.,
    (double)37796./3137161264. * 16384.,
    (double)206964./3137161264. * 16384.,
    (double)218376./3137161264. * 16384.,
    (double)169707./3137161264. * 16384.,
    (double)249341./3137161264. * 16384.,
    (double)144210./3137161264. * 16384.,
    (double)194519./3137161264. * 16384.,
    (double)249706./3137161264. * 16384.,
    (double)295339./3137161264. * 16384.,
    (double)485212./3137161264. * 16384.,
    (double)270580./3137161264. * 16384.,
    (double)28002./3137161264. * 16384.,
    (double)38588./3137161264. * 16384.,
    (double)40530./3137161264. * 16384.,
    (double)45227./3137161264. * 16384.,
    (double)169320./3137161264. * 16384.,
    (double)23795./3137161264. * 16384.,
    (double)146200./3137161264. * 16384.,
    (double)155670./3137161264. * 16384.,
    (double)109899./3137161264. * 16384.,
    (double)199543./3137161264. * 16384.,
    (double)143301./3137161264. * 16384.,
    (double)172212./3137161264. * 16384.,
    (double)223318./3137161264. * 16384.,
    (double)155148./3137161264. * 16384.,
    (double)169762./3137161264. * 16384.,
    (double)250794./3137161264. * 16384.,
    (double)189188./3137161264. * 16384.,
    (double)205681./3137161264. * 16384.,
    (double)172584./3137161264. * 16384.,
    (double)206892./3137161264. * 16384.,
    (double)183495./3137161264. * 16384.,
    (double)20132./3137161264. * 16384.,
    (double)145393./3137161264. * 16384.,
    (double)193449./3137161264. * 16384.,
    (double)189148./3137161264. * 16384.,
    (double)167331./3137161264. * 16384.,
    (double)192443./3137161264. * 16384.,
    (double)365729./3137161264. * 16384.,
    (double)31429./3137161264. * 16384.,
    (double)30456./3137161264. * 16384.,
    (double)18532./3137161264. * 16384.,
    (double)24162./3137161264. * 16384.,
    (double)30743./3137161264. * 16384.,
    (double)33396./3137161264. * 16384.,
    (double)20788./3137161264. * 16384.,
    (double)19992./3137161264. * 16384.,
    (double)21869./3137161264. * 16384.,
    (double)4799./3137161264. * 16384.,
    (double)16166./3137161264. * 16384.,
    (double)17819./3137161264. * 16384.,
    (double)17468./3137161264. * 16384.,
    (double)28089./3137161264. * 16384.,
    (double)17496./3137161264. * 16384.,
    (double)22478./3137161264. * 16384.,
    (double)33790./3137161264. * 16384.,
    (double)42015./3137161264. * 16384.,
    (double)21855./3137161264. * 16384.,
    (double)21919./3137161264. * 16384.,
    (double)31941./3137161264. * 16384.,
    (double)38192./3137161264. * 16384.,
    (double)28041./3137161264. * 16384.,
    (double)20688./3137161264. * 16384.,
    (double)35777./3137161264. * 16384.,
    (double)10591./3137161264. * 16384.,
    (double)33040./3137161264. * 16384.,
    (double)29455./3137161264. * 16384.,
    (double)18846./3137161264. * 16384.,
    (double)41241./3137161264. * 16384.,
    (double)20978./3137161264. * 16384.,
    (double)22708./3137161264. * 16384.,
    (double)21682./3137161264. * 16384.,
    (double)38362./3137161264. * 16384.,
    (double)35458./3137161264. * 16384.,
    (double)25565./3137161264. * 16384.,
    (double)4204./3137161264. * 16384.,
    (double)9751./3137161264. * 16384.,
    (double)10028./3137161264. * 16384.,
    (double)6524./3137161264. * 16384.,
    (double)31387./3137161264. * 16384.,
    (double)8328./3137161264. * 16384.,
    (double)38227./3137161264. * 16384.,
    (double)33445./3137161264. * 16384.,
    (double)15242./3137161264. * 16384.,
    (double)40610./3137161264. * 16384.,
    (double)24142./3137161264. * 16384.,
    (double)22899./3137161264. * 16384.,
    (double)30319./3137161264. * 16384.,
    (double)24889./3137161264. * 16384.,
    (double)21549./3137161264. * 16384.,
    (double)32629./3137161264. * 16384.,
    (double)43459./3137161264. * 16384.,
    (double)59591./3137161264. * 16384.,
    (double)43634./3137161264. * 16384.,
    (double)50753./3137161264. * 16384.,
    (double)27714./3137161264. * 16384.,
    (double)5502./3137161264. * 16384.,
    (double)27824./3137161264. * 16384.,
    (double)33915./3137161264. * 16384.,
    (double)26514./3137161264. * 16384.,
    (double)34200./3137161264. * 16384.,
    (double)30047./3137161264. * 16384.,
    (double)46605./3137161264. * 16384.,
    (double)220234./3137161264. * 16384.,
    (double)156960./3137161264. * 16384.,
    (double)114975./3137161264. * 16384.,
    (double)120991./3137161264. * 16384.,
    (double)157780./3137161264. * 16384.,
    (double)171211./3137161264. * 16384.,
    (double)154206./3137161264. * 16384.,
    (double)114764./3137161264. * 16384.,
    (double)212671./3137161264. * 16384.,
    (double)57903./3137161264. * 16384.,
    (double)171122./3137161264. * 16384.,
    (double)158040./3137161264. * 16384.,
    (double)120982./3137161264. * 16384.,
    (double)200907./3137161264. * 16384.,
    (double)145011./3137161264. * 16384.,
    (double)166229./3137161264. * 16384.,
    (double)20982./3137161264. * 16384.,
    (double)29723./3137161264. * 16384.,
    (double)14765./3137161264. * 16384.,
    (double)14345./3137161264. * 16384.,
    (double)17147./3137161264. * 16384.,
    (double)27584./3137161264. * 16384.,
    (double)21323./3137161264. * 16384.,
    (double)12205./3137161264. * 16384.,
    (double)45471./3137161264. * 16384.,
    (double)33603./3137161264. * 16384.,
    (double)31040./3137161264. * 16384.,
    (double)22735./3137161264. * 16384.,
    (double)18678./3137161264. * 16384.,
    (double)57900./3137161264. * 16384.,
    (double)22840./3137161264. * 16384.,
    (double)20382./3137161264. * 16384.,
    (double)137281./3137161264. * 16384.,
    (double)212867./3137161264. * 16384.,
    (double)157469./3137161264. * 16384.,
    (double)122672./3137161264. * 16384.,
    (double)19357./3137161264. * 16384.,
    (double)36852./3137161264. * 16384.,
    (double)30215./3137161264. * 16384.,
    (double)19448./3137161264. * 16384.,
    (double)175661./3137161264. * 16384.,
    (double)31593./3137161264. * 16384.,
    (double)133691./3137161264. * 16384.,
    (double)132464./3137161264. * 16384.,
    (double)83090./3137161264. * 16384.,
    (double)157019./3137161264. * 16384.,
    (double)143125./3137161264. * 16384.,
    (double)122242./3137161264. * 16384.,
    (double)112816./3137161264. * 16384.,
    (double)94913./3137161264. * 16384.,
    (double)96532./3137161264. * 16384.,
    (double)105019./3137161264. * 16384.,
    (double)154776./3137161264. * 16384.,
    (double)196280./3137161264. * 16384.,
    (double)168421./3137161264. * 16384.,
    (double)173867./3137161264. * 16384.,
    (double)161952./3137161264. * 16384.,
    (double)28266./3137161264. * 16384.,
    (double)179897./3137161264. * 16384.,
    (double)176408./3137161264. * 16384.,
    (double)101740./3137161264. * 16384.,
    (double)139357./3137161264. * 16384.,
    (double)151794./3137161264. * 16384.,
    (double)174807./3137161264. * 16384.,
    (double)193605./3137161264. * 16384.,
    (double)108806./3137161264. * 16384.,
    (double)83791./3137161264. * 16384.,
    (double)132544./3137161264. * 16384.,
    (double)116926./3137161264. * 16384.,
    (double)86613./3137161264. * 16384.,
    (double)70002./3137161264. * 16384.,
    (double)72836./3137161264. * 16384.,
    (double)125568./3137161264. * 16384.,
    (double)14600./3137161264. * 16384.,
    (double)76223./3137161264. * 16384.,
    (double)101932./3137161264. * 16384.,
    (double)120278./3137161264. * 16384.,
    (double)115430./3137161264. * 16384.,
    (double)87736./3137161264. * 16384.,
    (double)160427./3137161264. * 16384.,
    (double)256822./3137161264. * 16384.,
    (double)210987./3137161264. * 16384.,
    (double)132964./3137161264. * 16384.,
    (double)165628./3137161264. * 16384.,
    (double)188637./3137161264. * 16384.,
    (double)204216./3137161264. * 16384.,
    (double)140419./3137161264. * 16384.,
    (double)124514./3137161264. * 16384.,
    (double)281548./3137161264. * 16384.,
    (double)44791./3137161264. * 16384.,
    (double)170316./3137161264. * 16384.,
    (double)201628./3137161264. * 16384.,
    (double)169907./3137161264. * 16384.,
    (double)255763./3137161264. * 16384.,
    (double)151810./3137161264. * 16384.,
    (double)194744./3137161264. * 16384.,
    (double)148966./3137161264. * 16384.,
    (double)171735./3137161264. * 16384.,
    (double)142921./3137161264. * 16384.,
    (double)148223./3137161264. * 16384.,
    (double)17036./3137161264. * 16384.,
    (double)22704./3137161264. * 16384.,
    (double)17143./3137161264. * 16384.,
    (double)17009./3137161264. * 16384.,
    (double)175210./3137161264. * 16384.,
    (double)19043./3137161264. * 16384.,
    (double)138443./3137161264. * 16384.,
    (double)152404./3137161264. * 16384.,
    (double)111338./3137161264. * 16384.,
    (double)182279./3137161264. * 16384.,
    (double)140415./3137161264. * 16384.,
    (double)170058./3137161264. * 16384.,
    (double)191984./3137161264. * 16384.,
    (double)126386./3137161264. * 16384.,
    (double)121895./3137161264. * 16384.,
    (double)155729./3137161264. * 16384.,
    (double)181163./3137161264. * 16384.,
    (double)144979./3137161264. * 16384.,
    (double)114116./3137161264. * 16384.,
    (double)138549./3137161264. * 16384.,
    (double)186143./3137161264. * 16384.,
    (double)20802./3137161264. * 16384.,
    (double)174712./3137161264. * 16384.,
    (double)216122./3137161264. * 16384.,
    (double)201051./3137161264. * 16384.,
    (double)220030./3137161264. * 16384.,
    (double)199459./3137161264. * 16384.,
    (double)289318./3137161264. * 16384.,
    (double)433826./3137161264. * 16384.,
    (double)207457./3137161264. * 16384.,
    (double)170703./3137161264. * 16384.,
    (double)313007./3137161264. * 16384.,
    (double)162028./3137161264. * 16384.,
    (double)108423./3137161264. * 16384.,
    (double)102629./3137161264. * 16384.,
    (double)118793./3137161264. * 16384.,
    (double)169134./3137161264. * 16384.,
    (double)16000./3137161264. * 16384.,
    (double)83723./3137161264. * 16384.,
    (double)129714./3137161264. * 16384.,
    (double)233388./3137161264. * 16384.,
    (double)165507./3137161264. * 16384.,
    (double)129318./3137161264. * 16384.,
    (double)262703./3137161264. * 16384.,
    (double)220647./3137161264. * 16384.,
    (double)134060./3137161264. * 16384.,
    (double)100302./3137161264. * 16384.,
    (double)142306./3137161264. * 16384.,
    (double)126478./3137161264. * 16384.,
    (double)84814./3137161264. * 16384.,
    (double)86843./3137161264. * 16384.,
    (double)95590./3137161264. * 16384.,
    (double)162416./3137161264. * 16384.,
    (double)15386./3137161264. * 16384.,
    (double)85036./3137161264. * 16384.,
    (double)118912./3137161264. * 16384.,
    (double)137247./3137161264. * 16384.,
    (double)120668./3137161264. * 16384.,
    (double)83904./3137161264. * 16384.,
    (double)139760./3137161264. * 16384.,
    (double)181933./3137161264. * 16384.,
    (double)139818./3137161264. * 16384.,
    (double)144736./3137161264. * 16384.,
    (double)206510./3137161264. * 16384.,
    (double)17037./3137161264. * 16384.,
    (double)14838./3137161264. * 16384.,
    (double)13975./3137161264. * 16384.,
    (double)25334./3137161264. * 16384.,
    (double)113619./3137161264. * 16384.,
    (double)10798./3137161264. * 16384.,
    (double)72857./3137161264. * 16384.,
    (double)107223./3137161264. * 16384.,
    (double)102489./3137161264. * 16384.,
    (double)122498./3137161264. * 16384.,
    (double)88657./3137161264. * 16384.,
    (double)150750./3137161264. * 16384.,
    (double)256276./3137161264. * 16384.,
    (double)127423./3137161264. * 16384.,
    (double)155622./3137161264. * 16384.,
    (double)336914./3137161264. * 16384.,
    (double)174517./3137161264. * 16384.,
    (double)130931./3137161264. * 16384.,
    (double)131309./3137161264. * 16384.,
    (double)205459./3137161264. * 16384.,
    (double)167422./3137161264. * 16384.,
    (double)13151./3137161264. * 16384.,
    (double)106854./3137161264. * 16384.,
    (double)163776./3137161264. * 16384.,
    (double)223571./3137161264. * 16384.,
    (double)158518./3137161264. * 16384.,
    (double)178877./3137161264. * 16384.,
    (double)413467./3137161264. * 16384.,
    (double)316981./3137161264. * 16384.,
    (double)198221./3137161264. * 16384.,
    (double)136631./3137161264. * 16384.,
    (double)211811./3137161264. * 16384.,
    (double)204573./3137161264. * 16384.,
    (double)156761./3137161264. * 16384.,
    (double)145030./3137161264. * 16384.,
    (double)132466./3137161264. * 16384.,
    (double)167375./3137161264. * 16384.,
    (double)18529./3137161264. * 16384.,
    (double)106131./3137161264. * 16384.,
    (double)143677./3137161264. * 16384.,
    (double)148308./3137161264. * 16384.,
    (double)157352./3137161264. * 16384.,
    (double)115381./3137161264. * 16384.,
    (double)189079./3137161264. * 16384.,
    (double)242411./3137161264. * 16384.,
    (double)190636./3137161264. * 16384.,
    (double)108146./3137161264. * 16384.,
    (double)148456./3137161264. * 16384.,
    (double)167480./3137161264. * 16384.,
    (double)143818./3137161264. * 16384.,
    (double)113055./3137161264. * 16384.,
    (double)112165./3137161264. * 16384.,
    (double)189385./3137161264. * 16384.,
    (double)27048./3137161264. * 16384.,
    (double)129445./3137161264. * 16384.,
    (double)166275./3137161264. * 16384.,
    (double)132351./3137161264. * 16384.,
    (double)179130./3137161264. * 16384.,
    (double)97573./3137161264. * 16384.,
    (double)141608./3137161264. * 16384.,
    (double)165285./3137161264. * 16384.,
    (double)163449./3137161264. * 16384.,
    (double)133110./3137161264. * 16384.,
    (double)172619./3137161264. * 16384.,
    (double)14127./3137161264. * 16384.,
    (double)18030./3137161264. * 16384.,
    (double)18858./3137161264. * 16384.,
    (double)21154./3137161264. * 16384.,
    (double)155324./3137161264. * 16384.,
    (double)17232./3137161264. * 16384.,
    (double)121895./3137161264. * 16384.,
    (double)158388./3137161264. * 16384.,
    (double)115995./3137161264. * 16384.,
    (double)177572./3137161264. * 16384.,
    (double)117740./3137161264. * 16384.,
    (double)165165./3137161264. * 16384.,
    (double)204890./3137161264. * 16384.,
    (double)118937./3137161264. * 16384.,
    (double)116018./3137161264. * 16384.,
    (double)201203./3137161264. * 16384.,
    (double)193909./3137161264. * 16384.,
    (double)171123./3137161264. * 16384.,
    (double)151929./3137161264. * 16384.,
    (double)204518./3137161264. * 16384.,
    (double)161196./3137161264. * 16384.,
    (double)15505./3137161264. * 16384.,
    (double)119852./3137161264. * 16384.,
    (double)176008./3137161264. * 16384.,
    (double)168063./3137161264. * 16384.,
    (double)176375./3137161264. * 16384.,
    (double)156599./3137161264. * 16384.,
    (double)275640./3137161264. * 16384.,
    (double)236811./3137161264. * 16384.,
    (double)134309./3137161264. * 16384.,
    (double)114067./3137161264. * 16384.,
    (double)155654./3137161264. * 16384.,
    (double)186930./3137161264. * 16384.,
    (double)135497./3137161264. * 16384.,
    (double)134634./3137161264. * 16384.,
    (double)151910./3137161264. * 16384.,
    (double)205291./3137161264. * 16384.,
    (double)26947./3137161264. * 16384.,
    (double)145386./3137161264. * 16384.,
    (double)172882./3137161264. * 16384.,
    (double)153182./3137161264. * 16384.,
    (double)151419./3137161264. * 16384.,
    (double)167566./3137161264. * 16384.,
    (double)227514./3137161264. * 16384.,
    (double)18262./3137161264. * 16384.,
    (double)17796./3137161264. * 16384.,
    (double)11618./3137161264. * 16384.,
    (double)17175./3137161264. * 16384.,
    (double)14105./3137161264. * 16384.,
    (double)15858./3137161264. * 16384.,
    (double)14246./3137161264. * 16384.,
    (double)13746./3137161264. * 16384.,
    (double)19274./3137161264. * 16384.,
    (double)4778./3137161264. * 16384.,
    (double)19044./3137161264. * 16384.,
    (double)20824./3137161264. * 16384.,
    (double)18333./3137161264. * 16384.,
    (double)26882./3137161264. * 16384.,
    (double)18634./3137161264. * 16384.,
    (double)23299./3137161264. * 16384.,
    (double)145750./3137161264. * 16384.,
    (double)154606./3137161264. * 16384.,
    (double)119962./3137161264. * 16384.,
    (double)167180./3137161264. * 16384.,
    (double)13889./3137161264. * 16384.,
    (double)15377./3137161264. * 16384.,
    (double)15616./3137161264. * 16384.,
    (double)20672./3137161264. * 16384.,
    (double)162491./3137161264. * 16384.,
    (double)20181./3137161264. * 16384.,
    (double)124931./3137161264. * 16384.,
    (double)155255./3137161264. * 16384.,
    (double)109998./3137161264. * 16384.,
    (double)165550./3137161264. * 16384.,
    (double)155704./3137161264. * 16384.,
    (double)182541./3137161264. * 16384.,
    (double)147066./3137161264. * 16384.,
    (double)105022./3137161264. * 16384.,
    (double)106980./3137161264. * 16384.,
    (double)167061./3137161264. * 16384.,
    (double)177584./3137161264. * 16384.,
    (double)156856./3137161264. * 16384.,
    (double)160489./3137161264. * 16384.,
    (double)227453./3137161264. * 16384.,
    (double)226701./3137161264. * 16384.,
    (double)22061./3137161264. * 16384.,
    (double)172661./3137161264. * 16384.,
    (double)257314./3137161264. * 16384.,
    (double)167495./3137161264. * 16384.,
    (double)171977./3137161264. * 16384.,
    (double)193844./3137161264. * 16384.,
    (double)285336./3137161264. * 16384.,
    (double)340266./3137161264. * 16384.,
    (double)151446./3137161264. * 16384.,
    (double)130469./3137161264. * 16384.,
    (double)228128./3137161264. * 16384.,
    (double)154464./3137161264. * 16384.,
    (double)107963./3137161264. * 16384.,
    (double)103583./3137161264. * 16384.,
    (double)121226./3137161264. * 16384.,
    (double)170316./3137161264. * 16384.,
    (double)15846./3137161264. * 16384.,
    (double)96911./3137161264. * 16384.,
    (double)152308./3137161264. * 16384.,
    (double)219034./3137161264. * 16384.,
    (double)157221./3137161264. * 16384.,
    (double)150634./3137161264. * 16384.,
    (double)323678./3137161264. * 16384.,
    (double)193276./3137161264. * 16384.,
    (double)131869./3137161264. * 16384.,
    (double)97712./3137161264. * 16384.,
    (double)151345./3137161264. * 16384.,
    (double)126989./3137161264. * 16384.,
    (double)94953./3137161264. * 16384.,
    (double)97384./3137161264. * 16384.,
    (double)112308./3137161264. * 16384.,
    (double)164648./3137161264. * 16384.,
    (double)13637./3137161264. * 16384.,
    (double)117954./3137161264. * 16384.,
    (double)175573./3137161264. * 16384.,
    (double)169108./3137161264. * 16384.,
    (double)164994./3137161264. * 16384.,
    (double)126913./3137161264. * 16384.,
    (double)217311./3137161264. * 16384.,
    (double)213311./3137161264. * 16384.,
    (double)188427./3137161264. * 16384.,
    (double)158724./3137161264. * 16384.,
    (double)264410./3137161264. * 16384.,
    (double)19484./3137161264. * 16384.,
    (double)15750./3137161264. * 16384.,
    (double)13777./3137161264. * 16384.,
    (double)24126./3137161264. * 16384.,
    (double)201218./3137161264. * 16384.,
    (double)16818./3137161264. * 16384.,
    (double)154171./3137161264. * 16384.,
    (double)215243./3137161264. * 16384.,
    (double)191531./3137161264. * 16384.,
    (double)225752./3137161264. * 16384.,
    (double)207221./3137161264. * 16384.,
    (double)288351./3137161264. * 16384.,
    (double)375003./3137161264. * 16384.,
    (double)186457./3137161264. * 16384.,
    (double)199212./3137161264. * 16384.,
    (double)399198./3137161264. * 16384.,
    (double)257944./3137161264. * 16384.,
    (double)201366./3137161264. * 16384.,
    (double)187201./3137161264. * 16384.,
    (double)284171./3137161264. * 16384.,
    (double)339520./3137161264. * 16384.,
    (double)22056./3137161264. * 16384.,
    (double)267788./3137161264. * 16384.,
    (double)416475./3137161264. * 16384.,
    (double)525103./3137161264. * 16384.,
    (double)349878./3137161264. * 16384.,
    (double)409156./3137161264. * 16384.,
    (double)629233./3137161264. * 16384.,
    (double)39214./3137161264. * 16384.,
    (double)26751./3137161264. * 16384.,
    (double)23033./3137161264. * 16384.,
    (double)31227./3137161264. * 16384.,
    (double)28387./3137161264. * 16384.,
    (double)21631./3137161264. * 16384.,
    (double)19093./3137161264. * 16384.,
    (double)19398./3137161264. * 16384.,
    (double)23855./3137161264. * 16384.,
    (double)3638./3137161264. * 16384.,
    (double)20765./3137161264. * 16384.,
    (double)23833./3137161264. * 16384.,
    (double)24528./3137161264. * 16384.,
    (double)23762./3137161264. * 16384.,
    (double)18035./3137161264. * 16384.,
    (double)22365./3137161264. * 16384.,
    (double)30570./3137161264. * 16384.,
    (double)25178./3137161264. * 16384.,
    (double)18686./3137161264. * 16384.,
    (double)18819./3137161264. * 16384.,
    (double)25343./3137161264. * 16384.,
    (double)21369./3137161264. * 16384.,
    (double)21717./3137161264. * 16384.,
    (double)16221./3137161264. * 16384.,
    (double)20902./3137161264. * 16384.,
    (double)4739./3137161264. * 16384.,
    (double)20125./3137161264. * 16384.,
    (double)19700./3137161264. * 16384.,
    (double)15562./3137161264. * 16384.,
    (double)20507./3137161264. * 16384.,
    (double)19184./3137161264. * 16384.,
    (double)19503./3137161264. * 16384.,
    (double)17621./3137161264. * 16384.,
    (double)16008./3137161264. * 16384.,
    (double)14687./3137161264. * 16384.,
    (double)15862./3137161264. * 16384.,
    (double)2674./3137161264. * 16384.,
    (double)2974./3137161264. * 16384.,
    (double)3117./3137161264. * 16384.,
    (double)3045./3137161264. * 16384.,
    (double)12273./3137161264. * 16384.,
    (double)2233./3137161264. * 16384.,
    (double)12438./3137161264. * 16384.,
    (double)11582./3137161264. * 16384.,
    (double)10256./3137161264. * 16384.,
    (double)14324./3137161264. * 16384.,
    (double)15724./3137161264. * 16384.,
    (double)14391./3137161264. * 16384.,
    (double)21641./3137161264. * 16384.,
    (double)13679./3137161264. * 16384.,
    (double)12766./3137161264. * 16384.,
    (double)20659./3137161264. * 16384.,
    (double)22728./3137161264. * 16384.,
    (double)20554./3137161264. * 16384.,
    (double)16279./3137161264. * 16384.,
    (double)19848./3137161264. * 16384.,
    (double)15871./3137161264. * 16384.,
    (double)2195./3137161264. * 16384.,
    (double)14510./3137161264. * 16384.,
    (double)16325./3137161264. * 16384.,
    (double)16621./3137161264. * 16384.,
    (double)14272./3137161264. * 16384.,
    (double)17626./3137161264. * 16384.,
    (double)25258./3137161264. * 16384.,
    (double)35134./3137161264. * 16384.,
    (double)29150./3137161264. * 16384.,
    (double)20577./3137161264. * 16384.,
    (double)24127./3137161264. * 16384.,
    (double)32047./3137161264. * 16384.,
    (double)29661./3137161264. * 16384.,
    (double)23703./3137161264. * 16384.,
    (double)17701./3137161264. * 16384.,
    (double)24252./3137161264. * 16384.,
    (double)6629./3137161264. * 16384.,
    (double)39380./3137161264. * 16384.,
    (double)34445./3137161264. * 16384.,
    (double)15711./3137161264. * 16384.,
    (double)25224./3137161264. * 16384.,
    (double)29718./3137161264. * 16384.,
    (double)24676./3137161264. * 16384.,
    (double)33502./3137161264. * 16384.,
    (double)38221./3137161264. * 16384.,
    (double)20858./3137161264. * 16384.,
    (double)18319./3137161264. * 16384.,
    (double)29369./3137161264. * 16384.,
    (double)30084./3137161264. * 16384.,
    (double)27598./3137161264. * 16384.,
    (double)20060./3137161264. * 16384.,
    (double)34718./3137161264. * 16384.,
    (double)14108./3137161264. * 16384.,
    (double)33949./3137161264. * 16384.,
    (double)35423./3137161264. * 16384.,
    (double)14856./3137161264. * 16384.,
    (double)31224./3137161264. * 16384.,
    (double)23721./3137161264. * 16384.,
    (double)21299./3137161264. * 16384.,
    (double)16106./3137161264. * 16384.,
    (double)24565./3137161264. * 16384.,
    (double)15297./3137161264. * 16384.,
    (double)14128./3137161264. * 16384.,
    (double)4549./3137161264. * 16384.,
    (double)7792./3137161264. * 16384.,
    (double)7713./3137161264. * 16384.,
    (double)3637./3137161264. * 16384.,
    (double)23472./3137161264. * 16384.,
    (double)8181./3137161264. * 16384.,
    (double)21750./3137161264. * 16384.,
    (double)20140./3137161264. * 16384.,
    (double)10713./3137161264. * 16384.,
    (double)25277./3137161264. * 16384.,
    (double)17887./3137161264. * 16384.,
    (double)14499./3137161264. * 16384.,
    (double)13657./3137161264. * 16384.,
    (double)14849./3137161264. * 16384.,
    (double)9067./3137161264. * 16384.,
    (double)11623./3137161264. * 16384.,
    (double)20819./3137161264. * 16384.,
    (double)21142./3137161264. * 16384.,
    (double)16394./3137161264. * 16384.,
    (double)17505./3137161264. * 16384.,
    (double)16957./3137161264. * 16384.,
    (double)3323./3137161264. * 16384.,
    (double)18727./3137161264. * 16384.,
    (double)19421./3137161264. * 16384.,
    (double)13105./3137161264. * 16384.,
    (double)15001./3137161264. * 16384.,
    (double)17534./3137161264. * 16384.,
    (double)22979./3137161264. * 16384.,
    (double)22325./3137161264. * 16384.,
    (double)13874./3137161264. * 16384.,
    (double)11222./3137161264. * 16384.,
    (double)12356./3137161264. * 16384.,
    (double)34157./3137161264. * 16384.,
    (double)18275./3137161264. * 16384.,
    (double)17956./3137161264. * 16384.,
    (double)15067./3137161264. * 16384.,
    (double)18576./3137161264. * 16384.,
    (double)3911./3137161264. * 16384.,
    (double)13855./3137161264. * 16384.,
    (double)14165./3137161264. * 16384.,
    (double)11602./3137161264. * 16384.,
    (double)15194./3137161264. * 16384.,
    (double)13465./3137161264. * 16384.,
    (double)17174./3137161264. * 16384.,
    (double)2706./3137161264. * 16384.,
    (double)4101./3137161264. * 16384.,
    (double)3149./3137161264. * 16384.,
    (double)2139./3137161264. * 16384.,
    (double)4026./3137161264. * 16384.,
    (double)5593./3137161264. * 16384.,
    (double)5584./3137161264. * 16384.,
    (double)2806./3137161264. * 16384.,
    (double)3359./3137161264. * 16384.,
    (double)2672./3137161264. * 16384.,
    (double)5301./3137161264. * 16384.,
    (double)3793./3137161264. * 16384.,
    (double)2031./3137161264. * 16384.,
    (double)5379./3137161264. * 16384.,
    (double)3720./3137161264. * 16384.,
    (double)3082./3137161264. * 16384.,
    (double)11539./3137161264. * 16384.,
    (double)13698./3137161264. * 16384.,
    (double)12833./3137161264. * 16384.,
    (double)10287./3137161264. * 16384.,
    (double)2516./3137161264. * 16384.,
    (double)3288./3137161264. * 16384.,
    (double)4192./3137161264. * 16384.,
    (double)2384./3137161264. * 16384.,
    (double)14244./3137161264. * 16384.,
    (double)4556./3137161264. * 16384.,
    (double)17705./3137161264. * 16384.,
    (double)14297./3137161264. * 16384.,
    (double)7910./3137161264. * 16384.,
    (double)15646./3137161264. * 16384.,
    (double)17334./3137161264. * 16384.,
    (double)13187./3137161264. * 16384.,
    (double)9611./3137161264. * 16384.,
    (double)6957./3137161264. * 16384.,
    (double)7339./3137161264. * 16384.,
    (double)9144./3137161264. * 16384.,
    (double)14800./3137161264. * 16384.,
    (double)14868./3137161264. * 16384.,
    (double)14884./3137161264. * 16384.,
    (double)15150./3137161264. * 16384.,
    (double)14213./3137161264. * 16384.,
    (double)3139./3137161264. * 16384.,
    (double)16336./3137161264. * 16384.,
    (double)16498./3137161264. * 16384.,
    (double)10282./3137161264. * 16384.,
    (double)13123./3137161264. * 16384.,
    (double)17176./3137161264. * 16384.,
    (double)19297./3137161264. * 16384.,
    (double)24698./3137161264. * 16384.,
    (double)11676./3137161264. * 16384.,
    (double)9840./3137161264. * 16384.,
    (double)16552./3137161264. * 16384.,
    (double)14164./3137161264. * 16384.,
    (double)9031./3137161264. * 16384.,
    (double)8952./3137161264. * 16384.,
    (double)10265./3137161264. * 16384.,
    (double)13150./3137161264. * 16384.,
    (double)1979./3137161264. * 16384.,
    (double)8680./3137161264. * 16384.,
    (double)10764./3137161264. * 16384.,
    (double)14370./3137161264. * 16384.,
    (double)12798./3137161264. * 16384.,
    (double)10749./3137161264. * 16384.,
    (double)20539./3137161264. * 16384.,
    (double)22426./3137161264. * 16384.,
    (double)19880./3137161264. * 16384.,
    (double)15326./3137161264. * 16384.,
    (double)17480./3137161264. * 16384.,
    (double)19667./3137161264. * 16384.,
    (double)20648./3137161264. * 16384.,
    (double)17327./3137161264. * 16384.,
    (double)15829./3137161264. * 16384.,
    (double)16357./3137161264. * 16384.,
    (double)3301./3137161264. * 16384.,
    (double)16354./3137161264. * 16384.,
    (double)19245./3137161264. * 16384.,
    (double)13158./3137161264. * 16384.,
    (double)19732./3137161264. * 16384.,
    (double)15144./3137161264. * 16384.,
    (double)20500./3137161264. * 16384.,
    (double)12297./3137161264. * 16384.,
    (double)12350./3137161264. * 16384.,
    (double)12131./3137161264. * 16384.,
    (double)13858./3137161264. * 16384.,
    (double)1761./3137161264. * 16384.,
    (double)1948./3137161264. * 16384.,
    (double)2265./3137161264. * 16384.,
    (double)1986./3137161264. * 16384.,
    (double)11989./3137161264. * 16384.,
    (double)2289./3137161264. * 16384.,
    (double)11430./3137161264. * 16384.,
    (double)14428./3137161264. * 16384.,
    (double)8818./3137161264. * 16384.,
    (double)14390./3137161264. * 16384.,
    (double)17285./3137161264. * 16384.,
    (double)15634./3137161264. * 16384.,
    (double)15969./3137161264. * 16384.,
    (double)10028./3137161264. * 16384.,
    (double)10094./3137161264. * 16384.,
    (double)16862./3137161264. * 16384.,
    (double)12124./3137161264. * 16384.,
    (double)10484./3137161264. * 16384.,
    (double)10364./3137161264. * 16384.,
    (double)13431./3137161264. * 16384.,
    (double)16456./3137161264. * 16384.,
    (double)2138./3137161264. * 16384.,
    (double)16688./3137161264. * 16384.,
    (double)23400./3137161264. * 16384.,
    (double)19000./3137161264. * 16384.,
    (double)18982./3137161264. * 16384.,
    (double)22691./3137161264. * 16384.,
    (double)36180./3137161264. * 16384.,
    (double)32366./3137161264. * 16384.,
    (double)26893./3137161264. * 16384.,
    (double)19085./3137161264. * 16384.,
    (double)23947./3137161264. * 16384.,
    (double)27931./3137161264. * 16384.,
    (double)30118./3137161264. * 16384.,
    (double)23265./3137161264. * 16384.,
    (double)20369./3137161264. * 16384.,
    (double)17760./3137161264. * 16384.,
    (double)3750./3137161264. * 16384.,
    (double)12845./3137161264. * 16384.,
    (double)15754./3137161264. * 16384.,
    (double)16340./3137161264. * 16384.,
    (double)19274./3137161264. * 16384.,
    (double)14507./3137161264. * 16384.,
    (double)18379./3137161264. * 16384.,
    (double)30729./3137161264. * 16384.,
    (double)32466./3137161264. * 16384.,
    (double)21345./3137161264. * 16384.,
    (double)18270./3137161264. * 16384.,
    (double)33001./3137161264. * 16384.,
    (double)36397./3137161264. * 16384.,
    (double)37201./3137161264. * 16384.,
    (double)23799./3137161264. * 16384.,
    (double)24333./3137161264. * 16384.,
    (double)9859./3137161264. * 16384.,
    (double)30691./3137161264. * 16384.,
    (double)27229./3137161264. * 16384.,
    (double)12417./3137161264. * 16384.,
    (double)22018./3137161264. * 16384.,
    (double)26834./3137161264. * 16384.,
    (double)22093./3137161264. * 16384.,
    (double)13552./3137161264. * 16384.,
    (double)19721./3137161264. * 16384.,
    (double)17320./3137161264. * 16384.,
    (double)13495./3137161264. * 16384.,
    (double)3047./3137161264. * 16384.,
    (double)7042./3137161264. * 16384.,
    (double)6177./3137161264. * 16384.,
    (double)3557./3137161264. * 16384.,
    (double)11639./3137161264. * 16384.,
    (double)3750./3137161264. * 16384.,
    (double)14742./3137161264. * 16384.,
    (double)11799./3137161264. * 16384.,
    (double)8926./3137161264. * 16384.,
    (double)14475./3137161264. * 16384.,
    (double)13951./3137161264. * 16384.,
    (double)13445./3137161264. * 16384.,
    (double)12654./3137161264. * 16384.,
    (double)8592./3137161264. * 16384.,
    (double)8364./3137161264. * 16384.,
    (double)12295./3137161264. * 16384.,
    (double)17424./3137161264. * 16384.,
    (double)20708./3137161264. * 16384.,
    (double)15224./3137161264. * 16384.,
    (double)15087./3137161264. * 16384.,
    (double)14866./3137161264. * 16384.,
    (double)2450./3137161264. * 16384.,
    (double)11735./3137161264. * 16384.,
    (double)12912./3137161264. * 16384.,
    (double)11552./3137161264. * 16384.,
    (double)10761./3137161264. * 16384.,
    (double)13607./3137161264. * 16384.,
    (double)18822./3137161264. * 16384.,
    (double)33400./3137161264. * 16384.,
    (double)41490./3137161264. * 16384.,
    (double)19199./3137161264. * 16384.,
    (double)19397./3137161264. * 16384.,
    (double)38885./3137161264. * 16384.,
    (double)66622./3137161264. * 16384.,
    (double)33293./3137161264. * 16384.,
    (double)22136./3137161264. * 16384.,
    (double)22719./3137161264. * 16384.,
    (double)7876./3137161264. * 16384.,
    (double)20466./3137161264. * 16384.,
    (double)18870./3137161264. * 16384.,
    (double)11817./3137161264. * 16384.,
    (double)22501./3137161264. * 16384.,
    (double)14134./3137161264. * 16384.,
    (double)17886./3137161264. * 16384.,
    (double)35900./3137161264. * 16384.,
    (double)56201./3137161264. * 16384.,
    (double)27845./3137161264. * 16384.,
    (double)20685./3137161264. * 16384.,
    (double)36057./3137161264. * 16384.,
    (double)33370./3137161264. * 16384.,
    (double)40962./3137161264. * 16384.,
    (double)30086./3137161264. * 16384.,
    (double)34178./3137161264. * 16384.,
    (double)23386./3137161264. * 16384.,
    (double)43274./3137161264. * 16384.,
    (double)40516./3137161264. * 16384.,
    (double)13288./3137161264. * 16384.,
    (double)35665./3137161264. * 16384.,
    (double)26172./3137161264. * 16384.,
    (double)29804./3137161264. * 16384.,
    (double)18031./3137161264. * 16384.,
    (double)44359./3137161264. * 16384.,
    (double)24285./3137161264. * 16384.,
    (double)20091./3137161264. * 16384.,
    (double)6822./3137161264. * 16384.,
    (double)24848./3137161264. * 16384.,
    (double)16469./3137161264. * 16384.,
    (double)8413./3137161264. * 16384.,
    (double)24774./3137161264. * 16384.,
    (double)15049./3137161264. * 16384.,
    (double)28110./3137161264. * 16384.,
    (double)25916./3137161264. * 16384.,
    (double)10246./3137161264. * 16384.,
    (double)38050./3137161264. * 16384.,
    (double)25245./3137161264. * 16384.,
    (double)19875./3137161264. * 16384.,
    (double)12694./3137161264. * 16384.,
    (double)13849./3137161264. * 16384.,
    (double)9994./3137161264. * 16384.,
    (double)11540./3137161264. * 16384.,
    (double)21324./3137161264. * 16384.,
    (double)38084./3137161264. * 16384.,
    (double)21519./3137161264. * 16384.,
    (double)20011./3137161264. * 16384.,
    (double)15762./3137161264. * 16384.,
    (double)4597./3137161264. * 16384.,
    (double)18952./3137161264. * 16384.,
    (double)19089./3137161264. * 16384.,
    (double)9914./3137161264. * 16384.,
    (double)15566./3137161264. * 16384.,
    (double)16388./3137161264. * 16384.,
    (double)20869./3137161264. * 16384.,
    (double)22138./3137161264. * 16384.,
    (double)18819./3137161264. * 16384.,
    (double)12374./3137161264. * 16384.,
    (double)13462./3137161264. * 16384.,
    (double)28602./3137161264. * 16384.,
    (double)36525./3137161264. * 16384.,
    (double)34781./3137161264. * 16384.,
    (double)18755./3137161264. * 16384.,
    (double)21868./3137161264. * 16384.,
    (double)6286./3137161264. * 16384.,
    (double)19312./3137161264. * 16384.,
    (double)19546./3137161264. * 16384.,
    (double)10968./3137161264. * 16384.,
    (double)18723./3137161264. * 16384.,
    (double)16903./3137161264. * 16384.,
    (double)18227./3137161264. * 16384.,
    (double)4194./3137161264. * 16384.,
    (double)9202./3137161264. * 16384.,
    (double)5308./3137161264. * 16384.,
    (double)3349./3137161264. * 16384.,
    (double)8233./3137161264. * 16384.,
    (double)21306./3137161264. * 16384.,
    (double)26356./3137161264. * 16384.,
    (double)6358./3137161264. * 16384.,
    (double)7063./3137161264. * 16384.,
    (double)11001./3137161264. * 16384.,
    (double)14732./3137161264. * 16384.,
    (double)9204./3137161264. * 16384.,
    (double)2055./3137161264. * 16384.,
    (double)9017./3137161264. * 16384.,
    (double)6866./3137161264. * 16384.,
    (double)4360./3137161264. * 16384.,
    (double)27537./3137161264. * 16384.,
    (double)37308./3137161264. * 16384.,
    (double)29014./3137161264. * 16384.,
    (double)21941./3137161264. * 16384.,
    (double)9618./3137161264. * 16384.,
    (double)17923./3137161264. * 16384.,
    (double)18716./3137161264. * 16384.,
    (double)7157./3137161264. * 16384.,
    (double)30273./3137161264. * 16384.,
    (double)13969./3137161264. * 16384.,
    (double)37594./3137161264. * 16384.,
    (double)28165./3137161264. * 16384.,
    (double)18116./3137161264. * 16384.,
    (double)36653./3137161264. * 16384.,
    (double)41918./3137161264. * 16384.,
    (double)25811./3137161264. * 16384.,
    (double)15822./3137161264. * 16384.,
    (double)9308./3137161264. * 16384.,
    (double)10916./3137161264. * 16384.,
    (double)10696./3137161264. * 16384.,
    (double)22836./3137161264. * 16384.,
    (double)33545./3137161264. * 16384.,
    (double)34772./3137161264. * 16384.,
    (double)23283./3137161264. * 16384.,
    (double)22932./3137161264. * 16384.,
    (double)6519./3137161264. * 16384.,
    (double)30665./3137161264. * 16384.,
    (double)24995./3137161264. * 16384.,
    (double)10585./3137161264. * 16384.,
    (double)16434./3137161264. * 16384.,
    (double)25492./3137161264. * 16384.,
    (double)23105./3137161264. * 16384.,
    (double)17835./3137161264. * 16384.,
    (double)12413./3137161264. * 16384.,
    (double)9800./3137161264. * 16384.,
    (double)14075./3137161264. * 16384.,
    (double)12742./3137161264. * 16384.,
    (double)12319./3137161264. * 16384.,
    (double)10465./3137161264. * 16384.,
    (double)10411./3137161264. * 16384.,
    (double)11190./3137161264. * 16384.,
    (double)1626./3137161264. * 16384.,
    (double)8761./3137161264. * 16384.,
    (double)9758./3137161264. * 16384.,
    (double)10443./3137161264. * 16384.,
    (double)10822./3137161264. * 16384.,
    (double)9411./3137161264. * 16384.,
    (double)15785./3137161264. * 16384.,
    (double)23275./3137161264. * 16384.,
    (double)26181./3137161264. * 16384.,
    (double)16835./3137161264. * 16384.,
    (double)16470./3137161264. * 16384.,
    (double)22989./3137161264. * 16384.,
    (double)33714./3137161264. * 16384.,
    (double)28586./3137161264. * 16384.,
    (double)21177./3137161264. * 16384.,
    (double)18372./3137161264. * 16384.,
    (double)6003./3137161264. * 16384.,
    (double)22170./3137161264. * 16384.,
    (double)22865./3137161264. * 16384.,
    (double)10443./3137161264. * 16384.,
    (double)23082./3137161264. * 16384.,
    (double)17568./3137161264. * 16384.,
    (double)19435./3137161264. * 16384.,
    (double)11482./3137161264. * 16384.,
    (double)16948./3137161264. * 16384.,
    (double)15010./3137161264. * 16384.,
    (double)13695./3137161264. * 16384.,
    (double)1737./3137161264. * 16384.,
    (double)4022./3137161264. * 16384.,
    (double)3589./3137161264. * 16384.,
    (double)2362./3137161264. * 16384.,
    (double)12710./3137161264. * 16384.,
    (double)3337./3137161264. * 16384.,
    (double)16852./3137161264. * 16384.,
    (double)15242./3137161264. * 16384.,
    (double)8569./3137161264. * 16384.,
    (double)15706./3137161264. * 16384.,
    (double)19727./3137161264. * 16384.,
    (double)16104./3137161264. * 16384.,
    (double)12213./3137161264. * 16384.,
    (double)8621./3137161264. * 16384.,
    (double)8907./3137161264. * 16384.,
    (double)11538./3137161264. * 16384.,
    (double)11750./3137161264. * 16384.,
    (double)13415./3137161264. * 16384.,
    (double)11587./3137161264. * 16384.,
    (double)13067./3137161264. * 16384.,
    (double)13459./3137161264. * 16384.,
    (double)2088./3137161264. * 16384.,
    (double)15636./3137161264. * 16384.,
    (double)19261./3137161264. * 16384.,
    (double)13609./3137161264. * 16384.,
    (double)17845./3137161264. * 16384.,
    (double)23169./3137161264. * 16384.,
    (double)28802./3137161264. * 16384.,
    (double)22539./3137161264. * 16384.,
    (double)19527./3137161264. * 16384.,
    (double)14168./3137161264. * 16384.,
    (double)18643./3137161264. * 16384.,
    (double)14749./3137161264. * 16384.,
    (double)15366./3137161264. * 16384.,
    (double)12510./3137161264. * 16384.,
    (double)12583./3137161264. * 16384.,
    (double)13817./3137161264. * 16384.,
    (double)2469./3137161264. * 16384.,
    (double)10288./3137161264. * 16384.,
    (double)10473./3137161264. * 16384.,
    (double)11199./3137161264. * 16384.,
    (double)13726./3137161264. * 16384.,
    (double)9415./3137161264. * 16384.,
    (double)12234./3137161264. * 16384.,
    (double)24847./3137161264. * 16384.,
    (double)31701./3137161264. * 16384.,
    (double)18088./3137161264. * 16384.,
    (double)16531./3137161264. * 16384.,
    (double)26585./3137161264. * 16384.,
    (double)31324./3137161264. * 16384.,
    (double)28448./3137161264. * 16384.,
    (double)20512./3137161264. * 16384.,
    (double)28152./3137161264. * 16384.,
    (double)9923./3137161264. * 16384.,
    (double)34276./3137161264. * 16384.,
    (double)27353./3137161264. * 16384.,
    (double)11835./3137161264. * 16384.,
    (double)28111./3137161264. * 16384.,
    (double)15617./3137161264. * 16384.,
    (double)16128./3137161264. * 16384.,
    (double)14751./3137161264. * 16384.,
    (double)25334./3137161264. * 16384.,
    (double)28078./3137161264. * 16384.,
    (double)18072./3137161264. * 16384.,
    (double)3140./3137161264. * 16384.,
    (double)6499./3137161264. * 16384.,
    (double)8563./3137161264. * 16384.,
    (double)5361./3137161264. * 16384.,
    (double)20034./3137161264. * 16384.,
    (double)5696./3137161264. * 16384.,
    (double)24300./3137161264. * 16384.,
    (double)19898./3137161264. * 16384.,
    (double)7629./3137161264. * 16384.,
    (double)18300./3137161264. * 16384.,
    (double)16211./3137161264. * 16384.,
    (double)14032./3137161264. * 16384.,
    (double)11587./3137161264. * 16384.,
    (double)9899./3137161264. * 16384.,
    (double)9458./3137161264. * 16384.,
    (double)14312./3137161264. * 16384.,
    (double)14890./3137161264. * 16384.,
    (double)17537./3137161264. * 16384.,
    (double)19082./3137161264. * 16384.,
    (double)19749./3137161264. * 16384.,
    (double)15422./3137161264. * 16384.,
    (double)3140./3137161264. * 16384.,
    (double)15435./3137161264. * 16384.,
    (double)17492./3137161264. * 16384.,
    (double)11652./3137161264. * 16384.,
    (double)13192./3137161264. * 16384.,
    (double)15466./3137161264. * 16384.,
    (double)24080./3137161264. * 16384.,
    (double)2454./3137161264. * 16384.,
    (double)4004./3137161264. * 16384.,
    (double)2625./3137161264. * 16384.,
    (double)2007./3137161264. * 16384.,
    (double)4623./3137161264. * 16384.,
    (double)8079./3137161264. * 16384.,
    (double)6512./3137161264. * 16384.,
    (double)3454./3137161264. * 16384.,
    (double)2860./3137161264. * 16384.,
    (double)2100./3137161264. * 16384.,
    (double)4417./3137161264. * 16384.,
    (double)2925./3137161264. * 16384.,
    (double)1399./3137161264. * 16384.,
    (double)3874./3137161264. * 16384.,
    (double)3227./3137161264. * 16384.,
    (double)2214./3137161264. * 16384.,
    (double)4473./3137161264. * 16384.,
    (double)11057./3137161264. * 16384.,
    (double)4967./3137161264. * 16384.,
    (double)3065./3137161264. * 16384.,
    (double)9392./3137161264. * 16384.,
    (double)18611./3137161264. * 16384.,
    (double)14646./3137161264. * 16384.,
    (double)6446./3137161264. * 16384.,
    (double)6869./3137161264. * 16384.,
    (double)11982./3137161264. * 16384.,
    (double)15735./3137161264. * 16384.,
    (double)9443./3137161264. * 16384.,
    (double)2322./3137161264. * 16384.,
    (double)9455./3137161264. * 16384.,
    (double)4984./3137161264. * 16384.,
    (double)3722./3137161264. * 16384.,
    (double)2508./3137161264. * 16384.,
    (double)9022./3137161264. * 16384.,
    (double)8013./3137161264. * 16384.,
    (double)3423./3137161264. * 16384.,
    (double)2491./3137161264. * 16384.,
    (double)10163./3137161264. * 16384.,
    (double)12484./3137161264. * 16384.,
    (double)3608./3137161264. * 16384.,
    (double)9595./3137161264. * 16384.,
    (double)8916./3137161264. * 16384.,
    (double)24604./3137161264. * 16384.,
    (double)12402./3137161264. * 16384.,
    (double)2078./3137161264. * 16384.,
    (double)9308./3137161264. * 16384.,
    (double)8280./3137161264. * 16384.,
    (double)3839./3137161264. * 16384.,
    (double)1720./3137161264. * 16384.,
    (double)2253./3137161264. * 16384.,
    (double)1939./3137161264. * 16384.,
    (double)1958./3137161264. * 16384.,
    (double)4580./3137161264. * 16384.,
    (double)8835./3137161264. * 16384.,
    (double)8358./3137161264. * 16384.,
    (double)6550./3137161264. * 16384.,
    (double)3620./3137161264. * 16384.,
    (double)2220./3137161264. * 16384.,
    (double)7119./3137161264. * 16384.,
    (double)5374./3137161264. * 16384.,
    (double)2012./3137161264. * 16384.,
    (double)3421./3137161264. * 16384.,
    (double)3818./3137161264. * 16384.,
    (double)3935./3137161264. * 16384.,
    (double)17542./3137161264. * 16384.,
    (double)19015./3137161264. * 16384.,
    (double)12680./3137161264. * 16384.,
    (double)10491./3137161264. * 16384.,
    (double)17128./3137161264. * 16384.,
    (double)29197./3137161264. * 16384.,
    (double)27900./3137161264. * 16384.,
    (double)14925./3137161264. * 16384.,
    (double)21341./3137161264. * 16384.,
    (double)7784./3137161264. * 16384.,
    (double)27915./3137161264. * 16384.,
    (double)22274./3137161264. * 16384.,
    (double)9886./3137161264. * 16384.,
    (double)21786./3137161264. * 16384.,
    (double)20043./3137161264. * 16384.,
    (double)17948./3137161264. * 16384.,
    (double)2978./3137161264. * 16384.,
    (double)8875./3137161264. * 16384.,
    (double)4325./3137161264. * 16384.,
    (double)2412./3137161264. * 16384.,
    (double)5455./3137161264. * 16384.,
    (double)14267./3137161264. * 16384.,
    (double)12745./3137161264. * 16384.,
    (double)4544./3137161264. * 16384.,
    (double)7282./3137161264. * 16384.,
    (double)10226./3137161264. * 16384.,
    (double)22103./3137161264. * 16384.,
    (double)8711./3137161264. * 16384.,
    (double)2204./3137161264. * 16384.,
    (double)8078./3137161264. * 16384.,
    (double)6540./3137161264. * 16384.,
    (double)3485./3137161264. * 16384.,
    (double)14915./3137161264. * 16384.,
    (double)45807./3137161264. * 16384.,
    (double)28304./3137161264. * 16384.,
    (double)15463./3137161264. * 16384.,
    (double)5609./3137161264. * 16384.,
    (double)28471./3137161264. * 16384.,
    (double)18973./3137161264. * 16384.,
    (double)5807./3137161264. * 16384.,
    (double)26637./3137161264. * 16384.,
    (double)16150./3137161264. * 16384.,
    (double)36675./3137161264. * 16384.,
    (double)25696./3137161264. * 16384.,
    (double)8241./3137161264. * 16384.,
    (double)28939./3137161264. * 16384.,
    (double)26665./3137161264. * 16384.,
    (double)16973./3137161264. * 16384.,
    (double)9837./3137161264. * 16384.,
    (double)10415./3137161264. * 16384.,
    (double)10629./3137161264. * 16384.,
    (double)13072./3137161264. * 16384.,
    (double)20744./3137161264. * 16384.,
    (double)43735./3137161264. * 16384.,
    (double)33611./3137161264. * 16384.,
    (double)36946./3137161264. * 16384.,
    (double)23591./3137161264. * 16384.,
    (double)9302./3137161264. * 16384.,
    (double)37405./3137161264. * 16384.,
    (double)28619./3137161264. * 16384.,
    (double)10049./3137161264. * 16384.,
    (double)18465./3137161264. * 16384.,
    (double)23561./3137161264. * 16384.,
    (double)21645./3137161264. * 16384.,
    (double)14647./3137161264. * 16384.,
    (double)12227./3137161264. * 16384.,
    (double)8493./3137161264. * 16384.,
    (double)12640./3137161264. * 16384.,
    (double)10552./3137161264. * 16384.,
    (double)10030./3137161264. * 16384.,
    (double)7940./3137161264. * 16384.,
    (double)7713./3137161264. * 16384.,
    (double)12132./3137161264. * 16384.,
    (double)2234./3137161264. * 16384.,
    (double)9309./3137161264. * 16384.,
    (double)11725./3137161264. * 16384.,
    (double)9735./3137161264. * 16384.,
    (double)12011./3137161264. * 16384.,
    (double)8762./3137161264. * 16384.,
    (double)14903./3137161264. * 16384.,
    (double)21830./3137161264. * 16384.,
    (double)27234./3137161264. * 16384.,
    (double)16548./3137161264. * 16384.,
    (double)16602./3137161264. * 16384.,
    (double)25363./3137161264. * 16384.,
    (double)35198./3137161264. * 16384.,
    (double)26694./3137161264. * 16384.,
    (double)19008./3137161264. * 16384.,
    (double)28762./3137161264. * 16384.,
    (double)9337./3137161264. * 16384.,
    (double)31631./3137161264. * 16384.,
    (double)31598./3137161264. * 16384.,
    (double)14185./3137161264. * 16384.,
    (double)30371./3137161264. * 16384.,
    (double)22143./3137161264. * 16384.,
    (double)20245./3137161264. * 16384.,
    (double)13333./3137161264. * 16384.,
    (double)23218./3137161264. * 16384.,
    (double)17957./3137161264. * 16384.,
    (double)15180./3137161264. * 16384.,
    (double)3193./3137161264. * 16384.,
    (double)6693./3137161264. * 16384.,
    (double)6281./3137161264. * 16384.,
    (double)2943./3137161264. * 16384.,
    (double)21677./3137161264. * 16384.,
    (double)7148./3137161264. * 16384.,
    (double)25633./3137161264. * 16384.,
    (double)23770./3137161264. * 16384.,
    (double)10199./3137161264. * 16384.,
    (double)27347./3137161264. * 16384.,
    (double)20727./3137161264. * 16384.,
    (double)20765./3137161264. * 16384.,
    (double)14332./3137161264. * 16384.,
    (double)10659./3137161264. * 16384.,
    (double)9778./3137161264. * 16384.,
    (double)13248./3137161264. * 16384.,
    (double)36271./3137161264. * 16384.,
    (double)17678./3137161264. * 16384.,
    (double)14235./3137161264. * 16384.,
    (double)16624./3137161264. * 16384.,
    (double)19394./3137161264. * 16384.,
    (double)3648./3137161264. * 16384.,
    (double)24802./3137161264. * 16384.,
    (double)24351./3137161264. * 16384.,
    (double)16360./3137161264. * 16384.,
    (double)23347./3137161264. * 16384.,
    (double)22503./3137161264. * 16384.,
    (double)28155./3137161264. * 16384.,
    (double)30767./3137161264. * 16384.,
    (double)18815./3137161264. * 16384.,
    (double)14723./3137161264. * 16384.,
    (double)24085./3137161264. * 16384.,
    (double)21062./3137161264. * 16384.,
    (double)13482./3137161264. * 16384.,
    (double)13805./3137161264. * 16384.,
    (double)21490./3137161264. * 16384.,
    (double)19392./3137161264. * 16384.,
    (double)2093./3137161264. * 16384.,
    (double)9343./3137161264. * 16384.,
    (double)16427./3137161264. * 16384.,
    (double)19382./3137161264. * 16384.,
    (double)15625./3137161264. * 16384.,
    (double)13330./3137161264. * 16384.,
    (double)23413./3137161264. * 16384.,
    (double)21335./3137161264. * 16384.,
    (double)15957./3137161264. * 16384.,
    (double)11179./3137161264. * 16384.,
    (double)14081./3137161264. * 16384.,
    (double)15622./3137161264. * 16384.,
    (double)12548./3137161264. * 16384.,
    (double)12407./3137161264. * 16384.,
    (double)13789./3137161264. * 16384.,
    (double)15947./3137161264. * 16384.,
    (double)2370./3137161264. * 16384.,
    (double)12063./3137161264. * 16384.,
    (double)15103./3137161264. * 16384.,
    (double)12803./3137161264. * 16384.,
    (double)13468./3137161264. * 16384.,
    (double)11142./3137161264. * 16384.,
    (double)14882./3137161264. * 16384.,
    (double)14478./3137161264. * 16384.,
    (double)13861./3137161264. * 16384.,
    (double)12789./3137161264. * 16384.,
    (double)17224./3137161264. * 16384.,
    (double)1664./3137161264. * 16384.,
    (double)1779./3137161264. * 16384.,
    (double)1867./3137161264. * 16384.,
    (double)2998./3137161264. * 16384.,
    (double)11599./3137161264. * 16384.,
    (double)1575./3137161264. * 16384.,
    (double)9526./3137161264. * 16384.,
    (double)11964./3137161264. * 16384.,
    (double)8586./3137161264. * 16384.,
    (double)12007./3137161264. * 16384.,
    (double)10221./3137161264. * 16384.,
    (double)14949./3137161264. * 16384.,
    (double)19438./3137161264. * 16384.,
    (double)11404./3137161264. * 16384.,
    (double)13399./3137161264. * 16384.,
    (double)26019./3137161264. * 16384.,
    (double)16124./3137161264. * 16384.,
    (double)12551./3137161264. * 16384.,
    (double)12982./3137161264. * 16384.,
    (double)25026./3137161264. * 16384.,
    (double)18676./3137161264. * 16384.,
    (double)1776./3137161264. * 16384.,
    (double)11740./3137161264. * 16384.,
    (double)22375./3137161264. * 16384.,
    (double)20828./3137161264. * 16384.,
    (double)15266./3137161264. * 16384.,
    (double)18139./3137161264. * 16384.,
    (double)44033./3137161264. * 16384.,
    (double)35575./3137161264. * 16384.,
    (double)28778./3137161264. * 16384.,
    (double)21516./3137161264. * 16384.,
    (double)25372./3137161264. * 16384.,
    (double)30234./3137161264. * 16384.,
    (double)28112./3137161264. * 16384.,
    (double)47376./3137161264. * 16384.,
    (double)23503./3137161264. * 16384.,
    (double)24006./3137161264. * 16384.,
    (double)4507./3137161264. * 16384.,
    (double)21185./3137161264. * 16384.,
    (double)24212./3137161264. * 16384.,
    (double)18103./3137161264. * 16384.,
    (double)24825./3137161264. * 16384.,
    (double)19353./3137161264. * 16384.,
    (double)24956./3137161264. * 16384.,
    (double)36306./3137161264. * 16384.,
    (double)37675./3137161264. * 16384.,
    (double)20775./3137161264. * 16384.,
    (double)23085./3137161264. * 16384.,
    (double)35192./3137161264. * 16384.,
    (double)38613./3137161264. * 16384.,
    (double)32177./3137161264. * 16384.,
    (double)26720./3137161264. * 16384.,
    (double)32383./3137161264. * 16384.,
    (double)8319./3137161264. * 16384.,
    (double)33310./3137161264. * 16384.,
    (double)37557./3137161264. * 16384.,
    (double)19772./3137161264. * 16384.,
    (double)37988./3137161264. * 16384.,
    (double)21969./3137161264. * 16384.,
    (double)24946./3137161264. * 16384.,
    (double)19396./3137161264. * 16384.,
    (double)30282./3137161264. * 16384.,
    (double)24490./3137161264. * 16384.,
    (double)23792./3137161264. * 16384.,
    (double)3047./3137161264. * 16384.,
    (double)6222./3137161264. * 16384.,
    (double)7793./3137161264. * 16384.,
    (double)5701./3137161264. * 16384.,
    (double)27455./3137161264. * 16384.,
    (double)5461./3137161264. * 16384.,
    (double)31667./3137161264. * 16384.,
    (double)31424./3137161264. * 16384.,
    (double)14609./3137161264. * 16384.,
    (double)31373./3137161264. * 16384.,
    (double)22210./3137161264. * 16384.,
    (double)23723./3137161264. * 16384.,
    (double)21191./3137161264. * 16384.,
    (double)16146./3137161264. * 16384.,
    (double)15625./3137161264. * 16384.,
    (double)23906./3137161264. * 16384.,
    (double)27231./3137161264. * 16384.,
    (double)29826./3137161264. * 16384.,
    (double)31929./3137161264. * 16384.,
    (double)43216./3137161264. * 16384.,
    (double)23120./3137161264. * 16384.,
    (double)3588./3137161264. * 16384.,
    (double)24871./3137161264. * 16384.,
    (double)31156./3137161264. * 16384.,
    (double)21538./3137161264. * 16384.,
    (double)25236./3137161264. * 16384.,
    (double)25600./3137161264. * 16384.,
    (double)38316./3137161264. * 16384.,
    (double)19494./3137161264. * 16384.,
    (double)13867./3137161264. * 16384.,
    (double)10947./3137161264. * 16384.,
    (double)13426./3137161264. * 16384.,
    (double)18571./3137161264. * 16384.,
    (double)18761./3137161264. * 16384.,
    (double)20136./3137161264. * 16384.,
    (double)17015./3137161264. * 16384.,
    (double)20604./3137161264. * 16384.,
    (double)4130./3137161264. * 16384.,
    (double)19276./3137161264. * 16384.,
    (double)20274./3137161264. * 16384.,
    (double)12709./3137161264. * 16384.,
    (double)16627./3137161264. * 16384.,
    (double)18722./3137161264. * 16384.,
    (double)22054./3137161264. * 16384.,
    (double)2161./3137161264. * 16384.,
    (double)2850./3137161264. * 16384.,
    (double)1818./3137161264. * 16384.,
    (double)2024./3137161264. * 16384.,
    (double)3012./3137161264. * 16384.,
    (double)5334./3137161264. * 16384.,
    (double)4469./3137161264. * 16384.,
    (double)2870./3137161264. * 16384.,
    (double)3075./3137161264. * 16384.,
    (double)1783./3137161264. * 16384.,
    (double)4833./3137161264. * 16384.,
    (double)4155./3137161264. * 16384.,
    (double)2005./3137161264. * 16384.,
    (double)3998./3137161264. * 16384.,
    (double)3701./3137161264. * 16384.,
    (double)3141./3137161264. * 16384.,
    (double)13121./3137161264. * 16384.,
    (double)21111./3137161264. * 16384.,
    (double)17379./3137161264. * 16384.,
    (double)16548./3137161264. * 16384.,
    (double)2450./3137161264. * 16384.,
    (double)4872./3137161264. * 16384.,
    (double)5170./3137161264. * 16384.,
    (double)3887./3137161264. * 16384.,
    (double)20712./3137161264. * 16384.,
    (double)6181./3137161264. * 16384.,
    (double)22859./3137161264. * 16384.,
    (double)22241./3137161264. * 16384.,
    (double)10609./3137161264. * 16384.,
    (double)24306./3137161264. * 16384.,
    (double)24237./3137161264. * 16384.,
    (double)21709./3137161264. * 16384.,
    (double)14262./3137161264. * 16384.,
    (double)10731./3137161264. * 16384.,
    (double)11694./3137161264. * 16384.,
    (double)15536./3137161264. * 16384.,
    (double)18822./3137161264. * 16384.,
    (double)20894./3137161264. * 16384.,
    (double)23358./3137161264. * 16384.,
    (double)28914./3137161264. * 16384.,
    (double)35765./3137161264. * 16384.,
    (double)5082./3137161264. * 16384.,
    (double)29054./3137161264. * 16384.,
    (double)40764./3137161264. * 16384.,
    (double)17577./3137161264. * 16384.,
    (double)19657./3137161264. * 16384.,
    (double)26968./3137161264. * 16384.,
    (double)32219./3137161264. * 16384.,
    (double)26263./3137161264. * 16384.,
    (double)16173./3137161264. * 16384.,
    (double)12592./3137161264. * 16384.,
    (double)19649./3137161264. * 16384.,
    (double)15088./3137161264. * 16384.,
    (double)12450./3137161264. * 16384.,
    (double)12050./3137161264. * 16384.,
    (double)13526./3137161264. * 16384.,
    (double)15344./3137161264. * 16384.,
    (double)2109./3137161264. * 16384.,
    (double)10889./3137161264. * 16384.,
    (double)15686./3137161264. * 16384.,
    (double)16642./3137161264. * 16384.,
    (double)14450./3137161264. * 16384.,
    (double)14051./3137161264. * 16384.,
    (double)27448./3137161264. * 16384.,
    (double)19737./3137161264. * 16384.,
    (double)16145./3137161264. * 16384.,
    (double)11164./3137161264. * 16384.,
    (double)15133./3137161264. * 16384.,
    (double)16367./3137161264. * 16384.,
    (double)16937./3137161264. * 16384.,
    (double)15113./3137161264. * 16384.,
    (double)15879./3137161264. * 16384.,
    (double)15985./3137161264. * 16384.,
    (double)2346./3137161264. * 16384.,
    (double)15513./3137161264. * 16384.,
    (double)20494./3137161264. * 16384.,
    (double)14909./3137161264. * 16384.,
    (double)18410./3137161264. * 16384.,
    (double)15311./3137161264. * 16384.,
    (double)23407./3137161264. * 16384.,
    (double)17794./3137161264. * 16384.,
    (double)19542./3137161264. * 16384.,
    (double)16508./3137161264. * 16384.,
    (double)22495./3137161264. * 16384.,
    (double)2138./3137161264. * 16384.,
    (double)2436./3137161264. * 16384.,
    (double)2329./3137161264. * 16384.,
    (double)2915./3137161264. * 16384.,
    (double)19459./3137161264. * 16384.,
    (double)3005./3137161264. * 16384.,
    (double)19782./3137161264. * 16384.,
    (double)24642./3137161264. * 16384.,
    (double)15813./3137161264. * 16384.,
    (double)25286./3137161264. * 16384.,
    (double)23708./3137161264. * 16384.,
    (double)28694./3137161264. * 16384.,
    (double)26363./3137161264. * 16384.,
    (double)15519./3137161264. * 16384.,
    (double)16817./3137161264. * 16384.,
    (double)30414./3137161264. * 16384.,
    (double)25212./3137161264. * 16384.,
    (double)20601./3137161264. * 16384.,
    (double)20355./3137161264. * 16384.,
    (double)28980./3137161264. * 16384.,
    (double)29702./3137161264. * 16384.,
    (double)2832./3137161264. * 16384.,
    (double)31937./3137161264. * 16384.,
    (double)42124./3137161264. * 16384.,
    (double)39266./3137161264. * 16384.,
    (double)34330./3137161264. * 16384.,
    (double)43475./3137161264. * 16384.,
    (double)54455./3137161264. * 16384.,
    (double)341319./3137161264. * 16384.,
    (double)222667./3137161264. * 16384.,
    (double)191927./3137161264. * 16384.,
    (double)310584./3137161264. * 16384.,
    (double)225441./3137161264. * 16384.,
    (double)168126./3137161264. * 16384.,
    (double)160389./3137161264. * 16384.,
    (double)190729./3137161264. * 16384.,
    (double)193483./3137161264. * 16384.,
    (double)20958./3137161264. * 16384.,
    (double)138295./3137161264. * 16384.,
    (double)174749./3137161264. * 16384.,
    (double)241837./3137161264. * 16384.,
    (double)209351./3137161264. * 16384.,
    (double)156555./3137161264. * 16384.,
    (double)232466./3137161264. * 16384.,
    (double)237983./3137161264. * 16384.,
    (double)173732./3137161264. * 16384.,
    (double)118475./3137161264. * 16384.,
    (double)156734./3137161264. * 16384.,
    (double)183947./3137161264. * 16384.,
    (double)131046./3137161264. * 16384.,
    (double)145572./3137161264. * 16384.,
    (double)137212./3137161264. * 16384.,
    (double)149224./3137161264. * 16384.,
    (double)16535./3137161264. * 16384.,
    (double)116803./3137161264. * 16384.,
    (double)127369./3137161264. * 16384.,
    (double)127255./3137161264. * 16384.,
    (double)140401./3137161264. * 16384.,
    (double)115313./3137161264. * 16384.,
    (double)144185./3137161264. * 16384.,
    (double)151406./3137161264. * 16384.,
    (double)137758./3137161264. * 16384.,
    (double)115359./3137161264. * 16384.,
    (double)148520./3137161264. * 16384.,
    (double)14811./3137161264. * 16384.,
    (double)13456./3137161264. * 16384.,
    (double)14038./3137161264. * 16384.,
    (double)21407./3137161264. * 16384.,
    (double)116461./3137161264. * 16384.,
    (double)12311./3137161264. * 16384.,
    (double)107497./3137161264. * 16384.,
    (double)121796./3137161264. * 16384.,
    (double)87771./3137161264. * 16384.,
    (double)111099./3137161264. * 16384.,
    (double)111614./3137161264. * 16384.,
    (double)131783./3137161264. * 16384.,
    (double)164138./3137161264. * 16384.,
    (double)85880./3137161264. * 16384.,
    (double)75190./3137161264. * 16384.,
    (double)147964./3137161264. * 16384.,
    (double)122239./3137161264. * 16384.,
    (double)91637./3137161264. * 16384.,
    (double)83809./3137161264. * 16384.,
    (double)117586./3137161264. * 16384.,
    (double)110262./3137161264. * 16384.,
    (double)9504./3137161264. * 16384.,
    (double)83012./3137161264. * 16384.,
    (double)109504./3137161264. * 16384.,
    (double)129077./3137161264. * 16384.,
    (double)73146./3137161264. * 16384.,
    (double)113120./3137161264. * 16384.,
    (double)198337./3137161264. * 16384.,
    (double)316492./3137161264. * 16384.,
    (double)220489./3137161264. * 16384.,
    (double)136264./3137161264. * 16384.,
    (double)201366./3137161264. * 16384.,
    (double)231494./3137161264. * 16384.,
    (double)195476./3137161264. * 16384.,
    (double)160718./3137161264. * 16384.,
    (double)149831./3137161264. * 16384.,
    (double)160545./3137161264. * 16384.,
    (double)21727./3137161264. * 16384.,
    (double)107921./3137161264. * 16384.,
    (double)137908./3137161264. * 16384.,
    (double)130877./3137161264. * 16384.,
    (double)155782./3137161264. * 16384.,
    (double)96994./3137161264. * 16384.,
    (double)146191./3137161264. * 16384.,
    (double)273035./3137161264. * 16384.,
    (double)262119./3137161264. * 16384.,
    (double)138326./3137161264. * 16384.,
    (double)152397./3137161264. * 16384.,
    (double)210273./3137161264. * 16384.,
    (double)145354./3137161264. * 16384.,
    (double)176686./3137161264. * 16384.,
    (double)138668./3137161264. * 16384.,
    (double)226518./3137161264. * 16384.,
    (double)35359./3137161264. * 16384.,
    (double)181402./3137161264. * 16384.,
    (double)234418./3137161264. * 16384.,
    (double)121216./3137161264. * 16384.,
    (double)175216./3137161264. * 16384.,
    (double)110894./3137161264. * 16384.,
    (double)132413./3137161264. * 16384.,
    (double)166887./3137161264. * 16384.,
    (double)208442./3137161264. * 16384.,
    (double)156127./3137161264. * 16384.,
    (double)159234./3137161264. * 16384.,
    (double)22087./3137161264. * 16384.,
    (double)26505./3137161264. * 16384.,
    (double)25900./3137161264. * 16384.,
    (double)27965./3137161264. * 16384.,
    (double)215119./3137161264. * 16384.,
    (double)34608./3137161264. * 16384.,
    (double)201754./3137161264. * 16384.,
    (double)304141./3137161264. * 16384.,
    (double)123053./3137161264. * 16384.,
    (double)199604./3137161264. * 16384.,
    (double)168669./3137161264. * 16384.,
    (double)167171./3137161264. * 16384.,
    (double)125117./3137161264. * 16384.,
    (double)94085./3137161264. * 16384.,
    (double)68192./3137161264. * 16384.,
    (double)102149./3137161264. * 16384.,
    (double)161798./3137161264. * 16384.,
    (double)150116./3137161264. * 16384.,
    (double)117126./3137161264. * 16384.,
    (double)146539./3137161264. * 16384.,
    (double)123457./3137161264. * 16384.,
    (double)13321./3137161264. * 16384.,
    (double)103206./3137161264. * 16384.,
    (double)157696./3137161264. * 16384.,
    (double)112573./3137161264. * 16384.,
    (double)103737./3137161264. * 16384.,
    (double)118135./3137161264. * 16384.,
    (double)194259./3137161264. * 16384.,
    (double)224418./3137161264. * 16384.,
    (double)123764./3137161264. * 16384.,
    (double)96659./3137161264. * 16384.,
    (double)141039./3137161264. * 16384.,
    (double)218833./3137161264. * 16384.,
    (double)172232./3137161264. * 16384.,
    (double)168916./3137161264. * 16384.,
    (double)164249./3137161264. * 16384.,
    (double)200440./3137161264. * 16384.,
    (double)27572./3137161264. * 16384.,
    (double)136790./3137161264. * 16384.,
    (double)144061./3137161264. * 16384.,
    (double)139900./3137161264. * 16384.,
    (double)157226./3137161264. * 16384.,
    (double)126945./3137161264. * 16384.,
    (double)184846./3137161264. * 16384.,
    (double)24419./3137161264. * 16384.,
    (double)26002./3137161264. * 16384.,
    (double)16691./3137161264. * 16384.,
    (double)20047./3137161264. * 16384.,
    (double)29950./3137161264. * 16384.,
    (double)29642./3137161264. * 16384.,
    (double)30616./3137161264. * 16384.,
    (double)25112./3137161264. * 16384.,
    (double)26781./3137161264. * 16384.,
    (double)7303./3137161264. * 16384.,
    (double)44929./3137161264. * 16384.,
    (double)29042./3137161264. * 16384.,
    (double)23526./3137161264. * 16384.,
    (double)50486./3137161264. * 16384.,
    (double)26383./3137161264. * 16384.,
    (double)33247./3137161264. * 16384.,
    (double)138473./3137161264. * 16384.,
    (double)145129./3137161264. * 16384.,
    (double)190114./3137161264. * 16384.,
    (double)172138./3137161264. * 16384.,
    (double)19793./3137161264. * 16384.,
    (double)19159./3137161264. * 16384.,
    (double)61150./3137161264. * 16384.,
    (double)42139./3137161264. * 16384.,
    (double)170460./3137161264. * 16384.,
    (double)28621./3137161264. * 16384.,
    (double)170100./3137161264. * 16384.,
    (double)151435./3137161264. * 16384.,
    (double)88127./3137161264. * 16384.,
    (double)154438./3137161264. * 16384.,
    (double)165885./3137161264. * 16384.,
    (double)140977./3137161264. * 16384.,
    (double)103394./3137161264. * 16384.,
    (double)78819./3137161264. * 16384.,
    (double)76668./3137161264. * 16384.,
    (double)95322./3137161264. * 16384.,
    (double)165790./3137161264. * 16384.,
    (double)145932./3137161264. * 16384.,
    (double)210070./3137161264. * 16384.,
    (double)184510./3137161264. * 16384.,
    (double)132063./3137161264. * 16384.,
    (double)17711./3137161264. * 16384.,
    (double)134646./3137161264. * 16384.,
    (double)148163./3137161264. * 16384.,
    (double)117238./3137161264. * 16384.,
    (double)113353./3137161264. * 16384.,
    (double)145096./3137161264. * 16384.,
    (double)183866./3137161264. * 16384.,
    (double)202744./3137161264. * 16384.,
    (double)89553./3137161264. * 16384.,
    (double)75005./3137161264. * 16384.,
    (double)137223./3137161264. * 16384.,
    (double)105707./3137161264. * 16384.,
    (double)78152./3137161264. * 16384.,
    (double)76087./3137161264. * 16384.,
    (double)83481./3137161264. * 16384.,
    (double)104742./3137161264. * 16384.,
    (double)11848./3137161264. * 16384.,
    (double)64127./3137161264. * 16384.,
    (double)86265./3137161264. * 16384.,
    (double)133516./3137161264. * 16384.,
    (double)115292./3137161264. * 16384.,
    (double)97731./3137161264. * 16384.,
    (double)168036./3137161264. * 16384.,
    (double)175336./3137161264. * 16384.,
    (double)138547./3137161264. * 16384.,
    (double)96258./3137161264. * 16384.,
    (double)123850./3137161264. * 16384.,
    (double)143413./3137161264. * 16384.,
    (double)121172./3137161264. * 16384.,
    (double)114693./3137161264. * 16384.,
    (double)110812./3137161264. * 16384.,
    (double)128476./3137161264. * 16384.,
    (double)15118./3137161264. * 16384.,
    (double)136394./3137161264. * 16384.,
    (double)141808./3137161264. * 16384.,
    (double)122408./3137161264. * 16384.,
    (double)169133./3137161264. * 16384.,
    (double)115163./3137161264. * 16384.,
    (double)175723./3137161264. * 16384.,
    (double)135824./3137161264. * 16384.,
    (double)135893./3137161264. * 16384.,
    (double)131956./3137161264. * 16384.,
    (double)141124./3137161264. * 16384.,
    (double)14414./3137161264. * 16384.,
    (double)13485./3137161264. * 16384.,
    (double)17563./3137161264. * 16384.,
    (double)19518./3137161264. * 16384.,
    (double)145547./3137161264. * 16384.,
    (double)16326./3137161264. * 16384.,
    (double)133217./3137161264. * 16384.,
    (double)157772./3137161264. * 16384.,
    (double)109049./3137161264. * 16384.,
    (double)160230./3137161264. * 16384.,
    (double)191320./3137161264. * 16384.,
    (double)182572./3137161264. * 16384.,
    (double)151972./3137161264. * 16384.,
    (double)93765./3137161264. * 16384.,
    (double)87410./3137161264. * 16384.,
    (double)151794./3137161264. * 16384.,
    (double)107685./3137161264. * 16384.,
    (double)85532./3137161264. * 16384.,
    (double)106841./3137161264. * 16384.,
    (double)132526./3137161264. * 16384.,
    (double)161873./3137161264. * 16384.,
    (double)17035./3137161264. * 16384.,
    (double)142166./3137161264. * 16384.,
    (double)201719./3137161264. * 16384.,
    (double)205725./3137161264. * 16384.,
    (double)178098./3137161264. * 16384.,
    (double)211631./3137161264. * 16384.,
    (double)355696./3137161264. * 16384.,
    (double)23285./3137161264. * 16384.,
    (double)19408./3137161264. * 16384.,
    (double)14073./3137161264. * 16384.,
    (double)18608./3137161264. * 16384.,
    (double)19461./3137161264. * 16384.,
    (double)19279./3137161264. * 16384.,
    (double)17335./3137161264. * 16384.,
    (double)18130./3137161264. * 16384.,
    (double)13358./3137161264. * 16384.,
    (double)2574./3137161264. * 16384.,
    (double)9311./3137161264. * 16384.,
    (double)11375./3137161264. * 16384.,
    (double)13761./3137161264. * 16384.,
    (double)15455./3137161264. * 16384.,
    (double)11872./3137161264. * 16384.,
    (double)15754./3137161264. * 16384.,
    (double)24838./3137161264. * 16384.,
    (double)26700./3137161264. * 16384.,
    (double)19718./3137161264. * 16384.,
    (double)20819./3137161264. * 16384.,
    (double)28865./3137161264. * 16384.,
    (double)29261./3137161264. * 16384.,
    (double)43584./3137161264. * 16384.,
    (double)27527./3137161264. * 16384.,
    (double)19695./3137161264. * 16384.,
    (double)6430./3137161264. * 16384.,
    (double)22138./3137161264. * 16384.,
    (double)19628./3137161264. * 16384.,
    (double)16492./3137161264. * 16384.,
    (double)20517./3137161264. * 16384.,
    (double)17737./3137161264. * 16384.,
    (double)17143./3137161264. * 16384.,
    (double)11202./3137161264. * 16384.,
    (double)15517./3137161264. * 16384.,
    (double)12089./3137161264. * 16384.,
    (double)11972./3137161264. * 16384.,
    (double)2472./3137161264. * 16384.,
    (double)4173./3137161264. * 16384.,
    (double)4331./3137161264. * 16384.,
    (double)3382./3137161264. * 16384.,
    (double)12009./3137161264. * 16384.,
    (double)3348./3137161264. * 16384.,
    (double)16244./3137161264. * 16384.,
    (double)14966./3137161264. * 16384.,
    (double)7471./3137161264. * 16384.,
    (double)14176./3137161264. * 16384.,
    (double)14267./3137161264. * 16384.,
    (double)13959./3137161264. * 16384.,
    (double)11019./3137161264. * 16384.,
    (double)7676./3137161264. * 16384.,
    (double)6636./3137161264. * 16384.,
    (double)10024./3137161264. * 16384.,
    (double)13735./3137161264. * 16384.,
    (double)13531./3137161264. * 16384.,
    (double)11680./3137161264. * 16384.,
    (double)12374./3137161264. * 16384.,
    (double)9090./3137161264. * 16384.,
    (double)1687./3137161264. * 16384.,
    (double)8878./3137161264. * 16384.,
    (double)11129./3137161264. * 16384.,
    (double)9887./3137161264. * 16384.,
    (double)8649./3137161264. * 16384.,
    (double)11870./3137161264. * 16384.,
    (double)18989./3137161264. * 16384.,
    (double)21071./3137161264. * 16384.,
    (double)24385./3137161264. * 16384.,
    (double)12439./3137161264. * 16384.,
    (double)13526./3137161264. * 16384.,
    (double)21477./3137161264. * 16384.,
    (double)27048./3137161264. * 16384.,
    (double)22668./3137161264. * 16384.,
    (double)15141./3137161264. * 16384.,
    (double)14488./3137161264. * 16384.,
    (double)4480./3137161264. * 16384.,
    (double)11472./3137161264. * 16384.,
    (double)11666./3137161264. * 16384.,
    (double)8560./3137161264. * 16384.,
    (double)14044./3137161264. * 16384.,
    (double)9086./3137161264. * 16384.,
    (double)10680./3137161264. * 16384.,
    (double)28701./3137161264. * 16384.,
    (double)45149./3137161264. * 16384.,
    (double)19702./3137161264. * 16384.,
    (double)16023./3137161264. * 16384.,
    (double)30044./3137161264. * 16384.,
    (double)28494./3137161264. * 16384.,
    (double)36193./3137161264. * 16384.,
    (double)20922./3137161264. * 16384.,
    (double)30199./3137161264. * 16384.,
    (double)15562./3137161264. * 16384.,
    (double)31462./3137161264. * 16384.,
    (double)28249./3137161264. * 16384.,
    (double)11779./3137161264. * 16384.,
    (double)26094./3137161264. * 16384.,
    (double)16622./3137161264. * 16384.,
    (double)15639./3137161264. * 16384.,
    (double)14171./3137161264. * 16384.,
    (double)27933./3137161264. * 16384.,
    (double)16633./3137161264. * 16384.,
    (double)13940./3137161264. * 16384.,
    (double)4822./3137161264. * 16384.,
    (double)11906./3137161264. * 16384.,
    (double)10239./3137161264. * 16384.,
    (double)5041./3137161264. * 16384.,
    (double)44554./3137161264. * 16384.,
    (double)18869./3137161264. * 16384.,
    (double)43359./3137161264. * 16384.,
    (double)53203./3137161264. * 16384.,
    (double)14463./3137161264. * 16384.,
    (double)32165./3137161264. * 16384.,
    (double)23788./3137161264. * 16384.,
    (double)18870./3137161264. * 16384.,
    (double)10061./3137161264. * 16384.,
    (double)9063./3137161264. * 16384.,
    (double)6471./3137161264. * 16384.,
    (double)7769./3137161264. * 16384.,
    (double)14621./3137161264. * 16384.,
    (double)18903./3137161264. * 16384.,
    (double)14449./3137161264. * 16384.,
    (double)13266./3137161264. * 16384.,
    (double)11613./3137161264. * 16384.,
    (double)2714./3137161264. * 16384.,
    (double)12471./3137161264. * 16384.,
    (double)15515./3137161264. * 16384.,
    (double)7675./3137161264. * 16384.,
    (double)9786./3137161264. * 16384.,
    (double)11063./3137161264. * 16384.,
    (double)14746./3137161264. * 16384.,
    (double)17304./3137161264. * 16384.,
    (double)13949./3137161264. * 16384.,
    (double)10288./3137161264. * 16384.,
    (double)10669./3137161264. * 16384.,
    (double)22443./3137161264. * 16384.,
    (double)28101./3137161264. * 16384.,
    (double)29435./3137161264. * 16384.,
    (double)17098./3137161264. * 16384.,
    (double)18745./3137161264. * 16384.,
    (double)5425./3137161264. * 16384.,
    (double)29356./3137161264. * 16384.,
    (double)16687./3137161264. * 16384.,
    (double)9749./3137161264. * 16384.,
    (double)15744./3137161264. * 16384.,
    (double)15210./3137161264. * 16384.,
    (double)14790./3137161264. * 16384.,
    (double)2931./3137161264. * 16384.,
    (double)6011./3137161264. * 16384.,
    (double)3707./3137161264. * 16384.,
    (double)2646./3137161264. * 16384.,
    (double)6376./3137161264. * 16384.,
    (double)12603./3137161264. * 16384.,
    (double)13384./3137161264. * 16384.,
    (double)5192./3137161264. * 16384.,
    (double)5456./3137161264. * 16384.,
    (double)6907./3137161264. * 16384.,
    (double)31564./3137161264. * 16384.,
    (double)7394./3137161264. * 16384.,
    (double)2038./3137161264. * 16384.,
    (double)7029./3137161264. * 16384.,
    (double)6240./3137161264. * 16384.,
    (double)3678./3137161264. * 16384.,
    (double)14672./3137161264. * 16384.,
    (double)22903./3137161264. * 16384.,
    (double)23146./3137161264. * 16384.,
    (double)18077./3137161264. * 16384.,
    (double)5066./3137161264. * 16384.,
    (double)10145./3137161264. * 16384.,
    (double)18330./3137161264. * 16384.,
    (double)5583./3137161264. * 16384.,
    (double)27400./3137161264. * 16384.,
    (double)15013./3137161264. * 16384.,
    (double)42635./3137161264. * 16384.,
    (double)24987./3137161264. * 16384.,
    (double)9771./3137161264. * 16384.,
    (double)29495./3137161264. * 16384.,
    (double)33705./3137161264. * 16384.,
    (double)20811./3137161264. * 16384.,
    (double)9870./3137161264. * 16384.,
    (double)8584./3137161264. * 16384.,
    (double)8482./3137161264. * 16384.,
    (double)9109./3137161264. * 16384.,
    (double)18142./3137161264. * 16384.,
    (double)24038./3137161264. * 16384.,
    (double)28665./3137161264. * 16384.,
    (double)19736./3137161264. * 16384.,
    (double)15720./3137161264. * 16384.,
    (double)4853./3137161264. * 16384.,
    (double)24378./3137161264. * 16384.,
    (double)19433./3137161264. * 16384.,
    (double)9153./3137161264. * 16384.,
    (double)14218./3137161264. * 16384.,
    (double)19208./3137161264. * 16384.,
    (double)19151./3137161264. * 16384.,
    (double)17410./3137161264. * 16384.,
    (double)14721./3137161264. * 16384.,
    (double)10623./3137161264. * 16384.,
    (double)15797./3137161264. * 16384.,
    (double)11918./3137161264. * 16384.,
    (double)11359./3137161264. * 16384.,
    (double)9917./3137161264. * 16384.,
    (double)10688./3137161264. * 16384.,
    (double)10565./3137161264. * 16384.,
    (double)1646./3137161264. * 16384.,
    (double)8421./3137161264. * 16384.,
    (double)9662./3137161264. * 16384.,
    (double)11973./3137161264. * 16384.,
    (double)12736./3137161264. * 16384.,
    (double)13698./3137161264. * 16384.,
    (double)18768./3137161264. * 16384.,
    (double)23108./3137161264. * 16384.,
    (double)24435./3137161264. * 16384.,
    (double)16770./3137161264. * 16384.,
    (double)18326./3137161264. * 16384.,
    (double)26170./3137161264. * 16384.,
    (double)31509./3137161264. * 16384.,
    (double)26427./3137161264. * 16384.,
    (double)22000./3137161264. * 16384.,
    (double)20223./3137161264. * 16384.,
    (double)5015./3137161264. * 16384.,
    (double)37922./3137161264. * 16384.,
    (double)23419./3137161264. * 16384.,
    (double)15211./3137161264. * 16384.,
    (double)29135./3137161264. * 16384.,
    (double)23172./3137161264. * 16384.,
    (double)25754./3137161264. * 16384.,
    (double)12232./3137161264. * 16384.,
    (double)16837./3137161264. * 16384.,
    (double)16668./3137161264. * 16384.,
    (double)15005./3137161264. * 16384.,
    (double)1873./3137161264. * 16384.,
    (double)3975./3137161264. * 16384.,
    (double)4350./3137161264. * 16384.,
    (double)2831./3137161264. * 16384.,
    (double)16220./3137161264. * 16384.,
    (double)4526./3137161264. * 16384.,
    (double)20991./3137161264. * 16384.,
    (double)20508./3137161264. * 16384.,
    (double)12507./3137161264. * 16384.,
    (double)21963./3137161264. * 16384.,
    (double)42577./3137161264. * 16384.,
    (double)23521./3137161264. * 16384.,
    (double)13010./3137161264. * 16384.,
    (double)9997./3137161264. * 16384.,
    (double)9090./3137161264. * 16384.,
    (double)12796./3137161264. * 16384.,
    (double)11451./3137161264. * 16384.,
    (double)12469./3137161264. * 16384.,
    (double)12510./3137161264. * 16384.,
    (double)13558./3137161264. * 16384.,
    (double)14245./3137161264. * 16384.,
    (double)2263./3137161264. * 16384.,
    (double)16310./3137161264. * 16384.,
    (double)20882./3137161264. * 16384.,
    (double)15987./3137161264. * 16384.,
    (double)17981./3137161264. * 16384.,
    (double)25700./3137161264. * 16384.,
    (double)32937./3137161264. * 16384.,
    (double)222571./3137161264. * 16384.,
    (double)198568./3137161264. * 16384.,
    (double)137406./3137161264. * 16384.,
    (double)215424./3137161264. * 16384.,
    (double)152666./3137161264. * 16384.,
    (double)145707./3137161264. * 16384.,
    (double)98828./3137161264. * 16384.,
    (double)120960./3137161264. * 16384.,
    (double)131296./3137161264. * 16384.,
    (double)14986./3137161264. * 16384.,
    (double)101677./3137161264. * 16384.,
    (double)112069./3137161264. * 16384.,
    (double)96694./3137161264. * 16384.,
    (double)86336./3137161264. * 16384.,
    (double)70996./3137161264. * 16384.,
    (double)107494./3137161264. * 16384.,
    (double)220753./3137161264. * 16384.,
    (double)208250./3137161264. * 16384.,
    (double)115515./3137161264. * 16384.,
    (double)134100./3137161264. * 16384.,
    (double)221428./3137161264. * 16384.,
    (double)189411./3137161264. * 16384.,
    (double)189199./3137161264. * 16384.,
    (double)141491./3137161264. * 16384.,
    (double)220703./3137161264. * 16384.,
    (double)32642./3137161264. * 16384.,
    (double)256190./3137161264. * 16384.,
    (double)217988./3137161264. * 16384.,
    (double)99298./3137161264. * 16384.,
    (double)163572./3137161264. * 16384.,
    (double)107433./3137161264. * 16384.,
    (double)128280./3137161264. * 16384.,
    (double)135355./3137161264. * 16384.,
    (double)179217./3137161264. * 16384.,
    (double)123906./3137161264. * 16384.,
    (double)131013./3137161264. * 16384.,
    (double)20859./3137161264. * 16384.,
    (double)29593./3137161264. * 16384.,
    (double)24933./3137161264. * 16384.,
    (double)29642./3137161264. * 16384.,
    (double)151497./3137161264. * 16384.,
    (double)25229./3137161264. * 16384.,
    (double)189467./3137161264. * 16384.,
    (double)162727./3137161264. * 16384.,
    (double)78088./3137161264. * 16384.,
    (double)152844./3137161264. * 16384.,
    (double)123909./3137161264. * 16384.,
    (double)133130./3137161264. * 16384.,
    (double)106370./3137161264. * 16384.,
    (double)75316./3137161264. * 16384.,
    (double)56600./3137161264. * 16384.,
    (double)96035./3137161264. * 16384.,
    (double)114101./3137161264. * 16384.,
    (double)114067./3137161264. * 16384.,
    (double)90374./3137161264. * 16384.,
    (double)112270./3137161264. * 16384.,
    (double)131704./3137161264. * 16384.,
    (double)15996./3137161264. * 16384.,
    (double)124251./3137161264. * 16384.,
    (double)166543./3137161264. * 16384.,
    (double)103445./3137161264. * 16384.,
    (double)93870./3137161264. * 16384.,
    (double)118782./3137161264. * 16384.,
    (double)199242./3137161264. * 16384.,
    (double)18310./3137161264. * 16384.,
    (double)19811./3137161264. * 16384.,
    (double)10688./3137161264. * 16384.,
    (double)14081./3137161264. * 16384.,
    (double)23082./3137161264. * 16384.,
    (double)30750./3137161264. * 16384.,
    (double)18989./3137161264. * 16384.,
    (double)19720./3137161264. * 16384.,
    (double)15138./3137161264. * 16384.,
    (double)4426./3137161264. * 16384.,
    (double)19679./3137161264. * 16384.,
    (double)15829./3137161264. * 16384.,
    (double)8630./3137161264. * 16384.,
    (double)13320./3137161264. * 16384.,
    (double)9327./3137161264. * 16384.,
    (double)11797./3137161264. * 16384.,
    (double)20276./3137161264. * 16384.,
    (double)27216./3137161264. * 16384.,
    (double)14013./3137161264. * 16384.,
    (double)12500./3137161264. * 16384.,
    (double)34056./3137161264. * 16384.,
    (double)35340./3137161264. * 16384.,
    (double)32416./3137161264. * 16384.,
    (double)21168./3137161264. * 16384.,
    (double)26302./3137161264. * 16384.,
    (double)11064./3137161264. * 16384.,
    (double)87144./3137161264. * 16384.,
    (double)36552./3137161264. * 16384.,
    (double)9010./3137161264. * 16384.,
    (double)19403./3137161264. * 16384.,
    (double)13975./3137161264. * 16384.,
    (double)11977./3137161264. * 16384.,
    (double)14970./3137161264. * 16384.,
    (double)27533./3137161264. * 16384.,
    (double)16933./3137161264. * 16384.,
    (double)13726./3137161264. * 16384.,
    (double)4424./3137161264. * 16384.,
    (double)10713./3137161264. * 16384.,
    (double)10380./3137161264. * 16384.,
    (double)4974./3137161264. * 16384.,
    (double)25463./3137161264. * 16384.,
    (double)11545./3137161264. * 16384.,
    (double)44713./3137161264. * 16384.,
    (double)32333./3137161264. * 16384.,
    (double)9703./3137161264. * 16384.,
    (double)25659./3137161264. * 16384.,
    (double)21420./3137161264. * 16384.,
    (double)17423./3137161264. * 16384.,
    (double)13468./3137161264. * 16384.,
    (double)10591./3137161264. * 16384.,
    (double)6787./3137161264. * 16384.,
    (double)11289./3137161264. * 16384.,
    (double)19742./3137161264. * 16384.,
    (double)26266./3137161264. * 16384.,
    (double)18474./3137161264. * 16384.,
    (double)21035./3137161264. * 16384.,
    (double)15887./3137161264. * 16384.,
    (double)3785./3137161264. * 16384.,
    (double)19691./3137161264. * 16384.,
    (double)31161./3137161264. * 16384.,
    (double)10797./3137161264. * 16384.,
    (double)12153./3137161264. * 16384.,
    (double)13669./3137161264. * 16384.,
    (double)22269./3137161264. * 16384.,
    (double)235351./3137161264. * 16384.,
    (double)127914./3137161264. * 16384.,
    (double)107787./3137161264. * 16384.,
    (double)82785./3137161264. * 16384.,
    (double)158690./3137161264. * 16384.,
    (double)177702./3137161264. * 16384.,
    (double)167276./3137161264. * 16384.,
    (double)121221./3137161264. * 16384.,
    (double)148345./3137161264. * 16384.,
    (double)28696./3137161264. * 16384.,
    (double)187777./3137161264. * 16384.,
    (double)132707./3137161264. * 16384.,
    (double)77239./3137161264. * 16384.,
    (double)112065./3137161264. * 16384.,
    (double)139192./3137161264. * 16384.,
    (double)122907./3137161264. * 16384.,
    (double)18653./3137161264. * 16384.,
    (double)27351./3137161264. * 16384.,
    (double)20221./3137161264. * 16384.,
    (double)12942./3137161264. * 16384.,
    (double)18951./3137161264. * 16384.,
    (double)32858./3137161264. * 16384.,
    (double)28021./3137161264. * 16384.,
    (double)13497./3137161264. * 16384.,
    (double)24490./3137161264. * 16384.,
    (double)10677./3137161264. * 16384.,
    (double)48959./3137161264. * 16384.,
    (double)25428./3137161264. * 16384.,
    (double)10889./3137161264. * 16384.,
    (double)26910./3137161264. * 16384.,
    (double)29045./3137161264. * 16384.,
    (double)16681./3137161264. * 16384.,
    (double)143642./3137161264. * 16384.,
    (double)135121./3137161264. * 16384.,
    (double)133532./3137161264. * 16384.,
    (double)99635./3137161264. * 16384.,
    (double)21403./3137161264. * 16384.,
    (double)21912./3137161264. * 16384.,
    (double)32723./3137161264. * 16384.,
    (double)17385./3137161264. * 16384.,
    (double)96627./3137161264. * 16384.,
    (double)21227./3137161264. * 16384.,
    (double)50373./3137161264. * 16384.,
    (double)46542./3137161264. * 16384.,
    (double)47916./3137161264. * 16384.,
    (double)76400./3137161264. * 16384.,
    (double)97559./3137161264. * 16384.,
    (double)85854./3137161264. * 16384.,
    (double)77363./3137161264. * 16384.,
    (double)60040./3137161264. * 16384.,
    (double)63918./3137161264. * 16384.,
    (double)53723./3137161264. * 16384.,
    (double)102011./3137161264. * 16384.,
    (double)113812./3137161264. * 16384.,
    (double)126274./3137161264. * 16384.,
    (double)92977./3137161264. * 16384.,
    (double)112258./3137161264. * 16384.,
    (double)19157./3137161264. * 16384.,
    (double)161735./3137161264. * 16384.,
    (double)127690./3137161264. * 16384.,
    (double)65257./3137161264. * 16384.,
    (double)86534./3137161264. * 16384.,
    (double)129632./3137161264. * 16384.,
    (double)135197./3137161264. * 16384.,
    (double)132519./3137161264. * 16384.,
    (double)80698./3137161264. * 16384.,
    (double)64418./3137161264. * 16384.,
    (double)86922./3137161264. * 16384.,
    (double)88299./3137161264. * 16384.,
    (double)70425./3137161264. * 16384.,
    (double)56018./3137161264. * 16384.,
    (double)57537./3137161264. * 16384.,
    (double)80419./3137161264. * 16384.,
    (double)10010./3137161264. * 16384.,
    (double)75217./3137161264. * 16384.,
    (double)78370./3137161264. * 16384.,
    (double)63283./3137161264. * 16384.,
    (double)63946./3137161264. * 16384.,
    (double)62591./3137161264. * 16384.,
    (double)88764./3137161264. * 16384.,
    (double)153552./3137161264. * 16384.,
    (double)151134./3137161264. * 16384.,
    (double)101741./3137161264. * 16384.,
    (double)101147./3137161264. * 16384.,
    (double)150544./3137161264. * 16384.,
    (double)171953./3137161264. * 16384.,
    (double)128739./3137161264. * 16384.,
    (double)98684./3137161264. * 16384.,
    (double)141012./3137161264. * 16384.,
    (double)22258./3137161264. * 16384.,
    (double)179519./3137161264. * 16384.,
    (double)155438./3137161264. * 16384.,
    (double)85238./3137161264. * 16384.,
    (double)150114./3137161264. * 16384.,
    (double)135251./3137161264. * 16384.,
    (double)115050./3137161264. * 16384.,
    (double)118322./3137161264. * 16384.,
    (double)138940./3137161264. * 16384.,
    (double)114700./3137161264. * 16384.,
    (double)117471./3137161264. * 16384.,
    (double)14607./3137161264. * 16384.,
    (double)22427./3137161264. * 16384.,
    (double)18432./3137161264. * 16384.,
    (double)16942./3137161264. * 16384.,
    (double)147118./3137161264. * 16384.,
    (double)21806./3137161264. * 16384.,
    (double)196646./3137161264. * 16384.,
    (double)167838./3137161264. * 16384.,
    (double)82341./3137161264. * 16384.,
    (double)157871./3137161264. * 16384.,
    (double)152299./3137161264. * 16384.,
    (double)143412./3137161264. * 16384.,
    (double)97212./3137161264. * 16384.,
    (double)70676./3137161264. * 16384.,
    (double)61693./3137161264. * 16384.,
    (double)87853./3137161264. * 16384.,
    (double)106483./3137161264. * 16384.,
    (double)103978./3137161264. * 16384.,
    (double)88021./3137161264. * 16384.,
    (double)95152./3137161264. * 16384.,
    (double)129616./3137161264. * 16384.,
    (double)15214./3137161264. * 16384.,
    (double)175961./3137161264. * 16384.,
    (double)172575./3137161264. * 16384.,
    (double)116213./3137161264. * 16384.,
    (double)130436./3137161264. * 16384.,
    (double)161236./3137161264. * 16384.,
    (double)191416./3137161264. * 16384.,
    (double)219568./3137161264. * 16384.,
    (double)121780./3137161264. * 16384.,
    (double)86787./3137161264. * 16384.,
    (double)163881./3137161264. * 16384.,
    (double)113641./3137161264. * 16384.,
    (double)83989./3137161264. * 16384.,
    (double)67086./3137161264. * 16384.,
    (double)93252./3137161264. * 16384.,
    (double)104372./3137161264. * 16384.,
    (double)11120./3137161264. * 16384.,
    (double)62853./3137161264. * 16384.,
    (double)90651./3137161264. * 16384.,
    (double)114868./3137161264. * 16384.,
    (double)94141./3137161264. * 16384.,
    (double)69578./3137161264. * 16384.,
    (double)131015./3137161264. * 16384.,
    (double)162566./3137161264. * 16384.,
    (double)104200./3137161264. * 16384.,
    (double)62732./3137161264. * 16384.,
    (double)86690./3137161264. * 16384.,
    (double)107743./3137161264. * 16384.,
    (double)72617./3137161264. * 16384.,
    (double)72378./3137161264. * 16384.,
    (double)74674./3137161264. * 16384.,
    (double)98631./3137161264. * 16384.,
    (double)8797./3137161264. * 16384.,
    (double)67707./3137161264. * 16384.,
    (double)82681./3137161264. * 16384.,
    (double)66223./3137161264. * 16384.,
    (double)69937./3137161264. * 16384.,
    (double)54033./3137161264. * 16384.,
    (double)80551./3137161264. * 16384.,
    (double)105280./3137161264. * 16384.,
    (double)97526./3137161264. * 16384.,
    (double)63978./3137161264. * 16384.,
    (double)97340./3137161264. * 16384.,
    (double)10718./3137161264. * 16384.,
    (double)10326./3137161264. * 16384.,
    (double)8495./3137161264. * 16384.,
    (double)15378./3137161264. * 16384.,
    (double)89802./3137161264. * 16384.,
    (double)9624./3137161264. * 16384.,
    (double)75597./3137161264. * 16384.,
    (double)104722./3137161264. * 16384.,
    (double)70207./3137161264. * 16384.,
    (double)89966./3137161264. * 16384.,
    (double)77767./3137161264. * 16384.,
    (double)111320./3137161264. * 16384.,
    (double)121989./3137161264. * 16384.,
    (double)70393./3137161264. * 16384.,
    (double)54396./3137161264. * 16384.,
    (double)103864./3137161264. * 16384.,
    (double)90847./3137161264. * 16384.,
    (double)70787./3137161264. * 16384.,
    (double)57075./3137161264. * 16384.,
    (double)94037./3137161264. * 16384.,
    (double)86252./3137161264. * 16384.,
    (double)7803./3137161264. * 16384.,
    (double)58092./3137161264. * 16384.,
    (double)100282./3137161264. * 16384.,
    (double)102228./3137161264. * 16384.,
    (double)78840./3137161264. * 16384.,
    (double)89198./3137161264. * 16384.,
    (double)181640./3137161264. * 16384.,
    (double)225350./3137161264. * 16384.,
    (double)166310./3137161264. * 16384.,
    (double)100433./3137161264. * 16384.,
    (double)151502./3137161264. * 16384.,
    (double)177348./3137161264. * 16384.,
    (double)159093./3137161264. * 16384.,
    (double)128797./3137161264. * 16384.,
    (double)129299./3137161264. * 16384.,
    (double)127150./3137161264. * 16384.,
    (double)15566./3137161264. * 16384.,
    (double)109591./3137161264. * 16384.,
    (double)124322./3137161264. * 16384.,
    (double)98448./3137161264. * 16384.,
    (double)112622./3137161264. * 16384.,
    (double)71753./3137161264. * 16384.,
    (double)125588./3137161264. * 16384.,
    (double)214245./3137161264. * 16384.,
    (double)194267./3137161264. * 16384.,
    (double)106000./3137161264. * 16384.,
    (double)127288./3137161264. * 16384.,
    (double)202620./3137161264. * 16384.,
    (double)174422./3137161264. * 16384.,
    (double)176677./3137161264. * 16384.,
    (double)147102./3137161264. * 16384.,
    (double)178913./3137161264. * 16384.,
    (double)23112./3137161264. * 16384.,
    (double)218502./3137161264. * 16384.,
    (double)188193./3137161264. * 16384.,
    (double)88063./3137161264. * 16384.,
    (double)128882./3137161264. * 16384.,
    (double)87362./3137161264. * 16384.,
    (double)112494./3137161264. * 16384.,
    (double)124870./3137161264. * 16384.,
    (double)175415./3137161264. * 16384.,
    (double)100918./3137161264. * 16384.,
    (double)117176./3137161264. * 16384.,
    (double)14722./3137161264. * 16384.,
    (double)24019./3137161264. * 16384.,
    (double)17526./3137161264. * 16384.,
    (double)20134./3137161264. * 16384.,
    (double)154988./3137161264. * 16384.,
    (double)24036./3137161264. * 16384.,
    (double)165237./3137161264. * 16384.,
    (double)205872./3137161264. * 16384.,
    (double)86475./3137161264. * 16384.,
    (double)170936./3137161264. * 16384.,
    (double)131849./3137161264. * 16384.,
    (double)154912./3137161264. * 16384.,
    (double)150169./3137161264. * 16384.,
    (double)103198./3137161264. * 16384.,
    (double)67554./3137161264. * 16384.,
    (double)107376./3137161264. * 16384.,
    (double)147711./3137161264. * 16384.,
    (double)151091./3137161264. * 16384.,
    (double)115219./3137161264. * 16384.,
    (double)153512./3137161264. * 16384.,
    (double)119048./3137161264. * 16384.,
    (double)15315./3137161264. * 16384.,
    (double)112027./3137161264. * 16384.,
    (double)186628./3137161264. * 16384.,
    (double)101143./3137161264. * 16384.,
    (double)108193./3137161264. * 16384.,
    (double)106262./3137161264. * 16384.,
    (double)183823./3137161264. * 16384.,
    (double)204498./3137161264. * 16384.,
    (double)128192./3137161264. * 16384.,
    (double)91498./3137161264. * 16384.,
    (double)113713./3137161264. * 16384.,
    (double)161260./3137161264. * 16384.,
    (double)150563./3137161264. * 16384.,
    (double)158479./3137161264. * 16384.,
    (double)159127./3137161264. * 16384.,
    (double)160076./3137161264. * 16384.,
    (double)21943./3137161264. * 16384.,
    (double)130290./3137161264. * 16384.,
    (double)140427./3137161264. * 16384.,
    (double)106577./3137161264. * 16384.,
    (double)121903./3137161264. * 16384.,
    (double)136321./3137161264. * 16384.,
    (double)168938./3137161264. * 16384.,
    (double)17387./3137161264. * 16384.,
    (double)18098./3137161264. * 16384.,
    (double)13178./3137161264. * 16384.,
    (double)13242./3137161264. * 16384.,
    (double)17882./3137161264. * 16384.,
    (double)25619./3137161264. * 16384.,
    (double)26613./3137161264. * 16384.,
    (double)19645./3137161264. * 16384.,
    (double)16401./3137161264. * 16384.,
    (double)4561./3137161264. * 16384.,
    (double)23582./3137161264. * 16384.,
    (double)20529./3137161264. * 16384.,
    (double)11672./3137161264. * 16384.,
    (double)22740./3137161264. * 16384.,
    (double)18908./3137161264. * 16384.,
    (double)17781./3137161264. * 16384.,
    (double)145071./3137161264. * 16384.,
    (double)177968./3137161264. * 16384.,
    (double)135180./3137161264. * 16384.,
    (double)135552./3137161264. * 16384.,
    (double)17327./3137161264. * 16384.,
    (double)20416./3137161264. * 16384.,
    (double)26960./3137161264. * 16384.,
    (double)22391./3137161264. * 16384.,
    (double)231689./3137161264. * 16384.,
    (double)40413./3137161264. * 16384.,
    (double)176545./3137161264. * 16384.,
    (double)199796./3137161264. * 16384.,
    (double)102606./3137161264. * 16384.,
    (double)186954./3137161264. * 16384.,
    (double)189565./3137161264. * 16384.,
    (double)174606./3137161264. * 16384.,
    (double)111765./3137161264. * 16384.,
    (double)91787./3137161264. * 16384.,
    (double)83445./3137161264. * 16384.,
    (double)97215./3137161264. * 16384.,
    (double)153838./3137161264. * 16384.,
    (double)151508./3137161264. * 16384.,
    (double)171409./3137161264. * 16384.,
    (double)169142./3137161264. * 16384.,
    (double)152141./3137161264. * 16384.,
    (double)18911./3137161264. * 16384.,
    (double)177664./3137161264. * 16384.,
    (double)211950./3137161264. * 16384.,
    (double)108183./3137161264. * 16384.,
    (double)122002./3137161264. * 16384.,
    (double)173599./3137161264. * 16384.,
    (double)207708./3137161264. * 16384.,
    (double)178794./3137161264. * 16384.,
    (double)93712./3137161264. * 16384.,
    (double)73414./3137161264. * 16384.,
    (double)119359./3137161264. * 16384.,
    (double)97423./3137161264. * 16384.,
    (double)76311./3137161264. * 16384.,
    (double)69406./3137161264. * 16384.,
    (double)76400./3137161264. * 16384.,
    (double)101996./3137161264. * 16384.,
    (double)11169./3137161264. * 16384.,
    (double)70313./3137161264. * 16384.,
    (double)89156./3137161264. * 16384.,
    (double)113440./3137161264. * 16384.,
    (double)85087./3137161264. * 16384.,
    (double)85913./3137161264. * 16384.,
    (double)146283./3137161264. * 16384.,
    (double)153270./3137161264. * 16384.,
    (double)113386./3137161264. * 16384.,
    (double)83239./3137161264. * 16384.,
    (double)103793./3137161264. * 16384.,
    (double)120179./3137161264. * 16384.,
    (double)115639./3137161264. * 16384.,
    (double)109136./3137161264. * 16384.,
    (double)102248./3137161264. * 16384.,
    (double)105604./3137161264. * 16384.,
    (double)10878./3137161264. * 16384.,
    (double)108251./3137161264. * 16384.,
    (double)131427./3137161264. * 16384.,
    (double)93671./3137161264. * 16384.,
    (double)106801./3137161264. * 16384.,
    (double)107387./3137161264. * 16384.,
    (double)131859./3137161264. * 16384.,
    (double)144773./3137161264. * 16384.,
    (double)151081./3137161264. * 16384.,
    (double)115204./3137161264. * 16384.,
    (double)151240./3137161264. * 16384.,
    (double)13233./3137161264. * 16384.,
    (double)14733./3137161264. * 16384.,
    (double)13366./3137161264. * 16384.,
    (double)17350./3137161264. * 16384.,
    (double)176219./3137161264. * 16384.,
    (double)19005./3137161264. * 16384.,
    (double)183599./3137161264. * 16384.,
    (double)226678./3137161264. * 16384.,
    (double)125837./3137161264. * 16384.,
    (double)174784./3137161264. * 16384.,
    (double)186250./3137161264. * 16384.,
    (double)202579./3137161264. * 16384.,
    (double)173723./3137161264. * 16384.,
    (double)102369./3137161264. * 16384.,
    (double)96394./3137161264. * 16384.,
    (double)168311./3137161264. * 16384.,
    (double)147424./3137161264. * 16384.,
    (double)131933./3137161264. * 16384.,
    (double)130883./3137161264. * 16384.,
    (double)160037./3137161264. * 16384.,
    (double)173253./3137161264. * 16384.,
    (double)15175./3137161264. * 16384.,
    (double)191139./3137161264. * 16384.,
    (double)252537./3137161264. * 16384.,
    (double)201509./3137161264. * 16384.,
    (double)166450./3137161264. * 16384.,
    (double)228688./3137161264. * 16384.,
    (double)287501./3137161264. * 16384.,
    (double)352209./3137161264. * 16384.,
    (double)185924./3137161264. * 16384.,
    (double)172026./3137161264. * 16384.,
    (double)329801./3137161264. * 16384.,
    (double)174205./3137161264. * 16384.,
    (double)111185./3137161264. * 16384.,
    (double)99268./3137161264. * 16384.,
    (double)132988./3137161264. * 16384.,
    (double)159682./3137161264. * 16384.,
    (double)14353./3137161264. * 16384.,
    (double)76429./3137161264. * 16384.,
    (double)127996./3137161264. * 16384.,
    (double)228019./3137161264. * 16384.,
    (double)175461./3137161264. * 16384.,
    (double)112805./3137161264. * 16384.,
    (double)217000./3137161264. * 16384.,
    (double)192387./3137161264. * 16384.,
    (double)111100./3137161264. * 16384.,
    (double)85190./3137161264. * 16384.,
    (double)114986./3137161264. * 16384.,
    (double)116451./3137161264. * 16384.,
    (double)71143./3137161264. * 16384.,
    (double)73027./3137161264. * 16384.,
    (double)77514./3137161264. * 16384.,
    (double)110444./3137161264. * 16384.,
    (double)9203./3137161264. * 16384.,
    (double)71279./3137161264. * 16384.,
    (double)83384./3137161264. * 16384.,
    (double)108008./3137161264. * 16384.,
    (double)110658./3137161264. * 16384.,
    (double)73692./3137161264. * 16384.,
    (double)112002./3137161264. * 16384.,
    (double)129472./3137161264. * 16384.,
    (double)99383./3137161264. * 16384.,
    (double)84759./3137161264. * 16384.,
    (double)128781./3137161264. * 16384.,
    (double)12302./3137161264. * 16384.,
    (double)9201./3137161264. * 16384.,
    (double)8645./3137161264. * 16384.,
    (double)16059./3137161264. * 16384.,
    (double)80790./3137161264. * 16384.,
    (double)6777./3137161264. * 16384.,
    (double)56425./3137161264. * 16384.,
    (double)76085./3137161264. * 16384.,
    (double)74287./3137161264. * 16384.,
    (double)83100./3137161264. * 16384.,
    (double)78033./3137161264. * 16384.,
    (double)116929./3137161264. * 16384.,
    (double)182232./3137161264. * 16384.,
    (double)88800./3137161264. * 16384.,
    (double)101864./3137161264. * 16384.,
    (double)176146./3137161264. * 16384.,
    (double)131944./3137161264. * 16384.,
    (double)84902./3137161264. * 16384.,
    (double)76744./3137161264. * 16384.,
    (double)118982./3137161264. * 16384.,
    (double)105362./3137161264. * 16384.,
    (double)8563./3137161264. * 16384.,
    (double)69080./3137161264. * 16384.,
    (double)109387./3137161264. * 16384.,
    (double)150862./3137161264. * 16384.,
    (double)96138./3137161264. * 16384.,
    (double)115264./3137161264. * 16384.,
    (double)274718./3137161264. * 16384.,
    (double)248117./3137161264. * 16384.,
    (double)137493./3137161264. * 16384.,
    (double)95868./3137161264. * 16384.,
    (double)158812./3137161264. * 16384.,
    (double)137635./3137161264. * 16384.,
    (double)91422./3137161264. * 16384.,
    (double)69336./3137161264. * 16384.,
    (double)86224./3137161264. * 16384.,
    (double)97063./3137161264. * 16384.,
    (double)9339./3137161264. * 16384.,
    (double)53904./3137161264. * 16384.,
    (double)83889./3137161264. * 16384.,
    (double)100165./3137161264. * 16384.,
    (double)89379./3137161264. * 16384.,
    (double)59327./3137161264. * 16384.,
    (double)115038./3137161264. * 16384.,
    (double)148163./3137161264. * 16384.,
    (double)98094./3137161264. * 16384.,
    (double)61507./3137161264. * 16384.,
    (double)84468./3137161264. * 16384.,
    (double)92779./3137161264. * 16384.,
    (double)57231./3137161264. * 16384.,
    (double)54328./3137161264. * 16384.,
    (double)57562./3137161264. * 16384.,
    (double)92805./3137161264. * 16384.,
    (double)8312./3137161264. * 16384.,
    (double)56272./3137161264. * 16384.,
    (double)82083./3137161264. * 16384.,
    (double)78032./3137161264. * 16384.,
    (double)73364./3137161264. * 16384.,
    (double)52269./3137161264. * 16384.,
    (double)81212./3137161264. * 16384.,
    (double)96464./3137161264. * 16384.,
    (double)80561./3137161264. * 16384.,
    (double)64974./3137161264. * 16384.,
    (double)83694./3137161264. * 16384.,
    (double)7414./3137161264. * 16384.,
    (double)7432./3137161264. * 16384.,
    (double)5707./3137161264. * 16384.,
    (double)8381./3137161264. * 16384.,
    (double)86846./3137161264. * 16384.,
    (double)7647./3137161264. * 16384.,
    (double)50707./3137161264. * 16384.,
    (double)83133./3137161264. * 16384.,
    (double)73022./3137161264. * 16384.,
    (double)81896./3137161264. * 16384.,
    (double)65728./3137161264. * 16384.,
    (double)86371./3137161264. * 16384.,
    (double)90695./3137161264. * 16384.,
    (double)57723./3137161264. * 16384.,
    (double)43649./3137161264. * 16384.,
    (double)78458./3137161264. * 16384.,
    (double)81129./3137161264. * 16384.,
    (double)66888./3137161264. * 16384.,
    (double)46276./3137161264. * 16384.,
    (double)70611./3137161264. * 16384.,
    (double)73320./3137161264. * 16384.,
    (double)5522./3137161264. * 16384.,
    (double)49496./3137161264. * 16384.,
    (double)84533./3137161264. * 16384.,
    (double)81060./3137161264. * 16384.,
    (double)64529./3137161264. * 16384.,
    (double)71031./3137161264. * 16384.,
    (double)140331./3137161264. * 16384.,
    (double)209380./3137161264. * 16384.,
    (double)91251./3137161264. * 16384.,
    (double)75499./3137161264. * 16384.,
    (double)114176./3137161264. * 16384.,
    (double)144967./3137161264. * 16384.,
    (double)90637./3137161264. * 16384.,
    (double)79990./3137161264. * 16384.,
    (double)104644./3137161264. * 16384.,
    (double)121592./3137161264. * 16384.,
    (double)13683./3137161264. * 16384.,
    (double)50679./3137161264. * 16384.,
    (double)86590./3137161264. * 16384.,
    (double)122351./3137161264. * 16384.,
    (double)100718./3137161264. * 16384.,
    (double)74532./3137161264. * 16384.,
    (double)147516./3137161264. * 16384.,
    (double)15129./3137161264. * 16384.,
    (double)10356./3137161264. * 16384.,
    (double)7198./3137161264. * 16384.,
    (double)10952./3137161264. * 16384.,
    (double)12101./3137161264. * 16384.,
    (double)9386./3137161264. * 16384.,
    (double)8226./3137161264. * 16384.,
    (double)9808./3137161264. * 16384.,
    (double)11244./3137161264. * 16384.,
    (double)1852./3137161264. * 16384.,
    (double)8159./3137161264. * 16384.,
    (double)10622./3137161264. * 16384.,
    (double)15942./3137161264. * 16384.,
    (double)19738./3137161264. * 16384.,
    (double)10489./3137161264. * 16384.,
    (double)17620./3137161264. * 16384.,
    (double)101050./3137161264. * 16384.,
    (double)77605./3137161264. * 16384.,
    (double)81561./3137161264. * 16384.,
    (double)99872./3137161264. * 16384.,
    (double)9180./3137161264. * 16384.,
    (double)7207./3137161264. * 16384.,
    (double)8842./3137161264. * 16384.,
    (double)11565./3137161264. * 16384.,
    (double)89819./3137161264. * 16384.,
    (double)10167./3137161264. * 16384.,
    (double)58247./3137161264. * 16384.,
    (double)78859./3137161264. * 16384.,
    (double)76844./3137161264. * 16384.,
    (double)91748./3137161264. * 16384.,
    (double)91320./3137161264. * 16384.,
    (double)106436./3137161264. * 16384.,
    (double)101651./3137161264. * 16384.,
    (double)63239./3137161264. * 16384.,
    (double)62055./3137161264. * 16384.,
    (double)98101./3137161264. * 16384.,
    (double)107538./3137161264. * 16384.,
    (double)82416./3137161264. * 16384.,
    (double)78517./3137161264. * 16384.,
    (double)106253./3137161264. * 16384.,
    (double)111680./3137161264. * 16384.,
    (double)17844./3137161264. * 16384.,
    (double)71930./3137161264. * 16384.,
    (double)113636./3137161264. * 16384.,
    (double)105787./3137161264. * 16384.,
    (double)100372./3137161264. * 16384.,
    (double)106312./3137161264. * 16384.,
    (double)176631./3137161264. * 16384.,
    (double)248933./3137161264. * 16384.,
    (double)91541./3137161264. * 16384.,
    (double)78975./3137161264. * 16384.,
    (double)167318./3137161264. * 16384.,
    (double)106257./3137161264. * 16384.,
    (double)63616./3137161264. * 16384.,
    (double)63165./3137161264. * 16384.,
    (double)90087./3137161264. * 16384.,
    (double)111165./3137161264. * 16384.,
    (double)9819./3137161264. * 16384.,
    (double)55711./3137161264. * 16384.,
    (double)89414./3137161264. * 16384.,
    (double)173113./3137161264. * 16384.,
    (double)107948./3137161264. * 16384.,
    (double)84818./3137161264. * 16384.,
    (double)186732./3137161264. * 16384.,
    (double)157777./3137161264. * 16384.,
    (double)96239./3137161264. * 16384.,
    (double)69815./3137161264. * 16384.,
    (double)104062./3137161264. * 16384.,
    (double)94778./3137161264. * 16384.,
    (double)68200./3137161264. * 16384.,
    (double)63193./3137161264. * 16384.,
    (double)74242./3137161264. * 16384.,
    (double)98389./3137161264. * 16384.,
    (double)7946./3137161264. * 16384.,
    (double)64844./3137161264. * 16384.,
    (double)95258./3137161264. * 16384.,
    (double)119600./3137161264. * 16384.,
    (double)124585./3137161264. * 16384.,
    (double)78792./3137161264. * 16384.,
    (double)141353./3137161264. * 16384.,
    (double)106686./3137161264. * 16384.,
    (double)84381./3137161264. * 16384.,
    (double)77465./3137161264. * 16384.,
    (double)109688./3137161264. * 16384.,
    (double)8105./3137161264. * 16384.,
    (double)6624./3137161264. * 16384.,
    (double)7553./3137161264. * 16384.,
    (double)10173./3137161264. * 16384.,
    (double)83779./3137161264. * 16384.,
    (double)6557./3137161264. * 16384.,
    (double)60387./3137161264. * 16384.,
    (double)83617./3137161264. * 16384.,
    (double)92598./3137161264. * 16384.,
    (double)94804./3137161264. * 16384.,
    (double)102523./3137161264. * 16384.,
    (double)127604./3137161264. * 16384.,
    (double)167211./3137161264. * 16384.,
    (double)87454./3137161264. * 16384.,
    (double)86390./3137161264. * 16384.,
    (double)180590./3137161264. * 16384.,
    (double)101577./3137161264. * 16384.,
    (double)70763./3137161264. * 16384.,
    (double)74444./3137161264. * 16384.,
    (double)115992./3137161264. * 16384.,
    (double)134733./3137161264. * 16384.,
    (double)11151./3137161264. * 16384.,
    (double)95706./3137161264. * 16384.,
    (double)159211./3137161264. * 16384.,
    (double)196194./3137161264. * 16384.,
    (double)150930./3137161264. * 16384.,
    (double)182769./3137161264. * 16384.,
    (double)360155./3137161264. * 16384.,
    (double)349770./3137161264. * 16384.,
    (double)209966./3137161264. * 16384.,
    (double)163361./3137161264. * 16384.,
    (double)277242./3137161264. * 16384.,
    (double)207953./3137161264. * 16384.,
    (double)159819./3137161264. * 16384.,
    (double)135663./3137161264. * 16384.,
    (double)162075./3137161264. * 16384.,
    (double)150537./3137161264. * 16384.,
    (double)16503./3137161264. * 16384.,
    (double)83863./3137161264. * 16384.,
    (double)138372./3137161264. * 16384.,
    (double)183232./3137161264. * 16384.,
    (double)165842./3137161264. * 16384.,
    (double)116905./3137161264. * 16384.,
    (double)216173./3137161264. * 16384.,
    (double)251191./3137161264. * 16384.,
    (double)171318./3137161264. * 16384.,
    (double)133923./3137161264. * 16384.,
    (double)171025./3137161264. * 16384.,
    (double)180489./3137161264. * 16384.,
    (double)134978./3137161264. * 16384.,
    (double)188975./3137161264. * 16384.,
    (double)154832./3137161264. * 16384.,
    (double)155723./3137161264. * 16384.,
    (double)18637./3137161264. * 16384.,
    (double)132902./3137161264. * 16384.,
    (double)151190./3137161264. * 16384.,
    (double)119228./3137161264. * 16384.,
    (double)133814./3137161264. * 16384.,
    (double)112415./3137161264. * 16384.,
    (double)151657./3137161264. * 16384.,
    (double)136462./3137161264. * 16384.,
    (double)120855./3137161264. * 16384.,
    (double)101079./3137161264. * 16384.,
    (double)136162./3137161264. * 16384.,
    (double)12665./3137161264. * 16384.,
    (double)14058./3137161264. * 16384.,
    (double)12699./3137161264. * 16384.,
    (double)18179./3137161264. * 16384.,
    (double)105754./3137161264. * 16384.,
    (double)12363./3137161264. * 16384.,
    (double)87996./3137161264. * 16384.,
    (double)119438./3137161264. * 16384.,
    (double)77350./3137161264. * 16384.,
    (double)110561./3137161264. * 16384.,
    (double)107291./3137161264. * 16384.,
    (double)155105./3137161264. * 16384.,
    (double)150559./3137161264. * 16384.,
    (double)82335./3137161264. * 16384.,
    (double)80760./3137161264. * 16384.,
    (double)129718./3137161264. * 16384.,
    (double)145020./3137161264. * 16384.,
    (double)114511./3137161264. * 16384.,
    (double)93734./3137161264. * 16384.,
    (double)126732./3137161264. * 16384.,
    (double)94278./3137161264. * 16384.,
    (double)9060./3137161264. * 16384.,
    (double)69416./3137161264. * 16384.,
    (double)113198./3137161264. * 16384.,
    (double)119387./3137161264. * 16384.,
    (double)95679./3137161264. * 16384.,
    (double)116221./3137161264. * 16384.,
    (double)231478./3137161264. * 16384.,
    (double)267762./3137161264. * 16384.,
    (double)193079./3137161264. * 16384.,
    (double)113748./3137161264. * 16384.,
    (double)172279./3137161264. * 16384.,
    (double)199774./3137161264. * 16384.,
    (double)174793./3137161264. * 16384.,
    (double)122362./3137161264. * 16384.,
    (double)135186./3137161264. * 16384.,
    (double)128622./3137161264. * 16384.,
    (double)16410./3137161264. * 16384.,
    (double)75653./3137161264. * 16384.,
    (double)107155./3137161264. * 16384.,
    (double)118792./3137161264. * 16384.,
    (double)124293./3137161264. * 16384.,
    (double)78824./3137161264. * 16384.,
    (double)139570./3137161264. * 16384.,
    (double)219260./3137161264. * 16384.,
    (double)193848./3137161264. * 16384.,
    (double)112200./3137161264. * 16384.,
    (double)142180./3137161264. * 16384.,
    (double)193185./3137161264. * 16384.,
    (double)125192./3137161264. * 16384.,
    (double)131718./3137161264. * 16384.,
    (double)120329./3137161264. * 16384.,
    (double)180160./3137161264. * 16384.,
    (double)30475./3137161264. * 16384.,
    (double)124195./3137161264. * 16384.,
    (double)156976./3137161264. * 16384.,
    (double)110325./3137161264. * 16384.,
    (double)148875./3137161264. * 16384.,
    (double)98493./3137161264. * 16384.,
    (double)123461./3137161264. * 16384.,
    (double)125017./3137161264. * 16384.,
    (double)145209./3137161264. * 16384.,
    (double)100990./3137161264. * 16384.,
    (double)124311./3137161264. * 16384.,
    (double)14044./3137161264. * 16384.,
    (double)18632./3137161264. * 16384.,
    (double)13108./3137161264. * 16384.,
    (double)14875./3137161264. * 16384.,
    (double)165157./3137161264. * 16384.,
    (double)25650./3137161264. * 16384.,
    (double)121115./3137161264. * 16384.,
    (double)174946./3137161264. * 16384.,
    (double)94903./3137161264. * 16384.,
    (double)164280./3137161264. * 16384.,
    (double)122384./3137161264. * 16384.,
    (double)164650./3137161264. * 16384.,
    (double)97916./3137161264. * 16384.,
    (double)74129./3137161264. * 16384.,
    (double)57204./3137161264. * 16384.,
    (double)89775./3137161264. * 16384.,
    (double)116507./3137161264. * 16384.,
    (double)114608./3137161264. * 16384.,
    (double)77158./3137161264. * 16384.,
    (double)101665./3137161264. * 16384.,
    (double)91784./3137161264. * 16384.,
    (double)9933./3137161264. * 16384.,
    (double)73883./3137161264. * 16384.,
    (double)131279./3137161264. * 16384.,
    (double)86357./3137161264. * 16384.,
    (double)86446./3137161264. * 16384.,
    (double)92357./3137161264. * 16384.,
    (double)160826./3137161264. * 16384.,
    (double)187824./3137161264. * 16384.,
    (double)114194./3137161264. * 16384.,
    (double)85718./3137161264. * 16384.,
    (double)123074./3137161264. * 16384.,
    (double)177505./3137161264. * 16384.,
    (double)155703./3137161264. * 16384.,
    (double)147556./3137161264. * 16384.,
    (double)143485./3137161264. * 16384.,
    (double)142603./3137161264. * 16384.,
    (double)21897./3137161264. * 16384.,
    (double)101735./3137161264. * 16384.,
    (double)134660./3137161264. * 16384.,
    (double)110834./3137161264. * 16384.,
    (double)120519./3137161264. * 16384.,
    (double)103238./3137161264. * 16384.,
    (double)169952./3137161264. * 16384.,
    (double)13025./3137161264. * 16384.,
    (double)15610./3137161264. * 16384.,
    (double)9166./3137161264. * 16384.,
    (double)13192./3137161264. * 16384.,
    (double)16700./3137161264. * 16384.,
    (double)22520./3137161264. * 16384.,
    (double)19766./3137161264. * 16384.,
    (double)15909./3137161264. * 16384.,
    (double)13983./3137161264. * 16384.,
    (double)5358./3137161264. * 16384.,
    (double)28671./3137161264. * 16384.,
    (double)17943./3137161264. * 16384.,
    (double)12294./3137161264. * 16384.,
    (double)23871./3137161264. * 16384.,
    (double)15404./3137161264. * 16384.,
    (double)18242./3137161264. * 16384.,
    (double)122920./3137161264. * 16384.,
    (double)134998./3137161264. * 16384.,
    (double)120516./3137161264. * 16384.,
    (double)138286./3137161264. * 16384.,
    (double)14191./3137161264. * 16384.,
    (double)18606./3137161264. * 16384.,
    (double)19106./3137161264. * 16384.,
    (double)19015./3137161264. * 16384.,
    (double)142044./3137161264. * 16384.,
    (double)26052./3137161264. * 16384.,
    (double)122235./3137161264. * 16384.,
    (double)152719./3137161264. * 16384.,
    (double)93790./3137161264. * 16384.,
    (double)173533./3137161264. * 16384.,
    (double)172942./3137161264. * 16384.,
    (double)182137./3137161264. * 16384.,
    (double)106214./3137161264. * 16384.,
    (double)74457./3137161264. * 16384.,
    (double)74264./3137161264. * 16384.,
    (double)118285./3137161264. * 16384.,
    (double)144961./3137161264. * 16384.,
    (double)146538./3137161264. * 16384.,
    (double)149014./3137161264. * 16384.,
    (double)167163./3137161264. * 16384.,
    (double)130148./3137161264. * 16384.,
    (double)16248./3137161264. * 16384.,
    (double)124299./3137161264. * 16384.,
    (double)170917./3137161264. * 16384.,
    (double)107818./3137161264. * 16384.,
    (double)118785./3137161264. * 16384.,
    (double)160570./3137161264. * 16384.,
    (double)233622./3137161264. * 16384.,
    (double)199556./3137161264. * 16384.,
    (double)113624./3137161264. * 16384.,
    (double)93074./3137161264. * 16384.,
    (double)173067./3137161264. * 16384.,
    (double)108870./3137161264. * 16384.,
    (double)84856./3137161264. * 16384.,
    (double)81056./3137161264. * 16384.,
    (double)110739./3137161264. * 16384.,
    (double)112303./3137161264. * 16384.,
    (double)10931./3137161264. * 16384.,
    (double)70749./3137161264. * 16384.,
    (double)105744./3137161264. * 16384.,
    (double)127689./3137161264. * 16384.,
    (double)106641./3137161264. * 16384.,
    (double)100880./3137161264. * 16384.,
    (double)187473./3137161264. * 16384.,
    (double)191704./3137161264. * 16384.,
    (double)153406./3137161264. * 16384.,
    (double)107944./3137161264. * 16384.,
    (double)148605./3137161264. * 16384.,
    (double)143248./3137161264. * 16384.,
    (double)142597./3137161264. * 16384.,
    (double)127322./3137161264. * 16384.,
    (double)140344./3137161264. * 16384.,
    (double)134981./3137161264. * 16384.,
    (double)16561./3137161264. * 16384.,
    (double)138333./3137161264. * 16384.,
    (double)168151./3137161264. * 16384.,
    (double)128831./3137161264. * 16384.,
    (double)182565./3137161264. * 16384.,
    (double)138659./3137161264. * 16384.,
    (double)191873./3137161264. * 16384.,
    (double)109784./3137161264. * 16384.,
    (double)114222./3137161264. * 16384.,
    (double)112255./3137161264. * 16384.,
    (double)137379./3137161264. * 16384.,
    (double)9668./3137161264. * 16384.,
    (double)11804./3137161264. * 16384.,
    (double)12689./3137161264. * 16384.,
    (double)13709./3137161264. * 16384.,
    (double)106282./3137161264. * 16384.,
    (double)12094./3137161264. * 16384.,
    (double)107357./3137161264. * 16384.,
    (double)139883./3137161264. * 16384.,
    (double)94810./3137161264. * 16384.,
    (double)136387./3137161264. * 16384.,
    (double)201885./3137161264. * 16384.,
    (double)195911./3137161264. * 16384.,
    (double)135733./3137161264. * 16384.,
    (double)88280./3137161264. * 16384.,
    (double)86522./3137161264. * 16384.,
    (double)135663./3137161264. * 16384.,
    (double)117176./3137161264. * 16384.,
    (double)103516./3137161264. * 16384.,
    (double)91737./3137161264. * 16384.,
    (double)127702./3137161264. * 16384.,
    (double)122574./3137161264. * 16384.,
    (double)11109./3137161264. * 16384.,
    (double)114485./3137161264. * 16384.,
    (double)183716./3137161264. * 16384.,
    (double)158389./3137161264. * 16384.,
    (double)144188./3137161264. * 16384.,
    (double)195899./3137161264. * 16384.,
    (double)313796./3137161264. * 16384.,
    (double)316875./3137161264. * 16384.,
    (double)166454./3137161264. * 16384.,
    (double)137559./3137161264. * 16384.,
    (double)198326./3137161264. * 16384.,
    (double)133890./3137161264. * 16384.,
    (double)112157./3137161264. * 16384.,
    (double)82196./3137161264. * 16384.,
    (double)109360./3137161264. * 16384.,
    (double)133315./3137161264. * 16384.,
    (double)12384./3137161264. * 16384.,
    (double)79690./3137161264. * 16384.,
    (double)104478./3137161264. * 16384.,
    (double)143554./3137161264. * 16384.,
    (double)101531./3137161264. * 16384.,
    (double)73955./3137161264. * 16384.,
    (double)132821./3137161264. * 16384.,
    (double)213553./3137161264. * 16384.,
    (double)166968./3137161264. * 16384.,
    (double)91475./3137161264. * 16384.,
    (double)125012./3137161264. * 16384.,
    (double)162798./3137161264. * 16384.,
    (double)125868./3137161264. * 16384.,
    (double)105734./3137161264. * 16384.,
    (double)103270./3137161264. * 16384.,
    (double)160735./3137161264. * 16384.,
    (double)18595./3137161264. * 16384.,
    (double)163082./3137161264. * 16384.,
    (double)148643./3137161264. * 16384.,
    (double)114285./3137161264. * 16384.,
    (double)140050./3137161264. * 16384.,
    (double)101203./3137161264. * 16384.,
    (double)142926./3137161264. * 16384.,
    (double)130280./3137161264. * 16384.,
    (double)154842./3137161264. * 16384.,
    (double)102893./3137161264. * 16384.,
    (double)131867./3137161264. * 16384.,
    (double)15197./3137161264. * 16384.,
    (double)19157./3137161264. * 16384.,
    (double)15095./3137161264. * 16384.,
    (double)21182./3137161264. * 16384.,
    (double)120605./3137161264. * 16384.,
    (double)16733./3137161264. * 16384.,
    (double)96184./3137161264. * 16384.,
    (double)118932./3137161264. * 16384.,
    (double)87648./3137161264. * 16384.,
    (double)156333./3137161264. * 16384.,
    (double)127370./3137161264. * 16384.,
    (double)145173./3137161264. * 16384.,
    (double)126257./3137161264. * 16384.,
    (double)86118./3137161264. * 16384.,
    (double)67024./3137161264. * 16384.,
    (double)120643./3137161264. * 16384.,
    (double)122430./3137161264. * 16384.,
    (double)110326./3137161264. * 16384.,
    (double)83011./3137161264. * 16384.,
    (double)116684./3137161264. * 16384.,
    (double)125132./3137161264. * 16384.,
    (double)13160./3137161264. * 16384.,
    (double)98456./3137161264. * 16384.,
    (double)163869./3137161264. * 16384.,
    (double)133808./3137161264. * 16384.,
    (double)109919./3137161264. * 16384.,
    (double)143987./3137161264. * 16384.,
    (double)259881./3137161264. * 16384.,
    (double)18502./3137161264. * 16384.,
    (double)14462./3137161264. * 16384.,
    (double)20496./3137161264. * 16384.,
    (double)14939./3137161264. * 16384.,
    (double)14281./3137161264. * 16384.,
    (double)15044./3137161264. * 16384.,
    (double)10938./3137161264. * 16384.,
    (double)11473./3137161264. * 16384.,
    (double)10420./3137161264. * 16384.,
    (double)1859./3137161264. * 16384.,
    (double)12142./3137161264. * 16384.,
    (double)10624./3137161264. * 16384.,
    (double)9705./3137161264. * 16384.,
    (double)11753./3137161264. * 16384.,
    (double)8978./3137161264. * 16384.,
    (double)12697./3137161264. * 16384.,
    (double)15969./3137161264. * 16384.,
    (double)17552./3137161264. * 16384.,
    (double)8902./3137161264. * 16384.,
    (double)9674./3137161264. * 16384.,
    (double)25276./3137161264. * 16384.,
    (double)21051./3137161264. * 16384.,
    (double)15346./3137161264. * 16384.,
    (double)13119./3137161264. * 16384.,
    (double)16257./3137161264. * 16384.,
    (double)4790./3137161264. * 16384.,
    (double)28568./3137161264. * 16384.,
    (double)18912./3137161264. * 16384.,
    (double)9923./3137161264. * 16384.,
    (double)16870./3137161264. * 16384.,
    (double)12494./3137161264. * 16384.,
    (double)12644./3137161264. * 16384.,
    (double)8786./3137161264. * 16384.,
    (double)14233./3137161264. * 16384.,
    (double)9324./3137161264. * 16384.,
    (double)9602./3137161264. * 16384.,
    (double)1992./3137161264. * 16384.,
    (double)3772./3137161264. * 16384.,
    (double)3450./3137161264. * 16384.,
    (double)2082./3137161264. * 16384.,
    (double)14158./3137161264. * 16384.,
    (double)4071./3137161264. * 16384.,
    (double)16554./3137161264. * 16384.,
    (double)16679./3137161264. * 16384.,
    (double)8569./3137161264. * 16384.,
    (double)20868./3137161264. * 16384.,
    (double)22185./3137161264. * 16384.,
    (double)16247./3137161264. * 16384.,
    (double)11307./3137161264. * 16384.,
    (double)9018./3137161264. * 16384.,
    (double)6503./3137161264. * 16384.,
    (double)11082./3137161264. * 16384.,
    (double)16924./3137161264. * 16384.,
    (double)18016./3137161264. * 16384.,
    (double)13048./3137161264. * 16384.,
    (double)15754./3137161264. * 16384.,
    (double)11871./3137161264. * 16384.,
    (double)2356./3137161264. * 16384.,
    (double)12110./3137161264. * 16384.,
    (double)19661./3137161264. * 16384.,
    (double)11364./3137161264. * 16384.,
    (double)11757./3137161264. * 16384.,
    (double)14076./3137161264. * 16384.,
    (double)21341./3137161264. * 16384.,
    (double)195033./3137161264. * 16384.,
    (double)122232./3137161264. * 16384.,
    (double)92104./3137161264. * 16384.,
    (double)94585./3137161264. * 16384.,
    (double)153642./3137161264. * 16384.,
    (double)149547./3137161264. * 16384.,
    (double)170130./3137161264. * 16384.,
    (double)115005./3137161264. * 16384.,
    (double)126700./3137161264. * 16384.,
    (double)23458./3137161264. * 16384.,
    (double)127046./3137161264. * 16384.,
    (double)117199./3137161264. * 16384.,
    (double)93359./3137161264. * 16384.,
    (double)120251./3137161264. * 16384.,
    (double)133230./3137161264. * 16384.,
    (double)144002./3137161264. * 16384.,
    (double)14188./3137161264. * 16384.,
    (double)16607./3137161264. * 16384.,
    (double)9797./3137161264. * 16384.,
    (double)9114./3137161264. * 16384.,
    (double)15049./3137161264. * 16384.,
    (double)17565./3137161264. * 16384.,
    (double)15195./3137161264. * 16384.,
    (double)9649./3137161264. * 16384.,
    (double)14378./3137161264. * 16384.,
    (double)4954./3137161264. * 16384.,
    (double)30342./3137161264. * 16384.,
    (double)15487./3137161264. * 16384.,
    (double)11903./3137161264. * 16384.,
    (double)22165./3137161264. * 16384.,
    (double)25702./3137161264. * 16384.,
    (double)15655./3137161264. * 16384.,
    (double)143906./3137161264. * 16384.,
    (double)160813./3137161264. * 16384.,
    (double)144400./3137161264. * 16384.,
    (double)121755./3137161264. * 16384.,
    (double)17866./3137161264. * 16384.,
    (double)22691./3137161264. * 16384.,
    (double)23749./3137161264. * 16384.,
    (double)16910./3137161264. * 16384.,
    (double)163109./3137161264. * 16384.,
    (double)27007./3137161264. * 16384.,
    (double)91451./3137161264. * 16384.,
    (double)128515./3137161264. * 16384.,
    (double)83220./3137161264. * 16384.,
    (double)151641./3137161264. * 16384.,
    (double)155804./3137161264. * 16384.,
    (double)141350./3137161264. * 16384.,
    (double)104143./3137161264. * 16384.,
    (double)84291./3137161264. * 16384.,
    (double)75677./3137161264. * 16384.,
    (double)87592./3137161264. * 16384.,
    (double)136283./3137161264. * 16384.,
    (double)147289./3137161264. * 16384.,
    (double)142671./3137161264. * 16384.,
    (double)124363./3137161264. * 16384.,
    (double)135669./3137161264. * 16384.,
    (double)19788./3137161264. * 16384.,
    (double)166371./3137161264. * 16384.,
    (double)173873./3137161264. * 16384.,
    (double)99170./3137161264. * 16384.,
    (double)120007./3137161264. * 16384.,
    (double)156554./3137161264. * 16384.,
    (double)193263./3137161264. * 16384.,
    (double)174979./3137161264. * 16384.,
    (double)102445./3137161264. * 16384.,
    (double)71705./3137161264. * 16384.,
    (double)113484./3137161264. * 16384.,
    (double)101905./3137161264. * 16384.,
    (double)81235./3137161264. * 16384.,
    (double)70463./3137161264. * 16384.,
    (double)75202./3137161264. * 16384.,
    (double)110460./3137161264. * 16384.,
    (double)12003./3137161264. * 16384.,
    (double)84703./3137161264. * 16384.,
    (double)108423./3137161264. * 16384.,
    (double)100077./3137161264. * 16384.,
    (double)91265./3137161264. * 16384.,
    (double)80662./3137161264. * 16384.,
    (double)140679./3137161264. * 16384.,
    (double)183250./3137161264. * 16384.,
    (double)154390./3137161264. * 16384.,
    (double)96737./3137161264. * 16384.,
    (double)124559./3137161264. * 16384.,
    (double)142208./3137161264. * 16384.,
    (double)144645./3137161264. * 16384.,
    (double)108001./3137161264. * 16384.,
    (double)99159./3137161264. * 16384.,
    (double)147383./3137161264. * 16384.,
    (double)17279./3137161264. * 16384.,
    (double)171485./3137161264. * 16384.,
    (double)172182./3137161264. * 16384.,
    (double)124250./3137161264. * 16384.,
    (double)178026./3137161264. * 16384.,
    (double)152453./3137161264. * 16384.,
    (double)163159./3137161264. * 16384.,
    (double)132672./3137161264. * 16384.,
    (double)142944./3137161264. * 16384.,
    (double)109523./3137161264. * 16384.,
    (double)132957./3137161264. * 16384.,
    (double)11710./3137161264. * 16384.,
    (double)15876./3137161264. * 16384.,
    (double)13073./3137161264. * 16384.,
    (double)14021./3137161264. * 16384.,
    (double)154104./3137161264. * 16384.,
    (double)16941./3137161264. * 16384.,
    (double)146200./3137161264. * 16384.,
    (double)175719./3137161264. * 16384.,
    (double)115862./3137161264. * 16384.,
    (double)194215./3137161264. * 16384.,
    (double)219071./3137161264. * 16384.,
    (double)201496./3137161264. * 16384.,
    (double)147936./3137161264. * 16384.,
    (double)92845./3137161264. * 16384.,
    (double)85920./3137161264. * 16384.,
    (double)118777./3137161264. * 16384.,
    (double)116264./3137161264. * 16384.,
    (double)112295./3137161264. * 16384.,
    (double)102411./3137161264. * 16384.,
    (double)113299./3137161264. * 16384.,
    (double)162677./3137161264. * 16384.,
    (double)15028./3137161264. * 16384.,
    (double)177777./3137161264. * 16384.,
    (double)219096./3137161264. * 16384.,
    (double)166093./3137161264. * 16384.,
    (double)166263./3137161264. * 16384.,
    (double)205493./3137161264. * 16384.,
    (double)279002./3137161264. * 16384.,
    (double)344843./3137161264. * 16384.,
    (double)150747./3137161264. * 16384.,
    (double)106472./3137161264. * 16384.,
    (double)212428./3137161264. * 16384.,
    (double)124939./3137161264. * 16384.,
    (double)81878./3137161264. * 16384.,
    (double)64140./3137161264. * 16384.,
    (double)99498./3137161264. * 16384.,
    (double)124738./3137161264. * 16384.,
    (double)11818./3137161264. * 16384.,
    (double)65119./3137161264. * 16384.,
    (double)104042./3137161264. * 16384.,
    (double)158237./3137161264. * 16384.,
    (double)112192./3137161264. * 16384.,
    (double)80892./3137161264. * 16384.,
    (double)181887./3137161264. * 16384.,
    (double)169415./3137161264. * 16384.,
    (double)96956./3137161264. * 16384.,
    (double)54518./3137161264. * 16384.,
    (double)89538./3137161264. * 16384.,
    (double)100908./3137161264. * 16384.,
    (double)63677./3137161264. * 16384.,
    (double)52947./3137161264. * 16384.,
    (double)69378./3137161264. * 16384.,
    (double)104571./3137161264. * 16384.,
    (double)8419./3137161264. * 16384.,
    (double)62573./3137161264. * 16384.,
    (double)87301./3137161264. * 16384.,
    (double)82889./3137161264. * 16384.,
    (double)74836./3137161264. * 16384.,
    (double)58937./3137161264. * 16384.,
    (double)98080./3137161264. * 16384.,
    (double)128202./3137161264. * 16384.,
    (double)106834./3137161264. * 16384.,
    (double)70433./3137161264. * 16384.,
    (double)133686./3137161264. * 16384.,
    (double)12384./3137161264. * 16384.,
    (double)11364./3137161264. * 16384.,
    (double)7741./3137161264. * 16384.,
    (double)18363./3137161264. * 16384.,
    (double)88058./3137161264. * 16384.,
    (double)8381./3137161264. * 16384.,
    (double)56127./3137161264. * 16384.,
    (double)95167./3137161264. * 16384.,
    (double)87212./3137161264. * 16384.,
    (double)98329./3137161264. * 16384.,
    (double)76901./3137161264. * 16384.,
    (double)122496./3137161264. * 16384.,
    (double)162416./3137161264. * 16384.,
    (double)79465./3137161264. * 16384.,
    (double)70804./3137161264. * 16384.,
    (double)151047./3137161264. * 16384.,
    (double)102944./3137161264. * 16384.,
    (double)69123./3137161264. * 16384.,
    (double)60396./3137161264. * 16384.,
    (double)108778./3137161264. * 16384.,
    (double)102781./3137161264. * 16384.,
    (double)7725./3137161264. * 16384.,
    (double)66318./3137161264. * 16384.,
    (double)126121./3137161264. * 16384.,
    (double)144895./3137161264. * 16384.,
    (double)97883./3137161264. * 16384.,
    (double)122176./3137161264. * 16384.,
    (double)290842./3137161264. * 16384.,
    (double)211106./3137161264. * 16384.,
    (double)124778./3137161264. * 16384.,
    (double)102157./3137161264. * 16384.,
    (double)141244./3137161264. * 16384.,
    (double)124362./3137161264. * 16384.,
    (double)97759./3137161264. * 16384.,
    (double)77381./3137161264. * 16384.,
    (double)91815./3137161264. * 16384.,
    (double)95165./3137161264. * 16384.,
    (double)9296./3137161264. * 16384.,
    (double)67630./3137161264. * 16384.,
    (double)94183./3137161264. * 16384.,
    (double)98150./3137161264. * 16384.,
    (double)90806./3137161264. * 16384.,
    (double)65893./3137161264. * 16384.,
    (double)131008./3137161264. * 16384.,
    (double)158357./3137161264. * 16384.,
    (double)113350./3137161264. * 16384.,
    (double)64882./3137161264. * 16384.,
    (double)93792./3137161264. * 16384.,
    (double)129018./3137161264. * 16384.,
    (double)96091./3137161264. * 16384.,
    (double)76002./3137161264. * 16384.,
    (double)84473./3137161264. * 16384.,
    (double)116520./3137161264. * 16384.,
    (double)11473./3137161264. * 16384.,
    (double)94679./3137161264. * 16384.,
    (double)116583./3137161264. * 16384.,
    (double)82973./3137161264. * 16384.,
    (double)95029./3137161264. * 16384.,
    (double)65780./3137161264. * 16384.,
    (double)105519./3137161264. * 16384.,
    (double)99681./3137161264. * 16384.,
    (double)99164./3137161264. * 16384.,
    (double)63169./3137161264. * 16384.,
    (double)97804./3137161264. * 16384.,
    (double)7614./3137161264. * 16384.,
    (double)9363./3137161264. * 16384.,
    (double)6727./3137161264. * 16384.,
    (double)9764./3137161264. * 16384.,
    (double)100829./3137161264. * 16384.,
    (double)10547./3137161264. * 16384.,
    (double)80868./3137161264. * 16384.,
    (double)119034./3137161264. * 16384.,
    (double)84607./3137161264. * 16384.,
    (double)119290./3137161264. * 16384.,
    (double)99876./3137161264. * 16384.,
    (double)144334./3137161264. * 16384.,
    (double)115951./3137161264. * 16384.,
    (double)75195./3137161264. * 16384.,
    (double)60489./3137161264. * 16384.,
    (double)107616./3137161264. * 16384.,
    (double)103569./3137161264. * 16384.,
    (double)85281./3137161264. * 16384.,
    (double)67283./3137161264. * 16384.,
    (double)103513./3137161264. * 16384.,
    (double)102322./3137161264. * 16384.,
    (double)8931./3137161264. * 16384.,
    (double)74724./3137161264. * 16384.,
    (double)134307./3137161264. * 16384.,
    (double)108898./3137161264. * 16384.,
    (double)89885./3137161264. * 16384.,
    (double)103268./3137161264. * 16384.,
    (double)199398./3137161264. * 16384.,
    (double)226129./3137161264. * 16384.,
    (double)123829./3137161264. * 16384.,
    (double)92670./3137161264. * 16384.,
    (double)130227./3137161264. * 16384.,
    (double)162643./3137161264. * 16384.,
    (double)126867./3137161264. * 16384.,
    (double)113211./3137161264. * 16384.,
    (double)145114./3137161264. * 16384.,
    (double)158469./3137161264. * 16384.,
    (double)18740./3137161264. * 16384.,
    (double)94807./3137161264. * 16384.,
    (double)133233./3137161264. * 16384.,
    (double)139797./3137161264. * 16384.,
    (double)131721./3137161264. * 16384.,
    (double)124850./3137161264. * 16384.,
    (double)211101./3137161264. * 16384.,
    (double)14812./3137161264. * 16384.,
    (double)12840./3137161264. * 16384.,
    (double)7915./3137161264. * 16384.,
    (double)11430./3137161264. * 16384.,
    (double)12749./3137161264. * 16384.,
    (double)14066./3137161264. * 16384.,
    (double)10423./3137161264. * 16384.,
    (double)11753./3137161264. * 16384.,
    (double)11486./3137161264. * 16384.,
    (double)1974./3137161264. * 16384.,
    (double)11640./3137161264. * 16384.,
    (double)12765./3137161264. * 16384.,
    (double)13606./3137161264. * 16384.,
    (double)17390./3137161264. * 16384.,
    (double)12741./3137161264. * 16384.,
    (double)18388./3137161264. * 16384.,
    (double)155211./3137161264. * 16384.,
    (double)161901./3137161264. * 16384.,
    (double)116430./3137161264. * 16384.,
    (double)147642./3137161264. * 16384.,
    (double)12252./3137161264. * 16384.,
    (double)14206./3137161264. * 16384.,
    (double)13236./3137161264. * 16384.,
    (double)17037./3137161264. * 16384.,
    (double)181498./3137161264. * 16384.,
    (double)21373./3137161264. * 16384.,
    (double)131525./3137161264. * 16384.,
    (double)179867./3137161264. * 16384.,
    (double)124139./3137161264. * 16384.,
    (double)181434./3137161264. * 16384.,
    (double)179499./3137161264. * 16384.,
    (double)225885./3137161264. * 16384.,
    (double)152243./3137161264. * 16384.,
    (double)116381./3137161264. * 16384.,
    (double)92896./3137161264. * 16384.,
    (double)138577./3137161264. * 16384.,
    (double)158651./3137161264. * 16384.,
    (double)139574./3137161264. * 16384.,
    (double)140395./3137161264. * 16384.,
    (double)179660./3137161264. * 16384.,
    (double)178758./3137161264. * 16384.,
    (double)16278./3137161264. * 16384.,
    (double)155141./3137161264. * 16384.,
    (double)235812./3137161264. * 16384.,
    (double)145322./3137161264. * 16384.,
    (double)140665./3137161264. * 16384.,
    (double)170465./3137161264. * 16384.,
    (double)282396./3137161264. * 16384.,
    (double)329561./3137161264. * 16384.,
    (double)136146./3137161264. * 16384.,
    (double)97015./3137161264. * 16384.,
    (double)187432./3137161264. * 16384.,
    (double)130573./3137161264. * 16384.,
    (double)91909./3137161264. * 16384.,
    (double)78155./3137161264. * 16384.,
    (double)105617./3137161264. * 16384.,
    (double)149854./3137161264. * 16384.,
    (double)12952./3137161264. * 16384.,
    (double)83499./3137161264. * 16384.,
    (double)132811./3137161264. * 16384.,
    (double)203793./3137161264. * 16384.,
    (double)138785./3137161264. * 16384.,
    (double)126635./3137161264. * 16384.,
    (double)280782./3137161264. * 16384.,
    (double)209502./3137161264. * 16384.,
    (double)137526./3137161264. * 16384.,
    (double)90208./3137161264. * 16384.,
    (double)135964./3137161264. * 16384.,
    (double)150493./3137161264. * 16384.,
    (double)142226./3137161264. * 16384.,
    (double)93321./3137161264. * 16384.,
    (double)111380./3137161264. * 16384.,
    (double)151257./3137161264. * 16384.,
    (double)11678./3137161264. * 16384.,
    (double)118848./3137161264. * 16384.,
    (double)164582./3137161264. * 16384.,
    (double)156304./3137161264. * 16384.,
    (double)150675./3137161264. * 16384.,
    (double)126305./3137161264. * 16384.,
    (double)207370./3137161264. * 16384.,
    (double)189526./3137161264. * 16384.,
    (double)166400./3137161264. * 16384.,
    (double)121893./3137161264. * 16384.,
    (double)192006./3137161264. * 16384.,
    (double)12714./3137161264. * 16384.,
    (double)12542./3137161264. * 16384.,
    (double)9159./3137161264. * 16384.,
    (double)16098./3137161264. * 16384.,
    (double)191720./3137161264. * 16384.,
    (double)15013./3137161264. * 16384.,
    (double)152489./3137161264. * 16384.,
    (double)229213./3137161264. * 16384.,
    (double)178629./3137161264. * 16384.,
    (double)212760./3137161264. * 16384.,
    (double)219221./3137161264. * 16384.,
    (double)308915./3137161264. * 16384.,
    (double)307620./3137161264. * 16384.,
    (double)144474./3137161264. * 16384.,
    (double)128717./3137161264. * 16384.,
    (double)272764./3137161264. * 16384.,
    (double)186855./3137161264. * 16384.,
    (double)144599./3137161264. * 16384.,
    (double)130679./3137161264. * 16384.,
    (double)201865./3137161264. * 16384.,
    (double)239245./3137161264. * 16384.,
    (double)15206./3137161264. * 16384.,
    (double)204126./3137161264. * 16384.,
    (double)333476./3137161264. * 16384.,
    (double)322796./3137161264. * 16384.,
    (double)211807./3137161264. * 16384.,
    (double)271929./3137161264. * 16384.,
    (double)439567./3137161264. * 16384.,
    (double)711983./3137161264. * 16384.,
    (double)366177./3137161264. * 16384.,
    (double)299880./3137161264. * 16384.,
    (double)715250./3137161264. * 16384.,
    (double)316719./3137161264. * 16384.,
    (double)185955./3137161264. * 16384.,
    (double)168101./3137161264. * 16384.,
    (double)257602./3137161264. * 16384.,
    (double)364411./3137161264. * 16384.,
    (double)30102./3137161264. * 16384.,
    (double)149779./3137161264. * 16384.,
    (double)269865./3137161264. * 16384.,
    (double)638829./3137161264. * 16384.,
    (double)411934./3137161264. * 16384.,
    (double)227197./3137161264. * 16384.,
    (double)500893./3137161264. * 16384.,
    (double)337630./3137161264. * 16384.,
    (double)168565./3137161264. * 16384.,
    (double)130122./3137161264. * 16384.,
    (double)196622./3137161264. * 16384.,
    (double)180765./3137161264. * 16384.,
    (double)101268./3137161264. * 16384.,
    (double)87933./3137161264. * 16384.,
    (double)106941./3137161264. * 16384.,
    (double)183347./3137161264. * 16384.,
    (double)11495./3137161264. * 16384.,
    (double)89102./3137161264. * 16384.,
    (double)130342./3137161264. * 16384.,
    (double)187704./3137161264. * 16384.,
    (double)141202./3137161264. * 16384.,
    (double)107295./3137161264. * 16384.,
    (double)190847./3137161264. * 16384.,
    (double)262938./3137161264. * 16384.,
    (double)153045./3137161264. * 16384.,
    (double)134650./3137161264. * 16384.,
    (double)246030./3137161264. * 16384.,
    (double)18693./3137161264. * 16384.,
    (double)12942./3137161264. * 16384.,
    (double)10544./3137161264. * 16384.,
    (double)26181./3137161264. * 16384.,
    (double)133093./3137161264. * 16384.,
    (double)10053./3137161264. * 16384.,
    (double)67863./3137161264. * 16384.,
    (double)110481./3137161264. * 16384.,
    (double)153212./3137161264. * 16384.,
    (double)140512./3137161264. * 16384.,
    (double)105755./3137161264. * 16384.,
    (double)183609./3137161264. * 16384.,
    (double)515912./3137161264. * 16384.,
    (double)181351./3137161264. * 16384.,
    (double)189369./3137161264. * 16384.,
    (double)449207./3137161264. * 16384.,
    (double)294749./3137161264. * 16384.,
    (double)171116./3137161264. * 16384.,
    (double)154820./3137161264. * 16384.,
    (double)291355./3137161264. * 16384.,
    (double)198935./3137161264. * 16384.,
    (double)13567./3137161264. * 16384.,
    (double)103817./3137161264. * 16384.,
    (double)185450./3137161264. * 16384.,
    (double)336936./3137161264. * 16384.,
    (double)186726./3137161264. * 16384.,
    (double)180382./3137161264. * 16384.,
    (double)404793./3137161264. * 16384.,
    (double)350380./3137161264. * 16384.,
    (double)151378./3137161264. * 16384.,
    (double)108585./3137161264. * 16384.,
    (double)194457./3137161264. * 16384.,
    (double)156088./3137161264. * 16384.,
    (double)94153./3137161264. * 16384.,
    (double)74622./3137161264. * 16384.,
    (double)102574./3137161264. * 16384.,
    (double)141964./3137161264. * 16384.,
    (double)11901./3137161264. * 16384.,
    (double)61152./3137161264. * 16384.,
    (double)99775./3137161264. * 16384.,
    (double)146414./3137161264. * 16384.,
    (double)119041./3137161264. * 16384.,
    (double)72932./3137161264. * 16384.,
    (double)147504./3137161264. * 16384.,
    (double)189900./3137161264. * 16384.,
    (double)100232./3137161264. * 16384.,
    (double)64242./3137161264. * 16384.,
    (double)97744./3137161264. * 16384.,
    (double)93503./3137161264. * 16384.,
    (double)52519./3137161264. * 16384.,
    (double)48224./3137161264. * 16384.,
    (double)56277./3137161264. * 16384.,
    (double)98736./3137161264. * 16384.,
    (double)6540./3137161264. * 16384.,
    (double)48006./3137161264. * 16384.,
    (double)72606./3137161264. * 16384.,
    (double)84540./3137161264. * 16384.,
    (double)66364./3137161264. * 16384.,
    (double)52239./3137161264. * 16384.,
    (double)83595./3137161264. * 16384.,
    (double)146091./3137161264. * 16384.,
    (double)99784./3137161264. * 16384.,
    (double)72914./3137161264. * 16384.,
    (double)115159./3137161264. * 16384.,
    (double)9384./3137161264. * 16384.,
    (double)7166./3137161264. * 16384.,
    (double)5395./3137161264. * 16384.,
    (double)9572./3137161264. * 16384.,
    (double)109495./3137161264. * 16384.,
    (double)8545./3137161264. * 16384.,
    (double)48346./3137161264. * 16384.,
    (double)75420./3137161264. * 16384.,
    (double)78034./3137161264. * 16384.,
    (double)77488./3137161264. * 16384.,
    (double)55316./3137161264. * 16384.,
    (double)91152./3137161264. * 16384.,
    (double)171934./3137161264. * 16384.,
    (double)90910./3137161264. * 16384.,
    (double)70782./3137161264. * 16384.,
    (double)133448./3137161264. * 16384.,
    (double)139912./3137161264. * 16384.,
    (double)94295./3137161264. * 16384.,
    (double)70503./3137161264. * 16384.,
    (double)109039./3137161264. * 16384.,
    (double)107252./3137161264. * 16384.,
    (double)6858./3137161264. * 16384.,
    (double)52963./3137161264. * 16384.,
    (double)91822./3137161264. * 16384.,
    (double)117925./3137161264. * 16384.,
    (double)86446./3137161264. * 16384.,
    (double)79394./3137161264. * 16384.,
    (double)169742./3137161264. * 16384.,
    (double)241411./3137161264. * 16384.,
    (double)108321./3137161264. * 16384.,
    (double)93729./3137161264. * 16384.,
    (double)161646./3137161264. * 16384.,
    (double)144099./3137161264. * 16384.,
    (double)78629./3137161264. * 16384.,
    (double)79323./3137161264. * 16384.,
    (double)105698./3137161264. * 16384.,
    (double)143361./3137161264. * 16384.,
    (double)13959./3137161264. * 16384.,
    (double)58714./3137161264. * 16384.,
    (double)102655./3137161264. * 16384.,
    (double)165731./3137161264. * 16384.,
    (double)115762./3137161264. * 16384.,
    (double)96932./3137161264. * 16384.,
    (double)207179./3137161264. * 16384.,
    (double)16665./3137161264. * 16384.,
    (double)11080./3137161264. * 16384.,
    (double)7126./3137161264. * 16384.,
    (double)12836./3137161264. * 16384.,
    (double)10024./3137161264. * 16384.,
    (double)8101./3137161264. * 16384.,
    (double)6414./3137161264. * 16384.,
    (double)8564./3137161264. * 16384.,
    (double)10472./3137161264. * 16384.,
    (double)1125./3137161264. * 16384.,
    (double)5822./3137161264. * 16384.,
    (double)9371./3137161264. * 16384.,
    (double)17167./3137161264. * 16384.,
    (double)16561./3137161264. * 16384.,
    (double)10063./3137161264. * 16384.,
    (double)19618./3137161264. * 16384.,
    (double)107130./3137161264. * 16384.,
    (double)73145./3137161264. * 16384.,
    (double)68842./3137161264. * 16384.,
    (double)93147./3137161264. * 16384.,
    (double)8072./3137161264. * 16384.,
    (double)5053./3137161264. * 16384.,
    (double)5046./3137161264. * 16384.,
    (double)8742./3137161264. * 16384.,
    (double)78972./3137161264. * 16384.,
    (double)6239./3137161264. * 16384.,
    (double)42811./3137161264. * 16384.,
    (double)60434./3137161264. * 16384.,
    (double)72030./3137161264. * 16384.,
    (double)68214./3137161264. * 16384.,
    (double)66389./3137161264. * 16384.,
    (double)89066./3137161264. * 16384.,
    (double)117797./3137161264. * 16384.,
    (double)67445./3137161264. * 16384.,
    (double)65545./3137161264. * 16384.,
    (double)113403./3137161264. * 16384.,
    (double)119236./3137161264. * 16384.,
    (double)78980./3137161264. * 16384.,
    (double)70018./3137161264. * 16384.,
    (double)101934./3137161264. * 16384.,
    (double)114617./3137161264. * 16384.,
    (double)8925./3137161264. * 16384.,
    (double)63001./3137161264. * 16384.,
    (double)104970./3137161264. * 16384.,
    (double)117045./3137161264. * 16384.,
    (double)96489./3137161264. * 16384.,
    (double)101460./3137161264. * 16384.,
    (double)197962./3137161264. * 16384.,
    (double)406857./3137161264. * 16384.,
    (double)140194./3137161264. * 16384.,
    (double)131158./3137161264. * 16384.,
    (double)326562./3137161264. * 16384.,
    (double)145729./3137161264. * 16384.,
    (double)78757./3137161264. * 16384.,
    (double)91450./3137161264. * 16384.,
    (double)122398./3137161264. * 16384.,
    (double)192712./3137161264. * 16384.,
    (double)14838./3137161264. * 16384.,
    (double)73758./3137161264. * 16384.,
    (double)129130./3137161264. * 16384.,
    (double)276277./3137161264. * 16384.,
    (double)154576./3137161264. * 16384.,
    (double)127129./3137161264. * 16384.,
    (double)317475./3137161264. * 16384.,
    (double)214417./3137161264. * 16384.,
    (double)123010./3137161264. * 16384.,
    (double)91570./3137161264. * 16384.,
    (double)149431./3137161264. * 16384.,
    (double)115432./3137161264. * 16384.,
    (double)75745./3137161264. * 16384.,
    (double)69726./3137161264. * 16384.,
    (double)89208./3137161264. * 16384.,
    (double)122156./3137161264. * 16384.,
    (double)7627./3137161264. * 16384.,
    (double)68564./3137161264. * 16384.,
    (double)109509./3137161264. * 16384.,
    (double)152803./3137161264. * 16384.,
    (double)119330./3137161264. * 16384.,
    (double)92944./3137161264. * 16384.,
    (double)174079./3137161264. * 16384.,
    (double)140677./3137161264. * 16384.,
    (double)99174./3137161264. * 16384.,
    (double)88880./3137161264. * 16384.,
    (double)138409./3137161264. * 16384.,
    (double)9766./3137161264. * 16384.,
    (double)6706./3137161264. * 16384.,
    (double)6635./3137161264. * 16384.,
    (double)11568./3137161264. * 16384.,
    (double)104487./3137161264. * 16384.,
    (double)6621./3137161264. * 16384.,
    (double)68288./3137161264. * 16384.,
    (double)101831./3137161264. * 16384.,
    (double)109702./3137161264. * 16384.,
    (double)102659./3137161264. * 16384.,
    (double)92917./3137161264. * 16384.,
    (double)144824./3137161264. * 16384.,
    (double)259437./3137161264. * 16384.,
    (double)118784./3137161264. * 16384.,
    (double)120399./3137161264. * 16384.,
    (double)261230./3137161264. * 16384.,
    (double)131830./3137161264. * 16384.,
    (double)89143./3137161264. * 16384.,
    (double)86403./3137161264. * 16384.,
    (double)143554./3137161264. * 16384.,
    (double)183904./3137161264. * 16384.,
    (double)10601./3137161264. * 16384.,
    (double)103808./3137161264. * 16384.,
    (double)189440./3137161264. * 16384.,
    (double)295666./3137161264. * 16384.,
    (double)198436./3137161264. * 16384.,
    (double)202541./3137161264. * 16384.,
    (double)493789./3137161264. * 16384.,
    (double)375551./3137161264. * 16384.,
    (double)181491./3137161264. * 16384.,
    (double)137000./3137161264. * 16384.,
    (double)267932./3137161264. * 16384.,
    (double)162297./3137161264. * 16384.,
    (double)101636./3137161264. * 16384.,
    (double)83773./3137161264. * 16384.,
    (double)115523./3137161264. * 16384.,
    (double)133027./3137161264. * 16384.,
    (double)10957./3137161264. * 16384.,
    (double)54982./3137161264. * 16384.,
    (double)108369./3137161264. * 16384.,
    (double)182611./3137161264. * 16384.,
    (double)134978./3137161264. * 16384.,
    (double)87965./3137161264. * 16384.,
    (double)187958./3137161264. * 16384.,
    (double)192596./3137161264. * 16384.,
    (double)109752./3137161264. * 16384.,
    (double)76847./3137161264. * 16384.,
    (double)116844./3137161264. * 16384.,
    (double)101857./3137161264. * 16384.,
    (double)65501./3137161264. * 16384.,
    (double)60009./3137161264. * 16384.,
    (double)68180./3137161264. * 16384.,
    (double)87041./3137161264. * 16384.,
    (double)7709./3137161264. * 16384.,
    (double)50740./3137161264. * 16384.,
    (double)75445./3137161264. * 16384.,
    (double)78999./3137161264. * 16384.,
    (double)76762./3137161264. * 16384.,
    (double)56152./3137161264. * 16384.,
    (double)98506./3137161264. * 16384.,
    (double)112078./3137161264. * 16384.,
    (double)81552./3137161264. * 16384.,
    (double)67827./3137161264. * 16384.,
    (double)105921./3137161264. * 16384.,
    (double)8936./3137161264. * 16384.,
    (double)7695./3137161264. * 16384.,
    (double)5745./3137161264. * 16384.,
    (double)10800./3137161264. * 16384.,
    (double)64454./3137161264. * 16384.,
    (double)5577./3137161264. * 16384.,
    (double)35555./3137161264. * 16384.,
    (double)52755./3137161264. * 16384.,
    (double)66352./3137161264. * 16384.,
    (double)70760./3137161264. * 16384.,
    (double)51220./3137161264. * 16384.,
    (double)87723./3137161264. * 16384.,
    (double)141702./3137161264. * 16384.,
    (double)77598./3137161264. * 16384.,
    (double)71737./3137161264. * 16384.,
    (double)139236./3137161264. * 16384.,
    (double)112594./3137161264. * 16384.,
    (double)76753./3137161264. * 16384.,
    (double)62150./3137161264. * 16384.,
    (double)95596./3137161264. * 16384.,
    (double)75142./3137161264. * 16384.,
    (double)5774./3137161264. * 16384.,
    (double)42411./3137161264. * 16384.,
    (double)72785./3137161264. * 16384.,
    (double)110014./3137161264. * 16384.,
    (double)73797./3137161264. * 16384.,
    (double)82265./3137161264. * 16384.,
    (double)177800./3137161264. * 16384.,
    (double)205245./3137161264. * 16384.,
    (double)122135./3137161264. * 16384.,
    (double)62874./3137161264. * 16384.,
    (double)121214./3137161264. * 16384.,
    (double)106791./3137161264. * 16384.,
    (double)79018./3137161264. * 16384.,
    (double)51843./3137161264. * 16384.,
    (double)68052./3137161264. * 16384.,
    (double)77381./3137161264. * 16384.,
    (double)6871./3137161264. * 16384.,
    (double)35738./3137161264. * 16384.,
    (double)64186./3137161264. * 16384.,
    (double)82790./3137161264. * 16384.,
    (double)75685./3137161264. * 16384.,
    (double)42835./3137161264. * 16384.,
    (double)96395./3137161264. * 16384.,
    (double)113601./3137161264. * 16384.,
    (double)80158./3137161264. * 16384.,
    (double)42321./3137161264. * 16384.,
    (double)62754./3137161264. * 16384.,
    (double)66793./3137161264. * 16384.,
    (double)34330./3137161264. * 16384.,
    (double)36516./3137161264. * 16384.,
    (double)43003./3137161264. * 16384.,
    (double)59715./3137161264. * 16384.,
    (double)5215./3137161264. * 16384.,
    (double)35608./3137161264. * 16384.,
    (double)53088./3137161264. * 16384.,
    (double)50315./3137161264. * 16384.,
    (double)52540./3137161264. * 16384.,
    (double)35011./3137161264. * 16384.,
    (double)60269./3137161264. * 16384.,
    (double)94573./3137161264. * 16384.,
    (double)77471./3137161264. * 16384.,
    (double)51160./3137161264. * 16384.,
    (double)75579./3137161264. * 16384.,
    (double)6542./3137161264. * 16384.,
    (double)6351./3137161264. * 16384.,
    (double)4317./3137161264. * 16384.,
    (double)6803./3137161264. * 16384.,
    (double)60211./3137161264. * 16384.,
    (double)6489./3137161264. * 16384.,
    (double)31448./3137161264. * 16384.,
    (double)50556./3137161264. * 16384.,
    (double)51346./3137161264. * 16384.,
    (double)70197./3137161264. * 16384.,
    (double)41226./3137161264. * 16384.,
    (double)69427./3137161264. * 16384.,
    (double)91102./3137161264. * 16384.,
    (double)58340./3137161264. * 16384.,
    (double)43350./3137161264. * 16384.,
    (double)81332./3137161264. * 16384.,
    (double)74201./3137161264. * 16384.,
    (double)59688./3137161264. * 16384.,
    (double)42749./3137161264. * 16384.,
    (double)62219./3137161264. * 16384.,
    (double)62450./3137161264. * 16384.,
    (double)4556./3137161264. * 16384.,
    (double)32427./3137161264. * 16384.,
    (double)60630./3137161264. * 16384.,
    (double)64451./3137161264. * 16384.,
    (double)57992./3137161264. * 16384.,
    (double)46748./3137161264. * 16384.,
    (double)105615./3137161264. * 16384.,
    (double)149380./3137161264. * 16384.,
    (double)88049./3137161264. * 16384.,
    (double)60200./3137161264. * 16384.,
    (double)103916./3137161264. * 16384.,
    (double)96114./3137161264. * 16384.,
    (double)63974./3137161264. * 16384.,
    (double)63495./3137161264. * 16384.,
    (double)74229./3137161264. * 16384.,
    (double)94930./3137161264. * 16384.,
    (double)9481./3137161264. * 16384.,
    (double)45037./3137161264. * 16384.,
    (double)72978./3137161264. * 16384.,
    (double)93687./3137161264. * 16384.,
    (double)74730./3137161264. * 16384.,
    (double)61445./3137161264. * 16384.,
    (double)119356./3137161264. * 16384.,
    (double)8623./3137161264. * 16384.,
    (double)9970./3137161264. * 16384.,
    (double)4409./3137161264. * 16384.,
    (double)7783./3137161264. * 16384.,
    (double)5729./3137161264. * 16384.,
    (double)6486./3137161264. * 16384.,
    (double)4943./3137161264. * 16384.,
    (double)5766./3137161264. * 16384.,
    (double)5998./3137161264. * 16384.,
    (double)1270./3137161264. * 16384.,
    (double)4647./3137161264. * 16384.,
    (double)6510./3137161264. * 16384.,
    (double)7503./3137161264. * 16384.,
    (double)9044./3137161264. * 16384.,
    (double)5619./3137161264. * 16384.,
    (double)9016./3137161264. * 16384.,
    (double)87661./3137161264. * 16384.,
    (double)72638./3137161264. * 16384.,
    (double)59350./3137161264. * 16384.,
    (double)79523./3137161264. * 16384.,
    (double)5826./3137161264. * 16384.,
    (double)6843./3137161264. * 16384.,
    (double)4276./3137161264. * 16384.,
    (double)6495./3137161264. * 16384.,
    (double)56109./3137161264. * 16384.,
    (double)5143./3137161264. * 16384.,
    (double)35113./3137161264. * 16384.,
    (double)49336./3137161264. * 16384.,
    (double)52177./3137161264. * 16384.,
    (double)60689./3137161264. * 16384.,
    (double)56097./3137161264. * 16384.,
    (double)69442./3137161264. * 16384.,
    (double)81382./3137161264. * 16384.,
    (double)54808./3137161264. * 16384.,
    (double)52872./3137161264. * 16384.,
    (double)86018./3137161264. * 16384.,
    (double)76674./3137161264. * 16384.,
    (double)72042./3137161264. * 16384.,
    (double)54636./3137161264. * 16384.,
    (double)76995./3137161264. * 16384.,
    (double)73302./3137161264. * 16384.,
    (double)5464./3137161264. * 16384.,
    (double)52817./3137161264. * 16384.,
    (double)80161./3137161264. * 16384.,
    (double)68743./3137161264. * 16384.,
    (double)59618./3137161264. * 16384.,
    (double)71551./3137161264. * 16384.,
    (double)123727./3137161264. * 16384.,
    (double)149451./3137161264. * 16384.,
    (double)78755./3137161264. * 16384.,
    (double)61188./3137161264. * 16384.,
    (double)113037./3137161264. * 16384.,
    (double)78251./3137161264. * 16384.,
    (double)49136./3137161264. * 16384.,
    (double)46363./3137161264. * 16384.,
    (double)62620./3137161264. * 16384.,
    (double)75821./3137161264. * 16384.,
    (double)5752./3137161264. * 16384.,
    (double)35323./3137161264. * 16384.,
    (double)62014./3137161264. * 16384.,
    (double)103791./3137161264. * 16384.,
    (double)64671./3137161264. * 16384.,
    (double)56259./3137161264. * 16384.,
    (double)130452./3137161264. * 16384.,
    (double)105293./3137161264. * 16384.,
    (double)82261./3137161264. * 16384.,
    (double)52720./3137161264. * 16384.,
    (double)83546./3137161264. * 16384.,
    (double)62647./3137161264. * 16384.,
    (double)55945./3137161264. * 16384.,
    (double)46136./3137161264. * 16384.,
    (double)62045./3137161264. * 16384.,
    (double)53860./3137161264. * 16384.,
    (double)4662./3137161264. * 16384.,
    (double)42337./3137161264. * 16384.,
    (double)65331./3137161264. * 16384.,
    (double)63058./3137161264. * 16384.,
    (double)63088./3137161264. * 16384.,
    (double)50363./3137161264. * 16384.,
    (double)89181./3137161264. * 16384.,
    (double)79721./3137161264. * 16384.,
    (double)57712./3137161264. * 16384.,
    (double)58383./3137161264. * 16384.,
    (double)84843./3137161264. * 16384.,
    (double)4811./3137161264. * 16384.,
    (double)4253./3137161264. * 16384.,
    (double)3421./3137161264. * 16384.,
    (double)6188./3137161264. * 16384.,
    (double)56242./3137161264. * 16384.,
    (double)4351./3137161264. * 16384.,
    (double)38319./3137161264. * 16384.,
    (double)55149./3137161264. * 16384.,
    (double)60733./3137161264. * 16384.,
    (double)60475./3137161264. * 16384.,
    (double)58102./3137161264. * 16384.,
    (double)87048./3137161264. * 16384.,
    (double)106126./3137161264. * 16384.,
    (double)52567./3137161264. * 16384.,
    (double)59920./3137161264. * 16384.,
    (double)106215./3137161264. * 16384.,
    (double)70841./3137161264. * 16384.,
    (double)54320./3137161264. * 16384.,
    (double)46100./3137161264. * 16384.,
    (double)76992./3137161264. * 16384.,
    (double)89386./3137161264. * 16384.,
    (double)6096./3137161264. * 16384.,
    (double)55848./3137161264. * 16384.,
    (double)105352./3137161264. * 16384.,
    (double)123309./3137161264. * 16384.,
    (double)104847./3137161264. * 16384.,
    (double)108373./3137161264. * 16384.,
    (double)212663./3137161264. * 16384.,
    (double)279031./3137161264. * 16384.,
    (double)145248./3137161264. * 16384.,
    (double)99008./3137161264. * 16384.,
    (double)211121./3137161264. * 16384.,
    (double)100810./3137161264. * 16384.,
    (double)70932./3137161264. * 16384.,
    (double)52754./3137161264. * 16384.,
    (double)84486./3137161264. * 16384.,
    (double)110819./3137161264. * 16384.,
    (double)10424./3137161264. * 16384.,
    (double)51621./3137161264. * 16384.,
    (double)90315./3137161264. * 16384.,
    (double)144794./3137161264. * 16384.,
    (double)118982./3137161264. * 16384.,
    (double)65843./3137161264. * 16384.,
    (double)147400./3137161264. * 16384.,
    (double)180547./3137161264. * 16384.,
    (double)111538./3137161264. * 16384.,
    (double)69105./3137161264. * 16384.,
    (double)123197./3137161264. * 16384.,
    (double)88773./3137161264. * 16384.,
    (double)61503./3137161264. * 16384.,
    (double)67395./3137161264. * 16384.,
    (double)72876./3137161264. * 16384.,
    (double)103488./3137161264. * 16384.,
    (double)9544./3137161264. * 16384.,
    (double)59416./3137161264. * 16384.,
    (double)79540./3137161264. * 16384.,
    (double)106231./3137161264. * 16384.,
    (double)111581./3137161264. * 16384.,
    (double)63871./3137161264. * 16384.,
    (double)111413./3137161264. * 16384.,
    (double)123217./3137161264. * 16384.,
    (double)106471./3137161264. * 16384.,
    (double)106517./3137161264. * 16384.,
    (double)144809./3137161264. * 16384.,
    (double)10809./3137161264. * 16384.,
    (double)10187./3137161264. * 16384.,
    (double)8431./3137161264. * 16384.,
    (double)18034./3137161264. * 16384.,
    (double)66477./3137161264. * 16384.,
    (double)6304./3137161264. * 16384.,
    (double)37090./3137161264. * 16384.,
    (double)54347./3137161264. * 16384.,
    (double)65700./3137161264. * 16384.,
    (double)85063./3137161264. * 16384.,
    (double)55089./3137161264. * 16384.,
    (double)91540./3137161264. * 16384.,
    (double)169116./3137161264. * 16384.,
    (double)90796./3137161264. * 16384.,
    (double)98343./3137161264. * 16384.,
    (double)203250./3137161264. * 16384.,
    (double)110839./3137161264. * 16384.,
    (double)83122./3137161264. * 16384.,
    (double)73150./3137161264. * 16384.,
    (double)130526./3137161264. * 16384.,
    (double)93611./3137161264. * 16384.,
    (double)8013./3137161264. * 16384.,
    (double)53826./3137161264. * 16384.,
    (double)97119./3137161264. * 16384.,
    (double)141999./3137161264. * 16384.,
    (double)102166./3137161264. * 16384.,
    (double)109331./3137161264. * 16384.,
    (double)276208./3137161264. * 16384.,
    (double)17598./3137161264. * 16384.,
    (double)12124./3137161264. * 16384.,
    (double)6746./3137161264. * 16384.,
    (double)13414./3137161264. * 16384.,
    (double)9705./3137161264. * 16384.,
    (double)8441./3137161264. * 16384.,
    (double)5162./3137161264. * 16384.,
    (double)7378./3137161264. * 16384.,
    (double)9019./3137161264. * 16384.,
    (double)1297./3137161264. * 16384.,
    (double)4414./3137161264. * 16384.,
    (double)7292./3137161264. * 16384.,
    (double)10749./3137161264. * 16384.,
    (double)11656./3137161264. * 16384.,
    (double)6235./3137161264. * 16384.,
    (double)12586./3137161264. * 16384.,
    (double)13811./3137161264. * 16384.,
    (double)10086./3137161264. * 16384.,
    (double)5125./3137161264. * 16384.,
    (double)8361./3137161264. * 16384.,
    (double)8782./3137161264. * 16384.,
    (double)7349./3137161264. * 16384.,
    (double)5242./3137161264. * 16384.,
    (double)6068./3137161264. * 16384.,
    (double)8881./3137161264. * 16384.,
    (double)1204./3137161264. * 16384.,
    (double)5553./3137161264. * 16384.,
    (double)7307./3137161264. * 16384.,
    (double)9595./3137161264. * 16384.,
    (double)10515./3137161264. * 16384.,
    (double)5670./3137161264. * 16384.,
    (double)9979./3137161264. * 16384.,
    (double)9530./3137161264. * 16384.,
    (double)9814./3137161264. * 16384.,
    (double)6874./3137161264. * 16384.,
    (double)10532./3137161264. * 16384.,
    (double)864./3137161264. * 16384.,
    (double)1186./3137161264. * 16384.,
    (double)971./3137161264. * 16384.,
    (double)1194./3137161264. * 16384.,
    (double)7153./3137161264. * 16384.,
    (double)1004./3137161264. * 16384.,
    (double)4740./3137161264. * 16384.,
    (double)6123./3137161264. * 16384.,
    (double)6888./3137161264. * 16384.,
    (double)9265./3137161264. * 16384.,
    (double)5500./3137161264. * 16384.,
    (double)9194./3137161264. * 16384.,
    (double)18820./3137161264. * 16384.,
    (double)11617./3137161264. * 16384.,
    (double)9485./3137161264. * 16384.,
    (double)21287./3137161264. * 16384.,
    (double)16109./3137161264. * 16384.,
    (double)15120./3137161264. * 16384.,
    (double)10622./3137161264. * 16384.,
    (double)18465./3137161264. * 16384.,
    (double)10045./3137161264. * 16384.,
    (double)1094./3137161264. * 16384.,
    (double)6332./3137161264. * 16384.,
    (double)11861./3137161264. * 16384.,
    (double)14907./3137161264. * 16384.,
    (double)13596./3137161264. * 16384.,
    (double)10840./3137161264. * 16384.,
    (double)25188./3137161264. * 16384.,
    (double)133090./3137161264. * 16384.,
    (double)73513./3137161264. * 16384.,
    (double)51359./3137161264. * 16384.,
    (double)74497./3137161264. * 16384.,
    (double)73624./3137161264. * 16384.,
    (double)58452./3137161264. * 16384.,
    (double)51028./3137161264. * 16384.,
    (double)58213./3137161264. * 16384.,
    (double)98669./3137161264. * 16384.,
    (double)12098./3137161264. * 16384.,
    (double)53471./3137161264. * 16384.,
    (double)71632./3137161264. * 16384.,
    (double)88719./3137161264. * 16384.,
    (double)80743./3137161264. * 16384.,
    (double)59412./3137161264. * 16384.,
    (double)103647./3137161264. * 16384.,
    (double)9284./3137161264. * 16384.,
    (double)7962./3137161264. * 16384.,
    (double)4103./3137161264. * 16384.,
    (double)6339./3137161264. * 16384.,
    (double)5594./3137161264. * 16384.,
    (double)5728./3137161264. * 16384.,
    (double)4426./3137161264. * 16384.,
    (double)4325./3137161264. * 16384.,
    (double)7732./3137161264. * 16384.,
    (double)1475./3137161264. * 16384.,
    (double)5105./3137161264. * 16384.,
    (double)5875./3137161264. * 16384.,
    (double)9603./3137161264. * 16384.,
    (double)10900./3137161264. * 16384.,
    (double)5932./3137161264. * 16384.,
    (double)8897./3137161264. * 16384.,
    (double)74775./3137161264. * 16384.,
    (double)75315./3137161264. * 16384.,
    (double)53526./3137161264. * 16384.,
    (double)63952./3137161264. * 16384.,
    (double)6876./3137161264. * 16384.,
    (double)6410./3137161264. * 16384.,
    (double)5636./3137161264. * 16384.,
    (double)6364./3137161264. * 16384.,
    (double)61729./3137161264. * 16384.,
    (double)6649./3137161264. * 16384.,
    (double)31531./3137161264. * 16384.,
    (double)43692./3137161264. * 16384.,
    (double)46217./3137161264. * 16384.,
    (double)58790./3137161264. * 16384.,
    (double)46882./3137161264. * 16384.,
    (double)61988./3137161264. * 16384.,
    (double)79929./3137161264. * 16384.,
    (double)56107./3137161264. * 16384.,
    (double)51329./3137161264. * 16384.,
    (double)73113./3137161264. * 16384.,
    (double)76731./3137161264. * 16384.,
    (double)69348./3137161264. * 16384.,
    (double)54105./3137161264. * 16384.,
    (double)72769./3137161264. * 16384.,
    (double)81643./3137161264. * 16384.,
    (double)7622./3137161264. * 16384.,
    (double)59796./3137161264. * 16384.,
    (double)79427./3137161264. * 16384.,
    (double)71839./3137161264. * 16384.,
    (double)65634./3137161264. * 16384.,
    (double)70227./3137161264. * 16384.,
    (double)115861./3137161264. * 16384.,
    (double)139332./3137161264. * 16384.,
    (double)67964./3137161264. * 16384.,
    (double)49371./3137161264. * 16384.,
    (double)95185./3137161264. * 16384.,
    (double)70914./3137161264. * 16384.,
    (double)46075./3137161264. * 16384.,
    (double)39840./3137161264. * 16384.,
    (double)49187./3137161264. * 16384.,
    (double)85848./3137161264. * 16384.,
    (double)8370./3137161264. * 16384.,
    (double)40829./3137161264. * 16384.,
    (double)72007./3137161264. * 16384.,
    (double)111942./3137161264. * 16384.,
    (double)86734./3137161264. * 16384.,
    (double)54175./3137161264. * 16384.,
    (double)127842./3137161264. * 16384.,
    (double)132755./3137161264. * 16384.,
    (double)90981./3137161264. * 16384.,
    (double)53302./3137161264. * 16384.,
    (double)88712./3137161264. * 16384.,
    (double)76580./3137161264. * 16384.,
    (double)65976./3137161264. * 16384.,
    (double)46470./3137161264. * 16384.,
    (double)54259./3137161264. * 16384.,
    (double)81335./3137161264. * 16384.,
    (double)7068./3137161264. * 16384.,
    (double)52302./3137161264. * 16384.,
    (double)77076./3137161264. * 16384.,
    (double)99884./3137161264. * 16384.,
    (double)95184./3137161264. * 16384.,
    (double)59685./3137161264. * 16384.,
    (double)104168./3137161264. * 16384.,
    (double)91940./3137161264. * 16384.,
    (double)83295./3137161264. * 16384.,
    (double)54059./3137161264. * 16384.,
    (double)87014./3137161264. * 16384.,
    (double)7303./3137161264. * 16384.,
    (double)9365./3137161264. * 16384.,
    (double)4569./3137161264. * 16384.,
    (double)7165./3137161264. * 16384.,
    (double)72746./3137161264. * 16384.,
    (double)6195./3137161264. * 16384.,
    (double)44720./3137161264. * 16384.,
    (double)66268./3137161264. * 16384.,
    (double)68820./3137161264. * 16384.,
    (double)83252./3137161264. * 16384.,
    (double)64227./3137161264. * 16384.,
    (double)100015./3137161264. * 16384.,
    (double)127751./3137161264. * 16384.,
    (double)74539./3137161264. * 16384.,
    (double)68390./3137161264. * 16384.,
    (double)111678./3137161264. * 16384.,
    (double)87082./3137161264. * 16384.,
    (double)72172./3137161264. * 16384.,
    (double)53539./3137161264. * 16384.,
    (double)81647./3137161264. * 16384.,
    (double)109146./3137161264. * 16384.,
    (double)8615./3137161264. * 16384.,
    (double)76872./3137161264. * 16384.,
    (double)120584./3137161264. * 16384.,
    (double)143369./3137161264. * 16384.,
    (double)117409./3137161264. * 16384.,
    (double)115404./3137161264. * 16384.,
    (double)228523./3137161264. * 16384.,
    (double)397460./3137161264. * 16384.,
    (double)173743./3137161264. * 16384.,
    (double)138801./3137161264. * 16384.,
    (double)306053./3137161264. * 16384.,
    (double)127857./3137161264. * 16384.,
    (double)77324./3137161264. * 16384.,
    (double)69210./3137161264. * 16384.,
    (double)95619./3137161264. * 16384.,
    (double)135880./3137161264. * 16384.,
    (double)10354./3137161264. * 16384.,
    (double)62151./3137161264. * 16384.,
    (double)108111./3137161264. * 16384.,
    (double)234285./3137161264. * 16384.,
    (double)134645./3137161264. * 16384.,
    (double)104682./3137161264. * 16384.,
    (double)250445./3137161264. * 16384.,
    (double)158869./3137161264. * 16384.,
    (double)76937./3137161264. * 16384.,
    (double)59653./3137161264. * 16384.,
    (double)112749./3137161264. * 16384.,
    (double)77963./3137161264. * 16384.,
    (double)42440./3137161264. * 16384.,
    (double)46425./3137161264. * 16384.,
    (double)59811./3137161264. * 16384.,
    (double)97044./3137161264. * 16384.,
    (double)5916./3137161264. * 16384.,
    (double)47115./3137161264. * 16384.,
    (double)74730./3137161264. * 16384.,
    (double)100232./3137161264. * 16384.,
    (double)68966./3137161264. * 16384.,
    (double)59345./3137161264. * 16384.,
    (double)112749./3137161264. * 16384.,
    (double)146924./3137161264. * 16384.,
    (double)93154./3137161264. * 16384.,
    (double)99426./3137161264. * 16384.,
    (double)181565./3137161264. * 16384.,
    (double)10577./3137161264. * 16384.,
    (double)7422./3137161264. * 16384.,
    (double)7129./3137161264. * 16384.,
    (double)17683./3137161264. * 16384.,
    (double)83818./3137161264. * 16384.,
    (double)5955./3137161264. * 16384.,
    (double)47495./3137161264. * 16384.,
    (double)77846./3137161264. * 16384.,
    (double)90690./3137161264. * 16384.,
    (double)78856./3137161264. * 16384.,
    (double)61962./3137161264. * 16384.,
    (double)128791./3137161264. * 16384.,
    (double)273305./3137161264. * 16384.,
    (double)115721./3137161264. * 16384.,
    (double)147473./3137161264. * 16384.,
    (double)420508./3137161264. * 16384.,
    (double)141595./3137161264. * 16384.,
    (double)82924./3137161264. * 16384.,
    (double)92952./3137161264. * 16384.,
    (double)181151./3137161264. * 16384.,
    (double)124803./3137161264. * 16384.,
    (double)7953./3137161264. * 16384.,
    (double)75284./3137161264. * 16384.,
    (double)128698./3137161264. * 16384.,
    (double)216676./3137161264. * 16384.,
    (double)125571./3137161264. * 16384.,
    (double)144904./3137161264. * 16384.,
    (double)388123./3137161264. * 16384.,
    (double)218594./3137161264. * 16384.,
    (double)111816./3137161264. * 16384.,
    (double)75399./3137161264. * 16384.,
    (double)150125./3137161264. * 16384.,
    (double)104554./3137161264. * 16384.,
    (double)70876./3137161264. * 16384.,
    (double)51959./3137161264. * 16384.,
    (double)73548./3137161264. * 16384.,
    (double)99422./3137161264. * 16384.,
    (double)7659./3137161264. * 16384.,
    (double)48156./3137161264. * 16384.,
    (double)83588./3137161264. * 16384.,
    (double)107797./3137161264. * 16384.,
    (double)88836./3137161264. * 16384.,
    (double)60966./3137161264. * 16384.,
    (double)127927./3137161264. * 16384.,
    (double)132469./3137161264. * 16384.,
    (double)76302./3137161264. * 16384.,
    (double)43487./3137161264. * 16384.,
    (double)75561./3137161264. * 16384.,
    (double)74694./3137161264. * 16384.,
    (double)50548./3137161264. * 16384.,
    (double)38012./3137161264. * 16384.,
    (double)50489./3137161264. * 16384.,
    (double)76427./3137161264. * 16384.,
    (double)5683./3137161264. * 16384.,
    (double)44223./3137161264. * 16384.,
    (double)68415./3137161264. * 16384.,
    (double)77816./3137161264. * 16384.,
    (double)63163./3137161264. * 16384.,
    (double)42633./3137161264. * 16384.,
    (double)79669./3137161264. * 16384.,
    (double)107946./3137161264. * 16384.,
    (double)82042./3137161264. * 16384.,
    (double)58448./3137161264. * 16384.,
    (double)111080./3137161264. * 16384.,
    (double)6326./3137161264. * 16384.,
    (double)5914./3137161264. * 16384.,
    (double)4432./3137161264. * 16384.,
    (double)8828./3137161264. * 16384.,
    (double)80111./3137161264. * 16384.,
    (double)5556./3137161264. * 16384.,
    (double)41348./3137161264. * 16384.,
    (double)69611./3137161264. * 16384.,
    (double)77610./3137161264. * 16384.,
    (double)75911./3137161264. * 16384.,
    (double)50557./3137161264. * 16384.,
    (double)99351./3137161264. * 16384.,
    (double)156612./3137161264. * 16384.,
    (double)79657./3137161264. * 16384.,
    (double)77402./3137161264. * 16384.,
    (double)175612./3137161264. * 16384.,
    (double)115111./3137161264. * 16384.,
    (double)82992./3137161264. * 16384.,
    (double)74471./3137161264. * 16384.,
    (double)139659./3137161264. * 16384.,
    (double)96498./3137161264. * 16384.,
    (double)6635./3137161264. * 16384.,
    (double)55827./3137161264. * 16384.,
    (double)101301./3137161264. * 16384.,
    (double)125638./3137161264. * 16384.,
    (double)108072./3137161264. * 16384.,
    (double)91511./3137161264. * 16384.,
    (double)197381./3137161264. * 16384.,
    (double)154406./3137161264. * 16384.,
    (double)78086./3137161264. * 16384.,
    (double)60545./3137161264. * 16384.,
    (double)106017./3137161264. * 16384.,
    (double)99135./3137161264. * 16384.,
    (double)61106./3137161264. * 16384.,
    (double)56463./3137161264. * 16384.,
    (double)83665./3137161264. * 16384.,
    (double)108041./3137161264. * 16384.,
    (double)10784./3137161264. * 16384.,
    (double)58771./3137161264. * 16384.,
    (double)90674./3137161264. * 16384.,
    (double)102784./3137161264. * 16384.,
    (double)80747./3137161264. * 16384.,
    (double)79323./3137161264. * 16384.,
    (double)146029./3137161264. * 16384.,
    (double)9364./3137161264. * 16384.,
    (double)7195./3137161264. * 16384.,
    (double)4346./3137161264. * 16384.,
    (double)8635./3137161264. * 16384.,
    (double)5686./3137161264. * 16384.,
    (double)5160./3137161264. * 16384.,
    (double)4342./3137161264. * 16384.,
    (double)5531./3137161264. * 16384.,
    (double)7341./3137161264. * 16384.,
    (double)797./3137161264. * 16384.,
    (double)5215./3137161264. * 16384.,
    (double)7423./3137161264. * 16384.,
    (double)8965./3137161264. * 16384.,
    (double)8893./3137161264. * 16384.,
    (double)6259./3137161264. * 16384.,
    (double)10767./3137161264. * 16384.,
    (double)86966./3137161264. * 16384.,
    (double)71954./3137161264. * 16384.,
    (double)56869./3137161264. * 16384.,
    (double)91075./3137161264. * 16384.,
    (double)5493./3137161264. * 16384.,
    (double)4476./3137161264. * 16384.,
    (double)4378./3137161264. * 16384.,
    (double)7886./3137161264. * 16384.,
    (double)74551./3137161264. * 16384.,
    (double)6042./3137161264. * 16384.,
    (double)49126./3137161264. * 16384.,
    (double)69024./3137161264. * 16384.,
    (double)65404./3137161264. * 16384.,
    (double)69702./3137161264. * 16384.,
    (double)63610./3137161264. * 16384.,
    (double)99646./3137161264. * 16384.,
    (double)103428./3137161264. * 16384.,
    (double)62223./3137161264. * 16384.,
    (double)64874./3137161264. * 16384.,
    (double)114701./3137161264. * 16384.,
    (double)101824./3137161264. * 16384.,
    (double)71962./3137161264. * 16384.,
    (double)68982./3137161264. * 16384.,
    (double)113129./3137161264. * 16384.,
    (double)118904./3137161264. * 16384.,
    (double)7563./3137161264. * 16384.,
    (double)76039./3137161264. * 16384.,
    (double)120088./3137161264. * 16384.,
    (double)108086./3137161264. * 16384.,
    (double)85521./3137161264. * 16384.,
    (double)107112./3137161264. * 16384.,
    (double)185083./3137161264. * 16384.,
    (double)274679./3137161264. * 16384.,
    (double)117573./3137161264. * 16384.,
    (double)99339./3137161264. * 16384.,
    (double)207846./3137161264. * 16384.,
    (double)113192./3137161264. * 16384.,
    (double)68135./3137161264. * 16384.,
    (double)66141./3137161264. * 16384.,
    (double)92265./3137161264. * 16384.,
    (double)136529./3137161264. * 16384.,
    (double)11095./3137161264. * 16384.,
    (double)65514./3137161264. * 16384.,
    (double)119573./3137161264. * 16384.,
    (double)201591./3137161264. * 16384.,
    (double)125112./3137161264. * 16384.,
    (double)113940./3137161264. * 16384.,
    (double)305279./3137161264. * 16384.,
    (double)147973./3137161264. * 16384.,
    (double)98244./3137161264. * 16384.,
    (double)61523./3137161264. * 16384.,
    (double)114075./3137161264. * 16384.,
    (double)79981./3137161264. * 16384.,
    (double)56482./3137161264. * 16384.,
    (double)52208./3137161264. * 16384.,
    (double)69975./3137161264. * 16384.,
    (double)91614./3137161264. * 16384.,
    (double)6114./3137161264. * 16384.,
    (double)58759./3137161264. * 16384.,
    (double)98721./3137161264. * 16384.,
    (double)112729./3137161264. * 16384.,
    (double)98085./3137161264. * 16384.,
    (double)73423./3137161264. * 16384.,
    (double)146618./3137161264. * 16384.,
    (double)149419./3137161264. * 16384.,
    (double)117206./3137161264. * 16384.,
    (double)93014./3137161264. * 16384.,
    (double)167351./3137161264. * 16384.,
    (double)9258./3137161264. * 16384.,
    (double)7799./3137161264. * 16384.,
    (double)5609./3137161264. * 16384.,
    (double)12035./3137161264. * 16384.,
    (double)132983./3137161264. * 16384.,
    (double)8471./3137161264. * 16384.,
    (double)73241./3137161264. * 16384.,
    (double)120848./3137161264. * 16384.,
    (double)136980./3137161264. * 16384.,
    (double)131365./3137161264. * 16384.,
    (double)109762./3137161264. * 16384.,
    (double)185605./3137161264. * 16384.,
    (double)296490./3137161264. * 16384.,
    (double)133822./3137161264. * 16384.,
    (double)143574./3137161264. * 16384.,
    (double)322349./3137161264. * 16384.,
    (double)177763./3137161264. * 16384.,
    (double)130900./3137161264. * 16384.,
    (double)117096./3137161264. * 16384.,
    (double)201682./3137161264. * 16384.,
    (double)238208./3137161264. * 16384.,
    (double)12082./3137161264. * 16384.,
    (double)152999./3137161264. * 16384.,
    (double)279000./3137161264. * 16384.,
    (double)415521./3137161264. * 16384.,
    (double)258149./3137161264. * 16384.,
    (double)282091./3137161264. * 16384.,
    (double)540579./3137161264. * 16384.,
    (double)350693./3137161264. * 16384.,
    (double)202327./3137161264. * 16384.,
    (double)183428./3137161264. * 16384.,
    (double)303799./3137161264. * 16384.,
    (double)203861./3137161264. * 16384.,
    (double)122099./3137161264. * 16384.,
    (double)105686./3137161264. * 16384.,
    (double)135959./3137161264. * 16384.,
    (double)170217./3137161264. * 16384.,
    (double)17396./3137161264. * 16384.,
    (double)97913./3137161264. * 16384.,
    (double)146597./3137161264. * 16384.,
    (double)252184./3137161264. * 16384.,
    (double)192564./3137161264. * 16384.,
    (double)126334./3137161264. * 16384.,
    (double)221366./3137161264. * 16384.,
    (double)211334./3137161264. * 16384.,
    (double)129650./3137161264. * 16384.,
    (double)97119./3137161264. * 16384.,
    (double)129365./3137161264. * 16384.,
    (double)136680./3137161264. * 16384.,
    (double)85756./3137161264. * 16384.,
    (double)76891./3137161264. * 16384.,
    (double)83220./3137161264. * 16384.,
    (double)109359./3137161264. * 16384.,
    (double)9951./3137161264. * 16384.,
    (double)79110./3137161264. * 16384.,
    (double)94134./3137161264. * 16384.,
    (double)98878./3137161264. * 16384.,
    (double)96704./3137161264. * 16384.,
    (double)80948./3137161264. * 16384.,
    (double)117602./3137161264. * 16384.,
    (double)128605./3137161264. * 16384.,
    (double)95285./3137161264. * 16384.,
    (double)78487./3137161264. * 16384.,
    (double)117854./3137161264. * 16384.,
    (double)11946./3137161264. * 16384.,
    (double)8979./3137161264. * 16384.,
    (double)8039./3137161264. * 16384.,
    (double)14478./3137161264. * 16384.,
    (double)81654./3137161264. * 16384.,
    (double)9138./3137161264. * 16384.,
    (double)53453./3137161264. * 16384.,
    (double)67656./3137161264. * 16384.,
    (double)81520./3137161264. * 16384.,
    (double)86285./3137161264. * 16384.,
    (double)74429./3137161264. * 16384.,
    (double)104692./3137161264. * 16384.,
    (double)187023./3137161264. * 16384.,
    (double)95631./3137161264. * 16384.,
    (double)79957./3137161264. * 16384.,
    (double)168123./3137161264. * 16384.,
    (double)168977./3137161264. * 16384.,
    (double)101492./3137161264. * 16384.,
    (double)79424./3137161264. * 16384.,
    (double)128653./3137161264. * 16384.,
    (double)100510./3137161264. * 16384.,
    (double)8461./3137161264. * 16384.,
    (double)66015./3137161264. * 16384.,
    (double)99904./3137161264. * 16384.,
    (double)143921./3137161264. * 16384.,
    (double)95261./3137161264. * 16384.,
    (double)107226./3137161264. * 16384.,
    (double)209372./3137161264. * 16384.,
    (double)244894./3137161264. * 16384.,
    (double)142026./3137161264. * 16384.,
    (double)101243./3137161264. * 16384.,
    (double)144379./3137161264. * 16384.,
    (double)140579./3137161264. * 16384.,
    (double)96978./3137161264. * 16384.,
    (double)72280./3137161264. * 16384.,
    (double)85705./3137161264. * 16384.,
    (double)118277./3137161264. * 16384.,
    (double)16019./3137161264. * 16384.,
    (double)85272./3137161264. * 16384.,
    (double)106715./3137161264. * 16384.,
    (double)106314./3137161264. * 16384.,
    (double)116011./3137161264. * 16384.,
    (double)76597./3137161264. * 16384.,
    (double)127979./3137161264. * 16384.,
    (double)161896./3137161264. * 16384.,
    (double)105148./3137161264. * 16384.,
    (double)70617./3137161264. * 16384.,
    (double)92610./3137161264. * 16384.,
    (double)98634./3137161264. * 16384.,
    (double)69513./3137161264. * 16384.,
    (double)62971./3137161264. * 16384.,
    (double)68728./3137161264. * 16384.,
    (double)105507./3137161264. * 16384.,
    (double)11283./3137161264. * 16384.,
    (double)80730./3137161264. * 16384.,
    (double)101894./3137161264. * 16384.,
    (double)67412./3137161264. * 16384.,
    (double)76005./3137161264. * 16384.,
    (double)63388./3137161264. * 16384.,
    (double)84885./3137161264. * 16384.,
    (double)99167./3137161264. * 16384.,
    (double)93012./3137161264. * 16384.,
    (double)61249./3137161264. * 16384.,
    (double)78238./3137161264. * 16384.,
    (double)10836./3137161264. * 16384.,
    (double)9887./3137161264. * 16384.,
    (double)7500./3137161264. * 16384.,
    (double)9028./3137161264. * 16384.,
    (double)151373./3137161264. * 16384.,
    (double)23254./3137161264. * 16384.,
    (double)63357./3137161264. * 16384.,
    (double)76699./3137161264. * 16384.,
    (double)72973./3137161264. * 16384.,
    (double)100972./3137161264. * 16384.,
    (double)66638./3137161264. * 16384.,
    (double)76814./3137161264. * 16384.,
    (double)92762./3137161264. * 16384.,
    (double)66984./3137161264. * 16384.,
    (double)42948./3137161264. * 16384.,
    (double)73555./3137161264. * 16384.,
    (double)103156./3137161264. * 16384.,
    (double)75553./3137161264. * 16384.,
    (double)52480./3137161264. * 16384.,
    (double)78278./3137161264. * 16384.,
    (double)88105./3137161264. * 16384.,
    (double)8171./3137161264. * 16384.,
    (double)53415./3137161264. * 16384.,
    (double)76327./3137161264. * 16384.,
    (double)78744./3137161264. * 16384.,
    (double)71886./3137161264. * 16384.,
    (double)72671./3137161264. * 16384.,
    (double)127453./3137161264. * 16384.,
    (double)153170./3137161264. * 16384.,
    (double)76257./3137161264. * 16384.,
    (double)60167./3137161264. * 16384.,
    (double)91804./3137161264. * 16384.,
    (double)121053./3137161264. * 16384.,
    (double)70605./3137161264. * 16384.,
    (double)68799./3137161264. * 16384.,
    (double)80367./3137161264. * 16384.,
    (double)96636./3137161264. * 16384.,
    (double)12099./3137161264. * 16384.,
    (double)51567./3137161264. * 16384.,
    (double)71070./3137161264. * 16384.,
    (double)87099./3137161264. * 16384.,
    (double)81126./3137161264. * 16384.,
    (double)66365./3137161264. * 16384.,
    (double)129279./3137161264. * 16384.,
    (double)10785./3137161264. * 16384.,
    (double)8814./3137161264. * 16384.,
    (double)5700./3137161264. * 16384.,
    (double)9013./3137161264. * 16384.,
    (double)9232./3137161264. * 16384.,
    (double)9535./3137161264. * 16384.,
    (double)7092./3137161264. * 16384.,
    (double)8306./3137161264. * 16384.,
    (double)8142./3137161264. * 16384.,
    (double)1785./3137161264. * 16384.,
    (double)6380./3137161264. * 16384.,
    (double)8425./3137161264. * 16384.,
    (double)8233./3137161264. * 16384.,
    (double)12640./3137161264. * 16384.,
    (double)8462./3137161264. * 16384.,
    (double)12559./3137161264. * 16384.,
    (double)70632./3137161264. * 16384.,
    (double)58639./3137161264. * 16384.,
    (double)53866./3137161264. * 16384.,
    (double)60752./3137161264. * 16384.,
    (double)7025./3137161264. * 16384.,
    (double)5709./3137161264. * 16384.,
    (double)5861./3137161264. * 16384.,
    (double)7784./3137161264. * 16384.,
    (double)66069./3137161264. * 16384.,
    (double)7396./3137161264. * 16384.,
    (double)43421./3137161264. * 16384.,
    (double)54451./3137161264. * 16384.,
    (double)50119./3137161264. * 16384.,
    (double)61698./3137161264. * 16384.,
    (double)64452./3137161264. * 16384.,
    (double)76869./3137161264. * 16384.,
    (double)69421./3137161264. * 16384.,
    (double)44862./3137161264. * 16384.,
    (double)42515./3137161264. * 16384.,
    (double)68728./3137161264. * 16384.,
    (double)83685./3137161264. * 16384.,
    (double)65338./3137161264. * 16384.,
    (double)57633./3137161264. * 16384.,
    (double)76542./3137161264. * 16384.,
    (double)81539./3137161264. * 16384.,
    (double)7921./3137161264. * 16384.,
    (double)57093./3137161264. * 16384.,
    (double)79708./3137161264. * 16384.,
    (double)74540./3137161264. * 16384.,
    (double)73712./3137161264. * 16384.,
    (double)88305./3137161264. * 16384.,
    (double)135156./3137161264. * 16384.,
    (double)173868./3137161264. * 16384.,
    (double)73621./3137161264. * 16384.,
    (double)59469./3137161264. * 16384.,
    (double)115064./3137161264. * 16384.,
    (double)80754./3137161264. * 16384.,
    (double)48283./3137161264. * 16384.,
    (double)43478./3137161264. * 16384.,
    (double)60725./3137161264. * 16384.,
    (double)88025./3137161264. * 16384.,
    (double)9375./3137161264. * 16384.,
    (double)42113./3137161264. * 16384.,
    (double)66034./3137161264. * 16384.,
    (double)105211./3137161264. * 16384.,
    (double)75749./3137161264. * 16384.,
    (double)57326./3137161264. * 16384.,
    (double)136332./3137161264. * 16384.,
    (double)127453./3137161264. * 16384.,
    (double)85325./3137161264. * 16384.,
    (double)61908./3137161264. * 16384.,
    (double)96674./3137161264. * 16384.,
    (double)87745./3137161264. * 16384.,
    (double)73853./3137161264. * 16384.,
    (double)55990./3137161264. * 16384.,
    (double)76381./3137161264. * 16384.,
    (double)73029./3137161264. * 16384.,
    (double)7511./3137161264. * 16384.,
    (double)53902./3137161264. * 16384.,
    (double)81986./3137161264. * 16384.,
    (double)71336./3137161264. * 16384.,
    (double)81312./3137161264. * 16384.,
    (double)63137./3137161264. * 16384.,
    (double)105990./3137161264. * 16384.,
    (double)72450./3137161264. * 16384.,
    (double)59517./3137161264. * 16384.,
    (double)51280./3137161264. * 16384.,
    (double)78389./3137161264. * 16384.,
    (double)6135./3137161264. * 16384.,
    (double)4849./3137161264. * 16384.,
    (double)4972./3137161264. * 16384.,
    (double)7810./3137161264. * 16384.,
    (double)60318./3137161264. * 16384.,
    (double)6549./3137161264. * 16384.,
    (double)40120./3137161264. * 16384.,
    (double)60561./3137161264. * 16384.,
    (double)54411./3137161264. * 16384.,
    (double)65506./3137161264. * 16384.,
    (double)62132./3137161264. * 16384.,
    (double)88583./3137161264. * 16384.,
    (double)109575./3137161264. * 16384.,
    (double)60394./3137161264. * 16384.,
    (double)56993./3137161264. * 16384.,
    (double)114590./3137161264. * 16384.,
    (double)72600./3137161264. * 16384.,
    (double)56207./3137161264. * 16384.,
    (double)49209./3137161264. * 16384.,
    (double)76154./3137161264. * 16384.,
    (double)92605./3137161264. * 16384.,
    (double)7193./3137161264. * 16384.,
    (double)67852./3137161264. * 16384.,
    (double)110160./3137161264. * 16384.,
    (double)127870./3137161264. * 16384.,
    (double)105396./3137161264. * 16384.,
    (double)118932./3137161264. * 16384.,
    (double)235052./3137161264. * 16384.,
    (double)243053./3137161264. * 16384.,
    (double)146456./3137161264. * 16384.,
    (double)107973./3137161264. * 16384.,
    (double)174849./3137161264. * 16384.,
    (double)146233./3137161264. * 16384.,
    (double)110225./3137161264. * 16384.,
    (double)79817./3137161264. * 16384.,
    (double)92349./3137161264. * 16384.,
    (double)99348./3137161264. * 16384.,
    (double)10029./3137161264. * 16384.,
    (double)48091./3137161264. * 16384.,
    (double)76718./3137161264. * 16384.,
    (double)125139./3137161264. * 16384.,
    (double)102945./3137161264. * 16384.,
    (double)70255./3137161264. * 16384.,
    (double)126341./3137161264. * 16384.,
    (double)166582./3137161264. * 16384.,
    (double)117678./3137161264. * 16384.,
    (double)74019./3137161264. * 16384.,
    (double)96612./3137161264. * 16384.,
    (double)117239./3137161264. * 16384.,
    (double)91677./3137161264. * 16384.,
    (double)76266./3137161264. * 16384.,
    (double)77391./3137161264. * 16384.,
    (double)80577./3137161264. * 16384.,
    (double)10209./3137161264. * 16384.,
    (double)61736./3137161264. * 16384.,
    (double)78695./3137161264. * 16384.,
    (double)60741./3137161264. * 16384.,
    (double)80126./3137161264. * 16384.,
    (double)58564./3137161264. * 16384.,
    (double)83524./3137161264. * 16384.,
    (double)75707./3137161264. * 16384.,
    (double)70479./3137161264. * 16384.,
    (double)57643./3137161264. * 16384.,
    (double)73500./3137161264. * 16384.,
    (double)7219./3137161264. * 16384.,
    (double)8489./3137161264. * 16384.,
    (double)6514./3137161264. * 16384.,
    (double)9331./3137161264. * 16384.,
    (double)48296./3137161264. * 16384.,
    (double)5441./3137161264. * 16384.,
    (double)35050./3137161264. * 16384.,
    (double)44066./3137161264. * 16384.,
    (double)47465./3137161264. * 16384.,
    (double)54978./3137161264. * 16384.,
    (double)47450./3137161264. * 16384.,
    (double)71435./3137161264. * 16384.,
    (double)87890./3137161264. * 16384.,
    (double)51934./3137161264. * 16384.,
    (double)44016./3137161264. * 16384.,
    (double)91116./3137161264. * 16384.,
    (double)85619./3137161264. * 16384.,
    (double)80236./3137161264. * 16384.,
    (double)51007./3137161264. * 16384.,
    (double)72232./3137161264. * 16384.,
    (double)57803./3137161264. * 16384.,
    (double)5206./3137161264. * 16384.,
    (double)38640./3137161264. * 16384.,
    (double)55989./3137161264. * 16384.,
    (double)79028./3137161264. * 16384.,
    (double)56826./3137161264. * 16384.,
    (double)63553./3137161264. * 16384.,
    (double)124452./3137161264. * 16384.,
    (double)168298./3137161264. * 16384.,
    (double)129802./3137161264. * 16384.,
    (double)64151./3137161264. * 16384.,
    (double)99457./3137161264. * 16384.,
    (double)120977./3137161264. * 16384.,
    (double)127230./3137161264. * 16384.,
    (double)66078./3137161264. * 16384.,
    (double)72308./3137161264. * 16384.,
    (double)73534./3137161264. * 16384.,
    (double)9292./3137161264. * 16384.,
    (double)45029./3137161264. * 16384.,
    (double)65733./3137161264. * 16384.,
    (double)64654./3137161264. * 16384.,
    (double)75574./3137161264. * 16384.,
    (double)43750./3137161264. * 16384.,
    (double)93127./3137161264. * 16384.,
    (double)134853./3137161264. * 16384.,
    (double)118853./3137161264. * 16384.,
    (double)62444./3137161264. * 16384.,
    (double)76143./3137161264. * 16384.,
    (double)95457./3137161264. * 16384.,
    (double)53166./3137161264. * 16384.,
    (double)60789./3137161264. * 16384.,
    (double)68834./3137161264. * 16384.,
    (double)74144./3137161264. * 16384.,
    (double)11896./3137161264. * 16384.,
    (double)56303./3137161264. * 16384.,
    (double)74849./3137161264. * 16384.,
    (double)49626./3137161264. * 16384.,
    (double)77359./3137161264. * 16384.,
    (double)47055./3137161264. * 16384.,
    (double)67430./3137161264. * 16384.,
    (double)83127./3137161264. * 16384.,
    (double)88627./3137161264. * 16384.,
    (double)52039./3137161264. * 16384.,
    (double)66237./3137161264. * 16384.,
    (double)10274./3137161264. * 16384.,
    (double)12098./3137161264. * 16384.,
    (double)7291./3137161264. * 16384.,
    (double)9135./3137161264. * 16384.,
    (double)66041./3137161264. * 16384.,
    (double)10218./3137161264. * 16384.,
    (double)44364./3137161264. * 16384.,
    (double)60606./3137161264. * 16384.,
    (double)42847./3137161264. * 16384.,
    (double)80247./3137161264. * 16384.,
    (double)55509./3137161264. * 16384.,
    (double)69950./3137161264. * 16384.,
    (double)72095./3137161264. * 16384.,
    (double)54140./3137161264. * 16384.,
    (double)35592./3137161264. * 16384.,
    (double)59747./3137161264. * 16384.,
    (double)77628./3137161264. * 16384.,
    (double)84998./3137161264. * 16384.,
    (double)47591./3137161264. * 16384.,
    (double)61548./3137161264. * 16384.,
    (double)59159./3137161264. * 16384.,
    (double)5763./3137161264. * 16384.,
    (double)39609./3137161264. * 16384.,
    (double)57056./3137161264. * 16384.,
    (double)51123./3137161264. * 16384.,
    (double)55883./3137161264. * 16384.,
    (double)48002./3137161264. * 16384.,
    (double)91106./3137161264. * 16384.,
    (double)122038./3137161264. * 16384.,
    (double)72449./3137161264. * 16384.,
    (double)47813./3137161264. * 16384.,
    (double)73785./3137161264. * 16384.,
    (double)105263./3137161264. * 16384.,
    (double)86440./3137161264. * 16384.,
    (double)69720./3137161264. * 16384.,
    (double)69570./3137161264. * 16384.,
    (double)87945./3137161264. * 16384.,
    (double)14293./3137161264. * 16384.,
    (double)45485./3137161264. * 16384.,
    (double)58873./3137161264. * 16384.,
    (double)68184./3137161264. * 16384.,
    (double)72392./3137161264. * 16384.,
    (double)56228./3137161264. * 16384.,
    (double)94591./3137161264. * 16384.,
    (double)12111./3137161264. * 16384.,
    (double)10632./3137161264. * 16384.,
    (double)5151./3137161264. * 16384.,
    (double)8573./3137161264. * 16384.,
    (double)9437./3137161264. * 16384.,
    (double)13512./3137161264. * 16384.,
    (double)9063./3137161264. * 16384.,
    (double)7403./3137161264. * 16384.,
    (double)9553./3137161264. * 16384.,
    (double)5012./3137161264. * 16384.,
    (double)7852./3137161264. * 16384.,
    (double)7873./3137161264. * 16384.,
    (double)5669./3137161264. * 16384.,
    (double)14084./3137161264. * 16384.,
    (double)6639./3137161264. * 16384.,
    (double)8108./3137161264. * 16384.,
    (double)86667./3137161264. * 16384.,
    (double)79417./3137161264. * 16384.,
    (double)59937./3137161264. * 16384.,
    (double)68779./3137161264. * 16384.,
    (double)9298./3137161264. * 16384.,
    (double)10076./3137161264. * 16384.,
    (double)8308./3137161264. * 16384.,
    (double)8753./3137161264. * 16384.,
    (double)65463./3137161264. * 16384.,
    (double)8833./3137161264. * 16384.,
    (double)47905./3137161264. * 16384.,
    (double)56731./3137161264. * 16384.,
    (double)46710./3137161264. * 16384.,
    (double)71731./3137161264. * 16384.,
    (double)73670./3137161264. * 16384.,
    (double)74679./3137161264. * 16384.,
    (double)66883./3137161264. * 16384.,
    (double)42829./3137161264. * 16384.,
    (double)42587./3137161264. * 16384.,
    (double)65301./3137161264. * 16384.,
    (double)81571./3137161264. * 16384.,
    (double)82215./3137161264. * 16384.,
    (double)68632./3137161264. * 16384.,
    (double)75917./3137161264. * 16384.,
    (double)74536./3137161264. * 16384.,
    (double)7655./3137161264. * 16384.,
    (double)58768./3137161264. * 16384.,
    (double)75735./3137161264. * 16384.,
    (double)62413./3137161264. * 16384.,
    (double)62207./3137161264. * 16384.,
    (double)82071./3137161264. * 16384.,
    (double)113438./3137161264. * 16384.,
    (double)102045./3137161264. * 16384.,
    (double)57254./3137161264. * 16384.,
    (double)42146./3137161264. * 16384.,
    (double)70038./3137161264. * 16384.,
    (double)65309./3137161264. * 16384.,
    (double)45297./3137161264. * 16384.,
    (double)35722./3137161264. * 16384.,
    (double)45919./3137161264. * 16384.,
    (double)57455./3137161264. * 16384.,
    (double)5633./3137161264. * 16384.,
    (double)31548./3137161264. * 16384.,
    (double)44667./3137161264. * 16384.,
    (double)65650./3137161264. * 16384.,
    (double)49470./3137161264. * 16384.,
    (double)43254./3137161264. * 16384.,
    (double)83541./3137161264. * 16384.,
    (double)99257./3137161264. * 16384.,
    (double)75563./3137161264. * 16384.,
    (double)49742./3137161264. * 16384.,
    (double)71241./3137161264. * 16384.,
    (double)71969./3137161264. * 16384.,
    (double)77779./3137161264. * 16384.,
    (double)58671./3137161264. * 16384.,
    (double)74399./3137161264. * 16384.,
    (double)56042./3137161264. * 16384.,
    (double)9450./3137161264. * 16384.,
    (double)46646./3137161264. * 16384.,
    (double)61978./3137161264. * 16384.,
    (double)45502./3137161264. * 16384.,
    (double)65509./3137161264. * 16384.,
    (double)50604./3137161264. * 16384.,
    (double)70926./3137161264. * 16384.,
    (double)55333./3137161264. * 16384.,
    (double)56270./3137161264. * 16384.,
    (double)44954./3137161264. * 16384.,
    (double)57834./3137161264. * 16384.,
    (double)4302./3137161264. * 16384.,
    (double)4849./3137161264. * 16384.,
    (double)3839./3137161264. * 16384.,
    (double)5507./3137161264. * 16384.,
    (double)43811./3137161264. * 16384.,
    (double)4274./3137161264. * 16384.,
    (double)37498./3137161264. * 16384.,
    (double)47329./3137161264. * 16384.,
    (double)41247./3137161264. * 16384.,
    (double)53862./3137161264. * 16384.,
    (double)65715./3137161264. * 16384.,
    (double)73403./3137161264. * 16384.,
    (double)75270./3137161264. * 16384.,
    (double)42484./3137161264. * 16384.,
    (double)41356./3137161264. * 16384.,
    (double)69698./3137161264. * 16384.,
    (double)57251./3137161264. * 16384.,
    (double)51516./3137161264. * 16384.,
    (double)41817./3137161264. * 16384.,
    (double)59794./3137161264. * 16384.,
    (double)60287./3137161264. * 16384.,
    (double)4951./3137161264. * 16384.,
    (double)48273./3137161264. * 16384.,
    (double)76684./3137161264. * 16384.,
    (double)78403./3137161264. * 16384.,
    (double)79139./3137161264. * 16384.,
    (double)85850./3137161264. * 16384.,
    (double)143101./3137161264. * 16384.,
    (double)150395./3137161264. * 16384.,
    (double)104410./3137161264. * 16384.,
    (double)70590./3137161264. * 16384.,
    (double)130897./3137161264. * 16384.,
    (double)75948./3137161264. * 16384.,
    (double)59967./3137161264. * 16384.,
    (double)42008./3137161264. * 16384.,
    (double)59087./3137161264. * 16384.,
    (double)68889./3137161264. * 16384.,
    (double)7171./3137161264. * 16384.,
    (double)38675./3137161264. * 16384.,
    (double)56545./3137161264. * 16384.,
    (double)80892./3137161264. * 16384.,
    (double)73001./3137161264. * 16384.,
    (double)47722./3137161264. * 16384.,
    (double)86080./3137161264. * 16384.,
    (double)121126./3137161264. * 16384.,
    (double)95291./3137161264. * 16384.,
    (double)52673./3137161264. * 16384.,
    (double)78099./3137161264. * 16384.,
    (double)78180./3137161264. * 16384.,
    (double)72079./3137161264. * 16384.,
    (double)54016./3137161264. * 16384.,
    (double)59271./3137161264. * 16384.,
    (double)80575./3137161264. * 16384.,
    (double)10249./3137161264. * 16384.,
    (double)71015./3137161264. * 16384.,
    (double)72833./3137161264. * 16384.,
    (double)60457./3137161264. * 16384.,
    (double)89343./3137161264. * 16384.,
    (double)49225./3137161264. * 16384.,
    (double)75075./3137161264. * 16384.,
    (double)68528./3137161264. * 16384.,
    (double)79467./3137161264. * 16384.,
    (double)65715./3137161264. * 16384.,
    (double)87335./3137161264. * 16384.,
    (double)7381./3137161264. * 16384.,
    (double)9021./3137161264. * 16384.,
    (double)9994./3137161264. * 16384.,
    (double)14798./3137161264. * 16384.,
    (double)50688./3137161264. * 16384.,
    (double)6676./3137161264. * 16384.,
    (double)39243./3137161264. * 16384.,
    (double)47319./3137161264. * 16384.,
    (double)37946./3137161264. * 16384.,
    (double)61624./3137161264. * 16384.,
    (double)61178./3137161264. * 16384.,
    (double)63743./3137161264. * 16384.,
    (double)80018./3137161264. * 16384.,
    (double)52429./3137161264. * 16384.,
    (double)45294./3137161264. * 16384.,
    (double)96719./3137161264. * 16384.,
    (double)65890./3137161264. * 16384.,
    (double)57926./3137161264. * 16384.,
    (double)55199./3137161264. * 16384.,
    (double)85115./3137161264. * 16384.,
    (double)59909./3137161264. * 16384.,
    (double)5993./3137161264. * 16384.,
    (double)45025./3137161264. * 16384.,
    (double)69588./3137161264. * 16384.,
    (double)75897./3137161264. * 16384.,
    (double)64078./3137161264. * 16384.,
    (double)76627./3137161264. * 16384.,
    (double)166551./3137161264. * 16384.,
    (double)7552./3137161264. * 16384.,
    (double)7066./3137161264. * 16384.,
    (double)3834./3137161264. * 16384.,
    (double)6751./3137161264. * 16384.,
    (double)7198./3137161264. * 16384.,
    (double)7881./3137161264. * 16384.,
    (double)4758./3137161264. * 16384.,
    (double)5222./3137161264. * 16384.,
    (double)4959./3137161264. * 16384.,
    (double)1032./3137161264. * 16384.,
    (double)3795./3137161264. * 16384.,
    (double)4904./3137161264. * 16384.,
    (double)5411./3137161264. * 16384.,
    (double)6928./3137161264. * 16384.,
    (double)4109./3137161264. * 16384.,
    (double)6953./3137161264. * 16384.,
    (double)8310./3137161264. * 16384.,
    (double)8512./3137161264. * 16384.,
    (double)4077./3137161264. * 16384.,
    (double)5190./3137161264. * 16384.,
    (double)8935./3137161264. * 16384.,
    (double)11273./3137161264. * 16384.,
    (double)6510./3137161264. * 16384.,
    (double)6275./3137161264. * 16384.,
    (double)7397./3137161264. * 16384.,
    (double)2138./3137161264. * 16384.,
    (double)7621./3137161264. * 16384.,
    (double)7161./3137161264. * 16384.,
    (double)5320./3137161264. * 16384.,
    (double)8765./3137161264. * 16384.,
    (double)4631./3137161264. * 16384.,
    (double)6481./3137161264. * 16384.,
    (double)4661./3137161264. * 16384.,
    (double)7051./3137161264. * 16384.,
    (double)6095./3137161264. * 16384.,
    (double)5768./3137161264. * 16384.,
    (double)1053./3137161264. * 16384.,
    (double)2044./3137161264. * 16384.,
    (double)2869./3137161264. * 16384.,
    (double)1608./3137161264. * 16384.,
    (double)6493./3137161264. * 16384.,
    (double)1828./3137161264. * 16384.,
    (double)8561./3137161264. * 16384.,
    (double)7455./3137161264. * 16384.,
    (double)4024./3137161264. * 16384.,
    (double)7589./3137161264. * 16384.,
    (double)6588./3137161264. * 16384.,
    (double)6425./3137161264. * 16384.,
    (double)7002./3137161264. * 16384.,
    (double)5467./3137161264. * 16384.,
    (double)4084./3137161264. * 16384.,
    (double)8451./3137161264. * 16384.,
    (double)9045./3137161264. * 16384.,
    (double)10721./3137161264. * 16384.,
    (double)9579./3137161264. * 16384.,
    (double)13147./3137161264. * 16384.,
    (double)5936./3137161264. * 16384.,
    (double)1041./3137161264. * 16384.,
    (double)5716./3137161264. * 16384.,
    (double)8086./3137161264. * 16384.,
    (double)6169./3137161264. * 16384.,
    (double)6688./3137161264. * 16384.,
    (double)6800./3137161264. * 16384.,
    (double)12691./3137161264. * 16384.,
    (double)96701./3137161264. * 16384.,
    (double)71098./3137161264. * 16384.,
    (double)45351./3137161264. * 16384.,
    (double)57636./3137161264. * 16384.,
    (double)67734./3137161264. * 16384.,
    (double)74519./3137161264. * 16384.,
    (double)54399./3137161264. * 16384.,
    (double)54624./3137161264. * 16384.,
    (double)74378./3137161264. * 16384.,
    (double)11492./3137161264. * 16384.,
    (double)50689./3137161264. * 16384.,
    (double)65092./3137161264. * 16384.,
    (double)55186./3137161264. * 16384.,
    (double)68562./3137161264. * 16384.,
    (double)53317./3137161264. * 16384.,
    (double)85117./3137161264. * 16384.,
    (double)6950./3137161264. * 16384.,
    (double)8251./3137161264. * 16384.,
    (double)4204./3137161264. * 16384.,
    (double)5311./3137161264. * 16384.,
    (double)5657./3137161264. * 16384.,
    (double)8938./3137161264. * 16384.,
    (double)6792./3137161264. * 16384.,
    (double)4947./3137161264. * 16384.,
    (double)6587./3137161264. * 16384.,
    (double)1772./3137161264. * 16384.,
    (double)7558./3137161264. * 16384.,
    (double)7264./3137161264. * 16384.,
    (double)5767./3137161264. * 16384.,
    (double)10234./3137161264. * 16384.,
    (double)6379./3137161264. * 16384.,
    (double)7823./3137161264. * 16384.,
    (double)61556./3137161264. * 16384.,
    (double)84588./3137161264. * 16384.,
    (double)53037./3137161264. * 16384.,
    (double)54993./3137161264. * 16384.,
    (double)6594./3137161264. * 16384.,
    (double)13264./3137161264. * 16384.,
    (double)9701./3137161264. * 16384.,
    (double)7723./3137161264. * 16384.,
    (double)59940./3137161264. * 16384.,
    (double)9283./3137161264. * 16384.,
    (double)37833./3137161264. * 16384.,
    (double)48300./3137161264. * 16384.,
    (double)35255./3137161264. * 16384.,
    (double)64038./3137161264. * 16384.,
    (double)54549./3137161264. * 16384.,
    (double)61691./3137161264. * 16384.,
    (double)56476./3137161264. * 16384.,
    (double)45107./3137161264. * 16384.,
    (double)38841./3137161264. * 16384.,
    (double)53003./3137161264. * 16384.,
    (double)67969./3137161264. * 16384.,
    (double)85459./3137161264. * 16384.,
    (double)61679./3137161264. * 16384.,
    (double)73484./3137161264. * 16384.,
    (double)78858./3137161264. * 16384.,
    (double)9730./3137161264. * 16384.,
    (double)65214./3137161264. * 16384.,
    (double)81338./3137161264. * 16384.,
    (double)56916./3137161264. * 16384.,
    (double)62429./3137161264. * 16384.,
    (double)74369./3137161264. * 16384.,
    (double)109287./3137161264. * 16384.,
    (double)91315./3137161264. * 16384.,
    (double)60002./3137161264. * 16384.,
    (double)37117./3137161264. * 16384.,
    (double)69214./3137161264. * 16384.,
    (double)51947./3137161264. * 16384.,
    (double)42121./3137161264. * 16384.,
    (double)27870./3137161264. * 16384.,
    (double)36951./3137161264. * 16384.,
    (double)58075./3137161264. * 16384.,
    (double)6332./3137161264. * 16384.,
    (double)32636./3137161264. * 16384.,
    (double)53935./3137161264. * 16384.,
    (double)68950./3137161264. * 16384.,
    (double)60966./3137161264. * 16384.,
    (double)38063./3137161264. * 16384.,
    (double)91543./3137161264. * 16384.,
    (double)97234./3137161264. * 16384.,
    (double)81498./3137161264. * 16384.,
    (double)46388./3137161264. * 16384.,
    (double)69071./3137161264. * 16384.,
    (double)72020./3137161264. * 16384.,
    (double)81700./3137161264. * 16384.,
    (double)51616./3137161264. * 16384.,
    (double)57463./3137161264. * 16384.,
    (double)69598./3137161264. * 16384.,
    (double)8674./3137161264. * 16384.,
    (double)62048./3137161264. * 16384.,
    (double)88653./3137161264. * 16384.,
    (double)64322./3137161264. * 16384.,
    (double)89593./3137161264. * 16384.,
    (double)55743./3137161264. * 16384.,
    (double)88396./3137161264. * 16384.,
    (double)68280./3137161264. * 16384.,
    (double)72342./3137161264. * 16384.,
    (double)49386./3137161264. * 16384.,
    (double)67028./3137161264. * 16384.,
    (double)5612./3137161264. * 16384.,
    (double)6882./3137161264. * 16384.,
    (double)5003./3137161264. * 16384.,
    (double)6490./3137161264. * 16384.,
    (double)59652./3137161264. * 16384.,
    (double)6813./3137161264. * 16384.,
    (double)46663./3137161264. * 16384.,
    (double)61836./3137161264. * 16384.,
    (double)52435./3137161264. * 16384.,
    (double)79251./3137161264. * 16384.,
    (double)58155./3137161264. * 16384.,
    (double)82632./3137161264. * 16384.,
    (double)77181./3137161264. * 16384.,
    (double)53177./3137161264. * 16384.,
    (double)43182./3137161264. * 16384.,
    (double)82061./3137161264. * 16384.,
    (double)69620./3137161264. * 16384.,
    (double)56308./3137161264. * 16384.,
    (double)43906./3137161264. * 16384.,
    (double)64066./3137161264. * 16384.,
    (double)81097./3137161264. * 16384.,
    (double)7247./3137161264. * 16384.,
    (double)74642./3137161264. * 16384.,
    (double)106076./3137161264. * 16384.,
    (double)100415./3137161264. * 16384.,
    (double)99734./3137161264. * 16384.,
    (double)101996./3137161264. * 16384.,
    (double)178000./3137161264. * 16384.,
    (double)177379./3137161264. * 16384.,
    (double)86422./3137161264. * 16384.,
    (double)73017./3137161264. * 16384.,
    (double)145566./3137161264. * 16384.,
    (double)82073./3137161264. * 16384.,
    (double)47847./3137161264. * 16384.,
    (double)43426./3137161264. * 16384.,
    (double)71442./3137161264. * 16384.,
    (double)76336./3137161264. * 16384.,
    (double)6226./3137161264. * 16384.,
    (double)38810./3137161264. * 16384.,
    (double)68280./3137161264. * 16384.,
    (double)103992./3137161264. * 16384.,
    (double)67834./3137161264. * 16384.,
    (double)61280./3137161264. * 16384.,
    (double)120154./3137161264. * 16384.,
    (double)92957./3137161264. * 16384.,
    (double)52490./3137161264. * 16384.,
    (double)36806./3137161264. * 16384.,
    (double)60766./3137161264. * 16384.,
    (double)53408./3137161264. * 16384.,
    (double)36849./3137161264. * 16384.,
    (double)31259./3137161264. * 16384.,
    (double)45169./3137161264. * 16384.,
    (double)54455./3137161264. * 16384.,
    (double)4149./3137161264. * 16384.,
    (double)37059./3137161264. * 16384.,
    (double)53301./3137161264. * 16384.,
    (double)52086./3137161264. * 16384.,
    (double)41322./3137161264. * 16384.,
    (double)37591./3137161264. * 16384.,
    (double)64397./3137161264. * 16384.,
    (double)69938./3137161264. * 16384.,
    (double)53983./3137161264. * 16384.,
    (double)46887./3137161264. * 16384.,
    (double)83971./3137161264. * 16384.,
    (double)4994./3137161264. * 16384.,
    (double)4210./3137161264. * 16384.,
    (double)3949./3137161264. * 16384.,
    (double)9953./3137161264. * 16384.,
    (double)45841./3137161264. * 16384.,
    (double)3866./3137161264. * 16384.,
    (double)34604./3137161264. * 16384.,
    (double)46813./3137161264. * 16384.,
    (double)43785./3137161264. * 16384.,
    (double)44043./3137161264. * 16384.,
    (double)41640./3137161264. * 16384.,
    (double)71932./3137161264. * 16384.,
    (double)98615./3137161264. * 16384.,
    (double)49772./3137161264. * 16384.,
    (double)57276./3137161264. * 16384.,
    (double)132310./3137161264. * 16384.,
    (double)65417./3137161264. * 16384.,
    (double)41696./3137161264. * 16384.,
    (double)44685./3137161264. * 16384.,
    (double)101145./3137161264. * 16384.,
    (double)64781./3137161264. * 16384.,
    (double)4608./3137161264. * 16384.,
    (double)44003./3137161264. * 16384.,
    (double)77489./3137161264. * 16384.,
    (double)99969./3137161264. * 16384.,
    (double)61085./3137161264. * 16384.,
    (double)74125./3137161264. * 16384.,
    (double)193572./3137161264. * 16384.,
    (double)140305./3137161264. * 16384.,
    (double)83348./3137161264. * 16384.,
    (double)56811./3137161264. * 16384.,
    (double)104449./3137161264. * 16384.,
    (double)85029./3137161264. * 16384.,
    (double)67322./3137161264. * 16384.,
    (double)57095./3137161264. * 16384.,
    (double)64813./3137161264. * 16384.,
    (double)71915./3137161264. * 16384.,
    (double)7131./3137161264. * 16384.,
    (double)47537./3137161264. * 16384.,
    (double)72625./3137161264. * 16384.,
    (double)78007./3137161264. * 16384.,
    (double)72615./3137161264. * 16384.,
    (double)46313./3137161264. * 16384.,
    (double)93725./3137161264. * 16384.,
    (double)100020./3137161264. * 16384.,
    (double)67270./3137161264. * 16384.,
    (double)39248./3137161264. * 16384.,
    (double)60887./3137161264. * 16384.,
    (double)77154./3137161264. * 16384.,
    (double)63291./3137161264. * 16384.,
    (double)43412./3137161264. * 16384.,
    (double)57318./3137161264. * 16384.,
    (double)69653./3137161264. * 16384.,
    (double)6669./3137161264. * 16384.,
    (double)52420./3137161264. * 16384.,
    (double)72574./3137161264. * 16384.,
    (double)65818./3137161264. * 16384.,
    (double)61111./3137161264. * 16384.,
    (double)45259./3137161264. * 16384.,
    (double)72471./3137161264. * 16384.,
    (double)66131./3137161264. * 16384.,
    (double)65327./3137161264. * 16384.,
    (double)48371./3137161264. * 16384.,
    (double)75703./3137161264. * 16384.,
    (double)5255./3137161264. * 16384.,
    (double)6383./3137161264. * 16384.,
    (double)6721./3137161264. * 16384.,
    (double)10071./3137161264. * 16384.,
    (double)63826./3137161264. * 16384.,
    (double)6344./3137161264. * 16384.,
    (double)44576./3137161264. * 16384.,
    (double)65466./3137161264. * 16384.,
    (double)55004./3137161264. * 16384.,
    (double)68472./3137161264. * 16384.,
    (double)48552./3137161264. * 16384.,
    (double)80210./3137161264. * 16384.,
    (double)80430./3137161264. * 16384.,
    (double)50555./3137161264. * 16384.,
    (double)46473./3137161264. * 16384.,
    (double)103160./3137161264. * 16384.,
    (double)81035./3137161264. * 16384.,
    (double)68794./3137161264. * 16384.,
    (double)68058./3137161264. * 16384.,
    (double)182629./3137161264. * 16384.,
    (double)67362./3137161264. * 16384.,
    (double)5292./3137161264. * 16384.,
    (double)52791./3137161264. * 16384.,
    (double)88156./3137161264. * 16384.,
    (double)76450./3137161264. * 16384.,
    (double)71402./3137161264. * 16384.,
    (double)69223./3137161264. * 16384.,
    (double)145696./3137161264. * 16384.,
    (double)94425./3137161264. * 16384.,
    (double)51069./3137161264. * 16384.,
    (double)40580./3137161264. * 16384.,
    (double)63994./3137161264. * 16384.,
    (double)71342./3137161264. * 16384.,
    (double)51785./3137161264. * 16384.,
    (double)44470./3137161264. * 16384.,
    (double)59626./3137161264. * 16384.,
    (double)68248./3137161264. * 16384.,
    (double)8080./3137161264. * 16384.,
    (double)44691./3137161264. * 16384.,
    (double)64924./3137161264. * 16384.,
    (double)60874./3137161264. * 16384.,
    (double)57211./3137161264. * 16384.,
    (double)53196./3137161264. * 16384.,
    (double)99407./3137161264. * 16384.,
    (double)5901./3137161264. * 16384.,
    (double)4700./3137161264. * 16384.,
    (double)2896./3137161264. * 16384.,
    (double)4864./3137161264. * 16384.,
    (double)4244./3137161264. * 16384.,
    (double)5760./3137161264. * 16384.,
    (double)3850./3137161264. * 16384.,
    (double)4412./3137161264. * 16384.,
    (double)4125./3137161264. * 16384.,
    (double)773./3137161264. * 16384.,
    (double)4548./3137161264. * 16384.,
    (double)5423./3137161264. * 16384.,
    (double)4701./3137161264. * 16384.,
    (double)6158./3137161264. * 16384.,
    (double)4446./3137161264. * 16384.,
    (double)7260./3137161264. * 16384.,
    (double)53595./3137161264. * 16384.,
    (double)51725./3137161264. * 16384.,
    (double)40376./3137161264. * 16384.,
    (double)56309./3137161264. * 16384.,
    (double)4043./3137161264. * 16384.,
    (double)4643./3137161264. * 16384.,
    (double)3948./3137161264. * 16384.,
    (double)6467./3137161264. * 16384.,
    (double)54153./3137161264. * 16384.,
    (double)6021./3137161264. * 16384.,
    (double)42375./3137161264. * 16384.,
    (double)56626./3137161264. * 16384.,
    (double)42074./3137161264. * 16384.,
    (double)56809./3137161264. * 16384.,
    (double)54393./3137161264. * 16384.,
    (double)75526./3137161264. * 16384.,
    (double)58451./3137161264. * 16384.,
    (double)39423./3137161264. * 16384.,
    (double)40163./3137161264. * 16384.,
    (double)61467./3137161264. * 16384.,
    (double)62386./3137161264. * 16384.,
    (double)53635./3137161264. * 16384.,
    (double)50721./3137161264. * 16384.,
    (double)80816./3137161264. * 16384.,
    (double)90721./3137161264. * 16384.,
    (double)7377./3137161264. * 16384.,
    (double)64413./3137161264. * 16384.,
    (double)104510./3137161264. * 16384.,
    (double)70550./3137161264. * 16384.,
    (double)60906./3137161264. * 16384.,
    (double)83970./3137161264. * 16384.,
    (double)132586./3137161264. * 16384.,
    (double)128217./3137161264. * 16384.,
    (double)63915./3137161264. * 16384.,
    (double)50294./3137161264. * 16384.,
    (double)93656./3137161264. * 16384.,
    (double)62210./3137161264. * 16384.,
    (double)42557./3137161264. * 16384.,
    (double)36403./3137161264. * 16384.,
    (double)48486./3137161264. * 16384.,
    (double)69776./3137161264. * 16384.,
    (double)7008./3137161264. * 16384.,
    (double)37284./3137161264. * 16384.,
    (double)63574./3137161264. * 16384.,
    (double)82608./3137161264. * 16384.,
    (double)57638./3137161264. * 16384.,
    (double)50086./3137161264. * 16384.,
    (double)123271./3137161264. * 16384.,
    (double)95904./3137161264. * 16384.,
    (double)58234./3137161264. * 16384.,
    (double)39294./3137161264. * 16384.,
    (double)62692./3137161264. * 16384.,
    (double)58204./3137161264. * 16384.,
    (double)49417./3137161264. * 16384.,
    (double)40942./3137161264. * 16384.,
    (double)52003./3137161264. * 16384.,
    (double)49984./3137161264. * 16384.,
    (double)4097./3137161264. * 16384.,
    (double)42938./3137161264. * 16384.,
    (double)64827./3137161264. * 16384.,
    (double)56966./3137161264. * 16384.,
    (double)57421./3137161264. * 16384.,
    (double)43312./3137161264. * 16384.,
    (double)95190./3137161264. * 16384.,
    (double)76005./3137161264. * 16384.,
    (double)62573./3137161264. * 16384.,
    (double)51495./3137161264. * 16384.,
    (double)89829./3137161264. * 16384.,
    (double)5013./3137161264. * 16384.,
    (double)4754./3137161264. * 16384.,
    (double)3694./3137161264. * 16384.,
    (double)7502./3137161264. * 16384.,
    (double)65596./3137161264. * 16384.,
    (double)5199./3137161264. * 16384.,
    (double)47924./3137161264. * 16384.,
    (double)72945./3137161264. * 16384.,
    (double)70588./3137161264. * 16384.,
    (double)75919./3137161264. * 16384.,
    (double)71678./3137161264. * 16384.,
    (double)110750./3137161264. * 16384.,
    (double)125079./3137161264. * 16384.,
    (double)63382./3137161264. * 16384.,
    (double)67012./3137161264. * 16384.,
    (double)135989./3137161264. * 16384.,
    (double)84373./3137161264. * 16384.,
    (double)70558./3137161264. * 16384.,
    (double)65014./3137161264. * 16384.,
    (double)115742./3137161264. * 16384.,
    (double)109821./3137161264. * 16384.,
    (double)7310./3137161264. * 16384.,
    (double)92158./3137161264. * 16384.,
    (double)148558./3137161264. * 16384.,
    (double)174437./3137161264. * 16384.,
    (double)137104./3137161264. * 16384.,
    (double)152620./3137161264. * 16384.,
    (double)241053./3137161264. * 16384.,
    (double)213843./3137161264. * 16384.,
    (double)113001./3137161264. * 16384.,
    (double)97688./3137161264. * 16384.,
    (double)180363./3137161264. * 16384.,
    (double)113640./3137161264. * 16384.,
    (double)71588./3137161264. * 16384.,
    (double)57487./3137161264. * 16384.,
    (double)82534./3137161264. * 16384.,
    (double)92416./3137161264. * 16384.,
    (double)8928./3137161264. * 16384.,
    (double)44272./3137161264. * 16384.,
    (double)81625./3137161264. * 16384.,
    (double)133115./3137161264. * 16384.,
    (double)106191./3137161264. * 16384.,
    (double)65087./3137161264. * 16384.,
    (double)122359./3137161264. * 16384.,
    (double)106955./3137161264. * 16384.,
    (double)63211./3137161264. * 16384.,
    (double)45027./3137161264. * 16384.,
    (double)67881./3137161264. * 16384.,
    (double)71581./3137161264. * 16384.,
    (double)44368./3137161264. * 16384.,
    (double)37357./3137161264. * 16384.,
    (double)50625./3137161264. * 16384.,
    (double)53495./3137161264. * 16384.,
    (double)5250./3137161264. * 16384.,
    (double)33036./3137161264. * 16384.,
    (double)42991./3137161264. * 16384.,
    (double)56119./3137161264. * 16384.,
    (double)54312./3137161264. * 16384.,
    (double)41433./3137161264. * 16384.,
    (double)66320./3137161264. * 16384.,
    (double)93042./3137161264. * 16384.,
    (double)62658./3137161264. * 16384.,
    (double)43303./3137161264. * 16384.,
    (double)85989./3137161264. * 16384.,
    (double)6711./3137161264. * 16384.,
    (double)4676./3137161264. * 16384.,
    (double)3655./3137161264. * 16384.,
    (double)9004./3137161264. * 16384.,
    (double)45005./3137161264. * 16384.,
    (double)3687./3137161264. * 16384.,
    (double)29103./3137161264. * 16384.,
    (double)46995./3137161264. * 16384.,
    (double)43361./3137161264. * 16384.,
    (double)49288./3137161264. * 16384.,
    (double)44255./3137161264. * 16384.,
    (double)66104./3137161264. * 16384.,
    (double)129410./3137161264. * 16384.,
    (double)52916./3137161264. * 16384.,
    (double)41892./3137161264. * 16384.,
    (double)91789./3137161264. * 16384.,
    (double)74763./3137161264. * 16384.,
    (double)45157./3137161264. * 16384.,
    (double)36445./3137161264. * 16384.,
    (double)64584./3137161264. * 16384.,
    (double)55667./3137161264. * 16384.,
    (double)3834./3137161264. * 16384.,
    (double)30041./3137161264. * 16384.,
    (double)50623./3137161264. * 16384.,
    (double)75654./3137161264. * 16384.,
    (double)42359./3137161264. * 16384.,
    (double)53630./3137161264. * 16384.,
    (double)116610./3137161264. * 16384.,
    (double)158452./3137161264. * 16384.,
    (double)87416./3137161264. * 16384.,
    (double)54597./3137161264. * 16384.,
    (double)100610./3137161264. * 16384.,
    (double)102096./3137161264. * 16384.,
    (double)68705./3137161264. * 16384.,
    (double)53572./3137161264. * 16384.,
    (double)63770./3137161264. * 16384.,
    (double)63202./3137161264. * 16384.,
    (double)6029./3137161264. * 16384.,
    (double)31483./3137161264. * 16384.,
    (double)51541./3137161264. * 16384.,
    (double)65922./3137161264. * 16384.,
    (double)62661./3137161264. * 16384.,
    (double)37625./3137161264. * 16384.,
    (double)75210./3137161264. * 16384.,
    (double)100982./3137161264. * 16384.,
    (double)71968./3137161264. * 16384.,
    (double)38211./3137161264. * 16384.,
    (double)56382./3137161264. * 16384.,
    (double)71426./3137161264. * 16384.,
    (double)41257./3137161264. * 16384.,
    (double)38928./3137161264. * 16384.,
    (double)46578./3137161264. * 16384.,
    (double)55821./3137161264. * 16384.,
    (double)5093./3137161264. * 16384.,
    (double)35907./3137161264. * 16384.,
    (double)50467./3137161264. * 16384.,
    (double)42963./3137161264. * 16384.,
    (double)43132./3137161264. * 16384.,
    (double)30182./3137161264. * 16384.,
    (double)48688./3137161264. * 16384.,
    (double)77912./3137161264. * 16384.,
    (double)66058./3137161264. * 16384.,
    (double)41535./3137161264. * 16384.,
    (double)63859./3137161264. * 16384.,
    (double)6543./3137161264. * 16384.,
    (double)6026./3137161264. * 16384.,
    (double)4670./3137161264. * 16384.,
    (double)7545./3137161264. * 16384.,
    (double)57964./3137161264. * 16384.,
    (double)5783./3137161264. * 16384.,
    (double)39053./3137161264. * 16384.,
    (double)72227./3137161264. * 16384.,
    (double)40708./3137161264. * 16384.,
    (double)56315./3137161264. * 16384.,
    (double)46230./3137161264. * 16384.,
    (double)65057./3137161264. * 16384.,
    (double)82578./3137161264. * 16384.,
    (double)47835./3137161264. * 16384.,
    (double)28868./3137161264. * 16384.,
    (double)57214./3137161264. * 16384.,
    (double)75137./3137161264. * 16384.,
    (double)59008./3137161264. * 16384.,
    (double)39602./3137161264. * 16384.,
    (double)64305./3137161264. * 16384.,
    (double)55119./3137161264. * 16384.,
    (double)4178./3137161264. * 16384.,
    (double)32265./3137161264. * 16384.,
    (double)58445./3137161264. * 16384.,
    (double)57184./3137161264. * 16384.,
    (double)47890./3137161264. * 16384.,
    (double)49034./3137161264. * 16384.,
    (double)102334./3137161264. * 16384.,
    (double)103266./3137161264. * 16384.,
    (double)56582./3137161264. * 16384.,
    (double)40320./3137161264. * 16384.,
    (double)73561./3137161264. * 16384.,
    (double)87900./3137161264. * 16384.,
    (double)59466./3137161264. * 16384.,
    (double)53225./3137161264. * 16384.,
    (double)67303./3137161264. * 16384.,
    (double)82093./3137161264. * 16384.,
    (double)8919./3137161264. * 16384.,
    (double)32920./3137161264. * 16384.,
    (double)50582./3137161264. * 16384.,
    (double)72011./3137161264. * 16384.,
    (double)70616./3137161264. * 16384.,
    (double)44982./3137161264. * 16384.,
    (double)88736./3137161264. * 16384.,
    (double)8386./3137161264. * 16384.,
    (double)9257./3137161264. * 16384.,
    (double)4245./3137161264. * 16384.,
    (double)6885./3137161264. * 16384.,
    (double)7747./3137161264. * 16384.,
    (double)7037./3137161264. * 16384.,
    (double)6420./3137161264. * 16384.,
    (double)7405./3137161264. * 16384.,
    (double)6839./3137161264. * 16384.,
    (double)1044./3137161264. * 16384.,
    (double)5154./3137161264. * 16384.,
    (double)6459./3137161264. * 16384.,
    (double)8676./3137161264. * 16384.,
    (double)12538./3137161264. * 16384.,
    (double)6488./3137161264. * 16384.,
    (double)10997./3137161264. * 16384.,
    (double)56460./3137161264. * 16384.,
    (double)47246./3137161264. * 16384.,
    (double)41471./3137161264. * 16384.,
    (double)54312./3137161264. * 16384.,
    (double)5611./3137161264. * 16384.,
    (double)4289./3137161264. * 16384.,
    (double)5206./3137161264. * 16384.,
    (double)6982./3137161264. * 16384.,
    (double)48884./3137161264. * 16384.,
    (double)4980./3137161264. * 16384.,
    (double)28677./3137161264. * 16384.,
    (double)40272./3137161264. * 16384.,
    (double)36749./3137161264. * 16384.,
    (double)51213./3137161264. * 16384.,
    (double)42487./3137161264. * 16384.,
    (double)53415./3137161264. * 16384.,
    (double)54394./3137161264. * 16384.,
    (double)34980./3137161264. * 16384.,
    (double)29527./3137161264. * 16384.,
    (double)49089./3137161264. * 16384.,
    (double)71306./3137161264. * 16384.,
    (double)52330./3137161264. * 16384.,
    (double)52105./3137161264. * 16384.,
    (double)65778./3137161264. * 16384.,
    (double)59611./3137161264. * 16384.,
    (double)5610./3137161264. * 16384.,
    (double)36900./3137161264. * 16384.,
    (double)61820./3137161264. * 16384.,
    (double)62462./3137161264. * 16384.,
    (double)56013./3137161264. * 16384.,
    (double)54746./3137161264. * 16384.,
    (double)94121./3137161264. * 16384.,
    (double)110720./3137161264. * 16384.,
    (double)52309./3137161264. * 16384.,
    (double)38687./3137161264. * 16384.,
    (double)81441./3137161264. * 16384.,
    (double)56375./3137161264. * 16384.,
    (double)36337./3137161264. * 16384.,
    (double)38310./3137161264. * 16384.,
    (double)45108./3137161264. * 16384.,
    (double)55257./3137161264. * 16384.,
    (double)5441./3137161264. * 16384.,
    (double)26150./3137161264. * 16384.,
    (double)41639./3137161264. * 16384.,
    (double)77312./3137161264. * 16384.,
    (double)58065./3137161264. * 16384.,
    (double)43205./3137161264. * 16384.,
    (double)93164./3137161264. * 16384.,
    (double)80150./3137161264. * 16384.,
    (double)59520./3137161264. * 16384.,
    (double)38416./3137161264. * 16384.,
    (double)56635./3137161264. * 16384.,
    (double)56971./3137161264. * 16384.,
    (double)42486./3137161264. * 16384.,
    (double)39929./3137161264. * 16384.,
    (double)48067./3137161264. * 16384.,
    (double)48011./3137161264. * 16384.,
    (double)4144./3137161264. * 16384.,
    (double)33761./3137161264. * 16384.,
    (double)48277./3137161264. * 16384.,
    (double)56207./3137161264. * 16384.,
    (double)55787./3137161264. * 16384.,
    (double)44734./3137161264. * 16384.,
    (double)72785./3137161264. * 16384.,
    (double)66584./3137161264. * 16384.,
    (double)58796./3137161264. * 16384.,
    (double)44896./3137161264. * 16384.,
    (double)69644./3137161264. * 16384.,
    (double)6144./3137161264. * 16384.,
    (double)4277./3137161264. * 16384.,
    (double)4492./3137161264. * 16384.,
    (double)7088./3137161264. * 16384.,
    (double)53100./3137161264. * 16384.,
    (double)4499./3137161264. * 16384.,
    (double)36602./3137161264. * 16384.,
    (double)55507./3137161264. * 16384.,
    (double)51749./3137161264. * 16384.,
    (double)63616./3137161264. * 16384.,
    (double)64911./3137161264. * 16384.,
    (double)81925./3137161264. * 16384.,
    (double)91359./3137161264. * 16384.,
    (double)52811./3137161264. * 16384.,
    (double)42786./3137161264. * 16384.,
    (double)87653./3137161264. * 16384.,
    (double)57988./3137161264. * 16384.,
    (double)38356./3137161264. * 16384.,
    (double)42878./3137161264. * 16384.,
    (double)65023./3137161264. * 16384.,
    (double)90856./3137161264. * 16384.,
    (double)6353./3137161264. * 16384.,
    (double)51893./3137161264. * 16384.,
    (double)91159./3137161264. * 16384.,
    (double)118826./3137161264. * 16384.,
    (double)90953./3137161264. * 16384.,
    (double)99111./3137161264. * 16384.,
    (double)192570./3137161264. * 16384.,
    (double)10855./3137161264. * 16384.,
    (double)6643./3137161264. * 16384.,
    (double)4865./3137161264. * 16384.,
    (double)7528./3137161264. * 16384.,
    (double)6740./3137161264. * 16384.,
    (double)5396./3137161264. * 16384.,
    (double)3773./3137161264. * 16384.,
    (double)5342./3137161264. * 16384.,
    (double)4748./3137161264. * 16384.,
    (double)595./3137161264. * 16384.,
    (double)2498./3137161264. * 16384.,
    (double)4781./3137161264. * 16384.,
    (double)5838./3137161264. * 16384.,
    (double)6476./3137161264. * 16384.,
    (double)3971./3137161264. * 16384.,
    (double)6636./3137161264. * 16384.,
    (double)7560./3137161264. * 16384.,
    (double)5550./3137161264. * 16384.,
    (double)5258./3137161264. * 16384.,
    (double)5309./3137161264. * 16384.,
    (double)6052./3137161264. * 16384.,
    (double)5221./3137161264. * 16384.,
    (double)4904./3137161264. * 16384.,
    (double)4933./3137161264. * 16384.,
    (double)3956./3137161264. * 16384.,
    (double)622./3137161264. * 16384.,
    (double)3244./3137161264. * 16384.,
    (double)3717./3137161264. * 16384.,
    (double)3673./3137161264. * 16384.,
    (double)4444./3137161264. * 16384.,
    (double)3567./3137161264. * 16384.,
    (double)5532./3137161264. * 16384.,
    (double)4821./3137161264. * 16384.,
    (double)4336./3137161264. * 16384.,
    (double)3113./3137161264. * 16384.,
    (double)5013./3137161264. * 16384.,
    (double)552./3137161264. * 16384.,
    (double)606./3137161264. * 16384.,
    (double)549./3137161264. * 16384.,
    (double)746./3137161264. * 16384.,
    (double)3104./3137161264. * 16384.,
    (double)412./3137161264. * 16384.,
    (double)2451./3137161264. * 16384.,
    (double)3716./3137161264. * 16384.,
    (double)2609./3137161264. * 16384.,
    (double)3647./3137161264. * 16384.,
    (double)3246./3137161264. * 16384.,
    (double)4820./3137161264. * 16384.,
    (double)6403./3137161264. * 16384.,
    (double)3296./3137161264. * 16384.,
    (double)2769./3137161264. * 16384.,
    (double)5518./3137161264. * 16384.,
    (double)5692./3137161264. * 16384.,
    (double)4947./3137161264. * 16384.,
    (double)3535./3137161264. * 16384.,
    (double)5316./3137161264. * 16384.,
    (double)3864./3137161264. * 16384.,
    (double)436./3137161264. * 16384.,
    (double)2436./3137161264. * 16384.,
    (double)4213./3137161264. * 16384.,
    (double)4717./3137161264. * 16384.,
    (double)3855./3137161264. * 16384.,
    (double)4324./3137161264. * 16384.,
    (double)9292./3137161264. * 16384.,
    (double)7867./3137161264. * 16384.,
    (double)5752./3137161264. * 16384.,
    (double)3071./3137161264. * 16384.,
    (double)4871./3137161264. * 16384.,
    (double)6510./3137161264. * 16384.,
    (double)6863./3137161264. * 16384.,
    (double)4186./3137161264. * 16384.,
    (double)4110./3137161264. * 16384.,
    (double)3625./3137161264. * 16384.,
    (double)603./3137161264. * 16384.,
    (double)2172./3137161264. * 16384.,
    (double)3060./3137161264. * 16384.,
    (double)3256./3137161264. * 16384.,
    (double)3858./3137161264. * 16384.,
    (double)2390./3137161264. * 16384.,
    (double)4317./3137161264. * 16384.,
    (double)7171./3137161264. * 16384.,
    (double)8019./3137161264. * 16384.,
    (double)3475./3137161264. * 16384.,
    (double)4168./3137161264. * 16384.,
    (double)7985./3137161264. * 16384.,
    (double)7749./3137161264. * 16384.,
    (double)5019./3137161264. * 16384.,
    (double)5330./3137161264. * 16384.,
    (double)4792./3137161264. * 16384.,
    (double)1168./3137161264. * 16384.,
    (double)3703./3137161264. * 16384.,
    (double)4283./3137161264. * 16384.,
    (double)3383./3137161264. * 16384.,
    (double)4496./3137161264. * 16384.,
    (double)2994./3137161264. * 16384.,
    (double)3981./3137161264. * 16384.,
    (double)4811./3137161264. * 16384.,
    (double)5519./3137161264. * 16384.,
    (double)3278./3137161264. * 16384.,
    (double)4303./3137161264. * 16384.,
    (double)752./3137161264. * 16384.,
    (double)1413./3137161264. * 16384.,
    (double)964./3137161264. * 16384.,
    (double)824./3137161264. * 16384.,
    (double)5413./3137161264. * 16384.,
    (double)1279./3137161264. * 16384.,
    (double)4370./3137161264. * 16384.,
    (double)7214./3137161264. * 16384.,
    (double)2782./3137161264. * 16384.,
    (double)5107./3137161264. * 16384.,
    (double)4571./3137161264. * 16384.,
    (double)5430./3137161264. * 16384.,
    (double)5107./3137161264. * 16384.,
    (double)3377./3137161264. * 16384.,
    (double)2096./3137161264. * 16384.,
    (double)3961./3137161264. * 16384.,
    (double)5322./3137161264. * 16384.,
    (double)5635./3137161264. * 16384.,
    (double)3721./3137161264. * 16384.,
    (double)4819./3137161264. * 16384.,
    (double)4098./3137161264. * 16384.,
    (double)513./3137161264. * 16384.,
    (double)2834./3137161264. * 16384.,
    (double)4971./3137161264. * 16384.,
    (double)3495./3137161264. * 16384.,
    (double)3610./3137161264. * 16384.,
    (double)3647./3137161264. * 16384.,
    (double)7182./3137161264. * 16384.,
    (double)6040./3137161264. * 16384.,
    (double)3603./3137161264. * 16384.,
    (double)2384./3137161264. * 16384.,
    (double)3821./3137161264. * 16384.,
    (double)5355./3137161264. * 16384.,
    (double)4780./3137161264. * 16384.,
    (double)4502./3137161264. * 16384.,
    (double)4279./3137161264. * 16384.,
    (double)4306./3137161264. * 16384.,
    (double)685./3137161264. * 16384.,
    (double)2699./3137161264. * 16384.,
    (double)3392./3137161264. * 16384.,
    (double)3458./3137161264. * 16384.,
    (double)4056./3137161264. * 16384.,
    (double)3012./3137161264. * 16384.,
    (double)5011./3137161264. * 16384.,
    (double)596./3137161264. * 16384.,
    (double)828./3137161264. * 16384.,
    (double)390./3137161264. * 16384.,
    (double)518./3137161264. * 16384.,
    (double)831./3137161264. * 16384.,
    (double)1260./3137161264. * 16384.,
    (double)954./3137161264. * 16384.,
    (double)703./3137161264. * 16384.,
    (double)580./3137161264. * 16384.,
    (double)393./3137161264. * 16384.,
    (double)1221./3137161264. * 16384.,
    (double)810./3137161264. * 16384.,
    (double)355./3137161264. * 16384.,
    (double)812./3137161264. * 16384.,
    (double)583./3137161264. * 16384.,
    (double)741./3137161264. * 16384.,
    (double)4682./3137161264. * 16384.,
    (double)4586./3137161264. * 16384.,
    (double)3918./3137161264. * 16384.,
    (double)5428./3137161264. * 16384.,
    (double)712./3137161264. * 16384.,
    (double)945./3137161264. * 16384.,
    (double)1168./3137161264. * 16384.,
    (double)837./3137161264. * 16384.,
    (double)4881./3137161264. * 16384.,
    (double)1124./3137161264. * 16384.,
    (double)3818./3137161264. * 16384.,
    (double)4443./3137161264. * 16384.,
    (double)2929./3137161264. * 16384.,
    (double)5209./3137161264. * 16384.,
    (double)4839./3137161264. * 16384.,
    (double)5149./3137161264. * 16384.,
    (double)4071./3137161264. * 16384.,
    (double)2653./3137161264. * 16384.,
    (double)2708./3137161264. * 16384.,
    (double)4192./3137161264. * 16384.,
    (double)5894./3137161264. * 16384.,
    (double)5732./3137161264. * 16384.,
    (double)5124./3137161264. * 16384.,
    (double)5954./3137161264. * 16384.,
    (double)5090./3137161264. * 16384.,
    (double)836./3137161264. * 16384.,
    (double)4243./3137161264. * 16384.,
    (double)8386./3137161264. * 16384.,
    (double)4335./3137161264. * 16384.,
    (double)8025./3137161264. * 16384.,
    (double)5015./3137161264. * 16384.,
    (double)8328./3137161264. * 16384.,
    (double)7035./3137161264. * 16384.,
    (double)5418./3137161264. * 16384.,
    (double)3562./3137161264. * 16384.,
    (double)5847./3137161264. * 16384.,
    (double)4629./3137161264. * 16384.,
    (double)3704./3137161264. * 16384.,
    (double)3561./3137161264. * 16384.,
    (double)3831./3137161264. * 16384.,
    (double)4203./3137161264. * 16384.,
    (double)444./3137161264. * 16384.,
    (double)2348./3137161264. * 16384.,
    (double)3354./3137161264. * 16384.,
    (double)5630./3137161264. * 16384.,
    (double)5158./3137161264. * 16384.,
    (double)4529./3137161264. * 16384.,
    (double)8044./3137161264. * 16384.,
    (double)7384./3137161264. * 16384.,
    (double)6210./3137161264. * 16384.,
    (double)4082./3137161264. * 16384.,
    (double)6075./3137161264. * 16384.,
    (double)6750./3137161264. * 16384.,
    (double)6860./3137161264. * 16384.,
    (double)5301./3137161264. * 16384.,
    (double)6721./3137161264. * 16384.,
    (double)4599./3137161264. * 16384.,
    (double)619./3137161264. * 16384.,
    (double)4250./3137161264. * 16384.,
    (double)5079./3137161264. * 16384.,
    (double)5034./3137161264. * 16384.,
    (double)6587./3137161264. * 16384.,
    (double)5259./3137161264. * 16384.,
    (double)7889./3137161264. * 16384.,
    (double)4598./3137161264. * 16384.,
    (double)4797./3137161264. * 16384.,
    (double)4101./3137161264. * 16384.,
    (double)5800./3137161264. * 16384.,
    (double)529./3137161264. * 16384.,
    (double)646./3137161264. * 16384.,
    (double)670./3137161264. * 16384.,
    (double)808./3137161264. * 16384.,
    (double)4011./3137161264. * 16384.,
    (double)589./3137161264. * 16384.,
    (double)3840./3137161264. * 16384.,
    (double)5082./3137161264. * 16384.,
    (double)3941./3137161264. * 16384.,
    (double)5415./3137161264. * 16384.,
    (double)8905./3137161264. * 16384.,
    (double)7844./3137161264. * 16384.,
    (double)6313./3137161264. * 16384.,
    (double)4367./3137161264. * 16384.,
    (double)3443./3137161264. * 16384.,
    (double)6469./3137161264. * 16384.,
    (double)4970./3137161264. * 16384.,
    (double)4385./3137161264. * 16384.,
    (double)4102./3137161264. * 16384.,
    (double)5961./3137161264. * 16384.,
    (double)6226./3137161264. * 16384.,
    (double)613./3137161264. * 16384.,
    (double)4346./3137161264. * 16384.,
    (double)7609./3137161264. * 16384.,
    (double)7444./3137161264. * 16384.,
    (double)7766./3137161264. * 16384.,
    (double)8429./3137161264. * 16384.,
    (double)15823./3137161264. * 16384.,
    (double)118431./3137161264. * 16384.,
    (double)71038./3137161264. * 16384.,
    (double)52169./3137161264. * 16384.,
    (double)91346./3137161264. * 16384.,
    (double)62552./3137161264. * 16384.,
    (double)46487./3137161264. * 16384.,
    (double)31765./3137161264. * 16384.,
    (double)48747./3137161264. * 16384.,
    (double)51321./3137161264. * 16384.,
    (double)4683./3137161264. * 16384.,
    (double)30130./3137161264. * 16384.,
    (double)43051./3137161264. * 16384.,
    (double)47621./3137161264. * 16384.,
    (double)39371./3137161264. * 16384.,
    (double)30075./3137161264. * 16384.,
    (double)54171./3137161264. * 16384.,
    (double)89943./3137161264. * 16384.,
    (double)58270./3137161264. * 16384.,
    (double)34244./3137161264. * 16384.,
    (double)50192./3137161264. * 16384.,
    (double)65027./3137161264. * 16384.,
    (double)46687./3137161264. * 16384.,
    (double)42001./3137161264. * 16384.,
    (double)43082./3137161264. * 16384.,
    (double)54660./3137161264. * 16384.,
    (double)5933./3137161264. * 16384.,
    (double)61398./3137161264. * 16384.,
    (double)52195./3137161264. * 16384.,
    (double)36838./3137161264. * 16384.,
    (double)46834./3137161264. * 16384.,
    (double)33804./3137161264. * 16384.,
    (double)51497./3137161264. * 16384.,
    (double)54265./3137161264. * 16384.,
    (double)54070./3137161264. * 16384.,
    (double)34940./3137161264. * 16384.,
    (double)55725./3137161264. * 16384.,
    (double)6423./3137161264. * 16384.,
    (double)7224./3137161264. * 16384.,
    (double)5380./3137161264. * 16384.,
    (double)10096./3137161264. * 16384.,
    (double)43270./3137161264. * 16384.,
    (double)5353./3137161264. * 16384.,
    (double)40579./3137161264. * 16384.,
    (double)46819./3137161264. * 16384.,
    (double)29885./3137161264. * 16384.,
    (double)47175./3137161264. * 16384.,
    (double)37209./3137161264. * 16384.,
    (double)56311./3137161264. * 16384.,
    (double)55896./3137161264. * 16384.,
    (double)34013./3137161264. * 16384.,
    (double)25215./3137161264. * 16384.,
    (double)51711./3137161264. * 16384.,
    (double)50380./3137161264. * 16384.,
    (double)41783./3137161264. * 16384.,
    (double)32902./3137161264. * 16384.,
    (double)55217./3137161264. * 16384.,
    (double)54854./3137161264. * 16384.,
    (double)5097./3137161264. * 16384.,
    (double)41674./3137161264. * 16384.,
    (double)66599./3137161264. * 16384.,
    (double)51981./3137161264. * 16384.,
    (double)42134./3137161264. * 16384.,
    (double)50988./3137161264. * 16384.,
    (double)111842./3137161264. * 16384.,
    (double)6818./3137161264. * 16384.,
    (double)5293./3137161264. * 16384.,
    (double)2789./3137161264. * 16384.,
    (double)4678./3137161264. * 16384.,
    (double)5196./3137161264. * 16384.,
    (double)5479./3137161264. * 16384.,
    (double)3449./3137161264. * 16384.,
    (double)4128./3137161264. * 16384.,
    (double)3173./3137161264. * 16384.,
    (double)646./3137161264. * 16384.,
    (double)2489./3137161264. * 16384.,
    (double)3461./3137161264. * 16384.,
    (double)2851./3137161264. * 16384.,
    (double)3554./3137161264. * 16384.,
    (double)2156./3137161264. * 16384.,
    (double)4165./3137161264. * 16384.,
    (double)5585./3137161264. * 16384.,
    (double)5028./3137161264. * 16384.,
    (double)2753./3137161264. * 16384.,
    (double)3060./3137161264. * 16384.,
    (double)5532./3137161264. * 16384.,
    (double)4889./3137161264. * 16384.,
    (double)3608./3137161264. * 16384.,
    (double)3624./3137161264. * 16384.,
    (double)3695./3137161264. * 16384.,
    (double)915./3137161264. * 16384.,
    (double)5270./3137161264. * 16384.,
    (double)4102./3137161264. * 16384.,
    (double)2353./3137161264. * 16384.,
    (double)3434./3137161264. * 16384.,
    (double)2362./3137161264. * 16384.,
    (double)3318./3137161264. * 16384.,
    (double)3804./3137161264. * 16384.,
    (double)5080./3137161264. * 16384.,
    (double)2950./3137161264. * 16384.,
    (double)3991./3137161264. * 16384.,
    (double)595./3137161264. * 16384.,
    (double)1161./3137161264. * 16384.,
    (double)1045./3137161264. * 16384.,
    (double)822./3137161264. * 16384.,
    (double)4315./3137161264. * 16384.,
    (double)1236./3137161264. * 16384.,
    (double)8710./3137161264. * 16384.,
    (double)8397./3137161264. * 16384.,
    (double)2494./3137161264. * 16384.,
    (double)4689./3137161264. * 16384.,
    (double)4003./3137161264. * 16384.,
    (double)4605./3137161264. * 16384.,
    (double)5868./3137161264. * 16384.,
    (double)3805./3137161264. * 16384.,
    (double)2347./3137161264. * 16384.,
    (double)5402./3137161264. * 16384.,
    (double)6296./3137161264. * 16384.,
    (double)7157./3137161264. * 16384.,
    (double)4259./3137161264. * 16384.,
    (double)6938./3137161264. * 16384.,
    (double)5157./3137161264. * 16384.,
    (double)817./3137161264. * 16384.,
    (double)4814./3137161264. * 16384.,
    (double)13382./3137161264. * 16384.,
    (double)4229./3137161264. * 16384.,
    (double)4068./3137161264. * 16384.,
    (double)4352./3137161264. * 16384.,
    (double)10051./3137161264. * 16384.,
    (double)80448./3137161264. * 16384.,
    (double)49292./3137161264. * 16384.,
    (double)34427./3137161264. * 16384.,
    (double)39366./3137161264. * 16384.,
    (double)60586./3137161264. * 16384.,
    (double)55143./3137161264. * 16384.,
    (double)54842./3137161264. * 16384.,
    (double)43779./3137161264. * 16384.,
    (double)50031./3137161264. * 16384.,
    (double)6955./3137161264. * 16384.,
    (double)41227./3137161264. * 16384.,
    (double)45853./3137161264. * 16384.,
    (double)34679./3137161264. * 16384.,
    (double)39967./3137161264. * 16384.,
    (double)40185./3137161264. * 16384.,
    (double)58361./3137161264. * 16384.,
    (double)5468./3137161264. * 16384.,
    (double)6712./3137161264. * 16384.,
    (double)3139./3137161264. * 16384.,
    (double)3581./3137161264. * 16384.,
    (double)5026./3137161264. * 16384.,
    (double)6444./3137161264. * 16384.,
    (double)5396./3137161264. * 16384.,
    (double)3662./3137161264. * 16384.,
    (double)4713./3137161264. * 16384.,
    (double)1176./3137161264. * 16384.,
    (double)5956./3137161264. * 16384.,
    (double)5093./3137161264. * 16384.,
    (double)3537./3137161264. * 16384.,
    (double)5754./3137161264. * 16384.,
    (double)5257./3137161264. * 16384.,
    (double)5159./3137161264. * 16384.,
    (double)57576./3137161264. * 16384.,
    (double)54715./3137161264. * 16384.,
    (double)43674./3137161264. * 16384.,
    (double)49659./3137161264. * 16384.,
    (double)5953./3137161264. * 16384.,
    (double)5382./3137161264. * 16384.,
    (double)6710./3137161264. * 16384.,
    (double)5832./3137161264. * 16384.,
    (double)47216./3137161264. * 16384.,
    (double)6127./3137161264. * 16384.,
    (double)19875./3137161264. * 16384.,
    (double)32000./3137161264. * 16384.,
    (double)27558./3137161264. * 16384.,
    (double)36068./3137161264. * 16384.,
    (double)38873./3137161264. * 16384.,
    (double)45178./3137161264. * 16384.,
    (double)41327./3137161264. * 16384.,
    (double)27623./3137161264. * 16384.,
    (double)24893./3137161264. * 16384.,
    (double)32080./3137161264. * 16384.,
    (double)53089./3137161264. * 16384.,
    (double)46057./3137161264. * 16384.,
    (double)39881./3137161264. * 16384.,
    (double)44398./3137161264. * 16384.,
    (double)46931./3137161264. * 16384.,
    (double)5272./3137161264. * 16384.,
    (double)47668./3137161264. * 16384.,
    (double)56947./3137161264. * 16384.,
    (double)36663./3137161264. * 16384.,
    (double)37524./3137161264. * 16384.,
    (double)51794./3137161264. * 16384.,
    (double)70528./3137161264. * 16384.,
    (double)68672./3137161264. * 16384.,
    (double)41158./3137161264. * 16384.,
    (double)29837./3137161264. * 16384.,
    (double)47886./3137161264. * 16384.,
    (double)43948./3137161264. * 16384.,
    (double)32457./3137161264. * 16384.,
    (double)26439./3137161264. * 16384.,
    (double)27864./3137161264. * 16384.,
    (double)37834./3137161264. * 16384.,
    (double)3866./3137161264. * 16384.,
    (double)26691./3137161264. * 16384.,
    (double)35816./3137161264. * 16384.,
    (double)39224./3137161264. * 16384.,
    (double)32922./3137161264. * 16384.,
    (double)27664./3137161264. * 16384.,
    (double)53264./3137161264. * 16384.,
    (double)63393./3137161264. * 16384.,
    (double)51358./3137161264. * 16384.,
    (double)31672./3137161264. * 16384.,
    (double)43401./3137161264. * 16384.,
    (double)55700./3137161264. * 16384.,
    (double)50318./3137161264. * 16384.,
    (double)36313./3137161264. * 16384.,
    (double)35434./3137161264. * 16384.,
    (double)41488./3137161264. * 16384.,
    (double)4369./3137161264. * 16384.,
    (double)45342./3137161264. * 16384.,
    (double)48779./3137161264. * 16384.,
    (double)36363./3137161264. * 16384.,
    (double)46445./3137161264. * 16384.,
    (double)39238./3137161264. * 16384.,
    (double)50844./3137161264. * 16384.,
    (double)58459./3137161264. * 16384.,
    (double)52788./3137161264. * 16384.,
    (double)42851./3137161264. * 16384.,
    (double)61254./3137161264. * 16384.,
    (double)4781./3137161264. * 16384.,
    (double)5397./3137161264. * 16384.,
    (double)4321./3137161264. * 16384.,
    (double)5789./3137161264. * 16384.,
    (double)53595./3137161264. * 16384.,
    (double)5588./3137161264. * 16384.,
    (double)55046./3137161264. * 16384.,
    (double)65137./3137161264. * 16384.,
    (double)39521./3137161264. * 16384.,
    (double)55800./3137161264. * 16384.,
    (double)52124./3137161264. * 16384.,
    (double)68239./3137161264. * 16384.,
    (double)57114./3137161264. * 16384.,
    (double)36390./3137161264. * 16384.,
    (double)29916./3137161264. * 16384.,
    (double)53167./3137161264. * 16384.,
    (double)48571./3137161264. * 16384.,
    (double)41300./3137161264. * 16384.,
    (double)33389./3137161264. * 16384.,
    (double)45640./3137161264. * 16384.,
    (double)62552./3137161264. * 16384.,
    (double)5286./3137161264. * 16384.,
    (double)61723./3137161264. * 16384.,
    (double)75521./3137161264. * 16384.,
    (double)64804./3137161264. * 16384.,
    (double)64214./3137161264. * 16384.,
    (double)69982./3137161264. * 16384.,
    (double)110049./3137161264. * 16384.,
    (double)132309./3137161264. * 16384.,
    (double)56618./3137161264. * 16384.,
    (double)43188./3137161264. * 16384.,
    (double)87692./3137161264. * 16384.,
    (double)57061./3137161264. * 16384.,
    (double)33329./3137161264. * 16384.,
    (double)29252./3137161264. * 16384.,
    (double)44677./3137161264. * 16384.,
    (double)47705./3137161264. * 16384.,
    (double)4179./3137161264. * 16384.,
    (double)22939./3137161264. * 16384.,
    (double)38467./3137161264. * 16384.,
    (double)61211./3137161264. * 16384.,
    (double)43226./3137161264. * 16384.,
    (double)33510./3137161264. * 16384.,
    (double)71280./3137161264. * 16384.,
    (double)73552./3137161264. * 16384.,
    (double)36705./3137161264. * 16384.,
    (double)25004./3137161264. * 16384.,
    (double)39427./3137161264. * 16384.,
    (double)40557./3137161264. * 16384.,
    (double)24810./3137161264. * 16384.,
    (double)22613./3137161264. * 16384.,
    (double)30627./3137161264. * 16384.,
    (double)34919./3137161264. * 16384.,
    (double)2487./3137161264. * 16384.,
    (double)25019./3137161264. * 16384.,
    (double)34071./3137161264. * 16384.,
    (double)31725./3137161264. * 16384.,
    (double)27410./3137161264. * 16384.,
    (double)23944./3137161264. * 16384.,
    (double)42983./3137161264. * 16384.,
    (double)61996./3137161264. * 16384.,
    (double)38707./3137161264. * 16384.,
    (double)25233./3137161264. * 16384.,
    (double)49784./3137161264. * 16384.,
    (double)4477./3137161264. * 16384.,
    (double)3112./3137161264. * 16384.,
    (double)2364./3137161264. * 16384.,
    (double)6174./3137161264. * 16384.,
    (double)42195./3137161264. * 16384.,
    (double)3008./3137161264. * 16384.,
    (double)25255./3137161264. * 16384.,
    (double)41751./3137161264. * 16384.,
    (double)36458./3137161264. * 16384.,
    (double)34700./3137161264. * 16384.,
    (double)31698./3137161264. * 16384.,
    (double)57426./3137161264. * 16384.,
    (double)69980./3137161264. * 16384.,
    (double)34813./3137161264. * 16384.,
    (double)28574./3137161264. * 16384.,
    (double)62188./3137161264. * 16384.,
    (double)46822./3137161264. * 16384.,
    (double)29052./3137161264. * 16384.,
    (double)25861./3137161264. * 16384.,
    (double)48501./3137161264. * 16384.,
    (double)44337./3137161264. * 16384.,
    (double)3116./3137161264. * 16384.,
    (double)25290./3137161264. * 16384.,
    (double)49121./3137161264. * 16384.,
    (double)58322./3137161264. * 16384.,
    (double)38418./3137161264. * 16384.,
    (double)43956./3137161264. * 16384.,
    (double)108997./3137161264. * 16384.,
    (double)113412./3137161264. * 16384.,
    (double)60750./3137161264. * 16384.,
    (double)36396./3137161264. * 16384.,
    (double)69778./3137161264. * 16384.,
    (double)64087./3137161264. * 16384.,
    (double)45129./3137161264. * 16384.,
    (double)35766./3137161264. * 16384.,
    (double)44561./3137161264. * 16384.,
    (double)48178./3137161264. * 16384.,
    (double)4056./3137161264. * 16384.,
    (double)27213./3137161264. * 16384.,
    (double)41848./3137161264. * 16384.,
    (double)48826./3137161264. * 16384.,
    (double)46661./3137161264. * 16384.,
    (double)27537./3137161264. * 16384.,
    (double)60036./3137161264. * 16384.,
    (double)72792./3137161264. * 16384.,
    (double)48742./3137161264. * 16384.,
    (double)25884./3137161264. * 16384.,
    (double)41658./3137161264. * 16384.,
    (double)52191./3137161264. * 16384.,
    (double)38107./3137161264. * 16384.,
    (double)30735./3137161264. * 16384.,
    (double)37965./3137161264. * 16384.,
    (double)43353./3137161264. * 16384.,
    (double)3056./3137161264. * 16384.,
    (double)31532./3137161264. * 16384.,
    (double)43203./3137161264. * 16384.,
    (double)30326./3137161264. * 16384.,
    (double)30932./3137161264. * 16384.,
    (double)23263./3137161264. * 16384.,
    (double)41440./3137161264. * 16384.,
    (double)55471./3137161264. * 16384.,
    (double)49295./3137161264. * 16384.,
    (double)28631./3137161264. * 16384.,
    (double)50059./3137161264. * 16384.,
    (double)3742./3137161264. * 16384.,
    (double)4215./3137161264. * 16384.,
    (double)2754./3137161264. * 16384.,
    (double)5145./3137161264. * 16384.,
    (double)51074./3137161264. * 16384.,
    (double)4622./3137161264. * 16384.,
    (double)38381./3137161264. * 16384.,
    (double)61898./3137161264. * 16384.,
    (double)36579./3137161264. * 16384.,
    (double)46374./3137161264. * 16384.,
    (double)37957./3137161264. * 16384.,
    (double)63295./3137161264. * 16384.,
    (double)68076./3137161264. * 16384.,
    (double)38833./3137161264. * 16384.,
    (double)28859./3137161264. * 16384.,
    (double)57697./3137161264. * 16384.,
    (double)59789./3137161264. * 16384.,
    (double)47983./3137161264. * 16384.,
    (double)37195./3137161264. * 16384.,
    (double)62440./3137161264. * 16384.,
    (double)49618./3137161264. * 16384.,
    (double)4187./3137161264. * 16384.,
    (double)35234./3137161264. * 16384.,
    (double)73624./3137161264. * 16384.,
    (double)51744./3137161264. * 16384.,
    (double)45277./3137161264. * 16384.,
    (double)44465./3137161264. * 16384.,
    (double)94831./3137161264. * 16384.,
    (double)113865./3137161264. * 16384.,
    (double)43976./3137161264. * 16384.,
    (double)34373./3137161264. * 16384.,
    (double)53936./3137161264. * 16384.,
    (double)65033./3137161264. * 16384.,
    (double)44662./3137161264. * 16384.,
    (double)42345./3137161264. * 16384.,
    (double)54223./3137161264. * 16384.,
    (double)55022./3137161264. * 16384.,
    (double)6157./3137161264. * 16384.,
    (double)32353./3137161264. * 16384.,
    (double)54167./3137161264. * 16384.,
    (double)46737./3137161264. * 16384.,
    (double)44485./3137161264. * 16384.,
    (double)43044./3137161264. * 16384.,
    (double)78379./3137161264. * 16384.,
    (double)6779./3137161264. * 16384.,
    (double)3827./3137161264. * 16384.,
    (double)2408./3137161264. * 16384.,
    (double)3908./3137161264. * 16384.,
    (double)4152./3137161264. * 16384.,
    (double)4731./3137161264. * 16384.,
    (double)3804./3137161264. * 16384.,
    (double)4118./3137161264. * 16384.,
    (double)3194./3137161264. * 16384.,
    (double)526./3137161264. * 16384.,
    (double)3227./3137161264. * 16384.,
    (double)4872./3137161264. * 16384.,
    (double)3448./3137161264. * 16384.,
    (double)4794./3137161264. * 16384.,
    (double)3603./3137161264. * 16384.,
    (double)5496./3137161264. * 16384.,
    (double)57766./3137161264. * 16384.,
    (double)49459./3137161264. * 16384.,
    (double)36107./3137161264. * 16384.,
    (double)54237./3137161264. * 16384.,
    (double)3991./3137161264. * 16384.,
    (double)3612./3137161264. * 16384.,
    (double)3255./3137161264. * 16384.,
    (double)5543./3137161264. * 16384.,
    (double)49321./3137161264. * 16384.,
    (double)4911./3137161264. * 16384.,
    (double)35939./3137161264. * 16384.,
    (double)52830./3137161264. * 16384.,
    (double)36176./3137161264. * 16384.,
    (double)46563./3137161264. * 16384.,
    (double)44168./3137161264. * 16384.,
    (double)64589./3137161264. * 16384.,
    (double)62919./3137161264. * 16384.,
    (double)36688./3137161264. * 16384.,
    (double)47085./3137161264. * 16384.,
    (double)53105./3137161264. * 16384.,
    (double)63188./3137161264. * 16384.,
    (double)46791./3137161264. * 16384.,
    (double)45099./3137161264. * 16384.,
    (double)62497./3137161264. * 16384.,
    (double)56840./3137161264. * 16384.,
    (double)5084./3137161264. * 16384.,
    (double)51306./3137161264. * 16384.,
    (double)87760./3137161264. * 16384.,
    (double)52761./3137161264. * 16384.,
    (double)46415./3137161264. * 16384.,
    (double)62286./3137161264. * 16384.,
    (double)99249./3137161264. * 16384.,
    (double)101164./3137161264. * 16384.,
    (double)42951./3137161264. * 16384.,
    (double)35034./3137161264. * 16384.,
    (double)64783./3137161264. * 16384.,
    (double)47406./3137161264. * 16384.,
    (double)29431./3137161264. * 16384.,
    (double)27627./3137161264. * 16384.,
    (double)35226./3137161264. * 16384.,
    (double)49550./3137161264. * 16384.,
    (double)4953./3137161264. * 16384.,
    (double)26938./3137161264. * 16384.,
    (double)43512./3137161264. * 16384.,
    (double)54065./3137161264. * 16384.,
    (double)37937./3137161264. * 16384.,
    (double)34375./3137161264. * 16384.,
    (double)78168./3137161264. * 16384.,
    (double)62526./3137161264. * 16384.,
    (double)35704./3137161264. * 16384.,
    (double)24943./3137161264. * 16384.,
    (double)41962./3137161264. * 16384.,
    (double)43493./3137161264. * 16384.,
    (double)32997./3137161264. * 16384.,
    (double)28432./3137161264. * 16384.,
    (double)35096./3137161264. * 16384.,
    (double)34164./3137161264. * 16384.,
    (double)2440./3137161264. * 16384.,
    (double)30600./3137161264. * 16384.,
    (double)44388./3137161264. * 16384.,
    (double)35060./3137161264. * 16384.,
    (double)33833./3137161264. * 16384.,
    (double)32801./3137161264. * 16384.,
    (double)54601./3137161264. * 16384.,
    (double)67231./3137161264. * 16384.,
    (double)54018./3137161264. * 16384.,
    (double)41801./3137161264. * 16384.,
    (double)71264./3137161264. * 16384.,
    (double)4405./3137161264. * 16384.,
    (double)3829./3137161264. * 16384.,
    (double)2793./3137161264. * 16384.,
    (double)6055./3137161264. * 16384.,
    (double)61031./3137161264. * 16384.,
    (double)4458./3137161264. * 16384.,
    (double)49654./3137161264. * 16384.,
    (double)78116./3137161264. * 16384.,
    (double)54029./3137161264. * 16384.,
    (double)57868./3137161264. * 16384.,
    (double)58175./3137161264. * 16384.,
    (double)86211./3137161264. * 16384.,
    (double)92336./3137161264. * 16384.,
    (double)46557./3137161264. * 16384.,
    (double)42737./3137161264. * 16384.,
    (double)88645./3137161264. * 16384.,
    (double)63881./3137161264. * 16384.,
    (double)49946./3137161264. * 16384.,
    (double)43563./3137161264. * 16384.,
    (double)71251./3137161264. * 16384.,
    (double)79381./3137161264. * 16384.,
    (double)5167./3137161264. * 16384.,
    (double)63887./3137161264. * 16384.,
    (double)105525./3137161264. * 16384.,
    (double)97191./3137161264. * 16384.,
    (double)76996./3137161264. * 16384.,
    (double)91534./3137161264. * 16384.,
    (double)154300./3137161264. * 16384.,
    (double)339384./3137161264. * 16384.,
    (double)122526./3137161264. * 16384.,
    (double)97028./3137161264. * 16384.,
    (double)233423./3137161264. * 16384.,
    (double)95596./3137161264. * 16384.,
    (double)53678./3137161264. * 16384.,
    (double)43639./3137161264. * 16384.,
    (double)75366./3137161264. * 16384.,
    (double)90081./3137161264. * 16384.,
    (double)7188./3137161264. * 16384.,
    (double)33806./3137161264. * 16384.,
    (double)65328./3137161264. * 16384.,
    (double)150887./3137161264. * 16384.,
    (double)111078./3137161264. * 16384.,
    (double)56385./3137161264. * 16384.,
    (double)134997./3137161264. * 16384.,
    (double)92290./3137161264. * 16384.,
    (double)45599./3137161264. * 16384.,
    (double)31142./3137161264. * 16384.,
    (double)54531./3137161264. * 16384.,
    (double)46690./3137161264. * 16384.,
    (double)25725./3137161264. * 16384.,
    (double)21420./3137161264. * 16384.,
    (double)31332./3137161264. * 16384.,
    (double)43179./3137161264. * 16384.,
    (double)2730./3137161264. * 16384.,
    (double)24076./3137161264. * 16384.,
    (double)31974./3137161264. * 16384.,
    (double)52748./3137161264. * 16384.,
    (double)45025./3137161264. * 16384.,
    (double)28971./3137161264. * 16384.,
    (double)53594./3137161264. * 16384.,
    (double)71556./3137161264. * 16384.,
    (double)43845./3137161264. * 16384.,
    (double)32259./3137161264. * 16384.,
    (double)66630./3137161264. * 16384.,
    (double)4719./3137161264. * 16384.,
    (double)3145./3137161264. * 16384.,
    (double)2456./3137161264. * 16384.,
    (double)6700./3137161264. * 16384.,
    (double)37274./3137161264. * 16384.,
    (double)2450./3137161264. * 16384.,
    (double)18474./3137161264. * 16384.,
    (double)32499./3137161264. * 16384.,
    (double)39728./3137161264. * 16384.,
    (double)38036./3137161264. * 16384.,
    (double)31503./3137161264. * 16384.,
    (double)60161./3137161264. * 16384.,
    (double)114247./3137161264. * 16384.,
    (double)50490./3137161264. * 16384.,
    (double)42697./3137161264. * 16384.,
    (double)100411./3137161264. * 16384.,
    (double)64282./3137161264. * 16384.,
    (double)37181./3137161264. * 16384.,
    (double)31900./3137161264. * 16384.,
    (double)61846./3137161264. * 16384.,
    (double)49322./3137161264. * 16384.,
    (double)3210./3137161264. * 16384.,
    (double)27429./3137161264. * 16384.,
    (double)48075./3137161264. * 16384.,
    (double)85040./3137161264. * 16384.,
    (double)49324./3137161264. * 16384.,
    (double)53012./3137161264. * 16384.,
    (double)139485./3137161264. * 16384.,
    (double)111341./3137161264. * 16384.,
    (double)48432./3137161264. * 16384.,
    (double)31776./3137161264. * 16384.,
    (double)64890./3137161264. * 16384.,
    (double)48299./3137161264. * 16384.,
    (double)26954./3137161264. * 16384.,
    (double)20794./3137161264. * 16384.,
    (double)30980./3137161264. * 16384.,
    (double)34942./3137161264. * 16384.,
    (double)2626./3137161264. * 16384.,
    (double)14380./3137161264. * 16384.,
    (double)27192./3137161264. * 16384.,
    (double)42740./3137161264. * 16384.,
    (double)31614./3137161264. * 16384.,
    (double)19653./3137161264. * 16384.,
    (double)48350./3137161264. * 16384.,
    (double)54433./3137161264. * 16384.,
    (double)28668./3137161264. * 16384.,
    (double)17134./3137161264. * 16384.,
    (double)30925./3137161264. * 16384.,
    (double)30239./3137161264. * 16384.,
    (double)16630./3137161264. * 16384.,
    (double)12955./3137161264. * 16384.,
    (double)19536./3137161264. * 16384.,
    (double)27261./3137161264. * 16384.,
    (double)1543./3137161264. * 16384.,
    (double)13120./3137161264. * 16384.,
    (double)21226./3137161264. * 16384.,
    (double)27523./3137161264. * 16384.,
    (double)20348./3137161264. * 16384.,
    (double)15814./3137161264. * 16384.,
    (double)30008./3137161264. * 16384.,
    (double)42584./3137161264. * 16384.,
    (double)28676./3137161264. * 16384.,
    (double)20278./3137161264. * 16384.,
    (double)36530./3137161264. * 16384.,
    (double)2533./3137161264. * 16384.,
    (double)1825./3137161264. * 16384.,
    (double)1461./3137161264. * 16384.,
    (double)2817./3137161264. * 16384.,
    (double)29593./3137161264. * 16384.,
    (double)1946./3137161264. * 16384.,
    (double)12389./3137161264. * 16384.,
    (double)22775./3137161264. * 16384.,
    (double)27344./3137161264. * 16384.,
    (double)25681./3137161264. * 16384.,
    (double)21018./3137161264. * 16384.,
    (double)35592./3137161264. * 16384.,
    (double)45302./3137161264. * 16384.,
    (double)24909./3137161264. * 16384.,
    (double)17063./3137161264. * 16384.,
    (double)36553./3137161264. * 16384.,
    (double)33530./3137161264. * 16384.,
    (double)22360./3137161264. * 16384.,
    (double)15423./3137161264. * 16384.,
    (double)27825./3137161264. * 16384.,
    (double)29288./3137161264. * 16384.,
    (double)1773./3137161264. * 16384.,
    (double)15156./3137161264. * 16384.,
    (double)28327./3137161264. * 16384.,
    (double)34792./3137161264. * 16384.,
    (double)25650./3137161264. * 16384.,
    (double)25986./3137161264. * 16384.,
    (double)63693./3137161264. * 16384.,
    (double)84096./3137161264. * 16384.,
    (double)34066./3137161264. * 16384.,
    (double)27750./3137161264. * 16384.,
    (double)57058./3137161264. * 16384.,
    (double)51980./3137161264. * 16384.,
    (double)27541./3137161264. * 16384.,
    (double)24577./3137161264. * 16384.,
    (double)41273./3137161264. * 16384.,
    (double)42774./3137161264. * 16384.,
    (double)4234./3137161264. * 16384.,
    (double)14856./3137161264. * 16384.,
    (double)31913./3137161264. * 16384.,
    (double)59885./3137161264. * 16384.,
    (double)44099./3137161264. * 16384.,
    (double)26399./3137161264. * 16384.,
    (double)74699./3137161264. * 16384.,
    (double)4869./3137161264. * 16384.,
    (double)3050./3137161264. * 16384.,
    (double)1940./3137161264. * 16384.,
    (double)4135./3137161264. * 16384.,
    (double)3610./3137161264. * 16384.,
    (double)2361./3137161264. * 16384.,
    (double)2122./3137161264. * 16384.,
    (double)3484./3137161264. * 16384.,
    (double)3097./3137161264. * 16384.,
    (double)241./3137161264. * 16384.,
    (double)1413./3137161264. * 16384.,
    (double)2962./3137161264. * 16384.,
    (double)6234./3137161264. * 16384.,
    (double)5716./3137161264. * 16384.,
    (double)2711./3137161264. * 16384.,
    (double)6818./3137161264. * 16384.,
    (double)36992./3137161264. * 16384.,
    (double)24423./3137161264. * 16384.,
    (double)22561./3137161264. * 16384.,
    (double)34766./3137161264. * 16384.,
    (double)2719./3137161264. * 16384.,
    (double)1624./3137161264. * 16384.,
    (double)1573./3137161264. * 16384.,
    (double)3316./3137161264. * 16384.,
    (double)25049./3137161264. * 16384.,
    (double)1866./3137161264. * 16384.,
    (double)11917./3137161264. * 16384.,
    (double)21158./3137161264. * 16384.,
    (double)27421./3137161264. * 16384.,
    (double)25810./3137161264. * 16384.,
    (double)22470./3137161264. * 16384.,
    (double)38838./3137161264. * 16384.,
    (double)41877./3137161264. * 16384.,
    (double)22696./3137161264. * 16384.,
    (double)20973./3137161264. * 16384.,
    (double)43101./3137161264. * 16384.,
    (double)40226./3137161264. * 16384.,
    (double)23829./3137161264. * 16384.,
    (double)21487./3137161264. * 16384.,
    (double)37703./3137161264. * 16384.,
    (double)33710./3137161264. * 16384.,
    (double)2426./3137161264. * 16384.,
    (double)17906./3137161264. * 16384.,
    (double)36128./3137161264. * 16384.,
    (double)44773./3137161264. * 16384.,
    (double)32317./3137161264. * 16384.,
    (double)33545./3137161264. * 16384.,
    (double)74558./3137161264. * 16384.,
    (double)119440./3137161264. * 16384.,
    (double)44402./3137161264. * 16384.,
    (double)36760./3137161264. * 16384.,
    (double)87254./3137161264. * 16384.,
    (double)46578./3137161264. * 16384.,
    (double)24469./3137161264. * 16384.,
    (double)26209./3137161264. * 16384.,
    (double)38709./3137161264. * 16384.,
    (double)50767./3137161264. * 16384.,
    (double)3868./3137161264. * 16384.,
    (double)22832./3137161264. * 16384.,
    (double)40069./3137161264. * 16384.,
    (double)89746./3137161264. * 16384.,
    (double)50429./3137161264. * 16384.,
    (double)38380./3137161264. * 16384.,
    (double)97297./3137161264. * 16384.,
    (double)60311./3137161264. * 16384.,
    (double)30999./3137161264. * 16384.,
    (double)24172./3137161264. * 16384.,
    (double)41799./3137161264. * 16384.,
    (double)33207./3137161264. * 16384.,
    (double)20342./3137161264. * 16384.,
    (double)19825./3137161264. * 16384.,
    (double)27287./3137161264. * 16384.,
    (double)33913./3137161264. * 16384.,
    (double)2025./3137161264. * 16384.,
    (double)19310./3137161264. * 16384.,
    (double)33000./3137161264. * 16384.,
    (double)50405./3137161264. * 16384.,
    (double)38742./3137161264. * 16384.,
    (double)27952./3137161264. * 16384.,
    (double)56560./3137161264. * 16384.,
    (double)47267./3137161264. * 16384.,
    (double)36121./3137161264. * 16384.,
    (double)27688./3137161264. * 16384.,
    (double)47404./3137161264. * 16384.,
    (double)3008./3137161264. * 16384.,
    (double)2118./3137161264. * 16384.,
    (double)1886./3137161264. * 16384.,
    (double)3537./3137161264. * 16384.,
    (double)33819./3137161264. * 16384.,
    (double)2140./3137161264. * 16384.,
    (double)19893./3137161264. * 16384.,
    (double)33643./3137161264. * 16384.,
    (double)39389./3137161264. * 16384.,
    (double)38379./3137161264. * 16384.,
    (double)37827./3137161264. * 16384.,
    (double)60646./3137161264. * 16384.,
    (double)84055./3137161264. * 16384.,
    (double)40520./3137161264. * 16384.,
    (double)38460./3137161264. * 16384.,
    (double)90031./3137161264. * 16384.,
    (double)49734./3137161264. * 16384.,
    (double)29473./3137161264. * 16384.,
    (double)28993./3137161264. * 16384.,
    (double)49337./3137161264. * 16384.,
    (double)63125./3137161264. * 16384.,
    (double)3553./3137161264. * 16384.,
    (double)36411./3137161264. * 16384.,
    (double)66303./3137161264. * 16384.,
    (double)109481./3137161264. * 16384.,
    (double)70771./3137161264. * 16384.,
    (double)83156./3137161264. * 16384.,
    (double)195118./3137161264. * 16384.,
    (double)112703./3137161264. * 16384.,
    (double)54817./3137161264. * 16384.,
    (double)37367./3137161264. * 16384.,
    (double)80575./3137161264. * 16384.,
    (double)50372./3137161264. * 16384.,
    (double)31121./3137161264. * 16384.,
    (double)21640./3137161264. * 16384.,
    (double)33930./3137161264. * 16384.,
    (double)37250./3137161264. * 16384.,
    (double)3132./3137161264. * 16384.,
    (double)16068./3137161264. * 16384.,
    (double)30861./3137161264. * 16384.,
    (double)51921./3137161264. * 16384.,
    (double)42240./3137161264. * 16384.,
    (double)25273./3137161264. * 16384.,
    (double)57220./3137161264. * 16384.,
    (double)56671./3137161264. * 16384.,
    (double)30437./3137161264. * 16384.,
    (double)22774./3137161264. * 16384.,
    (double)35305./3137161264. * 16384.,
    (double)34046./3137161264. * 16384.,
    (double)21648./3137161264. * 16384.,
    (double)19631./3137161264. * 16384.,
    (double)23408./3137161264. * 16384.,
    (double)25631./3137161264. * 16384.,
    (double)1823./3137161264. * 16384.,
    (double)15541./3137161264. * 16384.,
    (double)21537./3137161264. * 16384.,
    (double)24952./3137161264. * 16384.,
    (double)22538./3137161264. * 16384.,
    (double)16945./3137161264. * 16384.,
    (double)32216./3137161264. * 16384.,
    (double)35964./3137161264. * 16384.,
    (double)24320./3137161264. * 16384.,
    (double)17063./3137161264. * 16384.,
    (double)32050./3137161264. * 16384.,
    (double)2274./3137161264. * 16384.,
    (double)1805./3137161264. * 16384.,
    (double)1361./3137161264. * 16384.,
    (double)3098./3137161264. * 16384.,
    (double)20670./3137161264. * 16384.,
    (double)1537./3137161264. * 16384.,
    (double)11598./3137161264. * 16384.,
    (double)19430./3137161264. * 16384.,
    (double)20799./3137161264. * 16384.,
    (double)20664./3137161264. * 16384.,
    (double)17540./3137161264. * 16384.,
    (double)33338./3137161264. * 16384.,
    (double)44461./3137161264. * 16384.,
    (double)21974./3137161264. * 16384.,
    (double)18297./3137161264. * 16384.,
    (double)39057./3137161264. * 16384.,
    (double)33066./3137161264. * 16384.,
    (double)21697./3137161264. * 16384.,
    (double)16497./3137161264. * 16384.,
    (double)28618./3137161264. * 16384.,
    (double)23385./3137161264. * 16384.,
    (double)1690./3137161264. * 16384.,
    (double)13046./3137161264. * 16384.,
    (double)23286./3137161264. * 16384.,
    (double)33711./3137161264. * 16384.,
    (double)25231./3137161264. * 16384.,
    (double)25430./3137161264. * 16384.,
    (double)64338./3137161264. * 16384.,
    (double)71455./3137161264. * 16384.,
    (double)37505./3137161264. * 16384.,
    (double)19685./3137161264. * 16384.,
    (double)39174./3137161264. * 16384.,
    (double)37555./3137161264. * 16384.,
    (double)26638./3137161264. * 16384.,
    (double)15231./3137161264. * 16384.,
    (double)21332./3137161264. * 16384.,
    (double)22597./3137161264. * 16384.,
    (double)1858./3137161264. * 16384.,
    (double)9444./3137161264. * 16384.,
    (double)18038./3137161264. * 16384.,
    (double)27007./3137161264. * 16384.,
    (double)22588./3137161264. * 16384.,
    (double)13804./3137161264. * 16384.,
    (double)31353./3137161264. * 16384.,
    (double)39690./3137161264. * 16384.,
    (double)28700./3137161264. * 16384.,
    (double)13066./3137161264. * 16384.,
    (double)22556./3137161264. * 16384.,
    (double)30255./3137161264. * 16384.,
    (double)21876./3137161264. * 16384.,
    (double)13025./3137161264. * 16384.,
    (double)18763./3137161264. * 16384.,
    (double)19475./3137161264. * 16384.,
    (double)1698./3137161264. * 16384.,
    (double)9801./3137161264. * 16384.,
    (double)15789./3137161264. * 16384.,
    (double)19298./3137161264. * 16384.,
    (double)18553./3137161264. * 16384.,
    (double)11620./3137161264. * 16384.,
    (double)21714./3137161264. * 16384.,
    (double)29541./3137161264. * 16384.,
    (double)23206./3137161264. * 16384.,
    (double)13902./3137161264. * 16384.,
    (double)25112./3137161264. * 16384.,
    (double)1920./3137161264. * 16384.,
    (double)1781./3137161264. * 16384.,
    (double)1060./3137161264. * 16384.,
    (double)1940./3137161264. * 16384.,
    (double)22853./3137161264. * 16384.,
    (double)1862./3137161264. * 16384.,
    (double)10729./3137161264. * 16384.,
    (double)19172./3137161264. * 16384.,
    (double)18790./3137161264. * 16384.,
    (double)21427./3137161264. * 16384.,
    (double)17396./3137161264. * 16384.,
    (double)29161./3137161264. * 16384.,
    (double)28345./3137161264. * 16384.,
    (double)16938./3137161264. * 16384.,
    (double)11073./3137161264. * 16384.,
    (double)23459./3137161264. * 16384.,
    (double)23885./3137161264. * 16384.,
    (double)19648./3137161264. * 16384.,
    (double)12041./3137161264. * 16384.,
    (double)20197./3137161264. * 16384.,
    (double)19166./3137161264. * 16384.,
    (double)1300./3137161264. * 16384.,
    (double)9770./3137161264. * 16384.,
    (double)18015./3137161264. * 16384.,
    (double)22942./3137161264. * 16384.,
    (double)19753./3137161264. * 16384.,
    (double)18354./3137161264. * 16384.,
    (double)40631./3137161264. * 16384.,
    (double)49695./3137161264. * 16384.,
    (double)21922./3137161264. * 16384.,
    (double)16302./3137161264. * 16384.,
    (double)31963./3137161264. * 16384.,
    (double)29315./3137161264. * 16384.,
    (double)18844./3137161264. * 16384.,
    (double)16421./3137161264. * 16384.,
    (double)23692./3137161264. * 16384.,
    (double)23212./3137161264. * 16384.,
    (double)2365./3137161264. * 16384.,
    (double)10415./3137161264. * 16384.,
    (double)20048./3137161264. * 16384.,
    (double)27533./3137161264. * 16384.,
    (double)22424./3137161264. * 16384.,
    (double)16420./3137161264. * 16384.,
    (double)39126./3137161264. * 16384.,
    (double)2135./3137161264. * 16384.,
    (double)1552./3137161264. * 16384.,
    (double)876./3137161264. * 16384.,
    (double)1915./3137161264. * 16384.,
    (double)1627./3137161264. * 16384.,
    (double)1841./3137161264. * 16384.,
    (double)1195./3137161264. * 16384.,
    (double)1655./3137161264. * 16384.,
    (double)1182./3137161264. * 16384.,
    (double)171./3137161264. * 16384.,
    (double)919./3137161264. * 16384.,
    (double)1555./3137161264. * 16384.,
    (double)2059./3137161264. * 16384.,
    (double)2215./3137161264. * 16384.,
    (double)1233./3137161264. * 16384.,
    (double)2560./3137161264. * 16384.,
    (double)30439./3137161264. * 16384.,
    (double)22001./3137161264. * 16384.,
    (double)16128./3137161264. * 16384.,
    (double)27369./3137161264. * 16384.,
    (double)2029./3137161264. * 16384.,
    (double)1465./3137161264. * 16384.,
    (double)1371./3137161264. * 16384.,
    (double)2436./3137161264. * 16384.,
    (double)20420./3137161264. * 16384.,
    (double)1710./3137161264. * 16384.,
    (double)10385./3137161264. * 16384.,
    (double)17451./3137161264. * 16384.,
    (double)19604./3137161264. * 16384.,
    (double)21977./3137161264. * 16384.,
    (double)18448./3137161264. * 16384.,
    (double)31986./3137161264. * 16384.,
    (double)29610./3137161264. * 16384.,
    (double)16232./3137161264. * 16384.,
    (double)14389./3137161264. * 16384.,
    (double)29115./3137161264. * 16384.,
    (double)29351./3137161264. * 16384.,
    (double)20185./3137161264. * 16384.,
    (double)17874./3137161264. * 16384.,
    (double)28988./3137161264. * 16384.,
    (double)24162./3137161264. * 16384.,
    (double)1813./3137161264. * 16384.,
    (double)14678./3137161264. * 16384.,
    (double)27053./3137161264. * 16384.,
    (double)28479./3137161264. * 16384.,
    (double)24564./3137161264. * 16384.,
    (double)26030./3137161264. * 16384.,
    (double)56233./3137161264. * 16384.,
    (double)52948./3137161264. * 16384.,
    (double)24014./3137161264. * 16384.,
    (double)18821./3137161264. * 16384.,
    (double)38701./3137161264. * 16384.,
    (double)24548./3137161264. * 16384.,
    (double)15362./3137161264. * 16384.,
    (double)13482./3137161264. * 16384.,
    (double)19565./3137161264. * 16384.,
    (double)25321./3137161264. * 16384.,
    (double)1968./3137161264. * 16384.,
    (double)13087./3137161264. * 16384.,
    (double)20583./3137161264. * 16384.,
    (double)36106./3137161264. * 16384.,
    (double)25563./3137161264. * 16384.,
    (double)23222./3137161264. * 16384.,
    (double)46390./3137161264. * 16384.,
    (double)36021./3137161264. * 16384.,
    (double)22338./3137161264. * 16384.,
    (double)15812./3137161264. * 16384.,
    (double)26507./3137161264. * 16384.,
    (double)22366./3137161264. * 16384.,
    (double)18502./3137161264. * 16384.,
    (double)13767./3137161264. * 16384.,
    (double)20519./3137161264. * 16384.,
    (double)18421./3137161264. * 16384.,
    (double)1370./3137161264. * 16384.,
    (double)12629./3137161264. * 16384.,
    (double)20178./3137161264. * 16384.,
    (double)25070./3137161264. * 16384.,
    (double)25463./3137161264. * 16384.,
    (double)18487./3137161264. * 16384.,
    (double)34177./3137161264. * 16384.,
    (double)28828./3137161264. * 16384.,
    (double)26103./3137161264. * 16384.,
    (double)16408./3137161264. * 16384.,
    (double)29155./3137161264. * 16384.,
    (double)1769./3137161264. * 16384.,
    (double)1588./3137161264. * 16384.,
    (double)1097./3137161264. * 16384.,
    (double)2076./3137161264. * 16384.,
    (double)18154./3137161264. * 16384.,
    (double)1481./3137161264. * 16384.,
    (double)13757./3137161264. * 16384.,
    (double)20971./3137161264. * 16384.,
    (double)20947./3137161264. * 16384.,
    (double)21978./3137161264. * 16384.,
    (double)26416./3137161264. * 16384.,
    (double)38236./3137161264. * 16384.,
    (double)38295./3137161264. * 16384.,
    (double)20345./3137161264. * 16384.,
    (double)18708./3137161264. * 16384.,
    (double)35981./3137161264. * 16384.,
    (double)30564./3137161264. * 16384.,
    (double)20381./3137161264. * 16384.,
    (double)17301./3137161264. * 16384.,
    (double)29154./3137161264. * 16384.,
    (double)30065./3137161264. * 16384.,
    (double)1954./3137161264. * 16384.,
    (double)20576./3137161264. * 16384.,
    (double)34874./3137161264. * 16384.,
    (double)44429./3137161264. * 16384.,
    (double)37303./3137161264. * 16384.,
    (double)40470./3137161264. * 16384.,
    (double)92054./3137161264. * 16384.,
    (double)86873./3137161264. * 16384.,
    (double)45643./3137161264. * 16384.,
    (double)31087./3137161264. * 16384.,
    (double)60072./3137161264. * 16384.,
    (double)35215./3137161264. * 16384.,
    (double)23488./3137161264. * 16384.,
    (double)15070./3137161264. * 16384.,
    (double)27698./3137161264. * 16384.,
    (double)40037./3137161264. * 16384.,
    (double)2780./3137161264. * 16384.,
    (double)16759./3137161264. * 16384.,
    (double)26447./3137161264. * 16384.,
    (double)41031./3137161264. * 16384.,
    (double)28373./3137161264. * 16384.,
    (double)17091./3137161264. * 16384.,
    (double)38348./3137161264. * 16384.,
    (double)53078./3137161264. * 16384.,
    (double)31097./3137161264. * 16384.,
    (double)17474./3137161264. * 16384.,
    (double)30806./3137161264. * 16384.,
    (double)30893./3137161264. * 16384.,
    (double)19893./3137161264. * 16384.,
    (double)15200./3137161264. * 16384.,
    (double)19788./3137161264. * 16384.,
    (double)27817./3137161264. * 16384.,
    (double)2126./3137161264. * 16384.,
    (double)19938./3137161264. * 16384.,
    (double)23786./3137161264. * 16384.,
    (double)27418./3137161264. * 16384.,
    (double)27804./3137161264. * 16384.,
    (double)17742./3137161264. * 16384.,
    (double)35090./3137161264. * 16384.,
    (double)41089./3137161264. * 16384.,
    (double)31156./3137161264. * 16384.,
    (double)17543./3137161264. * 16384.,
    (double)34355./3137161264. * 16384.,
    (double)3050./3137161264. * 16384.,
    (double)2562./3137161264. * 16384.,
    (double)1651./3137161264. * 16384.,
    (double)4121./3137161264. * 16384.,
    (double)21618./3137161264. * 16384.,
    (double)1872./3137161264. * 16384.,
    (double)11861./3137161264. * 16384.,
    (double)20686./3137161264. * 16384.,
    (double)19170./3137161264. * 16384.,
    (double)25072./3137161264. * 16384.,
    (double)16732./3137161264. * 16384.,
    (double)32412./3137161264. * 16384.,
    (double)46100./3137161264. * 16384.,
    (double)23370./3137161264. * 16384.,
    (double)16402./3137161264. * 16384.,
    (double)37833./3137161264. * 16384.,
    (double)30071./3137161264. * 16384.,
    (double)21058./3137161264. * 16384.,
    (double)15781./3137161264. * 16384.,
    (double)29677./3137161264. * 16384.,
    (double)29622./3137161264. * 16384.,
    (double)2169./3137161264. * 16384.,
    (double)16289./3137161264. * 16384.,
    (double)30554./3137161264. * 16384.,
    (double)36633./3137161264. * 16384.,
    (double)27709./3137161264. * 16384.,
    (double)31032./3137161264. * 16384.,
    (double)70194./3137161264. * 16384.,
    (double)3762./3137161264. * 16384.,
    (double)2425./3137161264. * 16384.,
    (double)1313./3137161264. * 16384.,
    (double)2545./3137161264. * 16384.,
    (double)2561./3137161264. * 16384.,
    (double)1798./3137161264. * 16384.,
    (double)1020./3137161264. * 16384.,
    (double)1788./3137161264. * 16384.,
    (double)1844./3137161264. * 16384.,
    (double)171./3137161264. * 16384.,
    (double)916./3137161264. * 16384.,
    (double)1469./3137161264. * 16384.,
    (double)2032./3137161264. * 16384.,
    (double)1852./3137161264. * 16384.,
    (double)1062./3137161264. * 16384.,
    (double)2599./3137161264. * 16384.,
    (double)2544./3137161264. * 16384.,
    (double)1858./3137161264. * 16384.,
    (double)873./3137161264. * 16384.,
    (double)1483./3137161264. * 16384.,
    (double)2761./3137161264. * 16384.,
    (double)1789./3137161264. * 16384.,
    (double)926./3137161264. * 16384.,
    (double)1469./3137161264. * 16384.,
    (double)1568./3137161264. * 16384.,
    (double)193./3137161264. * 16384.,
    (double)1326./3137161264. * 16384.,
    (double)1472./3137161264. * 16384.,
    (double)1724./3137161264. * 16384.,
    (double)1794./3137161264. * 16384.,
    (double)1071./3137161264. * 16384.,
    (double)2122./3137161264. * 16384.,
    (double)2077./3137161264. * 16384.,
    (double)1660./3137161264. * 16384.,
    (double)887./3137161264. * 16384.,
    (double)1722./3137161264. * 16384.,
    (double)178./3137161264. * 16384.,
    (double)193./3137161264. * 16384.,
    (double)134./3137161264. * 16384.,
    (double)193./3137161264. * 16384.,
    (double)1604./3137161264. * 16384.,
    (double)186./3137161264. * 16384.,
    (double)1393./3137161264. * 16384.,
    (double)1890./3137161264. * 16384.,
    (double)1336./3137161264. * 16384.,
    (double)1761./3137161264. * 16384.,
    (double)1268./3137161264. * 16384.,
    (double)2179./3137161264. * 16384.,
    (double)3204./3137161264. * 16384.,
    (double)1837./3137161264. * 16384.,
    (double)1070./3137161264. * 16384.,
    (double)2922./3137161264. * 16384.,
    (double)2658./3137161264. * 16384.,
    (double)2307./3137161264. * 16384.,
    (double)1311./3137161264. * 16384.,
    (double)2665./3137161264. * 16384.,
    (double)2035./3137161264. * 16384.,
    (double)210./3137161264. * 16384.,
    (double)1173./3137161264. * 16384.,
    (double)2924./3137161264. * 16384.,
    (double)2535./3137161264. * 16384.,
    (double)2382./3137161264. * 16384.,
    (double)2130./3137161264. * 16384.,
    (double)5054./3137161264. * 16384.,
    (double)48318./3137161264. * 16384.,
    (double)24804./3137161264. * 16384.,
    (double)16559./3137161264. * 16384.,
    (double)26274./3137161264. * 16384.,
    (double)30933./3137161264. * 16384.,
    (double)23039./3137161264. * 16384.,
    (double)17355./3137161264. * 16384.,
    (double)24522./3137161264. * 16384.,
    (double)24242./3137161264. * 16384.,
    (double)2866./3137161264. * 16384.,
    (double)14318./3137161264. * 16384.,
    (double)21569./3137161264. * 16384.,
    (double)23865./3137161264. * 16384.,
    (double)23659./3137161264. * 16384.,
    (double)18569./3137161264. * 16384.,
    (double)38578./3137161264. * 16384.,
    (double)2303./3137161264. * 16384.,
    (double)1697./3137161264. * 16384.,
    (double)902./3137161264. * 16384.,
    (double)1591./3137161264. * 16384.,
    (double)1902./3137161264. * 16384.,
    (double)1567./3137161264. * 16384.,
    (double)1045./3137161264. * 16384.,
    (double)1360./3137161264. * 16384.,
    (double)1534./3137161264. * 16384.,
    (double)192./3137161264. * 16384.,
    (double)1165./3137161264. * 16384.,
    (double)1425./3137161264. * 16384.,
    (double)2102./3137161264. * 16384.,
    (double)2308./3137161264. * 16384.,
    (double)1908./3137161264. * 16384.,
    (double)2726./3137161264. * 16384.,
    (double)28100./3137161264. * 16384.,
    (double)23914./3137161264. * 16384.,
    (double)17611./3137161264. * 16384.,
    (double)27570./3137161264. * 16384.,
    (double)1862./3137161264. * 16384.,
    (double)1767./3137161264. * 16384.,
    (double)1517./3137161264. * 16384.,
    (double)2288./3137161264. * 16384.,
    (double)23835./3137161264. * 16384.,
    (double)2059./3137161264. * 16384.,
    (double)13110./3137161264. * 16384.,
    (double)18383./3137161264. * 16384.,
    (double)17036./3137161264. * 16384.,
    (double)21102./3137161264. * 16384.,
    (double)18263./3137161264. * 16384.,
    (double)26768./3137161264. * 16384.,
    (double)27759./3137161264. * 16384.,
    (double)17126./3137161264. * 16384.,
    (double)14372./3137161264. * 16384.,
    (double)23548./3137161264. * 16384.,
    (double)26095./3137161264. * 16384.,
    (double)21204./3137161264. * 16384.,
    (double)16086./3137161264. * 16384.,
    (double)23245./3137161264. * 16384.,
    (double)28502./3137161264. * 16384.,
    (double)2156./3137161264. * 16384.,
    (double)19804./3137161264. * 16384.,
    (double)28486./3137161264. * 16384.,
    (double)26636./3137161264. * 16384.,
    (double)22032./3137161264. * 16384.,
    (double)27773./3137161264. * 16384.,
    (double)47564./3137161264. * 16384.,
    (double)51171./3137161264. * 16384.,
    (double)24495./3137161264. * 16384.,
    (double)16677./3137161264. * 16384.,
    (double)32943./3137161264. * 16384.,
    (double)27862./3137161264. * 16384.,
    (double)17624./3137161264. * 16384.,
    (double)12635./3137161264. * 16384.,
    (double)20042./3137161264. * 16384.,
    (double)24850./3137161264. * 16384.,
    (double)2030./3137161264. * 16384.,
    (double)15068./3137161264. * 16384.,
    (double)22806./3137161264. * 16384.,
    (double)28557./3137161264. * 16384.,
    (double)21243./3137161264. * 16384.,
    (double)15862./3137161264. * 16384.,
    (double)38915./3137161264. * 16384.,
    (double)38498./3137161264. * 16384.,
    (double)23835./3137161264. * 16384.,
    (double)14266./3137161264. * 16384.,
    (double)24974./3137161264. * 16384.,
    (double)27862./3137161264. * 16384.,
    (double)18713./3137161264. * 16384.,
    (double)12710./3137161264. * 16384.,
    (double)16297./3137161264. * 16384.,
    (double)21251./3137161264. * 16384.,
    (double)1467./3137161264. * 16384.,
    (double)16207./3137161264. * 16384.,
    (double)22005./3137161264. * 16384.,
    (double)25207./3137161264. * 16384.,
    (double)24343./3137161264. * 16384.,
    (double)18235./3137161264. * 16384.,
    (double)33299./3137161264. * 16384.,
    (double)32544./3137161264. * 16384.,
    (double)25974./3137161264. * 16384.,
    (double)17975./3137161264. * 16384.,
    (double)32153./3137161264. * 16384.,
    (double)1824./3137161264. * 16384.,
    (double)1625./3137161264. * 16384.,
    (double)1108./3137161264. * 16384.,
    (double)2143./3137161264. * 16384.,
    (double)24975./3137161264. * 16384.,
    (double)1774./3137161264. * 16384.,
    (double)18485./3137161264. * 16384.,
    (double)25356./3137161264. * 16384.,
    (double)24942./3137161264. * 16384.,
    (double)27193./3137161264. * 16384.,
    (double)23516./3137161264. * 16384.,
    (double)37030./3137161264. * 16384.,
    (double)37830./3137161264. * 16384.,
    (double)20061./3137161264. * 16384.,
    (double)17636./3137161264. * 16384.,
    (double)31863./3137161264. * 16384.,
    (double)22966./3137161264. * 16384.,
    (double)18248./3137161264. * 16384.,
    (double)13732./3137161264. * 16384.,
    (double)21038./3137161264. * 16384.,
    (double)32895./3137161264. * 16384.,
    (double)2053./3137161264. * 16384.,
    (double)25498./3137161264. * 16384.,
    (double)34167./3137161264. * 16384.,
    (double)39109./3137161264. * 16384.,
    (double)30602./3137161264. * 16384.,
    (double)36041./3137161264. * 16384.,
    (double)64955./3137161264. * 16384.,
    (double)155377./3137161264. * 16384.,
    (double)47686./3137161264. * 16384.,
    (double)31177./3137161264. * 16384.,
    (double)74811./3137161264. * 16384.,
    (double)33944./3137161264. * 16384.,
    (double)18034./3137161264. * 16384.,
    (double)14371./3137161264. * 16384.,
    (double)26685./3137161264. * 16384.,
    (double)31261./3137161264. * 16384.,
    (double)2286./3137161264. * 16384.,
    (double)12974./3137161264. * 16384.,
    (double)24229./3137161264. * 16384.,
    (double)46042./3137161264. * 16384.,
    (double)29601./3137161264. * 16384.,
    (double)18954./3137161264. * 16384.,
    (double)50558./3137161264. * 16384.,
    (double)37917./3137161264. * 16384.,
    (double)17625./3137161264. * 16384.,
    (double)10049./3137161264. * 16384.,
    (double)19945./3137161264. * 16384.,
    (double)18535./3137161264. * 16384.,
    (double)11517./3137161264. * 16384.,
    (double)7594./3137161264. * 16384.,
    (double)12712./3137161264. * 16384.,
    (double)16451./3137161264. * 16384.,
    (double)1030./3137161264. * 16384.,
    (double)8854./3137161264. * 16384.,
    (double)14649./3137161264. * 16384.,
    (double)17746./3137161264. * 16384.,
    (double)13496./3137161264. * 16384.,
    (double)9591./3137161264. * 16384.,
    (double)21878./3137161264. * 16384.,
    (double)30892./3137161264. * 16384.,
    (double)18763./3137161264. * 16384.,
    (double)12620./3137161264. * 16384.,
    (double)29399./3137161264. * 16384.,
    (double)1650./3137161264. * 16384.,
    (double)1216./3137161264. * 16384.,
    (double)804./3137161264. * 16384.,
    (double)2576./3137161264. * 16384.,
    (double)16425./3137161264. * 16384.,
    (double)1113./3137161264. * 16384.,
    (double)8367./3137161264. * 16384.,
    (double)16417./3137161264. * 16384.,
    (double)17944./3137161264. * 16384.,
    (double)16514./3137161264. * 16384.,
    (double)13059./3137161264. * 16384.,
    (double)28360./3137161264. * 16384.,
    (double)46540./3137161264. * 16384.,
    (double)20841./3137161264. * 16384.,
    (double)17847./3137161264. * 16384.,
    (double)43462./3137161264. * 16384.,
    (double)23887./3137161264. * 16384.,
    (double)14210./3137161264. * 16384.,
    (double)12367./3137161264. * 16384.,
    (double)25972./3137161264. * 16384.,
    (double)22419./3137161264. * 16384.,
    (double)1356./3137161264. * 16384.,
    (double)11809./3137161264. * 16384.,
    (double)24339./3137161264. * 16384.,
    (double)38514./3137161264. * 16384.,
    (double)24816./3137161264. * 16384.,
    (double)25583./3137161264. * 16384.,
    (double)71725./3137161264. * 16384.,
    (double)46876./3137161264. * 16384.,
    (double)20945./3137161264. * 16384.,
    (double)12126./3137161264. * 16384.,
    (double)25248./3137161264. * 16384.,
    (double)20619./3137161264. * 16384.,
    (double)12943./3137161264. * 16384.,
    (double)8100./3137161264. * 16384.,
    (double)13354./3137161264. * 16384.,
    (double)14683./3137161264. * 16384.,
    (double)963./3137161264. * 16384.,
    (double)6929./3137161264. * 16384.,
    (double)12583./3137161264. * 16384.,
    (double)17185./3137161264. * 16384.,
    (double)13242./3137161264. * 16384.,
    (double)7986./3137161264. * 16384.,
    (double)20113./3137161264. * 16384.,
    (double)24603./3137161264. * 16384.,
    (double)14190./3137161264. * 16384.,
    (double)6499./3137161264. * 16384.,
    (double)13339./3137161264. * 16384.,
    (double)15358./3137161264. * 16384.,
    (double)12797./3137161264. * 16384.,
    (double)5308./3137161264. * 16384.,
    (double)9902./3137161264. * 16384.,
    (double)11770./3137161264. * 16384.,
    (double)682./3137161264. * 16384.,
    (double)6434./3137161264. * 16384.,
    (double)10950./3137161264. * 16384.,
    (double)11991./3137161264. * 16384.,
    (double)10037./3137161264. * 16384.,
    (double)6229./3137161264. * 16384.,
    (double)15149./3137161264. * 16384.,
    (double)18441./3137161264. * 16384.,
    (double)11784./3137161264. * 16384.,
    (double)7252./3137161264. * 16384.,
    (double)16582./3137161264. * 16384.,
    (double)891./3137161264. * 16384.,
    (double)719./3137161264. * 16384.,
    (double)386./3137161264. * 16384.,
    (double)1082./3137161264. * 16384.,
    (double)13672./3137161264. * 16384.,
    (double)773./3137161264. * 16384.,
    (double)5957./3137161264. * 16384.,
    (double)12464./3137161264. * 16384.,
    (double)13328./3137161264. * 16384.,
    (double)12033./3137161264. * 16384.,
    (double)8531./3137161264. * 16384.,
    (double)19250./3137161264. * 16384.,
    (double)21796./3137161264. * 16384.,
    (double)10988./3137161264. * 16384.,
    (double)8322./3137161264. * 16384.,
    (double)20554./3137161264. * 16384.,
    (double)14524./3137161264. * 16384.,
    (double)10574./3137161264. * 16384.,
    (double)6912./3137161264. * 16384.,
    (double)15784./3137161264. * 16384.,
    (double)14237./3137161264. * 16384.,
    (double)804./3137161264. * 16384.,
    (double)6820./3137161264. * 16384.,
    (double)14416./3137161264. * 16384.,
    (double)20163./3137161264. * 16384.,
    (double)14029./3137161264. * 16384.,
    (double)12332./3137161264. * 16384.,
    (double)34518./3137161264. * 16384.,
    (double)37146./3137161264. * 16384.,
    (double)14585./3137161264. * 16384.,
    (double)11746./3137161264. * 16384.,
    (double)19580./3137161264. * 16384.,
    (double)19654./3137161264. * 16384.,
    (double)11023./3137161264. * 16384.,
    (double)9207./3137161264. * 16384.,
    (double)17452./3137161264. * 16384.,
    (double)15563./3137161264. * 16384.,
    (double)1265./3137161264. * 16384.,
    (double)7040./3137161264. * 16384.,
    (double)13459./3137161264. * 16384.,
    (double)17673./3137161264. * 16384.,
    (double)13777./3137161264. * 16384.,
    (double)10787./3137161264. * 16384.,
    (double)26706./3137161264. * 16384.,
    (double)1249./3137161264. * 16384.,
    (double)761./3137161264. * 16384.,
    (double)414./3137161264. * 16384.,
    (double)935./3137161264. * 16384.,
    (double)762./3137161264. * 16384.,
    (double)689./3137161264. * 16384.,
    (double)451./3137161264. * 16384.,
    (double)850./3137161264. * 16384.,
    (double)593./3137161264. * 16384.,
    (double)49./3137161264. * 16384.,
    (double)363./3137161264. * 16384.,
    (double)666./3137161264. * 16384.,
    (double)1002./3137161264. * 16384.,
    (double)1020./3137161264. * 16384.,
    (double)658./3137161264. * 16384.,
    (double)1535./3137161264. * 16384.,
    (double)17715./3137161264. * 16384.,
    (double)12422./3137161264. * 16384.,
    (double)9075./3137161264. * 16384.,
    (double)17190./3137161264. * 16384.,
    (double)817./3137161264. * 16384.,
    (double)593./3137161264. * 16384.,
    (double)475./3137161264. * 16384.,
    (double)1180./3137161264. * 16384.,
    (double)12603./3137161264. * 16384.,
    (double)816./3137161264. * 16384.,
    (double)8426./3137161264. * 16384.,
    (double)11101./3137161264. * 16384.,
    (double)12482./3137161264. * 16384.,
    (double)11386./3137161264. * 16384.,
    (double)11347./3137161264. * 16384.,
    (double)19448./3137161264. * 16384.,
    (double)19991./3137161264. * 16384.,
    (double)11255./3137161264. * 16384.,
    (double)10541./3137161264. * 16384.,
    (double)17230./3137161264. * 16384.,
    (double)14746./3137161264. * 16384.,
    (double)9996./3137161264. * 16384.,
    (double)8223./3137161264. * 16384.,
    (double)15664./3137161264. * 16384.,
    (double)14977./3137161264. * 16384.,
    (double)842./3137161264. * 16384.,
    (double)9678./3137161264. * 16384.,
    (double)16893./3137161264. * 16384.,
    (double)17466./3137161264. * 16384.,
    (double)11410./3137161264. * 16384.,
    (double)15484./3137161264. * 16384.,
    (double)29198./3137161264. * 16384.,
    (double)58326./3137161264. * 16384.,
    (double)15461./3137161264. * 16384.,
    (double)10767./3137161264. * 16384.,
    (double)23956./3137161264. * 16384.,
    (double)12546./3137161264. * 16384.,
    (double)6701./3137161264. * 16384.,
    (double)5630./3137161264. * 16384.,
    (double)9451./3137161264. * 16384.,
    (double)12061./3137161264. * 16384.,
    (double)855./3137161264. * 16384.,
    (double)6081./3137161264. * 16384.,
    (double)11070./3137161264. * 16384.,
    (double)17662./3137161264. * 16384.,
    (double)10771./3137161264. * 16384.,
    (double)8205./3137161264. * 16384.,
    (double)24153./3137161264. * 16384.,
    (double)14238./3137161264. * 16384.,
    (double)6985./3137161264. * 16384.,
    (double)4303./3137161264. * 16384.,
    (double)7554./3137161264. * 16384.,
    (double)6671./3137161264. * 16384.,
    (double)4258./3137161264. * 16384.,
    (double)3656./3137161264. * 16384.,
    (double)6119./3137161264. * 16384.,
    (double)6089./3137161264. * 16384.,
    (double)328./3137161264. * 16384.,
    (double)3883./3137161264. * 16384.,
    (double)6451./3137161264. * 16384.,
    (double)7819./3137161264. * 16384.,
    (double)5878./3137161264. * 16384.,
    (double)4608./3137161264. * 16384.,
    (double)11560./3137161264. * 16384.,
    (double)11523./3137161264. * 16384.,
    (double)6758./3137161264. * 16384.,
    (double)5005./3137161264. * 16384.,
    (double)9735./3137161264. * 16384.,
    (double)381./3137161264. * 16384.,
    (double)275./3137161264. * 16384.,
    (double)194./3137161264. * 16384.,
    (double)538./3137161264. * 16384.,
    (double)7008./3137161264. * 16384.,
    (double)332./3137161264. * 16384.,
    (double)4602./3137161264. * 16384.,
    (double)7496./3137161264. * 16384.,
    (double)8063./3137161264. * 16384.,
    (double)5888./3137161264. * 16384.,
    (double)6131./3137161264. * 16384.,
    (double)11219./3137161264. * 16384.,
    (double)17271./3137161264. * 16384.,
    (double)3877./3137161264. * 16384.,
    (double)3635./3137161264. * 16384.,
    (double)7485./3137161264. * 16384.,
    (double)3704./3137161264. * 16384.,
    (double)2322./3137161264. * 16384.,
    (double)2048./3137161264. * 16384.,
    (double)3967./3137161264. * 16384.,
    (double)4262./3137161264. * 16384.,
    (double)176./3137161264. * 16384.,
    (double)2903./3137161264. * 16384.,
    (double)4799./3137161264. * 16384.,
    (double)4540./3137161264. * 16384.,
    (double)1711./3137161264. * 16384.,
    (double)2365./3137161264. * 16384.,
    (double)2664./3137161264. * 16384.
};
