from setuptools import setup, find_packages

setup(
	name = 'MicrobeCensus',
	
	version = '1.2.0',
	
	description = 'A command-line tool for estimating average genome size from shotgun sequence data',
	
	install_requires=['numpy'],
	
	license = 'GPL',
	
	url = 'https://github.com/snayfach/MicrobeCensus',
	
	author = 'Stephen Nayfach',
    
	author_email='snayfach@gmail.com',
	
	classifiers = [
		'Development Status :: 5 - Production/Stable',
		'Intended Audience :: Science/Research',
		'Topic :: Scientific/Engineering :: Bio-Informatics',
		'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)',
		'Programming Language :: Python :: 2',
		'Programming Language :: Python :: 3'],

	keywords='MicrobeCensus metagenomics genomics microbiology ecology',
	
	#include_package_data = True,
	
	#data_files=[('data', ['data/coefficients.map'])]
	
	package_data = {
        'MicrobeCensus': ['README.txt'],
        'MicrobeCensus': ['EXAMPLE.txt'],
        'MicrobeCensus': ['NORMALIZATION.txt'],
		'MicrobeCensus': ['data/*'],
		'MicrobeCensus': ['src/*'],
		'MicrobeCensus': ['example/*'],
    }
)