This folder contains the following:

### Example data files
 1. [ChuaCircuit.mat](ChuaCircuit.mat): Simulation result of
    Modelica.Electrical.Analog.Examples.ChuaCircuit from the
    [Modelica Standard Library] version 3.2 (2010-10-25, build 5) with a stop
    time of 2500 s.  This can be generated by the example in the documentation
    for
    [modelicares.exps.write_script](http://kdavies4.github.io/ModelicaRes/exps.html#modelicares.exps.write_script)().
 2. [dsin.txt](dsin.txt): Parameter input file for
    Modelica.Blocks.Continuous.PID, generated by Dymola.
 3. [load-csv.csv](load-csv.csv): Example file for
    [modelicares.util.load_csv](http://kdavies4.github.io/ModelicaRes/util.html#load_csv)();
    from http://en.wikipedia.org/wiki/Comma-separated_values#Example, accessed
    2012-10-11.
 4. [PID.mat](PID.mat): Linearization result of Modelica.Blocks.Continuous.PID.
 5. [ThreeTanks.mat](ThreeTanks.mat): Simulation result of
    Modelica.Fluid.Examples.ThreeTanks.

### IPython notebooks
 1. [tutorial.ipynb](tutorial.ipynb): Tutorial for ModelicaRes; can be viewed at
    http://nbviewer.ipython.org/github/kdavies4/ModelicaRes/blob/master/examples/tutorial.ipynb
 2. [advanced.ipynb](advanced.ipynb): Advanced topics in ModelicaRes; can be
    viewed at
    http://nbviewer.ipython.org/github/kdavies4/ModelicaRes/blob/master/examples/advanced.ipynb.

### Scripts
 1. [load-csv.py](load-csv.py): Example script for
    [modelicares.util.load_csv](http://kdavies4.github.io/ModelicaRes/util.html#load_csv)()
 2. Other \*.py files to demonstrate various plotting functions and methods
    of ModelicaRes; these are included as links in the HTML documentation.

### Folders
 1. [ChuaCircuit](ChuaCircuit):  Contains an example script to simulate
    Modelica.Electrical.Analog.Examples.ChuaCircuit with various settings and
    plot the results.
 2. [PID](PID):  Contains an example script to linearize
    Modelica.Blocks.Continuous.PID with various settings and plot the results.


[Modelica Standard Library]: https://github.com/modelica/ModelicaStandardLibrary
