import errno
import threading
import time


__all__ = [
    'PeriodicExecutor',
    'ThreadWatcher',
    ]


class PeriodicExecutor(threading.Thread):
    """Call a function in a specified number of seconds interval:

    def f(*args, **kwargs):
        print time.time()

    pt = PeriodicExecutor(30.0, f, args=[], kwargs={})
    pt.start()

    do_other_stuff ...

    pt.cancel() # stop the timer's action if it's still waiting
    """

    def __init__(self, interval, func, *args, **kwargs):
        threading.Thread.__init__(self, name = "PeriodicExecutor")
        self._interval = interval
        self._func = func
        self._args = args
        self._kwargs = kwargs
        self._finished = threading.Event()
#        self.setDaemon(True)

    def cancel(self):
        """Stop the timer if it hasn't finished yet"""
        self._finished.set()

    def run(self):
        self._finished.wait(self._interval)
        while not self._finished.isSet():
            try:
                self._func(*self._args, **self._kwargs)
            except Exception, ex:
                if ex.args[0] == errno.EPIPE:
                    self._finished.set()
                else:
                    raise ex

            self._finished.wait(self._interval)
        self._finished.set()


class ThreadWatcher(object):
    def __init__(self):
        self.quit = False


if __name__ == "__main__":
    def foo(*args, **kwargs):
        tw_inter = kwargs.get('thread_controller')
        while not tw_inter.quit:
            print '(%s) ...' % threading.current_thread().ident, tw_inter.quit
            time.sleep(1.5)

    tw = ThreadWatcher()

    def main():
        my_t = threading.Thread(target = foo, kwargs = {'thread_controller': tw})
        my_t.start()

        while not tw.quit:
            print '(%s) ...' % threading.current_thread().ident
            time.sleep(1)

    try:
        main()

    except KeyboardInterrupt:
        print 'KeyboardInterrupt'

    except SystemExit:
        print 'SystemExit'

    except Exception:
        print 'Exception'

    finally:
        tw.quit = True

