#!/usr/bin/env python
import unittest

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup


def run_setup():
    setup(
        name = "MonkeyCommons",
        version = "201205-r1",
        author = "Shuge Lee",
        author_email = "shuge.lee@gmail.com",
        url = "https://bitbucket.org/shugelee/MonkeyCommons",
        license = "BSD License",

        description = "Python common wrapper functions",

        packages = [
            "commons",
        ],
    )

def run_tests():
    tl = unittest.TestLoader()
    test_suits = tl.discover('tests')

    testRunner = unittest.TextTestRunner()
    testRunner.run(test_suits)


if __name__ == "__main__":
    import sys
    import logging

    if len(sys.argv) == 2 and sys.argv[1] == "test":
        if sys.version_info[0] == 2 and sys.version_info[1] < 7:
            msg = "\n" + "this action requires Python 2.7" + "\n"
            logging.warn(msg)
            exit(0)
        run_tests()
    else:
        run_setup()
