import errno
import threading
import time


__all__ = [
    'PeriodicExecutor',
    'ThreadWatcher',
    ]


class PeriodicExecutor(threading.Thread):
    """Call a function in a specified number of seconds interval:

    def f(*args, **kwargs):
        print time.time()

    pt = PeriodicExecutor(30.0, f, args=[], kwargs={})
    pt.start()

    do_other_stuff ...

    pt.cancel() # stop the timer's action if it's still waiting
    """

    def __init__(self, interval, func, *args, **kwargs):
        threading.Thread.__init__(self, name = "PeriodicExecutor")
        self._interval = interval
        self._func = func
        self._args = args
        self._kwargs = kwargs
        self._finished = threading.Event()
#        self.setDaemon(True)

    def cancel(self):
        """Stop the timer if it hasn't finished yet"""
        self._finished.set()

    def run(self):
        self._finished.wait(self._interval)
        while not self._finished.isSet():
            try:
                self._func(*self._args, **self._kwargs)
            except Exception, ex:
                if ex.args[0] == errno.EPIPE:
                    self._finished.set()
                else:
                    raise ex

            self._finished.wait(self._interval)
        self._finished.set()


class ThreadWatcher:
    def __init__(self):
        self.quit = False


if __name__ == "__main__":
    def foo(*args, **kwargs):
        tc = kwargs.get('thread_controller')
        while True and not tc.quit:
            print 'in sub-thread:', tc
            time.sleep(1.5)

    tw_ = ThreadWatcher()

    def main():
        t = threading.Thread(target=foo, kwargs={'thread_controller': tw_})
        t.start()

        while True:
            print 'do sth ...'
            time.sleep(1)

    try:
        main()
    except KeyboardInterrupt:
        print 'KeyboardInterrupt'
        tw_.quit = True
    except SystemExit:
        print 'SystemExit'
        tw_.quit = True
    except Exception:
        print 'Exception'
        tw_.quit = True

