__all__ = [
    "discard",
]


def discard(container, elem):
    """ Remove element elem from the set if it is present. """
    if isinstance(container, dict):
        if elem in container:
            container.pop(elem)

    elif isinstance(container, (tuple, list)):
        if elem in container:
            container.remove(elem)

    elif isinstance(container, set):
        container.discard(elem)

    else:
        raise TypeError("only accept iterable/set type")


if __name__ == "__main__":
    import doctest
    doctest.testmod()
