import os
import sqlite3


__all__ = [
    "create_tbl_by_sql",
    "umysql_rs_wrapper",
]


#def create_tbl_by_sql_path(script_path, db_datas_path, override = False):
#    script_filename = os.path.basename(script_path)
#    db_filename = script_filename.replace("create_", "").replace("_structure.sql", ".sqlite")
#    db_fullpath = os.path.join(db_datas_path, db_filename)
#
#    if os.path.exists(db_fullpath) and override:
#        os.remove(db_fullpath)
#
#    conn = sqlite3.connect(db_fullpath)
#    cur = conn.cursor()
#   
#    f = file(script_path)
#    sql = f.read()
#    f.close()
#
#    cur.executescript(sql)
#
#    cur.close()
#    conn.close()


def create_tbl_by_sql(sql, db_path, override = False):
    if os.path.exists(db_path) and override:
        os.remove(db_path)

    conn = sqlite3.connect(db_path)
    cur = conn.cursor()

    cur.executescript(sql)

    cur.close()
    conn.close()


def umysql_rs_wrapper(rs):
    """
    wrap ultramysql result set as dict
    """
    records = []

    fields = [i[0] for i in rs.fields]

    for row in rs.rows:
        record = dict(zip(fields, row))
        records.append(record)

    return records