#!/usr/bin/env python
import StringIO
import codecs
import gzip
import sys

import web


__all__ = [
    "cut",
    "strip_bom",
    "split_by_token",
]


def cut(src, start_token, end_token=None):
    """ Return sub of src from start_token to end_token.
      >>> src = "blah=foobar;"
      >>> cut(src, "blah=", ";")
      'foobar'
      >>> cut('tel:13800013800', 'tel:')
      '13800013800'
      >>> cut("X: 600", "", ": ")
      'X'
      >>> cut("X: 600", ": ")
      '600'
    """
    start_pos = src.find(start_token)
    if start_pos == -1:
        return src

    buf = src[start_pos + len(start_token):]

    if end_token:
        end_pos = buf.find(end_token)
        return buf[:end_pos]
    else:
        return buf


def strip_bom(text):
    if web.safestr(text[:3]) == codecs.BOM_UTF8:
        text = text[3:]

    return text


def gzip_decompress_string(res):
    """
    not test yet
    """
    gz = gzip.GzipFile(fileobj = StringIO.StringIO(res), mode = "r")
    return gz.read()


def split_by_token(str, token):
    """
    >>> split_by_token('uname -a', '|')
    ['uname -a']

    >>> split_by_token("file --mime-type /tmp/CFXn.jpeg | awk '{print $2}'", '|')
    ['file --mime-type /tmp/CFXn.jpeg', "awk '{print $2}'"]
    """
    buf = str[:]
    splits = []

    while buf.find(token) != -1:
        end = buf.index(token)
        s = buf[: end]
        splits.append(s.strip())
        buf = buf[end + 1:]

    splits.append(buf.strip())

    return splits


if __name__ == "__main__":
    import doctest
    doctest.testmod()
