import logging
import functools

__all__ = [
    "discard",
    "ignore_exception",
]


def discard(container, elem):
    """ Remove element elem from the set if it is present. """
    if isinstance(container, dict):
        if elem in container:
            container.pop(elem)

    elif isinstance(container, (tuple, list)):
        if elem in container:
            container.remove(elem)

    elif isinstance(container, set):
        container.discard(elem)

    else:
        raise TypeError("only accept iterable/set type")


def ignore_exception(method):
    """ skip exception and logging it in ERROR level instead of interrrupt the process,
    do not using it unless you are understand what will happend.

    Usage:
         @ignore_exception
         append_record_into_sql_storage(ip="...)
    """
    @functools.wraps(method)
    def wrapper(*args, **kwargs):
        try:
            return method(*args, **kwargs)
        except Exception:
            import traceback
            import cStringIO
            fi = cStringIO.StringIO()
            traceback.print_exc(file = fi)
            upstream_msg = fi.getvalue()
            logging.error(upstream_msg)
        return
    return wrapper


if __name__ == "__main__":
    import doctest
    doctest.testmod()
