import datetime

__all__ = [
    "DictLike",
    "TriggerLike",
]


class DictLike(object):
    def to_dict(self, *args, **kwargs):
        d =  {}
        for key, val in self.__dict__.iteritems():
            if hasattr(self, '_to_dict_filters'):
                if key in self._to_dict_filters:
                    continue

            if not key.startswith("_"):
                # fix TypeError exception cause by json module encodes data from tornado.database API
                if isinstance(val, datetime.datetime):
                    val = str(val)
                d[key] = val
        return d


class TriggerLike(object):
    def __setattr__(self, key, value):
        if hasattr(self, "_triggers") and key in self._triggers:
            for trigger in self._triggers[key]:
                if trigger.__name__.startswith("pre_"):
                    trigger(key, value)

        self.__dict__[key] = value

        if hasattr(self, "_triggers") and key in self._triggers:
            for trigger in self._triggers[key]:
                if trigger.__name__.startswith("post_"):
                    trigger(key, value)

def dictdiff(d1, d2):
    return dict(set(d2.iteritems()) - set(d1.iteritems()))


if __name__ == "__main__":
    class Foo(DictLike, TriggerLike):
        def __init__(self):
            self.name = "Yuki"
            self.age = 17

            self._to_dict_filters = ('age', )

            self._triggers = {
                "name" : [self.post_name_changed,]
            }

        def post_name_changed(self, name, new_val):
            print "post_name_changed:", name, new_val

    foo = Foo()

    t1 = foo.to_dict()
    assert t1 == {"name" : "Yuki"}

    foo.name = "Aoi Sora"
    foo.age = "1983-11-11"

    t2 = foo.to_dict()
    assert t2 == {"name" : "Aoi Sora"}

    assert dictdiff(t1, t2) == {"name" : "Aoi Sora"}